/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.basic.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.JDBCPerfTestCase;
import org.apache.derbyTesting.perf.basic.jdbc.BaseLoad100TestSetup;

public class HeapScan
extends JDBCPerfTestCase {
    PreparedStatement select = null;
    protected static String tableName = "SCANTEST";
    protected static int rowcount = 10000;

    public static Test suite() {
        int iterations = 700;
        int repeats = 4;
        TestSuite heapScan = new TestSuite("HeapScanTests");
        heapScan.addTest((Test)new HeapScan("Scan100", iterations, repeats));
        heapScan.addTest((Test)new HeapScan("Scan100GetData", iterations, repeats));
        return new BaseLoad100TestSetup((Test)heapScan, rowcount, tableName);
    }

    public HeapScan(String name, int iterations, int repeats) {
        super(name, iterations, repeats);
    }

    public void setUp() throws Exception {
        this.select = this.openDefaultConnection().prepareStatement("SELECT * FROM " + tableName);
    }

    public void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
    }

    public void Scan100() throws Exception {
        ResultSet rs = this.select.executeQuery();
        int actualCount = 0;
        while (rs.next()) {
            ++actualCount;
        }
        HeapScan.assertEquals((int)actualCount, (int)rowcount);
        rs.close();
        this.getConnection().commit();
    }

    public void Scan100GetData() throws Exception {
        ResultSet rs = this.select.executeQuery();
        int actualCount = 0;
        while (rs.next()) {
            int i1 = rs.getInt(1);
            int i2 = rs.getInt(2);
            int i3 = rs.getInt(3);
            int i4 = rs.getInt(4);
            int i5 = rs.getInt(5);
            String c6 = rs.getString(6);
            String c7 = rs.getString(7);
            String c8 = rs.getString(8);
            String c9 = rs.getString(9);
            ++actualCount;
        }
        HeapScan.assertEquals((int)actualCount, (int)rowcount);
        this.getConnection().commit();
        rs.close();
    }

    public void tearDown() throws Exception {
        this.select.close();
        this.select = null;
        super.tearDown();
    }
}

