/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.basic.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.JDBCPerfTestCase;
import org.apache.derbyTesting.perf.basic.jdbc.BaseLoad100TestSetup;

public class CountTest
extends JDBCPerfTestCase {
    PreparedStatement select = null;
    static String tableName = "COUNTTEST";
    protected static int rowcount = 10000;

    public static Test suite() {
        TestSuite suite = new TestSuite("CountTest");
        int iterations = 1200;
        int repeats = 4;
        suite.addTest((Test)new CountTest("Count100", iterations, repeats));
        return new BaseLoad100TestSetup((Test)suite, rowcount, tableName);
    }

    public CountTest(String name, int iterations, int repeats) {
        super(name, iterations, repeats);
    }

    public void setUp() throws Exception {
        this.select = this.openDefaultConnection().prepareStatement("SELECT COUNT(i1) FROM " + tableName);
    }

    public void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
    }

    public void Count100() throws Exception {
        ResultSet rs = this.select.executeQuery();
        rs.next();
        CountTest.assertEquals((int)rowcount, (int)rs.getInt(1));
        rs.close();
        this.getConnection().commit();
    }

    public void tearDown() throws Exception {
        this.select.close();
        this.select = null;
        super.tearDown();
    }
}

