/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.DropDatabaseSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public abstract class BaseTestCase
extends TestCase {
    protected static final String ERRORSTACKTRACEFILE = "error-stacktrace.out";
    protected static final String DEFAULT_DB_DIR = "system";
    protected static final String DERBY_LOG = "derby.log";
    private static final PrintStream out = System.out;
    static /* synthetic */ Class class$org$apache$derbyTesting$junit$BaseTestCase;

    private BaseTestCase() {
    }

    public BaseTestCase(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        TestConfiguration config = this.getTestConfiguration();
        boolean trace = config.doTrace();
        long startTime = 0L;
        if (trace) {
            startTime = System.currentTimeMillis();
            out.println();
            out.print(this.getName() + " ");
        }
        if (System.getSecurityManager() == null && config.defaultSecurityManagerSetup()) {
            BaseTestCase.assertSecurityManager();
        }
        try {
            super.runBare();
        }
        catch (Throwable running) {
            PrintWriter stackOut = null;
            try {
                String failPath = PrivilegedFileOpsForTests.getAbsolutePath(this.getFailureFolder());
                stackOut = new PrintWriter(PrivilegedFileOpsForTests.getFileOutputStream(new File(failPath, ERRORSTACKTRACEFILE), true));
                stackOut.println("[Error/failure logged at " + new Date() + "]");
                running.printStackTrace(stackOut);
                stackOut.println();
                File origLog = new File(DEFAULT_DB_DIR, DERBY_LOG);
                File newLog = new File(failPath, DERBY_LOG);
                PrivilegedFileOpsForTests.copy(origLog, newLog);
                String dbName = TestConfiguration.getCurrent().getDefaultDatabaseName();
                File dbDir = new File(DEFAULT_DB_DIR, dbName);
                File newDbDir = new File(failPath, dbName);
                PrivilegedFileOpsForTests.copy(dbDir, newDbDir);
            }
            catch (IOException ioe) {
                BaseTestCase.printStackTrace(ioe);
                if (stackOut != null) {
                    stackOut.println("Copying derby.log or database failed:");
                    ioe.printStackTrace(stackOut);
                    stackOut.println();
                }
            }
            finally {
                if (stackOut != null) {
                    stackOut.close();
                }
                throw running;
            }
        }
        finally {
            if (trace) {
                long timeUsed = System.currentTimeMillis() - startTime;
                out.print("used " + timeUsed + " ms ");
            }
        }
    }

    public final TestConfiguration getTestConfiguration() {
        return TestConfiguration.getCurrent();
    }

    public final File getFailureFolder() {
        return this.getTestConfiguration().getFailureFolder(this);
    }

    public static void alarm(String text) {
        out.println("ALARM: " + text);
    }

    public static void println(String text) {
        if (TestConfiguration.getCurrent().isVerbose()) {
            out.println("DEBUG: " + text);
        }
    }

    public static void traceit(String text) {
        if (TestConfiguration.getCurrent().doTrace()) {
            out.println(text);
        }
    }

    public static void printStackTrace(Throwable t) {
        while (t != null) {
            t.printStackTrace(out);
            out.flush();
            if (!(t instanceof SQLException)) break;
            t = ((SQLException)t).getNextException();
        }
    }

    protected static void setSystemProperty(final String name, final String value) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.setProperty(name, value);
                return null;
            }
        });
    }

    protected static void removeSystemProperty(final String name) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.getProperties().remove(name);
                return null;
            }
        });
    }

    protected static String getSystemProperty(final String name) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(name);
            }
        });
    }

    protected static URL getTestResource(final String name) {
        return (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return (class$org$apache$derbyTesting$junit$BaseTestCase == null ? (class$org$apache$derbyTesting$junit$BaseTestCase = BaseTestCase.class$("org.apache.derbyTesting.junit.BaseTestCase")) : class$org$apache$derbyTesting$junit$BaseTestCase).getClassLoader().getResource(name);
            }
        });
    }

    protected static InputStream openTestResource(final URL url) throws PrivilegedActionException {
        return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                return url.openStream();
            }
        });
    }

    public static void assertSecurityManager() {
        BaseTestCase.assertNotNull((String)"No SecurityManager installed", (Object)System.getSecurityManager());
    }

    public static void assertEquals(InputStream is1, InputStream is2) throws IOException {
        if (is1 == null || is2 == null) {
            BaseTestCase.assertNull((String)"InputStream is2 is null, is1 is not", (Object)is1);
            BaseTestCase.assertNull((String)"InputStream is1 is null, is2 is not", (Object)is2);
            return;
        }
        long index = 0L;
        int b1 = is1.read();
        int b2 = is2.read();
        do {
            if (b1 != b2) {
                BaseTestCase.assertEquals((String)("Streams differ at index " + index), (int)b1, (int)b2);
            }
            ++index;
            b1 = is1.read();
            b2 = is2.read();
        } while (b1 != -1 || b2 != -1);
        is1.close();
        is2.close();
    }

    public static void assertEquals(Reader r1, Reader r2) throws IOException {
        long index = 0L;
        if (r1 == null || r2 == null) {
            BaseTestCase.assertNull((String)"Reader r2 is null, r1 is not", (Object)r1);
            BaseTestCase.assertNull((String)"Reader r1 is null, r2 is not", (Object)r2);
            return;
        }
        int c1 = r1.read();
        int c2 = r2.read();
        do {
            if (c1 != c2) {
                BaseTestCase.assertEquals((String)("Streams differ at index " + index), (int)c1, (int)c2);
            }
            ++index;
            c1 = r1.read();
            c2 = r2.read();
        } while (c1 != -1 || c2 != -1);
        r1.close();
        r2.close();
    }

    public static void assertThrowableEquals(Throwable t12, Throwable t22) {
        BaseTestCase.assertNotNull((String)"Passed-in throwable t1 cannot be null to assert detailed message", (Object)t12);
        BaseTestCase.assertNotNull((String)"Passed-in throwable t2 cannot be null to assert detailed message", (Object)t22);
        BaseTestCase.assertEquals((String)"Throwable class types are different", (String)t12.getClass().getName(), (String)t22.getClass().getName());
        BaseTestCase.assertEquals((String)"Detailed messages of the throwable's are different", (String)t12.getMessage(), (String)t22.getMessage());
    }

    public static void assertEquals(final File file1, final File file2) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    BufferedInputStream f1 = new BufferedInputStream(new FileInputStream(file1));
                    BufferedInputStream f2 = new BufferedInputStream(new FileInputStream(file2));
                    BaseTestCase.assertEquals(f1, f2);
                }
                catch (FileNotFoundException e) {
                    Assert.fail((String)("FileNotFoundException in assertEquals(File,File): " + e.getMessage()));
                    e.printStackTrace();
                }
                catch (IOException e) {
                    Assert.fail((String)("IOException in assertEquals(File, File): " + e.getMessage()));
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    public void assertExecJavaCmdAsExpected(String[] expectedString, String[] cmd, int expectedExitValue) throws InterruptedException, IOException {
        Process pr = this.execJavaCmd(cmd);
        String output = this.readProcessOutput(pr);
        int exitValue = pr.exitValue();
        Assert.assertEquals((int)expectedExitValue, (int)exitValue);
        if (expectedString != null) {
            for (int i = 0; i < expectedString.length; ++i) {
                BaseTestCase.assertFalse((output.indexOf(expectedString[i]) < 0 ? 1 : 0) != 0);
            }
        }
    }

    public Process execJavaCmd(String[] cmd) throws IOException {
        int totalSize = 3 + cmd.length;
        String[] tcmd = new String[totalSize];
        tcmd[0] = BaseTestCase.getJavaExecutableName();
        tcmd[1] = "-classpath";
        tcmd[2] = BaseTestCase.getSystemProperty("java.class.path");
        System.arraycopy(cmd, 0, tcmd, 3, cmd.length);
        final String[] command = tcmd;
        Process pr = null;
        try {
            pr = (Process)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    Process result = null;
                    result = Runtime.getRuntime().exec(command);
                    return result;
                }
            });
        }
        catch (PrivilegedActionException pe) {
            Exception e = pe.getException();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (SecurityException)e;
        }
        return pr;
    }

    public static final String getJavaExecutableName() {
        String vmname = BaseTestCase.getSystemProperty("com.ibm.oti.vm.exe");
        if (vmname == null) {
            vmname = BaseTestCase.getSystemProperty("java.home") + File.separator + "bin" + File.separator + "java";
        }
        return vmname;
    }

    public String readProcessOutput(Process pr) throws InterruptedException {
        InputStream is = pr.getInputStream();
        if (is == null) {
            BaseTestCase.fail((String)"Unexpectedly receiving no text from the process");
        }
        String output = "";
        try {
            int charsRead;
            char[] ca = new char[1024];
            InputStreamReader inStream = new InputStreamReader(is);
            while ((charsRead = inStream.read(ca, 0, ca.length)) != -1) {
                output = output + new String(ca, 0, charsRead);
            }
        }
        catch (Exception e) {
            BaseTestCase.fail("Exception accessing inputstream from process", e);
        }
        pr.waitFor();
        return output;
    }

    public static void removeDirectory(String path) {
        DropDatabaseSetup.removeDirectory(path);
    }

    public static void removeDirectory(File dir) {
        DropDatabaseSetup.removeDirectory(dir);
    }

    public static void fail(String msg, Exception e) throws AssertionFailedError {
        AssertionFailedError ae = new AssertionFailedError(msg);
        ae.initCause((Throwable)e);
        throw ae;
    }
}

