/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.AdditionalDb;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.BasicSetup;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_1;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_2;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_3;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_4;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_5;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.PhaseChanger;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

class UpgradeRun {
    private static final String[] jarFiles = new String[]{"derby.jar"};
    static final AdditionalDb[] ADDITIONAL_DBS = new AdditionalDb[]{new AdditionalDb("COLLATED_DB_10_3", true), new AdditionalDb("NO_ENCRYPT_10_2", true), new AdditionalDb("ENCRYPT_10_2", true), new AdditionalDb("ROLES_10_5", false)};
    static final String oldVersionsPath = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return System.getProperty("derbyTesting.oldVersionsPath");
        }
    });
    static final String jarPath = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return System.getProperty("derbyTesting.oldReleasePath");
        }
    });

    UpgradeRun() {
    }

    private static String getTextVersion(int[] iv) {
        String version = iv[0] + "." + iv[1] + "." + iv[2] + "." + iv[3];
        return version;
    }

    public static final Test suite(final int[] version) {
        ClassLoader oldLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return UpgradeRun.createClassLoader(version);
            }
        });
        if (oldLoader == null) {
            TestSuite suite = new TestSuite("Empty: Skipped upgrade Tests (no jars) for " + UpgradeRun.getTextVersion(version));
            BaseTestCase.traceit("Empty: Skip upgrade Tests (no jars) for " + UpgradeRun.getTextVersion(version));
            return suite;
        }
        TestSuite suite = new TestSuite("Upgrade Tests from " + UpgradeRun.getTextVersion(version));
        BaseTestCase.traceit("Prepare to run upgrade tests from " + UpgradeRun.getTextVersion(version));
        for (int phase = 0; phase < UpgradeChange.PHASES.length; ++phase) {
            ClassLoader loader = null;
            switch (phase) {
                case 0: 
                case 2: 
                case 4: {
                    loader = oldLoader;
                    break;
                }
            }
            Test phaseTests = UpgradeRun.baseSuite(UpgradeRun.getTextVersion(version) + " Upgrade Phase: " + UpgradeChange.PHASES[phase] + " ", phase, version);
            PhaseChanger phaseSet = new PhaseChanger(phaseTests, phase, loader, version);
            phaseSet = UpgradeRun.handleJavaSE6(phase, version, (Test)phaseSet);
            suite.addTest((Test)phaseSet);
        }
        TestSetup setup = TestConfiguration.singleUseDatabaseDecorator((Test)suite);
        for (int i = 0; i < ADDITIONAL_DBS.length; ++i) {
            setup = UpgradeRun.ADDITIONAL_DBS[i].shutDown ? TestConfiguration.additionalDatabaseDecorator((Test)setup, UpgradeRun.ADDITIONAL_DBS[i].logicalName) : TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)setup, UpgradeRun.ADDITIONAL_DBS[i].logicalName);
        }
        Properties preReleaseUpgrade = new Properties();
        preReleaseUpgrade.setProperty("derby.database.allowPreReleaseUpgrade", "true");
        setup = new SystemPropertyTestSetup((Test)setup, preReleaseUpgrade);
        return SecurityManagerSetup.noSecurityManager((Test)setup);
    }

    private static Test baseSuite(String name, int phase, int[] version) {
        TestSuite suite = new TestSuite(name);
        int oldMajor = version[0];
        int oldMinor = version[1];
        if (phase != 4) {
            suite.addTest(BasicSetup.suite());
            if (oldMajor == 10) {
                if (oldMinor < 1) {
                    suite.addTest(Changes10_1.suite());
                }
                if (oldMinor < 2) {
                    suite.addTest(Changes10_2.suite());
                }
                if (oldMinor < 3) {
                    suite.addTest(Changes10_3.suite(phase));
                }
                if (oldMinor < 4) {
                    suite.addTest(Changes10_4.suite(phase));
                }
                if (oldMinor < 5) {
                    suite.addTest(Changes10_5.suite(phase));
                }
            }
            switch (phase) {
                case 0: {
                    break;
                }
                case 2: {
                    break;
                }
                case 1: 
                case 3: {
                    UpgradeRun.RunDataBaseMetaDataTest(suite, oldMinor);
                }
            }
        } else {
            suite.addTest((Test)new BasicSetup("noConnectionAfterHardUpgrade"));
        }
        return TestConfiguration.connectionDSDecorator((Test)suite);
    }

    private static String getOldJarLocation(int[] oldVersion) {
        if (jarPath == null || jarPath.length() == 0) {
            return null;
        }
        String version = UpgradeRun.getTextVersion(oldVersion);
        String jarLocation = jarPath + File.separator + version;
        return jarLocation;
    }

    private static String getOldJarURLLocation(int[] oldVersion) {
        String oldJarUrl = "http://svn.apache.org/repos/asf/db/derby/jars";
        String version = UpgradeRun.getTextVersion(oldVersion);
        String jarLocation = oldJarUrl + "/" + version;
        return jarLocation;
    }

    private static ClassLoader createClassLoader(int[] version) {
        URL[] url = new URL[jarFiles.length];
        String jarLocation = UpgradeRun.getOldJarLocation(version);
        if (jarLocation != null) {
            File lib = new File(jarLocation);
            if (!lib.exists()) {
                BaseTestCase.alarm("Non-existing location for jar files: '" + jarLocation + "'. Upgrade tests can NOT be run!");
                return null;
            }
            for (int i = 0; i < jarFiles.length; ++i) {
                try {
                    url[i] = new File(lib, jarFiles[i]).toURL();
                    continue;
                }
                catch (MalformedURLException e) {
                    Assert.fail((String)e.toString());
                }
            }
        } else {
            String oldURLJarLocation = UpgradeRun.getOldJarURLLocation(version);
            for (int i = 0; i < jarFiles.length; ++i) {
                try {
                    url[i] = new URL(oldURLJarLocation + "/" + jarFiles[i]);
                    Object dummy = url[i].getContent();
                    continue;
                }
                catch (MalformedURLException e) {
                    Assert.fail((String)e.toString());
                    continue;
                }
                catch (IOException e) {
                    BaseTestCase.alarm("IOException msg: '" + e.getMessage() + "'." + " Upgrade tests can NOT be run!");
                    return null;
                }
            }
        }
        return new URLClassLoader(url, null);
    }

    private static Test handleJavaSE6(int phase, int[] version, Test test) {
        boolean oldReleaseNeedsJDBC3 = false;
        switch (phase) {
            case 0: 
            case 2: {
                if (version[0] != 10 || version[1] >= 3 || version[1] >= 2 && version[2] >= 2) break;
                oldReleaseNeedsJDBC3 = true;
                break;
            }
        }
        if (oldReleaseNeedsJDBC3) {
            return TestConfiguration.forceJDBC3Embedded(test);
        }
        return test;
    }

    private static void RunDataBaseMetaDataTest(TestSuite suite, int oldMinor) {
        Method[] methods = DatabaseMetaDataTest.class.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String name;
            Method m = methods[i];
            if (m.getParameterTypes().length > 0 || !m.getReturnType().equals(Void.TYPE) || !(name = m.getName()).startsWith("test") || name.equals("testGetTablesModify") && oldMinor < 1 || name.equals("testGetTablePrivileges") && oldMinor < 2 || name.equals("testGetColumnPrivileges") && oldMinor < 2) continue;
            suite.addTest((Test)new DatabaseMetaDataTest(name));
        }
    }
}

