/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.tools.sysinfo;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBC;

public class SysinfoCPCheckTest
extends BaseJDBCTestCase {
    private static boolean isClient = true;
    private static boolean isServer = true;

    public SysinfoCPCheckTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (!Derby.hasTools()) {
            return new TestSuite("empty: no tools support");
        }
        if (!Derby.hasServer()) {
            isServer = false;
        }
        if (!Derby.hasClient()) {
            isClient = false;
        }
        TestSuite suite = new TestSuite(SysinfoCPCheckTest.class, "Sysinfo ClassPath Checker");
        return suite;
    }

    public void testClassPathChecker() throws IOException {
        String Success = "SUCCESS: All Derby related classes found in class path.";
        String thisclass = "org.apache.derbyTesting.functionTests.tests.tools.SysinfoCPCheckTest.class";
        String[][] tstargs = new String[][]{{null, "0", "Testing for presence of all Derby-related libraries; typically, only some are needed.", null}, {"a", "0", "USAGE: java org.apache.derby.tools.sysinfo -cp [ [ embedded ][ server ][ client] [ db2driver ] [ tools ] [  anyClass.class ] ]", null}, {"embedded", "6", Success, "derby.jar"}, {"server", "10", Success, "derbynet.jar"}, {"tools", "6", Success, "derbytools.jar"}, {"client", "6", Success, "derbyclient.jar"}, {thisclass, "6", Success, "SysinfoCPCheckTest"}, {"nonexist.class", "6", "    (nonexist not found.)", null}};
        PrintStream out = System.out;
        int tst = 0;
        for (tst = 0; tst < tstargs.length; ++tst) {
            ByteArrayOutputStream rawBytes = this.getOutputStream();
            PrintStream testOut = new PrintStream(rawBytes, false);
            this.setSystemOut(testOut);
            if (!this.checkClientOrServer(tstargs[tst][0])) continue;
            if (tstargs[tst][0] == null) {
                sysinfo.main((String[])new String[]{"-cp"});
            } else {
                sysinfo.main((String[])new String[]{"-cp", tstargs[tst][0]});
            }
            this.setSystemOut(out);
            rawBytes.flush();
            rawBytes.close();
            byte[] testRawBytes = rawBytes.toByteArray();
            String s = null;
            try {
                BufferedReader sysinfoOutput = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(testRawBytes)));
                if (tstargs[tst][0] == null) {
                    s = sysinfoOutput.readLine();
                    SysinfoCPCheckTest.assertEquals((String)tstargs[tst][2], (String)s);
                    while (s != null) {
                        s = sysinfoOutput.readLine();
                    }
                    continue;
                }
                if (!this.checkClientOrServer(tstargs[tst][0])) continue;
                int linenumber = Integer.parseInt(tstargs[tst][1]);
                boolean found = false;
                for (int i = 0; i < linenumber; ++i) {
                    s = sysinfoOutput.readLine();
                    if (tstargs[tst][3] == null || s.indexOf(tstargs[tst][3]) <= 0) continue;
                    found = true;
                }
                if (tstargs[tst][3] != null && !found) {
                    SysinfoCPCheckTest.fail((String)("did not find the string searched for: " + tstargs[tst][3] + " for command -cp: " + tstargs[tst][0]));
                }
                if ((s = sysinfoOutput.readLine()) == null) {
                    SysinfoCPCheckTest.fail((String)"encountered unexpected null strings");
                } else {
                    SysinfoCPCheckTest.assertEquals((String)tstargs[tst][2], (String)s);
                }
                s = sysinfoOutput.readLine();
                sysinfoOutput.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean checkClientOrServer(String kind) {
        if (kind == null) {
            return true;
        }
        if ((kind.equals("server") || kind.equals("client")) && JDBC.vmSupportsJSR169()) {
            return false;
        }
        if (kind.equals("server")) {
            return isServer;
        }
        if (kind.equals("client")) {
            return isClient;
        }
        return true;
    }

    private void setSystemOut(final PrintStream out) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.setOut(out);
                return null;
            }
        });
    }

    ByteArrayOutputStream getOutputStream() {
        return new ByteArrayOutputStream(20480);
    }
}

