/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.Derby;

public class IJRunScriptTest
extends BaseJDBCTestCase {
    public static Test suite() {
        if (Derby.hasTools()) {
            TestSuite suite = new TestSuite("IJRunScriptTest");
            suite.addTestSuite(IJRunScriptTest.class);
            return new CleanDatabaseTestSetup((Test)suite);
        }
        return new TestSuite("empty: no tools support");
    }

    public IJRunScriptTest(String name) {
        super(name);
    }

    public void testScriptExecution() throws SQLException, UnsupportedEncodingException {
        this.runTestingScript("CREATE TABLE T1(I INT);\nCREATE TABLE T2(I INT)", 0);
        Statement s = this.createStatement();
        IJRunScriptTest.assertEquals((int)2, (int)s.executeUpdate("INSERT INTO T1 VALUES 1,2"));
        IJRunScriptTest.assertEquals((int)3, (int)s.executeUpdate("INSERT INTO T2 VALUES 1,2,4"));
        this.runTestingScript("DROP TABLE T1;DROP TABLE T2", 0);
        s.close();
    }

    public void testBracketedComment() throws SQLException, UnsupportedEncodingException {
        this.runTestingScript("VALUES /* comment /* nested comment */ 5; */ 1;", 0);
        this.runTestingScript("/* just a comment */", 0);
        this.runTestingScript("/* a /* nested */ comment */", 0);
    }

    public void testEmptyScript() throws SQLException, UnsupportedEncodingException {
        this.runTestingScript("", 0);
    }

    public void testAutoCommitCommand() throws SQLException, UnsupportedEncodingException {
        Connection conn = this.getConnection();
        IJRunScriptTest.assertTrue((boolean)conn.getAutoCommit());
        this.runTestingScript("AUTOCOMMIT OFF;", 0);
        IJRunScriptTest.assertFalse((boolean)conn.isClosed());
        IJRunScriptTest.assertFalse((boolean)conn.getAutoCommit());
    }

    public void testErrorsCount() throws SQLException, UnsupportedEncodingException {
        this.runTestingScript("CREATE TAAABLE T (I INT);", 1);
        this.runTestingScript("INSERT INTO TIJ VALUES 1;", 1);
        this.runTestingScript("INSERT INTO TIJ VALUES 1;\nDELETE FROM SYS.SYSTABLES", 2);
        this.runTestingScript("INSERT INTO TIJ VALUES 1;DELETE FROM SYS.SYSTABLES", 2);
        this.runTestingScript("CREATX TABLE TIJME(I INT);CREATE TABLE TIJME(I INT);INSERT INTO TIJME VALUES 1,3,4;INSERT INTO TIJME VALUESS 1,3,4;DROP TABLE TIJME", 2);
    }

    private void runTestingScript(String script, int expectedErrorCount) throws UnsupportedEncodingException, SQLException {
        int errorCount = this.runSQLCommands(script);
        IJRunScriptTest.assertEquals((String)("Error count on " + script), (int)expectedErrorCount, (int)errorCount);
    }
}

