/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import java.util.zip.CRC32;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.util.corruptio.CorruptibleIo;

public class LogChecksumSetup {
    private CorruptibleIo cbio = CorruptibleIo.getInstance();

    LogChecksumSetup() {
    }

    void insertAndCorrupt(Connection conn, int rowCount) throws SQLException {
        PreparedStatement ps = conn.prepareStatement("INSERT INTO T1 VALUES(?,?,?)");
        Random r = new Random();
        CRC32 checksum = new CRC32();
        boolean corrupt = false;
        for (int i = 0; i < rowCount; ++i) {
            if (i == rowCount - 1) {
                this.setupLogCorruption(50, 10);
                corrupt = true;
            }
            ps.setInt(1, i);
            byte[] dataBytes = this.generateBinaryData(r, 90000, 1000 * i);
            ps.setBytes(2, dataBytes);
            checksum.update(dataBytes, 0, dataBytes.length);
            checksum.reset();
            checksum.update(dataBytes, 0, dataBytes.length);
            ps.setLong(3, checksum.getValue());
            ps.executeUpdate();
            conn.commit();
        }
    }

    void updateAndCorrupt(Connection conn, int rowCount) throws SQLException {
        PreparedStatement ps = conn.prepareStatement("update T1 SET DATA=?, DATACHECKSUM=? where ID=?");
        Random r = new Random();
        CRC32 checksum = new CRC32();
        int updateCount = 0;
        boolean corrupt = false;
        for (int i = 0; i < rowCount; ++i) {
            if (i == rowCount - 1) {
                this.setupLogCorruption(50, 10);
                corrupt = true;
            }
            byte[] dataBytes = this.generateBinaryData(r, 1234, 5000 * i);
            ps.setBytes(1, dataBytes);
            checksum.update(dataBytes, 0, dataBytes.length);
            checksum.reset();
            checksum.update(dataBytes, 0, dataBytes.length);
            ps.setLong(2, checksum.getValue());
            ps.setInt(3, i);
            updateCount += ps.executeUpdate();
            conn.commit();
        }
    }

    void verifyData(Connection conn, int expectedRowCount) throws SQLException {
        Statement s = conn.createStatement();
        CRC32 checksum = new CRC32();
        ResultSet rs = s.executeQuery("SELECT DATA , DATACHECKSUM, ID FROM T1");
        int count = 0;
        while (rs.next()) {
            byte[] dataBytes = rs.getBytes(1);
            long ckmRead = rs.getLong(2);
            int id = rs.getInt(3);
            checksum.reset();
            checksum.update(dataBytes, 0, dataBytes.length);
            if (checksum.getValue() != ckmRead) {
                this.logMessage("CHECKSUMs ARE NOT MATCHING");
                this.logMessage("ID=" + id + " Checksum From DB:" + ckmRead);
                this.logMessage("Recalcaulted sum :" + checksum.getValue());
                this.logMessage("Length of Data:" + dataBytes.length);
            }
            ++count;
        }
        conn.commit();
        if (count != expectedRowCount) {
            this.logMessage("Expected Number Of Rows (" + expectedRowCount + ")" + "!=" + "No Of rows in the Table(" + count + ")");
        }
    }

    private void createTable(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.executeUpdate("CREATE TABLE T1(ID INT,DATA BLOB(300000),DATACHECKSUM BIGINT)");
        conn.commit();
        s.close();
    }

    private void setupLogCorruption(int off, int len) {
        this.cbio.setLogCorruption(true);
        this.cbio.setOffset(off);
        this.cbio.setLength(len);
    }

    private byte[] generateBinaryData(Random r, int factor, int size) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(64);
        try {
            DataOutputStream daos = new DataOutputStream(baos);
            for (int i = 0; i < size; ++i) {
                int p = r.nextInt() % factor;
                if (p < 0) {
                    p *= -1;
                }
                daos.writeInt(p);
            }
        }
        catch (IOException ie) {
            this.logMessage(ie.getMessage());
        }
        return baos.toByteArray();
    }

    private void runTest(Connection conn) throws SQLException {
        this.logMessage("Begin LogCheckum Setup Test");
        this.createTable(conn);
        this.insertAndCorrupt(conn, 11);
        this.logMessage("End LogChecksum Setup Test");
    }

    void logMessage(String str) {
        System.out.println(str);
    }

    public static void main(String[] argv) throws Throwable {
        LogChecksumSetup lctest = new LogChecksumSetup();
        ij.getPropertyArg((String[])argv);
        Connection conn = ij.startJBMS();
        conn.setAutoCommit(false);
        try {
            lctest.runTest(conn);
        }
        catch (SQLException sqle) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sqle);
            sqle.printStackTrace(System.out);
        }
    }
}

