/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SimplePerfTest
extends BaseJDBCTestCase {
    private static int tuplesToInsert = 0;
    private static int commitFreq = 0;

    public SimplePerfTest(String testcaseName) {
        super(testcaseName);
    }

    public static Test suite() throws Exception {
        System.out.println("**** SimplePerfTest.suite()");
        String masterHostName = System.getProperty("test.serverHost", "localhost");
        int masterPortNo = Integer.parseInt(System.getProperty("test.serverPort", "1527"));
        TestSuite suite = new TestSuite("SimplePerfTest");
        tuplesToInsert = Integer.parseInt(System.getProperty("test.inserts", "1000"));
        commitFreq = Integer.parseInt(System.getProperty("test.commitFreq", "0"));
        suite.addTest(SimplePerfTest.suite(masterHostName, masterPortNo));
        System.out.println("*** Done suite.addTest(SimplePerfTest.suite())");
        return suite;
    }

    public static Test suite(String serverHost, int serverPort) {
        System.out.println("*** SimplePerfTest.suite(serverHost,serverPort)");
        Test t = TestConfiguration.existingServerSuite(SimplePerfTest.class, false, serverHost, serverPort);
        System.out.println("*** Done TestConfiguration.existingServerSuite(SimplePerfTest.class,false,serverHost,serverPort)");
        return t;
    }

    public void testInserts() throws SQLException, IOException, InterruptedException {
        System.out.println("**** SimplePerfTest.testInserts() " + this.getTestConfiguration().getJDBCClient().getJDBCDriverName());
        Connection conn = this.getConnection();
        Statement s = conn.createStatement();
        s.executeUpdate("create table t (i integer primary key, vc varchar(20))");
        PreparedStatement pSt = this.prepareStatement("insert into t values (?,?)");
        conn.setAutoCommit(commitFreq == 0);
        for (int i = 0; i < tuplesToInsert; ++i) {
            pSt.setInt(1, i);
            pSt.setString(2, "i" + i);
            pSt.execute();
            if (commitFreq == 0 || i % commitFreq != 0) continue;
            System.out.println("i: " + i);
            conn.commit();
        }
        conn.commit();
        ResultSet rs = s.executeQuery("select count(*) from t");
        rs.next();
        int count = rs.getInt(1);
        System.out.println("count: " + count);
    }

    public void verifyTestInserts() throws SQLException, IOException, InterruptedException {
        System.out.println("**** SimplePerfTest.verifyTestInserts() " + this.getTestConfiguration().getJDBCClient().getJDBCDriverName());
        Connection conn = this.getConnection();
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("select count(*) from t");
        rs.next();
        int count = rs.getInt(1);
        System.out.println("count: " + count);
    }
}

