/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class ReplicationRun_Local_StateTest_part1_2
extends ReplicationRun {
    static final String CANNOT_CONNECT_TO_DB_IN_SLAVE_MODE = "08004";
    static final String LOGIN_FAILED = "08004";
    static final String REPLICATION_DB_NOT_BOOTED = "XRE11";
    static final String REPLICATION_MASTER_ALREADY_BOOTED = "XRE22";
    static final String REPLICATION_NOT_IN_MASTER_MODE = "XRE07";
    static final String REPLICATION_SLAVE_STARTED_OK = "XRE08";

    public ReplicationRun_Local_StateTest_part1_2(String testcaseName) {
        super(testcaseName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ReplicationRun_Local_StateTest_part1_2 Suite");
        suite.addTestSuite(ReplicationRun_Local_StateTest_part1_2.class);
        return SecurityManagerSetup.noSecurityManager((Test)suite);
    }

    public void testReplication_Local_StateTest_part1_2() throws Exception {
        this.cleanAllTestHosts();
        this.initEnvironment();
        this.initMaster(masterServerHost, replicatedDb);
        this.masterServer = this.startServer(masterJvmVersion, derbyMasterVersion, masterServerHost, "0.0.0.0", masterServerPort, masterDbSubPath);
        this.slaveServer = this.startServer(slaveJvmVersion, derbySlaveVersion, slaveServerHost, "0.0.0.0", slaveServerPort, slaveDbSubPath);
        this.startServerMonitor(slaveServerHost);
        this.bootMasterDatabase(jvmVersion, masterDatabasePath + FS + masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, null);
        this.initSlave(slaveServerHost, jvmVersion, replicatedDb);
        this.startSlave(jvmVersion, replicatedDb, slaveServerHost, slaveServerPort, slaveServerHost, slaveReplPort, testClientHost);
        this.startMaster(jvmVersion, replicatedDb, masterServerHost, masterServerPort, masterServerHost, slaveServerPort, slaveServerHost, slaveReplPort);
        this._testPostStartedMasterAndSlave_StopMaster();
        this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
    }

    private void _testPostStartedMasterAndSlave_StopMaster() throws InterruptedException, SQLException {
        String msg;
        String ss;
        String msg2;
        String ss2;
        int ec;
        Connection conn = null;
        String db = null;
        String connectionURL = null;
        db = slaveDatabasePath + FS + ReplicationRun.slaveDbSubPath + FS + replicatedDb;
        connectionURL = "jdbc:derby://" + slaveServerHost + ":" + slaveServerPort + "/" + db + ";stopMaster=true";
        this.util.DEBUG("1. testPostStartedMasterAndSlave_StopMaster: " + connectionURL);
        try {
            conn = DriverManager.getConnection(connectionURL);
            this.util.DEBUG("Unexpectedly connected as: " + connectionURL);
            ReplicationRun_Local_StateTest_part1_2.assertTrue((String)("Unexpectedly connected as: " + connectionURL), (boolean)false);
        }
        catch (SQLException se) {
            ec = se.getErrorCode();
            ss2 = se.getSQLState();
            msg2 = ec + " " + ss2 + " " + se.getMessage();
            BaseJDBCTestCase.assertSQLState("connectionURL +  failed: " + msg2, "08004", se);
            this.util.DEBUG("stopMaster on slave failed as expected: " + connectionURL + " " + msg2);
        }
        db = masterDatabasePath + FS + ReplicationRun.masterDbSubPath + FS + replicatedDb;
        connectionURL = "jdbc:derby://" + masterServerHost + ":" + masterServerPort + "/" + db + ";stopMaster=true";
        this.util.DEBUG("2. testPostStartedMasterAndSlave_StopMaster: " + connectionURL);
        try {
            conn = DriverManager.getConnection(connectionURL);
            this.util.DEBUG("Connected as expected: " + connectionURL);
        }
        catch (SQLException se) {
            ec = se.getErrorCode();
            ss2 = se.getSQLState();
            msg2 = ec + " " + ss2 + " " + se.getMessage();
            this.util.DEBUG("stopMaster on master failed: " + connectionURL + " " + msg2);
            ReplicationRun_Local_StateTest_part1_2.assertTrue((String)("stopMaster on master failed: " + connectionURL + " " + msg2), (boolean)false);
        }
        db = slaveDatabasePath + FS + ReplicationRun.slaveDbSubPath + FS + replicatedDb;
        connectionURL = "jdbc:derby://" + slaveServerHost + ":" + slaveServerPort + "/" + db;
        this.util.DEBUG("3. testPostStartedMasterAndSlave_StopMaster: " + connectionURL);
        SQLException gotEx = null;
        int tries = 20;
        while (tries-- > 0) {
            gotEx = null;
            try {
                conn = DriverManager.getConnection(connectionURL);
                this.util.DEBUG("Successfully connected: " + connectionURL);
                break;
            }
            catch (SQLException se) {
                gotEx = se;
                if (!se.getSQLState().equals("08004")) break;
                this.util.DEBUG("got CANNOT_CONNECT_TO_DB_IN_SLAVE_MODE, sleep");
                Thread.sleep(1000L);
            }
        }
        if (gotEx != null) {
            this.util.DEBUG("3. failed to connect to ex-slave");
            throw gotEx;
        }
        db = slaveDatabasePath + FS + ReplicationRun.slaveDbSubPath + FS + replicatedDb;
        connectionURL = "jdbc:derby://" + slaveServerHost + ":" + slaveServerPort + "/" + db + ";stopMaster=true";
        this.util.DEBUG("4. testPostStartedMasterAndSlave_StopMaster: " + connectionURL);
        try {
            conn = DriverManager.getConnection(connectionURL);
            this.util.DEBUG("4. Unexpectedly connected: " + connectionURL);
            ReplicationRun_Local_StateTest_part1_2.assertTrue((String)("4. Unexpectedly connected: " + connectionURL), (boolean)false);
        }
        catch (SQLException se) {
            int ec2 = se.getErrorCode();
            ss = se.getSQLState();
            msg = ec2 + " " + ss + " " + se.getMessage();
            BaseJDBCTestCase.assertSQLState("4. stopMaster on slave failed with: " + connectionURL + " " + msg, REPLICATION_NOT_IN_MASTER_MODE, se);
            this.util.DEBUG("4. stopMaster on slave failed as expected: " + connectionURL + " " + msg);
        }
        db = masterDatabasePath + FS + ReplicationRun.masterDbSubPath + FS + replicatedDb;
        connectionURL = "jdbc:derby://" + masterServerHost + ":" + masterServerPort + "/" + db;
        this.util.DEBUG("5. testPostStartedMasterAndSlave_StopMaster: " + connectionURL);
        try {
            conn = DriverManager.getConnection(connectionURL);
            this.util.DEBUG("5. Successfully connected: " + connectionURL);
        }
        catch (SQLException se) {
            int ec3 = se.getErrorCode();
            ss = se.getSQLState();
            msg = ec3 + " " + ss + " " + se.getMessage();
            this.util.DEBUG("5. Connect to db not in master mode unexpectedly failed : " + connectionURL + " " + msg);
            ReplicationRun_Local_StateTest_part1_2.assertTrue((String)("5. Connect to db not in master mode unexpectedly failed : " + connectionURL + " " + msg), (boolean)false);
        }
        db = masterDatabasePath + FS + ReplicationRun.masterDbSubPath + FS + replicatedDb;
        connectionURL = "jdbc:derby://" + masterServerHost + ":" + masterServerPort + "/" + db + ";stopMaster=true";
        this.util.DEBUG("6. testPostStartedMasterAndSlave_StopMaster: " + connectionURL);
        try {
            conn = DriverManager.getConnection(connectionURL);
            this.util.DEBUG("6. Unexpectedly connected: " + connectionURL);
            ReplicationRun_Local_StateTest_part1_2.assertTrue((String)("6. Unexpectedly connected: " + connectionURL), (boolean)false);
        }
        catch (SQLException se) {
            int ec4 = se.getErrorCode();
            ss = se.getSQLState();
            msg = ec4 + " " + ss + " " + se.getMessage();
            BaseJDBCTestCase.assertSQLState("6. stopMaster on server not in master mode failed with: " + connectionURL + " " + msg, REPLICATION_NOT_IN_MASTER_MODE, se);
            this.util.DEBUG("6. stopMaster on server not in master mode failed as expected: " + connectionURL + " " + msg);
        }
    }
}

