/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.management;

import java.util.Set;
import javax.management.ObjectName;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.management.MBeanTest;

public class ManagementMBeanTest
extends MBeanTest {
    public ManagementMBeanTest(String name) {
        super(name);
    }

    public static Test suite() {
        return MBeanTest.suite(ManagementMBeanTest.class, "ManagementMBeanTest");
    }

    public void testStartStopManagementFromApplication() throws Exception {
        ObjectName appMgmtBean = this.getApplicationManagementMBean();
        this.startStopManagement(appMgmtBean);
    }

    private void startStopManagement(ObjectName mbean) throws Exception {
        this.assertBooleanAttribute(true, mbean, "ManagementActive");
        int derbyMbeanCount = this.getDerbyDomainMBeans().size();
        ManagementMBeanTest.assertTrue((String)("DerbyMBeanCount:" + derbyMbeanCount), (derbyMbeanCount >= 2 ? 1 : 0) != 0);
        this.invokeOperation(mbean, "startManagement");
        this.assertBooleanAttribute(true, mbean, "ManagementActive");
        ManagementMBeanTest.assertEquals((int)derbyMbeanCount, (int)this.getDerbyDomainMBeans().size());
        this.invokeOperation(mbean, "stopManagement");
        this.assertBooleanAttribute(false, mbean, "ManagementActive");
        Set<ObjectName> managementOnly = this.getDerbyDomainMBeans();
        ManagementMBeanTest.assertEquals((int)2, (int)managementOnly.size());
        for (ObjectName name : managementOnly) {
            ManagementMBeanTest.assertEquals((String)"Management", (String)name.getKeyProperty("type"));
        }
        this.invokeOperation(mbean, "startManagement");
        this.assertBooleanAttribute(true, mbean, "ManagementActive");
        ManagementMBeanTest.assertEquals((int)derbyMbeanCount, (int)this.getDerbyDomainMBeans().size());
    }
}

