/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.management;

import java.io.BufferedReader;
import java.util.Hashtable;
import javax.management.ObjectName;
import junit.framework.Test;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.derbyTesting.functionTests.tests.management.MBeanTest;
import org.apache.derbyTesting.junit.Utilities;

public class JDBCMBeanTest
extends MBeanTest {
    public JDBCMBeanTest(String name) {
        super(name);
    }

    public static Test suite() {
        return MBeanTest.suite(JDBCMBeanTest.class, "JDBCMBeanTest");
    }

    private ObjectName getJdbcMBeanObjectName() throws Exception {
        Hashtable<String, String> keyProps = new Hashtable<String, String>();
        keyProps.put("type", "JDBC");
        return this.getDerbyMBeanName(keyProps);
    }

    public void testAttributeCompliantDriver() throws Exception {
        this.assertBooleanAttribute(true, this.getJdbcMBeanObjectName(), "CompliantDriver");
    }

    public void testAttributeDriverLevel() throws Exception {
        String expected = "[Unable to get driver level from sysinfo]";
        BufferedReader sysinfoOutput = Utilities.getSysinfoFromServer();
        String line = null;
        while ((line = sysinfoOutput.readLine()) != null) {
            if (!line.matches("^JRE - JDBC: .*")) continue;
            expected = line.substring(line.indexOf(": ") + 2);
        }
        this.assertStringAttribute(expected, this.getJdbcMBeanObjectName(), "DriverLevel");
    }

    public void testAttributeMajorVersion() throws Exception {
        EmbeddedDriver d = new EmbeddedDriver();
        int expected = d.getMajorVersion();
        this.assertIntAttribute(expected, this.getJdbcMBeanObjectName(), "MajorVersion");
    }

    public void testAttributeMinorVersion() throws Exception {
        EmbeddedDriver d = new EmbeddedDriver();
        int expected = d.getMinorVersion();
        this.assertIntAttribute(expected, this.getJdbcMBeanObjectName(), "MinorVersion");
    }

    public void testOperationAcceptsURL() throws Exception {
        String opName = "acceptsURL";
        ObjectName objName = this.getJdbcMBeanObjectName();
        Object[] params = new Object[1];
        String[] signature = new String[]{"java.lang.String"};
        params[0] = "jdbc:derby:testDatabase";
        Boolean accepted = (Boolean)this.invokeOperation(objName, opName, params, signature);
        JDBCMBeanTest.assertTrue((String)("URL: " + params[0]), (boolean)accepted);
        params[0] = "jdbc:derby:testDB;create=true;user=tester;password=mypass";
        accepted = (Boolean)this.invokeOperation(objName, opName, params, signature);
        JDBCMBeanTest.assertTrue((String)("URL: " + params[0]), (boolean)accepted);
        params[0] = "jdbc:invalidProtocol:newDatabase";
        accepted = (Boolean)this.invokeOperation(objName, opName, params, signature);
        JDBCMBeanTest.assertFalse((String)("URL: " + params[0]), (boolean)accepted);
    }
}

