/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class dbjarUtil {
    public static void createArchive(String jarName, String path, String dbName) throws Exception {
        String root = System.getProperty("derby.system.home", System.getProperty("user.dir"));
        File top = new File(root, path);
        if (!top.isDirectory()) {
            throw new Exception(top.toString() + " is not a directory");
        }
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(new File(root, jarName)));
        dbjarUtil.addEntries(zos, top, dbName, top.getPath().length());
        zos.close();
    }

    static void addEntries(ZipOutputStream zos, File dir, String dbName, int old) throws Exception {
        String[] list = dir.list();
        for (int i = 0; i < list.length; ++i) {
            File f = new File(dir, list[i]);
            if (f.isDirectory()) {
                dbjarUtil.addEntries(zos, f, dbName, old);
                continue;
            }
            dbjarUtil.addFile(zos, f, dbName, old);
        }
    }

    static void addFile(ZipOutputStream zos, File f, String dbName, int old) throws IOException {
        int int9;
        String s = f.getPath().replace(File.separatorChar, '/');
        s = s.substring(old);
        s = dbName.concat(s);
        ZipEntry ze = new ZipEntry(s);
        ze.setTime(f.lastModified());
        zos.putNextEntry(ze);
        byte[] byte8 = new byte[1024];
        BufferedInputStream bufferedInputStream10 = new BufferedInputStream(new FileInputStream(f));
        while ((int9 = bufferedInputStream10.read(byte8, 0, byte8.length)) != -1) {
            zos.write(byte8, 0, int9);
        }
        bufferedInputStream10.close();
        zos.closeEntry();
    }

    public static void setDBContextClassLoader(String jarName) throws MalformedURLException {
        String root = System.getProperty("derby.system.home", System.getProperty("user.dir"));
        File jar = new File(root, jarName);
        URLClassLoader cl = new URLClassLoader(new URL[]{jar.toURL()});
        Thread.currentThread().setContextClassLoader(cl);
    }

    public static void setNullContextClassLoader() {
        Thread.currentThread().setContextClassLoader(null);
    }
}

