/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.jdbc.ClientDataSource;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;

public class ShutdownDatabaseTest
extends BaseJDBCTestCase {
    public ShutdownDatabaseTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup((Test)new TestSuite(ShutdownDatabaseTest.class, "ShutdownDatabaseTest"));
    }

    protected void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
    }

    protected void setUp() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table TEST_TABLE ( TEST_COL integer )");
        this.commit();
        this.insertIntoTestTable(1, 1000);
    }

    protected void tearDown() throws Exception {
        Statement st = this.createStatement();
        st.execute("DROP TABLE TEST_TABLE");
        st.close();
        this.commit();
        super.tearDown();
    }

    public void testOnlyTransactionWasCommited() throws SQLException {
        this.commit();
        this.assertShutdownOK();
        Statement st = this.createStatement();
        JDBC.assertSingleValueResultSet(st.executeQuery("select count(*) from TEST_TABLE "), "1000");
        st.close();
    }

    public void testTwiceCommited() throws SQLException {
        this.commit();
        this.insertIntoTestTable(1001, 999);
        this.commit();
        this.assertShutdownOK();
        Statement st = this.createStatement();
        JDBC.assertSingleValueResultSet(st.executeQuery("select count(*) from TEST_TABLE "), "1999");
        st.close();
    }

    public void testOnceRollbackedAndCommited() throws SQLException {
        this.rollback();
        this.insertIntoTestTable(1001, 999);
        this.commit();
        this.assertShutdownOK();
        Statement st = this.createStatement();
        JDBC.assertSingleValueResultSet(st.executeQuery("select count(*) from TEST_TABLE "), "999");
        st.close();
    }

    public void testOnlyTransactionWasRollbacked() throws SQLException {
        this.rollback();
        this.assertShutdownOK();
        Statement st = this.createStatement();
        JDBC.assertSingleValueResultSet(st.executeQuery("select count(*) from TEST_TABLE "), "0");
        st.close();
    }

    public void testOnceCommitedAndRollbacked() throws SQLException {
        this.commit();
        this.insertIntoTestTable(1001, 999);
        this.rollback();
        this.assertShutdownOK();
        Statement st = this.createStatement();
        JDBC.assertSingleValueResultSet(st.executeQuery("select count(*) from TEST_TABLE "), "1000");
        st.close();
    }

    public void testTwiceRollbacked() throws SQLException {
        this.rollback();
        this.insertIntoTestTable(1001, 999);
        this.rollback();
        this.assertShutdownOK();
        Statement st = this.createStatement();
        JDBC.assertSingleValueResultSet(st.executeQuery("select count(*) from TEST_TABLE "), "0");
        st.close();
    }

    public void testOnlyTransactionWasLeft() throws SQLException {
        this.assertShutdownOK();
        Statement st = this.createStatement();
        JDBC.assertSingleValueResultSet(st.executeQuery("select count(*) from TEST_TABLE "), "0");
        st.close();
    }

    public void testOnceCommitedAndLeft() throws SQLException {
        this.commit();
        this.insertIntoTestTable(1001, 999);
        this.assertShutdownOK();
        Statement st = this.createStatement();
        JDBC.assertSingleValueResultSet(st.executeQuery("select count(*) from TEST_TABLE "), "1000");
        st.close();
    }

    public void testOnceRollbackedAndLeft() throws SQLException {
        this.rollback();
        this.insertIntoTestTable(1001, 999);
        this.assertShutdownOK();
        Statement st = this.createStatement();
        JDBC.assertSingleValueResultSet(st.executeQuery("select count(*) from TEST_TABLE "), "0");
        st.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertIntoTestTable(int val) throws SQLException {
        PreparedStatement st = null;
        try {
            st = this.prepareStatement("insert into TEST_TABLE ( TEST_COL ) values( ? )");
            st.setInt(1, val);
            st.execute();
        }
        finally {
            if (st != null) {
                st.close();
                st = null;
            }
        }
    }

    private void insertIntoTestTable(int initialval, int count) throws SQLException {
        for (int i = initialval; i < initialval + count; ++i) {
            this.insertIntoTestTable(i);
        }
    }

    protected void assertShutdownOK() throws SQLException {
        Connection conn = this.getConnection();
        if (ShutdownDatabaseTest.usingEmbedded()) {
            DataSource ds = JDBCDataSource.getDataSource();
            JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
            try {
                ds.getConnection();
                ShutdownDatabaseTest.fail((String)"expected shutdown to fail");
            }
            catch (SQLException e) {
                ShutdownDatabaseTest.assertSQLState("08006", e);
            }
            ShutdownDatabaseTest.assertTrue((boolean)conn.isClosed());
        } else if (ShutdownDatabaseTest.usingDerbyNetClient()) {
            ClientDataSource ds = (ClientDataSource)JDBCDataSource.getDataSource();
            ds.setConnectionAttributes("shutdown=true");
            try {
                ds.getConnection();
                ShutdownDatabaseTest.fail((String)"expected shutdown to fail");
            }
            catch (SQLException e) {
                ShutdownDatabaseTest.assertSQLState("08006", e);
            }
        }
    }
}

