/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RolesConferredPrivilegesTest
extends BaseJDBCTestCase {
    private static final String pwSuffix = "pwSuffix";
    private static final String NOEXECUTEPERMISSION = "42504";
    private static final String NOTABLEPERMISSION = "42500";
    private static final String NOCOLUMNPERMISSION = "42502";
    private static final String TABLENOTFOUND = "42X05";
    private static final String OBJECTNOTFOUND = "42X94";
    private static final String FKVIOLATION = "23503";
    private static final String CHECKCONSTRAINTVIOLATED = "23513";
    private static final String ALREADYCLOSED = "XJ012";
    private static final String CONSTRAINTDROPPED = "01500";
    private static final String VIEWDROPPED = "01501";
    private static final String TRIGGERDROPPED = "01502";
    private static final String UNRELIABLE = "42Y39";
    private static final String[] users = new String[]{"test_dbo", "DonaldDuck"};
    private static final int GRANT = 0;
    private static final int REVOKE = 1;
    private static final int NOPRIV = 0;
    private static final int VIAUSER = 1;
    private static final int VIAROLE = 2;
    private static final String g_r = "references on s1.t1 ";
    private static final String g_r_c1 = "references (c1) on s1.t1 ";
    private static final String g_r_c2 = "references (c2) on s1.t1 ";
    private static final String g_r_c3 = "references (c3) on s1.t1 ";
    private static final String g_u = "update on s1.t1 ";
    private static final String g_u_c1 = "update (c1) on s1.t1 ";
    private static final String g_u_c2 = "update (c2) on s1.t1 ";
    private static final String g_u_c3 = "update (c3) on s1.t1 ";
    private static final String g_u_c1_c2_c3 = "update (c1,c2,c3) on s1.t1 ";
    private static final String g_i = "insert on s1.t1 ";
    private static final String g_s = "select on s1.t1 ";
    private static final String g_s_c1 = "select (c1) on s1.t1 ";
    private static final String g_s_c2 = "select (c2) on s1.t1 ";
    private static final String g_s_c3 = "select (c3) on s1.t1 ";
    private static final String g_d = "delete on s1.t1 ";
    private static final String g_t = "trigger on s1.t1 ";
    private static final String g_e = "execute on function s1.f1 ";
    private static final String g_e_f2 = "execute on function s1.f2 ";
    private static final String[] g_all = new String[]{"references on s1.t1 ", "references (c1) on s1.t1 ", "references (c2) on s1.t1 ", "references (c3) on s1.t1 ", "update on s1.t1 ", "update (c1) on s1.t1 ", "update (c2) on s1.t1 ", "update (c3) on s1.t1 ", "insert on s1.t1 ", "select on s1.t1 ", "select (c1) on s1.t1 ", "select (c2) on s1.t1 ", "select (c3) on s1.t1 ", "delete on s1.t1 ", "trigger on s1.t1 ", "execute on function s1.f1 "};
    private static final String[] g_all_col = new String[]{"references (c1) on s1.t1 ", "references (c2) on s1.t1 ", "references (c3) on s1.t1 ", "update (c1) on s1.t1 ", "update (c2) on s1.t1 ", "update (c3) on s1.t1 ", "insert on s1.t1 ", "select (c1) on s1.t1 ", "select (c2) on s1.t1 ", "select (c3) on s1.t1 ", "delete on s1.t1 ", "trigger on s1.t1 ", "execute on function s1.f1 "};
    private static final String[] g_all_tab = new String[]{"references on s1.t1 ", "update on s1.t1 ", "insert on s1.t1 ", "select on s1.t1 ", "delete on s1.t1 ", "trigger on s1.t1 ", "execute on function s1.f1 "};
    private static final String[][] grantRevokes = new String[][]{g_all, g_all_col, g_all_tab};

    public RolesConferredPrivilegesTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("RolesConferredPrivilegesTest");
        suite.addTest(RolesConferredPrivilegesTest.makeSuite());
        return suite;
    }

    private static Test makeSuite() {
        CleanDatabaseTestSetup clean = new CleanDatabaseTestSetup((Test)new TestSuite(RolesConferredPrivilegesTest.class)){

            protected void decorateSQL(Statement s) throws SQLException {
                s.execute("create role a1");
                s.execute("create role j");
                s.execute("create role b");
                s.execute("create role e");
                s.execute("create role h");
                s.execute("create role a2");
                s.execute("create role c");
                s.execute("create role f");
                s.execute("create role a3");
                s.execute("create role d");
                s.execute("grant a1 to j");
                s.execute("grant a1 TO b");
                s.execute("grant b TO e");
                s.execute("grant e TO h");
                s.execute("grant a1 TO c");
                s.execute("grant e TO f");
                s.execute("grant a2 TO c");
                s.execute("grant c TO f");
                s.execute("grant f TO h");
                s.execute("grant a3 TO d");
                s.execute("grant d TO f");
                s.execute("create schema s1");
                s.execute("create function s1.f1( ) returns int language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.lang.RolesConferredPrivilegesTest.s1f1' no sql called on null input");
                s.execute("create function s1.f2( ) returns int language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.lang.RolesConferredPrivilegesTest.s1f1' no sql called on null input");
                s.execute("create table s1.t1(c1 int unique, c2 int unique, c3 int unique, primary key (c1,c2,c3))");
                s.execute("create procedure s1.calledNested()  language java parameter style java  external name 'org.apache.derbyTesting.functionTests.tests.lang.RolesConferredPrivilegesTest.calledNested'   modifies sql data");
                s.execute("create function s1.getCurrentRole() returns varchar(30)language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.lang.RolesConferredPrivilegesTest.getCurrentRole'  reads sql data");
            }
        };
        return TestConfiguration.sqlAuthorizationDecorator(DatabasePropertyTestSetup.singleProperty(DatabasePropertyTestSetup.builtinAuthentication((Test)clean, users, pwSuffix), "derby.language.statementCacheSize", "1000"));
    }

    public void testConferredPrivileges() throws SQLException {
        Connection dboConn = this.getConnection();
        Statement s = dboConn.createStatement();
        String[] grantees = new String[]{"DonaldDuck", "public"};
        Connection c = this.openUserConnection("DonaldDuck");
        for (int gNo = 0; gNo < grantees.length; ++gNo) {
            int i;
            s.executeUpdate("grant h to " + grantees[gNo]);
            String[] applicableFor_h = new String[]{"h", "a1", "a2", "a3", "b", "e", "c", "f", "d"};
            String[] notApplicableFor_h = new String[]{"j"};
            this.setRole(c, "h");
            for (i = 0; i < applicableFor_h.length; ++i) {
                this.assertAllforRole(2, c, applicableFor_h[i]);
            }
            for (i = 0; i < notApplicableFor_h.length; ++i) {
                this.assertAllforRole(0, c, notApplicableFor_h[i]);
            }
            this.setRole(c, "none");
            for (i = 0; i < applicableFor_h.length; ++i) {
                this.assertAllforRole(0, c, applicableFor_h[i]);
            }
            s.executeUpdate("grant f to " + grantees[gNo]);
            this.setRole(c, "f");
            this.assertAllforRole(2, c, "a1");
            s.executeUpdate("revoke a1 from c");
            this.assertAllforRole(2, c, "a1");
            s.executeUpdate("revoke a1 from b");
            this.assertAllforRole(0, c, "a1");
            s.executeUpdate("grant a1 to b");
            this.assertAllforRole(2, c, "a1");
            s.executeUpdate("grant a1 to c");
            s.executeUpdate("revoke f from " + grantees[gNo]);
            this.setRole(c, "h");
            s.executeUpdate("revoke h from " + grantees[gNo]);
            for (i = 0; i < applicableFor_h.length; ++i) {
                this.assertAllforRole(0, c, applicableFor_h[i]);
            }
            s.executeUpdate("grant h to " + grantees[gNo]);
            this.setRole(c, "h");
            for (i = 0; i < applicableFor_h.length; ++i) {
                this.assertAllforRole(2, c, applicableFor_h[i]);
            }
            s.executeUpdate("drop role h");
            for (i = 0; i < applicableFor_h.length; ++i) {
                this.assertAllforRole(0, c, applicableFor_h[i]);
            }
            s.executeUpdate("create role h");
            s.executeUpdate("grant e to h");
            s.executeUpdate("grant f to h");
        }
        c.close();
        s.close();
        dboConn.close();
    }

    public void testViewInvalidation() throws SQLException {
        SQLWarning w;
        Connection dboConn = this.getConnection();
        Statement s = dboConn.createStatement();
        Connection c = this.openUserConnection("DonaldDuck");
        Statement cStmt = c.createStatement();
        String[] grantToThisRole = new String[]{"a2", "h"};
        String[] roleGrantees = new String[]{"DonaldDuck", "public"};
        String[] tabAndColSelectsPerms = new String[]{g_s, g_s_c1};
        String createViewString = "create view v as select c1 from s1.t1";
        for (int r = 0; r < grantToThisRole.length; ++r) {
            for (int gNo = 0; gNo < roleGrantees.length; ++gNo) {
                for (int i = 0; i < tabAndColSelectsPerms.length; ++i) {
                    s.executeUpdate("grant h to " + roleGrantees[gNo]);
                    this.doGrantRevoke(0, "test_dbo", tabAndColSelectsPerms[i], grantToThisRole[r]);
                    this.setRole(c, "h");
                    cStmt.executeUpdate(createViewString);
                    this.assertViewExists(true, c, "v");
                    this.setRole(c, "none");
                    this.assertViewExists(true, c, "v");
                    this.doGrantRevoke(1, "test_dbo", tabAndColSelectsPerms[i], grantToThisRole[r], VIEWDROPPED);
                    this.assertViewExists(false, c, "v");
                    this.doGrantRevoke(0, "test_dbo", tabAndColSelectsPerms[i], grantToThisRole[r]);
                    this.setRole(c, "h");
                    cStmt.executeUpdate(createViewString);
                    this.assertViewExists(true, c, "v");
                    s.executeUpdate("revoke h from " + roleGrantees[gNo]);
                    w = s.getWarnings();
                    RolesConferredPrivilegesTest.assertSQLState(VIEWDROPPED, w);
                    this.assertViewExists(false, c, "v");
                    String[] directGrantee = roleGrantees;
                    for (int u = 0; u < directGrantee.length; ++u) {
                        s.executeUpdate("grant h to " + roleGrantees[gNo]);
                        this.doGrantRevoke(0, "test_dbo", tabAndColSelectsPerms[i], directGrantee[u]);
                        this.setRole(c, "h");
                        cStmt.executeUpdate(createViewString);
                        s.executeUpdate("revoke h from " + roleGrantees[gNo]);
                        this.assertViewExists(true, c, "v");
                        this.doGrantRevoke(1, "test_dbo", tabAndColSelectsPerms[i], directGrantee[u], VIEWDROPPED);
                        this.assertViewExists(false, c, "v");
                    }
                    this.doGrantRevoke(1, "test_dbo", tabAndColSelectsPerms[i], grantToThisRole[r]);
                }
            }
        }
        this.doGrantRevoke(0, "test_dbo", g_s, "h");
        s.executeUpdate("grant h to DonaldDuck");
        this.setRole(c, "h");
        cStmt.executeUpdate(createViewString);
        this.assertViewExists(true, c, "v");
        s.executeUpdate("drop role h");
        w = s.getWarnings();
        RolesConferredPrivilegesTest.assertSQLState(VIEWDROPPED, w);
        this.assertViewExists(false, c, "v");
        this.doGrantRevoke(1, "test_dbo", g_s, "h");
        s.executeUpdate("create role h");
        s.executeUpdate("grant e to h");
        s.executeUpdate("grant f to h");
        this.doGrantRevoke(0, "test_dbo", g_s, "a3");
        s.executeUpdate("grant h to DonaldDuck");
        this.setRole(c, "h");
        cStmt.executeUpdate(createViewString);
        this.assertViewExists(true, c, "v");
        s.executeUpdate("drop role a3");
        w = s.getWarnings();
        RolesConferredPrivilegesTest.assertSQLState(VIEWDROPPED, w);
        this.assertViewExists(false, c, "v");
        this.doGrantRevoke(1, "test_dbo", g_s, "h");
        s.executeUpdate("create role a3");
        s.executeUpdate("grant a3 to d");
        cStmt.close();
        c.close();
        s.close();
        dboConn.close();
    }

    public void testTriggerInvalidation() throws SQLException {
        int i;
        SQLWarning w;
        Connection dboConn = this.getConnection();
        Statement s = dboConn.createStatement();
        Connection c = this.openUserConnection("DonaldDuck");
        Statement cStmt = c.createStatement();
        String[] grantToThisRole = new String[]{"a2", "h"};
        String[] roleGrantees = new String[]{"DonaldDuck", "public"};
        String createTriggerString = "create trigger t after insert on s1.t1 values 1";
        for (int r = 0; r < grantToThisRole.length; ++r) {
            for (int gNo = 0; gNo < roleGrantees.length; ++gNo) {
                s.executeUpdate("grant h to " + roleGrantees[gNo]);
                this.doGrantRevoke(0, "test_dbo", g_t, grantToThisRole[r]);
                this.setRole(c, "h");
                cStmt.executeUpdate(createTriggerString);
                this.assertTriggerExists(true, c, "t");
                cStmt.executeUpdate(createTriggerString);
                this.setRole(c, "none");
                this.assertTriggerExists(true, c, "t");
                this.setRole(c, "h");
                cStmt.executeUpdate(createTriggerString);
                this.doGrantRevoke(1, "test_dbo", g_t, grantToThisRole[r], TRIGGERDROPPED);
                this.assertTriggerExists(false, c, "t");
                this.doGrantRevoke(0, "test_dbo", g_t, grantToThisRole[r]);
                this.setRole(c, "h");
                cStmt.executeUpdate(createTriggerString);
                this.assertTriggerExists(true, c, "t");
                cStmt.executeUpdate(createTriggerString);
                s.executeUpdate("revoke h from " + roleGrantees[gNo]);
                w = s.getWarnings();
                RolesConferredPrivilegesTest.assertSQLState(TRIGGERDROPPED, w);
                this.assertTriggerExists(false, c, "t");
                String[] directGrantee = roleGrantees;
                for (int u = 0; u < directGrantee.length; ++u) {
                    s.executeUpdate("grant h to " + roleGrantees[gNo]);
                    this.doGrantRevoke(0, "test_dbo", g_t, directGrantee[u]);
                    this.setRole(c, "h");
                    cStmt.executeUpdate(createTriggerString);
                    s.executeUpdate("revoke h from " + roleGrantees[gNo]);
                    this.assertTriggerExists(true, c, "t");
                    cStmt.executeUpdate(createTriggerString);
                    this.doGrantRevoke(1, "test_dbo", g_t, directGrantee[u], TRIGGERDROPPED);
                    this.assertTriggerExists(false, c, "t");
                }
                this.doGrantRevoke(1, "test_dbo", g_t, grantToThisRole[r]);
            }
        }
        this.doGrantRevoke(0, "test_dbo", g_t, "h");
        s.executeUpdate("grant h to DonaldDuck");
        this.setRole(c, "h");
        cStmt.executeUpdate(createTriggerString);
        this.assertTriggerExists(true, c, "t");
        cStmt.executeUpdate(createTriggerString);
        s.executeUpdate("drop role h");
        w = s.getWarnings();
        RolesConferredPrivilegesTest.assertSQLState(TRIGGERDROPPED, w);
        this.assertTriggerExists(false, c, "t");
        this.doGrantRevoke(1, "test_dbo", g_t, "h");
        s.executeUpdate("create role h");
        s.executeUpdate("grant e to h");
        s.executeUpdate("grant f to h");
        this.doGrantRevoke(0, "test_dbo", g_t, "h");
        this.doGrantRevoke(0, "test_dbo", g_e, "h");
        s.executeUpdate("grant h to DonaldDuck");
        this.setRole(c, "h");
        cStmt.executeUpdate("create trigger t after insert on s1.t1 values s1.f1()");
        this.assertTriggerExists(true, c, "t");
        cStmt.executeUpdate("create trigger t after insert on s1.t1 values s1.f1()");
        s.executeUpdate("revoke h from DonaldDuck");
        w = s.getWarnings();
        RolesConferredPrivilegesTest.assertSQLState(TRIGGERDROPPED, w);
        this.assertTriggerExists(false, c, "t");
        this.doGrantRevoke(1, "test_dbo", g_t, "h");
        this.doGrantRevoke(1, "test_dbo", g_e, "h");
        String[] triggerPrivGrantees = new String[]{"h", "DonaldDuck"};
        for (i = 0; i < triggerPrivGrantees.length; ++i) {
            s.executeUpdate("grant h to DonaldDuck");
            this.setRole(c, "h");
            this.doGrantRevoke(0, "test_dbo", g_t, triggerPrivGrantees[i]);
            this.doGrantRevoke(0, "test_dbo", g_s_c1, "public");
            this.doGrantRevoke(0, "test_dbo", g_s_c2, "h");
            cStmt.executeUpdate("create trigger t after insert on s1.t1 select c1,c2 from s1.t1");
            s.executeUpdate("revoke h from DonaldDuck");
            w = s.getWarnings();
            RolesConferredPrivilegesTest.assertSQLState(TRIGGERDROPPED, w);
            this.assertTriggerExists(false, c, "t");
            this.doGrantRevoke(1, "test_dbo", g_t, triggerPrivGrantees[i]);
            this.doGrantRevoke(1, "test_dbo", g_s_c1, "public");
            this.doGrantRevoke(1, "test_dbo", g_s_c2, "h");
        }
        for (i = 0; i < triggerPrivGrantees.length; ++i) {
            s.executeUpdate("grant h to DonaldDuck");
            this.setRole(c, "h");
            this.doGrantRevoke(0, "test_dbo", g_t, triggerPrivGrantees[i]);
            this.doGrantRevoke(0, "test_dbo", g_s_c1, "DonaldDuck");
            this.doGrantRevoke(0, "test_dbo", g_s_c2, "h");
            cStmt.executeUpdate("create trigger t after insert on s1.t1 select c1,c2 from s1.t1");
            s.executeUpdate("revoke h from DonaldDuck");
            w = s.getWarnings();
            RolesConferredPrivilegesTest.assertSQLState(TRIGGERDROPPED, w);
            this.assertTriggerExists(false, c, "t");
            this.doGrantRevoke(1, "test_dbo", g_t, triggerPrivGrantees[i]);
            this.doGrantRevoke(1, "test_dbo", g_s_c1, "DonaldDuck");
            this.doGrantRevoke(1, "test_dbo", g_s_c2, "h");
        }
        for (i = 0; i < triggerPrivGrantees.length; ++i) {
            s.executeUpdate("grant h to DonaldDuck");
            this.setRole(c, "h");
            this.doGrantRevoke(0, "test_dbo", g_t, triggerPrivGrantees[i]);
            this.doGrantRevoke(0, "test_dbo", g_s_c1, "DonaldDuck");
            this.doGrantRevoke(0, "test_dbo", g_s_c2, "public");
            this.doGrantRevoke(0, "test_dbo", g_s_c3, "h");
            cStmt.executeUpdate("create trigger t after insert on s1.t1 select c1,c2,c3 from s1.t1");
            s.executeUpdate("revoke h from DonaldDuck");
            w = s.getWarnings();
            RolesConferredPrivilegesTest.assertSQLState(TRIGGERDROPPED, w);
            this.assertTriggerExists(false, c, "t");
            this.doGrantRevoke(1, "test_dbo", g_t, triggerPrivGrantees[i]);
            this.doGrantRevoke(1, "test_dbo", g_s_c1, "DonaldDuck");
            this.doGrantRevoke(1, "test_dbo", g_s_c2, "public");
            this.doGrantRevoke(1, "test_dbo", g_s_c3, "h");
        }
        cStmt.close();
        c.close();
        s.close();
        dboConn.close();
    }

    public void testConstraintInvalidation() throws SQLException {
        Connection dboConn = this.getConnection();
        Statement s = dboConn.createStatement();
        Connection c = this.openUserConnection("DonaldDuck");
        Statement cStmt = c.createStatement();
        String[] grantToThisRole = new String[]{"a2", "h"};
        String[] roleGrantees = new String[]{"DonaldDuck", "public"};
        String[][] tabAndColReferencesPerms = new String[][]{{g_r}, {g_r_c1, g_r_c2, g_r_c3}};
        String createTableString = "create table t (i int not null, j int, k int)";
        String dropTableString = "drop table t";
        String addConstraintString = "alter table t add constraint fk foreign key(i,j,k) references s1.t1";
        cStmt.executeUpdate(createTableString);
        for (int r = 0; r < grantToThisRole.length; ++r) {
            for (int gNo = 0; gNo < roleGrantees.length; ++gNo) {
                for (int i = 0; i < tabAndColReferencesPerms.length; ++i) {
                    s.executeUpdate("grant h to " + roleGrantees[gNo]);
                    this.doGrantRevoke(0, "test_dbo", tabAndColReferencesPerms[i], grantToThisRole[r]);
                    this.setRole(c, "h");
                    cStmt.executeUpdate(addConstraintString);
                    this.assertFkConstraintExists(true, c, "t");
                    this.setRole(c, "none");
                    this.assertFkConstraintExists(true, c, "t");
                    this.doGrantRevoke(1, "test_dbo", tabAndColReferencesPerms[i], grantToThisRole[r], new String[]{CONSTRAINTDROPPED, null, null});
                    this.assertFkConstraintExists(false, c, "t");
                    this.doGrantRevoke(0, "test_dbo", tabAndColReferencesPerms[i], grantToThisRole[r]);
                    this.setRole(c, "h");
                    cStmt.executeUpdate(addConstraintString);
                    this.assertFkConstraintExists(true, c, "t");
                    s.executeUpdate("revoke h from " + roleGrantees[gNo]);
                    this.assertFkConstraintExists(false, c, "t");
                    String[] directGrantee = roleGrantees;
                    for (int u = 0; u < directGrantee.length; ++u) {
                        s.executeUpdate("grant h to " + roleGrantees[gNo]);
                        this.doGrantRevoke(0, "test_dbo", tabAndColReferencesPerms[i], directGrantee[u]);
                        this.setRole(c, "h");
                        cStmt.executeUpdate(addConstraintString);
                        s.executeUpdate("revoke h from " + roleGrantees[gNo]);
                        this.assertFkConstraintExists(true, c, "t");
                        this.doGrantRevoke(1, "test_dbo", tabAndColReferencesPerms[i], directGrantee[u], new String[]{CONSTRAINTDROPPED, null, null});
                        this.assertFkConstraintExists(false, c, "t");
                    }
                    this.doGrantRevoke(1, "test_dbo", tabAndColReferencesPerms[i], grantToThisRole[r]);
                }
            }
        }
        this.doGrantRevoke(0, "test_dbo", g_r, "h");
        s.executeUpdate("grant h to DonaldDuck");
        this.setRole(c, "h");
        cStmt.executeUpdate(addConstraintString);
        this.assertFkConstraintExists(true, c, "t");
        s.executeUpdate("drop role h");
        SQLWarning w = s.getWarnings();
        RolesConferredPrivilegesTest.assertSQLState(CONSTRAINTDROPPED, w);
        this.assertFkConstraintExists(false, c, "t");
        this.doGrantRevoke(1, "test_dbo", g_s, "h");
        s.executeUpdate("create role h");
        s.executeUpdate("grant e to h");
        s.executeUpdate("grant f to h");
        s.executeUpdate("grant h to DonaldDuck");
        this.setRole(c, "h");
        this.doGrantRevoke(0, "test_dbo", new String[]{g_r_c1, g_r_c2, g_r_c3}, "h");
        cStmt.executeUpdate("alter table t add constraint fk foreign key(i,j,k) references s1.t1");
        s.executeUpdate("revoke h from DonaldDuck");
        w = s.getWarnings();
        RolesConferredPrivilegesTest.assertSQLState(CONSTRAINTDROPPED, w);
        this.assertFkConstraintExists(false, c, "t");
        this.doGrantRevoke(1, "test_dbo", new String[]{g_r_c1, g_r_c2, g_r_c3}, "h");
        s.executeUpdate("grant h to DonaldDuck");
        this.setRole(c, "h");
        this.doGrantRevoke(0, "test_dbo", g_r_c1, "public");
        this.doGrantRevoke(0, "test_dbo", g_r_c2, "h");
        this.doGrantRevoke(0, "test_dbo", g_r_c3, "h");
        cStmt.executeUpdate("alter table t add constraint fk foreign key(i,j,k) references s1.t1");
        s.executeUpdate("revoke h from DonaldDuck");
        w = s.getWarnings();
        RolesConferredPrivilegesTest.assertSQLState(CONSTRAINTDROPPED, w);
        this.assertFkConstraintExists(false, c, "t");
        this.doGrantRevoke(1, "test_dbo", g_r_c1, "public");
        this.doGrantRevoke(1, "test_dbo", g_r_c2, "h");
        this.doGrantRevoke(1, "test_dbo", g_r_c3, "h");
        s.executeUpdate("grant h to DonaldDuck");
        this.setRole(c, "h");
        this.doGrantRevoke(0, "test_dbo", g_r_c1, "DonaldDuck");
        this.doGrantRevoke(0, "test_dbo", g_r_c2, "h");
        this.doGrantRevoke(0, "test_dbo", g_r_c3, "h");
        cStmt.executeUpdate("alter table t add constraint fk foreign key(i,j,k) references s1.t1");
        s.executeUpdate("revoke h from DonaldDuck");
        w = s.getWarnings();
        RolesConferredPrivilegesTest.assertSQLState(CONSTRAINTDROPPED, w);
        this.assertFkConstraintExists(false, c, "t");
        this.doGrantRevoke(1, "test_dbo", g_r_c1, "DonaldDuck");
        this.doGrantRevoke(1, "test_dbo", g_r_c2, "h");
        this.doGrantRevoke(1, "test_dbo", g_r_c3, "h");
        s.executeUpdate("grant h to DonaldDuck");
        this.setRole(c, "h");
        this.doGrantRevoke(0, "test_dbo", g_r_c1, "DonaldDuck");
        this.doGrantRevoke(0, "test_dbo", g_r_c2, "public");
        this.doGrantRevoke(0, "test_dbo", g_r_c3, "h");
        cStmt.executeUpdate("alter table t add constraint fk foreign key(i,j,k) references s1.t1");
        s.executeUpdate("revoke h from DonaldDuck");
        w = s.getWarnings();
        RolesConferredPrivilegesTest.assertSQLState(CONSTRAINTDROPPED, w);
        this.assertFkConstraintExists(false, c, "t");
        this.doGrantRevoke(1, "test_dbo", g_r_c1, "DonaldDuck");
        this.doGrantRevoke(1, "test_dbo", g_r_c2, "public");
        this.doGrantRevoke(1, "test_dbo", g_r_c3, "h");
        s.executeUpdate("grant h to DonaldDuck");
        this.setRole(c, "h");
        this.doGrantRevoke(0, "test_dbo", g_e, "h");
        cStmt.executeUpdate("alter table t add constraint ch check(i < s1.f1())");
        this.assertCheckConstraintExists(true, c, "t");
        s.executeUpdate("revoke h from DonaldDuck");
        w = s.getWarnings();
        RolesConferredPrivilegesTest.assertSQLState(CONSTRAINTDROPPED, w);
        this.assertCheckConstraintExists(false, c, "t");
        this.doGrantRevoke(1, "test_dbo", g_e, "h");
        s.executeUpdate("grant h to DonaldDuck");
        this.setRole(c, "h");
        this.doGrantRevoke(0, "test_dbo", g_e, "h");
        this.doGrantRevoke(0, "test_dbo", g_e_f2, "DonaldDuck");
        cStmt.executeUpdate("alter table t add constraint ch check(i < (s1.f1() + s1.f2()))");
        this.assertCheckConstraintExists(true, c, "t");
        s.executeUpdate("revoke h from DonaldDuck");
        w = s.getWarnings();
        RolesConferredPrivilegesTest.assertSQLState(CONSTRAINTDROPPED, w);
        this.assertCheckConstraintExists(false, c, "t");
        this.doGrantRevoke(1, "test_dbo", g_e, "h");
        this.doGrantRevoke(1, "test_dbo", g_e_f2, "DonaldDuck");
        s.executeUpdate("grant h to DonaldDuck");
        this.setRole(c, "h");
        this.doGrantRevoke(0, "test_dbo", g_e, "h");
        this.doGrantRevoke(0, "test_dbo", g_e_f2, "DonaldDuck");
        cStmt.executeUpdate("create table tmp(i int constraint ct1 check(i < s1.f1()),                 j int constraint ct2 check(j < s1.f2()))");
        s.executeUpdate("revoke h from DonaldDuck");
        try {
            cStmt.executeUpdate("insert into tmp values (6, -1)");
        }
        catch (SQLException e) {
            RolesConferredPrivilegesTest.fail("expected success", e);
        }
        try {
            cStmt.executeUpdate("insert into tmp values (6, 6)");
            RolesConferredPrivilegesTest.fail((String)"ct2 should remain");
        }
        catch (SQLException e) {
            RolesConferredPrivilegesTest.assertSQLState(CHECKCONSTRAINTVIOLATED, e);
        }
        cStmt.executeUpdate("alter table tmp drop constraint ct2");
        this.doGrantRevoke(1, "test_dbo", g_e, "h");
        this.doGrantRevoke(1, "test_dbo", g_e_f2, "DonaldDuck");
        cStmt.executeUpdate("drop table tmp");
        cStmt.executeUpdate(dropTableString);
        cStmt.close();
        c.close();
        s.close();
        dboConn.close();
    }

    public void testPSInvalidation() throws SQLException {
        Connection dboConn = this.getConnection();
        Statement s = dboConn.createStatement();
        Connection c = this.openUserConnection("DonaldDuck");
        Statement cStmt = c.createStatement();
        String[] grantToThisRole = new String[]{"a2", "h"};
        String[] roleGrantees = new String[]{"DonaldDuck", "public"};
        String[][] privilegeStmts = new String[][]{{g_s, "select c1 from s1.t1"}, {g_s_c1, "select c1 from s1.t1"}, {g_e, "values s1.f1()"}, {g_u, "update s1.t1 set c1=0"}, {g_u_c1_c2_c3, "update s1.t1 set c1=0"}, {g_i, "insert into s1.t1 values (5,5,5)"}};
        PreparedStatement ps = null;
        for (int r = 0; r < grantToThisRole.length; ++r) {
            for (int gNo = 0; gNo < roleGrantees.length; ++gNo) {
                for (int i = 0; i < privilegeStmts.length; ++i) {
                    s.executeUpdate("grant h to " + roleGrantees[gNo]);
                    this.doGrantRevoke(0, "test_dbo", privilegeStmts[i][0], grantToThisRole[r]);
                    this.setRole(c, "h");
                    ps = c.prepareStatement(privilegeStmts[i][1]);
                    this.assertPsWorks(true, ps);
                    this.setRole(c, "none");
                    this.assertPsWorks(false, ps);
                    this.setRole(c, "h");
                    this.assertPsWorks(true, ps);
                    this.doGrantRevoke(1, "test_dbo", privilegeStmts[i][0], grantToThisRole[r]);
                    this.assertPsWorks(false, ps);
                    this.doGrantRevoke(0, "test_dbo", privilegeStmts[i][0], grantToThisRole[r]);
                    this.setRole(c, "h");
                    this.assertPsWorks(true, ps);
                    s.executeUpdate("revoke h from " + roleGrantees[gNo]);
                    this.assertPsWorks(false, ps);
                    String[] directGrantee = roleGrantees;
                    for (int u = 0; u < directGrantee.length; ++u) {
                        s.executeUpdate("grant h to " + roleGrantees[gNo]);
                        this.setRole(c, "h");
                        this.assertPsWorks(true, ps);
                        this.doGrantRevoke(0, "test_dbo", privilegeStmts[i][0], directGrantee[u]);
                        s.executeUpdate("revoke h from " + roleGrantees[gNo]);
                        this.assertPsWorks(true, ps);
                        this.doGrantRevoke(1, "test_dbo", privilegeStmts[i][0], directGrantee[u]);
                        this.assertPsWorks(false, ps);
                    }
                    this.doGrantRevoke(1, "test_dbo", privilegeStmts[i][0], grantToThisRole[r]);
                }
            }
        }
        for (int i = 0; i < privilegeStmts.length; ++i) {
            this.doGrantRevoke(0, "test_dbo", privilegeStmts[i][0], "h");
            s.executeUpdate("grant h to DonaldDuck");
            this.setRole(c, "h");
            ps = c.prepareStatement(privilegeStmts[i][1]);
            this.assertPsWorks(true, ps);
            s.executeUpdate("drop role h");
            this.assertPsWorks(false, ps);
            this.doGrantRevoke(1, "test_dbo", privilegeStmts[i][0], "h");
            s.executeUpdate("create role h");
            s.executeUpdate("grant e to h");
            s.executeUpdate("grant f to h");
        }
        cStmt.close();
        c.close();
        s.close();
        dboConn.close();
    }

    public void testOpenRs() throws SQLException {
        Connection dboConn = this.getConnection();
        Statement s = dboConn.createStatement();
        Connection c = this.openUserConnection("DonaldDuck");
        Statement cStmt = c.createStatement();
        ResultSet rs = null;
        String select = "select * from s1.t1";
        PreparedStatement ps = dboConn.prepareStatement("insert into s1.t1 values (?,?,?)");
        for (int i = 0; i < 5; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i);
            ps.setInt(3, i);
            ps.execute();
        }
        this.doGrantRevoke(0, "test_dbo", g_s, "h");
        s.execute("grant h to DonaldDuck");
        this.setRole(c, "h");
        rs = cStmt.executeQuery(select);
        rs.next();
        this.doGrantRevoke(1, "test_dbo", g_s, "h");
        rs.next();
        rs.close();
        c.setAutoCommit(false);
        this.doGrantRevoke(0, "test_dbo", g_s, "h");
        this.setRole(c, "h");
        rs = cStmt.executeQuery(select);
        rs.next();
        c.commit();
        this.doGrantRevoke(1, "test_dbo", g_s, "h");
        rs.next();
        rs.close();
        c.setAutoCommit(true);
        this.doGrantRevoke(0, "test_dbo", g_s, "h");
        s.execute("grant h to DonaldDuck");
        this.setRole(c, "h");
        rs = cStmt.executeQuery(select);
        rs.next();
        s.execute("revoke h from DonaldDuck");
        rs.next();
        rs.close();
        c.setAutoCommit(false);
        s.execute("grant h to DonaldDuck");
        this.setRole(c, "h");
        rs = cStmt.executeQuery(select);
        rs.next();
        c.commit();
        s.execute("revoke h from DonaldDuck");
        rs.next();
        rs.close();
        c.setAutoCommit(true);
        this.doGrantRevoke(1, "test_dbo", g_s, "h");
        this.doGrantRevoke(0, "test_dbo", g_s, "h");
        s.execute("grant h to DonaldDuck");
        this.setRole(c, "h");
        c.setAutoCommit(true);
        rs = cStmt.executeQuery(select);
        rs.next();
        this.setRole(c, "none");
        rs.next();
        rs.close();
        c.setAutoCommit(false);
        this.setRole(c, "h");
        rs = cStmt.executeQuery(select);
        rs.next();
        c.commit();
        this.setRole(c, "none");
        rs.next();
        rs.close();
        c.setAutoCommit(true);
        this.doGrantRevoke(1, "test_dbo", g_s, "h");
        s.executeUpdate("delete from s1.t1");
        c.close();
        dboConn.close();
    }

    public void testDefaultCurrentRole() throws SQLException {
        Connection dboConn = this.getConnection();
        Statement s = dboConn.createStatement();
        s.execute("grant h to DonaldDuck");
        Connection c = this.openUserConnection("DonaldDuck");
        Statement cStmt = c.createStatement();
        this.setRole(c, "h");
        cStmt.executeUpdate("create table t(role varchar(128) default current_role)");
        cStmt.executeUpdate("insert into t values default");
        ResultSet rs = cStmt.executeQuery("select * from t");
        JDBC.assertSingleValueResultSet(rs, "\"H\"");
        rs.close();
        cStmt.executeUpdate("drop table t");
        cStmt.executeUpdate("create table t(i int)");
        cStmt.executeUpdate("insert into t values 1");
        cStmt.executeUpdate("alter table t add column role varchar(10) default current_role");
        rs = cStmt.executeQuery("select * from t");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "\"H\""}});
        rs.close();
        cStmt.executeUpdate("drop table t");
        s.execute("grant execute on procedure s1.calledNested to DonaldDuck");
        if (!JDBC.vmSupportsJSR169()) {
            cStmt.executeUpdate("call s1.calledNested()");
        }
        this.setRole(c, "none");
        cStmt.close();
        s.execute("revoke h from DonaldDuck");
        s.execute("revoke execute on procedure s1.calledNested from DonaldDuck restrict");
        s.close();
        c.close();
        dboConn.close();
    }

    public void testCurrentRoleInWeirdContexts() throws SQLException {
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        Connection dboConn = this.getConnection();
        Statement s = dboConn.createStatement();
        this.setRole(dboConn, "a1");
        s.execute("create table trackCreds(usr varchar(30), role varchar(30))");
        s.executeUpdate("create table t(i int)");
        s.execute("grant insert on t to DonaldDuck");
        s.execute("grant h to DonaldDuck");
        s.execute("create trigger tr after insert on t insert into trackCreds values (current_user, current_role)");
        Connection c = this.openUserConnection("DonaldDuck");
        Statement cStmt = c.createStatement();
        this.setRole(c, "h");
        cStmt.executeUpdate("insert into test_dbo.t values 1");
        ResultSet rs = s.executeQuery("select * from trackCreds");
        JDBC.assertFullResultSet(rs, new String[][]{{"DONALDDUCK", "\"H\""}});
        rs.close();
        this.setRole(c, "none");
        cStmt.close();
        try {
            s.execute("create table strange(role varchar(30) check (role = current_role))");
            RolesConferredPrivilegesTest.fail((String)"current_role inside a check constraint should be denied");
        }
        catch (SQLException e) {
            RolesConferredPrivilegesTest.assertSQLState(UNRELIABLE, e);
        }
        s.execute("create table strange(i int)");
        s.execute("insert into strange values null");
        s.execute("alter table strange add constraint s check (s1.getCurrentRole() = '\"A1\"')");
        s.execute("revoke h from DonaldDuck");
        s.execute("revoke insert on t from DonaldDuck");
        this.setRole(dboConn, "none");
        s.execute("drop table trackCreds");
        s.execute("drop table t");
        s.execute("drop table strange");
        s.close();
        c.close();
        dboConn.close();
    }

    public static int s1f1() {
        return 0;
    }

    private void assertAllforRole(int hasPrivilege, Connection c, String grantee) throws SQLException {
        for (int i = 0; i < grantRevokes.length; ++i) {
            this.doGrantRevoke(0, "test_dbo", grantRevokes[i], grantee);
            this.assertEverything(hasPrivilege, c, null);
            this.doGrantRevoke(1, "test_dbo", grantRevokes[i], grantee);
            if (hasPrivilege != 2) continue;
            this.assertEverything(0, c, null);
        }
    }

    private void assertEverything(int hasPrivilege, String user, String role) throws SQLException {
        Connection c = this.openUserConnection(user);
        this.assertEverything(hasPrivilege, c, role);
        c.close();
    }

    private void assertEverything(int hasPrivilege, Connection c, String role) throws SQLException {
        if (role != null) {
            this.setRole(c, role);
        }
        String[] columns = new String[]{"c1", "c2"};
        String schema = "s1";
        String table = "t1";
        String function = "f1";
        this.assertSelectPrivilege(hasPrivilege, c, schema, table, columns);
        this.assertSelectPrivilege(hasPrivilege, c, schema, table, null);
        this.assertInsertPrivilege(hasPrivilege, c, schema, table, null);
        this.assertUpdatePrivilege(hasPrivilege, c, schema, table, columns);
        this.assertUpdatePrivilege(hasPrivilege, c, schema, table, null);
        this.assertDeletePrivilege(hasPrivilege, c, schema, table);
        this.assertReferencesPrivilege(hasPrivilege, c, schema, table, columns);
        this.assertReferencesPrivilege(hasPrivilege, c, schema, table, null);
        this.assertTriggerPrivilege(hasPrivilege, c, schema, table);
        this.assertExecutePrivilege(hasPrivilege, c, schema, function);
    }

    private void assertExecutePrivilege(int hasPrivilege, String user, String role, String schema, String function) throws SQLException {
        Connection c = this.openUserConnection(user);
        if (role != null) {
            this.setRole(c, role);
        }
        this.assertExecutePrivilege(hasPrivilege, c, schema, function);
        c.close();
    }

    private void assertExecutePrivilege(int hasPrivilege, Connection c, String schema, String function) throws SQLException {
        Statement stm = c.createStatement();
        try {
            ResultSet rs = stm.executeQuery("values " + schema + "." + function + "()");
            rs.next();
            rs.close();
            stm.close();
            if (hasPrivilege == 0) {
                RolesConferredPrivilegesTest.fail((String)("expected no EXECUTE privilege on function. " + RolesConferredPrivilegesTest.formatArgs(c, schema, function)));
            }
        }
        catch (SQLException e) {
            if (stm != null) {
                stm.close();
            }
            if (hasPrivilege == 0) {
                RolesConferredPrivilegesTest.assertSQLState(NOEXECUTEPERMISSION, e);
            }
            RolesConferredPrivilegesTest.fail("Unexpected lack of execute privilege. " + RolesConferredPrivilegesTest.formatArgs(c, schema, function), e);
        }
    }

    private void assertTriggerPrivilege(int hasPrivilege, String user, String role, String schema, String table) throws SQLException {
        Connection c = this.openUserConnection(user);
        if (role != null) {
            this.setRole(c, role);
        }
        this.assertTriggerPrivilege(hasPrivilege, c, schema, table);
        c.close();
    }

    private void assertTriggerPrivilege(int hasPrivilege, Connection c, String schema, String table) throws SQLException {
        Statement s = c.createStatement();
        String triggerName = table + "Trigger";
        try {
            int i = s.executeUpdate("create trigger " + triggerName + " after insert on " + schema + "." + table + " for each row values 1");
            if (hasPrivilege != 0) {
                RolesConferredPrivilegesTest.assertEquals((int)0, (int)i);
            }
            s.execute("drop trigger " + triggerName);
            if (hasPrivilege == 0) {
                RolesConferredPrivilegesTest.fail((String)("expected no TRIGGER privilege on table. " + RolesConferredPrivilegesTest.formatArgs(c, schema, table)));
            }
        }
        catch (SQLException e) {
            if (hasPrivilege == 0) {
                RolesConferredPrivilegesTest.assertSQLState(NOTABLEPERMISSION, e);
            }
            RolesConferredPrivilegesTest.fail("Unexpected lack of trigger privilege. " + RolesConferredPrivilegesTest.formatArgs(c, schema, table), e);
        }
        s.close();
        this.assertPrivilegeMetadata(hasPrivilege, c, "TRIGGER", schema, table, null);
    }

    private void assertReferencesPrivilege(int hasPrivilege, String user, String role, String schema, String table, String[] columns) throws SQLException {
        Connection c = this.openUserConnection(user);
        if (role != null) {
            this.setRole(c, role);
        }
        this.assertReferencesPrivilege(hasPrivilege, c, schema, table, columns);
        c.close();
    }

    private void assertReferencesPrivilege(int hasPrivilege, Connection c, String schema, String table, String[] columns) throws SQLException {
        Statement s = c.createStatement();
        columns = columns == null ? this.getAllColumns(schema, table) : columns;
        for (int i = 0; i < columns.length; ++i) {
            try {
                s.execute("create table referencestest (c1 int references " + schema + "." + table + "(" + columns[i] + "))");
                s.execute("drop table referencestest");
                if (hasPrivilege != 0) continue;
                RolesConferredPrivilegesTest.fail((String)("Unexpected references privilege. " + RolesConferredPrivilegesTest.formatArgs(c, schema, table, new String[]{columns[i]})));
                continue;
            }
            catch (SQLException e) {
                if (hasPrivilege == 0) {
                    RolesConferredPrivilegesTest.assertSQLState(NOCOLUMNPERMISSION, e);
                    continue;
                }
                RolesConferredPrivilegesTest.fail("Unexpected lack of references privilege. " + RolesConferredPrivilegesTest.formatArgs(c, schema, table, new String[]{columns[i]}), e);
            }
        }
        s.close();
        this.assertPrivilegeMetadata(hasPrivilege, c, "REFERENCES", schema, table, columns);
    }

    private void assertUpdatePrivilege(int hasPrivilege, String user, String role, String schema, String table, String[] columns) throws SQLException {
        Connection c = this.openUserConnection(user);
        if (role != null) {
            this.setRole(c, role);
        }
        this.assertUpdatePrivilege(hasPrivilege, c, schema, table, columns);
        c.close();
    }

    private void assertUpdatePrivilege(int hasPrivilege, Connection c, String schema, String table, String[] columns) throws SQLException {
        String[] checkColumns = columns == null ? this.getAllColumns(schema, table) : columns;
        Statement s = c.createStatement();
        int columnCount = 0;
        for (int i = 0; i < checkColumns.length; ++i) {
            boolean checkCount = false;
            try {
                try {
                    ResultSet countRS = s.executeQuery("select count(" + checkColumns[i] + ") from " + schema + "." + table);
                    if (!countRS.next()) {
                        RolesConferredPrivilegesTest.fail((String)("Could not get count on " + checkColumns[i] + " to verify update"));
                    }
                    columnCount = countRS.getInt(1);
                    checkCount = true;
                }
                catch (SQLException e) {
                    RolesConferredPrivilegesTest.assertSQLState(NOCOLUMNPERMISSION, e);
                }
                int actualCount = s.executeUpdate("update " + schema + "." + table + " set " + checkColumns[i] + "= 0");
                if (hasPrivilege != 0 && checkCount) {
                    RolesConferredPrivilegesTest.assertEquals((int)columnCount, (int)actualCount);
                }
                if (hasPrivilege != 0) continue;
                RolesConferredPrivilegesTest.fail((String)("expected no UPDATE privilege on  " + RolesConferredPrivilegesTest.formatArgs(c, schema, table, new String[]{checkColumns[i]})));
                continue;
            }
            catch (SQLException e) {
                if (hasPrivilege == 0) {
                    RolesConferredPrivilegesTest.assertSQLState(NOCOLUMNPERMISSION, e);
                    continue;
                }
                RolesConferredPrivilegesTest.fail((String)("Unexpected lack of privilege to update. " + RolesConferredPrivilegesTest.formatArgs(c, schema, table, new String[]{checkColumns[i]})));
            }
        }
        s.close();
        this.assertPrivilegeMetadata(hasPrivilege, c, "UPDATE", schema, table, columns);
    }

    private void assertInsertPrivilege(int hasPrivilege, String user, String role, String schema, String table, String[] columns) throws SQLException {
        Connection c = this.openUserConnection(user);
        if (role != null) {
            this.setRole(c, role);
        }
        this.assertInsertPrivilege(hasPrivilege, c, schema, table, columns);
        c.close();
    }

    private void assertInsertPrivilege(int hasPrivilege, Connection c, String schema, String table, String[] columns) throws SQLException {
        Statement s = c.createStatement();
        try {
            int i = s.executeUpdate("insert into " + schema + "." + table + " values (0,0,0)");
            if (hasPrivilege == 0) {
                RolesConferredPrivilegesTest.fail((String)("expected no INSERT privilege on table, " + RolesConferredPrivilegesTest.formatArgs(c, schema, table, columns)));
            }
        }
        catch (SQLException e) {
            if (hasPrivilege == 0) {
                RolesConferredPrivilegesTest.assertSQLState(NOTABLEPERMISSION, e);
            }
            RolesConferredPrivilegesTest.fail("Unexpected lack of insert privilege. " + RolesConferredPrivilegesTest.formatArgs(c, schema, table, columns), e);
        }
        s.close();
        this.assertPrivilegeMetadata(hasPrivilege, c, "INSERT", schema, table, columns);
    }

    private void assertSelectPrivilege(int hasPrivilege, String user, String role, String schema, String table, String[] columns) throws SQLException {
        Connection c = this.openUserConnection(user);
        if (role != null) {
            this.setRole(c, role);
        }
        this.assertSelectPrivilege(hasPrivilege, c, schema, table, columns);
        c.close();
    }

    private void assertSelectPrivilege(int hasPrivilege, Connection c, String schema, String table, String[] columns) throws SQLException {
        this.assertSelectPrivilege(hasPrivilege, c, schema, table, columns, NOCOLUMNPERMISSION);
    }

    private void assertSelectPrivilege(int hasPrivilege, Connection c, String schema, String table, String[] columns, String sqlState) throws SQLException {
        Statement s = c.createStatement();
        try {
            s.execute("select " + RolesConferredPrivilegesTest.columnListAsString(columns) + " from " + schema + "." + table);
            if (hasPrivilege == 0) {
                RolesConferredPrivilegesTest.fail((String)("expected no SELECT privilege on table " + RolesConferredPrivilegesTest.formatArgs(c, schema, table, columns)));
            }
        }
        catch (SQLException e) {
            if (hasPrivilege == 0) {
                RolesConferredPrivilegesTest.assertSQLState(sqlState, e);
            }
            RolesConferredPrivilegesTest.fail("Unexpected lack of select privilege. " + RolesConferredPrivilegesTest.formatArgs(c, schema, table, columns), e);
        }
        s.close();
        this.assertPrivilegeMetadata(hasPrivilege, c, "SELECT", schema, table, columns);
    }

    private void assertViewExists(boolean exists, Connection c, String table) throws SQLException {
        Statement s = c.createStatement();
        try {
            s.execute("select * from " + table);
            if (!exists) {
                RolesConferredPrivilegesTest.fail((String)("Table expected not to exist: " + table));
            }
        }
        catch (SQLException e) {
            if (exists) {
                RolesConferredPrivilegesTest.fail("Table expected to exist: " + table, e);
            }
            RolesConferredPrivilegesTest.assertSQLState(TABLENOTFOUND, e);
        }
        s.close();
    }

    private void assertTriggerExists(boolean exists, Connection c, String trigger) throws SQLException {
        Statement s = c.createStatement();
        try {
            s.execute("drop trigger " + trigger);
            if (!exists) {
                RolesConferredPrivilegesTest.fail((String)("Trigger expected not to exist: " + trigger));
            }
        }
        catch (SQLException e) {
            if (exists) {
                RolesConferredPrivilegesTest.fail("Trigger expected to exist: " + trigger, e);
            }
            RolesConferredPrivilegesTest.assertSQLState(OBJECTNOTFOUND, e);
        }
        s.close();
    }

    private void assertFkConstraintExists(boolean exists, Connection c, String table) throws SQLException {
        this.assertConstraintExists(exists, c, table, FKVIOLATION);
    }

    private void assertCheckConstraintExists(boolean exists, Connection c, String table) throws SQLException {
        this.assertConstraintExists(exists, c, table, CHECKCONSTRAINTVIOLATED);
    }

    private void assertConstraintExists(boolean exists, Connection c, String table, String sqlState) throws SQLException {
        Statement s = c.createStatement();
        try {
            s.execute("insert into " + table + " values (6,6,6)");
            s.execute("delete from " + table);
            if (exists) {
                RolesConferredPrivilegesTest.fail((String)("Table expected to have a constraint: " + table));
            }
        }
        catch (SQLException e) {
            if (!exists) {
                RolesConferredPrivilegesTest.fail("Table expected not to have a constraint: " + table, e);
            }
            RolesConferredPrivilegesTest.assertSQLState(sqlState, e);
        }
        s.close();
    }

    private void assertPsWorks(boolean works, PreparedStatement ps) throws SQLException {
        ps.getConnection().setAutoCommit(false);
        try {
            boolean b = ps.execute();
            ResultSet rs = ps.getResultSet();
            if (rs != null) {
                rs.next();
                rs.close();
            }
            ps.getConnection().rollback();
            ps.getConnection().setAutoCommit(true);
            if (!works) {
                RolesConferredPrivilegesTest.fail((String)"Prepared statement expected to fail.");
            }
        }
        catch (SQLException e) {
            ps.getConnection().setAutoCommit(true);
            if (works) {
                RolesConferredPrivilegesTest.fail("Prepared statement expected to work.", e);
            }
            this.assertSQLState(new String[]{NOCOLUMNPERMISSION, NOEXECUTEPERMISSION, NOTABLEPERMISSION}, e);
        }
    }

    private void assertDeletePrivilege(int hasPrivilege, String user, String role, String schema, String table) throws SQLException {
        Connection c = this.openUserConnection(user);
        if (role != null) {
            this.setRole(c, role);
        }
        this.assertDeletePrivilege(hasPrivilege, c, schema, table);
        c.close();
    }

    private void assertDeletePrivilege(int hasPrivilege, Connection c, String schema, String table) throws SQLException {
        Statement s = c.createStatement();
        try {
            s.execute("delete from " + schema + "." + table);
            if (hasPrivilege == 0) {
                RolesConferredPrivilegesTest.fail((String)("expected no DELETE privilege on table " + RolesConferredPrivilegesTest.formatArgs(c, schema, table)));
            }
        }
        catch (SQLException e) {
            if (hasPrivilege == 0) {
                RolesConferredPrivilegesTest.assertSQLState(NOTABLEPERMISSION, e);
            }
            RolesConferredPrivilegesTest.fail("Unexpected lack of delete privilege. " + RolesConferredPrivilegesTest.formatArgs(c, schema, table), e);
        }
        s.close();
        this.assertPrivilegeMetadata(hasPrivilege, c, "DELETE", schema, table, null);
    }

    private void assertPrivilegeMetadata(int hasPrivilege, Connection c, String type, String schema, String table, String[] columns) throws SQLException {
        Statement stm = c.createStatement();
        ResultSet rs = stm.executeQuery("values current_user");
        rs.next();
        String user = rs.getString(1);
        rs.close();
        stm.close();
        if (this.isOwner(schema, user)) {
            return;
        }
        if (hasPrivilege == 2) {
            return;
        }
        DatabaseMetaData dm = c.getMetaData();
        rs = dm.getTablePrivileges(null, JDBC.identifierToCNF(schema), JDBC.identifierToCNF(table));
        boolean found = false;
        if (columns == null) {
            while (rs.next()) {
                String privUser;
                RolesConferredPrivilegesTest.assertEquals((String)JDBC.identifierToCNF("test_dbo"), (String)rs.getString(4));
                RolesConferredPrivilegesTest.assertEquals((String)"NO", (String)rs.getString(7));
                if (!rs.getString(6).equals(type) || !(privUser = rs.getString(5)).equals(user) && !privUser.equals(JDBC.identifierToCNF("public"))) continue;
                found = true;
            }
            RolesConferredPrivilegesTest.assertEquals((hasPrivilege == 1 ? 1 : 0) != 0, (boolean)found);
            rs.close();
        }
        ResultSet cp = null;
        if (columns != null) {
            int noFound = 0;
            for (int i = 0; i < columns.length; ++i) {
                cp = dm.getColumnPrivileges(null, JDBC.identifierToCNF(schema), JDBC.identifierToCNF(table), JDBC.identifierToCNF(columns[i]));
                while (cp.next()) {
                    String privUser;
                    RolesConferredPrivilegesTest.assertEquals((String)JDBC.identifierToCNF("test_dbo"), (String)cp.getString(5));
                    RolesConferredPrivilegesTest.assertEquals((String)"NO", (String)cp.getString(8));
                    if (!cp.getString(7).equals(type) || !(privUser = cp.getString(6)).equals(user) && !privUser.equals(JDBC.identifierToCNF("public"))) continue;
                    ++noFound;
                }
            }
            if (hasPrivilege == 1) {
                RolesConferredPrivilegesTest.assertEquals((int)columns.length, (int)noFound);
            } else {
                RolesConferredPrivilegesTest.assertEquals((int)0, (int)noFound);
            }
        }
        if (cp != null) {
            cp.close();
        }
    }

    private boolean isOwner(String schema, String user) throws SQLException {
        Connection c = this.getConnection();
        Statement stm = c.createStatement();
        ResultSet rs = stm.executeQuery("select schemaname, authorizationid from sys.sysschemas where schemaname='" + JDBC.identifierToCNF(schema) + "'");
        rs.next();
        boolean result = rs.getString(2).equals(JDBC.identifierToCNF(user));
        rs.close();
        stm.close();
        return result;
    }

    private String[] getAllColumns(String schema, String table) throws SQLException {
        Connection c = this.getConnection();
        DatabaseMetaData dbmd = c.getMetaData();
        ArrayList<String> columnList = new ArrayList<String>();
        ResultSet rs = dbmd.getColumns(null, schema, table, null);
        while (rs.next()) {
            columnList.add(rs.getString(4));
        }
        return columnList.toArray(new String[0]);
    }

    private static String columnListAsString(String[] columns) {
        if (columns == null) {
            return "*";
        }
        StringBuffer sb = new StringBuffer(columns[0]);
        for (int i = 1; i < columns.length; ++i) {
            sb.append("," + columns[i]);
        }
        return sb.toString();
    }

    private static String formatArgs(Connection c, String schema, String table, String[] columns) throws SQLException {
        return RolesConferredPrivilegesTest.formatArgs(c, schema, table) + "(" + RolesConferredPrivilegesTest.columnListAsString(columns) + ")";
    }

    private static String formatArgs(Connection c, String schema, String dbObject) throws SQLException {
        Statement stm = c.createStatement();
        ResultSet rs = stm.executeQuery("values current_user");
        rs.next();
        String user = rs.getString(1);
        rs = c.createStatement().executeQuery("values current_role");
        rs.next();
        String role = rs.getString(1);
        rs.close();
        stm.close();
        return "User: " + user + (role == null ? "" : " Role: " + role) + " Object: " + schema + "." + dbObject;
    }

    private void setRole(Connection c, String role) throws SQLException {
        PreparedStatement ps;
        if (role.toUpperCase().equals("NONE")) {
            ps = c.prepareStatement("set role none");
        } else {
            ps = c.prepareStatement("set role ?");
            ps.setString(1, role);
        }
        ps.execute();
        ps.close();
    }

    private void doGrantRevoke(int action, String grantor, String[] actionStrings, String grantee, String[] warningExpected) throws SQLException {
        Connection c = this.openUserConnection(grantor);
        Statement s = c.createStatement();
        for (int i = 0; i < actionStrings.length; ++i) {
            s.execute((action == 0 ? "grant " : "revoke ") + actionStrings[i] + (action == 0 ? " to " : " from ") + grantee + (action == 1 && actionStrings[i].startsWith("execute") ? " restrict" : ""));
            if (warningExpected[i] == null) continue;
            RolesConferredPrivilegesTest.assertSQLState(warningExpected[i], s.getWarnings());
        }
        s.close();
        c.close();
    }

    private void doGrantRevoke(int action, String grantor, String[] actionStrings, String grantee) throws SQLException {
        String[] warns = new String[actionStrings.length];
        this.doGrantRevoke(action, grantor, actionStrings, grantee, warns);
    }

    private void doGrantRevoke(int action, String grantor, String actionString, String grantee, String warningExpected) throws SQLException {
        this.doGrantRevoke(action, grantor, new String[]{actionString}, grantee, new String[]{warningExpected});
    }

    private void doGrantRevoke(int action, String grantor, String actionString, String grantee) throws SQLException {
        this.doGrantRevoke(action, grantor, new String[]{actionString}, grantee);
    }

    private String CNFUser2user(String CNFUser) {
        for (int i = 0; i < users.length; ++i) {
            if (!JDBC.identifierToCNF(users[i]).equals(CNFUser)) continue;
            return users[i];
        }
        RolesConferredPrivilegesTest.fail((String)"test error");
        return null;
    }

    private void assertSQLState(String[] ok_states, SQLException e) {
        String state = e.getSQLState();
        boolean found = false;
        for (int i = 0; i < ok_states.length; ++i) {
            if (!ok_states[i].equals(state)) continue;
            found = true;
        }
        if (!found) {
            StringBuffer b = new StringBuffer();
            b.append("Exception ");
            b.append(state);
            b.append(" found, one of ");
            for (int i = 0; i < ok_states.length; ++i) {
                b.append(ok_states[i]);
                if (i == ok_states.length - 1) continue;
                b.append('|');
            }
            b.append(" expected");
            RolesConferredPrivilegesTest.fail((String)b.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void calledNested() throws SQLException {
        Connection c = null;
        try {
            c = DriverManager.getConnection("jdbc:default:connection");
            Statement cStmt = c.createStatement();
            cStmt.executeUpdate("create table t(role varchar(128) default current_role)");
            cStmt.executeUpdate("insert into t values default");
            ResultSet rs = cStmt.executeQuery("select * from t");
            JDBC.assertSingleValueResultSet(rs, "\"H\"");
            rs.close();
            cStmt.executeUpdate("drop table t");
            cStmt.executeUpdate("create table t(i int)");
            cStmt.executeUpdate("insert into t values 1");
            cStmt.executeUpdate("alter table t add column role varchar(10) default current_role");
            rs = cStmt.executeQuery("select * from t");
            JDBC.assertFullResultSet(rs, new String[][]{{"1", "\"H\""}});
            rs.close();
            cStmt.executeUpdate("drop table t");
            cStmt.close();
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentRole() throws SQLException {
        Connection c = null;
        try {
            c = DriverManager.getConnection("jdbc:default:connection");
            Statement cStmt = c.createStatement();
            ResultSet rs = cStmt.executeQuery("values current_role");
            rs.next();
            String result = rs.getString(1);
            rs.close();
            cStmt.close();
            String string = result;
            return string;
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

