/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ReleaseCompileLocksTest
extends BaseJDBCTestCase {
    public ReleaseCompileLocksTest(String name) {
        super(name);
    }

    protected void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
    }

    protected void setUp() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.execute("create function dmlstatic() returns INT parameter style java language java external name 'org.apache.derbyTesting.functionTests.util.StaticInitializers.DMLInStaticInitializer.getANumber' no sql");
        stmt.execute("create function insertstatic() returns INT parameter style java language java external name 'org.apache.derbyTesting.functionTests.util.StaticInitializers.InsertInStaticInitializer.getANumber' no sql");
        stmt.close();
        this.commit();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ReleasecompileLocksTest");
        suite.addTest(ReleaseCompileLocksTest.baseSuite("ReleaseCompileLocksTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(ReleaseCompileLocksTest.baseSuite("ReleaseCompileLocksTest:client")));
        return suite;
    }

    protected static Test baseSuite(String name) {
        TestSuite suite = new TestSuite(name);
        suite.addTestSuite(ReleaseCompileLocksTest.class);
        return new CleanDatabaseTestSetup((Test)suite){

            protected void decorateSQL(Statement s) throws SQLException {
                s.execute("create table t1 (s int)");
            }
        };
    }

    public void testReleaseCompileLocks() throws Exception {
        Statement stmt = this.createStatement();
        if (JDBC.vmSupportsJDBC3()) {
            JDBC.assertFullResultSet(stmt.executeQuery("select (dmlstatic()) from sys.systables where CAST(tablename AS VARCHAR(128))= 'SYSCONGLOMERATES'"), new String[][]{{"1"}});
        } else {
            JDBC.assertFullResultSet(stmt.executeQuery("select count(*) from sys.systables where CAST(tablename AS VARCHAR(128)) = 'SYSCONGLOMERATES'"), new String[][]{{"1"}});
        }
        JDBC.assertEmpty(stmt.executeQuery("select TYPE, MODE, TABLENAME, LOCKNAME, STATE from syscs_diag.lock_table order by 1"));
        this.commit();
        stmt.execute("drop table t1");
        stmt.execute("create table t1 (s int)");
        this.commit();
        if (JDBC.vmSupportsJDBC3()) {
            JDBC.assertFullResultSet(stmt.executeQuery("select (insertstatic()) from sys.systables where CAST(tablename AS VARCHAR(128)) = 'SYSCONGLOMERATES'"), new String[][]{{"1"}});
        } else {
            JDBC.assertFullResultSet(stmt.executeQuery("select count(*) from sys.systables where CAST(tablename AS VARCHAR(128)) = 'SYSCONGLOMERATES'"), new String[][]{{"1"}});
        }
        JDBC.assertEmpty(stmt.executeQuery("select TYPE, MODE, TABLENAME, LOCKNAME, STATE from syscs_diag.lock_table order by 1"));
        JDBC.assertEmpty(stmt.executeQuery("select * from t1"));
        stmt.execute("drop table t1");
        this.commit();
        JDBC.assertEmpty(stmt.executeQuery("select TYPE, MODE, TABLENAME, LOCKNAME, STATE from syscs_diag.lock_table order by 1"));
        this.commit();
        stmt.execute("create table test_tab (x int)");
        stmt.executeUpdate("insert into test_tab values (1)");
        this.commit();
        JDBC.assertSingleValueResultSet(stmt.executeQuery("select count(*) from syscs_diag.lock_table"), "0");
        JDBC.assertSingleValueResultSet(stmt.executeQuery("select count(*) from sys.sysviews"), "0");
        JDBC.assertSingleValueResultSet(stmt.executeQuery("select count(*) from syscs_diag.lock_table"), "0");
        stmt.execute("insert into test_tab values (2)");
        ResultSet rs = stmt.executeQuery("select TYPE, MODE, TABLENAME, LOCKNAME, STATE from syscs_diag.lock_table order by 1");
        String[][] expectedValues = new String[][]{{"ROW", "X", "TEST_TAB", "(1,8)", "GRANT"}, {"TABLE", "IX", "TEST_TAB", "Tablelock", "GRANT"}};
        JDBC.assertFullResultSet(rs, expectedValues);
        try {
            stmt.execute("drop table t1");
            ReleaseCompileLocksTest.fail((String)"expected SQLException; table t should not exist");
        }
        catch (SQLException e) {
            ReleaseCompileLocksTest.assertSQLState("42Y55", e);
        }
        stmt.execute("create table t1 (x int)");
        this.commit();
        JDBC.assertEmpty(stmt.executeQuery("select * from t1"));
        Connection conn1 = this.openDefaultConnection();
        Statement stmt2 = conn1.createStatement();
        stmt2.execute("create table t2 (x int)");
        stmt2.execute("drop table t2");
        stmt2.close();
        conn1.commit();
        conn1.close();
        stmt.execute("drop table test_tab");
        stmt.execute("create table test_tab (x int)");
        stmt.execute("insert into test_tab values (1)");
        this.commit();
        PreparedStatement ps = this.prepareStatement("update test_tab set x=2 where x=?");
        ps.setCursorName("cursor1");
        ps.setInt(1, 1);
        JDBC.assertSingleValueResultSet(stmt.executeQuery("select count(*) from syscs_diag.lock_table"), "0");
        ps.executeUpdate();
        rs = stmt.executeQuery("select TYPE, MODE, TABLENAME, LOCKNAME, STATE from syscs_diag.lock_table order by 1");
        String[][] expectedValues1 = new String[][]{{"ROW", "X", "TEST_TAB", "(1,7)", "GRANT"}, {"TABLE", "IX", "TEST_TAB", "Tablelock", "GRANT"}};
        JDBC.assertFullResultSet(rs, expectedValues1);
        this.commit();
        stmt.execute("create table t (c1 int not null primary key, c2 int references t)");
        stmt.executeUpdate("insert into t values (1,1)");
        stmt.executeUpdate("insert into t values (2,1)");
        this.commit();
        ps = this.prepareStatement("select * from t where c1 = ? and c2 = ?");
        ps.setCursorName("ps");
        JDBC.assertEmpty(stmt.executeQuery("select * from syscs_diag.lock_table"));
        stmt.execute("create table x(c1 int)");
        stmt.execute("drop table x");
        this.commit();
        ps = this.prepareStatement("insert into t values (3,2)");
        ps.setCursorName("pi");
        JDBC.assertEmpty(stmt.executeQuery("select * from syscs_diag.lock_table"));
        this.commit();
        stmt.execute("create table x(c1 int)");
        stmt.execute("drop table x");
        this.commit();
        ps = this.prepareStatement("update t set c2 = c1, c1 = c2");
        ps.setCursorName("p1");
        JDBC.assertEmpty(stmt.executeQuery("select * from syscs_diag.lock_table"));
        this.commit();
        stmt.execute("create table x(c1 int)");
        stmt.execute("drop table x");
        this.commit();
        ps = this.prepareStatement("delete from t");
        ps.setCursorName("p1");
        JDBC.assertEmpty(stmt.executeQuery("select * from syscs_diag.lock_table"));
        this.commit();
        stmt.execute("create trigger update_of_t after update on t for each row values 2");
        stmt.execute("create trigger insert_of_t after insert on t for each row values 3");
        this.commit();
        ps = this.prepareStatement("update t set c2=2 where c1=2");
        ps.setCursorName("pu");
        JDBC.assertEmpty(stmt.executeQuery("select * from syscs_diag.lock_table"));
        this.commit();
        rs.close();
        ps.close();
        stmt.close();
    }
}

