/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;

public class GroupByTest
extends BaseJDBCTestCase {
    String[][] expRS;
    String[] expColNames;
    private static char[] chars = new char[]{'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', 'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', 'z', 'x', 'c', 'v', 'b', 'n', 'm'};

    public GroupByTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup((Test)new TestSuite(GroupByTest.class, "GroupByTest")){

            protected void decorateSQL(Statement s) throws SQLException {
                GroupByTest.createSchemaObjects(s);
            }
        };
    }

    private static void createSchemaObjects(Statement st) throws SQLException {
        st.executeUpdate("create table bug280 (a int, b int)");
        st.executeUpdate("insert into bug280 (a, b) values (1,1), (1,2), (1,3), (2,1), (2,2)");
        st.executeUpdate("CREATE TABLE A2937 (C CHAR(10) NOT NULL, D DATE NOT NULL, DC DECIMAL(6,2))");
        st.executeUpdate("INSERT INTO A2937 VALUES ('aaa', DATE('2007-07-10'), 500.00)");
        st.executeUpdate("create table yy (a double, b double)");
        st.executeUpdate("insert into yy values (2,4), (2, 4), (5,7), (2,3), (2,3), (2,3), (2,3), (9,7)");
        st.executeUpdate("create table t1 (a int, b int, c int)");
        st.executeUpdate("create table t2 (a int, b int, c int)");
        st.executeUpdate("insert into t2 values (1,1,1), (2,2,2)");
        st.executeUpdate("create table unmapped(c1 long varchar)");
        st.executeUpdate("create table t_twoints(c1 int, c2 int)");
        st.executeUpdate("create table t5920(c int, d int)");
        st.executeUpdate("insert into t5920(c,d) values (1,10),(2,20),(2,20),(3,30),(3,30),(3,30)");
        st.executeUpdate("create table t5653 (c1 float)");
        st.executeUpdate("insert into t5653 values 0.0, 90.0");
        st.executeUpdate("create table d3613 (a int, b int, c int, d int)");
        st.executeUpdate("insert into d3613 values (1,2,1,2), (1,2,3,4), (1,3,5,6), (2,2,2,2)");
        st.executeUpdate("create table d2085 (a int, b int, c int, d int)");
        st.executeUpdate("insert into d2085 values (1,1,1,1), (1,2,3,4), (4,3,2,1), (2,2,2,2)");
        st.execute("create table d3219 (a varchar(10), b varchar(1000))");
        st.execute("CREATE TABLE d3904_T1( D1 DATE NOT NULL PRIMARY KEY, N1 VARCHAR( 10 ))");
        st.execute("CREATE TABLE d3904_T2( D2 DATE NOT NULL PRIMARY KEY, N2 VARCHAR( 10 ))");
        st.execute("INSERT INTO d3904_T1 VALUES ( DATE( '2008-10-01' ), 'something' ), ( DATE( '2008-10-02' ), 'something' )");
        st.execute("INSERT INTO d3904_T2 VALUES( DATE( '2008-10-01' ), 'something' )");
        st.executeUpdate("create table d2457_o (name varchar(20), ord int)");
        st.executeUpdate("create table d2457_a (ord int, amount int)");
        st.executeUpdate("insert into d2457_o values ('John', 1), ('Jerry', 2), ('Jerry', 3), ('John', 4), ('John', 5)");
        st.executeUpdate("insert into d2457_a values (1, 12), (2, 23), (3, 34), (4, 45), (5, 56)");
        st.executeUpdate("create table d4071(i int, v char(10))");
        st.executeUpdate("insert into d4071        values (1, '0123456789'),              (1, '1234567890'),              (3, '2345678901'),              (4, '0123456789'),              (5, '1234567890')");
        st.executeUpdate("create table t (i int, s smallint, l bigint, c char(10), v varchar(50), lvc long varchar, d double precision, r real, dt date, t time, ts timestamp, b char(2) for bit data, bv varchar(2) for bit data, lbv long varchar for bit data)");
        st.executeUpdate(" create table tab1 ( i integer, s smallint, l bigint, c char(30), v varchar(30), lvc long varchar, d double precision, r real, dt date, t time, ts timestamp)");
        st.executeUpdate("insert into t (i) values (null)");
        st.executeUpdate("insert into t (i) values (null)");
        st.executeUpdate(" insert into t values (0, 100, 1000000, 'hello', 'everyone is here', 'what the heck do we care?', 200.0e0, 200.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (0, 100, 1000000, 'hello', 'everyone is here', 'what the heck do we care?', 200.0e0, 200.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (1, 100, 1000000, 'hello', 'everyone is here', 'what the heck do we care?', 200.0e0, 200.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (0, 200, 1000000, 'hello', 'everyone is here', 'what the heck do we care?', 200.0e0, 200.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (0, 100, 2000000, 'hello', 'everyone is here', 'what the heck do we care?', 200.0e0, 200.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (0, 100, 1000000, 'goodbye', 'everyone is here', 'adios, muchachos', 200.0e0, 200.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (0, 100, 1000000, 'hello', 'noone is here', 'what the heck do we care?', 200.0e0, 200.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (0, 100, 1000000, 'hello', 'everyone is here', 'what the heck do we care?', 200.0e0, 200.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (0, 100, 1000000, 'hello', 'everyone is here', 'what the heck do we care?', 100.0e0, 200.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (0, 100, 1000000, 'hello', 'everyone is here', 'what the heck do we care?', 200.0e0, 100.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (0, 100, 1000000, 'hello', 'everyone is here', 'what the heck do we care?', 200.0e0, 200.0e0, date('1992-09-09'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (0, 100, 1000000, 'hello', 'everyone is here', 'what the heck do we care?', 200.0e0, 200.0e0, date('1992-01-01'), time('12:55:55'), timestamp('1992-01-01 12:30:30'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (0, 100, 1000000, 'hello', 'everyone is here', 'what the heck do we care?', 200.0e0, 200.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:55:55'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (0, 100, 1000000, 'hello', 'everyone is here', 'what the heck do we care?', 200.0e0, 200.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'ffff', X'0f0f', X'1234')");
        st.executeUpdate(" insert into t values (0, 100, 1000000, 'hello', 'everyone is here', 'what the heck do we care?', 200.0e0, 200.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'12af', X'ffff', X'ABCD')");
        st.executeUpdate("insert into tab1 select i, s, l, c, v, lvc, d, r, dt, t, ts from t");
        st.executeUpdate("CREATE TABLE EMPTAB (EMPID INTEGER NOT NULL, SALARY DECIMAL(10, 4), DEPT_DEPTNO INTEGER)");
        st.executeUpdate("ALTER TABLE EMPTAB ADD CONSTRAINT PK_EMPTAB PRIMARY KEY (EMPID)");
        st.executeUpdate("CREATE TABLE DEPTTAB (DEPTNO INTEGER NOT NULL)");
        st.executeUpdate("ALTER TABLE DEPTTAB ADD CONSTRAINT PK_DEPTTAB PRIMARY KEY (DEPTNO)");
        st.executeUpdate("insert into DEPTTAB values( 1 )");
        st.executeUpdate("insert into EMPTAB values( 1, 1000, 1 )");
        st.executeUpdate("CREATE TABLE T1_D3880(i int, c varchar(20))");
        st.executeUpdate("create table t2_D3880(i int, c2 varchar(20), i2 int)");
        st.executeUpdate("insert into t1_D3880 values(1, 'abc')");
        st.executeUpdate("insert into t1_D3880 values(2, 'abc')");
        st.executeUpdate("insert into t2_D3880 values(1, 'xyz', 10)");
        st.executeUpdate("insert into t2_D3880 values(1, 'aaa', 20)");
        st.executeUpdate("insert into t2_D3880 values(2, 'xxx', 30)");
        st.executeUpdate("CREATE FUNCTION MAXOF2(ONE DOUBLE, TWO DOUBLE) RETURNS DOUBLE PARAMETER STYLE JAVA NO SQL LANGUAGE JAVA EXTERNAL NAME 'java.lang.Math.max'");
        st.executeUpdate("CREATE TABLE Testd3631( GroupCol INT, Value1 INT, Value2 INT )");
        st.executeUpdate("INSERT INTO Testd3631 VALUES (1, 1, 5)");
        st.executeUpdate("INSERT INTO Testd3631 VALUES (2, -7, 2)");
        st.executeUpdate("INSERT INTO Testd3631 VALUES (2, 1, -5)");
    }

    public void testGroupByErrors() throws Exception {
        Statement st = this.createStatement();
        GroupByTest.assertStatementError("42Y36", st, "select * from t1 group by 1");
        GroupByTest.assertStatementError("42X04", st, "select a as d from t1 group by d");
        GroupByTest.assertStatementError("42Y36", st, "select a as b from t1 group by b");
        GroupByTest.assertStatementError("42Y36", st, " select a from t1 group by b");
        GroupByTest.assertStatementError("42Y36", st, " select a, char(b) from t1 group by a");
        this.assertCompileError("42Y90", "select a from t1 group by a for update");
        GroupByTest.assertStatementError("21000", st, "select a, (select a from t2) from t1 group by a");
        GroupByTest.assertStatementError("42Y30", st, "select t2.a, (select b from t1 where t1.b = t2.b) from t1 t2 group by t2.a");
        GroupByTest.assertStatementError("42X24", st, "select a from t1 group by a having c = 1");
        GroupByTest.assertStatementError("42X04", st, " select a from t1 o group by a having a = (select a from t1 where b = b.o)");
        GroupByTest.assertStatementError("42X01", st, "select a from t1 group by ?");
        GroupByTest.assertStatementError("X0X67", st, " select c1, max(1) from unmapped group by c1");
        st.close();
    }

    public void testGroupByWithVariousDatatypes() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select i from t group by i order by i");
        this.expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0"}, {"1"}, {null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select s from t group by s order by s");
        this.expColNames = new String[]{"S"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"100"}, {"200"}, {null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select l from t group by l order by l");
        this.expColNames = new String[]{"L"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"1000000"}, {"2000000"}, {null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select c from t group by c order by c");
        this.expColNames = new String[]{"C"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"goodbye"}, {"hello"}, {null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select v from t group by v order by v");
        this.expColNames = new String[]{"V"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"everyone is here"}, {"noone is here"}, {null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select d from t group by d order by d");
        this.expColNames = new String[]{"D"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"100.0"}, {"200.0"}, {null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select r from t group by r order by r");
        this.expColNames = new String[]{"R"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"100.0"}, {"200.0"}, {null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select dt from t group by dt order by dt");
        this.expColNames = new String[]{"DT"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"1992-01-01"}, {"1992-09-09"}, {null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select t from t group by t order by t");
        this.expColNames = new String[]{"T"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"12:30:30"}, {"12:55:55"}, {null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select ts from t group by ts order by ts");
        this.expColNames = new String[]{"TS"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"1992-01-01 12:30:30.0"}, {"1992-01-01 12:55:55.0"}, {null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select b from t group by b order by b");
        this.expColNames = new String[]{"B"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"12af"}, {"ffff"}, {null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select bv from t group by bv order by bv");
        this.expColNames = new String[]{"BV"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0f0f"}, {"ffff"}, {null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        GroupByTest.assertStatementError("X0X67", st, "select lbv from t group by lbv order by lbv");
        st.close();
    }

    public void testMulticolumnGrouping() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select i, dt, b from t where 1=1 group by i, dt, b order by i,dt,b");
        this.expColNames = new String[]{"I", "DT", "B"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", "12af"}, {"0", "1992-01-01", "ffff"}, {"0", "1992-09-09", "12af"}, {"1", "1992-01-01", "12af"}, {null, null, null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select i, dt, b from t group by i, dt, b order by i,dt,b");
        this.expColNames = new String[]{"I", "DT", "B"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", "12af"}, {"0", "1992-01-01", "ffff"}, {"0", "1992-09-09", "12af"}, {"1", "1992-01-01", "12af"}, {null, null, null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select i, dt, b from t group by b, i, dt order by i,dt,b");
        this.expColNames = new String[]{"I", "DT", "B"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", "12af"}, {"0", "1992-01-01", "ffff"}, {"0", "1992-09-09", "12af"}, {"1", "1992-01-01", "12af"}, {null, null, null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select i, dt, b from t group by dt, i, b order by i,dt,b");
        this.expColNames = new String[]{"I", "DT", "B"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", "12af"}, {"0", "1992-01-01", "ffff"}, {"0", "1992-09-09", "12af"}, {"1", "1992-01-01", "12af"}, {null, null, null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        st.close();
    }

    public void testGroupByExpression() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select expr1, expr2 from (select i * s, c || v from t) t (expr1, expr2) group by expr2, expr1 order by expr2,expr1");
        this.expColNames = new String[]{"EXPR1", "EXPR2"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "goodbye   everyone is here"}, {"0", "hello     everyone is here"}, {"100", "hello     everyone is here"}, {"0", "hello     noone is here"}, {null, null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        st.close();
    }

    public void testGroupByCorrelatedSubquery() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select i, expr1 from (select i, (select distinct i from t m where m.i = t.i) from t) t (i, expr1) group by i, expr1 order by i,expr1");
        this.expColNames = new String[]{"I", "EXPR1"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "0"}, {"1", "1"}, {null, null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        st.close();
    }

    public void testGroupByDistinct() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select distinct i, dt, b from t group by i, dt, b order by i,dt,b");
        this.expColNames = new String[]{"I", "DT", "B"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", "12af"}, {"0", "1992-01-01", "ffff"}, {"0", "1992-09-09", "12af"}, {"1", "1992-01-01", "12af"}, {null, null, null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        st.close();
    }

    public void testGroupByOrderBy() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select i, dt, b from t group by i, dt, b order by i, dt, b");
        this.expColNames = new String[]{"I", "DT", "B"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", "12af"}, {"0", "1992-01-01", "ffff"}, {"0", "1992-09-09", "12af"}, {"1", "1992-01-01", "12af"}, {null, null, null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery("select i, dt, b from t group by i, dt, b order by i, dt");
        this.expColNames = new String[]{"I", "DT", "B"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", "12af"}, {"0", "1992-01-01", "ffff"}, {"0", "1992-09-09", "12af"}, {"1", "1992-01-01", "12af"}, {null, null, null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery("select i, dt, b from t group by i, dt, b order by b, dt, i");
        this.expColNames = new String[]{"I", "DT", "B"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", "12af"}, {"1", "1992-01-01", "12af"}, {"0", "1992-09-09", "12af"}, {"0", "1992-01-01", "ffff"}, {null, null, null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery("select i, dt, b from t group by i, dt, b order by b, dt");
        this.expColNames = new String[]{"I", "DT", "B"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", "12af"}, {"1", "1992-01-01", "12af"}, {"0", "1992-09-09", "12af"}, {"0", "1992-01-01", "ffff"}, {null, null, null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        st.close();
    }

    public void testGroupByInSubquery() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select * from (select i, dt from t group by i, dt) t (t_i, t_dt), (select i, dt from t group by i, dt) m (m_i, m_dt) where t_i = m_i and t_dt = m_dt order by t_i,t_dt,m_i,m_dt");
        this.expColNames = new String[]{"T_I", "T_DT", "M_I", "M_DT"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", "0", "1992-01-01"}, {"0", "1992-09-09", "0", "1992-09-09"}, {"1", "1992-01-01", "1", "1992-01-01"}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select * from (select i, dt from t group by i, dt) t (t_i, t_dt), (select i, dt from t group by i, dt) m (m_i, m_dt) group by t_i, t_dt, m_i, m_dt order by t_i,t_dt,m_i,m_dt");
        this.expColNames = new String[]{"T_I", "T_DT", "M_I", "M_DT"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", "0", "1992-01-01"}, {"0", "1992-01-01", "0", "1992-09-09"}, {"0", "1992-01-01", "1", "1992-01-01"}, {"0", "1992-01-01", null, null}, {"0", "1992-09-09", "0", "1992-01-01"}, {"0", "1992-09-09", "0", "1992-09-09"}, {"0", "1992-09-09", "1", "1992-01-01"}, {"0", "1992-09-09", null, null}, {"1", "1992-01-01", "0", "1992-01-01"}, {"1", "1992-01-01", "0", "1992-09-09"}, {"1", "1992-01-01", "1", "1992-01-01"}, {"1", "1992-01-01", null, null}, {null, null, "0", "1992-01-01"}, {null, null, "0", "1992-09-09"}, {null, null, "1", "1992-01-01"}, {null, null, null, null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select * from (select i, dt from t group by i, dt) t (t_i, t_dt), (select i, dt from t group by i, dt) m (m_i, m_dt) where t_i = m_i and t_dt = m_dt group by t_i, t_dt, m_i, m_dt order by t_i,t_dt,m_i,m_dt");
        this.expColNames = new String[]{"T_I", "T_DT", "M_I", "M_DT"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", "0", "1992-01-01"}, {"0", "1992-09-09", "0", "1992-09-09"}, {"1", "1992-01-01", "1", "1992-01-01"}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select t.*, m.* from (select i, dt from t group by i, dt) t (t_i, t_dt), (select i, dt from t group by i, dt) m (t_i, t_dt) where t.t_i = m.t_i and t.t_dt = m.t_dt group by t.t_i, t.t_dt, m.t_i, m.t_dt order by t.t_i,t.t_dt,m.t_i,m.t_dt");
        this.expColNames = new String[]{"T_I", "T_DT", "T_I", "T_DT"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", "0", "1992-01-01"}, {"0", "1992-09-09", "0", "1992-09-09"}, {"1", "1992-01-01", "1", "1992-01-01"}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select t.t_i, t.t_dt, m.* from (select i, dt from t group by i, dt) t (t_i, t_dt), (select i, dt from t group by i, dt) m (t_i, t_dt) where t.t_i = m.t_i and t.t_dt = m.t_dt group by t.t_i, t.t_dt, m.t_i, m.t_dt order by t.t_i,t.t_dt,m.t_i,m.t_dt");
        this.expColNames = new String[]{"T_I", "T_DT", "T_I", "T_DT"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", "0", "1992-01-01"}, {"0", "1992-09-09", "0", "1992-09-09"}, {"1", "1992-01-01", "1", "1992-01-01"}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        st.close();
    }

    public void testGroupByWithAdditionalColumns() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select i, dt, b from t group by i, dt, b order by i,dt,b");
        this.expColNames = new String[]{"I", "DT", "B"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", "12af"}, {"0", "1992-01-01", "ffff"}, {"0", "1992-09-09", "12af"}, {"1", "1992-01-01", "12af"}, {null, null, null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select t.i from t group by i, dt, b order by i");
        this.expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0"}, {"0"}, {"0"}, {"1"}, {null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select t.dt from t group by i, dt, b order by dt");
        this.expColNames = new String[]{"DT"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"1992-01-01"}, {"1992-01-01"}, {"1992-01-01"}, {"1992-09-09"}, {null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select t.b from t group by i, dt, b order by b");
        this.expColNames = new String[]{"B"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"12af"}, {"12af"}, {"12af"}, {"ffff"}, {null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select t.t_i, m.t_i from (select i, dt from t group by i, dt) t (t_i, t_dt), (select i, dt from t group by i, dt) m (t_i, t_dt) where t.t_i = m.t_i and t.t_dt = m.t_dt group by t.t_i, t.t_dt, m.t_i, m.t_dt order by t.t_i,m.t_i");
        this.expColNames = new String[]{"T_I", "T_I"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "0"}, {"0", "0"}, {"1", "1"}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        st.close();
    }

    public void testParameterMarkersInHavingClause() throws Exception {
        ResultSet rs = null;
        PreparedStatement pSt = this.prepareStatement("select i, dt, b from t group by i, dt, b having i = ? order by i,dt,b");
        pSt.setInt(1, 0);
        rs = pSt.executeQuery();
        this.expColNames = new String[]{"I", "DT", "B"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", "12af"}, {"0", "1992-01-01", "ffff"}, {"0", "1992-09-09", "12af"}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        pSt.close();
    }

    public void testHavingClauseInSubquery() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select * from (select i, dt from t group by i, dt having 1=1) t (t_i, t_dt), (select i, dt from t group by i, dt having i = 0) m (m_i, m_dt) where t_i = m_i and t_dt = m_dt order by t_i,t_dt,m_i,m_dt");
        this.expColNames = new String[]{"T_I", "T_DT", "M_I", "M_DT"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", "0", "1992-01-01"}, {"0", "1992-09-09", "0", "1992-09-09"}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select * from (select i, dt from t group by i, dt having 1=1) t (t_i, t_dt), (select i, dt from t group by i, dt having i = 0) m (m_i, m_dt) group by t_i, t_dt, m_i, m_dt order by t_i,t_dt,m_i,m_dt");
        this.expColNames = new String[]{"T_I", "T_DT", "M_I", "M_DT"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", "0", "1992-01-01"}, {"0", "1992-01-01", "0", "1992-09-09"}, {"0", "1992-09-09", "0", "1992-01-01"}, {"0", "1992-09-09", "0", "1992-09-09"}, {"1", "1992-01-01", "0", "1992-01-01"}, {"1", "1992-01-01", "0", "1992-09-09"}, {null, null, "0", "1992-01-01"}, {null, null, "0", "1992-09-09"}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select * from (select i, dt from t group by i, dt having 1=1) t (t_i, t_dt), (select i, dt from t group by i, dt having i = 0) m (m_i, m_dt) where t_i = m_i and t_dt = m_dt group by t_i, t_dt, m_i, m_dt having t_i * m_i = m_i * t_i order by t_i,t_dt,m_i,m_dt");
        this.expColNames = new String[]{"T_I", "T_DT", "M_I", "M_DT"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", "0", "1992-01-01"}, {"0", "1992-09-09", "0", "1992-09-09"}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery("select  q1.DEPTNO from DEPTTAB q1, EMPTAB q2 where ( integer (1.1) = 1)  and  ( q2.DEPT_DEPTNO = q1.DEPTNO)  GROUP BY q1.DEPTNO HAVING  max( q2.SALARY) >=  ( select  q3.SALARY from EMPTAB q3 where  (q3.EMPID =  q1.DEPTNO) )");
        this.expRS = new String[][]{{"1"}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        st.close();
    }

    public void testCorrelatedSubqueryInHavingClause() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select i, dt from t group by i, dt having i = (select distinct i from tab1 where t.i = tab1.i) order by i,dt");
        this.expColNames = new String[]{"I", "DT"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01"}, {"0", "1992-09-09"}, {"1", "1992-01-01"}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select i, dt from t group by i, dt having i = (select i from t m group by i having t.i = m.i) order by i,dt");
        this.expColNames = new String[]{"I", "DT"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01"}, {"0", "1992-09-09"}, {"1", "1992-01-01"}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        st.close();
    }

    public void testHavingClauseColumnRef() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select i as outer_i, dt from t group by i, dt having i = (select i from t m group by i having t.i = m.i) order by outer_i,dt");
        this.expColNames = new String[]{"OUTER_I", "DT"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01"}, {"0", "1992-09-09"}, {"1", "1992-01-01"}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        st.close();
    }

    public void testGroupByColumnsNotInSelectList() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select i, dt from t group by i, dt order by i,dt");
        this.expColNames = new String[]{"I", "DT"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01"}, {"0", "1992-09-09"}, {"1", "1992-01-01"}, {null, null}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select t.dt from t group by i, dt having i = 0 order by t.dt");
        this.expColNames = new String[]{"DT"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"1992-01-01"}, {"1992-09-09"}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select t.dt from t group by i, dt having i <> 0 order by t.dt");
        this.expColNames = new String[]{"DT"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"1992-01-01"}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery(" select t.dt from t group by i, dt having i != 0 order by t.dt");
        this.expColNames = new String[]{"DT"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"1992-01-01"}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        st.close();
    }

    public void testInvalidHavingClauses() throws Exception {
        Statement st = this.createStatement();
        GroupByTest.assertStatementError("42X19", st, "select 1 from t_twoints having 1");
        GroupByTest.assertStatementError("42Y35", st, "select * from t_twoints having c1 = 1");
        GroupByTest.assertStatementError("42X24", st, " select 1 from t_twoints having c1 = 1");
        GroupByTest.assertStatementError("42Y35", st, "select * from t_twoints t1_outer having 1 = (select 1 from t_twoints where c1 = t1_outer.c1)");
        st.close();
    }

    public void testHavingClauseRestrictions5653() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select 1 from t5653 having 1=0");
        this.expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, this.expColNames);
        JDBC.assertDrainResults(rs, 0);
        GroupByTest.assertStatementError("42Y35", st, "select * from t5653 having 1=1");
        GroupByTest.assertStatementError("42Y35", st, "select c1 from t5653 having 1=1");
        GroupByTest.assertStatementError("42Y35", st, "select sqrt(c1) from t5653 having 1=1");
        GroupByTest.assertStatementError("42Y35", st, "select * from t5653 having 1 = (select 1 from t5653 where c1 = 0.0)");
        GroupByTest.assertStatementError("42Y35", st, "select (c1 * c1) / c1 from t5653 where c1 <> 0 having 1=1");
        GroupByTest.assertStatementError("42Y35", st, "select * from t5653 having 1 between 1 and 2");
        st.close();
    }

    public void testHavingWithoutGroupBy5920() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery(" select avg(c) from t5920 having 1 < 2");
        this.expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"2"}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery("select 10 from t5920 having 1 < 2");
        this.expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"10"}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        rs = st.executeQuery("select 10,avg(c) from t5920 having 1 < 2");
        this.expColNames = new String[]{"1", "2"};
        JDBC.assertColumnNames(rs, this.expColNames);
        this.expRS = new String[][]{{"10", "2"}};
        JDBC.assertFullResultSet(rs, this.expRS, true);
        st.close();
    }

    public void testGroupByWithTempTable() throws SQLException {
        Statement s = this.createStatement();
        s.execute("declare global temporary table session.ztemp ( orderID varchar( 50 ) ) not logged");
        JDBC.assertEmpty(s.executeQuery("select orderID from session.ztemp group by orderID"));
    }

    public void testHavingWithInnerJoinDerby3880() throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("select   t1_D3880.i, avg(t2_D3880.i2)  from t1_D3880 inner join t2_D3880 on (t1_D3880.i = t2_D3880.i) group by t1_D3880.i having avg(t2_D3880.i2) > 0");
        String[][] expRs = new String[][]{{"1", "15"}, {"2", "30"}};
        JDBC.assertFullResultSet(rs, expRs);
    }

    public void testGroupByWithAliasToSameName() throws SQLException {
        Statement s = this.createStatement();
        String[][] expected1 = new String[][]{{"1", "3"}, {"2", "2"}};
        JDBC.assertUnorderedResultSet(s.executeQuery("select a, count(a) from bug280 group by a"), expected1);
        JDBC.assertUnorderedResultSet(s.executeQuery("select a, count(a) as a from bug280 group by a"), expected1);
        String[][] expected2 = new String[][]{{"1", "3", "1"}, {"2", "2", "2"}};
        JDBC.assertUnorderedResultSet(s.executeQuery("select a, count(a), a from bug280 group by a"), expected2);
        String[][] expected3 = new String[][]{{"1", "1"}, {"1", "1"}, {"1", "1"}, {"2", "2"}, {"2", "2"}};
        JDBC.assertFullResultSet(s.executeQuery("select t.t_i, m.t_i from (select a, b from bug280 group by a, b) t (t_i, t_dt), (select a, b from bug280 group by a, b) m (t_i, t_dt) where t.t_i = m.t_i and t.t_dt = m.t_dt group by t.t_i, t.t_dt, m.t_i, m.t_dt order by t.t_i,m.t_i"), expected3);
        String[][] expected4 = new String[][]{{"1", "1"}, {"2", "2"}};
        JDBC.assertUnorderedResultSet(s.executeQuery("select a, a from bug280 group by a"), expected4);
        JDBC.assertUnorderedResultSet(s.executeQuery("select bug280.a, a from bug280 group by a"), expected4);
        JDBC.assertUnorderedResultSet(s.executeQuery("select bug280.a, bug280.a from bug280 group by a"), expected4);
        JDBC.assertUnorderedResultSet(s.executeQuery("select a, bug280.a from bug280 group by a"), expected4);
        s.close();
    }

    public void testDERBY2937() throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("SELECT A.C, SUBSTR (MAX(CAST(A.D AS CHAR(10)) || CAST(A.DC AS CHAR(8))), 11, 8) AS BUG FROM A2937 A GROUP BY A.C");
        JDBC.assertFullResultSet(rs, new String[][]{{"aaa", "500.00"}});
    }

    public void testDerbyOrderByOnAggregate() throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("select b, count(*) from yy where a=5 or a=2 group by b order by count(*) desc");
        JDBC.assertFullResultSet(rs, new Object[][]{{new Double(3.0), new Integer(4)}, {new Double(4.0), new Integer(2)}, {new Double(7.0), new Integer(1)}}, false);
        rs = s.executeQuery("select b, count(*) from yy where a=5 or a=2 group by b order by count(*) asc");
        JDBC.assertFullResultSet(rs, new Object[][]{{new Double(7.0), new Integer(1)}, {new Double(4.0), new Integer(2)}, {new Double(3.0), new Integer(4)}}, false);
    }

    public void testOrNodeInHavingClause() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE TAB ( ID VARCHAR(20), INFO VARCHAR(20))");
        s.executeUpdate("insert into TAB values  ('1', 'A')");
        s.executeUpdate("insert into TAB values  ('2', 'A')");
        s.executeUpdate("insert into TAB values  ('3', 'B')");
        s.executeUpdate("insert into TAB values  ('4', 'B')");
        ResultSet rs = s.executeQuery("SELECT t0.INFO, COUNT(t0.ID) FROM TAB t0 GROUP BY t0.INFO HAVING (t0.INFO = 'A' OR t0.INFO = 'B') AND t0.INFO IS NOT NULL");
        String[][] expectedRows = new String[][]{{"A", "2"}, {"B", "2"}};
        JDBC.assertFullResultSet(rs, expectedRows);
        s.executeUpdate("DROP TABLE TAB");
    }

    public void testDistinctGroupBy() throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("select distinct a from d3613 group by a");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"2"}, {"1"}});
        rs = s.executeQuery("select distinct a from d3613 group by a,b");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"2"}, {"1"}});
        rs = s.executeQuery("select a,b from d3613");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "2"}, {"1", "2"}, {"1", "3"}, {"2", "2"}});
        rs = s.executeQuery("select distinct a,b from d3613 group by a,b,c");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "2"}, {"1", "3"}, {"2", "2"}});
        rs = s.executeQuery("select distinct a,b from d3613 group by a,b");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "2"}, {"1", "3"}, {"2", "2"}});
        rs = s.executeQuery("select distinct a,b from d3613 group by a,c,b");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "2"}, {"1", "3"}, {"2", "2"}});
        rs = s.executeQuery("select a,sum(b) from d3613 group by a,b");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "4"}, {"1", "3"}, {"2", "2"}});
        rs = s.executeQuery("select distinct a,sum(b) from d3613 group by a,b");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "4"}, {"1", "3"}, {"2", "2"}});
        rs = s.executeQuery("select a,sum(b) from d3613 group by a,c");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "2"}, {"1", "2"}, {"1", "3"}, {"2", "2"}});
        rs = s.executeQuery("select distinct a,sum(b) from d3613 group by a,c");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "2"}, {"1", "3"}, {"2", "2"}});
        rs = s.executeQuery("select a,sum(b) from d3613 group by a,b,c");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "2"}, {"1", "2"}, {"1", "3"}, {"2", "2"}});
        rs = s.executeQuery("select distinct a,sum(b) from d3613 group by a,b,c");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "2"}, {"1", "3"}, {"2", "2"}});
        rs = s.executeQuery("select distinct a,sum(b) from d3613 group by a");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "7"}, {"2", "2"}});
        GroupByTest.assertStatementError("42Y36", s, "select distinct a,b from d3613 group by a");
        GroupByTest.assertStatementError("42Y36", s, "select distinct a,b from d3613 group by a,c");
        GroupByTest.assertStatementError("42Y36", s, "select distinct a,b,sum(b) from d3613 group by a");
        JDBC.assertFullResultSet(s.executeQuery("select distinct t.t_i, m.t_i from (select a, b from bug280 group by a, b) t (t_i, t_dt), (select a, b from bug280 group by a, b) m (t_i, t_dt) where t.t_i = m.t_i and t.t_dt = m.t_dt group by t.t_i, t.t_dt, m.t_i, m.t_dt order by t.t_i,m.t_i"), new String[][]{{"1", "1"}, {"2", "2"}});
        JDBC.assertFullResultSet(s.executeQuery(" select distinct t.i from t group by i, dt, b order by i"), new String[][]{{"0"}, {"1"}, {null}});
        JDBC.assertFullResultSet(s.executeQuery(" select distinct t.dt from t group by i, dt, b order by dt"), new String[][]{{"1992-01-01"}, {"1992-09-09"}, {null}});
    }

    public void testOrderByNonGroupedColumn() throws SQLException {
        Statement s = this.createStatement();
        GroupByTest.assertStatementError("42Y36", s, "select a from d2085 group by a order by b");
        GroupByTest.assertStatementError("42Y36", s, "select a from d2085 group by a,b order by c");
        GroupByTest.assertStatementError("42Y36", s, "select a,b from d2085 group by a,b order by c*2");
    }

    public void testGroupByMaxWithEmptyString() throws SQLException {
        boolean wasSet = false;
        Statement st = this.createStatement();
        this.loadRows();
        ResultSet rs = st.executeQuery("select b,max(a) from d3219 group by b");
        while (rs.next()) {
        }
    }

    private void loadRows() throws SQLException {
        PreparedStatement ps = this.prepareStatement("insert into d3219 (a, b) values ('', ?)");
        for (int i = 0; i < 2000; ++i) {
            ps.setString(1, GroupByTest.genString(1000));
            ps.executeUpdate();
        }
    }

    private static String genString(int len) {
        StringBuffer buf = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            buf.append(chars[(int)((double)chars.length * Math.random())]);
        }
        return buf.toString();
    }

    public void testColumnAliasInGroupByAndHaving() throws SQLException {
        Statement s = this.createStatement();
        JDBC.assertUnorderedResultSet(s.executeQuery("select name, count(ord) from d2457_o  group by name having count(ord) > 2"), new String[][]{{"John", "3"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select name as col1, count(ord) as col2  from d2457_o group by name having count(ord) > 2"), new String[][]{{"John", "3"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select name as col1, count(ord) as col2  from d2457_o ordertable group by name  having count(ord) > 2"), new String[][]{{"John", "3"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select ordertable.name as col1,  count(ord) as col2 from d2457_o ordertable  group by name having count(ord) > 2"), new String[][]{{"John", "3"}});
        GroupByTest.assertStatementError("42X04", s, "select name as col1, count(ord) as col2 from d2457_o  group by name having col2 > 2");
        GroupByTest.assertStatementError("42X04", s, "select name as col1, count(ord) as col2 from d2457_o  group by col1 having col2 > 2");
        GroupByTest.assertStatementError("42X04", s, "select name as col1, count(ord) as col2 from d2457_o  group by col1 having count(ord) > 2");
        GroupByTest.assertStatementError("42X04", s, "select name as col1, sum(amount) as col2  from d2457_o, d2457_a where d2457_o.ord = d2457_a.ord  group by col1 having col2 > 2");
        GroupByTest.assertStatementError("42X04", s, "select name as col1, sum(amount) as col2  from d2457_o t1, d2457_a t2 where t1.ord = t2.ord  group by col1 having col2 > 2");
        GroupByTest.assertStatementError("42X04", s, "select name as col1, sum(amount) as col2  from d2457_o t1, d2457_a t2 where t1.ord = t2.ord  group by col1 having sum(amount) > 2");
        GroupByTest.assertStatementError("42X04", s, "select name as col1, sum(amount) as col2  from d2457_o t1, d2457_a t2 where t1.ord = t2.ord  group by col1 having col2 > 2");
        GroupByTest.assertStatementError("42X04", s, "select * from (select t1.name as col, sum(amount)  from d2457_o t1, d2457_a t2 where t1.ord = t2.ord  group by col) as t12(col1, col2) where col2 > 2");
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from (select name, count(ord) from d2457_o ordertable  group by ordertable.name) as ordertable(col1, col2)  where col2 > 2"), new String[][]{{"John", "3"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from (select name as col, sum(amount)  from d2457_o t1, d2457_a t2 where t1.ord = t2.ord  group by name) as t12(col1, col2) where col2 > 2"), new String[][]{{"Jerry", "57"}, {"John", "113"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select t1.name as col1,  sum(t2.amount) as col2 from d2457_o t1, d2457_a t2  where t1.ord = t2.ord group by t1.name  having sum(t2.amount) > 2"), new String[][]{{"Jerry", "57"}, {"John", "113"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select name as col1, sum(amount) as col2  from d2457_o t1, d2457_a t2 where t1.ord = t2.ord  group by name having sum(amount) > 2"), new String[][]{{"Jerry", "57"}, {"John", "113"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select t1.name as col1, sum(amount) as col2  from d2457_o t1, d2457_a t2 where t1.ord = t2.ord  group by name having sum(amount) > 2"), new String[][]{{"Jerry", "57"}, {"John", "113"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select name as col1, sum(t2.amount) as col2  from d2457_o t1, d2457_a t2 where t1.ord = t2.ord  group by name having sum(amount) > 2"), new String[][]{{"Jerry", "57"}, {"John", "113"}});
    }

    public void testSetOperationsAndGroupBy() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("CREATE TABLE D3764A (A1 INTEGER, A2 VARCHAR(10))");
        int[] valuesA = new int[]{1, 2, 3, 4, 5, 6, 5, 3, 1};
        PreparedStatement insertA = this.prepareStatement("INSERT INTO D3764A (A1) VALUES (?)");
        for (int i = 0; i < valuesA.length; ++i) {
            insertA.setInt(1, valuesA[i]);
            insertA.executeUpdate();
        }
        s.execute("CREATE TABLE D3764B (B1 INTEGER, B2 VARCHAR(10))");
        int[] valuesB = new int[]{1, 2, 3, 3, 7, 9};
        PreparedStatement insertB = this.prepareStatement("INSERT INTO D3764B (B1) VALUES (?)");
        for (int i = 0; i < valuesB.length; ++i) {
            insertB.setInt(1, valuesB[i]);
            insertB.executeUpdate();
        }
        String[] singleColumnQueries = new String[]{"SELECT A1 FROM D3764A", "SELECT COUNT(A1) FROM D3764A", "SELECT COUNT(A1) FROM D3764A GROUP BY A1", "SELECT COUNT(A1) FROM D3764A GROUP BY A2", "SELECT COUNT(A1) FROM D3764A GROUP BY A1, A2", "SELECT B1 FROM D3764B", "SELECT COUNT(B1) FROM D3764B", "SELECT COUNT(B1) FROM D3764B GROUP BY B1", "SELECT COUNT(B1) FROM D3764B GROUP BY B2", "SELECT COUNT(B1) FROM D3764B GROUP BY B1, B2", "VALUES 1, 2, 3, 4"};
        String[][][] singleColumnExpected = new String[][][]{{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}, {"5"}, {"3"}, {"1"}}, {{Integer.toString(valuesA.length)}}, {{"2"}, {"1"}, {"2"}, {"1"}, {"2"}, {"1"}}, {{Integer.toString(valuesA.length)}}, {{"2"}, {"1"}, {"2"}, {"1"}, {"2"}, {"1"}}, {{"1"}, {"2"}, {"3"}, {"3"}, {"7"}, {"9"}}, {{Integer.toString(valuesB.length)}}, {{"1"}, {"1"}, {"2"}, {"1"}, {"1"}}, {{Integer.toString(valuesB.length)}}, {{"1"}, {"1"}, {"2"}, {"1"}, {"1"}}, {{"1"}, {"2"}, {"3"}, {"4"}}};
        GroupByTest.doAllSetOperations(s, singleColumnQueries, singleColumnExpected);
        String[] twoColumnQueries = new String[]{"SELECT A1-1, A1+1 FROM D3764A", "SELECT COUNT(A1), A1 FROM D3764A GROUP BY A1", "SELECT COUNT(A1), LENGTH(A2) FROM D3764A GROUP BY A2", "SELECT COUNT(A1), A1 FROM D3764A GROUP BY A1, A2", "SELECT B1-1, B1+1 FROM D3764B", "SELECT COUNT(B1), B1 FROM D3764B GROUP BY B1", "SELECT COUNT(B1), LENGTH(B2) FROM D3764B GROUP BY B2", "SELECT COUNT(B1), B1 FROM D3764B GROUP BY B1, B2", "VALUES (1, 2), (3, 4)"};
        String[][][] twoColumnExpected = new String[][][]{{{"0", "2"}, {"1", "3"}, {"2", "4"}, {"3", "5"}, {"4", "6"}, {"5", "7"}, {"4", "6"}, {"2", "4"}, {"0", "2"}}, {{"2", "1"}, {"1", "2"}, {"2", "3"}, {"1", "4"}, {"2", "5"}, {"1", "6"}}, {{Integer.toString(valuesA.length), null}}, {{"2", "1"}, {"1", "2"}, {"2", "3"}, {"1", "4"}, {"2", "5"}, {"1", "6"}}, {{"0", "2"}, {"1", "3"}, {"2", "4"}, {"2", "4"}, {"6", "8"}, {"8", "10"}}, {{"1", "1"}, {"1", "2"}, {"2", "3"}, {"1", "7"}, {"1", "9"}}, {{Integer.toString(valuesB.length), null}}, {{"1", "1"}, {"1", "2"}, {"2", "3"}, {"1", "7"}, {"1", "9"}}, {{"1", "2"}, {"3", "4"}}};
        GroupByTest.doAllSetOperations(s, twoColumnQueries, twoColumnExpected);
        GroupByTest.assertSetOpErrors("42X58", s, singleColumnQueries, twoColumnQueries);
        GroupByTest.assertSetOpErrors("42X58", s, twoColumnQueries, singleColumnQueries);
    }

    private static void doAllSetOperations(Statement s, String[] queries, String[][][] expectedResults) throws SQLException {
        GroupByTest.assertEquals((int)queries.length, (int)expectedResults.length);
        for (int i = 0; i < queries.length; ++i) {
            String query1 = queries[i];
            List rows1 = GroupByTest.resultArrayToList(expectedResults[i]);
            for (int j = 0; j < queries.length; ++j) {
                String query2 = queries[j];
                List rows2 = GroupByTest.resultArrayToList(expectedResults[j]);
                String query = query1 + " UNION " + query2;
                String[][] rows = GroupByTest.union(rows1, rows2, false);
                JDBC.assertUnorderedResultSet(s.executeQuery(query), rows);
                query = query1 + " UNION ALL " + query2;
                rows = GroupByTest.union(rows1, rows2, true);
                JDBC.assertUnorderedResultSet(s.executeQuery(query), rows);
                query = query1 + " EXCEPT " + query2;
                rows = GroupByTest.except(rows1, rows2, false);
                JDBC.assertUnorderedResultSet(s.executeQuery(query), rows);
                query = query1 + " EXCEPT ALL " + query2;
                rows = GroupByTest.except(rows1, rows2, true);
                JDBC.assertUnorderedResultSet(s.executeQuery(query), rows);
                query = query1 + " INTERSECT " + query2;
                rows = GroupByTest.intersect(rows1, rows2, false);
                JDBC.assertUnorderedResultSet(s.executeQuery(query), rows);
                query = query1 + " INTERSECT ALL " + query2;
                rows = GroupByTest.intersect(rows1, rows2, true);
                JDBC.assertUnorderedResultSet(s.executeQuery(query), rows);
            }
        }
    }

    private static void assertSetOpErrors(String sqlState, Statement s, String[] queries1, String[] queries2) throws SQLException {
        String[] operators = new String[]{" UNION ", " UNION ALL ", " EXCEPT ", " EXCEPT ALL ", " INTERSECT ", " INTERSECT ALL "};
        for (int i = 0; i < queries1.length; ++i) {
            for (int j = 0; j < queries2.length; ++j) {
                for (int k = 0; k < operators.length; ++k) {
                    GroupByTest.assertStatementError(sqlState, s, queries1[i] + operators[k] + queries2[j]);
                }
            }
        }
    }

    private static String[][] union(Collection rows1, Collection rows2, boolean all) {
        Collection bagOrSet = GroupByTest.newBagOrSet(all);
        bagOrSet.addAll(rows1);
        bagOrSet.addAll(rows2);
        return GroupByTest.toResultArray(bagOrSet);
    }

    private static String[][] except(Collection rows1, Collection rows2, boolean all) {
        Collection bagOrSet = GroupByTest.newBagOrSet(all);
        bagOrSet.addAll(rows1);
        Iterator it = rows2.iterator();
        while (it.hasNext()) {
            bagOrSet.remove(it.next());
        }
        return GroupByTest.toResultArray(bagOrSet);
    }

    private static String[][] intersect(Collection rows1, Collection rows2, boolean all) {
        Collection bagOrSet = GroupByTest.newBagOrSet(all);
        ArrayList copyOfRows2 = new ArrayList(rows2);
        Iterator it = rows1.iterator();
        while (it.hasNext()) {
            Object x = it.next();
            if (!copyOfRows2.remove(x)) continue;
            bagOrSet.add(x);
        }
        return GroupByTest.toResultArray(bagOrSet);
    }

    private static Collection newBagOrSet(boolean bag) {
        if (bag) {
            return new ArrayList();
        }
        return new HashSet();
    }

    private static String[][] toResultArray(Collection rows) {
        String[][] results = new String[rows.size()][];
        Iterator it = rows.iterator();
        for (int i = 0; i < results.length; ++i) {
            List row = (List)it.next();
            results[i] = row.toArray(new String[row.size()]);
        }
        return results;
    }

    private static List resultArrayToList(String[][] results) {
        ArrayList<List<String>> rows = new ArrayList<List<String>>(results.length);
        for (int i = 0; i < results.length; ++i) {
            rows.add(Arrays.asList(results[i]));
        }
        return rows;
    }

    public void testDerby3904MinMaxOptimization() throws SQLException {
        Statement s = this.createStatement();
        JDBC.assertFullResultSet(s.executeQuery("SELECT d3904_T1.D1 FROM d3904_T1 LEFT JOIN d3904_T2 ON d3904_T1.D1 = d3904_T2.D2 WHERE d3904_T2.D2 IS NULL"), new String[][]{{"2008-10-02"}});
        JDBC.assertFullResultSet(s.executeQuery("SELECT MAX( d3904_T1.D1 ) as D FROM d3904_T1 WHERE d3904_T1.D1 NOT IN ( SELECT d3904_T2.D2 FROM d3904_T2 )"), new String[][]{{"2008-10-02"}});
        JDBC.assertFullResultSet(s.executeQuery("SELECT MAX( d3904_T1.D1 ) AS D FROM d3904_T1 LEFT JOIN d3904_T2 ON d3904_T1.D1 = d3904_T2.D2 WHERE d3904_T2.D2 IS NULL"), new String[][]{{"2008-10-02"}});
        s.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        JDBC.assertFullResultSet(s.executeQuery("SELECT MAX(D1) FROM D3904_T1"), new String[][]{{"2008-10-02"}});
        RuntimeStatisticsParser rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        GroupByTest.assertTrue((boolean)rtsp.usedLastKeyIndexScan());
        GroupByTest.assertFalse((boolean)rtsp.usedIndexRowToBaseRow());
        JDBC.assertFullResultSet(s.executeQuery("SELECT MAX(D1) FROM d3904_T1, D3904_T2 WHERE d3904_T1.D1='2008-10-02'"), new String[][]{{"2008-10-02"}});
    }

    public void testDerby3631AggregateInGroupByQuery() throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("SELECT GroupCol, MAXOF2(CAST(SUM(Value1) AS DOUBLE), CAST(SUM(Value2) AS DOUBLE)) AS MaxOf2 FROM Testd3631 GROUP BY GroupCol ");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "5.0"}, {"2", "-3.0"}});
        rs = s.executeQuery("SELECT GroupCol, MAXOF2(SUM(Value1), SUM(Value2)) AS MaxOf2 FROM Testd3631 GROUP BY GroupCol");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "5.0"}, {"2", "-3.0"}});
    }

    public void testDerby4071AggregateOnGroupByColumnInHaving() throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("SELECT MAX(i), COUNT(T.V) FROM d4071 T     GROUP BY T.V HAVING COUNT(T.V) > 1");
        JDBC.assertFullResultSet(rs, new String[][]{{"4", "2"}, {"5", "2"}});
    }
}

