/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SavepointJdbc30Test
extends BaseJDBCTestCase {
    public SavepointJdbc30Test(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("SavepointJdbc30_JSR169Test suite");
        TestSuite embedded = new TestSuite("SavepointJdbc30_JSR169Test:embedded");
        embedded.addTestSuite(SavepointJdbc30Test.class);
        embedded.addTest(SavepointJdbc30Test.getEmbeddedSuite("SavepointJdbc30_JSR169Test:embedded only"));
        suite.addTest((Test)embedded);
        TestSuite client = new TestSuite("SavepointJdbc30_JSR169Test:client");
        client.addTestSuite(SavepointJdbc30Test.class);
        suite.addTest(TestConfiguration.clientServerDecorator((Test)client));
        if (JDBC.vmSupportsJDBC3()) {
            embedded = new TestSuite("SavepointJdbc30_JSR169Test:embedded XADataSource");
            embedded.addTestSuite(SavepointJdbc30Test.class);
            embedded.addTest(SavepointJdbc30Test.getEmbeddedSuite("SavepointJdbc30_JSR169Test:embedded only XADataSource"));
            suite.addTest((Test)TestConfiguration.connectionXADecorator((Test)embedded));
            client = new TestSuite("SavepointJdbc30_JSR169Test:client XADatasource");
            client.addTestSuite(SavepointJdbc30Test.class);
            suite.addTest(TestConfiguration.clientServerDecorator((Test)TestConfiguration.connectionXADecorator((Test)client)));
        }
        return new CleanDatabaseTestSetup((Test)suite){

            protected void decorateSQL(Statement s) throws SQLException {
                s.execute("create table t1 (c11 int, c12 smallint)");
                s.execute("create table t2 (c11 int)");
                this.getConnection().commit();
            }
        };
    }

    private static Test getEmbeddedSuite(String name) {
        TestSuite embedded = new TestSuite(name);
        Method[] methods = SavepointJdbc30Test.class.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String methodName;
            Method m = methods[i];
            if (m.getParameterTypes().length > 0 || !m.getReturnType().equals(Void.TYPE) || !(methodName = m.getName()).startsWith("x")) continue;
            embedded.addTest((Test)new SavepointJdbc30Test(methodName));
        }
        return embedded;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.getConnection().setAutoCommit(false);
    }

    public void testNoSavepointsIfAutoCommit() throws SQLException {
        Connection con = this.getConnection();
        con.setAutoCommit(true);
        try {
            con.setSavepoint();
            SavepointJdbc30Test.fail((String)"No unnamed savepoints allowed if autocommit is true");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("XJ010", se);
        }
        try {
            con.setSavepoint("notallowed");
            SavepointJdbc30Test.fail((String)"No named savepoints allowed if autocommit is true");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("XJ010", se);
        }
    }

    public void testReusingSavepoints() throws SQLException {
        Connection con = this.getConnection();
        Savepoint savepoint1 = con.setSavepoint("s1");
        con.releaseSavepoint(savepoint1);
        con.setSavepoint("s1");
        con.rollback();
    }

    public void testNullName() throws SQLException {
        Connection con = this.getConnection();
        try {
            con.setSavepoint(null);
            SavepointJdbc30Test.fail((String)"FAIL 3 Null savepoint");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("XJ011", se);
        }
        con.rollback();
    }

    public void testNamesAndIds() throws SQLException {
        Savepoint savepoint1;
        Connection con = this.getConnection();
        try {
            savepoint1 = con.setSavepoint();
            savepoint1.getSavepointId();
            savepoint1.getSavepointName();
            SavepointJdbc30Test.fail((String)"FAIL 4 getSavepointName on id savepoint");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("XJ014", se);
        }
        con.rollback();
        try {
            savepoint1 = con.setSavepoint("s1");
            savepoint1.getSavepointName();
            savepoint1.getSavepointId();
            SavepointJdbc30Test.fail((String)"FAIL 4 getSavepointId on named savepoint ");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("XJ013", se);
        }
        con.rollback();
    }

    public void testBug4465() throws SQLException {
        Connection con = this.getConnection();
        Savepoint savepoint1 = con.setSavepoint("s1");
        con.commit();
        con.setSavepoint("s2");
        Statement s = this.createStatement();
        s.executeUpdate("INSERT INTO T1 VALUES(2,1)");
        try {
            con.releaseSavepoint(savepoint1);
            SavepointJdbc30Test.fail((String)"FAIL 5a - release savepoint from a different transaction did not raise error");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("3B001", se);
        }
        con.commit();
        savepoint1 = con.setSavepoint("s1");
        con.commit();
        con.setSavepoint("s2");
        s.executeUpdate("INSERT INTO T1 VALUES(2,1)");
        try {
            con.rollback(savepoint1);
            SavepointJdbc30Test.fail((String)"FAIL 5b - rollback savepoint from a different transaction did not raise error");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("3B001", se);
        }
        con.commit();
    }

    public void testReleaseReleasedSavepoint() throws SQLException {
        Connection con = this.getConnection();
        Savepoint savepoint1 = con.setSavepoint("s1");
        con.releaseSavepoint(savepoint1);
        con.setSavepoint("s2");
        Statement s = this.createStatement();
        s.executeUpdate("INSERT INTO T1 VALUES(2,1)");
        try {
            con.releaseSavepoint(savepoint1);
            SavepointJdbc30Test.fail((String)"FAIL 6a - releasing a released savepoint did not raise error");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("3B001", se);
        }
        con.commit();
    }

    public void testRollbackReleasedSavepoint() throws SQLException {
        Connection con = this.getConnection();
        Savepoint savepoint1 = con.setSavepoint("s1");
        con.releaseSavepoint(savepoint1);
        con.setSavepoint("s2");
        Statement s = this.createStatement();
        s.executeUpdate("INSERT INTO T1 VALUES(2,1)");
        try {
            con.rollback(savepoint1);
            SavepointJdbc30Test.fail((String)"FAIL 6b - rollback a released savepoint did not raise error");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("3B001", se);
        }
        con.commit();
    }

    public void testReleaseSavepointFromOtherTransaction() throws SQLException {
        Connection con2;
        Connection con;
        block3: {
            con = this.getConnection();
            Savepoint savepoint1 = con.setSavepoint("s1");
            Statement s = this.createStatement();
            s.executeUpdate("INSERT INTO T1 VALUES(2,1)");
            con2 = this.openDefaultConnection();
            try {
                con2.releaseSavepoint(savepoint1);
                SavepointJdbc30Test.fail((String)"FAIL 6c - releasing another transaction's savepoint did not raise error");
            }
            catch (SQLException se) {
                if (SavepointJdbc30Test.usingEmbedded()) {
                    SavepointJdbc30Test.assertSQLState("XJ010", se);
                }
                if (!SavepointJdbc30Test.usingDerbyNetClient()) break block3;
                SavepointJdbc30Test.assertSQLState("XJ008", se);
            }
        }
        con.commit();
        con2.commit();
    }

    public void testSwapSavepointsAcrossConnectionAndRelease() throws SQLException {
        Connection con2;
        Connection con;
        block3: {
            con = this.getConnection();
            con2 = this.openDefaultConnection();
            con2.setAutoCommit(false);
            Savepoint savepoint1 = con2.setSavepoint("s1");
            Statement s = this.createStatement();
            s.executeUpdate("INSERT INTO T1 VALUES(2,1)");
            con.setSavepoint("s1");
            try {
                con.releaseSavepoint(savepoint1);
                SavepointJdbc30Test.fail((String)"FAIL 7a - releasing a another transaction's savepoint did not raise error");
            }
            catch (SQLException se) {
                if (SavepointJdbc30Test.usingEmbedded()) {
                    SavepointJdbc30Test.assertSQLState("3B502", se);
                }
                if (!SavepointJdbc30Test.usingDerbyNetClient()) break block3;
                SavepointJdbc30Test.assertSQLState("XJ097", se);
            }
        }
        con.commit();
        con2.commit();
    }

    public void testSwapSavepointsAcrossConnectionsAndRollback() throws SQLException {
        Connection con2;
        Connection con;
        block3: {
            con = this.getConnection();
            con2 = this.openDefaultConnection();
            con2.setAutoCommit(false);
            Savepoint savepoint1 = con2.setSavepoint("s1");
            Statement s = this.createStatement();
            s.executeUpdate("INSERT INTO T1 VALUES(2,1)");
            con.setSavepoint("s1");
            try {
                con.rollback(savepoint1);
                SavepointJdbc30Test.fail((String)"FAIL 7b - rolling back a another transaction's savepoint did not raise error");
            }
            catch (SQLException se) {
                if (SavepointJdbc30Test.usingEmbedded()) {
                    SavepointJdbc30Test.assertSQLState("3B502", se);
                }
                if (!SavepointJdbc30Test.usingDerbyNetClient()) break block3;
                SavepointJdbc30Test.assertSQLState("XJ097", se);
            }
        }
        con.commit();
        con2.commit();
    }

    public void testSavepointName() throws SQLException {
        Connection con = this.getConnection();
        Savepoint savepoint1 = con.setSavepoint("myname");
        String savepointName = savepoint1.getSavepointName();
        SavepointJdbc30Test.assertEquals((String)savepointName, (String)"myname");
        con.rollback();
    }

    public void testNameCaseSensitivity() throws SQLException {
        Connection con = this.getConnection();
        Savepoint savepoint1 = con.setSavepoint("MyName");
        String savepointName = savepoint1.getSavepointName();
        SavepointJdbc30Test.assertEquals((String)savepointName, (String)"MyName");
        con.rollback();
    }

    public void testRollbackMultipleTimes() throws SQLException {
        Connection con = this.getConnection();
        Savepoint savepoint1 = con.setSavepoint("MyName");
        con.rollback(savepoint1);
        con.rollback(savepoint1);
        con.rollback();
    }

    public void testReleaseMultipleTimes() throws SQLException {
        Connection con = this.getConnection();
        Savepoint savepoint1 = con.setSavepoint("MyName");
        con.releaseSavepoint(savepoint1);
        try {
            con.releaseSavepoint(savepoint1);
            SavepointJdbc30Test.fail((String)"FAIL 12 releasing a savepoint multiple times should fail");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("3B001", se);
        }
        con.rollback();
    }

    public void testSavepointFromEarlierTransactionAfterToggleAutocommit() throws SQLException {
        Connection con = this.getConnection();
        Savepoint savepoint1 = con.setSavepoint("MyName");
        con.setAutoCommit(true);
        con.setAutoCommit(false);
        Savepoint savepoint2 = con.setSavepoint("MyName1");
        try {
            con.releaseSavepoint(savepoint1);
            SavepointJdbc30Test.fail((String)"FAIL 13 shouldn't be able to use a savepoint from earlier transaction after setting autocommit on and off");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("3B001", se);
        }
        con.releaseSavepoint(savepoint2);
        con.rollback();
    }

    public void testRollbackReleasesSavepointArray() throws SQLException {
        Connection con = this.getConnection();
        Connection con2 = this.openDefaultConnection();
        con2.setAutoCommit(false);
        Statement s1 = this.createStatement();
        s1.executeUpdate("insert into t1 values(1,1)");
        s1.executeUpdate("insert into t1 values(2,0)");
        con.commit();
        s1.executeUpdate("update t1 set c11=c11+1 where c12 > 0");
        Statement s2 = con2.createStatement();
        Savepoint savepoint1 = con2.setSavepoint("MyName");
        try {
            s2.executeUpdate("update t1 set c11=c11+1 where c12 < 1");
            SavepointJdbc30Test.fail((String)"FAIL 14 should have gotten lock time out");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("40XL1", se);
        }
        try {
            con2.releaseSavepoint(savepoint1);
            SavepointJdbc30Test.fail((String)"FAIL 14 A non-user initiated transaction rollback should release the internal savepoint array");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("3B001", se);
        }
        con.rollback();
        con2.rollback();
        s1.execute("delete from t1");
        con.commit();
    }

    public void testSavepointsInBatch() throws SQLException {
        Connection con = this.getConnection();
        Statement s = this.createStatement();
        s.execute("delete from t1");
        s.addBatch("insert into t1 values(1,1)");
        s.addBatch("insert into t1 values(2,2)");
        Savepoint savepoint1 = con.setSavepoint();
        s.addBatch("insert into t1 values(3,3)");
        s.executeBatch();
        con.rollback(savepoint1);
        this.assertTableRowCount("T1", 0);
        con.rollback();
    }

    public void testGrammarCheck() throws SQLException {
        Statement s = this.getConnection().createStatement();
        try {
            s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS");
            SavepointJdbc30Test.fail((String)"FAIL 16 Should have gotten exception for missing ON ROLLBACK RETAIN CURSORS");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("42X01", se);
        }
        try {
            s.executeUpdate("SAVEPOINT s1 UNIQUE ON ROLLBACK RETAIN CURSORS ON ROLLBACK RETAIN CURSORS");
            SavepointJdbc30Test.fail((String)"FAIL 16 Should have gotten exception for multiple ON ROLLBACK RETAIN CURSORS");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("42613", se);
        }
        try {
            s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN LOCKS");
            SavepointJdbc30Test.fail((String)"FAIL 16 Should have gotten exception for multiple ON ROLLBACK RETAIN LOCKS");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("42613", se);
        }
        try {
            s.executeUpdate("SAVEPOINT s1 UNIQUE UNIQUE ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
            SavepointJdbc30Test.fail((String)"FAIL 16 Should have gotten exception for multiple UNIQUE keywords");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("42613", se);
        }
        s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN CURSORS ON ROLLBACK RETAIN LOCKS");
        s.executeUpdate("RELEASE TO SAVEPOINT s1");
        this.getConnection().rollback();
    }

    public void testNoNestedSavepointsWhenUsingSQL() throws SQLException {
        Statement s = this.getConnection().createStatement();
        s.executeUpdate("SAVEPOINT s1 UNIQUE ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        try {
            s.executeUpdate("SAVEPOINT s2 UNIQUE ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
            SavepointJdbc30Test.fail((String)"FAIL 17a Should have gotten exception for nested savepoints");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("3B002", se);
        }
        s.executeUpdate("RELEASE TO SAVEPOINT s1");
        s.executeUpdate("SAVEPOINT s2 UNIQUE ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        this.getConnection().rollback();
        s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        try {
            s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
            SavepointJdbc30Test.fail((String)"FAIL 17b Should have gotten exception for nested savepoints");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("3B002", se);
        }
        this.getConnection().rollback();
    }

    public void testNoNestedSavepointsInsideJdbcSavepoint() throws SQLException {
        Connection con = this.getConnection();
        Savepoint savepoint1 = con.setSavepoint();
        Statement s = this.getConnection().createStatement();
        try {
            s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
            SavepointJdbc30Test.fail((String)"FAIL 18 shouldn't be able set SQL savepoint nested inside JDBC savepoints");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("3B002", se);
        }
        con.releaseSavepoint(savepoint1);
        s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        con.rollback();
    }

    public void testNoNestedSavepointsInsideSqlSavepoint() throws SQLException {
        Statement s = this.getConnection().createStatement();
        s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        try {
            s.executeUpdate("SAVEPOINT s2 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
            SavepointJdbc30Test.fail((String)"FAIL 19 shouldn't be able set SQL savepoint nested inside SQL savepoint");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("3B002", se);
        }
        s.executeUpdate("RELEASE TO SAVEPOINT s1");
        s.executeUpdate("SAVEPOINT s2 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        this.getConnection().rollback();
    }

    public void testRollbackSqlSavepointSameAsJdbc() throws SQLException {
        Connection con = this.getConnection();
        Statement s = this.createStatement();
        s.executeUpdate("DELETE FROM T1");
        con.commit();
        s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        s.executeUpdate("INSERT INTO T1 VALUES(1,1)");
        s.executeUpdate("INSERT INTO T1 VALUES(1,1)");
        s.executeUpdate("INSERT INTO T1 VALUES(1,1)");
        s.execute("ROLLBACK TO SAVEPOINT s1");
        ResultSet rs1 = s.executeQuery("select count(*) from t1");
        rs1.next();
        SavepointJdbc30Test.assertEquals((int)rs1.getInt(1), (int)0);
        con.rollback();
    }

    public void testReleaseSqlSavepointAndRollback() throws SQLException {
        Connection con = this.getConnection();
        Statement s = this.createStatement();
        s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        s.executeUpdate("INSERT INTO T1 VALUES(1,1)");
        s.executeUpdate("INSERT INTO T1 VALUES(2,1)");
        s.executeUpdate("INSERT INTO T1 VALUES(3,1)");
        s.executeUpdate("RELEASE TO SAVEPOINT s1");
        con.rollback();
        ResultSet rs1 = s.executeQuery("select count(*) from t1");
        rs1.next();
        SavepointJdbc30Test.assertEquals((int)rs1.getInt(1), (int)0);
        con.rollback();
    }

    public void testNoSqlSavepointStartingWithSYS() throws SQLException {
        Statement s = this.createStatement();
        try {
            s.executeUpdate("SAVEPOINT SYSs2 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
            SavepointJdbc30Test.fail((String)"FAIL 22 shouldn't be able to create a SQL savepoint starting with name SYS");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("42939", se);
        }
        this.getConnection().rollback();
    }

    public void testBug5817() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table savepoint (savepoint int, release int)");
        ResultSet rs1 = s.executeQuery("select count(*) from savepoint");
        rs1.next();
        SavepointJdbc30Test.assertEquals((String)(" There should have been 0 rows in the table, but found " + rs1.getInt(1)), (int)rs1.getInt(1), (int)0);
        s.execute("SAVEPOINT savepoint ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        s.executeUpdate("INSERT INTO savepoint VALUES(1,1)");
        s.execute("RELEASE SAVEPOINT savepoint");
        rs1 = s.executeQuery("select count(*) from savepoint");
        rs1.next();
        SavepointJdbc30Test.assertEquals((String)("There should have been 1 rows in the table, but found " + rs1.getInt(1)), (int)rs1.getInt(1), (int)1);
        s.execute("SAVEPOINT release ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        s.executeUpdate("INSERT INTO savepoint VALUES(2,1)");
        s.execute("ROLLBACK TO SAVEPOINT release");
        rs1 = s.executeQuery("select count(*) from savepoint");
        rs1.next();
        SavepointJdbc30Test.assertEquals((String)("ERROR: There should have been 1 rows in the table, but found " + rs1.getInt(1)), (int)rs1.getInt(1), (int)1);
        s.execute("RELEASE SAVEPOINT release");
        this.getConnection().rollback();
    }

    public void testNameLengthMax128Chars() throws SQLException {
        try {
            this.getConnection().setSavepoint("MyName1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890");
            SavepointJdbc30Test.fail((String)"FAIL 24 shouldn't be able to create a SQL savepoint with name exceeding 128 characters");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("42622", se);
        }
        this.getConnection().rollback();
    }

    public void testNoSqlSavepointStartingWithSYSThroughJdbc() throws SQLException {
        try {
            this.getConnection().setSavepoint("SYSs2");
            SavepointJdbc30Test.fail((String)"FAIL 25 shouldn't be able to create a SQL savepoint starting with name SYS through jdbc");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("42939", se);
        }
        this.getConnection().rollback();
    }

    public void testRollbackNullSavepoint() throws SQLException {
        block3: {
            try {
                this.getConnection().rollback(null);
                SavepointJdbc30Test.fail((String)"FAIL 26a rollback of null savepoint did not raise error ");
            }
            catch (SQLException se) {
                if (SavepointJdbc30Test.usingEmbedded()) {
                    SavepointJdbc30Test.assertSQLState("3B001", se);
                }
                if (!SavepointJdbc30Test.usingDerbyNetClient()) break block3;
                SavepointJdbc30Test.assertSQLState("3B502", se);
            }
        }
    }

    public void testReleaseNullSavepoint() throws SQLException {
        block3: {
            try {
                this.getConnection().releaseSavepoint(null);
                SavepointJdbc30Test.fail((String)"FAIL 26b release of null savepoint did not raise error ");
            }
            catch (SQLException se) {
                if (SavepointJdbc30Test.usingEmbedded()) {
                    SavepointJdbc30Test.assertSQLState("3B001", se);
                }
                if (!SavepointJdbc30Test.usingDerbyNetClient()) break block3;
                SavepointJdbc30Test.assertSQLState("3B502", se);
            }
        }
    }

    public void xtestNoConflictWithGeneratedName() throws SQLException {
        Connection con = this.getConnection();
        con.setSavepoint();
        con.setSavepoint("i.SAVEPT0");
        con.rollback();
    }

    public void xtestRollbackWillReleaseLaterSavepoints() throws SQLException {
        Connection con = this.getConnection();
        Savepoint savepoint1 = con.setSavepoint();
        Statement s = this.createStatement();
        s.executeUpdate("INSERT INTO T1 VALUES(1,1)");
        Savepoint savepoint2 = con.setSavepoint("s1");
        s.executeUpdate("INSERT INTO T1 VALUES(2,1)");
        Savepoint savepoint3 = con.setSavepoint("s2");
        s.executeUpdate("INSERT INTO T1 VALUES(3,1)");
        con.rollback(savepoint2);
        this.assertTableRowCount("T1", 1);
        try {
            con.releaseSavepoint(savepoint3);
            SavepointJdbc30Test.fail((String)"FAIL 41a release of rolled back savepoint");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("3B001", se);
        }
        try {
            con.rollback(savepoint3);
            SavepointJdbc30Test.fail((String)"FAIL 41b release of rolled back savepoint");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("3B001", se);
        }
        con.rollback(savepoint1);
        this.assertTableRowCount("T1", 0);
        con.rollback();
    }

    public void xtestRollbackWillReleaseActiveSavepoints() throws SQLException {
        Connection con = this.getConnection();
        Savepoint savepoint1 = con.setSavepoint();
        con.rollback();
        try {
            con.rollback(savepoint1);
            SavepointJdbc30Test.fail((String)"FAIL 42 release of rolled back savepoint");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("3B001", se);
        }
    }

    public void xtestCommitWillReleaseActiveSavepoints() throws SQLException {
        Connection con = this.getConnection();
        Savepoint savepoint1 = con.setSavepoint();
        con.commit();
        try {
            con.rollback(savepoint1);
            SavepointJdbc30Test.fail((String)"FAIL 42a Rollback after commit.");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("3B001", se);
        }
    }

    public void xtestReuseNameAfterRelease() throws SQLException {
        Savepoint savepoint1;
        Connection con;
        block3: {
            con = this.getConnection();
            savepoint1 = con.setSavepoint("s1");
            try {
                con.setSavepoint("s1");
                SavepointJdbc30Test.fail((String)"Should not be able to set two savepoints with the same name");
            }
            catch (SQLException se) {
                if (SavepointJdbc30Test.usingEmbedded()) {
                    SavepointJdbc30Test.assertSQLState("3B501", se);
                }
                if (!SavepointJdbc30Test.usingDerbyNetClient()) break block3;
                SavepointJdbc30Test.assertSQLState("3B002", se);
            }
        }
        con.releaseSavepoint(savepoint1);
        con.setSavepoint("s1");
        con.rollback();
    }

    public void xtestReuseNameAfterRollback() throws SQLException {
        Connection con;
        block3: {
            con = this.getConnection();
            Savepoint savepoint1 = con.setSavepoint("MyName");
            con.rollback(savepoint1);
            try {
                con.setSavepoint("MyName");
                SavepointJdbc30Test.fail((String)"FAIL 45 reuse of savepoint name after rollback should fail");
            }
            catch (SQLException se) {
                if (SavepointJdbc30Test.usingEmbedded()) {
                    SavepointJdbc30Test.assertSQLState("3B501", se);
                }
                if (!SavepointJdbc30Test.usingDerbyNetClient()) break block3;
                SavepointJdbc30Test.assertSQLState("3B002", se);
            }
        }
        con.rollback();
    }

    public void xtestCursorsCloseOnRollback() throws SQLException {
        Connection con = this.getConnection();
        Statement sWithHold = con.createStatement(1003, 1007, 1);
        Statement s = this.createStatement();
        s.executeUpdate("DELETE FROM T1");
        s.executeUpdate("INSERT INTO T1 VALUES(19,1)");
        s.executeUpdate("INSERT INTO T1 VALUES(19,2)");
        s.executeUpdate("INSERT INTO T1 VALUES(19,3)");
        ResultSet rs1 = s.executeQuery("select * from t1");
        rs1.next();
        ResultSet rs1WithHold = sWithHold.executeQuery("select * from t1");
        rs1WithHold.next();
        Savepoint savepoint1 = con.setSavepoint();
        ResultSet rs2 = s.executeQuery("select * from t1");
        rs2.next();
        ResultSet rs2WithHold = sWithHold.executeQuery("select * from t1");
        rs2WithHold.next();
        con.rollback(savepoint1);
        try {
            rs1.next();
            SavepointJdbc30Test.fail((String)"FAIL 46 shouldn't be able to use a resultset (declared before the savepoint unit) after the rollback to savepoint");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("XCL16", se);
        }
        try {
            rs1WithHold.next();
            SavepointJdbc30Test.fail((String)"FAIL 46 shouldn't be able to use a holdable resultset (declared before the savepoint unit) after the rollback to savepoint");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("XCL16", se);
        }
        try {
            rs2.next();
            SavepointJdbc30Test.fail((String)"FAIL 46 shouldn't be able to use a resultset (declared within the savepoint unit) after the rollback to savepoint");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("XCL16", se);
        }
        try {
            rs2WithHold.next();
            SavepointJdbc30Test.fail((String)"FAIL 46 shouldn't be able to use a holdable resultset (declared within the savepoint unit) after the rollback to savepoint");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("XCL16", se);
        }
        con.rollback();
    }

    public void xtestGetSavepoint() throws SQLException {
        Connection con = this.getConnection();
        Savepoint savepoint1 = con.setSavepoint();
        Savepoint savepoint2 = con.setSavepoint();
        savepoint1.getSavepointId();
        savepoint2.getSavepointId();
        con.releaseSavepoint(savepoint2);
        savepoint2 = con.setSavepoint();
        savepoint2.getSavepointId();
        con.commit();
        savepoint2 = con.setSavepoint();
        savepoint2.getSavepointId();
        con.rollback();
        savepoint2 = con.setSavepoint();
        savepoint2.getSavepointId();
        con.rollback();
    }

    public void xtestNestedSavepoints() throws SQLException {
        Connection con = this.getConnection();
        Savepoint savepoint1 = con.setSavepoint();
        Savepoint savepoint2 = con.setSavepoint();
        Statement s = this.createStatement();
        try {
            s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
            SavepointJdbc30Test.fail((String)"FAIL 48 shouldn't be able set SQL savepoint nested inside JDBC/SQL savepoints");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("3B002", se);
        }
        con.releaseSavepoint(savepoint2);
        try {
            s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
            SavepointJdbc30Test.fail((String)"FAIL 48 Should have gotten exception for nested SQL savepoint");
        }
        catch (SQLException se) {
            SavepointJdbc30Test.assertSQLState("3B002", se);
        }
        con.releaseSavepoint(savepoint1);
        s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        con.rollback();
    }
}

