/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class PrepStmtMetaDataTest
extends BaseJDBCTestCase {
    public PrepStmtMetaDataTest(String name) {
        super(name);
    }

    public void testNoResultSetMeta() throws SQLException {
        this.checkEmptyMetaData("create table ab(a int)", true);
        this.checkEmptyMetaData("alter table ab add column b int", true);
        Statement s = this.createStatement();
        s.execute("create procedure testproc() language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.PrepStmtMetaDataTest.tstmeth' parameter style java");
        this.checkEmptyMetaData("call testproc()", false);
        this.checkEmptyMetaData("drop procedure testproc", true);
        this.checkEmptyMetaData("create schema myschema", true);
        this.checkEmptyMetaData("drop schema myschema restrict", true);
        s.execute("CREATE TABLE TRIGTAB (i int)");
        this.checkEmptyMetaData("create trigger mytrig after insert on ab for each row insert into trigtab values(1)", true);
        this.checkEmptyMetaData("drop trigger mytrig", true);
        this.checkEmptyMetaData("create view myview as select * from ab", true);
        this.checkEmptyMetaData("drop view myview", true);
        this.checkEmptyMetaData("drop table ab", false);
        this.checkEmptyMetaData("create index aindex on ab(a)", true);
        this.checkEmptyMetaData("drop index aindex", false);
        this.checkEmptyMetaData("insert into ab values(1,1)", true);
        this.checkEmptyMetaData("update ab set a = 2", false);
        this.checkEmptyMetaData("delete from ab", false);
        s.executeUpdate("drop table ab");
        s.close();
    }

    public void testAlterTableMeta() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table bug4579 (c11 int)");
        s.executeUpdate("insert into bug4579 values (1)");
        PreparedStatement ps = this.prepareStatement("select * from bug4579");
        ResultSetMetaData rsmd = ps.getMetaData();
        PrepStmtMetaDataTest.assertEquals((int)1, (int)rsmd.getColumnCount());
        PrepStmtMetaDataTest.assertEquals((int)4, (int)rsmd.getColumnType(1));
        PrepStmtMetaDataTest.assertEquals((String)"C11", (String)rsmd.getColumnName(1));
        if (PrepStmtMetaDataTest.usingDerbyNetClient()) {
            return;
        }
        s.executeUpdate("alter table bug4579 add column c12 int");
        rsmd = ps.getMetaData();
        PrepStmtMetaDataTest.assertEquals((int)2, (int)rsmd.getColumnCount());
        PrepStmtMetaDataTest.assertEquals((int)4, (int)rsmd.getColumnType(1));
        PrepStmtMetaDataTest.assertEquals((String)"C11", (String)rsmd.getColumnName(1));
        PrepStmtMetaDataTest.assertEquals((int)4, (int)rsmd.getColumnType(2));
        PrepStmtMetaDataTest.assertEquals((String)"C12", (String)rsmd.getColumnName(2));
        s.executeUpdate("alter table bug4579 add column c13 int");
        ResultSet rs = ps.executeQuery();
        rsmd = ps.getMetaData();
        PrepStmtMetaDataTest.assertEquals((int)3, (int)rsmd.getColumnCount());
        PrepStmtMetaDataTest.assertEquals((int)4, (int)rsmd.getColumnType(1));
        PrepStmtMetaDataTest.assertEquals((String)"C11", (String)rsmd.getColumnName(1));
        PrepStmtMetaDataTest.assertEquals((int)4, (int)rsmd.getColumnType(2));
        PrepStmtMetaDataTest.assertEquals((String)"C12", (String)rsmd.getColumnName(2));
        PrepStmtMetaDataTest.assertEquals((int)4, (int)rsmd.getColumnType(3));
        PrepStmtMetaDataTest.assertEquals((String)"C13", (String)rsmd.getColumnName(3));
        rs.close();
        ps.close();
        s.executeUpdate("drop table bug4579");
        s.close();
    }

    private void checkEmptyMetaData(String sql, boolean execute) throws SQLException {
        PreparedStatement ps = this.prepareStatement(sql);
        ResultSetMetaData rsmd = ps.getMetaData();
        this.assertEmptyResultSetMetaData(rsmd);
        if (execute) {
            ps.executeUpdate();
        }
        ps.close();
    }

    public void testAllDataTypesMetaData() throws SQLException {
        Statement s = this.createStatement();
        SQLUtilities.createAndPopulateAllDataTypesTable(s);
        s.close();
        PreparedStatement ps = this.prepareStatement("SELECT * from AllDataTypesTable");
        ResultSetMetaData rsmd = ps.getMetaData();
        int colCount = rsmd.getColumnCount();
        PrepStmtMetaDataTest.assertEquals((int)17, (int)colCount);
        PrepStmtMetaDataTest.assertEquals((String)"", (String)rsmd.getCatalogName(1));
        PrepStmtMetaDataTest.assertEquals((String)"java.lang.Integer", (String)rsmd.getColumnClassName(1));
        PrepStmtMetaDataTest.assertEquals((int)6, (int)rsmd.getColumnDisplaySize(1));
        PrepStmtMetaDataTest.assertEquals((String)"SMALLINTCOL", (String)rsmd.getColumnLabel(1));
        PrepStmtMetaDataTest.assertEquals((int)5, (int)rsmd.getColumnType(1));
        PrepStmtMetaDataTest.assertEquals((String)"SMALLINT", (String)rsmd.getColumnTypeName(1));
        PrepStmtMetaDataTest.assertEquals((int)5, (int)rsmd.getPrecision(1));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)rsmd.getScale(1));
        PrepStmtMetaDataTest.assertEquals((String)"APP", (String)rsmd.getSchemaName(1));
        PrepStmtMetaDataTest.assertEquals((String)"ALLDATATYPESTABLE", (String)rsmd.getTableName(1));
        PrepStmtMetaDataTest.assertFalse((boolean)rsmd.isAutoIncrement(1));
        PrepStmtMetaDataTest.assertFalse((boolean)rsmd.isCurrency(1));
        PrepStmtMetaDataTest.assertFalse((boolean)rsmd.isDefinitelyWritable(1));
        PrepStmtMetaDataTest.assertEquals((int)1, (int)rsmd.isNullable(1));
        if (PrepStmtMetaDataTest.usingEmbedded()) {
            PrepStmtMetaDataTest.assertFalse((boolean)rsmd.isReadOnly(1));
        }
        PrepStmtMetaDataTest.assertTrue((boolean)rsmd.isSearchable(1));
        PrepStmtMetaDataTest.assertTrue((boolean)rsmd.isSigned(1));
        PrepStmtMetaDataTest.assertFalse((boolean)rsmd.isWritable(1));
        PrepStmtMetaDataTest.assertEquals((String)"java.lang.Integer", (String)rsmd.getColumnClassName(2));
        PrepStmtMetaDataTest.assertEquals((int)11, (int)rsmd.getColumnDisplaySize(2));
        PrepStmtMetaDataTest.assertEquals((String)"INTEGERCOL", (String)rsmd.getColumnLabel(2));
        PrepStmtMetaDataTest.assertEquals((int)4, (int)rsmd.getColumnType(2));
        PrepStmtMetaDataTest.assertEquals((String)"INTEGER", (String)rsmd.getColumnTypeName(2));
        PrepStmtMetaDataTest.assertEquals((int)10, (int)rsmd.getPrecision(2));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)rsmd.getScale(2));
        PrepStmtMetaDataTest.assertEquals((String)"java.lang.Long", (String)rsmd.getColumnClassName(3));
        PrepStmtMetaDataTest.assertEquals((int)20, (int)rsmd.getColumnDisplaySize(3));
        PrepStmtMetaDataTest.assertEquals((String)"BIGINTCOL", (String)rsmd.getColumnLabel(3));
        PrepStmtMetaDataTest.assertEquals((int)-5, (int)rsmd.getColumnType(3));
        PrepStmtMetaDataTest.assertEquals((String)"BIGINT", (String)rsmd.getColumnTypeName(3));
        PrepStmtMetaDataTest.assertEquals((int)19, (int)rsmd.getPrecision(3));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)rsmd.getScale(3));
        PrepStmtMetaDataTest.assertEquals((String)"java.math.BigDecimal", (String)rsmd.getColumnClassName(4));
        PrepStmtMetaDataTest.assertEquals((int)12, (int)rsmd.getColumnDisplaySize(4));
        PrepStmtMetaDataTest.assertEquals((String)"DECIMALCOL", (String)rsmd.getColumnLabel(4));
        PrepStmtMetaDataTest.assertEquals((int)3, (int)rsmd.getColumnType(4));
        PrepStmtMetaDataTest.assertEquals((String)"DECIMAL", (String)rsmd.getColumnTypeName(4));
        PrepStmtMetaDataTest.assertEquals((int)10, (int)rsmd.getPrecision(4));
        PrepStmtMetaDataTest.assertEquals((int)5, (int)rsmd.getScale(4));
        PrepStmtMetaDataTest.assertEquals((String)"java.lang.Float", (String)rsmd.getColumnClassName(5));
        PrepStmtMetaDataTest.assertEquals((int)13, (int)rsmd.getColumnDisplaySize(5));
        PrepStmtMetaDataTest.assertEquals((String)"REALCOL", (String)rsmd.getColumnLabel(5));
        PrepStmtMetaDataTest.assertEquals((int)7, (int)rsmd.getColumnType(5));
        PrepStmtMetaDataTest.assertEquals((String)"REAL", (String)rsmd.getColumnTypeName(5));
        PrepStmtMetaDataTest.assertEquals((int)7, (int)rsmd.getPrecision(5));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)rsmd.getScale(5));
        PrepStmtMetaDataTest.assertEquals((String)"java.lang.Double", (String)rsmd.getColumnClassName(6));
        PrepStmtMetaDataTest.assertEquals((int)22, (int)rsmd.getColumnDisplaySize(6));
        PrepStmtMetaDataTest.assertEquals((String)"DOUBLECOL", (String)rsmd.getColumnLabel(6));
        PrepStmtMetaDataTest.assertEquals((int)8, (int)rsmd.getColumnType(6));
        PrepStmtMetaDataTest.assertEquals((String)"DOUBLE", (String)rsmd.getColumnTypeName(6));
        PrepStmtMetaDataTest.assertEquals((int)15, (int)rsmd.getPrecision(6));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)rsmd.getScale(6));
        PrepStmtMetaDataTest.assertEquals((String)"java.lang.String", (String)rsmd.getColumnClassName(7));
        PrepStmtMetaDataTest.assertEquals((int)60, (int)rsmd.getColumnDisplaySize(7));
        PrepStmtMetaDataTest.assertEquals((String)"CHARCOL", (String)rsmd.getColumnLabel(7));
        PrepStmtMetaDataTest.assertEquals((int)1, (int)rsmd.getColumnType(7));
        PrepStmtMetaDataTest.assertEquals((String)"CHAR", (String)rsmd.getColumnTypeName(7));
        PrepStmtMetaDataTest.assertEquals((int)60, (int)rsmd.getPrecision(7));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)rsmd.getScale(7));
        PrepStmtMetaDataTest.assertEquals((String)"java.lang.String", (String)rsmd.getColumnClassName(8));
        PrepStmtMetaDataTest.assertEquals((int)60, (int)rsmd.getColumnDisplaySize(8));
        PrepStmtMetaDataTest.assertEquals((String)"VARCHARCOL", (String)rsmd.getColumnLabel(8));
        PrepStmtMetaDataTest.assertEquals((int)12, (int)rsmd.getColumnType(8));
        PrepStmtMetaDataTest.assertEquals((String)"VARCHAR", (String)rsmd.getColumnTypeName(8));
        PrepStmtMetaDataTest.assertEquals((int)60, (int)rsmd.getPrecision(8));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)rsmd.getScale(8));
        PrepStmtMetaDataTest.assertEquals((String)"java.lang.String", (String)rsmd.getColumnClassName(9));
        PrepStmtMetaDataTest.assertEquals((int)32700, (int)rsmd.getColumnDisplaySize(9));
        PrepStmtMetaDataTest.assertEquals((String)"LONGVARCHARCOL", (String)rsmd.getColumnLabel(9));
        PrepStmtMetaDataTest.assertEquals((int)-1, (int)rsmd.getColumnType(9));
        PrepStmtMetaDataTest.assertEquals((String)"LONG VARCHAR", (String)rsmd.getColumnTypeName(9));
        PrepStmtMetaDataTest.assertEquals((int)32700, (int)rsmd.getPrecision(9));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)rsmd.getScale(9));
        PrepStmtMetaDataTest.assertEquals((String)"byte[]", (String)rsmd.getColumnClassName(10));
        PrepStmtMetaDataTest.assertEquals((int)120, (int)rsmd.getColumnDisplaySize(10));
        PrepStmtMetaDataTest.assertEquals((String)"CHARFORBITCOL", (String)rsmd.getColumnLabel(10));
        PrepStmtMetaDataTest.assertEquals((int)-2, (int)rsmd.getColumnType(10));
        if (PrepStmtMetaDataTest.usingEmbedded()) {
            PrepStmtMetaDataTest.assertEquals((String)"CHAR () FOR BIT DATA", (String)rsmd.getColumnTypeName(10));
        } else {
            PrepStmtMetaDataTest.assertEquals((String)"CHAR FOR BIT DATA", (String)rsmd.getColumnTypeName(10));
        }
        PrepStmtMetaDataTest.assertEquals((int)60, (int)rsmd.getPrecision(10));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)rsmd.getScale(10));
        PrepStmtMetaDataTest.assertEquals((String)"byte[]", (String)rsmd.getColumnClassName(11));
        PrepStmtMetaDataTest.assertEquals((int)120, (int)rsmd.getColumnDisplaySize(11));
        PrepStmtMetaDataTest.assertEquals((String)"VARCHARFORBITCOL", (String)rsmd.getColumnLabel(11));
        PrepStmtMetaDataTest.assertEquals((int)-3, (int)rsmd.getColumnType(11));
        if (PrepStmtMetaDataTest.usingEmbedded()) {
            PrepStmtMetaDataTest.assertEquals((String)"VARCHAR () FOR BIT DATA", (String)rsmd.getColumnTypeName(11));
        } else {
            PrepStmtMetaDataTest.assertEquals((String)"VARCHAR FOR BIT DATA", (String)rsmd.getColumnTypeName(11));
        }
        PrepStmtMetaDataTest.assertEquals((int)60, (int)rsmd.getPrecision(11));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)rsmd.getScale(11));
        PrepStmtMetaDataTest.assertEquals((String)"byte[]", (String)rsmd.getColumnClassName(12));
        PrepStmtMetaDataTest.assertEquals((int)65400, (int)rsmd.getColumnDisplaySize(12));
        PrepStmtMetaDataTest.assertEquals((String)"LVARCHARFORBITCOL", (String)rsmd.getColumnLabel(12));
        PrepStmtMetaDataTest.assertEquals((int)-4, (int)rsmd.getColumnType(12));
        PrepStmtMetaDataTest.assertEquals((String)"LONG VARCHAR FOR BIT DATA", (String)rsmd.getColumnTypeName(12));
        PrepStmtMetaDataTest.assertEquals((int)32700, (int)rsmd.getPrecision(12));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)rsmd.getScale(12));
        PrepStmtMetaDataTest.assertEquals((String)"java.sql.Clob", (String)rsmd.getColumnClassName(13));
        PrepStmtMetaDataTest.assertEquals((int)1024, (int)rsmd.getColumnDisplaySize(13));
        PrepStmtMetaDataTest.assertEquals((String)"CLOBCOL", (String)rsmd.getColumnLabel(13));
        PrepStmtMetaDataTest.assertEquals((int)2005, (int)rsmd.getColumnType(13));
        PrepStmtMetaDataTest.assertEquals((String)"CLOB", (String)rsmd.getColumnTypeName(13));
        PrepStmtMetaDataTest.assertEquals((int)1024, (int)rsmd.getPrecision(13));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)rsmd.getScale(13));
        PrepStmtMetaDataTest.assertEquals((String)"java.sql.Date", (String)rsmd.getColumnClassName(14));
        PrepStmtMetaDataTest.assertEquals((int)10, (int)rsmd.getColumnDisplaySize(14));
        PrepStmtMetaDataTest.assertEquals((String)"DATECOL", (String)rsmd.getColumnLabel(14));
        PrepStmtMetaDataTest.assertEquals((int)91, (int)rsmd.getColumnType(14));
        PrepStmtMetaDataTest.assertEquals((String)"DATE", (String)rsmd.getColumnTypeName(14));
        PrepStmtMetaDataTest.assertEquals((int)10, (int)rsmd.getPrecision(14));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)rsmd.getScale(14));
        PrepStmtMetaDataTest.assertEquals((String)"java.sql.Time", (String)rsmd.getColumnClassName(15));
        PrepStmtMetaDataTest.assertEquals((int)8, (int)rsmd.getColumnDisplaySize(15));
        PrepStmtMetaDataTest.assertEquals((String)"TIMECOL", (String)rsmd.getColumnLabel(15));
        PrepStmtMetaDataTest.assertEquals((int)92, (int)rsmd.getColumnType(15));
        PrepStmtMetaDataTest.assertEquals((String)"TIME", (String)rsmd.getColumnTypeName(15));
        PrepStmtMetaDataTest.assertEquals((int)8, (int)rsmd.getPrecision(15));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)rsmd.getScale(15));
        PrepStmtMetaDataTest.assertEquals((String)"java.sql.Timestamp", (String)rsmd.getColumnClassName(16));
        PrepStmtMetaDataTest.assertEquals((int)26, (int)rsmd.getColumnDisplaySize(16));
        PrepStmtMetaDataTest.assertEquals((String)"TIMESTAMPCOL", (String)rsmd.getColumnLabel(16));
        PrepStmtMetaDataTest.assertEquals((int)93, (int)rsmd.getColumnType(16));
        PrepStmtMetaDataTest.assertEquals((String)"TIMESTAMP", (String)rsmd.getColumnTypeName(16));
        PrepStmtMetaDataTest.assertEquals((int)26, (int)rsmd.getPrecision(16));
        PrepStmtMetaDataTest.assertEquals((int)6, (int)rsmd.getScale(16));
        PrepStmtMetaDataTest.assertEquals((String)"java.sql.Blob", (String)rsmd.getColumnClassName(17));
        PrepStmtMetaDataTest.assertEquals((int)2048, (int)rsmd.getColumnDisplaySize(17));
        PrepStmtMetaDataTest.assertEquals((String)"BLOBCOL", (String)rsmd.getColumnLabel(17));
        PrepStmtMetaDataTest.assertEquals((int)2004, (int)rsmd.getColumnType(17));
        PrepStmtMetaDataTest.assertEquals((String)"BLOB", (String)rsmd.getColumnTypeName(17));
        PrepStmtMetaDataTest.assertEquals((int)1024, (int)rsmd.getPrecision(17));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)rsmd.getScale(17));
        ps.close();
    }

    private void assertEmptyResultSetMetaData(ResultSetMetaData rsmd) throws SQLException {
        if (rsmd != null) {
            PrepStmtMetaDataTest.assertEquals((int)0, (int)rsmd.getColumnCount());
        }
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(PrepStmtMetaDataTest.class);
    }

    public static void tstmeth() {
    }
}

