/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.jdbc.ClientConnectionPoolDataSource;
import org.apache.derby.jdbc.ClientXADataSource;
import org.apache.derby.jdbc.EmbeddedSimpleDataSource;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.AssertEventCatcher;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.cdsXid;
import org.apache.derbyTesting.functionTests.util.SecurityCheck;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCClient;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class J2EEDataSourceTest
extends BaseJDBCTestCase {
    private static final String dbName = TestConfiguration.getCurrent().getDefaultDatabaseName();
    protected static Hashtable conns = new Hashtable();
    private static final String CONNSTRING_FORMAT = "\\S+@\\-?[0-9]+.* \\(XID = .*\\), \\(SESSIONID = [0-9]+\\), \\(DATABASE = [A-Za-z]+\\), \\(DRDAID = .*\\) ";
    private final Object nogc = SecurityCheck.class;

    public J2EEDataSourceTest(String name) {
        super(name);
    }

    private static Test getTimeoutSuite(String postfix) {
        TestSuite suite = new TestSuite("Lower lock timeout" + postfix);
        suite.addTest((Test)new J2EEDataSourceTest("timeoutTestDerby1144PooledDS"));
        suite.addTest((Test)new J2EEDataSourceTest("timeoutTestDerby1144XADS"));
        return DatabasePropertyTestSetup.setLockTimeouts((Test)suite, 3, 5);
    }

    private static Test baseSuite(String postfix) {
        TestSuite suite = new TestSuite("ClientAndEmbedded" + postfix);
        suite.addTest((Test)new J2EEDataSourceTest("testGlobalLocalInterleaf"));
        suite.addTest((Test)new J2EEDataSourceTest("testSetIsolationWithStatement"));
        suite.addTest((Test)new J2EEDataSourceTest("testJira95pds"));
        suite.addTest((Test)new J2EEDataSourceTest("testJira95xads"));
        suite.addTest((Test)new J2EEDataSourceTest("testBadConnectionAttributeSyntax"));
        suite.addTest((Test)new J2EEDataSourceTest("testCloseActiveConnection_DS"));
        suite.addTest((Test)new J2EEDataSourceTest("testCloseActiveConnection_CP"));
        suite.addTest((Test)new J2EEDataSourceTest("testCloseActiveConnection_XA_local"));
        suite.addTest((Test)new J2EEDataSourceTest("testCloseActiveConnection_XA_global"));
        suite.addTest((Test)new J2EEDataSourceTest("testDescriptionProperty"));
        suite.addTest((Test)new J2EEDataSourceTest("testConnectionErrorEvent"));
        suite.addTest((Test)new J2EEDataSourceTest("testConnectionEventListenerIsNull"));
        suite.addTest((Test)new J2EEDataSourceTest("testReadOnlyToWritableTran"));
        suite.addTest((Test)new J2EEDataSourceTest("testAutoCommitOnXAResourceStart"));
        suite.addTest((Test)new J2EEDataSourceTest("testAllDataSources"));
        suite.addTest((Test)new J2EEDataSourceTest("testClosedCPDSConnection"));
        suite.addTest((Test)new J2EEDataSourceTest("testClosedXADSConnection"));
        suite.addTest((Test)new J2EEDataSourceTest("testSetSchemaInXAConnection"));
        suite.addTest((Test)new J2EEDataSourceTest("testPooledReuseOnClose"));
        suite.addTest((Test)new J2EEDataSourceTest("testSchemaIsReset"));
        suite.addTest((Test)new J2EEDataSourceTest("testSchemaIsResetWhenDeleted"));
        suite.addTest((Test)new J2EEDataSourceTest("testDerby3799"));
        return suite;
    }

    private static Test getClientSuite() {
        TestSuite suite = new TestSuite("Client/Server");
        suite.addTest((Test)new J2EEDataSourceTest("testClientDSConnectionAttributes"));
        suite.addTest((Test)new J2EEDataSourceTest("testClientTraceFileDSConnectionAttribute"));
        suite.addTest((Test)new J2EEDataSourceTest("testClientMessageTextConnectionAttribute"));
        return suite;
    }

    private static Test getEmbeddedSuite(String postfix) {
        TestSuite suite = new TestSuite("Embedded" + postfix);
        suite.addTest((Test)new J2EEDataSourceTest("testDSRequestAuthentication"));
        suite.addTest((Test)new J2EEDataSourceTest("testReuseAcrossGlobalLocal"));
        suite.addTest((Test)new J2EEDataSourceTest("testXAHoldability"));
        return suite;
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            TestSuite suite = new TestSuite("J2EEDatasourceTest cannot run with JSR169");
            return suite;
        }
        TestSuite suite = new TestSuite("J2EEDataSourceTest suite");
        suite.addTest(J2EEDataSourceTest.baseSuite(":embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(J2EEDataSourceTest.baseSuite(":client")));
        suite.addTest(TestConfiguration.clientServerDecorator(J2EEDataSourceTest.getClientSuite()));
        suite.addTest(J2EEDataSourceTest.getEmbeddedSuite("embedded"));
        suite.addTest(J2EEDataSourceTest.getTimeoutSuite(":embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(J2EEDataSourceTest.getTimeoutSuite(":client")));
        return new CleanDatabaseTestSetup((Test)suite){

            protected void decorateSQL(Statement s) throws SQLException {
                s.executeUpdate("create table autocommitxastart(i int)");
                s.executeUpdate("insert into autocommitxastart values 1,2,3,4,5");
                s.executeUpdate("create schema SCHEMA_Patricio");
                s.executeUpdate("create table SCHEMA_Patricio.Patricio (id VARCHAR(255), value INTEGER)");
                s.executeUpdate("create table intTable(i int)");
                s.executeUpdate("create table hold_30 (id int not null primary key, b char(30))");
                s.executeUpdate("create procedure checkConn2(in dsname varchar(20)) parameter style java language java modifies SQL DATA external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.J2EEDataSourceTest." + J2EEDataSourceTest.getNestedMethodName() + "'");
                s.execute("create table derby3799 (dClob clob)");
                s.executeUpdate("insert into derby3799 values ('myLittleTestClob')");
            }
        };
    }

    public void tearDown() throws Exception {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (int i = 0; i < 6; ++i) {
                    String traceFileName = "trace" + (i + 1) + ".out";
                    File traceFile = new File(traceFileName);
                    if (!traceFile.exists()) continue;
                    traceFile.delete();
                }
                return null;
            }
        });
        super.tearDown();
    }

    public void testConnectionErrorEvent() throws SQLException, Exception {
        AssertEventCatcher aes12 = new AssertEventCatcher(12);
        ConnectionPoolDataSource ds = J2EEDataSource.getConnectionPoolDataSource();
        PooledConnection pc = ds.getPooledConnection();
        pc.addConnectionEventListener(aes12);
        Connection conn = pc.getConnection();
        J2EEDataSourceTest.dropTable(conn, "TAB1");
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        if (J2EEDataSourceTest.usingEmbedded()) {
            this.getTestConfiguration().shutdownDatabase();
        } else {
            this.getTestConfiguration().stopNetworkServer();
        }
        try {
            conn.prepareStatement("CREATE TABLE TAB1(COL1 INT NOT NULL)");
        }
        catch (SQLException e) {
            if (J2EEDataSourceTest.usingEmbedded()) {
                J2EEDataSourceTest.assertSQLState("08003", e);
            }
            J2EEDataSourceTest.assertSQLState("08006", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.prepareStatement("CREATE TABLE TAB1(COL1 INT NOT NULL)", 1);
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            int[] columnIndexes = new int[]{1};
            conn.prepareStatement("CREATE TABLE TAB1(COL1 INT NOT NULL)", columnIndexes);
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            String[] columnNames = new String[]{"col1"};
            conn.prepareStatement("CREATE TABLE TAB1(COL1 INT NOT NULL)", columnNames);
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.prepareStatement("CREATE TABLE TAB1(COL1 INT NOT NULL)", 1003, 1007);
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.prepareStatement("CREATE TABLE TAB1(COL1 INT NOT NULL)", 1003, 1007, 2);
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.createStatement();
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.createStatement(1003, 1007, 2);
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.createStatement(1003, 1007);
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.prepareCall("CREATE TABLE TAB1(COL1 INT NOT NULL)", 1003, 1007);
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.prepareCall("CREATE TABLE TAB1(COL1 INT NOT NULL)");
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.prepareCall("CREATE TABLE TAB1(COL1 INT NOT NULL)", 1003, 1007, 2);
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.nativeSQL("CREATE TABLE TAB1(COL1 INT NOT NULL)");
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.getAutoCommit();
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.getHoldability();
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.setHoldability(1);
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.commit();
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.rollback();
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.setSavepoint();
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.setSavepoint("savept1");
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.rollback(null);
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.releaseSavepoint(null);
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.setTransactionIsolation(2);
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.getTransactionIsolation();
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.getWarnings();
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.clearWarnings();
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.getMetaData();
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.isReadOnly();
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.setReadOnly(true);
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.setCatalog(null);
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.getCatalog();
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.getTypeMap();
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.setTypeMap(null);
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("08003", e);
        }
        J2EEDataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        if (J2EEDataSourceTest.usingEmbedded()) {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        } else {
            this.getTestConfiguration().startNetworkServer();
        }
        conn = this.getConnection();
        conn.close();
    }

    public void testConnectionEventListenerIsNull() throws SQLException {
        ConnectionPoolDataSource cpds = J2EEDataSource.getConnectionPoolDataSource();
        this.subtestCloseEventWithNullListener(cpds.getPooledConnection());
        this.subtestErrorEventWithNullListener(cpds.getPooledConnection());
        XADataSource xads = J2EEDataSource.getXADataSource();
        this.subtestCloseEventWithNullListener(xads.getXAConnection());
        this.subtestErrorEventWithNullListener(xads.getXAConnection());
    }

    private void subtestCloseEventWithNullListener(PooledConnection pc) throws SQLException {
        pc.addConnectionEventListener(null);
        pc.getConnection().close();
        pc.close();
    }

    private void subtestErrorEventWithNullListener(PooledConnection pc) throws SQLException {
        pc.addConnectionEventListener(null);
        Connection c = pc.getConnection();
        this.getTestConfiguration().shutdownDatabase();
        try {
            c.prepareStatement("VALUES 1");
            J2EEDataSourceTest.fail((String)"Statement should fail after database shutdown");
        }
        catch (SQLException e) {
            if (J2EEDataSourceTest.usingEmbedded()) {
                J2EEDataSourceTest.assertSQLState("08003", e);
            }
            J2EEDataSourceTest.assertSQLState("08006", e);
        }
        c.close();
        pc.close();
    }

    private void testCloseActiveConnection(Connection c, boolean autoCommit, boolean global) throws SQLException {
        if (global) {
            J2EEDataSourceTest.assertFalse((String)"auto-commit should be false in XA", (boolean)autoCommit);
        }
        J2EEDataSourceTest.assertEquals((String)"auto-commit", (boolean)autoCommit, (boolean)c.getAutoCommit());
        Statement s = c.createStatement();
        JDBC.assertDrainResults(s.executeQuery("SELECT * FROM SYS.SYSTABLES"));
        s.close();
        try {
            c.close();
            J2EEDataSourceTest.assertTrue((String)"close() should fail", (autoCommit || global ? 1 : 0) != 0);
        }
        catch (SQLException e) {
            if (autoCommit || global) {
                throw e;
            }
            J2EEDataSourceTest.assertSQLState("25001", e);
        }
        if (!autoCommit && !global) {
            c.rollback();
        }
        c.close();
    }

    public void testCloseActiveConnection_DS() throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource();
        this.testCloseActiveConnection(ds.getConnection(), true, false);
        Connection c = ds.getConnection();
        c.setAutoCommit(false);
        this.testCloseActiveConnection(c, false, false);
    }

    public void testCloseActiveConnection_CP() throws SQLException {
        ConnectionPoolDataSource ds = J2EEDataSource.getConnectionPoolDataSource();
        PooledConnection pc = ds.getPooledConnection();
        this.testCloseActiveConnection(pc.getConnection(), true, false);
        Connection c = pc.getConnection();
        c.setAutoCommit(false);
        this.testCloseActiveConnection(c, false, false);
    }

    public void testCloseActiveConnection_XA_local() throws SQLException {
        XADataSource ds = J2EEDataSource.getXADataSource();
        XAConnection xa = ds.getXAConnection();
        this.testCloseActiveConnection(xa.getConnection(), true, false);
        Connection c = xa.getConnection();
        c.setAutoCommit(false);
        this.testCloseActiveConnection(c, false, false);
    }

    public void testCloseActiveConnection_XA_global() throws SQLException, XAException {
        XADataSource ds = J2EEDataSource.getXADataSource();
        XAConnection xa = ds.getXAConnection();
        XAResource xar = xa.getXAResource();
        cdsXid xid = new cdsXid(1, 2, 3);
        xar.start(xid, 0);
        this.testCloseActiveConnection(xa.getConnection(), false, true);
        Connection c = xa.getConnection();
        c.setAutoCommit(false);
        this.testCloseActiveConnection(c, false, true);
        xar.end(xid, 0x4000000);
    }

    public void testPooledReuseOnClose() throws SQLException {
        ConnectionPoolDataSource cpds = J2EEDataSource.getConnectionPoolDataSource();
        this.subtestPooledReuseOnClose(cpds.getPooledConnection());
        this.subtestPooledCloseOnClose(cpds.getPooledConnection());
        this.subtestPooledRemoveListenerOnClose(cpds.getPooledConnection());
        this.subtestPooledAddListenerOnClose(cpds.getPooledConnection());
        XADataSource xads = J2EEDataSource.getXADataSource();
        this.subtestPooledReuseOnClose(xads.getXAConnection());
        this.subtestPooledCloseOnClose(xads.getXAConnection());
        this.subtestPooledRemoveListenerOnClose(xads.getXAConnection());
        this.subtestPooledAddListenerOnClose(xads.getXAConnection());
    }

    private void subtestPooledReuseOnClose(final PooledConnection pc) throws SQLException {
        final Connection[] newConn = new Connection[1];
        pc.addConnectionEventListener(new ConnectionEventListener(){

            public void connectionClosed(ConnectionEvent event) {
                PooledConnection pce = (PooledConnection)event.getSource();
                Assert.assertSame((Object)pc, (Object)pce);
                try {
                    newConn[0] = pce.getConnection();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }

            public void connectionErrorOccurred(ConnectionEvent event) {
            }
        });
        Connection c1 = pc.getConnection();
        c1.close();
        Connection c2 = newConn[0];
        J2EEDataSourceTest.assertNotNull((Object)c2);
        c2.createStatement().close();
        pc.close();
    }

    private void subtestPooledCloseOnClose(final PooledConnection pc) throws SQLException {
        pc.addConnectionEventListener(new ConnectionEventListener(){

            public void connectionClosed(ConnectionEvent event) {
                PooledConnection pce = (PooledConnection)event.getSource();
                Assert.assertSame((Object)pc, (Object)pce);
                try {
                    pce.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }

            public void connectionErrorOccurred(ConnectionEvent event) {
            }
        });
        pc.getConnection().close();
        try {
            pc.getConnection();
            J2EEDataSourceTest.fail((String)"PooledConnection should be closed");
        }
        catch (SQLException sqle) {
            J2EEDataSourceTest.assertSQLState("08003", sqle);
        }
    }

    private void subtestPooledRemoveListenerOnClose(final PooledConnection pc) throws SQLException {
        final int[] count1 = new int[1];
        pc.addConnectionEventListener(new ConnectionEventListener(){

            public void connectionClosed(ConnectionEvent event) {
                PooledConnection pce = (PooledConnection)event.getSource();
                Assert.assertSame((Object)pc, (Object)pce);
                count1[0] = count1[0] + 1;
                pce.removeConnectionEventListener(this);
            }

            public void connectionErrorOccurred(ConnectionEvent event) {
            }
        });
        final int[] count2 = new int[1];
        pc.addConnectionEventListener(new ConnectionEventListener(){

            public void connectionClosed(ConnectionEvent event) {
                PooledConnection pce = (PooledConnection)event.getSource();
                Assert.assertSame((Object)pc, (Object)pce);
                count2[0] = count2[0] + 1;
            }

            public void connectionErrorOccurred(ConnectionEvent event) {
            }
        });
        J2EEDataSourceTest.assertEquals((int)0, (int)count1[0]);
        J2EEDataSourceTest.assertEquals((int)0, (int)count2[0]);
        pc.getConnection().close();
        J2EEDataSourceTest.assertEquals((int)1, (int)count1[0]);
        J2EEDataSourceTest.assertEquals((int)1, (int)count2[0]);
        pc.getConnection().close();
        J2EEDataSourceTest.assertEquals((int)1, (int)count1[0]);
        J2EEDataSourceTest.assertEquals((int)2, (int)count2[0]);
        pc.close();
    }

    private void subtestPooledAddListenerOnClose(final PooledConnection pc) throws SQLException {
        final int[] count = new int[2];
        pc.addConnectionEventListener(new ConnectionEventListener(){

            public void connectionClosed(ConnectionEvent event) {
                Assert.assertSame((Object)pc, (Object)event.getSource());
                count[0] = count[0] + 1;
                pc.addConnectionEventListener(new ConnectionEventListener(){

                    public void connectionClosed(ConnectionEvent e) {
                        Assert.assertSame((Object)pc, (Object)e.getSource());
                        int[] nArray = count;
                        nArray[1] = nArray[1] + 1;
                    }

                    public void connectionErrorOccurred(ConnectionEvent e) {
                    }
                });
            }

            public void connectionErrorOccurred(ConnectionEvent event) {
            }
        });
        int expectedAdded = 0;
        for (int i = 0; i < 5; ++i) {
            J2EEDataSourceTest.assertEquals((String)"close count (main)", (int)i, (int)count[0]);
            J2EEDataSourceTest.assertEquals((String)"close count (added)", (int)expectedAdded, (int)count[1]);
            expectedAdded += i;
            pc.getConnection().close();
        }
        pc.close();
    }

    public void testAllDataSources() throws SQLException, Exception {
        Connection dmc = this.getConnection();
        CallableStatement cs = dmc.prepareCall("call checkConn2(?)");
        cs.setString(1, "Nested");
        try {
            cs.execute();
        }
        catch (SQLException sqle) {
            J2EEDataSourceTest.assertSQLState("40XC0", sqle);
        }
        cs.setString(1, "Nested2");
        cs.execute();
        String EmptyMapValue = null;
        String NullMapValue = null;
        String MapMapValue = null;
        if (J2EEDataSourceTest.usingEmbedded()) {
            EmptyMapValue = "OK";
            NullMapValue = "XJ081";
            MapMapValue = "0A000";
        } else if (J2EEDataSourceTest.usingDerbyNetClient()) {
            EmptyMapValue = "0A000";
            NullMapValue = "0A000";
            MapMapValue = "0A000";
        }
        Object[] expectedValues = new Object[]{new Integer(1), "XJ010", new Integer(2), new Boolean(true), new Boolean(false), EmptyMapValue, NullMapValue, MapMapValue};
        this.assertConnectionOK(expectedValues, "DriverManager ", dmc);
        if (J2EEDataSourceTest.usingEmbedded()) {
            this.assertTenConnectionsUnique();
        }
        DataSource dscs = JDBCDataSource.getDataSource();
        if (J2EEDataSourceTest.usingEmbedded()) {
            J2EEDataSourceTest.assertToString(dscs);
        }
        DataSource ds = dscs;
        this.assertConnectionOK(expectedValues, "DataSource", ds.getConnection());
        EmbeddedSimpleDataSource dssimple = null;
        if (J2EEDataSourceTest.usingEmbedded()) {
            EmbeddedSimpleDataSource realdssimple = new EmbeddedSimpleDataSource();
            realdssimple.setDatabaseName(dbName);
            ds = realdssimple;
            dssimple = realdssimple;
            this.assertConnectionOK(expectedValues, "SimpleDataSource", ds.getConnection());
        }
        ConnectionPoolDataSource dsp = J2EEDataSource.getConnectionPoolDataSource();
        if (J2EEDataSourceTest.usingEmbedded()) {
            J2EEDataSourceTest.assertToString(dsp);
        }
        PooledConnection pc = dsp.getPooledConnection();
        if (J2EEDataSourceTest.usingEmbedded()) {
            SecurityCheck.assertSourceSecurity(pc, "javax.sql.PooledConnection");
        }
        AssertEventCatcher aes1 = new AssertEventCatcher(1);
        pc.addConnectionEventListener(aes1);
        this.assertConnectionOK(expectedValues, "ConnectionPoolDataSource", pc.getConnection());
        J2EEDataSourceTest.assertTrue((boolean)aes1.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)aes1.didConnectionErrorEventHappen());
        aes1.resetState();
        this.assertConnectionOK(expectedValues, "ConnectionPoolDataSource", pc.getConnection());
        J2EEDataSourceTest.assertTrue((boolean)aes1.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)aes1.didConnectionErrorEventHappen());
        aes1.resetState();
        XADataSource dsx = J2EEDataSource.getXADataSource();
        if (J2EEDataSourceTest.usingEmbedded()) {
            J2EEDataSourceTest.assertToString(dsx);
        }
        TestConfiguration.getCurrent().shutdownDatabase();
        dmc = this.getConnection();
        cs = dmc.prepareCall("call checkConn2(?)");
        if (J2EEDataSourceTest.usingEmbedded()) {
            SecurityCheck.assertSourceSecurity(cs, "java.sql.CallableStatement");
        }
        cs.setString(1, "Nested");
        try {
            cs.execute();
        }
        catch (SQLException sqle) {
            J2EEDataSourceTest.assertSQLState("40XC0", sqle);
        }
        cs.setString(1, "Nested2");
        cs.execute();
        XAConnection xac = dsx.getXAConnection();
        if (J2EEDataSourceTest.usingEmbedded()) {
            SecurityCheck.assertSourceSecurity(xac, "javax.sql.XAConnection");
        }
        AssertEventCatcher aes3 = new AssertEventCatcher(3);
        xac.addConnectionEventListener(aes3);
        this.assertConnectionOK(expectedValues, "XADataSource", xac.getConnection());
        J2EEDataSourceTest.assertTrue((boolean)aes3.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)aes3.didConnectionErrorEventHappen());
        aes3.resetState();
        pc = dsp.getPooledConnection();
        AssertEventCatcher aes2 = new AssertEventCatcher(2);
        pc.addConnectionEventListener(aes2);
        this.assertConnectionOK(expectedValues, "ConnectionPoolDataSource", pc.getConnection());
        J2EEDataSourceTest.assertTrue((boolean)aes2.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)aes2.didConnectionErrorEventHappen());
        aes2.resetState();
        xac = dsx.getXAConnection();
        AssertEventCatcher aes4 = new AssertEventCatcher(4);
        xac.addConnectionEventListener(aes4);
        this.assertConnectionOK(expectedValues, "XADataSource", xac.getConnection());
        J2EEDataSourceTest.assertTrue((boolean)aes4.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)aes4.didConnectionErrorEventHappen());
        aes4.resetState();
        this.assertConnectionOK(expectedValues, "XADataSource", xac.getConnection());
        J2EEDataSourceTest.assertTrue((boolean)aes4.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)aes4.didConnectionErrorEventHappen());
        aes4.resetState();
        xac.close();
        xac = dsx.getXAConnection();
        AssertEventCatcher aes5 = new AssertEventCatcher(5);
        xac.addConnectionEventListener(aes5);
        XAResource xar = xac.getXAResource();
        if (J2EEDataSourceTest.usingEmbedded()) {
            SecurityCheck.assertSourceSecurity(xar, "javax.transaction.xa.XAResource");
        }
        cdsXid xid = new cdsXid(1, 35, 47);
        xar.start(xid, 0);
        Connection xacc = xac.getConnection();
        xacc.close();
        expectedValues[0] = new Integer(2);
        if (J2EEDataSourceTest.usingEmbedded()) {
            expectedValues[1] = "XJ058";
        }
        expectedValues[3] = new Boolean(false);
        this.assertConnectionOK(expectedValues, "Global XADataSource", xac.getConnection());
        J2EEDataSourceTest.assertTrue((boolean)aes5.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)aes5.didConnectionErrorEventHappen());
        aes5.resetState();
        this.assertConnectionOK(expectedValues, "Global XADataSource", xac.getConnection());
        J2EEDataSourceTest.assertTrue((boolean)aes5.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)aes5.didConnectionErrorEventHappen());
        aes5.resetState();
        xar.end(xid, 0x4000000);
        expectedValues[0] = new Integer(1);
        expectedValues[3] = new Boolean(true);
        this.assertConnectionOK(expectedValues, "Switch to local XADataSource", xac.getConnection());
        J2EEDataSourceTest.assertTrue((boolean)aes5.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)aes5.didConnectionErrorEventHappen());
        aes5.resetState();
        this.assertConnectionOK(expectedValues, "Switch to local XADataSource", xac.getConnection());
        J2EEDataSourceTest.assertTrue((boolean)aes5.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)aes5.didConnectionErrorEventHappen());
        aes5.resetState();
        Connection backtoGlobal = xac.getConnection();
        xar.start(xid, 0x200000);
        expectedValues[0] = new Integer(2);
        expectedValues[3] = new Boolean(false);
        this.assertConnectionOK(expectedValues, "Switch to global XADataSource", backtoGlobal);
        J2EEDataSourceTest.assertTrue((boolean)aes5.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)aes5.didConnectionErrorEventHappen());
        aes5.resetState();
        this.assertConnectionOK(expectedValues, "Switch to global XADataSource", xac.getConnection());
        J2EEDataSourceTest.assertTrue((boolean)aes5.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)aes5.didConnectionErrorEventHappen());
        aes5.resetState();
        xar.end(xid, 0x4000000);
        xar.commit(xid, true);
        xac.close();
    }

    public void testClosedCPDSConnection() throws SQLException, Exception {
        ResultSet rs;
        Statement s;
        Connection c1;
        PooledConnection pc;
        ConnectionPoolDataSource dsp;
        block5: {
            dsp = J2EEDataSource.getConnectionPoolDataSource();
            pc = dsp.getPooledConnection();
            c1 = pc.getConnection();
            s = c1.createStatement();
            s.executeUpdate("delete from intTable");
            c1.setAutoCommit(false);
            s.executeUpdate("insert into intTable values(1)");
            c1 = pc.getConnection();
            rs = c1.createStatement().executeQuery("select count(*) from intTable");
            rs.next();
            J2EEDataSourceTest.assertEquals((int)0, (int)rs.getInt(1));
            c1.close();
            try {
                rs.next();
                J2EEDataSourceTest.fail((String)"ResultSet is open for a closed connection obtained from PooledConnection");
            }
            catch (SQLException sqle) {
                if (J2EEDataSourceTest.usingEmbedded()) {
                    J2EEDataSourceTest.assertSQLState("08003", sqle);
                }
                if (!J2EEDataSourceTest.usingDerbyNetClient()) break block5;
                J2EEDataSourceTest.assertSQLState("XCL16", sqle);
            }
        }
        try {
            s.executeUpdate("update intTable set i = 1");
            J2EEDataSourceTest.fail((String)"Statement is open for a closed connection obtained from PooledConnection");
        }
        catch (SQLException sqle) {
            J2EEDataSourceTest.assertSQLState("08003", sqle);
        }
        pc.close();
        pc = null;
        J2EEDataSourceTest.PoolReset("ConnectionPoolDataSource", dsp.getPooledConnection());
        s.close();
        rs.close();
        c1.close();
    }

    public void testClosedXADSConnection() throws SQLException, Exception {
        XADataSource dsx = J2EEDataSource.getXADataSource();
        XAConnection xac = dsx.getXAConnection();
        Connection c1 = xac.getConnection();
        Statement s = c1.createStatement();
        c1.setAutoCommit(false);
        s.executeUpdate("insert into intTable values(2)");
        c1 = xac.getConnection();
        ResultSet rs = c1.createStatement().executeQuery("select count(*) from intTable");
        rs.next();
        J2EEDataSourceTest.assertEquals((int)0, (int)rs.getInt(1));
        rs.close();
        c1.close();
        xac.close();
        xac = null;
        J2EEDataSourceTest.PoolReset("XADataSource", dsx.getXAConnection());
    }

    public void testGlobalLocalInterleaf() throws SQLException, XAException {
        XADataSource dsx = J2EEDataSource.getXADataSource();
        XAConnection xac = dsx.getXAConnection();
        AssertEventCatcher aes6 = new AssertEventCatcher(6);
        xac.addConnectionEventListener(aes6);
        XAResource xar = xac.getXAResource();
        cdsXid xid = new cdsXid(1, 93, 103);
        Connection cs1 = xac.getConnection();
        this.assertConnectionState(1, 2, true, false, cs1);
        xar.start(xid, 0);
        this.assertConnectionState(2, 2, false, false, cs1);
        cs1.setTransactionIsolation(1);
        cs1.setReadOnly(true);
        this.setHoldability(cs1, false);
        boolean ReadOnly = false;
        if (J2EEDataSourceTest.usingEmbedded()) {
            ReadOnly = true;
        }
        this.assertConnectionState(2, 1, false, ReadOnly, cs1);
        xar.end(xid, 0x4000000);
        this.assertConnectionState(2, 1, true, ReadOnly, cs1);
        cs1.setTransactionIsolation(2);
        cs1.setReadOnly(false);
        this.setHoldability(cs1, false);
        this.assertConnectionState(2, 2, true, false, cs1);
        xar.start(xid, 0x200000);
        this.assertConnectionState(2, 1, false, ReadOnly, cs1);
        xar.end(xid, 0x4000000);
        this.assertConnectionState(2, 2, true, false, cs1);
        xar.start(xid, 0x200000);
        this.assertConnectionState(2, 1, false, ReadOnly, cs1);
        xar.end(xid, 0x2000000);
        this.assertConnectionState(2, 2, true, false, cs1);
        xar.start(xid, 0x8000000);
        this.assertConnectionState(2, 1, false, ReadOnly, cs1);
        xar.end(xid, 0x4000000);
        this.assertConnectionState(2, 2, true, false, cs1);
        cs1.setTransactionIsolation(1);
        cs1.setReadOnly(true);
        this.setHoldability(cs1, true);
        J2EEDataSourceTest.assertFalse((boolean)aes6.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)aes6.didConnectionErrorEventHappen());
        aes6.resetState();
        cs1.close();
        J2EEDataSourceTest.assertTrue((boolean)aes6.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)aes6.didConnectionErrorEventHappen());
        aes6.resetState();
        cs1 = xac.getConnection();
        this.assertConnectionState(1, 2, true, false, cs1);
        cs1.close();
        J2EEDataSourceTest.assertTrue((boolean)aes6.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)aes6.didConnectionErrorEventHappen());
        aes6.resetState();
        xar.start(xid, 0x200000);
        cs1 = xac.getConnection();
        this.assertConnectionState(2, 1, false, ReadOnly, cs1);
        cs1.close();
        xar.end(xid, 0x4000000);
        J2EEDataSourceTest.assertTrue((boolean)aes6.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)aes6.didConnectionErrorEventHappen());
        aes6.resetState();
        cs1 = xac.getConnection();
        cs1.setTransactionIsolation(4);
        this.assertConnectionState(1, 4, true, false, cs1);
        xar.start(xid, 0x200000);
        this.assertConnectionState(2, 1, false, ReadOnly, cs1);
        xar.end(xid, 0x4000000);
        this.assertConnectionState(1, 4, true, false, cs1);
        xar.commit(xid, true);
        this.assertConnectionState(1, 4, true, false, cs1);
        J2EEDataSourceTest.assertFalse((boolean)aes6.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)aes6.didConnectionErrorEventHappen());
        aes6.resetState();
        cs1.close();
        J2EEDataSourceTest.assertTrue((boolean)aes6.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)aes6.didConnectionErrorEventHappen());
        aes6.resetState();
    }

    public void testSetIsolationWithStatement() throws SQLException, XAException {
        XADataSource dsx = J2EEDataSource.getXADataSource();
        XAConnection xac = dsx.getXAConnection();
        AssertEventCatcher aes6 = new AssertEventCatcher(6);
        xac.addConnectionEventListener(aes6);
        XAResource xar = xac.getXAResource();
        Connection conn = xac.getConnection();
        Statement s = conn.createStatement();
        this.assertConnectionState(1, 2, true, false, conn);
        conn.setTransactionIsolation(1);
        this.assertConnectionState(1, 1, true, false, conn);
        s.executeUpdate("set current isolation = RR");
        this.assertConnectionState(1, 8, true, false, conn);
        cdsXid xid = new cdsXid(1, 35, 47);
        xar.start(xid, 0);
        this.assertConnectionState(2, 8, false, false, conn);
        xar.end(xid, 0x4000000);
        this.assertConnectionState(1, 8, true, false, conn);
        s.executeUpdate("set current isolation = RS");
        this.assertConnectionState(1, 4, true, false, conn);
        xar.start(xid, 0x200000);
        this.assertConnectionState(2, 8, false, false, conn);
        xar.end(xid, 0x4000000);
        this.assertConnectionState(1, 4, true, false, conn);
        cdsXid xid2 = new cdsXid(1, 93, 103);
        xar.start(xid2, 0);
        this.assertConnectionState(2, 4, false, false, conn);
        xar.end(xid2, 0x4000000);
        xar.start(xid, 0x200000);
        this.assertConnectionState(2, 8, false, false, conn);
        xar.end(xid, 0x4000000);
        this.assertConnectionState(1, 4, true, false, conn);
        xar.start(xid, 0x200000);
        this.assertConnectionState(2, 8, false, false, conn);
        s.executeUpdate("set current isolation = UR");
        this.assertConnectionState(2, 1, false, false, conn);
        xar.end(xid, 0x4000000);
        this.assertConnectionState(1, 1, true, false, conn);
        xar.start(xid2, 0x200000);
        this.assertConnectionState(2, 4, false, false, conn);
        xar.end(xid2, 0x4000000);
        xar.rollback(xid2);
        this.assertConnectionState(1, 1, true, false, conn);
        xar.rollback(xid);
        this.assertConnectionState(1, 1, true, false, conn);
        J2EEDataSourceTest.assertFalse((boolean)aes6.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)aes6.didConnectionErrorEventHappen());
        aes6.resetState();
    }

    public void testReuseAcrossGlobalLocal() throws SQLException, XAException {
        if (J2EEDataSourceTest.usingDerbyNetClient()) {
            return;
        }
        int[] onetwothree = new int[]{1, 2, 3};
        int[] three = new int[]{3};
        int[] pspc = new int[]{1, 4};
        int[] cspc = new int[]{2, 12, 12};
        int[] StatementExpectedValues = new int[]{1004, 1007, 1001, 444, 713, 19, 1};
        int[] PreparedStatementExpectedValues = new int[]{1004, 1007, 1001, 888, 317, 91, 1};
        int[] CallableStatementExpectedValues = new int[]{1004, 1007, 1001, 999, 137, 85, 1};
        XADataSource dsx = J2EEDataSource.getXADataSource();
        XAConnection xac = dsx.getXAConnection();
        AssertEventCatcher aes6 = new AssertEventCatcher(6);
        xac.addConnectionEventListener(aes6);
        XAResource xar = xac.getXAResource();
        cdsXid xid = new cdsXid(1, 103, 119);
        Connection cs1 = xac.getConnection();
        cs1.setTransactionIsolation(4);
        cs1.setAutoCommit(false);
        J2EEDataSourceTest.assertLocks(null, cs1);
        Statement sru1 = cs1.createStatement();
        sru1.setCursorName("SN1");
        sru1.executeUpdate("insert into intTable values 1,2,3");
        Statement sruBatch = cs1.createStatement();
        sruBatch.setCursorName("sruBatch");
        Statement sruState = this.createFloatStatementForStateChecking(StatementExpectedValues, cs1);
        PreparedStatement psruState = this.createFloatStatementForStateChecking(new int[]{1, 4}, PreparedStatementExpectedValues, cs1, "select i from intTable where i = ?");
        CallableStatement csruState = this.createFloatCallForStateChecking(new int[]{2, 12, 12}, CallableStatementExpectedValues, cs1, "CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?,?)");
        PreparedStatement psParams = cs1.prepareStatement("select * from intTable where i > ?");
        psParams.setCursorName("params");
        psParams.setInt(1, 2);
        J2EEDataSourceTest.resultSetQuery("params", three, psParams.executeQuery());
        sruBatch.addBatch("insert into intTable values 4");
        J2EEDataSourceTest.queryOnStatement("SN1", onetwothree, cs1, sru1);
        cs1.commit();
        xar.start(xid, 0);
        J2EEDataSourceTest.queryOnStatement("SN1", onetwothree, cs1, sru1);
        sruBatch.addBatch("insert into intTable values 5");
        Statement sru2 = cs1.createStatement();
        sru2.setCursorName("OAK2");
        J2EEDataSourceTest.queryOnStatement("OAK2", onetwothree, cs1, sru2);
        J2EEDataSourceTest.queryOnStatement("SN1", onetwothree, cs1, sru1);
        StatementExpectedValues[6] = 2;
        PreparedStatementExpectedValues[6] = 2;
        CallableStatementExpectedValues[6] = 2;
        this.assertStatementState(null, StatementExpectedValues, sruState);
        this.assertStatementState(pspc, PreparedStatementExpectedValues, psruState);
        this.assertStatementState(cspc, CallableStatementExpectedValues, csruState);
        J2EEDataSourceTest.resultSetQuery("params", three, psParams.executeQuery());
        xar.end(xid, 0x4000000);
        J2EEDataSourceTest.queryOnStatement("SN1", onetwothree, cs1, sru1);
        J2EEDataSourceTest.queryOnStatement("OAK2", onetwothree, cs1, sru2);
        sruBatch.addBatch("insert into intTable values 6,7");
        Statement sru3 = cs1.createStatement();
        sru3.setCursorName("SF3");
        J2EEDataSourceTest.queryOnStatement("SF3", onetwothree, cs1, sru3);
        StatementExpectedValues[6] = 1;
        PreparedStatementExpectedValues[6] = 1;
        CallableStatementExpectedValues[6] = 1;
        this.assertStatementState(null, StatementExpectedValues, sruState);
        this.assertStatementState(pspc, PreparedStatementExpectedValues, psruState);
        this.assertStatementState(cspc, CallableStatementExpectedValues, csruState);
        J2EEDataSourceTest.resultSetQuery("params", three, psParams.executeQuery());
        J2EEDataSourceTest.assertLocks(new int[]{14, 14}, cs1);
        cs1.commit();
        J2EEDataSourceTest.assertFalse((boolean)aes6.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)aes6.didConnectionErrorEventHappen());
        aes6.resetState();
        XAConnection xac2 = dsx.getXAConnection();
        AssertEventCatcher aes5 = new AssertEventCatcher(5);
        xac2.addConnectionEventListener(aes5);
        XAResource xar2 = xac2.getXAResource();
        xar2.start(xid, 0x200000);
        Connection cs2 = xac2.getConnection();
        J2EEDataSourceTest.queryOnStatement("SN1", onetwothree, cs1, sru1);
        J2EEDataSourceTest.queryOnStatement("OAK2", onetwothree, cs1, sru2);
        J2EEDataSourceTest.queryOnStatement("SF3", onetwothree, cs1, sru3);
        sruBatch.addBatch("insert into intTable values 8");
        this.assertStatementState(null, StatementExpectedValues, sruState);
        this.assertStatementState(pspc, PreparedStatementExpectedValues, psruState);
        this.assertStatementState(cspc, CallableStatementExpectedValues, csruState);
        J2EEDataSourceTest.assertLocks(new int[]{14, 12}, cs1);
        int[] updateCounts = sruBatch.executeBatch();
        int[] expectedUpdateCounts = new int[]{1, 1, 2, 1};
        for (int i = 0; i < updateCounts.length; ++i) {
            J2EEDataSourceTest.assertEquals((int)expectedUpdateCounts[i], (int)updateCounts[i]);
        }
        J2EEDataSourceTest.queryOnStatement("sruBatch", new int[]{1, 2, 3, 4, 5, 6, 7, 8}, cs1, sruBatch);
        xar2.end(xid, 0x4000000);
        J2EEDataSourceTest.assertFalse((boolean)aes5.didConnectionClosedEventHappen());
        J2EEDataSourceTest.assertFalse((boolean)aes5.didConnectionErrorEventHappen());
        aes5.resetState();
        xac2.close();
        xac2.close();
        xac2.addConnectionEventListener(null);
        xac2.removeConnectionEventListener(null);
        try {
            xac2.getXAResource();
            if (J2EEDataSourceTest.usingEmbedded()) {
                J2EEDataSourceTest.fail((String)"expected SQLException on closed XAConnection.getXAResource");
            }
        }
        catch (SQLException sqle) {
            J2EEDataSourceTest.assertSQLState("08003", sqle);
        }
        try {
            xac2.getConnection();
            J2EEDataSourceTest.fail((String)"expected SQLException on XAConnection.getConnection");
        }
        catch (SQLException sqle) {
            J2EEDataSourceTest.assertSQLState("08003", sqle);
        }
        try {
            xar2.start(xid, 0x200000);
            J2EEDataSourceTest.fail((String)"expected XAException on XAResource.TMJOIN");
        }
        catch (XAException xae) {
            this.assertXAException("XAResource.start", xae);
        }
        try {
            xar2.end(xid, 0x200000);
            J2EEDataSourceTest.fail((String)"expected XAException on XAResource.TMJOIN");
        }
        catch (XAException xae) {
            this.assertXAException("XAResource.end", xae);
        }
        try {
            xar2.commit(xid, true);
            J2EEDataSourceTest.fail((String)"expected XAException on XAResource.commit");
        }
        catch (XAException xae) {
            this.assertXAException("XAResource.commit", xae);
        }
        try {
            xar2.prepare(xid);
            J2EEDataSourceTest.fail((String)"expected XAException on XAResource.prepare");
        }
        catch (XAException xae) {
            this.assertXAException("XAResource.prepare", xae);
        }
        try {
            xar2.recover(0);
            J2EEDataSourceTest.fail((String)"expected XAException on XAResource.recover");
        }
        catch (XAException xae) {
            this.assertXAException("XAResource.recover", xae);
        }
        try {
            xar2.prepare(xid);
            J2EEDataSourceTest.fail((String)"expected XAException on XAResource.prepare");
        }
        catch (XAException xae) {
            this.assertXAException("XAResource.prepare", xae);
        }
        try {
            xar2.isSameRM(xar2);
            J2EEDataSourceTest.fail((String)"expected XAException on XAResource.isSameRM");
        }
        catch (XAException xae) {
            this.assertXAException("XAResource.isSameRM", xae);
        }
        cs1.rollback();
        sruState.close();
        psruState.close();
        csruState.close();
        psParams.close();
        sruBatch.close();
        sru1.close();
        sru2.close();
        sru3.close();
        cs1.close();
        cs2.close();
        xac.removeConnectionEventListener(null);
        xac.close();
        xac2.close();
        TestConfiguration.getCurrent().shutdownDatabase();
    }

    public void testSetSchemaInXAConnection() throws SQLException {
        XADataSource dsx = J2EEDataSource.getXADataSource();
        XAConnection xac3 = dsx.getXAConnection();
        Connection conn3 = xac3.getConnection();
        Statement st3 = conn3.createStatement();
        st3.execute("SET SCHEMA SCHEMA_Patricio");
        st3.close();
        PreparedStatement ps3 = conn3.prepareStatement("INSERT INTO Patricio VALUES (?, ?)");
        ps3.setString(1, "Patricio");
        ps3.setInt(2, 3);
        ps3.executeUpdate();
        J2EEDataSourceTest.assertEquals((int)1, (int)ps3.getUpdateCount());
        ps3.close();
        conn3.close();
        xac3.close();
    }

    public void testSchemaIsReset() throws SQLException {
        String userSchema = "USERSCHEMA";
        ConnectionPoolDataSource cpDs = J2EEDataSource.getConnectionPoolDataSource();
        J2EEDataSource.setBeanProperty(cpDs, "createDatabase", "create");
        this.doTestSchemaIsReset(cpDs.getPooledConnection("USERSCHEMA", "secret"), "USERSCHEMA");
        if (J2EEDataSourceTest.usingDerbyNetClient()) {
            J2EEDataSource.setBeanProperty(cpDs, "maxStatements", new Integer(7));
            this.doTestSchemaIsReset(cpDs.getPooledConnection("USERSCHEMA", "secret"), "USERSCHEMA");
        }
    }

    private void doTestSchemaIsReset(PooledConnection pc, String userSchema) throws SQLException {
        Connection con1 = pc.getConnection();
        JDBC.assertCurrentSchema(con1, userSchema);
        Statement stmt1 = con1.createStatement();
        stmt1.execute("set schema APP");
        stmt1.close();
        JDBC.assertCurrentSchema(con1, "APP");
        con1.close();
        Connection con2 = pc.getConnection();
        JDBC.assertCurrentSchema(con2, userSchema);
        con2.close();
        Connection con3 = pc.getConnection();
        JDBC.assertCurrentSchema(con3, userSchema);
        con3.close();
        pc.close();
    }

    public void testSchemaIsResetWhenDeleted() throws SQLException {
        String userSchema = "AUSER";
        ConnectionPoolDataSource cpDs = J2EEDataSource.getConnectionPoolDataSource();
        J2EEDataSource.setBeanProperty(cpDs, "createDatabase", "create");
        PooledConnection pc = cpDs.getPooledConnection("AUSER", "secret");
        Connection con = pc.getConnection();
        JDBC.assertCurrentSchema(con, "AUSER");
        Statement stmt = con.createStatement();
        stmt.executeUpdate("create table schematest (id int)");
        stmt.executeUpdate("drop table schematest");
        stmt.executeUpdate("drop schema AUSER restrict");
        stmt.close();
        con.close();
        con = pc.getConnection();
        JDBC.assertCurrentSchema(con, "AUSER");
        stmt = con.createStatement();
        stmt.executeUpdate("create table schematest (id int)");
        stmt.executeUpdate("drop table schematest");
        stmt.close();
        JDBC.assertCurrentSchema(con, "AUSER");
        con.close();
        pc.close();
    }

    public void testAutoCommitOnXAResourceStart() throws SQLException, XAException {
        ResultSet rs4;
        Statement s4;
        Connection conn4;
        cdsXid xid4a;
        XAConnection xac4;
        block13: {
            XADataSource dsx = J2EEDataSource.getXADataSource();
            xac4 = dsx.getXAConnection();
            xid4a = null;
            if (J2EEDataSourceTest.usingEmbedded()) {
                xid4a = new cdsXid(4, 23, 76);
            } else if (J2EEDataSourceTest.usingDerbyNetClient()) {
                xid4a = new cdsXid(5, 23, 76);
            }
            conn4 = xac4.getConnection();
            J2EEDataSourceTest.assertTrue((boolean)conn4.getAutoCommit());
            s4 = conn4.createStatement(1003, 1007, 2);
            rs4 = s4.executeQuery("select i from autocommitxastart");
            rs4.next();
            J2EEDataSourceTest.assertEquals((int)1, (int)rs4.getInt(1));
            rs4.next();
            J2EEDataSourceTest.assertEquals((int)2, (int)rs4.getInt(1));
            xac4.getXAResource().start(xid4a, 0);
            xac4.getXAResource().end(xid4a, 0x4000000);
            try {
                rs4.next();
                J2EEDataSourceTest.fail((String)"expected an exception indicating resultset is closed.");
            }
            catch (SQLException sqle) {
                if (!J2EEDataSourceTest.usingDerbyNetClient()) break block13;
                J2EEDataSourceTest.assertSQLState("XCL16", sqle);
            }
        }
        conn4.setAutoCommit(false);
        J2EEDataSourceTest.assertFalse((boolean)conn4.getAutoCommit());
        rs4 = s4.executeQuery("select i from autocommitxastart");
        rs4.next();
        J2EEDataSourceTest.assertEquals((int)1, (int)rs4.getInt(1));
        rs4.next();
        J2EEDataSourceTest.assertEquals((int)2, (int)rs4.getInt(1));
        if (J2EEDataSourceTest.usingEmbedded()) {
            xid4a = new cdsXid(4, 93, 103);
        } else if (J2EEDataSourceTest.usingDerbyNetClient()) {
            xid4a = new cdsXid(5, 93, 103);
        }
        try {
            xac4.getXAResource().start(xid4a, 0);
        }
        catch (XAException xae) {
            if (J2EEDataSourceTest.usingEmbedded()) {
                J2EEDataSourceTest.assertNull((Object)xae.getMessage());
            } else if (J2EEDataSourceTest.usingDerbyNetClient()) {
                J2EEDataSourceTest.assertTrue((xae.getMessage().indexOf("XAER_OUTSIDE") >= 0 ? 1 : 0) != 0);
            }
            J2EEDataSourceTest.assertEquals((int)-9, (int)xae.errorCode);
        }
        rs4.next();
        J2EEDataSourceTest.assertEquals((int)3, (int)rs4.getInt(1));
        rs4.close();
        conn4.rollback();
        conn4.close();
        xac4.close();
    }

    public void testReadOnlyToWritableTran() throws SQLException, Exception {
        Statement s = this.createStatement();
        s.executeUpdate("delete from autocommitxastart where i = 6");
        s.executeUpdate("delete from autocommitxastart where i = 7");
        XADataSource dsx = J2EEDataSource.getXADataSource();
        XAConnection xac5 = dsx.getXAConnection();
        cdsXid xid5a = new cdsXid(5, 119, -127);
        Connection conn5 = xac5.getConnection();
        Statement sru5a = conn5.createStatement();
        XAResource xar = xac5.getXAResource();
        xar.start(xid5a, 0);
        conn5.setReadOnly(true);
        if (J2EEDataSourceTest.usingEmbedded()) {
            this.assertConnectionState(2, 2, false, true, conn5);
        } else if (J2EEDataSourceTest.usingDerbyNetClient()) {
            this.assertConnectionState(2, 2, false, false, conn5);
        }
        ResultSet rs5 = sru5a.executeQuery("select count(*) from autocommitxastart");
        rs5.next();
        J2EEDataSourceTest.assertEquals((int)5, (int)rs5.getInt(1));
        rs5.close();
        xar.end(xid5a, 0x4000000);
        xar.commit(xid5a, true);
        conn5.close();
        conn5 = xac5.getConnection();
        sru5a = conn5.createStatement();
        xar.start(xid5a, 0);
        this.assertConnectionState(2, 2, false, false, conn5);
        sru5a.executeUpdate("insert into autocommitxastart values 6,7");
        rs5 = sru5a.executeQuery("select count(*) from autocommitxastart");
        rs5.next();
        J2EEDataSourceTest.assertEquals((int)7, (int)rs5.getInt(1));
        xar.end(xid5a, 0x4000000);
        xar.commit(xid5a, true);
        conn5.close();
        xac5.close();
        sru5a.close();
    }

    public void testJira95pds() throws Exception {
        try {
            ConnectionPoolDataSource pds = J2EEDataSource.getConnectionPoolDataSource();
            JDBCDataSource.setBeanProperty(pds, "databaseName", "jdbc:derby:boo");
            pds.getPooledConnection();
            J2EEDataSourceTest.fail((String)"expected an SQLException!");
        }
        catch (SQLException sqle) {
            J2EEDataSourceTest.assertSQLState("XCY00", sqle);
        }
        catch (Exception e) {
            throw e;
        }
    }

    public void testJira95xads() throws SQLException {
        try {
            XADataSource dxs = J2EEDataSource.getXADataSource();
            JDBCDataSource.setBeanProperty(dxs, "databaseName", "jdbc:derby:boo");
            dxs.getXAConnection().getConnection();
            J2EEDataSourceTest.fail((String)"expected an SQLException!");
        }
        catch (SQLException sqle) {
            J2EEDataSourceTest.assertSQLState("XCY00", sqle);
        }
    }

    public void testBadConnectionAttributeSyntax() throws SQLException {
        ConnectionPoolDataSource cpds = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.setBeanProperty(cpds, "ConnectionAttributes", "bad");
        try {
            cpds.getPooledConnection();
            J2EEDataSourceTest.fail((String)"should have seen an error");
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("XJ028", e);
        }
        XADataSource xads = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xads, "ConnectionAttributes", "bad");
        try {
            xads.getXAConnection();
            J2EEDataSourceTest.fail((String)"should have seen an error");
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("XJ028", e);
        }
    }

    public void testClientDSConnectionAttributes() throws SQLException {
        if (J2EEDataSourceTest.usingEmbedded()) {
            return;
        }
        ClientConnectionPoolDataSource cpds = new ClientConnectionPoolDataSource();
        J2EEDataSourceTest.dsConnectionRequests(new String[]{"08001", "08001", "08001", "08001", "08001", "08001", "08001", "08001", "08001"}, (ConnectionPoolDataSource)cpds);
        cpds.setConnectionAttributes("databaseName=" + dbName);
        J2EEDataSourceTest.dsConnectionRequests(new String[]{"08001", "08001", "08001", "08001", "08001", "08001", "08001", "08001", "08001"}, (ConnectionPoolDataSource)cpds);
        cpds.setConnectionAttributes(null);
        cpds.setConnectionAttributes("databaseName=kangaroo");
        cpds.setDatabaseName(dbName);
        J2EEDataSourceTest.dsConnectionRequests(new String[]{"OK", "08001", "OK", "OK", "08001", "08001", "OK", "OK", "OK"}, (ConnectionPoolDataSource)cpds);
        cpds.setConnectionAttributes(null);
        cpds.setDatabaseName(null);
        ClientXADataSource xads = new ClientXADataSource();
        J2EEDataSourceTest.dsConnectionRequests(new String[]{"08001", "08001", "08001", "08001", "08001", "08001", "08001", "08001", "08001"}, (XADataSource)xads);
        xads.setConnectionAttributes("databaseName=wombat");
        J2EEDataSourceTest.dsConnectionRequests(new String[]{"08001", "08001", "08001", "08001", "08001", "08001", "08001", "08001", "08001"}, (XADataSource)xads);
        xads.setConnectionAttributes(null);
        xads.setConnectionAttributes("databaseName=kangaroo");
        xads.setDatabaseName("wombat");
        J2EEDataSourceTest.dsConnectionRequests(new String[]{"OK", "08001", "OK", "OK", "08001", "08001", "OK", "OK", "OK"}, (XADataSource)xads);
        xads.setConnectionAttributes(null);
        xads.setDatabaseName(null);
    }

    public void testDSRequestAuthentication() throws Exception {
        JDBCClient dsclient = this.getTestConfiguration().getJDBCClient();
        String dsName = dsclient.getDataSourceClassName();
        DataSource ds = (DataSource)Class.forName(dsName).newInstance();
        JDBCDataSource.setBeanProperty(ds, "attributesAsPassword", Boolean.TRUE);
        J2EEDataSourceTest.dsConnectionRequests(new String[]{"XJ004", "XJ004", "XJ004", "XJ028", "XJ028", "XJ004", "XJ004", "XJ004", "XJ004"}, ds);
        JDBCDataSource.setBeanProperty(ds, "attributesAsPassword", Boolean.FALSE);
        JDBCDataSource.setBeanProperty(ds, "attributesAsPassword", Boolean.TRUE);
        JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "databaseName=kangaroo");
        J2EEDataSourceTest.dsConnectionRequests(new String[]{"XJ004", "XJ004", "XJ004", "XJ028", "XJ028", "XJ004", "XJ004", "XJ004", "XJ004"}, ds);
        JDBCDataSource.setBeanProperty(ds, "attributesAsPassword", Boolean.FALSE);
        JDBCDataSource.clearStringBeanProperty(ds, "connectionAttributes");
        J2EEDataSourceTest.setDatabaseProperty("derby.user.fred", "wilma");
        J2EEDataSourceTest.setDatabaseProperty("derby.user.APP", "APP");
        J2EEDataSourceTest.setDatabaseProperty("derby.authentication.provider", "BUILTIN");
        J2EEDataSourceTest.setDatabaseProperty("derby.connection.requireAuthentication", "true");
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
        try {
            ds.getConnection();
        }
        catch (SQLException sqle) {
            J2EEDataSourceTest.assertSQLState("XJ015", sqle);
        }
        JDBCDataSource.clearStringBeanProperty(ds, "databaseName");
        JDBCDataSource.clearStringBeanProperty(ds, "shutdownDatabase");
        JDBCDataSource.setBeanProperty(ds, "attributesAsPassword", Boolean.TRUE);
        J2EEDataSourceTest.dsConnectionRequests(new String[]{"XJ004", "XJ004", "XJ004", "XJ028", "XJ028", "XJ004", "XJ004", "XJ004", "XJ004"}, ds);
        JDBCDataSource.setBeanProperty(ds, "attributesAsPassword", Boolean.FALSE);
        JDBCDataSource.setBeanProperty(ds, "attributesAsPassword", Boolean.TRUE);
        JDBCDataSource.setBeanProperty(ds, "user", "fred");
        JDBCDataSource.setBeanProperty(ds, "password", "databaseName=" + dbName + ";password=wilma");
        J2EEDataSourceTest.dsConnectionRequests(new String[]{"XJ004", "XJ004", "XJ004", "XJ028", "XJ028", "XJ004", "XJ004", "XJ004", "XJ004"}, ds);
        JDBCDataSource.setBeanProperty(ds, "attributesAsPassword", Boolean.FALSE);
        JDBCDataSource.clearStringBeanProperty(ds, "user");
        JDBCDataSource.clearStringBeanProperty(ds, "password");
        ds = null;
        String cpdsName = dsclient.getConnectionPoolDataSourceClassName();
        ConnectionPoolDataSource cpds = (ConnectionPoolDataSource)Class.forName(cpdsName).newInstance();
        J2EEDataSourceTest.dsConnectionRequests(new String[]{"XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004"}, cpds);
        JDBCDataSource.setBeanProperty(cpds, "connectionAttributes", "databaseName=" + dbName);
        J2EEDataSourceTest.dsConnectionRequests(new String[]{"XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004"}, cpds);
        JDBCDataSource.clearStringBeanProperty(cpds, "connectionAttributes");
        JDBCDataSource.setBeanProperty(cpds, "attributesAsPassword", Boolean.TRUE);
        J2EEDataSourceTest.dsConnectionRequests(new String[]{"XJ004", "XJ004", "XJ004", "XJ028", "XJ028", "XJ004", "XJ004", "XJ004", "XJ004"}, cpds);
        JDBCDataSource.setBeanProperty(cpds, "attributesAsPassword", Boolean.FALSE);
        JDBCDataSource.setBeanProperty(cpds, "attributesAsPassword", Boolean.TRUE);
        JDBCDataSource.setBeanProperty(cpds, "user", "fred");
        JDBCDataSource.setBeanProperty(cpds, "password", "databaseName=" + dbName + ";password=wilma");
        J2EEDataSourceTest.dsConnectionRequests(new String[]{"XJ004", "XJ004", "XJ004", "XJ028", "XJ028", "XJ004", "XJ004", "XJ004", "XJ004"}, cpds);
        JDBCDataSource.setBeanProperty(cpds, "attributesAsPassword", Boolean.FALSE);
        JDBCDataSource.clearStringBeanProperty(cpds, "user");
        JDBCDataSource.clearStringBeanProperty(cpds, "password");
        cpds = null;
        String xadsName = dsclient.getXADataSourceClassName();
        XADataSource xads = (XADataSource)Class.forName(xadsName).newInstance();
        J2EEDataSourceTest.dsConnectionRequests(new String[]{"08006", "08006", "08006", "08006", "08006", "08006", "08006", "08006", "08006"}, xads);
        JDBCDataSource.setBeanProperty(xads, "databaseName", dbName);
        J2EEDataSourceTest.dsConnectionRequests(new String[]{"08004", "08004", "08004", "OK", "08004", "08004", "08004", "08004", "08004"}, xads);
        JDBCDataSource.clearStringBeanProperty(xads, "databaseName");
        JDBCDataSource.setBeanProperty(xads, "connectionAttributes", "databaseName=" + dbName);
        J2EEDataSourceTest.dsConnectionRequests(new String[]{"08006", "08006", "08006", "08006", "08006", "08006", "08006", "08006", "08006"}, xads);
        JDBCDataSource.clearStringBeanProperty(xads, "connectionAttributes");
        JDBCDataSource.setBeanProperty(xads, "attributesAsPassword", Boolean.TRUE);
        J2EEDataSourceTest.dsConnectionRequests(new String[]{"08006", "08006", "08006", "08006", "08006", "08006", "08006", "08006", "08006"}, xads);
        JDBCDataSource.setBeanProperty(xads, "attributesAsPassword", Boolean.FALSE);
        JDBCDataSource.setBeanProperty(xads, "databaseName", dbName);
        JDBCDataSource.setBeanProperty(xads, "attributesAsPassword", Boolean.TRUE);
        J2EEDataSourceTest.dsConnectionRequests(new String[]{"08004", "08004", "08004", "XJ028", "XJ028", "08004", "08004", "OK", "08004"}, xads);
        JDBCDataSource.setBeanProperty(xads, "attributesAsPassword", Boolean.FALSE);
        JDBCDataSource.clearStringBeanProperty(xads, "databaseName");
        J2EEDataSourceTest.setDatabaseProperty("derby.connection.requireAuthentication", "false");
        TestConfiguration.getCurrent().shutdownDatabase();
    }

    public void testClientTraceFileDSConnectionAttribute() throws SQLException {
        if (J2EEDataSourceTest.usingEmbedded()) {
            return;
        }
        ConnectionPoolDataSource cpds = J2EEDataSource.getConnectionPoolDataSource();
        String traceFile = "trace3.out";
        JDBCDataSource.setBeanProperty(cpds, "connectionAttributes", "traceFile=" + traceFile);
        ((ClientConnectionPoolDataSource)cpds).getConnection();
        JDBCDataSource.clearStringBeanProperty(cpds, "connectionAttributes");
        traceFile = "trace4.out";
        JDBCDataSource.setBeanProperty(cpds, "traceFile", traceFile);
        ((ClientConnectionPoolDataSource)cpds).getConnection();
        cpds = null;
        XADataSource xads = J2EEDataSource.getXADataSource();
        traceFile = "trace5.out";
        JDBCDataSource.setBeanProperty(xads, "connectionAttributes", "traceFile=" + traceFile);
        ((ClientXADataSource)xads).getConnection();
        JDBCDataSource.clearStringBeanProperty(xads, "connectionAttributes");
        traceFile = "trace6.out";
        JDBCDataSource.setBeanProperty(xads, "traceFile", traceFile);
        ((ClientXADataSource)xads).getConnection();
        J2EEDataSourceTest.assertTraceFilesExist();
    }

    private static void assertTraceFilesExist() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (int i = 3; i < 6; ++i) {
                    String traceFileName = "trace" + (i + 1) + ".out";
                    File traceFile = new File(traceFileName);
                    if (i == 4) continue;
                    Assert.assertTrue((boolean)traceFile.exists());
                }
                return null;
            }
        });
    }

    public void testClientMessageTextConnectionAttribute() throws SQLException {
        if (J2EEDataSourceTest.usingEmbedded()) {
            return;
        }
        String retrieveMessageTextProperty = "retrieveMessageText";
        ClientConnectionPoolDataSource cpds = new ClientConnectionPoolDataSource();
        cpds.setDatabaseName(dbName);
        cpds.setConnectionAttributes(retrieveMessageTextProperty + "=false");
        Connection conn = cpds.getConnection();
        J2EEDataSourceTest.assertMessageText(conn, "false");
        conn.close();
        cpds.setConnectionAttributes(retrieveMessageTextProperty + "=true");
        conn = cpds.getConnection();
        J2EEDataSourceTest.assertMessageText(conn, "true");
        cpds.setConnectionAttributes(null);
        conn.close();
        ClientXADataSource xads = new ClientXADataSource();
        xads.setDatabaseName(dbName);
        xads.setConnectionAttributes(retrieveMessageTextProperty + "=false");
        conn = xads.getConnection();
        J2EEDataSourceTest.assertMessageText(conn, "false");
        conn.close();
        xads.setConnectionAttributes(retrieveMessageTextProperty + "=true");
        conn = xads.getConnection();
        J2EEDataSourceTest.assertMessageText(conn, "true");
        conn.close();
        xads.setConnectionAttributes(null);
    }

    private static void assertMessageText(Connection conn, String retrieveMessageTextValue) throws SQLException {
        try {
            conn.createStatement().executeQuery("SELECT * FROM APP.NOTTHERE");
        }
        catch (SQLException e) {
            J2EEDataSourceTest.assertSQLState("42X05", e);
            if (retrieveMessageTextValue.equals("true")) {
                J2EEDataSourceTest.assertTrue((e.getMessage().indexOf("does not exist") >= 0 ? 1 : 0) != 0);
            }
            J2EEDataSourceTest.assertTrue((e.getMessage().indexOf("does not exist") == -1 ? 1 : 0) != 0);
        }
    }

    public void testDescriptionProperty() throws SQLException, Exception {
        this.subTestDataSourceDescription((DataSource)((Object)J2EEDataSource.getConnectionPoolDataSource()));
        this.subTestDataSourceDescription((DataSource)((Object)J2EEDataSource.getXADataSource()));
    }

    private void subTestDataSourceDescription(DataSource ds) throws Exception {
        String setDescription = "Everything you ever wanted to know about this datasource";
        JDBCDataSource.setBeanProperty(ds, "description", setDescription);
        ds.getConnection();
        J2EEDataSourceTest.assertEquals((Object)setDescription, (Object)JDBCDataSource.getBeanProperty(ds, "description"));
        JDBCDataSource.clearStringBeanProperty(ds, "description");
        J2EEDataSourceTest.assertNull((Object)JDBCDataSource.getBeanProperty(ds, "description"));
    }

    public void testXAHoldability() throws SQLException, XAException {
        if (J2EEDataSourceTest.usingDerbyNetClient()) {
            return;
        }
        XADataSource dscsx = J2EEDataSource.getXADataSource();
        XAConnection xac = dscsx.getXAConnection();
        XAResource xr = xac.getXAResource();
        cdsXid xid = new cdsXid(25, 21, 1);
        Connection conn1 = xac.getConnection();
        J2EEDataSourceTest.assertTrue((boolean)conn1.getAutoCommit());
        J2EEDataSourceTest.assertEquals((int)1, (int)conn1.getHoldability());
        xr.start(xid, 0);
        J2EEDataSourceTest.assertFalse((boolean)conn1.getAutoCommit());
        J2EEDataSourceTest.assertEquals((int)2, (int)conn1.getHoldability());
        xr.end(xid, 0x4000000);
        conn1.commit();
        conn1.close();
        xid = new cdsXid(27, 21, 1);
        xr.start(xid, 0);
        conn1 = xac.getConnection();
        J2EEDataSourceTest.assertEquals((int)2, (int)conn1.getHoldability());
        J2EEDataSourceTest.assertFalse((boolean)conn1.getAutoCommit());
        xr.end(xid, 0x4000000);
        conn1.rollback();
        Connection conn = xac.getConnection();
        conn.setAutoCommit(false);
        conn.setHoldability(2);
        J2EEDataSourceTest.assertEquals((int)2, (int)conn.getHoldability());
        Statement s = conn.createStatement();
        J2EEDataSourceTest.assertEquals((int)2, (int)s.getResultSetHoldability());
        s.executeUpdate("insert into hold_30 values (1,'init2'), (2, 'init3'), (3,'init3')");
        s.executeUpdate("insert into hold_30 values (4,'init4'), (5, 'init5'), (6,'init6')");
        s.executeUpdate("insert into hold_30 values (7,'init7'), (8, 'init8'), (9,'init9')");
        J2EEDataSourceTest.assertEquals((int)2, (int)s.getResultSetHoldability());
        Statement sh = conn.createStatement(1003, 1007, 1);
        PreparedStatement psh = conn.prepareStatement("select id from hold_30 for update", 1003, 1007, 1);
        CallableStatement csh = conn.prepareCall("select id from hold_30 for update", 1003, 1007, 1);
        J2EEDataSourceTest.assertEquals((int)1, (int)sh.getResultSetHoldability());
        J2EEDataSourceTest.assertEquals((int)1, (int)psh.getResultSetHoldability());
        J2EEDataSourceTest.assertEquals((int)1, (int)csh.getResultSetHoldability());
        ResultSet rsh = sh.executeQuery("select id from hold_30 for update");
        rsh.next();
        J2EEDataSourceTest.assertEquals((int)1, (int)rsh.getInt(1));
        rsh.next();
        J2EEDataSourceTest.assertEquals((int)2, (int)rsh.getInt(1));
        conn.commit();
        rsh.next();
        J2EEDataSourceTest.assertEquals((int)3, (int)rsh.getInt(1));
        conn.commit();
        xid = new cdsXid(23, 21, 1);
        xr.start(xid, 0);
        Statement stmtInsideGlobalTransaction = conn.createStatement();
        PreparedStatement prepstmtInsideGlobalTransaction = conn.prepareStatement("select id from hold_30");
        CallableStatement callablestmtInsideGlobalTransaction = conn.prepareCall("select id from hold_30");
        J2EEDataSourceTest.assertEquals((int)2, (int)conn.getHoldability());
        J2EEDataSourceTest.assertEquals((int)2, (int)s.getResultSetHoldability());
        if (J2EEDataSourceTest.usingEmbedded()) {
            J2EEDataSourceTest.assertEquals((int)2, (int)sh.getResultSetHoldability());
        } else if (J2EEDataSourceTest.usingDerbyNetClient()) {
            J2EEDataSourceTest.assertEquals((int)1, (int)sh.getResultSetHoldability());
        }
        J2EEDataSourceTest.assertEquals((int)2, (int)stmtInsideGlobalTransaction.getResultSetHoldability());
        J2EEDataSourceTest.assertEquals((int)2, (int)prepstmtInsideGlobalTransaction.getResultSetHoldability());
        J2EEDataSourceTest.assertEquals((int)2, (int)callablestmtInsideGlobalTransaction.getResultSetHoldability());
        ResultSet rsx = s.executeQuery("select id from hold_30 for update");
        rsx.next();
        J2EEDataSourceTest.assertEquals((int)1, (int)rsx.getInt(1));
        rsx.next();
        J2EEDataSourceTest.assertEquals((int)2, (int)rsx.getInt(1));
        xr.end(xid, 0x4000000);
        try {
            rsx.next();
            J2EEDataSourceTest.fail((String)"rsx's connection not active id ");
        }
        catch (SQLException sqle) {
            J2EEDataSourceTest.assertSQLState("08003", sqle);
        }
        try {
            rsh.next();
            J2EEDataSourceTest.fail((String)"rsh's connection not active id ");
        }
        catch (SQLException sqle) {
            J2EEDataSourceTest.assertSQLState("XCL16", sqle);
        }
        xr.start(xid, 0x200000);
        Statement stmtAfterGlobalTransactionResume = conn.createStatement();
        PreparedStatement prepstmtAfterGlobalTransactionResume = conn.prepareStatement("select id from hold_30");
        CallableStatement callablestmtAfterGlobalTransactionResume = conn.prepareCall("select id from hold_30");
        J2EEDataSourceTest.assertEquals((int)2, (int)conn.getHoldability());
        J2EEDataSourceTest.assertEquals((int)2, (int)s.getResultSetHoldability());
        if (J2EEDataSourceTest.usingEmbedded()) {
            J2EEDataSourceTest.assertEquals((int)2, (int)sh.getResultSetHoldability());
        } else if (J2EEDataSourceTest.usingDerbyNetClient()) {
            J2EEDataSourceTest.assertEquals((int)1, (int)sh.getResultSetHoldability());
        }
        J2EEDataSourceTest.assertEquals((int)2, (int)stmtInsideGlobalTransaction.getResultSetHoldability());
        J2EEDataSourceTest.assertEquals((int)2, (int)prepstmtInsideGlobalTransaction.getResultSetHoldability());
        J2EEDataSourceTest.assertEquals((int)2, (int)callablestmtInsideGlobalTransaction.getResultSetHoldability());
        J2EEDataSourceTest.assertEquals((int)2, (int)stmtAfterGlobalTransactionResume.getResultSetHoldability());
        J2EEDataSourceTest.assertEquals((int)2, (int)prepstmtAfterGlobalTransactionResume.getResultSetHoldability());
        J2EEDataSourceTest.assertEquals((int)2, (int)callablestmtAfterGlobalTransactionResume.getResultSetHoldability());
        if (J2EEDataSourceTest.usingEmbedded()) {
            rsx.next();
            J2EEDataSourceTest.assertEquals((int)3, (int)rsx.getInt(1));
        }
        xr.end(xid, 0x4000000);
        if (xr.prepare(xid) != 3) {
            xr.commit(xid, false);
        }
        try {
            rsx.next();
            J2EEDataSourceTest.fail((String)"rsx's connection not active id (B)");
        }
        catch (SQLException sqle) {
            J2EEDataSourceTest.assertSQLState("XCL16", sqle);
        }
        try {
            rsh.next();
            J2EEDataSourceTest.fail((String)"rsh's should be closed (B)");
        }
        catch (SQLException sqle) {
            J2EEDataSourceTest.assertSQLState("XCL16", sqle);
        }
        conn.setHoldability(1);
        J2EEDataSourceTest.assertEquals((int)1, (int)conn.getHoldability());
        xid = new cdsXid(24, 21, 1);
        xr.start(xid, 0);
        J2EEDataSourceTest.assertEquals((int)2, (int)conn.getHoldability());
        try {
            conn.setHoldability(1);
            J2EEDataSourceTest.fail((String)"allowed to set hold mode in xa transaction");
        }
        catch (SQLException sqle) {
            J2EEDataSourceTest.assertSQLState("XJ05C", sqle);
        }
        Statement shxa = conn.createStatement(1003, 1007, 1);
        J2EEDataSourceTest.assertEquals((int)2, (int)s.getResultSetHoldability());
        J2EEDataSourceTest.assertEquals((int)10000, (int)conn.getWarnings().getErrorCode());
        shxa.close();
        shxa = conn.prepareStatement("select id from hold_30", 1003, 1007, 1);
        J2EEDataSourceTest.assertEquals((int)2, (int)s.getResultSetHoldability());
        J2EEDataSourceTest.assertEquals((int)10000, (int)conn.getWarnings().getErrorCode());
        shxa.close();
        shxa = conn.prepareCall("CALL SYSCS_UTIL.SYSCS_CHECKPOINT_DATABASE()", 1003, 1007, 1);
        J2EEDataSourceTest.assertEquals((int)2, (int)s.getResultSetHoldability());
        J2EEDataSourceTest.assertEquals((int)10000, (int)conn.getWarnings().getErrorCode());
        shxa.close();
        if (J2EEDataSourceTest.usingEmbedded()) {
            J2EEDataSourceTest.assertEquals((int)2, (int)sh.getResultSetHoldability());
            sh.executeQuery("select id from hold_30").close();
            sh.execute("select id from hold_30");
            sh.getResultSet().close();
            J2EEDataSourceTest.assertEquals((int)2, (int)psh.getResultSetHoldability());
            psh.executeQuery().close();
            psh.execute();
            psh.getResultSet().close();
            J2EEDataSourceTest.assertEquals((int)2, (int)csh.getResultSetHoldability());
            csh.executeQuery().close();
            csh.execute();
            csh.getResultSet().close();
        }
        sh.executeUpdate("insert into hold_30 values(10, 'init10')");
        xr.end(xid, 0x4000000);
        J2EEDataSourceTest.assertEquals((int)1, (int)conn.getHoldability());
        s.close();
        sh.close();
        csh.close();
        psh.close();
        rsx.close();
        stmtInsideGlobalTransaction.close();
        prepstmtInsideGlobalTransaction.close();
        callablestmtInsideGlobalTransaction.close();
        stmtAfterGlobalTransactionResume.close();
        prepstmtAfterGlobalTransactionResume.close();
        callablestmtAfterGlobalTransactionResume.close();
        conn.close();
        xac.close();
        TestConfiguration.getCurrent().shutdownDatabase();
    }

    public void testConnectionLeakInDatabaseMetaData() throws SQLException {
        ConnectionPoolDataSource cpDs = J2EEDataSource.getConnectionPoolDataSource();
        PooledConnection pc = cpDs.getPooledConnection();
        Connection con1 = pc.getConnection();
        DatabaseMetaData dmd1 = con1.getMetaData();
        J2EEDataSourceTest.assertSame((Object)con1, (Object)dmd1.getConnection());
        con1.close();
        Connection con2 = pc.getConnection();
        DatabaseMetaData dmd2 = con2.getMetaData();
        J2EEDataSourceTest.assertSame((Object)con2, (Object)dmd2.getConnection());
        try {
            dmd1.getConnection();
            J2EEDataSourceTest.fail((String)"Should have thrown no current connection exception");
        }
        catch (SQLException sqle) {
            J2EEDataSourceTest.assertSQLState("08003", sqle);
        }
        con2.close();
        pc.close();
        try {
            dmd2.getConnection();
            J2EEDataSourceTest.fail((String)"Should have thrown no current connection exception");
        }
        catch (SQLException sqle) {
            J2EEDataSourceTest.assertSQLState("08003", sqle);
        }
    }

    public void testDerby3799() throws SQLException {
        ConnectionPoolDataSource cpDs = J2EEDataSource.getConnectionPoolDataSource();
        PooledConnection pc = cpDs.getPooledConnection();
        Connection con1 = pc.getConnection();
        Statement stmt = con1.createStatement();
        ResultSet rs = stmt.executeQuery("select dClob from derby3799");
        J2EEDataSourceTest.assertTrue((boolean)rs.next());
        rs.getString(1);
        rs.close();
        con1.close();
        Connection con2 = pc.getConnection();
        stmt = con2.createStatement();
        rs = stmt.executeQuery("select dClob from derby3799");
        J2EEDataSourceTest.assertTrue((boolean)rs.next());
        rs.getString(1);
        con2.close();
    }

    public void timeoutTestDerby1144PooledDS() throws SQLException {
        PooledConnection pc1 = null;
        ConnectionPoolDataSource ds = J2EEDataSource.getConnectionPoolDataSource();
        pc1 = ds.getPooledConnection();
        J2EEDataSourceTest.assertPooledConnHoldability("PooledConnection", pc1);
        pc1.close();
        pc1 = ds.getPooledConnection();
        J2EEDataSourceTest.assertPooledConnAutoCommit("PooledConnection", pc1);
        pc1.close();
        pc1 = ds.getPooledConnection();
        this.assertPooledConnIso("PooledConnection", pc1);
        pc1.close();
    }

    public void timeoutTestDerby1144XADS() throws SQLException {
        XADataSource xds = J2EEDataSource.getXADataSource();
        XAConnection xpc1 = xds.getXAConnection();
        this.assertPooledConnIso("XAConnection", xpc1);
        xpc1.close();
    }

    private static void assertPooledConnAutoCommit(String desc, PooledConnection pc1) throws SQLException {
        Connection conn = pc1.getConnection();
        conn.setAutoCommit(true);
        conn = pc1.getConnection();
        boolean autocommit = conn.getAutoCommit();
        J2EEDataSourceTest.assertTrue((boolean)autocommit);
        conn.close();
    }

    private static void assertPooledConnHoldability(String desc, PooledConnection pc1) throws SQLException {
        Connection conn = pc1.getConnection();
        conn.setHoldability(2);
        conn = pc1.getConnection();
        J2EEDataSourceTest.assertConnHoldability(conn, 1);
        conn.close();
    }

    private static void assertConnHoldability(Connection conn, int expectedHoldability) throws SQLException {
        int holdability = conn.getHoldability();
        J2EEDataSourceTest.assertEquals((int)expectedHoldability, (int)holdability);
    }

    private void assertPooledConnIso(String pooledConnType, PooledConnection pc) throws SQLException {
        Connection conn = pc.getConnection();
        J2EEDataSourceTest.setupDerby1144Table(conn);
        conn.setTransactionIsolation(1);
        this.assertIsoLocks(conn, 1);
        conn.close();
        Connection newconn = pc.getConnection();
        this.assertIsoLocks(newconn, 2);
    }

    private static void setupDerby1144Table(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.executeUpdate("INSERT INTO intTable VALUES(1)");
        stmt.executeUpdate("INSERT INTO intTable VALUES(2)");
        conn.commit();
    }

    private void assertIsoLocks(Connection conn, int expectedIsoLevel) throws SQLException {
        int conniso = conn.getTransactionIsolation();
        J2EEDataSourceTest.assertEquals((int)expectedIsoLevel, (int)conniso);
        boolean selectTimedOut = this.selectTimesoutDuringUpdate(conn);
        switch (conniso) {
            case 1: {
                J2EEDataSourceTest.assertFalse((boolean)selectTimedOut);
                break;
            }
            case 2: {
                J2EEDataSourceTest.assertTrue((boolean)selectTimedOut);
                break;
            }
            default: {
                System.out.println("No test support for isolation level");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean selectTimesoutDuringUpdate(Connection conn) throws SQLException {
        Connection updateConn = null;
        conn.setAutoCommit(false);
        try {
            updateConn = this.openDefaultConnection();
            updateConn.setAutoCommit(false);
            Statement upStmt = updateConn.createStatement();
            upStmt.executeUpdate("update intTable set i = 3");
            Statement stmt = conn.createStatement();
            JDBC.assertDrainResults(stmt.executeQuery("Select * from intTable"));
            stmt.close();
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("40XL1")) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            try {
                conn.rollback();
                updateConn.rollback();
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return false;
    }

    private void assertConnectionState(int expectedHoldability, int expectedIsolation, boolean expectedCommitSetting, boolean expectedReadOnly, Connection conn) throws SQLException {
        J2EEDataSourceTest.assertEquals((int)expectedHoldability, (int)conn.getHoldability());
        J2EEDataSourceTest.assertEquals((int)expectedIsolation, (int)conn.getTransactionIsolation());
        J2EEDataSourceTest.assertEquals((boolean)expectedCommitSetting, (boolean)conn.getAutoCommit());
        J2EEDataSourceTest.assertEquals((boolean)expectedReadOnly, (boolean)conn.isReadOnly());
    }

    private static void setDatabaseProperty(String property, String value) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource();
        Connection cadmin = ds.getConnection();
        CallableStatement cs = cadmin.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)");
        cs.setString(1, property);
        cs.setString(2, value);
        cs.execute();
        cs.close();
        cadmin.close();
    }

    private void setHoldability(Connection conn, boolean hold) throws SQLException {
        conn.setHoldability(hold ? 1 : 2);
    }

    private static void dsConnectionRequests(String[] expectedValues, DataSource ds) {
        if (J2EEDataSourceTest.usingEmbedded()) {
            SecurityCheck.assertSourceSecurity(ds, "javax.sql.DataSource");
        }
        try {
            ds.getConnection();
            if (!expectedValues[0].equals("OK")) {
                J2EEDataSourceTest.fail((String)" expected connection to fail, but was OK");
            }
        }
        catch (SQLException sqle) {
            J2EEDataSourceTest.assertSQLState(expectedValues[0], sqle);
        }
        J2EEDataSourceTest.dsConnectionRequest(expectedValues[1], ds, null, null);
        J2EEDataSourceTest.dsConnectionRequest(expectedValues[2], ds, "fred", null);
        J2EEDataSourceTest.dsConnectionRequest(expectedValues[3], ds, "fred", "wilma");
        J2EEDataSourceTest.dsConnectionRequest(expectedValues[4], ds, null, "wilma");
        J2EEDataSourceTest.dsConnectionRequest(expectedValues[5], ds, null, "databaseName=wombat");
        J2EEDataSourceTest.dsConnectionRequest(expectedValues[6], ds, "fred", "databaseName=wombat");
        J2EEDataSourceTest.dsConnectionRequest(expectedValues[7], ds, "fred", "databaseName=wombat;password=wilma");
        J2EEDataSourceTest.dsConnectionRequest(expectedValues[8], ds, "fred", "databaseName=wombat;password=betty");
    }

    private static void dsConnectionRequest(String expectedValue, DataSource ds, String user, String ConnAttr) {
        try {
            ds.getConnection(user, ConnAttr);
            if (!expectedValue.equals("OK")) {
                J2EEDataSourceTest.fail((String)" expected connection to fail, but was OK");
            }
        }
        catch (SQLException sqle) {
            J2EEDataSourceTest.assertSQLState(expectedValue, sqle);
        }
    }

    private static void dsConnectionRequests(String[] expectedValues, ConnectionPoolDataSource ds) {
        try {
            ds.getPooledConnection();
            if (!expectedValues[0].equals("OK")) {
                J2EEDataSourceTest.fail((String)" expected connection to fail, but was OK");
            }
        }
        catch (SQLException sqle) {
            J2EEDataSourceTest.assertSQLState(expectedValues[0], sqle);
        }
        J2EEDataSourceTest.dsConnectionRequest(expectedValues[1], ds, null, null);
        J2EEDataSourceTest.dsConnectionRequest(expectedValues[2], ds, "fred", null);
        J2EEDataSourceTest.dsConnectionRequest(expectedValues[3], ds, "fred", "wilma");
        J2EEDataSourceTest.dsConnectionRequest(expectedValues[4], ds, null, "wilma");
        J2EEDataSourceTest.dsConnectionRequest(expectedValues[5], ds, null, "databaseName=wombat");
        J2EEDataSourceTest.dsConnectionRequest(expectedValues[6], ds, "fred", "databaseName=wombat");
        J2EEDataSourceTest.dsConnectionRequest(expectedValues[7], ds, "fred", "databaseName=wombat;password=wilma");
        J2EEDataSourceTest.dsConnectionRequest(expectedValues[8], ds, "fred", "databaseName=wombat;password=betty");
    }

    private static void dsConnectionRequest(String expectedValue, ConnectionPoolDataSource ds, String user, String ConnAttr) {
        try {
            ds.getPooledConnection(user, ConnAttr);
            if (!expectedValue.equals("OK")) {
                J2EEDataSourceTest.fail((String)" expected connection to fail, but was OK");
            }
        }
        catch (SQLException sqle) {
            J2EEDataSourceTest.assertSQLState(expectedValue, sqle);
        }
    }

    private static void dsConnectionRequests(String[] expectedValues, XADataSource ds) {
        try {
            ds.getXAConnection();
            if (!expectedValues[0].equals("OK")) {
                J2EEDataSourceTest.fail((String)" expected connection to fail, but was OK");
            }
        }
        catch (SQLException sqle) {
            J2EEDataSourceTest.assertSQLState(expectedValues[0], sqle);
        }
        J2EEDataSourceTest.dsConnectionRequest(expectedValues[1], ds, null, null);
        J2EEDataSourceTest.dsConnectionRequest(expectedValues[2], ds, "fred", null);
        J2EEDataSourceTest.dsConnectionRequest(expectedValues[3], ds, "fred", "wilma");
        J2EEDataSourceTest.dsConnectionRequest(expectedValues[4], ds, null, "wilma");
        J2EEDataSourceTest.dsConnectionRequest(expectedValues[5], ds, null, "databaseName=" + dbName);
        J2EEDataSourceTest.dsConnectionRequest(expectedValues[6], ds, "fred", "databaseName=" + dbName);
        J2EEDataSourceTest.dsConnectionRequest(expectedValues[7], ds, "fred", "databaseName=" + dbName + ";password=wilma");
        J2EEDataSourceTest.dsConnectionRequest(expectedValues[8], ds, "fred", "databaseName=" + dbName + ";password=betty");
    }

    private static void dsConnectionRequest(String expectedValue, XADataSource ds, String user, String ConnAttr) {
        try {
            ds.getXAConnection(user, ConnAttr);
            if (!expectedValue.equals("OK")) {
                J2EEDataSourceTest.fail((String)" expected connection to fail, but was OK");
            }
        }
        catch (SQLException sqle) {
            J2EEDataSourceTest.assertSQLState(expectedValue, sqle);
        }
    }

    protected void assertXAException(String tag, XAException xae) {
        if (J2EEDataSourceTest.usingEmbedded()) {
            J2EEDataSourceTest.assertEquals((String)"No current connection.", (String)xae.getMessage());
        } else if (J2EEDataSourceTest.usingDerbyNetClient()) {
            J2EEDataSourceTest.assertEquals((String)"XAER_RMFAIL : No current connection.", (String)xae.getMessage());
        }
        Throwable t = xae.getCause();
        if (t instanceof SQLException) {
            J2EEDataSourceTest.assertSQLState("08003", (SQLException)t);
        }
    }

    private static void queryOnStatement(String expectedCursorName, int[] expectedValues, Connection conn, Statement s) throws SQLException {
        if (J2EEDataSourceTest.usingEmbedded()) {
            J2EEDataSourceTest.assertEquals((Object)conn, (Object)s.getConnection());
        }
        J2EEDataSourceTest.resultSetQuery(expectedCursorName, expectedValues, s.executeQuery("select * from intTable"));
    }

    private static void resultSetQuery(String expectedCursorName, int[] expectedValues, ResultSet rs) throws SQLException {
        if (J2EEDataSourceTest.usingEmbedded()) {
            SecurityCheck.assertSourceSecurity(rs, "java.sql.ResultSet");
        }
        J2EEDataSourceTest.assertEquals((String)expectedCursorName, (String)rs.getCursorName());
        int index = 0;
        while (rs.next()) {
            J2EEDataSourceTest.assertEquals((int)expectedValues[index], (int)rs.getInt(1));
            ++index;
        }
        J2EEDataSourceTest.assertEquals((int)expectedValues.length, (int)index++);
        rs.close();
    }

    private static void assertLocks(int[] expectedValues, Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("SELECT XID, sum(cast (LOCKCOUNT AS INT)) FROM SYSCS_DIAG.LOCK_TABLE AS L GROUP BY XID");
        int xact_index = 0;
        while (rs.next()) {
            if (expectedValues != null) {
                J2EEDataSourceTest.assertEquals((int)expectedValues[xact_index], (int)rs.getInt(2));
            } else {
                J2EEDataSourceTest.fail((String)"expected no locks");
            }
            ++xact_index;
        }
        if (expectedValues != null) {
            J2EEDataSourceTest.assertEquals((int)expectedValues.length, (int)xact_index);
        }
        rs.close();
        s.close();
    }

    private void assertStatementState(int[] parameterExpectedValues, int[] expectedValues, Statement s) throws SQLException {
        J2EEDataSourceTest.assertEquals((int)expectedValues[0], (int)s.getResultSetType());
        J2EEDataSourceTest.assertEquals((int)expectedValues[1], (int)s.getResultSetConcurrency());
        J2EEDataSourceTest.assertEquals((int)expectedValues[2], (int)s.getFetchDirection());
        J2EEDataSourceTest.assertEquals((int)expectedValues[3], (int)s.getFetchSize());
        J2EEDataSourceTest.assertEquals((int)expectedValues[4], (int)s.getMaxFieldSize());
        J2EEDataSourceTest.assertEquals((int)expectedValues[5], (int)s.getMaxRows());
        J2EEDataSourceTest.assertEquals((int)expectedValues[6], (int)s.getResultSetHoldability());
        if (s instanceof PreparedStatement) {
            PreparedStatement ps = (PreparedStatement)s;
            ParameterMetaData psmd = ps.getParameterMetaData();
            J2EEDataSourceTest.assertEquals((int)parameterExpectedValues[0], (int)psmd.getParameterCount());
            for (int i = 1; i <= psmd.getParameterCount(); ++i) {
                J2EEDataSourceTest.assertEquals((int)parameterExpectedValues[i], (int)psmd.getParameterType(i));
            }
        }
    }

    private Statement createFloatStatementForStateChecking(int[] StatementExpectedValues, Connection conn) throws SQLException {
        Statement s = this.internalCreateFloatStatementForStateChecking(conn);
        s.setCursorName("StokeNewington");
        s.setFetchDirection(1001);
        s.setFetchSize(444);
        s.setMaxFieldSize(713);
        s.setMaxRows(19);
        this.assertStatementState(null, StatementExpectedValues, s);
        return s;
    }

    private Statement internalCreateFloatStatementForStateChecking(Connection conn) throws SQLException {
        return conn.createStatement(1004, 1007, 1);
    }

    private PreparedStatement createFloatStatementForStateChecking(int[] parameterExpectedValues, int[] PreparedStatementExpectedValues, Connection conn, String sql) throws SQLException {
        PreparedStatement s = this.internalCreateFloatStatementForStateChecking(conn, sql);
        s.setCursorName("StokeNewington");
        s.setFetchDirection(1001);
        s.setFetchSize(888);
        s.setMaxFieldSize(317);
        s.setMaxRows(91);
        this.assertStatementState(parameterExpectedValues, PreparedStatementExpectedValues, s);
        return s;
    }

    private PreparedStatement internalCreateFloatStatementForStateChecking(Connection conn, String sql) throws SQLException {
        return conn.prepareStatement(sql, 1004, 1007, 1);
    }

    private CallableStatement createFloatCallForStateChecking(int[] parameterExpectedValues, int[] CallableStatementExpectedValues, Connection conn, String sql) throws SQLException {
        CallableStatement s = this.internalCreateFloatCallForStateChecking(conn, sql);
        s.setCursorName("StokeNewington");
        s.setFetchDirection(1001);
        s.setFetchSize(999);
        s.setMaxFieldSize(137);
        s.setMaxRows(85);
        this.assertStatementState(parameterExpectedValues, CallableStatementExpectedValues, s);
        return s;
    }

    private CallableStatement internalCreateFloatCallForStateChecking(Connection conn, String sql) throws SQLException {
        return conn.prepareCall(sql, 1004, 1007, 1);
    }

    private void assertConnectionOK(Object[] expectedValues, String dsName, Connection conn) throws SQLException {
        J2EEDataSourceTest.assertEquals((int)((Integer)expectedValues[0]), (int)conn.getHoldability());
        try {
            conn.releaseSavepoint(conn.setSavepoint());
            if (conn.getAutoCommit()) {
                J2EEDataSourceTest.fail((String)"expected a SQLExpection (savepoint with autocommit on");
            }
            if (!((String)expectedValues[1]).equals("OK")) {
                J2EEDataSourceTest.fail((String)"expected a SQLExpection (savepoint with autocommit on");
            }
        }
        catch (SQLException sqle) {
            if (conn.getAutoCommit()) {
                J2EEDataSourceTest.assertSQLState("XJ010", sqle);
            }
            if (((String)expectedValues[1]).equals("OK")) {
                throw sqle;
            }
            J2EEDataSourceTest.assertSQLState((String)expectedValues[1], sqle);
        }
        if (J2EEDataSourceTest.usingEmbedded()) {
            SecurityCheck.assertSourceSecurity(conn, "java.sql.Connection");
            SecurityCheck.assertSourceSecurity(conn.getMetaData(), "java.sql.DatabaseMetaData");
        }
        J2EEDataSourceTest.assertEquals((int)((Integer)expectedValues[2]), (int)conn.getTransactionIsolation());
        J2EEDataSourceTest.assertEquals((boolean)((Boolean)expectedValues[3]), (boolean)conn.getAutoCommit());
        J2EEDataSourceTest.assertEquals((boolean)((Boolean)expectedValues[4]), (boolean)conn.isReadOnly());
        if (dsName.endsWith("DataSource")) {
            J2EEDataSourceTest.assertNull((Object)conn.getWarnings());
        }
        Statement s1 = conn.createStatement();
        this.assertStatementOK(dsName, conn, s1);
        this.assertStatementOK(dsName, conn, conn.createStatement(1004, 1007));
        Connection c1 = conn.getMetaData().getConnection();
        if (!J2EEDataSourceTest.usingDerbyNetClient() && dsName.indexOf("DataSource") >= 0) {
            J2EEDataSourceTest.assertEquals((Object)c1, (Object)conn);
        }
        try {
            conn.setTypeMap(Collections.EMPTY_MAP);
            if (!((String)expectedValues[5]).equals("OK")) {
                J2EEDataSourceTest.fail((String)" expected an sqlexception on setTypeMap(EMPTY_MAP)");
            }
        }
        catch (SQLException sqle) {
            if (((String)expectedValues[5]).equals("OK")) {
                throw sqle;
            }
            J2EEDataSourceTest.assertSQLState((String)expectedValues[5], sqle);
        }
        try {
            conn.setTypeMap(null);
            J2EEDataSourceTest.fail((String)"setTypeMap(null) should throw exception");
        }
        catch (SQLException sqle) {
            J2EEDataSourceTest.assertSQLState((String)expectedValues[6], sqle);
        }
        try {
            HashMap map = new HashMap();
            map.put("name", (Class<?>)((Object)"class"));
            conn.setTypeMap(map);
            if (!((String)expectedValues[7]).equals("OK")) {
                J2EEDataSourceTest.fail((String)" expected an sqlexception on setTypeMap(map)");
            }
        }
        catch (SQLException sqle) {
            if (((String)expectedValues[7]).equals("OK")) {
                throw sqle;
            }
            J2EEDataSourceTest.assertSQLState((String)expectedValues[7], sqle);
        }
        this.assertConnectionPreClose(dsName, conn);
        conn.close();
        conn.close();
        try {
            conn.createStatement();
            J2EEDataSourceTest.fail((String)(dsName + " <closedconn>.createStatement(), " + "expected 08003 - No current connection"));
        }
        catch (SQLException sqle) {
            J2EEDataSourceTest.assertSQLState("08003", sqle);
        }
        try {
            s1.execute("values 1");
            J2EEDataSourceTest.fail((String)(dsName + " <closedstmt>.execute(), " + "expected 08003 - No current connection"));
        }
        catch (SQLException sqle) {
            J2EEDataSourceTest.assertSQLState("08003", sqle);
        }
    }

    private void assertConnectionPreClose(String dsName, Connection conn) throws SQLException {
        conn.setHoldability(2);
        if (!dsName.equals("Nested2")) {
            try {
                conn.setReadOnly(true);
            }
            catch (SQLException sqle) {
                J2EEDataSourceTest.assertSQLState("25501", sqle);
            }
        }
    }

    private void assertStatementOK(String dsName, Connection conn, Statement s) throws SQLException {
        ResultSet rs;
        Connection c1;
        if (J2EEDataSourceTest.usingEmbedded()) {
            SecurityCheck.assertSourceSecurity(s, "java.sql.Statement");
        }
        if ((c1 = s.getConnection()) != conn && !J2EEDataSourceTest.usingDerbyNetClient() && dsName.indexOf("DataSource") >= 0) {
            J2EEDataSourceTest.fail((String)"incorrect connection object returned for Statement.getConnection()");
        }
        s.addBatch("insert into intTable values 1");
        s.addBatch("insert into intTable values 2,3");
        int[] states = s.executeBatch();
        if (states[0] != 1) {
            J2EEDataSourceTest.fail((String)"invalid update count for first batch statement");
        }
        if (states[1] != 2) {
            J2EEDataSourceTest.fail((String)"invalid update count for second batch statement");
        }
        if ((rs = s.executeQuery("VALUES 1")).getStatement() != s) {
            J2EEDataSourceTest.fail((String)("incorrect Statement object returned for ResultSet.getStatement for " + dsName));
        }
        rs.close();
        s.close();
    }

    private static void PoolReset(String type, PooledConnection pc) throws SQLException {
        J2EEDataSourceTest.PoolResetWork("1", "C", pc.getConnection());
        J2EEDataSourceTest.PoolResetWork("2", "", pc.getConnection());
        J2EEDataSourceTest.PoolResetWork("3", "D", pc.getConnection());
        pc.close();
    }

    private static void PoolResetWork(String expectedID, String tableAction, Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        if (tableAction.equals("C")) {
            s.execute("CREATE TABLE PoolResetWork (id int generated always as identity, name varchar(25))");
        }
        ResultSet rs = s.executeQuery("VALUES IDENTITY_VAL_LOCAL()");
        rs.next();
        String val = rs.getString(1);
        if (!rs.wasNull() || val != null) {
            J2EEDataSourceTest.fail((String)("initial call to IDENTITY_VAL_LOCAL is not NULL!" + val));
        }
        rs.close();
        s.executeUpdate("INSERT INTO PoolResetWork(name) values ('derby-222')");
        rs = s.executeQuery("VALUES IDENTITY_VAL_LOCAL()");
        rs.next();
        val = rs.getString(1);
        J2EEDataSourceTest.assertEquals((String)expectedID, (String)val);
        rs.close();
        if (tableAction.equals("D")) {
            s.execute("DROP TABLE PoolResetWork");
        }
        s.close();
        conn.close();
    }

    private static void assertToString(Connection conn) throws Exception {
        J2EEDataSourceTest.assertStringFormat(conn);
        String str = conn.toString();
        if (conns.containsKey(str)) {
            throw new Exception("ERROR: Connection toString() is not unique: " + str);
        }
        conns.put(str, conn);
    }

    private static void assertStringFormat(PooledConnection pc) throws Exception {
        String prefix = J2EEDataSourceTest.assertStringPrefix(pc);
        String connstr = pc.toString();
        String format = prefix + " \\(ID = [0-9]+\\), Physical Connection = " + "<none>|" + CONNSTRING_FORMAT;
        J2EEDataSourceTest.assertTrue((boolean)connstr.matches(format));
    }

    private static void assertStringFormat(Connection conn) {
        J2EEDataSourceTest.assertStringPrefix(conn);
        String str = conn.toString();
        J2EEDataSourceTest.assertTrue((String)("\nexpected format:\n \\S+@\\-?[0-9]+.* \\(XID = .*\\), \\(SESSIONID = [0-9]+\\), \\(DATABASE = [A-Za-z]+\\), \\(DRDAID = .*\\) \nactual value:\n " + str), (boolean)str.matches(CONNSTRING_FORMAT));
    }

    private static String assertStringPrefix(Object conn) {
        String connstr = conn.toString();
        String prefix = conn.getClass().getName() + "@" + conn.hashCode();
        J2EEDataSourceTest.assertTrue((boolean)connstr.startsWith(prefix));
        return prefix;
    }

    private static void assertToString(DataSource ds) throws Exception {
        J2EEDataSourceTest.clearConnections();
        int numConnections = 10;
        for (int i = 0; i < numConnections; ++i) {
            Connection conn = ds.getConnection();
            J2EEDataSourceTest.assertToString(conn);
        }
        J2EEDataSourceTest.clearConnections();
    }

    private static void clearConnections() throws SQLException {
        Iterator it = conns.values().iterator();
        while (it.hasNext()) {
            Connection conn = (Connection)it.next();
            conn.close();
        }
        conns.clear();
    }

    private void assertTenConnectionsUnique() throws Exception {
        J2EEDataSourceTest.clearConnections();
        int numConnections = 10;
        for (int i = 0; i < numConnections; ++i) {
            Connection conn = this.openDefaultConnection();
            J2EEDataSourceTest.assertToString(conn);
        }
        J2EEDataSourceTest.clearConnections();
    }

    private static void assertToString(XADataSource xds) throws Exception {
        XAConnection xc;
        int numConnections = 10;
        Hashtable<String, XAConnection> xaConns = new Hashtable<String, XAConnection>();
        for (int i = 0; i < numConnections; ++i) {
            xc = xds.getXAConnection();
            J2EEDataSourceTest.assertStringFormat(xc);
            String str = xc.toString();
            J2EEDataSourceTest.assertNull(xaConns.get(str));
            xaConns.put(str, xc);
        }
        Iterator it = xaConns.values().iterator();
        J2EEDataSourceTest.clearConnections();
        while (it.hasNext()) {
            xc = (XAConnection)it.next();
            Connection conn = xc.getConnection();
            J2EEDataSourceTest.assertToString(conn);
        }
        J2EEDataSourceTest.clearConnections();
        it = xaConns.values().iterator();
        while (it.hasNext()) {
            xc = (XAConnection)it.next();
            xc.close();
        }
        xaConns.clear();
    }

    private static void assertToString(ConnectionPoolDataSource pds) throws Exception {
        PooledConnection pc;
        int numConnections = 10;
        Hashtable<String, PooledConnection> pooledConns = new Hashtable<String, PooledConnection>();
        for (int i = 0; i < numConnections; ++i) {
            pc = pds.getPooledConnection();
            J2EEDataSourceTest.assertStringFormat(pc);
            String str = pc.toString();
            J2EEDataSourceTest.assertNull(pooledConns.get(str));
            pooledConns.put(str, pc);
        }
        Iterator it = pooledConns.values().iterator();
        J2EEDataSourceTest.clearConnections();
        while (it.hasNext()) {
            pc = (PooledConnection)it.next();
            Connection conn = pc.getConnection();
            J2EEDataSourceTest.assertToString(conn);
        }
        J2EEDataSourceTest.clearConnections();
        it = pooledConns.values().iterator();
        while (it.hasNext()) {
            pc = (PooledConnection)it.next();
            pc.close();
        }
        pooledConns.clear();
    }

    private static String getNestedMethodName() {
        return "checkNesConn";
    }

    public static void checkNesConn(String dsName) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        String EmptyMapValue = null;
        String NullMapValue = null;
        String MapMapValue = null;
        if (J2EEDataSourceTest.usingEmbedded()) {
            EmptyMapValue = "OK";
            NullMapValue = "XJ081";
            MapMapValue = "0A000";
        } else if (J2EEDataSourceTest.usingDerbyNetClient()) {
            EmptyMapValue = "0A000";
            NullMapValue = "0A000";
            MapMapValue = "0A000";
        }
        Object[] expectedValues = new Object[]{new Integer(1), "OK", new Integer(2), new Boolean(false), new Boolean(false), EmptyMapValue, NullMapValue, MapMapValue};
        new J2EEDataSourceTest("J2EEDataSourceTest").assertConnectionOK(expectedValues, dsName, conn);
    }
}

