/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClobTest
extends BaseJDBCTestCase {
    private static final int TRANSFER_BUFFER_SIZE = 4096;
    private static final int SET_STRING = 1;
    private static final int SET_ASCII_STREAM = 2;
    private static final int SET_CHARACTER_STREAM = 4;
    private static int nextUniqueId = 150000;
    private static final String NORWEGIAN_LETTERS = "\u00e6\u00f8\u00e5\u00e6\u00f8\u00e5\u00e6\u00f8\u00e5\u00e6\u00f8\u00e5\u00e6\u00f8\u00e5\u00e6\u00f8\u00e5";
    private Clob clob = null;

    public ClobTest(String testName) {
        super(testName);
    }

    public void testGetSubString_PosOneTooBig() throws SQLException {
        long length = this.clob.length();
        ClobTest.assertEquals((String)"", (String)this.clob.getSubString(length + 1L, 10));
    }

    public void testGetSubString_PosTooBig() {
        try {
            this.clob.getSubString(999L, 10);
            ClobTest.fail((String)"getSubString with pos larger than clob length must fail");
        }
        catch (SQLException sqle) {
            ClobTest.assertSQLState("XJ076", sqle);
        }
    }

    public void testGetSubString_PosNegative() throws SQLException {
        try {
            this.clob.getSubString(-123L, 10);
            ClobTest.fail((String)"getSubString with negative position should fail");
        }
        catch (SQLException sqle) {
            ClobTest.assertSQLState("XJ070", sqle);
        }
    }

    public void testGetSubString_RequestZeroLength_PosValid() throws SQLException {
        ClobTest.assertEquals((String)"", (String)this.clob.getSubString(1L, 0));
    }

    public void testGetSubString_RequestZeroLength_PosTooBig() throws SQLException {
        try {
            this.clob.getSubString(999L, 0);
        }
        catch (SQLException sqle) {
            ClobTest.assertSQLState("XJ076", sqle);
        }
    }

    public void testGetSubString_BiggerThanInternalBuffer() throws IOException, SQLException {
        int stringLength = 0x100000;
        this.transferData(new LoopingAlphabetReader(stringLength), this.clob.setCharacterStream(1L), 4096);
        String obtained = this.clob.getSubString(1L, stringLength);
        ClobTest.assertEquals((String)"Incorrect string length", (int)stringLength, (int)obtained.length());
        CharArrayWriter charWriter = new CharArrayWriter();
        this.transferData(new LoopingAlphabetReader(stringLength), charWriter, 4096);
        ClobTest.assertEquals((String)"String do not match", (String)charWriter.toString(), (String)obtained);
    }

    public void testLengthOnEmptyClob() throws SQLException {
        ClobTest.assertEquals((long)0L, (long)this.clob.length());
    }

    public void testInsertStringOnEmptyClob_Singlebyte() throws SQLException {
        String content = "This is the new Clob content.";
        this.clob.setString(1L, content);
        ClobTest.assertEquals((String)"Incorrect length reported", (long)content.length(), (long)this.clob.length());
        ClobTest.assertEquals((String)"Clob content is incorrect", (String)content, (String)this.clob.getSubString(1L, content.length()));
    }

    public void testInsertStringOnEmptyClob_Multibyte() throws SQLException {
        String content = "A few Norwegian letters: \u00e6, \u00e5, \u00f8.";
        this.clob.setString(1L, content);
        ClobTest.assertEquals((String)"Incorrect length reported", (long)content.length(), (long)this.clob.length());
        ClobTest.assertEquals((String)"Clob content is incorrect", (String)content, (String)this.clob.getSubString(1L, content.length()));
    }

    public void testInsertStringInMiddle_Multibyte() throws SQLException {
        this.clob.setString(1L, NORWEGIAN_LETTERS);
        ClobTest.assertEquals((String)NORWEGIAN_LETTERS, (String)this.clob.getSubString(1L, NORWEGIAN_LETTERS.length()));
        char[] modifiedContent = NORWEGIAN_LETTERS.toCharArray();
        modifiedContent[4] = 97;
        modifiedContent[5] = 98;
        modifiedContent[8] = 99;
        String newContent = String.copyValueOf(modifiedContent);
        ClobTest.assertEquals((int)1, (int)this.clob.setString(9L, "c"));
        ClobTest.assertEquals((int)1, (int)this.clob.setString(5L, "a"));
        ClobTest.assertEquals((int)1, (int)this.clob.setString(6L, "b"));
        ClobTest.assertEquals((String)"Clob content is incorrect", (String)newContent, (String)this.clob.getSubString(1L, newContent.length()));
    }

    public void testLengthAfterInsertOnEmpty() throws IOException, SQLException {
        this.insertDataWithToken("", 0L, 0L, 1);
        ClobTest.assertEquals((long)0L, (long)this.clob.length());
        this.clob.setString(1L, "TEST");
        ClobTest.assertEquals((long)4L, (long)this.clob.length());
        this.clob.setString(1L, "TEST");
        ClobTest.assertEquals((long)4L, (long)this.clob.length());
        this.clob.setString(5L, "TEST");
        ClobTest.assertEquals((long)8L, (long)this.clob.length());
        this.clob.setString(7L, "TEST");
        ClobTest.assertEquals((long)10L, (long)this.clob.length());
        this.clob.truncate(4L);
        ClobTest.assertEquals((long)4L, (long)this.clob.length());
        this.clob.setString(4L, "TEST");
        ClobTest.assertEquals((long)7L, (long)this.clob.length());
    }

    public void testLengthAfterInsertOnLarge() throws IOException, SQLException {
        String token = "SWEETSPOT";
        long curLength = 41984 + "SWEETSPOT".length();
        this.insertDataWithToken("SWEETSPOT", 32768L, 9216L, 4);
        ClobTest.assertEquals((long)curLength, (long)this.clob.length());
        this.clob.setString(1L, "TEST");
        ClobTest.assertEquals((long)curLength, (long)this.clob.length());
        this.clob.setString(curLength, "X");
        ClobTest.assertEquals((long)curLength, (long)this.clob.length());
        ClobTest.assertEquals((long)32769L, (long)this.clob.position("SWEETSPOT", 17408L));
        this.clob.setString(32769L, "FUNNYSPOT");
        ClobTest.assertEquals((long)curLength, (long)this.clob.length());
        ClobTest.assertEquals((long)-1L, (long)this.clob.position("SWEETSPOT", 17408L));
        this.clob.setString(curLength + 1L, "TEST");
        ClobTest.assertEquals((long)(curLength += 4L), (long)this.clob.length());
    }

    public void testReplaceMultibyteWithSingleByteForwards() throws IOException, SQLException {
        this.clob.setString(1L, NORWEGIAN_LETTERS);
        ClobTest.assertEquals((String)NORWEGIAN_LETTERS, (String)this.clob.getSubString(1L, NORWEGIAN_LETTERS.length()));
        char[] modifiedContent = NORWEGIAN_LETTERS.toCharArray();
        String toInsert = "abcdefghijklmnopqr";
        for (int iz = 0; iz < toInsert.length(); ++iz) {
            modifiedContent[iz] = toInsert.charAt(iz);
            ClobTest.assertEquals((int)1, (int)this.clob.setString(iz + 1, toInsert.substring(iz, iz + 1)));
            ClobTest.assertEquals((String)String.copyValueOf(modifiedContent), (String)this.clob.getSubString(1L, 100));
            ClobTest.assertEquals(new StringReader(String.copyValueOf(modifiedContent)), this.clob.getCharacterStream());
        }
    }

    public void testReplaceMultibyteWithSingleByteBackwards() throws IOException, SQLException {
        this.clob.setString(1L, NORWEGIAN_LETTERS);
        ClobTest.assertEquals((String)NORWEGIAN_LETTERS, (String)this.clob.getSubString(1L, NORWEGIAN_LETTERS.length()));
        char[] modifiedContent = NORWEGIAN_LETTERS.toCharArray();
        String toInsert = "abcdefghijklmnopqr";
        for (int iz = toInsert.length() - 1; iz >= 0; --iz) {
            modifiedContent[iz] = toInsert.charAt(iz);
            ClobTest.assertEquals((int)1, (int)this.clob.setString(iz + 1, toInsert.substring(iz, iz + 1)));
            ClobTest.assertEquals((String)String.copyValueOf(modifiedContent), (String)this.clob.getSubString(1L, 100));
            ClobTest.assertEquals(new StringReader(String.copyValueOf(modifiedContent)), this.clob.getCharacterStream());
        }
    }

    public void testInsertCharacter_ReadOnlyToTemporary() throws IOException, SQLException {
        long skipped;
        this.setAutoCommit(false);
        PreparedStatement ps = this.prepareStatement("insert into ClobTestData values (?,?)");
        int initalSize = 131072;
        ps.setInt(1, 2);
        ps.setCharacterStream(2, (Reader)new LoopingAlphabetReader(initalSize), initalSize);
        ps.executeUpdate();
        PreparedStatement psSelect = this.prepareStatement("select dClob from ClobTestData where id = ?");
        psSelect.setInt(1, 2);
        ResultSet lRs = psSelect.executeQuery();
        lRs.next();
        Clob lClob = lRs.getClob(1);
        lClob.setString(1L, "K");
        Reader r = lClob.getCharacterStream();
        ClobTest.assertEquals((int)75, (int)r.read());
        long length = 1L;
        while ((skipped = r.skip(4096L)) > 0L) {
            length += skipped;
        }
        lRs.close();
        ClobTest.assertEquals((String)"Wrong length!", (long)initalSize, (long)length);
        ps.setInt(1, 10003);
        ps.setClob(2, lClob);
        ps.executeUpdate();
        psSelect.setInt(1, 10003);
        lRs = psSelect.executeQuery();
        lRs.next();
        Clob lClob2 = lRs.getClob(1);
        ClobTest.assertEquals(lClob.getCharacterStream(), lClob2.getCharacterStream());
        ClobTest.assertEquals((long)initalSize, (long)lClob2.length());
    }

    public void testPositionWithString_ASCII_SimplePartialRecurringPattern() throws IOException, SQLException {
        String token = "xxSPOTxx";
        String inserted = "abcdexxSPxabcdexabxxSPxxxSPOTxabcxxSPOTxxabc";
        this.clob.setString(1L, inserted);
        ClobTest.assertEquals((String)"Invalid match position", (long)(inserted.indexOf(token, 0) + 1), (long)this.clob.position(token, 1L));
    }

    public void testPositionWithString_USASCII() throws IOException, SQLException {
        String token = "xxSPOTxx";
        long prefix = 93191L;
        long postfix = 12288L;
        this.insertDataWithToken(token, 93191L, 12288L, 2);
        this.executeTestPositionWithStringToken(token, 93191L);
    }

    public void testPositionWithString_IOS88591() throws IOException, SQLException {
        String token = "xx\u00c6\u00c6\u00c6xx";
        long prefix = 68608L;
        long postfix = 1022L;
        this.insertDataWithToken(token, 68608L, 1022L, 2);
        this.executeTestPositionWithStringToken(token, 68608L);
    }

    public void testPositionWithString_CJK() throws IOException, SQLException {
        long prefix = 11L;
        long postfix = 90L;
        char[] tmpChar = new char[1];
        LoopingAlphabetReader tokenSrc = new LoopingAlphabetReader(1L, CharAlphabet.cjkSubset());
        tokenSrc.read(tmpChar);
        String token = String.copyValueOf(tmpChar);
        this.insertDataWithToken(token, 11L, 90L, 4);
        this.executeTestPositionWithStringToken(token, 11L);
    }

    public void testTruncateZeroOnDisk() throws IOException, SQLException {
        long size = 33799L;
        this.insertDataWithToken("", size, 0L, 4);
        this.truncateToZero(size);
    }

    public void testTruncateZeroInMemory() throws IOException, SQLException {
        long size = 33L;
        this.insertDataWithToken("", size, 0L, 1);
        this.truncateToZero(size);
    }

    private void truncateToZero(long initSize) throws IOException, SQLException {
        ClobTest.assertEquals((long)initSize, (long)this.clob.length());
        this.clob.truncate(0L);
        ClobTest.assertEquals((long)0L, (long)this.clob.length());
        ClobTest.assertEquals((String)"", (String)this.clob.getSubString(1L, 0));
        ClobTest.assertEquals((String)"", (String)this.clob.getSubString(1L, 1));
        ClobTest.assertEquals((int)-1, (int)this.clob.getCharacterStream().read());
    }

    public void testTruncateExactOnDisk() throws IOException, SQLException {
        long size = 33799L;
        this.insertDataWithToken("", size, 0L, 4);
        ClobTest.assertEquals((long)size, (long)this.clob.length());
        this.clob.truncate(size);
        ClobTest.assertEquals((long)size, (long)this.clob.length());
    }

    public void testTruncateExactInMemory() throws IOException, SQLException {
        long size = 33L;
        this.insertDataWithToken("", size, 0L, 1);
        ClobTest.assertEquals((long)size, (long)this.clob.length());
        this.clob.truncate(size);
        ClobTest.assertEquals((long)size, (long)this.clob.length());
    }

    public void testTruncateTooLongOnDisk() throws IOException, SQLException {
        long size = 45064L;
        this.insertDataWithToken("", size, 0L, 4);
        try {
            this.clob.truncate(size * 2L);
            ClobTest.fail((String)"Truncate should have failed, position too large");
        }
        catch (SQLException sqle) {
            ClobTest.assertSQLState("XJ079", sqle);
        }
    }

    public void testTruncateTooLongInMemory() throws IOException, SQLException {
        long size = 44L;
        this.insertDataWithToken("", size, 0L, 1);
        try {
            this.clob.truncate(size * 2L);
            ClobTest.fail((String)"Truncate should have failed, position too large");
        }
        catch (SQLException sqle) {
            ClobTest.assertSQLState("XJ079", sqle);
        }
    }

    public void testGetLengthAfterTruncate() throws IOException, SQLException {
        long initialSize = 89086L;
        long truncateOnceSize = 87049L;
        long truncateTwiceSize = 2065L;
        this.insertDataWithToken("", 89086L, 0L, 2);
        ClobTest.assertEquals((long)89086L, (long)this.clob.length());
        this.clob.truncate(87049L);
        ClobTest.assertEquals((long)87049L, (long)this.clob.length());
        this.clob.truncate(2065L);
        ClobTest.assertEquals((long)2065L, (long)this.clob.length());
        this.clob.truncate(2065L);
        ClobTest.assertEquals((long)2065L, (long)this.clob.length());
    }

    public void testCloningThroughAddBatchWithStream() throws SQLException {
        this.testCloningThroughAddBatch(true, true);
        this.testCloningThroughAddBatch(true, false);
    }

    public void testCloningThroughAddBatchWithString() throws SQLException {
        this.testCloningThroughAddBatch(false, true);
        this.testCloningThroughAddBatch(false, false);
    }

    private void testCloningThroughAddBatch(boolean sourceAsStream, boolean autoCommit) throws SQLException {
        int count = 100;
        boolean savedAutoCommitValue = this.getConnection().getAutoCommit();
        this.setAutoCommit(autoCommit);
        int[] expectedResult = new int[100];
        Arrays.fill(expectedResult, 1);
        PreparedStatement insert = this.prepareStatement("insert into ClobTestData values (?,?)");
        int firstId = nextUniqueId;
        for (int i = 0; i < 100; ++i) {
            insert.setInt(1, nextUniqueId++);
            String str = "Clob-" + i;
            if (sourceAsStream) {
                insert.setCharacterStream(2, (Reader)new StringReader(str), str.length());
            } else {
                insert.setString(2, "Clob-" + i);
            }
            insert.addBatch();
        }
        ClobTest.assertTrue((boolean)Arrays.equals(expectedResult, insert.executeBatch()));
        this.commit();
        PreparedStatement delete = this.prepareStatement("delete from ClobTestData where id = ?");
        for (int i = 0; i < 100; ++i) {
            delete.setInt(1, firstId + i);
            delete.addBatch();
        }
        ClobTest.assertTrue((boolean)Arrays.equals(expectedResult, delete.executeBatch()));
        this.commit();
        this.setAutoCommit(savedAutoCommitValue);
    }

    private void executeTestPositionWithStringToken(String token, long prefixLength) throws IOException, SQLException {
        long TOKEN_POS = prefixLength + 1L;
        ClobTest.assertEquals((long)-1L, (long)this.clob.position(token, TOKEN_POS + 1L));
        ClobTest.assertEquals((long)TOKEN_POS, (long)this.clob.position(token, TOKEN_POS));
        ClobTest.assertEquals((long)TOKEN_POS, (long)this.clob.position(token, 1L));
    }

    protected void setUp() throws Exception {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select dClob from ClobTestData where id = 1");
        ClobTest.assertTrue((boolean)rs.next());
        this.clob = rs.getClob(1);
    }

    protected void tearDown() throws Exception {
        this.clob = null;
        super.tearDown();
    }

    public static Test suite() {
        return new ClobTestSetup(TestConfiguration.defaultSuite(ClobTest.class, false));
    }

    private int transferData(InputStream source, OutputStream dest, int tz) throws IOException {
        int read;
        if (tz < 1) {
            throw new IllegalArgumentException("Buffer size must be 1 or greater: " + tz);
        }
        BufferedInputStream in = new BufferedInputStream(source);
        BufferedOutputStream out = new BufferedOutputStream(dest, tz);
        byte[] bridge = new byte[tz];
        int total = 0;
        while ((read = in.read(bridge, 0, tz)) != -1) {
            out.write(bridge, 0, read);
            total += read;
        }
        in.close();
        out.flush();
        return total;
    }

    private int transferData(Reader source, Writer dest, int tz) throws IOException {
        int read;
        if (tz < 1) {
            throw new IllegalArgumentException("Buffer size must be 1 or greater: " + tz);
        }
        BufferedReader in = new BufferedReader(source);
        BufferedWriter out = new BufferedWriter(dest, tz);
        char[] bridge = new char[tz];
        int total = 0;
        while ((read = in.read(bridge, 0, tz)) != -1) {
            out.write(bridge, 0, read);
            total += read;
        }
        in.close();
        out.flush();
        return total;
    }

    private int transferData(Reader source, int tz) throws IOException, SQLException {
        int read;
        if (tz < 1) {
            throw new IllegalArgumentException("Buffer size must be 1 or greater: " + tz);
        }
        BufferedReader in = new BufferedReader(source);
        char[] bridge = new char[tz];
        int total = 0;
        while ((read = in.read(bridge, 0, tz)) != -1) {
            this.clob.setString((long)total + 1L, String.copyValueOf(bridge, 0, read));
            total += read;
        }
        in.close();
        return total;
    }

    private void insertDataWithToken(String token, long pre, long post, int mode) throws IOException, SQLException {
        long total = 0L;
        switch (mode) {
            case 1: {
                LoopingAlphabetReader charIn = new LoopingAlphabetReader(pre);
                total += (long)this.transferData(charIn, 4096);
                this.clob.setString(pre + 1L, token);
                total += (long)token.length();
                charIn = new LoopingAlphabetReader(post);
                total += (long)this.transferData(charIn, 4096);
                break;
            }
            case 2: {
                OutputStream asciiOut = this.clob.setAsciiStream(1L);
                LoopingAlphabetStream asciiIn = new LoopingAlphabetStream(pre);
                total += (long)this.transferData(asciiIn, asciiOut, 4096);
                byte[] tokenBytes = token.getBytes("ISO-8859-1");
                asciiOut.write(tokenBytes, 0, tokenBytes.length);
                total += (long)tokenBytes.length;
                asciiIn = new LoopingAlphabetStream(post);
                total += (long)this.transferData(asciiIn, asciiOut, 4096);
                break;
            }
            case 4: {
                Writer charOut = this.clob.setCharacterStream(1L);
                LoopingAlphabetReader charIn = new LoopingAlphabetReader(pre);
                total += (long)this.transferData(charIn, charOut, 4096);
                charOut.write(token);
                total += (long)token.length();
                charIn = new LoopingAlphabetReader(post);
                total += (long)this.transferData(charIn, charOut, 4096);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown insertion mode: " + mode);
            }
        }
        ClobTest.assertEquals((String)"Invalid length after insertion", (long)(pre + post + (long)token.length()), (long)this.clob.length());
    }

    private static class ClobTestSetup
    extends BaseJDBCTestSetup {
        ClobTestSetup(Test test) {
            super(test);
        }

        protected void setUp() throws SQLException {
            Connection con = this.getConnection();
            Statement stmt = con.createStatement();
            stmt.execute("create table ClobTestData (id int unique, dClob CLOB)");
            stmt.executeUpdate("insert into ClobTestData values (1, '')");
            stmt.close();
        }

        protected void tearDown() throws Exception {
            Connection con = this.getConnection();
            Statement stmt = con.createStatement();
            stmt.execute("drop table ClobTestData");
            stmt.close();
            super.tearDown();
        }
    }
}

