/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.BufferedOutputStream;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.harness.jvm;
import org.apache.derbyTesting.functionTests.util.ExecProcUtil;

public class runtimeinfo {
    private static Properties properties = new Properties();
    private static jvm jvm;
    private static Vector vCmd;
    private static BufferedOutputStream bos;
    private static String[] RuntimeinfoCmd;
    private static String[] RuntimeinfoLocaleCmd;

    public static void main(String[] args) throws Exception {
        jvm = System.getProperty("java.vm.name") != null && System.getProperty("java.vm.name").equals("J9") ? org.apache.derbyTesting.functionTests.harness.jvm.getJvm("j9_13") : org.apache.derbyTesting.functionTests.harness.jvm.getJvm("currentjvm");
        vCmd = jvm.getCommandLine();
        try {
            ij.getPropertyArg((String[])args);
            Connection conn1 = ij.startJBMS();
            bos = new BufferedOutputStream(System.out, 1024);
            System.out.println("Testing Runtimeinfo");
            ExecProcUtil.execCmdDumpResults(RuntimeinfoCmd, vCmd, bos);
            System.out.println("End test");
            Connection conn2 = ij.startJBMS();
            PreparedStatement ps = runtimeinfo.prepareAndExecuteQuery(conn1, "SELECT count(*) from sys.systables");
            PreparedStatement ps2 = runtimeinfo.prepareAndExecuteQuery(conn1, "VALUES(1)");
            Connection conn3 = ij.startJBMS();
            PreparedStatement ps3 = runtimeinfo.prepareAndExecuteQuery(conn2, "SELECT count(*) from sys.systables");
            PreparedStatement ps4 = runtimeinfo.prepareAndExecuteQuery(conn2, "VALUES(2)");
            System.out.println("Testing Runtimeinfo (locale)");
            ExecProcUtil.execCmdDumpResults(RuntimeinfoLocaleCmd, vCmd, bos);
            System.out.println("End test (locale)");
            ps.close();
            ps2.close();
            ps3.close();
            ps4.close();
            conn1.close();
            conn2.close();
            conn3.close();
            System.out.println("Testing Runtimeinfo after closing connectiosn");
            Thread.sleep(1000L);
            NetworkServerControl derbyServer = new NetworkServerControl(InetAddress.getByName("localhost"), 1527);
            System.out.println(derbyServer.getRuntimeInfo());
            System.out.println("End test");
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static PreparedStatement prepareAndExecuteQuery(Connection conn, String sql) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        rs.next();
        return ps;
    }

    static {
        RuntimeinfoCmd = new String[]{"org.apache.derby.drda.NetworkServerControl", "runtimeinfo"};
        RuntimeinfoLocaleCmd = new String[]{"-Duser.language=err", "-Duser.country=DE", "org.apache.derby.drda.NetworkServerControl", "runtimeinfo"};
    }
}

