/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.suites;

import java.sql.SQLException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.JDBC;

public final class EncryptionSuite
extends BaseJDBCTestCase {
    public EncryptionSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Encrpytion Suite");
        if (JDBC.vmSupportsJDBC3()) {
            suite.addTest(Decorator.encryptedDatabase(EncryptionSuite.baseSuite("default")));
            suite.addTest(EncryptionSuite.encryptedSuite("AES/CBC/NoPadding"));
            suite.addTest(EncryptionSuite.encryptedSuite("DES/ECB/NoPadding"));
            suite.addTest(EncryptionSuite.encryptedSuite("DESede/CFB/NoPadding"));
            suite.addTest(EncryptionSuite.encryptedSuite("DES/CBC/NoPadding"));
            suite.addTest(EncryptionSuite.encryptedSuite("Blowfish/CBC/NoPadding"));
            suite.addTest(EncryptionSuite.encryptedSuite("AES/OFB/NoPadding"));
        }
        return suite;
    }

    private static Test encryptedSuite(String algorithm) {
        return Decorator.encryptedDatabase(EncryptionSuite.baseSuite(algorithm), algorithm);
    }

    private static Test baseSuite(String algorithm) {
        TestSuite suite = new TestSuite("Encryption Algorithm: " + algorithm);
        suite.addTestSuite(EncryptionSuite.class);
        return suite;
    }

    public void testEncryptedDBConnection() throws SQLException {
        this.getConnection().close();
    }
}

