// This file is part of Deark.

// This is a generated file. Do not edit.

// This data is zlib-compressed. After decompression,
// it is a CP932-to-Unicode lookup table for the double-byte
// CP932 characters, from 0x8000 to 0xffff.
// For compressibility reasons, it is organized as:
// - 32768 "plane" or special bytes
// - 32768 high bytes
// - 32768 low bytes
// For more information, see the "deark-extras" project
// listed in the main Deark readme file.

#define DE_CP932DATA_ORIG_LEN 98304
#define DE_CP932DATA_LEN 17611
static const u8 de_cp932data[DE_CP932DATA_LEN] = {
	120,218,237,157,7,88,19,77,187,247,67,80,154,82,164,23,
	233,138,34,22,164,247,34,77,90,32,132,146,144,64,32,16,
	2,132,14,161,247,78,104,161,133,94,236,5,177,128,93,44,
	8,98,71,69,68,17,17,16,197,94,80,44,4,145,111,19,
	80,17,245,209,247,61,121,207,117,190,115,246,183,187,51,179,
	187,100,119,239,41,247,252,119,244,154,133,64,64,64,254,143,
	49,78,231,127,254,19,254,231,30,114,28,172,3,32,255,93,
	188,165,111,239,102,150,95,255,197,155,49,48,151,126,3,244,
	127,143,1,208,127,209,62,40,88,250,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,255,223,2,253,253,62,248,202,
	15,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	2,242,151,64,153,250,67,232,191,119,89,232,255,141,44,251,
	31,112,63,232,223,159,253,239,250,228,9,244,127,82,41,66,
	255,179,15,12,253,255,178,194,255,47,104,87,63,124,222,231,
	119,165,0,253,151,175,7,253,71,55,8,133,210,87,200,76,
	48,115,99,232,31,103,21,134,254,199,50,96,238,195,66,161,
	191,49,3,250,211,31,64,255,149,34,131,254,240,235,191,249,
	253,236,189,231,253,240,23,57,197,220,250,5,133,252,34,227,
	127,188,229,223,63,193,252,252,131,254,59,53,29,250,175,92,
	225,223,53,127,78,193,204,84,77,102,52,72,232,239,51,235,
	107,57,66,161,208,249,173,5,250,199,7,128,66,255,155,156,
	12,244,199,234,6,253,7,65,51,183,225,64,255,162,37,252,
	241,32,116,54,35,254,39,56,91,232,63,158,250,55,28,1,
	148,41,117,139,249,182,255,170,141,65,255,185,225,252,34,19,
	160,223,14,204,105,77,255,84,17,160,255,138,125,255,217,90,
	1,253,177,246,255,225,252,175,159,15,58,107,48,116,110,86,
	124,235,238,126,239,207,160,127,118,164,208,223,100,38,243,29,
	226,63,60,23,116,142,109,115,250,202,191,104,14,127,82,32,
	127,147,27,80,102,54,1,40,244,95,108,208,191,191,6,244,
	31,186,168,57,85,9,250,67,145,66,255,157,183,13,38,139,
	128,95,105,64,232,31,252,21,244,231,63,130,254,115,231,247,
	23,249,10,133,254,202,102,232,239,154,28,148,233,205,125,94,
	129,66,127,87,89,230,72,86,232,247,246,240,203,74,12,253,
	219,58,255,83,41,64,255,155,223,7,160,255,74,75,129,254,
	40,90,254,169,241,67,127,225,191,254,232,124,126,83,237,255,
	243,206,15,4,4,228,255,12,202,202,202,211,211,192,10,4,
	202,144,105,8,35,6,128,209,3,25,153,105,136,178,204,180,
	12,3,250,137,233,175,167,25,76,203,209,47,48,45,55,61,
	45,7,160,160,0,145,145,145,157,158,134,208,175,1,68,10,
	10,203,191,35,163,44,11,64,255,61,100,246,199,114,63,32,
	47,47,39,7,145,149,157,221,155,185,9,112,84,238,39,100,
	101,101,20,20,20,100,100,128,203,3,55,96,130,253,244,167,
	147,253,138,162,226,244,55,20,151,43,127,249,178,92,102,250,
	183,0,207,162,42,11,145,253,253,31,40,203,40,42,42,255,
	231,96,90,249,255,151,30,226,15,231,89,127,131,194,44,191,
	59,207,186,236,27,10,10,202,51,127,187,124,253,124,152,96,
	255,130,63,33,255,35,243,206,254,226,247,51,117,23,168,77,
	43,228,151,201,47,255,3,42,255,200,220,74,74,111,131,44,
	44,44,82,82,44,95,97,74,249,203,252,39,156,10,203,119,
	160,63,38,161,243,142,253,134,31,254,2,250,43,88,232,43,
	83,222,127,160,140,27,252,238,62,244,151,89,22,105,233,175,
	105,105,105,86,122,196,42,51,91,77,33,179,199,191,87,92,
	232,15,213,120,197,55,190,87,104,217,57,44,251,45,127,172,
	20,128,187,101,130,253,191,186,245,156,231,83,253,53,178,179,
	191,86,5,218,63,224,5,191,62,26,112,6,56,200,232,22,
	228,232,225,10,5,59,136,26,108,6,187,185,208,236,236,236,
	127,128,6,103,0,68,106,51,41,7,53,135,25,104,179,1,
	2,129,160,33,24,56,126,131,9,246,3,87,113,154,133,6,
	172,206,12,102,35,58,46,252,46,179,208,4,190,166,92,144,
	52,36,125,5,54,136,32,146,1,42,19,53,139,235,55,68,
	209,104,7,152,147,43,213,209,211,11,69,73,79,139,245,240,
	10,194,167,167,86,251,186,224,113,104,84,102,69,66,66,53,
	46,62,27,237,238,229,227,91,86,78,160,231,143,189,51,240,
	115,140,135,167,167,143,95,8,137,20,147,144,144,156,158,157,
	75,161,32,96,48,151,100,74,52,12,25,68,137,77,75,173,
	129,3,25,224,140,194,86,4,38,103,48,193,126,42,149,90,
	238,136,64,135,36,21,82,17,181,177,176,232,148,32,103,39,
	98,70,13,10,17,24,81,230,12,163,80,211,42,17,78,104,
	172,143,143,111,64,64,96,68,100,108,69,106,54,185,56,144,
	20,89,233,145,155,95,230,135,128,67,92,144,40,180,187,135,
	151,87,64,112,72,104,104,104,120,98,106,106,6,165,184,22,
	137,15,32,193,81,40,44,22,135,247,39,18,195,147,114,106,
	107,235,48,1,105,112,140,103,138,111,24,204,14,225,17,20,
	91,14,67,48,234,132,3,194,25,229,138,70,199,248,16,8,
	196,128,144,240,152,152,216,184,212,212,52,128,44,178,115,94,
	33,165,60,211,14,131,11,35,165,164,102,230,81,43,43,97,
	118,57,206,72,164,59,214,195,195,195,19,135,195,51,193,254,
	106,31,223,192,16,82,100,66,106,86,25,53,15,238,128,114,
	68,187,121,250,5,70,167,103,147,75,170,2,43,51,93,8,
	153,197,14,206,142,238,56,111,95,95,98,120,116,108,78,78,
	126,33,165,140,90,142,198,248,85,84,120,197,249,67,252,125,
	107,130,29,156,60,112,129,65,65,233,57,133,176,26,132,159,
	127,185,47,60,54,189,168,196,185,214,55,45,61,222,33,53,
	2,102,7,71,3,117,216,205,9,200,42,52,218,221,29,40,
	96,79,47,60,1,184,32,49,32,56,56,56,130,20,25,21,
	27,23,159,144,148,148,156,154,150,67,206,163,148,150,149,1,
	119,168,76,133,57,98,220,194,35,163,48,73,249,212,138,138,
	10,59,59,132,147,179,11,112,5,140,187,59,214,139,128,167,
	95,128,9,246,251,187,19,3,2,72,49,232,216,4,44,112,
	239,252,130,194,138,170,106,152,61,28,133,198,225,188,137,97,
	164,152,164,44,114,174,87,90,57,208,74,124,253,201,209,132,
	58,4,58,37,147,66,111,206,8,71,52,214,3,15,33,4,
	4,4,132,68,196,198,198,37,196,39,224,195,16,24,55,28,
	206,43,40,147,156,95,28,28,83,205,104,245,246,240,88,56,
	156,222,108,157,144,24,44,189,224,188,240,254,1,97,97,81,
	201,41,64,77,41,41,175,172,130,193,49,62,126,192,26,238,
	27,111,239,224,226,86,130,39,18,35,98,98,226,18,82,211,
	178,115,114,11,139,28,139,97,246,8,68,88,120,84,106,65,
	101,101,37,220,51,211,41,214,30,77,161,194,252,139,48,24,
	38,216,239,21,27,80,94,24,27,74,141,247,77,244,45,113,
	112,204,32,39,21,80,16,217,49,118,246,14,112,39,151,112,
	23,160,10,51,138,203,27,239,227,27,68,138,141,79,72,72,
	76,74,75,203,36,147,115,11,42,106,83,11,171,33,14,56,
	239,96,170,175,61,80,146,177,9,217,100,2,12,240,101,112,
	7,7,39,23,164,171,187,167,39,206,203,207,63,44,44,60,
	58,58,33,42,57,39,55,175,128,82,66,173,168,170,3,114,
	195,29,27,20,20,30,158,144,74,38,83,1,235,128,230,140,
	118,115,7,218,10,33,40,44,62,59,57,57,141,158,127,212,
	138,122,70,46,59,186,2,143,224,235,31,17,13,220,179,8,
	86,77,207,81,123,192,61,210,29,34,83,252,159,147,11,189,
	82,161,221,220,220,220,1,176,244,118,229,133,247,241,241,1,
	170,151,95,64,32,80,173,73,145,209,116,187,1,111,4,144,
	146,2,20,75,118,110,94,30,165,168,56,186,184,140,10,169,
	168,172,170,5,158,197,17,137,11,206,43,172,131,59,56,58,
	199,22,213,214,133,7,167,144,176,30,85,97,133,196,10,152,
	51,144,23,30,158,128,7,241,13,36,37,164,2,6,32,156,
	128,155,17,2,0,139,74,178,93,220,189,0,115,8,142,64,
	211,192,226,188,124,137,65,33,69,97,209,209,49,248,132,180,
	236,66,170,131,11,33,41,15,238,66,69,250,37,59,186,185,
	68,215,218,57,56,122,3,110,2,168,107,37,190,213,113,8,
	184,3,19,236,71,227,188,189,9,196,12,106,100,181,87,73,
	117,164,15,80,26,24,15,111,188,111,104,56,41,46,49,51,
	55,175,168,18,239,67,164,87,99,32,187,157,156,145,128,127,
	103,180,63,160,18,163,241,64,19,36,66,136,1,128,203,2,
	178,7,200,153,28,50,157,188,60,106,5,17,248,1,28,141,
	246,244,242,33,6,5,132,69,144,162,99,128,156,75,47,12,
	168,195,230,214,198,22,160,169,48,132,11,224,243,60,130,130,
	73,121,232,140,56,123,66,42,38,35,49,21,142,241,202,199,
	135,198,36,36,231,22,80,50,41,246,14,24,66,72,88,81,
	81,73,42,208,204,96,8,52,142,64,12,11,143,77,201,47,
	170,4,252,63,218,203,63,161,220,153,41,229,143,198,184,217,
	121,226,2,99,98,128,138,157,146,154,14,52,185,130,66,74,
	81,17,181,8,240,90,8,44,142,16,16,20,158,88,84,140,
	64,161,3,99,18,227,145,161,240,236,66,59,140,79,84,108,
	106,37,28,139,247,35,6,66,130,130,35,19,220,40,69,21,
	112,7,156,143,79,144,123,66,146,79,70,6,217,1,129,2,
	242,168,152,10,52,5,122,127,237,228,68,239,216,208,24,0,
	122,21,195,1,53,204,203,135,81,197,252,253,3,128,26,6,
	116,28,164,168,232,24,186,235,143,79,72,78,75,207,200,206,
	158,201,201,162,226,146,82,106,57,93,61,192,29,92,144,72,
	160,163,241,38,16,2,195,72,177,233,185,128,127,117,169,96,
	130,253,56,63,98,104,98,114,106,78,69,86,33,6,232,141,
	156,128,174,8,11,120,103,31,95,191,192,64,18,41,10,200,
	23,192,79,229,144,233,153,2,60,136,3,18,137,33,97,82,
	200,133,212,242,56,114,69,145,51,2,66,113,4,170,112,64,
	72,84,124,82,54,165,168,164,132,26,81,229,230,134,39,228,
	83,189,8,126,105,21,212,236,96,111,52,44,132,228,3,180,
	87,20,214,3,135,199,211,155,1,49,40,140,20,25,159,140,
	204,166,87,24,224,178,229,248,216,20,170,59,112,214,135,16,
	21,27,159,152,146,151,159,95,16,237,128,243,242,198,145,99,
	227,200,84,160,107,130,1,46,3,200,62,192,183,2,221,16,
	208,40,9,193,161,161,120,160,25,48,193,126,122,169,167,102,
	0,158,159,66,41,46,46,171,118,112,10,14,133,199,36,166,
	196,59,35,49,64,25,249,133,1,58,132,81,191,51,201,84,
	74,189,61,80,156,246,64,55,22,134,198,32,0,71,14,0,
	1,28,163,155,159,95,112,40,140,20,73,247,18,201,105,105,
	233,64,249,1,87,43,41,175,178,71,122,166,100,228,83,0,
	95,138,240,240,34,4,1,41,76,30,62,1,145,13,247,2,
	122,49,111,2,5,134,66,5,144,129,203,121,224,8,169,126,
	212,202,42,59,36,58,25,195,112,65,62,1,65,64,255,144,
	157,71,161,80,235,170,97,8,84,92,81,69,109,80,8,160,
	68,128,186,19,16,28,65,46,13,38,167,193,51,17,76,176,
	31,97,71,41,68,165,184,197,22,250,230,133,213,248,147,97,
	8,103,23,192,255,17,3,131,66,128,78,25,112,121,153,228,
	18,103,36,22,239,227,79,36,145,237,163,92,176,30,62,1,
	164,216,164,148,44,74,101,28,41,54,46,29,66,137,137,77,
	115,141,130,193,0,247,229,67,8,200,204,38,23,21,87,250,
	135,132,167,166,231,193,224,112,39,52,189,190,3,0,158,128,
	16,28,70,2,58,189,148,44,50,57,63,191,184,172,162,198,
	193,43,146,16,16,158,87,66,13,68,250,249,21,150,144,40,
	72,95,47,63,187,96,66,97,70,66,137,95,176,11,18,157,
	16,230,88,84,11,3,220,189,67,158,35,18,61,227,157,129,
	150,227,27,16,29,19,75,239,58,10,40,76,176,31,104,235,
	245,1,222,222,248,160,200,56,74,73,144,35,214,187,176,176,
	24,142,68,97,220,3,19,73,121,5,21,33,118,196,96,18,
	21,238,8,40,92,12,22,232,159,34,211,128,50,41,137,142,
	118,112,119,65,121,0,253,16,4,238,224,4,156,3,188,136,
	7,206,27,232,50,124,35,3,131,2,67,66,177,164,152,184,
	56,160,49,59,164,3,222,128,222,241,81,74,129,158,175,204,
	222,193,17,137,241,244,14,140,138,77,78,167,20,99,106,17,
	88,108,96,88,84,76,28,49,140,236,235,15,143,245,195,212,
	164,162,139,66,156,49,30,248,128,60,74,133,163,79,49,138,
	2,135,193,51,114,67,188,74,252,42,19,73,8,191,2,106,
	0,12,131,45,68,228,37,103,186,227,97,112,38,216,143,194,
	148,195,80,88,114,112,76,12,58,61,60,20,80,86,222,161,
	241,48,119,152,139,179,71,48,221,167,23,230,100,186,225,188,
	115,8,128,248,141,118,77,74,173,180,115,7,106,7,33,50,
	44,57,185,176,200,222,197,213,23,226,23,26,150,135,204,163,
	82,178,98,162,210,129,78,2,112,152,145,113,241,169,25,133,
	62,193,97,137,105,149,117,240,184,232,184,228,56,127,247,100,
	18,9,94,28,20,89,84,101,151,132,139,43,171,113,70,102,
	82,233,93,10,194,221,27,15,40,40,64,35,144,18,83,51,
	242,226,138,66,1,85,233,3,244,184,25,153,128,223,164,59,
	81,160,194,227,137,1,192,145,152,132,164,228,108,64,29,150,
	87,248,199,219,99,176,4,98,68,84,18,19,236,175,39,196,
	34,72,85,216,148,180,100,44,150,20,71,241,69,185,38,68,
	230,218,97,253,129,86,22,3,220,206,221,139,20,147,90,82,
	156,158,89,227,136,197,7,134,228,229,85,224,35,128,215,17,
	192,155,195,221,233,46,11,130,247,9,12,139,3,84,1,32,
	9,242,169,84,59,111,98,106,122,6,5,16,199,233,25,118,
	14,88,119,66,76,74,78,78,32,22,23,0,11,171,6,164,
	1,210,19,23,138,138,143,79,160,226,147,129,238,5,9,84,
	104,2,44,163,140,26,95,97,143,140,140,118,136,2,186,66,
	84,88,92,66,97,33,197,206,193,21,91,110,151,90,236,226,
	69,36,101,23,198,58,0,63,244,33,198,167,217,3,122,136,
	94,217,48,110,244,98,192,19,152,96,63,160,94,163,1,255,
	159,158,158,69,151,222,197,21,53,181,48,24,32,67,129,172,
	167,55,104,130,47,28,168,5,128,109,197,84,199,10,132,61,
	2,233,77,8,139,138,45,114,8,32,34,221,81,132,36,120,
	36,196,59,186,186,206,5,229,67,32,58,250,185,167,16,170,
	9,53,190,128,192,1,106,65,161,93,98,29,204,51,40,56,
	195,145,80,237,22,135,65,103,5,165,199,166,160,226,3,162,
	28,80,161,97,81,229,181,126,174,174,112,71,71,159,200,194,
	226,26,84,88,16,220,55,33,161,188,206,219,63,13,133,38,
	134,71,2,239,125,112,66,93,36,193,161,18,131,139,207,115,
	242,72,40,67,192,224,168,176,228,34,108,20,2,155,144,65,
	46,40,39,100,148,122,122,6,68,50,193,126,114,161,147,29,
	208,75,3,93,171,167,23,129,16,20,24,30,78,2,202,157,
	2,56,222,44,20,204,14,70,46,172,176,119,7,222,240,188,
	188,188,125,252,252,2,131,66,1,231,151,156,158,14,168,4,
	10,181,210,19,71,132,4,4,38,37,5,38,101,101,19,128,
	222,46,48,33,189,8,134,112,35,6,103,100,230,56,56,98,
	8,190,17,17,164,236,236,34,42,21,27,30,155,238,69,114,
	8,12,2,164,80,60,53,182,222,206,19,159,9,100,51,12,
	142,198,251,6,2,175,56,177,241,169,64,71,72,173,112,72,
	176,71,16,2,67,35,82,10,169,53,117,17,200,192,132,10,
	186,144,114,112,243,8,143,73,45,6,94,84,235,234,125,136,
	14,14,33,217,192,195,6,135,2,82,129,9,246,167,83,74,
	28,171,253,67,242,242,203,29,92,129,234,8,216,24,28,22,
	22,151,156,156,69,129,215,197,36,151,144,237,29,201,196,188,
	20,15,2,80,45,106,200,25,25,126,65,209,41,139,208,12,
	232,114,70,19,130,161,209,132,49,223,144,210,116,115,163,185,
	125,199,17,11,155,67,30,44,245,135,253,95,12,140,48,128,
	127,79,206,140,142,48,226,153,29,194,220,81,19,38,216,63,
	247,114,240,159,136,101,132,206,240,95,147,73,247,255,140,119,
	145,223,81,88,248,61,93,193,8,17,8,18,98,46,48,4,
	130,254,118,136,154,115,40,158,138,240,9,253,113,160,231,55,
	48,103,252,135,129,147,211,108,52,151,121,187,12,156,129,133,
	30,56,135,210,135,135,32,206,191,199,197,249,235,120,145,147,
	203,239,64,2,235,44,68,228,63,64,31,89,242,157,25,96,
	138,69,125,131,25,253,31,10,101,103,247,243,216,213,124,232,
	21,222,21,61,15,60,26,13,153,127,12,141,153,7,112,0,
	198,72,160,126,56,236,134,113,251,59,220,127,65,221,108,204,
	4,251,231,95,26,251,247,120,96,61,60,32,30,127,15,125,
	240,131,62,152,0,4,244,152,145,254,87,72,250,158,196,205,
	192,140,247,159,127,196,251,107,194,139,254,206,54,19,120,123,
	205,1,242,61,233,205,0,239,253,99,252,149,84,111,111,220,
	236,81,188,55,254,59,164,57,233,92,252,143,16,124,124,232,
	219,239,97,130,253,115,174,70,160,83,78,248,43,252,125,103,
	128,248,206,101,230,168,31,125,5,22,122,64,223,245,99,28,
	96,36,232,199,126,11,154,17,250,207,238,249,251,251,17,25,
	187,140,229,215,48,99,252,47,243,135,43,18,51,253,137,196,
	106,34,145,24,73,172,32,254,5,144,186,128,63,19,152,29,
	56,159,96,250,200,210,79,71,131,254,130,224,224,16,122,200,
	88,192,127,190,7,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,249,95,65,112,112,80,240,63,19,18,2,172,33,179,
	209,124,32,33,161,244,121,111,255,129,176,191,192,62,124,14,
	117,225,243,136,0,96,4,243,9,103,130,253,223,175,70,250,
	119,128,144,34,233,81,228,191,65,102,100,212,95,18,29,29,
	3,44,191,128,9,246,211,47,19,243,19,245,115,210,177,12,
	102,35,58,245,223,147,177,16,122,64,137,253,129,184,127,133,
	248,120,250,54,19,50,18,127,69,53,35,100,198,252,143,9,
	127,32,241,199,189,249,64,126,220,77,72,44,156,187,155,244,
	71,114,191,39,43,146,255,4,252,107,34,133,62,17,45,0,
	19,236,167,210,175,51,115,181,63,146,250,51,144,212,95,146,
	150,70,15,232,203,63,147,206,216,210,25,137,244,116,32,149,
	65,143,50,210,127,11,112,42,131,1,35,98,130,253,25,153,
	25,191,39,51,51,147,17,0,192,50,231,145,205,8,33,192,
	150,69,39,115,118,251,153,236,175,9,234,247,67,217,140,227,
	217,127,77,14,35,248,9,38,216,159,243,79,144,255,8,132,
	76,206,101,36,114,115,115,233,91,110,110,121,238,111,201,251,
	21,184,121,251,249,51,212,231,127,77,205,163,160,0,88,103,
	97,130,253,5,127,73,225,175,129,252,184,75,1,150,66,202,
	119,230,166,41,20,234,15,123,20,28,165,232,207,20,23,21,
	255,154,146,226,146,18,38,216,95,242,123,74,127,166,248,91,
	170,108,6,72,217,87,130,191,165,202,168,127,34,135,90,78,
	165,150,255,14,135,223,28,175,47,143,45,47,175,152,11,19,
	236,159,123,185,202,191,164,170,170,138,190,209,129,84,253,129,
	234,191,167,134,190,253,3,181,181,192,250,3,76,176,191,246,
	159,169,251,153,242,185,59,144,217,184,190,62,178,254,87,32,
	253,40,17,240,80,231,153,89,236,38,254,97,122,185,153,41,
	226,104,179,83,197,209,231,120,163,1,139,39,237,251,92,108,
	243,38,90,163,195,4,251,103,38,107,195,211,128,245,199,185,
	213,214,127,77,204,28,215,165,79,144,54,241,227,36,104,223,
	230,63,163,125,159,2,205,207,79,125,118,2,51,26,176,233,
	234,206,206,101,166,249,117,130,177,175,9,189,137,31,230,17,
	99,236,253,60,115,152,222,215,153,193,104,63,204,19,70,155,
	157,11,140,9,246,211,39,20,163,253,78,248,255,200,55,73,
	79,251,22,132,66,102,4,190,1,67,198,91,132,135,211,126,
	161,221,105,17,127,98,70,75,27,254,73,71,207,151,197,142,
	76,210,191,209,209,180,104,167,104,134,202,6,160,209,232,27,
	237,219,70,199,133,33,132,105,128,184,5,54,212,28,149,11,
	161,7,180,184,89,229,186,193,237,187,68,253,133,150,164,209,
	53,33,109,70,25,210,190,233,62,218,55,125,247,93,105,209,
	76,77,83,83,253,231,73,170,159,97,130,253,105,12,225,69,
	155,35,177,130,102,180,15,237,187,10,162,75,160,16,134,220,
	153,200,52,155,149,63,179,74,6,98,150,245,93,198,68,102,
	231,208,190,105,7,218,207,250,1,200,205,89,29,64,163,247,
	244,180,175,29,58,64,106,193,70,70,23,155,54,211,141,82,
	104,148,121,208,126,213,57,50,193,126,122,23,251,83,215,250,
	83,79,88,242,67,167,7,96,73,239,229,38,168,84,250,247,
	99,104,63,247,101,52,122,119,66,155,233,85,38,102,251,150,
	159,59,6,155,159,122,128,239,174,126,46,155,230,186,225,89,
	199,138,194,184,71,38,50,99,0,224,219,60,188,16,152,26,
	125,71,77,13,6,99,153,55,55,47,116,222,4,189,106,179,
	243,242,170,217,67,236,231,193,250,53,98,36,212,208,104,77,
	96,65,107,210,55,12,6,179,116,102,242,83,73,73,250,138,
	209,164,7,192,30,125,149,148,250,62,229,169,38,125,149,214,
	116,211,154,221,151,254,26,106,185,107,185,211,87,122,160,197,
	156,249,79,225,172,112,248,2,248,66,248,204,135,151,212,224,
	11,217,24,19,250,178,207,204,217,203,1,44,12,212,129,196,
	204,236,188,156,156,140,136,11,129,88,164,174,142,128,32,212,
	25,243,244,170,207,155,153,151,251,219,100,186,234,140,213,137,
	123,38,205,195,51,123,144,199,201,153,151,62,73,174,250,236,
	100,185,26,63,206,157,203,239,226,194,63,243,233,165,217,239,
	47,241,127,141,93,4,232,223,97,210,160,207,157,139,100,130,
	253,244,201,117,5,230,206,180,43,248,109,190,93,20,74,72,
	3,5,44,1,40,148,48,106,46,34,34,26,95,231,197,133,
	252,114,166,220,111,136,185,203,126,157,88,86,158,222,247,203,
	127,239,240,181,190,39,181,129,30,95,155,209,239,43,124,155,
	44,118,102,158,87,109,122,176,114,118,210,87,70,172,56,119,
	122,86,38,216,15,92,101,21,93,90,40,41,205,170,11,37,
	175,213,244,228,106,175,95,232,141,175,172,161,107,6,29,60,
	30,175,3,193,207,135,126,120,86,57,232,208,53,196,250,111,
	66,130,161,33,116,129,69,7,208,14,170,4,85,85,186,134,
	80,165,71,192,78,154,239,55,89,161,166,166,6,8,9,181,
	111,146,66,119,94,12,156,83,159,81,28,76,176,127,86,180,
	232,234,170,251,233,206,10,23,221,239,83,178,106,104,248,107,
	104,204,30,155,35,94,102,147,186,254,254,144,111,199,52,103,
	18,90,116,33,163,69,212,251,166,108,116,190,139,156,89,77,
	243,171,72,159,161,107,2,230,138,28,253,32,125,125,253,249,
	179,163,234,207,157,10,85,159,41,250,103,102,86,85,198,204,
	170,116,12,127,208,64,250,51,145,17,67,12,25,207,232,32,
	253,31,198,63,141,191,30,159,209,70,250,63,68,161,161,38,
	140,49,80,3,26,93,31,193,232,129,121,216,247,208,32,204,
	0,80,78,116,157,100,48,35,151,128,104,99,248,175,153,63,
	4,106,5,108,76,29,255,4,176,142,176,166,235,48,155,31,
	199,56,109,1,101,102,56,111,220,147,46,199,12,97,145,145,
	144,72,24,61,9,51,164,199,134,95,133,154,61,176,68,194,
	233,26,13,110,4,167,199,14,244,205,104,142,118,163,167,29,
	191,15,100,58,254,60,182,233,244,117,252,209,120,222,216,164,
	177,139,139,49,67,129,25,199,50,193,254,216,249,160,140,25,
	151,166,227,234,26,231,58,35,243,140,141,129,109,38,137,222,
	0,4,27,24,73,12,102,70,255,205,27,156,4,156,93,188,
	59,61,166,135,238,241,216,120,96,77,72,216,144,144,128,197,
	210,85,160,7,118,3,61,218,144,224,193,216,155,163,15,77,
	60,104,115,71,15,77,232,219,140,70,84,195,37,225,102,82,
	94,73,112,125,32,242,102,236,48,193,254,164,95,140,51,250,
	48,130,148,228,100,19,64,138,210,55,66,138,41,99,161,175,
	116,124,129,197,47,37,197,47,213,143,62,254,55,171,83,253,
	83,77,129,5,216,241,167,209,128,196,111,196,171,105,154,169,
	233,220,1,192,244,244,128,111,202,115,38,101,246,53,8,250,
	58,230,55,139,153,217,76,28,252,245,64,48,83,254,253,227,
	135,225,62,128,80,250,74,155,59,212,247,125,199,108,254,224,
	30,132,30,132,135,51,210,225,102,89,17,244,56,226,235,32,
	223,12,230,12,105,28,9,168,227,175,42,153,113,52,39,10,
	88,114,114,162,204,191,15,183,49,146,230,100,114,204,92,209,
	28,59,59,120,102,49,103,28,45,46,47,46,142,174,160,153,
	96,63,253,50,241,192,102,193,24,124,75,200,203,75,156,81,
	229,73,12,105,110,145,95,144,204,208,231,201,27,231,141,135,
	165,22,0,138,61,245,235,248,87,122,97,33,109,38,248,58,
	16,70,161,100,208,183,12,198,176,215,70,186,130,207,100,172,
	69,64,234,183,131,93,57,57,51,106,60,231,7,57,158,147,
	243,235,116,9,153,9,246,147,191,235,125,50,185,228,199,212,
	215,3,116,233,207,8,114,115,103,223,1,242,233,107,126,1,
	93,255,3,1,176,21,80,11,45,25,67,91,150,133,64,96,
	85,94,110,53,251,38,80,92,252,227,155,1,227,101,192,170,
	244,219,152,83,217,183,20,245,235,40,148,53,181,178,178,188,
	114,102,251,37,21,149,179,111,19,76,176,159,113,29,107,198,
	50,155,156,59,104,53,247,13,165,182,110,238,171,74,29,125,
	169,169,129,204,190,176,212,125,13,235,126,30,181,170,7,94,
	97,26,108,26,106,109,232,239,50,13,140,245,23,216,206,190,
	223,200,209,131,45,117,91,25,239,58,182,63,12,38,109,171,
	223,14,44,245,245,219,193,127,182,5,1,1,97,6,44,208,
	197,60,147,226,18,210,44,213,53,7,141,118,26,140,24,78,
	125,169,173,99,29,88,200,198,254,89,144,143,23,179,84,24,
	163,176,92,84,108,169,36,7,167,160,144,174,62,218,141,131,
	147,107,209,98,110,30,94,190,37,139,248,15,220,134,124,148,
	244,88,42,229,67,144,82,219,96,180,95,69,149,245,209,130,
	205,91,22,178,178,113,201,236,96,91,120,249,90,215,249,206,
	77,13,45,205,39,91,117,249,139,41,69,37,2,236,80,238,
	68,85,53,117,93,189,233,122,142,69,153,89,169,105,171,20,
	211,51,200,185,156,11,23,178,173,88,185,167,187,7,194,90,
	70,45,95,174,128,245,16,21,19,22,145,217,198,15,101,247,
	116,240,39,138,235,75,170,43,173,198,153,152,109,140,140,42,
	85,82,14,14,244,151,145,61,28,68,12,240,123,205,4,243,
	143,28,110,59,83,94,65,173,236,120,50,250,248,169,154,58,
	223,18,126,1,65,33,97,17,81,177,211,23,245,205,205,70,
	229,100,229,228,151,45,87,88,177,82,113,149,210,234,53,107,
	215,41,175,87,1,12,208,208,212,210,214,17,80,231,189,44,
	0,89,97,188,193,196,212,204,220,98,163,165,149,181,141,45,
	204,142,254,201,75,71,39,103,23,36,202,181,65,128,54,249,
	251,179,104,140,27,227,83,135,244,79,203,18,124,253,252,137,
	1,129,65,193,33,161,97,225,244,239,1,71,51,62,133,153,
	152,148,156,146,154,150,158,145,153,149,157,67,206,165,127,156,
	151,66,255,34,102,25,213,218,214,14,142,96,78,241,111,218,
	188,101,235,182,237,59,118,238,218,221,184,167,105,239,190,253,
	7,154,91,14,30,58,124,228,232,177,227,39,90,79,158,58,
	125,166,237,108,123,199,185,206,243,23,46,94,186,124,229,106,
	215,181,235,55,186,111,246,220,234,189,125,167,239,110,255,189,
	129,251,131,144,161,225,7,35,15,31,141,62,126,242,244,217,
	243,23,47,95,189,126,51,246,246,221,248,251,15,141,77,251,
	14,180,156,232,184,48,243,188,229,21,149,85,213,53,181,117,
	245,13,155,102,239,230,237,129,243,241,196,19,188,126,186,221,
	236,221,206,190,255,240,241,211,4,109,242,243,212,23,160,38,
	240,0,181,148,213,247,192,236,181,129,19,31,25,103,166,153,
	96,255,76,129,179,208,75,92,92,98,169,164,148,180,204,188,
	18,159,151,7,51,21,0,206,168,1,186,122,250,16,3,67,
	163,121,101,76,127,238,187,253,64,49,11,136,202,119,65,160,
	139,249,68,5,151,174,94,166,166,199,194,202,43,32,33,34,
	175,170,164,107,45,179,110,165,166,161,164,242,114,173,13,243,
	234,195,188,236,248,250,144,244,92,215,3,110,112,181,235,186,
	129,225,167,137,27,221,61,189,119,238,222,99,74,249,239,105,
	216,180,117,59,80,248,64,217,55,183,252,169,216,191,150,250,
	247,66,135,252,80,234,179,37,54,13,89,229,207,111,195,162,
	68,20,176,93,112,199,88,223,213,195,221,59,38,33,110,97,
	255,6,3,244,121,79,44,62,118,32,49,222,17,170,205,182,
	88,84,156,199,196,194,30,25,20,130,115,98,213,97,231,22,
	147,224,93,98,186,17,142,10,14,245,234,227,88,186,76,13,
	19,192,41,185,92,221,45,48,52,55,49,173,56,32,40,38,
	219,57,60,33,149,18,23,136,13,171,45,240,180,14,73,89,
	81,198,4,251,75,125,42,206,34,92,210,61,74,16,14,190,
	57,72,18,10,227,110,31,76,246,206,115,132,59,228,227,55,
	111,114,42,138,37,184,142,78,133,132,58,58,230,229,209,191,
	143,21,22,238,121,225,202,245,27,108,134,139,88,22,64,120,
	23,67,33,140,92,120,250,104,249,106,237,165,210,50,28,250,
	138,235,238,47,83,214,83,147,148,18,21,91,165,163,203,42,
	254,189,41,127,207,167,185,141,124,126,123,250,158,179,191,58,
	67,123,250,232,229,139,239,67,183,27,152,96,255,175,60,208,
	156,99,150,130,114,182,162,43,88,53,224,46,220,10,242,74,
	86,186,64,35,46,40,236,216,68,156,253,117,28,68,82,90,
	248,170,44,163,77,175,87,209,78,76,136,7,14,174,165,159,
	145,166,87,94,103,169,177,69,208,149,235,148,243,135,167,166,
	89,23,121,108,180,116,198,250,7,36,146,75,203,149,47,14,
	177,64,121,68,87,172,53,210,53,46,189,242,246,250,232,122,
	54,214,69,82,234,86,42,78,46,135,106,219,47,221,127,240,
	138,165,95,64,200,210,197,179,228,130,234,149,235,189,253,106,
	111,38,33,236,75,213,61,189,18,74,106,155,249,87,216,214,
	16,35,146,178,169,155,152,96,255,174,206,105,30,37,117,123,
	247,148,204,2,141,166,46,77,14,30,93,203,72,31,173,224,
	208,176,202,186,93,123,90,46,94,226,210,151,93,167,170,22,
	18,21,95,195,43,113,244,252,133,107,15,95,190,255,48,205,
	201,231,233,173,29,159,83,167,179,11,18,212,221,213,115,119,
	232,233,98,99,183,192,220,226,173,237,221,3,2,242,132,192,
	168,196,244,186,29,29,39,197,150,187,213,8,179,26,158,145,
	88,249,65,142,180,212,126,247,240,242,151,62,219,223,151,172,
	216,20,90,125,61,110,28,119,170,64,184,254,72,206,33,206,
	242,141,231,243,237,30,113,217,214,90,190,213,236,97,225,28,
	228,13,17,88,120,220,46,100,178,233,117,59,143,23,212,41,
	86,183,108,219,96,115,219,107,200,216,102,45,149,149,185,235,
	140,67,78,14,15,77,10,189,125,254,112,13,51,198,127,67,
	26,38,23,189,203,186,118,242,236,147,96,204,241,37,37,159,
	21,68,23,72,138,235,62,218,229,115,175,112,67,145,245,91,
	187,197,195,135,149,67,101,222,45,208,122,167,136,190,0,83,
	27,67,123,188,108,110,188,116,110,59,11,185,185,160,41,19,
	194,175,108,122,240,195,202,93,227,167,5,11,4,81,183,12,
	89,34,111,148,123,160,37,252,90,93,151,79,172,197,39,223,
	107,165,173,90,113,48,183,205,121,53,79,199,38,106,220,2,
	235,195,157,145,158,40,90,180,159,162,221,187,69,194,175,156,
	244,55,133,55,188,230,228,109,59,60,124,35,171,230,176,77,
	11,241,108,254,41,189,172,3,253,11,162,94,223,244,105,86,
	220,57,10,147,34,119,60,89,130,210,125,116,242,203,153,115,
	2,183,46,139,143,220,183,186,52,249,124,85,41,238,58,255,
	117,109,38,216,111,236,179,63,42,196,38,147,180,109,34,183,
	160,118,236,148,112,75,139,176,111,234,190,252,203,46,97,59,
	142,6,236,236,219,50,221,197,147,150,181,224,230,240,49,61,
	173,19,97,199,137,85,221,68,214,151,91,74,253,124,90,18,
	108,97,213,50,74,144,164,195,220,128,63,10,121,161,203,126,
	3,205,103,42,168,253,65,66,39,125,21,166,189,249,94,30,
	122,165,220,194,245,219,56,206,141,38,166,53,116,115,221,121,
	60,89,181,106,52,175,162,63,44,102,139,180,215,169,126,220,
	13,4,205,0,225,34,87,110,182,95,116,100,209,244,38,217,
	167,26,111,106,125,234,90,174,52,166,195,75,138,54,227,111,
	174,20,213,82,58,122,101,151,141,222,174,231,139,218,150,56,
	34,89,120,66,107,124,105,22,156,29,148,197,137,87,94,233,
	220,126,32,125,185,131,9,246,99,149,207,137,36,36,109,244,
	130,64,78,22,138,30,140,186,34,249,128,71,47,57,1,82,
	82,179,46,249,133,78,67,145,197,174,201,214,144,61,151,26,
	56,89,27,29,145,33,43,72,87,35,54,139,219,179,137,154,
	157,95,114,73,107,175,192,114,56,68,127,67,216,72,52,107,
	228,94,14,241,47,62,143,209,39,204,158,116,15,137,201,184,
	174,31,248,196,178,221,117,103,227,158,234,134,27,22,31,66,
	63,56,202,38,61,223,147,54,172,105,181,206,62,80,26,101,
	221,118,246,229,235,79,11,57,96,31,135,167,93,92,223,12,
	172,73,9,52,122,75,202,177,79,57,247,208,226,139,194,86,
	121,125,181,148,147,214,151,142,93,73,194,106,223,184,33,157,
	236,166,241,72,231,54,245,233,232,190,206,11,221,81,226,238,
	251,99,35,111,90,100,168,244,63,134,111,100,198,255,127,169,
	47,137,240,220,77,206,78,21,9,129,7,188,149,104,20,216,
	122,117,216,39,219,248,236,169,37,166,136,53,207,114,225,184,
	116,82,36,97,87,179,78,64,240,6,1,31,253,73,155,74,
	107,34,143,213,85,14,47,159,41,241,194,163,93,79,32,89,
	210,105,103,42,141,139,100,98,29,35,236,141,228,57,62,104,
	43,224,227,181,188,118,240,46,188,66,107,254,244,46,108,169,
	98,194,158,181,130,193,49,139,119,229,138,61,232,246,34,197,
	58,9,68,155,212,183,196,41,72,80,210,191,152,104,66,104,
	246,176,69,15,227,105,55,188,199,26,87,104,153,237,115,190,
	126,233,224,166,225,55,176,172,39,154,231,9,2,165,197,220,
	27,45,13,214,229,109,170,223,81,224,154,82,183,53,138,226,
	126,113,107,252,62,49,97,203,128,250,99,95,170,70,150,48,
	193,126,158,28,248,230,4,71,183,194,71,143,63,70,167,85,
	29,17,117,176,41,191,179,67,23,106,50,30,40,91,126,25,
	187,202,111,93,173,74,86,128,225,208,66,81,247,3,66,172,
	251,14,56,22,174,114,176,241,148,216,252,249,18,41,212,240,
	243,86,91,200,194,202,59,186,232,198,143,28,183,62,14,249,
	99,143,89,235,90,77,25,69,121,116,155,114,134,44,153,186,
	187,179,191,213,155,245,210,27,239,83,174,190,231,121,217,180,
	15,124,188,165,19,180,161,218,254,34,91,240,232,171,201,202,
	112,168,61,117,208,126,135,210,161,61,249,144,139,238,39,246,
	251,217,110,210,15,231,72,56,159,44,164,16,88,160,124,175,
	141,179,218,123,165,189,255,166,131,27,86,233,144,15,54,243,
	124,46,163,97,172,114,13,86,10,190,79,119,150,91,135,105,
	210,22,35,107,50,193,254,193,15,123,71,215,28,223,117,131,
	210,107,195,214,120,218,129,179,226,108,232,147,98,47,236,232,
	37,249,242,212,178,180,254,104,190,61,141,185,183,122,116,146,
	116,62,189,29,233,127,126,249,226,180,189,45,84,233,182,36,
	251,58,204,190,147,79,106,113,144,56,94,51,203,182,79,98,
	74,155,161,239,168,238,126,62,121,175,206,223,187,242,57,56,
	87,47,223,222,133,182,145,101,131,236,229,19,6,39,123,218,
	116,22,171,62,43,173,179,79,226,69,42,209,62,229,63,103,
	29,251,184,254,226,214,156,36,182,83,207,234,33,67,97,227,
	181,158,86,82,60,149,11,124,125,106,130,12,68,22,74,94,
	10,58,191,91,154,166,131,136,87,183,185,160,244,232,236,250,
	9,221,222,108,235,245,228,167,67,107,137,91,28,168,252,183,
	253,167,179,181,247,64,238,118,49,227,223,191,202,215,223,127,
	197,242,69,229,204,229,13,182,221,47,165,41,230,97,148,136,
	117,235,173,3,58,107,206,216,153,25,151,240,244,24,47,242,
	82,184,154,214,35,118,250,134,219,218,234,196,122,26,226,205,
	165,201,229,123,70,150,78,119,238,126,17,156,243,14,66,245,
	254,34,56,76,202,98,27,149,52,42,234,19,63,220,29,246,
	105,223,199,79,187,250,194,11,41,78,15,189,143,72,15,200,
	88,188,120,98,190,94,196,247,148,222,33,54,222,37,226,233,
	228,161,144,164,244,254,188,40,246,197,107,34,19,55,75,171,
	183,102,115,34,245,20,8,231,89,220,88,240,111,134,150,236,
	208,166,246,230,90,186,189,147,214,115,12,247,188,191,213,39,
	81,180,166,130,139,67,202,165,60,164,75,237,138,156,214,185,
	47,158,206,166,135,195,189,142,134,29,149,89,63,254,133,9,
	246,191,228,166,190,116,140,10,27,29,116,58,160,171,53,124,
	136,93,102,224,105,59,108,221,126,235,87,213,209,99,170,199,
	164,221,71,85,71,246,237,222,173,211,88,173,50,192,126,188,
	141,149,244,98,145,184,62,140,235,156,87,224,242,107,28,184,
	119,59,33,34,218,169,203,119,170,145,61,115,135,66,54,56,
	242,137,22,186,119,176,251,133,108,222,217,31,100,41,118,78,
	228,204,151,244,216,79,194,171,221,214,117,104,60,184,153,178,
	130,207,48,66,58,226,173,176,215,194,48,233,254,83,206,111,
	166,146,26,74,46,75,22,59,160,114,120,216,78,172,185,39,
	190,77,144,242,206,214,214,128,107,143,247,48,118,23,123,223,
	182,13,21,107,210,206,236,121,22,185,216,178,111,163,137,199,
	22,168,240,128,130,197,126,1,181,139,102,34,55,49,176,132,
	203,73,77,119,153,96,191,213,206,88,9,237,237,65,93,239,
	163,163,154,138,210,246,218,166,107,105,248,102,56,181,116,217,
	192,119,238,254,50,229,218,87,88,192,227,60,88,46,99,202,
	174,166,235,41,243,152,116,229,1,231,238,87,118,250,185,222,
	146,35,239,48,105,134,39,32,87,159,78,140,92,157,18,122,
	148,243,244,83,201,224,181,26,79,75,100,64,235,228,185,16,
	150,192,242,165,252,215,202,11,110,170,115,200,180,71,88,132,
	7,91,98,87,183,72,223,118,191,116,173,202,129,26,217,142,
	36,114,113,195,49,189,226,171,66,224,6,66,219,222,32,218,
	212,157,140,58,86,34,216,190,240,29,88,151,33,99,173,54,
	253,230,126,87,82,79,238,81,200,90,114,127,255,200,155,21,
	171,243,109,38,6,86,32,76,51,144,117,55,55,191,150,19,
	209,106,251,162,245,248,211,51,38,216,255,212,220,113,191,255,
	250,169,103,167,239,106,126,218,168,191,95,27,201,230,115,110,
	243,40,108,24,221,244,242,245,238,19,250,157,151,203,208,35,
	231,13,154,168,201,135,52,207,47,123,164,44,129,143,245,24,
	23,15,26,23,53,107,185,136,153,128,119,64,248,158,22,107,
	12,27,173,121,91,57,116,82,111,236,9,49,74,23,246,238,
	186,136,194,170,199,46,251,88,204,47,231,190,23,86,77,17,
	84,39,30,124,187,100,179,100,144,131,142,78,132,118,116,228,
	233,123,25,239,170,162,160,143,206,185,140,11,101,95,109,223,
	27,190,188,134,231,202,84,85,191,184,43,244,224,164,201,234,
	59,39,20,14,58,26,134,248,127,92,189,122,21,215,200,193,
	38,24,134,100,82,183,113,89,149,100,89,211,71,233,188,67,
	58,215,247,25,101,21,44,26,178,128,142,154,10,48,193,254,
	163,107,238,240,60,66,62,32,141,167,75,248,221,56,254,246,
	216,86,219,151,166,209,68,69,167,242,201,194,165,173,15,208,
	199,36,79,31,80,158,132,241,169,187,236,241,40,46,199,200,
	198,13,190,20,156,178,93,174,179,123,187,116,4,63,191,235,
	30,200,85,8,159,35,210,165,236,67,110,107,217,154,80,147,
	214,193,219,119,130,171,131,47,32,238,68,89,58,58,244,134,
	42,123,249,61,228,89,96,206,203,202,43,22,185,70,249,206,
	213,91,139,161,60,59,234,164,90,30,141,47,64,100,12,177,
	27,150,183,212,196,120,157,126,216,253,162,137,213,243,83,138,
	154,213,135,231,231,44,165,162,131,207,251,228,185,26,11,192,
	207,115,111,220,146,97,251,172,146,7,25,107,141,59,184,32,
	202,197,99,112,196,45,79,143,239,41,244,70,78,204,244,163,
	112,60,19,236,79,53,124,53,73,190,154,63,188,31,247,56,
	84,233,64,196,251,184,170,246,10,147,207,214,247,54,239,106,
	231,158,82,61,221,92,190,117,156,220,148,21,245,192,64,67,
	205,156,212,180,231,93,251,64,177,75,112,187,205,149,227,138,
	182,220,19,197,25,144,112,239,169,35,111,135,252,197,146,30,
	62,86,92,135,119,189,122,237,82,66,105,153,70,250,243,1,
	25,54,137,198,182,237,83,7,194,142,102,109,124,226,153,7,
	247,32,226,242,98,203,159,241,133,212,216,109,123,26,139,122,
	216,170,182,204,234,106,63,219,234,162,36,3,216,198,125,47,
	29,141,87,63,221,213,209,233,199,255,90,223,207,255,225,117,
	147,87,171,224,10,105,89,241,205,150,49,141,148,158,43,205,
	123,139,238,92,142,218,214,120,236,68,146,123,255,34,173,74,
	131,189,89,119,212,57,153,241,255,191,117,47,137,104,231,190,
	244,169,29,171,208,59,135,51,215,35,60,175,230,75,92,253,
	222,95,76,19,250,192,215,215,41,102,240,218,185,238,219,43,
	223,214,188,92,211,22,144,135,17,218,113,83,215,238,3,247,
	157,33,37,159,43,59,89,107,132,35,163,32,59,130,130,52,
	20,236,171,42,49,13,163,17,75,77,247,54,250,72,121,250,
	63,97,65,236,140,117,225,13,222,101,198,93,24,195,158,249,
	94,196,233,232,53,191,98,54,221,136,150,173,65,226,65,57,
	247,37,222,100,185,139,145,72,70,94,225,92,29,10,250,57,
	232,112,150,201,54,231,29,203,183,45,201,180,227,180,56,255,
	228,120,143,237,233,139,138,44,77,3,34,207,88,157,252,148,
	238,9,110,24,44,113,226,218,123,213,240,169,252,167,133,230,
	235,45,107,223,188,86,164,30,32,24,28,91,196,4,251,111,
	13,79,168,40,221,111,89,252,2,202,191,202,106,123,247,212,
	187,0,187,77,249,206,86,59,245,239,244,25,30,148,184,222,
	93,44,187,123,39,36,239,116,162,138,204,106,145,91,152,157,
	205,106,4,31,243,209,246,77,153,16,27,199,213,147,195,157,
	16,191,39,142,39,46,31,91,81,213,245,180,207,169,166,108,
	247,23,7,183,237,35,23,142,41,53,118,52,5,158,102,199,
	37,43,9,132,175,50,123,87,182,167,115,169,213,13,65,142,
	202,252,37,50,125,114,178,216,254,21,158,139,146,68,183,113,
	39,240,12,126,172,24,127,230,118,206,246,226,233,23,184,227,
	209,178,208,116,108,191,196,219,102,145,74,149,149,125,175,112,
	211,11,151,233,38,238,183,59,188,40,153,5,123,120,169,142,
	70,215,242,7,233,49,11,246,168,230,59,191,219,139,224,228,
	56,230,192,140,254,79,107,29,124,213,249,203,219,18,26,82,
	123,57,239,18,242,52,52,215,219,223,170,176,42,122,223,145,
	47,148,141,226,201,49,228,107,138,167,30,59,122,151,214,118,
	207,234,206,162,195,165,43,247,145,33,150,23,83,100,185,240,
	9,92,137,69,42,144,180,136,43,159,207,100,28,255,132,63,
	160,247,81,194,83,223,63,148,100,191,224,249,213,53,59,20,
	121,241,176,157,108,105,15,174,13,95,121,16,157,155,117,25,
	214,128,207,49,174,225,68,17,139,51,239,229,31,14,58,135,
	201,220,123,87,246,202,171,202,148,86,233,13,77,75,31,7,
	119,199,95,35,137,86,223,80,170,40,191,124,93,245,201,170,
	45,46,245,30,198,149,235,220,31,106,228,30,57,112,124,105,
	179,222,77,181,35,31,184,202,113,219,35,68,182,92,56,123,
	209,154,34,111,105,48,206,140,127,255,126,37,191,122,67,240,
	205,156,179,175,85,14,26,95,90,32,18,95,234,207,139,251,
	252,146,37,209,186,43,176,36,61,87,165,119,77,94,168,127,
	7,251,141,134,183,149,21,124,196,54,95,72,98,185,83,189,
	177,115,66,201,157,23,252,82,242,74,249,16,156,174,222,193,
	216,194,250,45,187,143,95,190,222,61,174,246,128,123,197,18,
	115,11,132,85,96,74,195,214,29,71,47,75,45,230,19,90,
	181,94,67,207,112,131,51,50,53,131,72,230,231,46,168,171,
	111,216,188,191,229,112,215,213,142,206,179,183,239,191,28,252,
	200,233,170,140,118,115,177,136,204,46,172,136,243,11,41,10,
	206,164,138,246,12,118,221,233,191,113,247,250,195,71,226,43,
	5,87,45,95,184,244,131,172,226,234,47,175,151,176,153,88,
	176,58,217,111,116,117,14,136,78,174,202,56,216,204,4,251,
	47,94,106,57,219,123,255,209,203,145,87,19,239,57,89,160,
	194,66,130,226,178,58,154,122,186,134,70,14,54,142,184,79,
	126,254,65,201,169,119,242,114,10,139,74,202,168,91,183,111,
	222,181,187,177,229,64,243,254,67,39,207,93,236,31,114,122,
	250,18,242,230,253,151,5,139,4,121,86,172,90,171,170,109,
	103,106,109,227,238,232,31,225,23,158,148,144,95,90,28,154,
	93,180,115,199,158,166,214,67,109,87,111,223,31,25,125,57,
	244,238,253,167,9,54,14,45,110,62,94,33,113,249,117,235,
	85,181,140,204,205,68,44,109,123,221,253,130,68,227,162,82,
	169,13,219,183,237,221,127,184,157,191,111,240,243,171,87,79,
	94,210,88,244,141,86,175,209,91,171,161,40,9,43,36,21,
	96,67,163,66,138,227,146,35,211,41,153,231,55,31,221,182,
	167,227,194,78,38,216,223,120,118,235,169,214,59,143,70,121,
	5,167,94,189,164,61,208,54,242,178,89,139,49,115,118,209,
	82,117,171,76,222,71,174,143,75,172,168,219,27,159,182,43,
	107,231,221,115,131,29,247,30,246,8,126,20,254,50,37,49,
	1,179,31,84,211,80,209,130,16,189,215,5,248,103,38,147,
	27,74,11,183,237,61,124,240,108,107,91,251,153,11,93,55,
	110,222,126,53,1,153,94,192,201,177,136,91,64,84,248,252,
	82,5,77,45,152,174,145,157,223,153,108,207,164,156,146,134,
	150,173,187,247,183,119,246,116,223,228,234,29,89,36,38,25,
	38,139,179,14,57,227,160,31,147,113,172,190,241,248,253,19,
	71,247,158,187,121,227,118,223,157,71,247,30,14,190,166,77,
	76,126,158,130,114,241,73,108,95,190,122,141,138,150,65,183,
	147,61,204,21,137,243,32,4,248,49,227,255,127,167,212,186,
	55,110,105,238,124,114,47,191,239,238,114,233,37,75,57,197,
	141,2,44,213,53,112,254,85,173,167,46,159,61,57,114,123,
	244,105,47,109,114,241,34,97,149,235,171,52,12,76,204,140,
	224,78,174,104,188,95,72,56,41,58,59,54,25,146,182,253,
	104,251,249,139,61,215,31,142,62,184,255,232,249,155,15,239,
	22,178,115,112,11,200,200,173,212,210,54,54,135,33,236,237,
	66,3,130,112,145,49,121,69,165,213,141,39,14,183,30,57,
	119,234,124,223,211,41,218,203,188,103,139,132,68,48,210,18,
	75,4,229,196,197,68,109,28,96,214,1,225,145,89,233,169,
	155,107,247,236,61,73,57,210,122,241,234,205,238,222,254,231,
	111,223,47,18,23,91,34,161,161,105,106,98,4,115,113,196,
	226,188,45,72,145,177,173,73,13,109,103,47,92,191,198,4,
	251,123,71,6,238,246,63,24,126,242,244,197,216,187,55,227,
	159,190,176,114,186,97,22,45,17,86,92,163,101,188,209,6,
	182,14,238,236,130,242,12,12,143,74,75,77,34,103,23,101,
	213,85,86,52,236,108,106,237,157,124,248,105,108,160,101,90,
	214,3,34,198,167,200,179,94,66,72,73,129,87,199,213,216,
	63,10,107,101,110,235,101,226,189,33,128,136,74,201,127,156,
	86,149,94,77,45,47,222,145,59,124,116,232,230,193,55,39,
	59,15,221,177,21,98,251,240,17,50,78,99,149,157,28,227,
	230,177,48,88,185,194,202,80,111,181,154,254,6,211,240,40,
	36,202,149,24,17,140,15,197,186,33,72,149,212,172,61,165,
	85,228,162,198,189,87,46,93,252,120,161,189,243,248,229,152,
	171,163,35,31,104,227,211,83,159,191,64,56,56,185,23,11,
	74,48,193,126,41,217,85,107,149,85,84,141,97,238,94,104,
	15,223,248,212,156,196,226,18,106,79,90,233,237,27,39,174,
	77,119,246,92,184,119,229,210,217,243,213,23,23,191,26,91,
	1,229,120,253,222,222,192,118,169,29,181,32,185,49,114,75,
	97,78,253,33,34,196,239,212,211,51,157,35,23,187,63,116,
	8,171,177,9,40,104,72,138,172,228,37,4,71,194,86,149,
	149,108,219,149,221,122,183,251,220,249,19,119,206,142,61,230,
	28,26,222,51,242,122,245,135,241,183,52,200,148,232,210,133,
	203,228,149,212,212,53,53,180,172,55,58,59,217,34,221,221,
	194,162,83,211,200,213,245,141,71,218,59,219,58,174,116,247,
	247,13,13,143,133,113,177,78,134,171,107,168,45,181,51,181,
	52,118,119,243,38,248,98,113,33,105,217,5,57,233,21,181,
	109,199,46,158,106,101,130,253,29,71,123,239,14,25,142,62,
	125,243,254,35,175,176,148,194,10,173,181,134,26,198,90,154,
	230,238,30,40,47,239,156,144,93,241,254,121,185,219,55,101,
	28,121,125,240,69,203,211,163,15,239,15,60,120,117,172,171,
	243,113,141,148,185,162,145,173,10,12,210,162,132,242,138,74,
	170,47,108,42,173,173,78,219,123,44,226,80,195,113,222,252,
	68,150,75,28,119,228,20,134,23,95,237,121,124,75,131,127,
	193,237,145,229,19,67,175,87,174,18,151,151,237,140,137,194,
	68,19,29,19,131,180,35,244,81,202,158,238,110,41,254,205,
	123,175,159,110,187,121,170,235,201,165,129,19,237,59,214,22,
	53,212,148,29,188,255,4,42,49,205,53,241,246,241,194,3,
	82,47,5,159,115,241,183,201,11,152,46,14,211,136,182,192,
	161,124,54,106,201,81,242,27,210,55,111,97,198,251,191,200,
	137,246,179,71,91,246,220,191,49,184,251,238,179,201,133,194,
	52,126,225,245,210,90,154,247,180,95,89,152,88,218,163,28,
	209,88,207,232,152,164,228,244,180,252,138,178,186,173,187,27,
	247,53,31,104,57,210,218,121,249,230,224,139,231,239,94,67,
	78,113,8,8,74,44,147,119,119,194,249,167,230,87,165,84,
	39,250,134,23,83,58,198,110,158,188,125,110,96,239,129,83,
	199,251,95,247,61,147,182,213,80,210,215,18,83,87,229,95,
	236,85,226,237,26,131,42,40,123,152,49,33,196,117,232,252,
	232,209,206,23,247,175,60,233,62,71,235,123,120,235,217,171,
	53,65,107,197,194,176,6,242,68,165,72,91,105,19,29,216,
	178,105,73,173,212,221,21,23,143,220,60,185,175,163,185,231,
	86,225,182,179,245,198,75,108,94,124,250,98,248,118,253,107,
	149,43,224,191,222,131,128,128,128,128,128,128,128,128,128,128,
	128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
	128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
	128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
	128,128,128,252,175,192,64,224,99,102,108,116,74,114,48,250,
	93,96,106,60,178,160,232,172,79,203,150,77,91,143,117,238,
	30,188,245,162,231,206,216,171,126,206,69,180,37,44,188,95,
	36,196,35,36,69,165,149,13,84,224,94,149,197,251,198,246,
	28,109,217,59,120,121,0,210,199,57,181,84,12,239,148,237,
	131,179,113,14,40,156,76,47,219,185,231,246,177,83,221,23,
	123,186,134,94,60,126,255,121,98,154,155,79,98,229,154,213,
	202,42,186,122,134,70,230,214,200,136,196,212,148,172,98,234,
	230,29,199,154,219,59,59,186,186,31,12,13,79,124,228,21,
	225,90,42,44,169,182,78,113,185,1,204,238,142,139,191,111,
	72,52,41,46,246,66,75,215,137,51,143,94,221,223,188,48,
	120,249,39,21,29,39,67,44,202,24,227,23,226,229,31,153,
	152,91,183,227,210,181,158,49,38,216,63,52,242,248,233,171,
	183,111,198,62,125,92,192,186,112,49,15,183,144,128,148,194,
	106,61,83,91,43,75,180,185,171,159,55,129,24,24,29,153,
	153,21,65,206,73,45,173,170,221,182,229,108,75,251,161,147,
	71,91,15,92,189,212,221,55,114,255,203,52,228,51,203,27,
	218,219,119,139,184,57,165,87,200,200,202,45,83,83,214,181,
	216,104,142,65,122,226,124,253,252,9,1,33,97,145,209,241,
	201,105,217,185,5,212,146,202,170,253,7,143,30,59,126,246,
	106,111,247,253,225,71,143,159,173,155,228,96,95,160,184,76,
	106,185,130,132,166,150,133,171,47,17,141,79,74,140,41,200,
	45,106,168,219,127,248,216,233,214,147,39,206,95,189,125,247,
	222,200,171,207,139,249,21,100,86,153,21,68,100,198,87,229,
	109,57,180,123,223,141,206,203,61,167,90,207,93,122,193,4,
	251,31,223,157,26,103,231,95,34,182,90,201,200,195,5,235,
	234,132,136,77,34,215,238,176,222,189,183,229,216,241,139,183,
	30,191,24,30,225,224,22,21,147,145,78,94,175,107,160,105,
	226,98,233,137,243,171,13,137,73,200,46,47,171,160,238,186,
	176,31,114,248,92,199,233,180,243,151,174,94,187,117,179,239,
	238,192,240,131,209,151,111,160,188,92,108,170,162,98,82,234,
	43,53,236,99,23,216,46,178,49,35,225,35,8,33,161,1,
	65,181,21,245,249,53,85,185,197,133,110,149,151,219,174,92,
	59,216,57,240,116,137,224,232,35,15,8,187,192,187,143,34,
	220,31,228,87,172,146,214,84,210,183,49,113,180,51,178,71,
	98,189,157,241,1,164,52,202,214,166,205,141,155,118,182,52,
	31,216,123,236,228,153,115,103,239,116,223,123,160,251,250,237,
	248,7,26,27,19,236,135,46,21,226,50,179,94,171,98,168,
	110,30,238,12,11,243,13,178,243,42,201,65,23,38,84,31,
	223,187,229,208,249,147,141,250,155,247,221,59,90,191,255,206,
	192,195,251,147,111,135,23,114,201,203,242,175,151,230,92,36,
	103,238,163,171,174,109,162,9,81,209,33,184,57,187,163,92,
	99,252,253,226,227,210,110,37,236,77,202,206,201,43,166,148,
	148,82,11,170,107,180,116,204,108,108,97,246,112,39,71,36,
	214,195,215,143,16,157,154,153,150,157,149,87,90,87,91,181,
	101,95,243,177,189,135,143,134,158,235,188,116,171,103,120,244,
	233,187,137,123,108,11,22,241,139,138,45,149,93,105,168,107,
	101,238,128,116,197,226,124,195,195,66,34,99,18,146,210,51,
	51,170,75,170,154,40,123,250,31,245,13,116,220,237,229,124,
	61,38,161,40,191,206,154,9,246,231,154,27,32,224,159,67,
	131,240,62,17,105,217,228,228,212,134,178,173,91,176,37,187,
	246,31,58,117,244,228,153,179,199,47,94,189,209,119,231,194,
	221,193,161,199,180,201,47,44,208,133,236,92,220,124,194,138,
	74,90,170,70,40,164,155,43,214,27,130,243,245,39,174,13,
	141,138,78,204,47,110,172,63,177,103,120,100,176,123,252,29,
	173,132,117,114,226,62,219,61,206,62,117,53,97,149,245,70,
	218,246,102,235,148,68,68,51,170,118,215,111,166,202,23,100,
	145,227,15,133,147,26,114,118,142,11,60,239,154,98,189,179,
	168,237,35,251,208,91,110,57,153,147,90,108,147,129,171,244,
	92,211,163,136,77,65,169,126,230,171,131,99,212,47,225,142,
	157,174,239,187,122,226,238,245,182,206,222,77,178,211,227,34,
	162,171,165,133,4,63,27,121,33,153,49,255,177,49,212,218,
	41,121,107,118,17,121,103,96,105,245,179,172,154,168,68,202,
	197,227,215,142,93,191,53,240,232,222,4,151,192,162,47,52,
	54,57,113,101,67,91,39,71,44,33,180,100,203,174,221,185,
	121,135,247,117,116,238,191,40,223,216,115,255,233,11,200,96,
	255,107,126,54,14,8,235,228,18,78,238,9,46,53,67,77,
	221,229,138,226,30,216,104,27,88,132,139,111,16,10,225,229,
	191,112,115,125,234,190,203,39,207,92,239,109,236,104,57,223,
	121,226,245,219,33,94,238,47,31,62,242,116,47,17,22,146,
	147,93,175,161,189,66,215,116,131,3,202,29,71,76,73,172,
	35,37,28,10,75,45,47,222,91,185,57,127,235,254,211,7,
	218,59,122,238,244,13,76,64,63,143,63,121,187,96,49,151,
	128,137,212,242,85,74,198,166,186,26,90,54,146,30,204,248,
	254,169,143,119,160,127,112,68,84,34,80,248,37,21,155,118,
	109,223,179,175,249,248,201,211,103,238,222,27,120,60,254,137,
	85,152,111,177,132,228,114,13,99,180,131,249,198,248,192,0,
	92,70,106,250,206,77,69,219,182,87,109,233,184,122,246,238,
	243,119,143,33,15,199,4,135,30,124,188,223,191,152,93,124,
	88,152,79,68,70,181,81,65,201,96,165,177,141,29,204,210,
	25,237,74,196,6,4,71,36,36,231,21,20,151,80,43,171,
	116,140,13,55,218,192,236,157,112,1,209,177,169,57,25,228,
	252,130,210,248,10,201,166,221,39,155,91,246,30,190,208,246,
	112,228,238,20,109,114,193,66,46,118,94,110,62,152,192,85,
	65,97,66,96,104,120,74,229,217,83,199,175,221,237,189,210,
	127,249,217,243,193,145,207,28,156,211,146,82,124,210,27,212,
	149,213,172,152,96,191,133,165,141,253,70,148,183,199,42,47,
	167,200,176,248,148,172,140,244,92,114,73,81,105,229,238,77,
	123,246,119,30,56,117,238,194,229,254,145,207,147,207,191,112,
	45,20,226,23,19,88,42,45,177,88,65,85,87,219,108,131,
	129,141,165,57,204,5,3,193,121,121,215,212,111,105,218,119,
	228,238,163,7,207,94,103,141,47,156,160,45,17,146,229,150,
	18,94,180,66,67,93,251,19,253,139,39,60,150,6,206,72,
	119,223,224,200,157,97,169,9,41,201,228,156,194,157,251,14,
	28,122,240,112,99,63,148,95,76,69,217,202,25,233,133,247,
	11,15,203,205,73,221,220,184,111,247,161,131,199,207,180,93,
	188,124,189,119,112,184,255,243,251,15,82,211,130,171,133,150,
	184,187,152,89,122,111,44,51,180,182,175,161,150,84,187,94,
	59,118,228,41,47,205,116,45,19,236,23,147,19,151,215,81,
	215,197,120,196,7,57,239,223,211,84,122,172,247,246,147,71,
	119,218,7,174,95,120,40,46,40,192,202,206,167,161,164,46,
	171,99,236,96,138,246,192,185,251,43,134,144,162,18,92,227,
	19,83,146,82,179,200,165,212,138,74,72,195,206,29,77,173,
	39,142,157,186,244,161,253,234,149,91,61,189,247,134,31,61,
	144,93,185,118,221,6,27,59,235,40,140,187,27,214,39,44,
	32,191,162,172,124,247,142,3,205,251,15,30,62,122,172,235,
	242,197,171,182,247,184,111,77,44,96,227,16,224,89,194,43,
	44,182,108,149,178,182,190,129,169,249,198,13,150,24,15,111,
	31,223,110,98,104,76,70,124,74,108,102,110,33,165,102,231,
	246,45,45,7,219,59,47,92,190,247,210,238,237,224,135,247,
	188,139,181,150,201,106,234,155,219,89,19,131,67,152,96,127,
	104,68,248,238,125,7,14,119,180,119,62,125,206,202,201,47,
	40,42,43,41,181,76,102,245,90,125,131,13,150,102,246,214,
	112,7,27,167,242,138,109,77,123,91,7,251,7,238,220,120,
	249,106,236,237,228,39,22,222,133,15,196,148,52,205,54,24,
	153,64,12,156,108,209,46,88,28,222,219,143,232,223,180,191,
	245,204,181,27,55,123,238,15,62,24,25,125,253,252,213,248,
	216,199,73,54,81,113,105,57,249,229,244,207,169,172,93,167,
	98,106,98,103,11,131,35,35,74,210,138,168,229,245,13,59,
	15,158,185,116,172,243,218,141,238,145,7,15,123,134,117,222,
	142,189,17,18,228,20,88,204,198,193,207,181,96,173,196,242,
	101,178,202,22,42,230,6,174,30,132,200,232,199,47,222,112,
	114,60,103,101,91,165,176,79,94,218,84,136,223,216,208,192,
	156,25,254,207,205,221,27,110,143,10,203,201,106,12,142,173,
	218,186,171,185,163,237,196,209,227,157,215,206,246,221,252,52,
	250,242,245,148,184,132,20,41,38,33,37,59,55,175,184,172,
	168,118,219,174,163,187,155,60,175,116,93,187,222,115,239,254,
	192,208,163,39,175,33,227,31,62,210,231,231,99,231,56,34,
	36,187,218,192,202,193,209,11,235,225,233,67,8,240,143,10,
	139,44,171,105,88,119,30,229,125,175,18,241,64,80,20,233,
	126,106,229,229,9,8,148,93,82,94,77,67,223,200,204,17,
	233,77,72,200,169,217,177,239,208,145,139,247,135,159,114,11,
	138,170,170,91,232,215,214,93,238,185,53,240,105,169,146,178,
	166,65,190,97,235,49,35,57,3,19,103,215,224,140,142,222,
	207,92,162,218,38,248,248,71,47,223,243,9,202,197,192,61,
	2,187,190,127,31,230,191,64,199,165,235,31,39,229,20,141,
	9,181,27,32,156,66,82,58,114,203,148,148,215,171,78,110,
	180,233,64,185,122,226,195,163,162,243,77,26,154,79,116,94,
	144,235,127,66,19,80,84,245,177,216,24,151,82,82,81,125,
	98,226,204,237,207,44,14,146,144,213,235,209,97,36,211,45,
	219,154,47,92,127,242,242,205,216,103,46,203,14,245,13,46,
	94,222,190,201,130,219,154,174,29,110,127,240,244,217,251,15,
	188,66,134,186,6,102,246,206,104,98,184,87,78,105,109,221,
	182,135,143,121,37,37,164,86,171,155,59,123,224,9,81,169,
	187,154,66,174,245,222,158,94,200,167,138,194,236,142,136,204,
	200,172,168,153,236,236,25,122,254,234,203,2,158,181,235,181,
	13,145,120,179,212,172,156,210,221,123,78,119,244,222,237,31,
	248,108,174,102,138,113,111,60,208,198,4,251,207,119,241,137,
	91,172,90,167,10,71,185,123,226,18,179,243,242,75,27,118,
	28,110,61,127,105,226,205,251,133,108,43,173,220,220,97,222,
	164,140,173,141,71,122,238,60,228,85,146,146,89,171,108,110,
	1,223,232,128,241,240,21,202,200,42,110,59,14,233,248,2,
	17,114,114,54,204,175,62,117,102,114,108,197,74,97,123,159,
	248,178,250,134,205,219,27,47,94,235,237,27,121,202,206,37,
	46,97,165,176,114,149,210,234,181,235,148,77,205,45,172,93,
	112,196,192,204,172,156,10,192,105,82,182,239,220,117,232,244,
	133,139,119,167,89,68,214,5,199,20,135,117,61,132,64,57,
	132,132,197,164,214,168,155,88,123,227,3,131,67,83,170,107,
	235,182,239,62,124,238,74,87,207,40,144,183,98,106,26,230,
	182,48,12,22,23,155,92,186,123,104,13,51,230,255,53,129,
	217,193,125,131,172,247,243,52,61,124,11,249,184,116,237,122,
	53,27,91,51,115,152,157,61,6,46,38,30,227,128,144,168,
	56,112,244,194,165,208,158,251,207,95,178,58,106,187,5,58,
	101,52,116,180,156,232,122,62,197,191,70,215,2,230,1,9,
	12,14,171,115,190,221,199,178,94,74,70,85,195,123,19,42,
	48,166,176,180,161,245,86,223,0,59,135,128,164,252,122,227,
	141,8,76,108,90,110,195,246,179,87,122,71,92,86,114,44,
	17,66,89,56,120,146,243,45,92,139,202,79,119,245,15,190,
	120,69,67,11,42,168,107,234,93,186,61,244,78,212,202,131,
	224,27,120,226,210,181,219,24,4,218,35,98,186,96,211,150,
	173,187,246,30,57,117,186,243,214,212,23,8,11,78,110,141,
	142,137,5,220,41,33,179,184,98,199,174,211,103,206,51,99,
	254,199,27,195,207,88,216,184,176,27,177,33,225,25,117,251,
	128,190,231,172,145,138,148,252,58,148,183,116,83,108,94,225,
	230,253,151,187,94,242,79,47,88,200,55,46,170,168,229,130,
	214,192,213,6,144,42,142,210,62,79,45,10,205,202,222,211,
	116,8,242,172,247,5,27,23,159,160,116,197,238,75,93,233,
	239,151,122,136,138,137,175,80,86,209,54,42,245,236,121,244,
	129,95,72,78,211,2,230,230,73,138,217,113,125,112,252,131,
	28,206,203,220,17,229,87,107,233,235,61,60,254,233,11,158,
	95,98,95,215,141,219,50,242,250,33,113,81,103,76,105,82,
	107,52,28,175,110,63,244,240,201,43,142,53,132,236,178,242,
	202,234,205,45,167,58,206,157,191,61,112,255,245,184,130,160,
	144,176,156,252,138,117,235,213,244,55,162,211,234,246,28,104,
	189,61,249,144,9,246,63,122,57,198,206,167,165,173,163,103,
	100,98,23,157,125,246,242,149,155,67,211,11,164,101,151,111,
	180,180,242,198,251,135,84,111,57,222,121,127,112,193,148,170,
	149,23,49,52,172,160,126,251,174,61,135,79,94,190,126,115,
	255,221,251,200,244,123,181,91,33,219,186,239,251,62,125,173,
	170,107,11,179,115,13,10,47,219,123,188,237,226,253,254,113,
	63,46,41,37,101,127,7,132,179,11,202,245,58,62,224,248,
	133,199,200,58,40,235,178,53,107,181,172,96,14,135,219,218,
	187,122,39,160,28,50,34,107,220,99,124,194,72,233,228,194,
	186,29,109,93,143,62,77,65,228,141,237,236,17,94,248,40,
	73,41,19,11,7,175,144,120,50,245,204,158,214,219,148,199,
	236,66,241,117,91,247,236,59,120,168,253,6,159,182,11,165,
	180,124,243,39,116,148,2,145,9,246,231,64,121,249,21,149,
	214,26,89,108,220,12,103,219,234,234,87,187,122,237,177,19,
	155,91,219,47,92,127,126,119,236,61,68,216,91,211,192,17,
	41,16,21,29,155,144,154,81,92,53,218,124,234,220,229,107,
	221,254,111,33,124,2,75,165,228,124,55,64,204,97,8,23,
	47,31,255,144,45,217,197,37,101,212,154,221,74,7,142,159,
	232,56,255,46,165,43,180,167,111,248,105,49,117,143,231,25,
	92,87,111,0,113,108,138,196,170,168,236,140,245,34,248,250,
	133,172,49,139,143,198,101,147,219,54,213,0,158,98,71,113,
	19,208,5,12,169,178,241,41,73,202,44,83,88,175,189,225,
	137,167,255,120,136,212,84,54,164,184,180,188,114,127,243,193,
	200,99,55,110,223,25,162,61,124,186,14,162,193,47,100,36,
	189,214,192,18,227,236,73,12,8,100,130,253,28,19,34,18,
	86,30,156,225,105,185,173,21,91,154,206,183,246,174,124,55,
	14,229,23,182,115,194,4,68,165,167,178,87,232,108,221,190,
	239,248,137,75,210,55,142,125,228,90,180,76,221,96,67,124,
	45,33,32,118,235,193,155,71,206,72,186,185,223,130,220,245,
	26,127,239,180,108,101,144,9,206,39,128,156,95,214,176,189,
	105,239,145,227,167,219,205,94,188,30,123,7,97,225,212,51,
	222,110,97,181,211,195,211,123,56,33,53,187,232,92,119,89,
	224,233,139,87,110,12,220,125,224,253,116,37,150,157,79,89,
	115,92,223,208,200,194,221,35,112,97,118,94,89,85,237,206,
	166,230,115,87,7,159,124,248,200,34,36,239,164,24,103,102,
	110,99,27,225,27,28,30,65,138,123,120,123,79,85,109,221,
	206,219,83,87,52,76,239,143,190,177,250,52,57,181,64,138,
	9,246,203,172,80,209,238,176,180,33,144,115,243,11,41,165,
	181,187,15,4,182,95,125,240,110,124,33,219,34,110,193,101,
	183,139,244,43,205,169,138,104,172,5,41,50,190,126,111,235,
	133,171,247,71,30,62,126,197,182,225,218,98,110,145,21,107,
	156,240,177,144,220,26,192,219,31,104,57,116,252,244,221,123,
	67,143,222,188,122,15,225,16,81,91,99,227,224,27,28,159,
	148,146,222,30,20,183,109,247,158,99,167,59,187,251,164,166,
	56,120,150,54,73,89,120,133,37,22,110,222,122,180,131,118,
	254,114,247,205,158,7,175,94,191,251,44,34,34,183,76,220,
	38,137,92,182,243,221,254,3,167,46,244,245,191,122,251,158,
	143,95,64,76,74,39,216,216,220,35,30,93,92,2,72,176,
	157,77,141,183,6,6,223,23,10,201,43,154,219,192,29,60,
	189,227,2,195,153,96,127,229,246,91,71,167,88,185,249,236,
	236,85,212,117,245,140,77,97,230,40,201,237,1,233,149,203,
	74,79,126,236,185,117,111,232,249,139,183,156,82,203,21,215,
	185,162,221,194,19,178,138,106,235,47,95,185,117,123,248,225,
	163,233,5,65,188,130,194,225,16,41,21,83,71,98,108,74,
	122,6,185,249,208,209,211,103,47,246,244,190,157,248,188,128,
	67,118,149,25,28,246,172,221,5,237,245,254,48,253,195,98,
	113,201,148,226,74,158,166,3,135,196,79,47,125,113,155,101,
	33,127,152,216,205,110,27,91,71,183,235,15,111,69,68,222,
	45,30,244,226,219,223,220,126,161,187,175,255,205,71,43,184,
	181,168,244,26,188,170,174,129,169,153,165,141,147,75,20,49,
	40,54,62,149,66,13,172,168,172,170,217,221,120,240,196,228,
	67,87,129,246,115,87,174,245,50,193,254,190,135,143,94,124,
	100,101,207,202,46,213,205,55,247,11,8,139,77,42,222,74,
	173,216,190,255,200,241,214,51,55,122,181,45,148,181,116,70,
	128,50,186,58,254,101,137,184,228,82,21,85,53,67,115,203,
	88,152,131,247,226,196,180,220,55,69,245,144,77,222,141,39,
	59,123,174,223,27,152,126,252,98,236,237,187,169,101,139,120,
	249,150,232,139,40,172,179,66,6,144,98,83,170,247,86,156,
	60,117,30,232,227,71,31,191,26,131,114,241,168,107,232,36,
	25,218,162,3,211,115,218,75,203,202,155,206,94,239,238,189,
	123,239,233,139,151,16,8,215,50,133,21,132,117,122,104,119,
	143,144,228,20,114,126,81,133,145,8,109,226,102,227,222,131,
	103,213,46,0,130,115,240,233,7,13,41,185,21,75,84,244,
	54,90,90,219,216,193,17,142,46,94,204,168,255,37,59,14,
	158,110,191,212,167,254,124,98,146,107,177,232,114,13,189,68,
	7,23,87,15,223,138,4,10,245,84,253,182,125,222,135,128,
	103,191,255,148,250,25,194,206,37,207,10,116,19,38,22,214,
	85,142,120,191,128,160,200,196,148,204,178,114,200,137,206,250,
	3,95,94,92,186,113,243,30,235,2,54,118,142,197,103,214,
	173,183,183,66,184,247,80,147,171,27,54,239,221,215,210,122,
	249,102,223,61,246,133,150,74,106,90,218,171,55,0,190,82,
	49,40,56,58,169,0,120,163,216,127,160,205,227,138,143,239,
	59,26,59,191,168,88,154,246,234,245,170,250,14,165,196,0,
	106,80,112,104,84,74,6,185,180,162,166,110,219,206,67,71,
	142,181,158,62,119,121,248,241,132,0,141,101,217,122,109,132,
	145,137,173,131,91,104,74,70,182,109,113,121,37,19,236,111,
	216,180,109,119,227,177,19,199,123,239,220,127,253,220,153,22,
	44,179,108,149,139,176,190,129,209,70,152,189,67,64,88,104,
	108,66,98,138,96,30,105,115,212,254,35,167,207,116,94,187,
	57,48,56,244,248,197,171,177,9,86,81,118,222,189,60,2,
	18,144,165,154,203,87,234,169,250,95,52,206,181,116,186,29,
	84,86,179,169,97,199,206,125,86,23,157,158,188,144,19,17,
	95,163,190,75,251,209,85,164,135,191,84,88,124,130,13,178,
	170,126,243,214,93,247,7,31,142,62,123,81,242,102,124,114,
	237,66,54,78,110,49,217,213,22,222,254,125,228,210,173,181,
	117,245,39,46,92,233,186,53,52,60,58,65,155,252,178,131,
	79,66,121,185,174,21,18,189,144,16,86,90,70,173,222,180,
	235,224,137,179,231,175,92,237,221,184,235,160,29,215,18,33,
	9,41,47,102,124,255,77,203,194,198,25,133,193,122,16,252,
	73,209,169,100,202,150,61,61,7,143,181,158,58,125,229,198,
	227,39,227,15,71,216,199,244,87,0,239,109,235,71,223,37,
	25,191,114,138,241,246,241,11,111,102,167,20,85,243,236,59,
	212,122,238,146,181,119,15,164,247,238,179,55,172,139,120,120,
	21,204,172,224,46,238,158,126,65,193,33,107,157,241,219,113,
	135,143,156,190,211,113,246,194,213,39,183,229,71,159,99,222,
	179,114,118,242,75,13,245,0,25,107,177,120,178,23,229,234,
	31,50,144,36,146,153,157,87,238,81,187,99,247,225,35,103,
	110,247,141,142,77,64,95,34,249,68,36,101,86,172,54,11,
	39,37,102,102,41,21,85,84,153,232,233,26,152,152,218,181,
	133,56,100,122,122,121,7,38,36,218,80,226,120,168,53,77,
	208,246,107,35,143,152,241,253,215,183,80,46,14,158,37,194,
	203,86,43,155,248,132,146,226,42,107,182,238,56,154,120,238,
	214,157,209,253,220,239,39,95,169,11,75,189,89,182,98,181,
	164,62,135,159,72,202,210,244,12,185,138,230,182,246,222,254,
	129,135,207,94,192,167,166,131,23,12,64,196,100,229,164,84,
	212,244,204,45,205,144,214,145,118,177,46,121,24,175,35,110,
	238,49,69,9,73,105,228,146,29,59,155,15,30,111,125,240,
	228,35,208,48,28,37,36,149,245,76,93,78,37,245,180,228,
	151,150,85,215,94,188,222,51,240,104,130,119,137,80,184,136,
	182,149,29,220,1,229,138,25,192,71,70,199,167,112,223,43,
	223,126,138,163,235,218,77,252,227,103,175,223,140,209,166,22,
	75,44,91,174,164,102,23,188,220,196,0,142,0,222,82,74,
	227,18,146,82,50,75,106,235,63,49,193,254,15,31,143,0,
	111,59,119,250,6,135,71,63,64,150,72,201,46,91,193,173,
	173,167,109,36,131,112,14,142,138,205,202,201,47,170,169,221,
	41,123,160,165,173,253,198,173,219,35,163,71,23,178,243,240,
	9,136,73,203,202,175,215,49,48,50,129,35,33,222,248,176,
	248,254,187,59,114,114,75,26,190,60,58,197,215,214,245,126,
	208,114,228,209,232,179,231,47,89,88,23,9,172,92,171,162,
	199,107,133,196,122,11,9,250,173,15,110,104,61,121,234,76,
	119,201,141,155,253,111,198,140,89,120,52,229,55,152,89,58,
	224,113,201,57,148,250,253,71,122,239,60,223,52,246,110,106,
	122,223,18,193,12,89,117,3,51,91,228,94,202,145,83,183,
	63,167,115,45,228,94,42,189,198,100,49,220,61,50,41,37,
	183,180,172,166,78,187,69,255,212,121,51,11,59,71,38,216,
	239,226,23,24,126,180,164,184,210,187,122,107,239,173,190,134,
	55,99,124,156,60,1,233,101,219,143,116,94,232,123,177,120,
	106,138,141,44,40,44,43,183,226,132,176,134,182,181,35,46,
	32,48,184,162,110,111,203,161,195,39,82,111,244,192,38,222,
	1,250,73,68,201,200,10,185,120,235,65,159,195,78,109,157,
	203,46,93,189,121,107,104,236,253,36,116,177,38,209,196,212,
	237,194,197,140,60,138,228,166,67,251,15,183,95,184,125,111,
	144,246,225,45,228,249,151,233,5,108,162,75,165,52,181,117,
	204,45,92,80,158,222,17,49,25,5,59,247,182,28,110,239,
	184,107,105,254,226,21,11,151,176,8,81,117,131,133,21,12,
	238,140,242,240,196,19,124,179,178,227,19,146,114,242,203,43,
	235,119,52,30,63,209,12,248,161,174,235,183,251,30,61,94,
	194,12,255,175,248,113,98,18,202,45,36,41,181,66,49,20,
	120,185,114,113,37,134,134,111,170,188,154,157,91,88,247,254,
	225,192,88,219,249,123,15,30,115,242,10,139,76,170,168,233,
	154,181,189,14,12,142,142,201,204,203,231,107,60,24,122,97,
	82,122,181,42,68,77,67,207,216,51,39,245,121,149,202,227,
	93,251,90,142,159,164,125,186,115,119,96,129,160,188,162,134,
	177,133,147,11,218,191,225,0,181,170,110,243,129,230,83,87,
	110,244,220,233,27,30,91,192,205,35,40,220,74,145,87,81,
	93,110,225,211,216,180,255,218,145,163,39,90,79,159,61,127,
	121,40,105,120,228,209,179,55,99,239,56,116,223,8,139,208,
	63,198,107,191,94,69,85,71,87,207,200,152,241,206,235,177,
	101,251,177,147,167,219,47,246,244,221,239,124,51,241,153,107,
	137,176,184,12,19,236,95,175,97,106,131,60,187,239,210,145,
	238,99,97,157,215,187,111,61,1,84,220,83,214,197,124,252,
	194,75,149,84,245,101,172,189,240,196,128,240,200,168,237,123,
	14,244,235,55,31,61,117,254,221,157,129,199,207,158,191,126,
	37,68,35,127,180,20,22,133,136,137,75,202,173,80,92,213,
	177,94,67,211,12,243,212,210,170,223,17,137,118,195,250,249,
	19,3,131,66,194,72,177,163,111,23,65,187,150,136,136,174,
	235,16,87,185,177,193,10,139,155,240,35,166,2,215,75,76,
	207,175,220,116,250,208,177,147,237,231,47,246,222,29,28,26,
	25,103,231,130,114,139,45,149,140,19,77,206,168,222,153,119,
	82,115,240,241,171,105,104,20,171,136,216,58,77,29,125,99,
	51,115,132,19,114,204,13,234,39,30,24,66,98,198,119,63,
	64,64,254,55,240,255,0,187,40,98,171
};
