#include <stdio.h>
#include <string.h>

/* base64 encoding table */
char base64_encode_table[] = {
  'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K',
  'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
  'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o',
  'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3',
  '4', '5', '6', '7', '8', '9', '+', '/'
 };

int base64_encode_bitmap[] = {
  128, 64, 32, 16, 8, 4, 2, 1
 };

int base64_encode_bitmap2[] = {
  32, 16, 8, 4, 2, 1
};


int base64_encode(char *inraw, int inraw_len, char *outb64) {
  int maxbits = inraw_len * 8;
  int curinbit = 0;
  int curoutbit = 0;
  int curbyte = -1;
  int byte = inraw[0];
  int nextbyte = 0;

  /* go through each byte in inraw up to max */
  for (curinbit=0; curinbit<maxbits; curinbit++) {
    int bitcount = (curinbit % 8);
    if ( ( curinbit % 8 ) == 0 ) {
      curbyte++;
      byte = inraw[curbyte];
    }
    if ( ( byte - base64_encode_bitmap[(bitcount)] ) > -1 ) { /* bit is on, or 1 */
      nextbyte += base64_encode_bitmap2[(curinbit%6)];
      byte = ( byte - base64_encode_bitmap[(bitcount)] );
    }
    if ( ((curinbit%6) == 5) || (curinbit == (maxbits-1)) ) {
      outb64[curoutbit++] = base64_encode_table[nextbyte];
      nextbyte = 0;
    }
    
  }
  
  if ( (inraw_len%3) != 0 ) {
    //outb64[curoutbit++] = base64_encode_table[nextbyte];
    curinbit = (inraw_len%3);
    while ( (inraw_len++%3) != 0 ) {
      outb64[curoutbit++] = '=';
    }
  }
  
  return(0);
}


/*
#include <stdlib.h>
int main(int argc, char **argv) {
  char *buffer = argv[1];
  char newbuffer[1024];
  memset(newbuffer, '\0', sizeof(newbuffer));
  if ( argc < 2 ) {
    printf("Usage: %s TEXT\n", argv[0]);
    exit(1);
  }
  base64_encode(buffer, strlen(buffer), newbuffer);
  printf("size: %i\nold: %s\nnew: %s\n", strlen(buffer), buffer, newbuffer);
  return(0);
}
*/
