/* dconf-window.c generated by valac 0.34.0.3-63fa6, the Vala compiler
 * generated from dconf-window.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <cairo.h>


#define TYPE_BEHAVIOUR (behaviour_get_type ())

#define TYPE_DCONF_WINDOW (dconf_window_get_type ())
#define DCONF_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DCONF_WINDOW, DConfWindow))
#define DCONF_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DCONF_WINDOW, DConfWindowClass))
#define IS_DCONF_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DCONF_WINDOW))
#define IS_DCONF_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DCONF_WINDOW))
#define DCONF_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DCONF_WINDOW, DConfWindowClass))

typedef struct _DConfWindow DConfWindow;
typedef struct _DConfWindowClass DConfWindowClass;
typedef struct _DConfWindowPrivate DConfWindowPrivate;

#define TYPE_BOOKMARKS (bookmarks_get_type ())
#define BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOKMARKS, Bookmarks))
#define BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOKMARKS, BookmarksClass))
#define IS_BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOKMARKS))
#define IS_BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOKMARKS))
#define BOOKMARKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOKMARKS, BookmarksClass))

typedef struct _Bookmarks Bookmarks;
typedef struct _BookmarksClass BookmarksClass;

#define TYPE_PATH_BAR (path_bar_get_type ())
#define PATH_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATH_BAR, PathBar))
#define PATH_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PATH_BAR, PathBarClass))
#define IS_PATH_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATH_BAR))
#define IS_PATH_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PATH_BAR))
#define PATH_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PATH_BAR, PathBarClass))

typedef struct _PathBar PathBar;
typedef struct _PathBarClass PathBarClass;

#define TYPE_REGISTRY_VIEW (registry_view_get_type ())
#define REGISTRY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGISTRY_VIEW, RegistryView))
#define REGISTRY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGISTRY_VIEW, RegistryViewClass))
#define IS_REGISTRY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGISTRY_VIEW))
#define IS_REGISTRY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGISTRY_VIEW))
#define REGISTRY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGISTRY_VIEW, RegistryViewClass))

typedef struct _RegistryView RegistryView;
typedef struct _RegistryViewClass RegistryViewClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;

#define TYPE_CONFIGURATION_EDITOR (configuration_editor_get_type ())
#define CONFIGURATION_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_EDITOR, ConfigurationEditor))
#define CONFIGURATION_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_EDITOR, ConfigurationEditorClass))
#define IS_CONFIGURATION_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_EDITOR))
#define IS_CONFIGURATION_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_EDITOR))
#define CONFIGURATION_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_EDITOR, ConfigurationEditorClass))

typedef struct _ConfigurationEditor ConfigurationEditor;
typedef struct _ConfigurationEditorClass ConfigurationEditorClass;

#define TYPE_PATH_ELEMENT (path_element_get_type ())
#define PATH_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATH_ELEMENT, PathElement))
#define IS_PATH_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATH_ELEMENT))
#define PATH_ELEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_PATH_ELEMENT, PathElementIface))

typedef struct _PathElement PathElement;
typedef struct _PathElementIface PathElementIface;

typedef enum  {
	BEHAVIOUR_UNSAFE,
	BEHAVIOUR_SAFE,
	BEHAVIOUR_ALWAYS_CONFIRM_IMPLICIT,
	BEHAVIOUR_ALWAYS_CONFIRM_EXPLICIT,
	BEHAVIOUR_ALWAYS_DELAY
} Behaviour;

struct _DConfWindow {
	GtkApplicationWindow parent_instance;
	DConfWindowPrivate * priv;
};

struct _DConfWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _DConfWindowPrivate {
	gchar* _current_path;
	gint window_width;
	gint window_height;
	gboolean window_is_maximized;
	gboolean window_is_tiled;
	GSettings* settings;
	Bookmarks* bookmarks_button;
	GtkMenuButton* info_button;
	PathBar* pathbar;
	RegistryView* registry_view;
	GtkRevealer* notification_revealer;
	GtkLabel* notification_label;
	gulong behaviour_changed_handler;
	gulong small_keys_list_rows_handler;
	gulong small_bookmarks_rows_handler;
};

struct _Block1Data {
	int _ref_count_;
	DConfWindow* self;
	GtkStyleContext* context;
};

struct _Block2Data {
	int _ref_count_;
	DConfWindow* self;
	GtkCheckButton* checkbutton;
};

struct _PathElementIface {
	GTypeInterface parent_iface;
};


static gpointer dconf_window_parent_class = NULL;

GType behaviour_get_type (void) G_GNUC_CONST;
GType dconf_window_get_type (void) G_GNUC_CONST;
GType bookmarks_get_type (void) G_GNUC_CONST;
GType path_bar_get_type (void) G_GNUC_CONST;
GType registry_view_get_type (void) G_GNUC_CONST;
#define DCONF_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DCONF_WINDOW, DConfWindowPrivate))
enum  {
	DCONF_WINDOW_DUMMY_PROPERTY,
	DCONF_WINDOW_CURRENT_PATH
};
static void dconf_window_reset_recursively (DConfWindow* self);
static void _dconf_window_reset_recursively_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void dconf_window_reset (DConfWindow* self);
static void _dconf_window_reset_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void dconf_window_enter_delay_mode (DConfWindow* self);
static void _dconf_window_enter_delay_mode_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
DConfWindow* dconf_window_new (void);
DConfWindow* dconf_window_construct (GType object_type);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
void registry_view_invalidate_popovers (RegistryView* self);
static void _registry_view_invalidate_popovers_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda85_ (Block1Data* _data1_);
static void ___lambda85__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda86_ (Block1Data* _data1_);
static void ___lambda86__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
void registry_view_init (RegistryView* self, const gchar* path, gboolean restore_view);
gchar* dconf_window_stripped_path (const gchar* path);
GtkWidget* _dconf_window_get_parent (GtkWidget* widget);
static void dconf_window_on_show (DConfWindow* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda87_ (Block2Data* _data2_);
static void ___lambda87__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void _dconf_window_on_show_gtk_widget_show (GtkWidget* _sender, gpointer self);
static gboolean dconf_window_on_window_state_event (DConfWindow* self, GtkWidget* widget, GdkEventWindowState* event);
static gboolean _dconf_window_on_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static void dconf_window_on_size_allocate (DConfWindow* self, GtkAllocation* allocation);
static void _dconf_window_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static void dconf_window_on_destroy (DConfWindow* self);
GType configuration_editor_get_type (void) G_GNUC_CONST;
void configuration_editor_clean_copy_notification (ConfigurationEditor* self);
static const gchar* dconf_window_get_current_path (DConfWindow* self);
static void _dconf_window_on_destroy_gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void dconf_window_request_path (DConfWindow* self, const gchar* full_name);
void registry_view_set_search_mode (RegistryView* self, gboolean* mode);
void registry_view_path_requested (RegistryView* self, const gchar* _full_name, const gchar* selected);
gchar* path_bar_get_selected_child (PathBar* self, const gchar* current_path);
GType path_element_get_type (void) G_GNUC_CONST;
static void _dconf_window_request_path_path_element_request_path (PathElement* _sender, const gchar* path, gpointer self);
void dconf_window_update_path_elements (DConfWindow* self);
void bookmarks_set_path (Bookmarks* self, const gchar* path);
void path_bar_set_path (PathBar* self, const gchar* path);
void dconf_window_update_hamburger_menu (DConfWindow* self);
gboolean registry_view_get_current_delay_mode (RegistryView* self);
void registry_view_reset (RegistryView* self, gboolean recursively);
void registry_view_enter_delay_mode (RegistryView* self);
static gboolean dconf_window_on_key_press_event (DConfWindow* self, GtkWidget* widget, GdkEventKey* event);
void registry_view_discard_row_popover (RegistryView* self);
void bookmarks_set_bookmarked (Bookmarks* self, gboolean new_state);
gchar* registry_view_get_copy_text (RegistryView* self);
void configuration_editor_copy (ConfigurationEditor* self, const gchar* text);
void configuration_editor_about_cb (ConfigurationEditor* self);
gboolean path_bar_open_child (PathBar* self, const gchar* current_path);
gboolean registry_view_show_row_popover (RegistryView* self);
gboolean registry_view_handle_search_event (RegistryView* self, GdkEventKey* event);
static gboolean _dconf_window_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void dconf_window_on_menu_button_clicked (DConfWindow* self);
static void _dconf_window_on_menu_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
void dconf_window_show_notification (DConfWindow* self, const gchar* notification);
static void dconf_window_hide_notification (DConfWindow* self);
static void _dconf_window_hide_notification_gtk_button_clicked (GtkButton* _sender, gpointer self);
void dconf_window_set_current_path (DConfWindow* self, const gchar* value);
static void dconf_window_finalize (GObject* obj);
static void _vala_dconf_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dconf_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const GActionEntry DCONF_WINDOW_action_entries[3] = {{"reset-recursive", _dconf_window_reset_recursively_gsimple_action_activate_callback}, {"reset-visible", _dconf_window_reset_gsimple_action_activate_callback}, {"enter-delay-mode", _dconf_window_enter_delay_mode_gsimple_action_activate_callback}};

GType behaviour_get_type (void) {
	static volatile gsize behaviour_type_id__volatile = 0;
	if (g_once_init_enter (&behaviour_type_id__volatile)) {
		static const GEnumValue values[] = {{BEHAVIOUR_UNSAFE, "BEHAVIOUR_UNSAFE", "unsafe"}, {BEHAVIOUR_SAFE, "BEHAVIOUR_SAFE", "safe"}, {BEHAVIOUR_ALWAYS_CONFIRM_IMPLICIT, "BEHAVIOUR_ALWAYS_CONFIRM_IMPLICIT", "always-confirm-implicit"}, {BEHAVIOUR_ALWAYS_CONFIRM_EXPLICIT, "BEHAVIOUR_ALWAYS_CONFIRM_EXPLICIT", "always-confirm-explicit"}, {BEHAVIOUR_ALWAYS_DELAY, "BEHAVIOUR_ALWAYS_DELAY", "always-delay"}, {0, NULL, NULL}};
		GType behaviour_type_id;
		behaviour_type_id = g_enum_register_static ("Behaviour", values);
		g_once_init_leave (&behaviour_type_id__volatile, behaviour_type_id);
	}
	return behaviour_type_id__volatile;
}


static void _dconf_window_reset_recursively_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 31 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_reset_recursively ((DConfWindow*) self);
#line 246 "dconf-window.c"
}


static void _dconf_window_reset_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 31 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_reset ((DConfWindow*) self);
#line 253 "dconf-window.c"
}


static void _dconf_window_enter_delay_mode_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 31 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_enter_delay_mode ((DConfWindow*) self);
#line 260 "dconf-window.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 60 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 60 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return _data1_;
#line 269 "dconf-window.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 60 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 278 "dconf-window.c"
		DConfWindow* self;
#line 60 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		self = _data1_->self;
#line 60 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_object_unref0 (_data1_->context);
#line 60 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_object_unref0 (self);
#line 60 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_slice_free (Block1Data, _data1_);
#line 288 "dconf-window.c"
	}
}


static void _registry_view_invalidate_popovers_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 64 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_invalidate_popovers ((RegistryView*) self);
#line 296 "dconf-window.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 70 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return self ? g_object_ref (self) : NULL;
#line 303 "dconf-window.c"
}


static void __lambda85_ (Block1Data* _data1_) {
	DConfWindow* self;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 79 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self = _data1_->self;
#line 80 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->settings;
#line 80 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = g_settings_get_boolean (_tmp0_, "small-keys-list-rows");
#line 80 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp1_) {
#line 319 "dconf-window.c"
		GtkStyleContext* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 82 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp2_ = _data1_->context;
#line 82 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp3_ = gtk_style_context_has_class (_tmp2_, "small-keys-list-rows");
#line 82 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (!_tmp3_) {
#line 328 "dconf-window.c"
			GtkStyleContext* _tmp4_ = NULL;
#line 82 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp4_ = _data1_->context;
#line 82 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_style_context_add_class (_tmp4_, "small-keys-list-rows");
#line 334 "dconf-window.c"
		}
	} else {
		GtkStyleContext* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 84 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp5_ = _data1_->context;
#line 84 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp6_ = gtk_style_context_has_class (_tmp5_, "small-keys-list-rows");
#line 84 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (_tmp6_) {
#line 345 "dconf-window.c"
			GtkStyleContext* _tmp7_ = NULL;
#line 84 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp7_ = _data1_->context;
#line 84 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_style_context_remove_class (_tmp7_, "small-keys-list-rows");
#line 351 "dconf-window.c"
		}
	}
}


static void ___lambda85__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 79 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	__lambda85_ (self);
#line 360 "dconf-window.c"
}


static void __lambda86_ (Block1Data* _data1_) {
	DConfWindow* self;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 86 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self = _data1_->self;
#line 87 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->settings;
#line 87 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = g_settings_get_boolean (_tmp0_, "small-bookmarks-rows");
#line 87 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp1_) {
#line 376 "dconf-window.c"
		GtkStyleContext* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 89 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp2_ = _data1_->context;
#line 89 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp3_ = gtk_style_context_has_class (_tmp2_, "small-bookmarks-rows");
#line 89 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (!_tmp3_) {
#line 385 "dconf-window.c"
			GtkStyleContext* _tmp4_ = NULL;
#line 89 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp4_ = _data1_->context;
#line 89 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_style_context_add_class (_tmp4_, "small-bookmarks-rows");
#line 391 "dconf-window.c"
		}
	} else {
		GtkStyleContext* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 91 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp5_ = _data1_->context;
#line 91 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp6_ = gtk_style_context_has_class (_tmp5_, "small-bookmarks-rows");
#line 91 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (_tmp6_) {
#line 402 "dconf-window.c"
			GtkStyleContext* _tmp7_ = NULL;
#line 91 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp7_ = _data1_->context;
#line 91 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_style_context_remove_class (_tmp7_, "small-bookmarks-rows");
#line 408 "dconf-window.c"
		}
	}
}


static void ___lambda86__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 86 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	__lambda86_ (self);
#line 417 "dconf-window.c"
}


DConfWindow* dconf_window_construct (GType object_type) {
	DConfWindow * self = NULL;
	Block1Data* _data1_;
	GSettings* _tmp0_ = NULL;
	RegistryView* _tmp1_ = NULL;
	gulong _tmp2_ = 0UL;
	GSettings* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GSettings* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GSettings* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GtkStyleContext* _tmp9_ = NULL;
	GtkStyleContext* _tmp10_ = NULL;
	GSettings* _tmp11_ = NULL;
	gulong _tmp12_ = 0UL;
	GSettings* _tmp13_ = NULL;
	gulong _tmp14_ = 0UL;
	GSettings* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	GSettings* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	RegistryView* _tmp21_ = NULL;
	GSettings* _tmp22_ = NULL;
	RegistryView* _tmp23_ = NULL;
	RegistryView* _tmp24_ = NULL;
	GSettings* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	GSettings* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
#line 60 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 60 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data1_->_ref_count_ = 1;
#line 60 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self = (DConfWindow*) g_object_new (object_type, NULL);
#line 60 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data1_->self = g_object_ref (self);
#line 62 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_action_map_add_action_entries ((GActionMap*) self, DCONF_WINDOW_action_entries, G_N_ELEMENTS (DCONF_WINDOW_action_entries), self);
#line 64 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->settings;
#line 64 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = self->priv->registry_view;
#line 64 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = g_signal_connect_object (_tmp0_, "changed::behaviour", (GCallback) _registry_view_invalidate_popovers_g_settings_changed, _tmp1_, 0);
#line 64 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->behaviour_changed_handler = _tmp2_;
#line 66 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = self->priv->settings;
#line 66 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp4_ = g_settings_get_int (_tmp3_, "window-width");
#line 66 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp5_ = self->priv->settings;
#line 66 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp6_ = g_settings_get_int (_tmp5_, "window-height");
#line 66 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_window_set_default_size ((GtkWindow*) self, _tmp4_, _tmp6_);
#line 67 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp7_ = self->priv->settings;
#line 67 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp8_ = g_settings_get_boolean (_tmp7_, "window-is-maximized");
#line 67 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp8_) {
#line 68 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		gtk_window_maximize ((GtkWindow*) self);
#line 488 "dconf-window.c"
	}
#line 70 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 70 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 70 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data1_->context = _tmp10_;
#line 79 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp11_ = self->priv->settings;
#line 79 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp12_ = g_signal_connect_data (_tmp11_, "changed::small-keys-list-rows", (GCallback) ___lambda85__g_settings_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 79 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->small_keys_list_rows_handler = _tmp12_;
#line 86 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp13_ = self->priv->settings;
#line 86 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp14_ = g_signal_connect_data (_tmp13_, "changed::small-bookmarks-rows", (GCallback) ___lambda86__g_settings_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 86 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->small_bookmarks_rows_handler = _tmp14_;
#line 95 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp15_ = self->priv->settings;
#line 95 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp16_ = g_settings_get_boolean (_tmp15_, "small-keys-list-rows");
#line 95 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp16_) {
#line 514 "dconf-window.c"
		GtkStyleContext* _tmp17_ = NULL;
#line 96 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp17_ = _data1_->context;
#line 96 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		gtk_style_context_add_class (_tmp17_, "small-keys-list-rows");
#line 520 "dconf-window.c"
	}
#line 97 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp18_ = self->priv->settings;
#line 97 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp19_ = g_settings_get_boolean (_tmp18_, "small-bookmarks-rows");
#line 97 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp19_) {
#line 528 "dconf-window.c"
		GtkStyleContext* _tmp20_ = NULL;
#line 98 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp20_ = _data1_->context;
#line 98 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		gtk_style_context_add_class (_tmp20_, "small-bookmarks-rows");
#line 534 "dconf-window.c"
	}
#line 100 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp21_ = self->priv->registry_view;
#line 100 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_object_bind_property_with_closures ((GObject*) _tmp21_, "current-path", (GObject*) self, "current-path", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 101 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp22_ = self->priv->settings;
#line 101 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp23_ = self->priv->registry_view;
#line 101 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_settings_bind (_tmp22_, "behaviour", (GObject*) _tmp23_, "behaviour", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_NO_SENSITIVITY);
#line 102 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp24_ = self->priv->registry_view;
#line 102 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp25_ = self->priv->settings;
#line 102 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp26_ = g_settings_get_string (_tmp25_, "saved-view");
#line 102 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp27_ = _tmp26_;
#line 102 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp28_ = self->priv->settings;
#line 102 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp29_ = g_settings_get_boolean (_tmp28_, "restore-view");
#line 102 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_init (_tmp24_, _tmp27_, _tmp29_);
#line 102 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (_tmp27_);
#line 60 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	block1_data_unref (_data1_);
#line 60 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data1_ = NULL;
#line 60 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return self;
#line 568 "dconf-window.c"
}


DConfWindow* dconf_window_new (void) {
#line 60 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return dconf_window_construct (TYPE_DCONF_WINDOW);
#line 575 "dconf-window.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1328 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1329 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1329 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1329 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1330 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1330 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 608 "dconf-window.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1331 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1331 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1331 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 617 "dconf-window.c"
	}
#line 1333 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1333 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 623 "dconf-window.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1334 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1334 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1334 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 632 "dconf-window.c"
	}
#line 1336 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1336 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 638 "dconf-window.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1336 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1336 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1336 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 647 "dconf-window.c"
	} else {
#line 1336 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 651 "dconf-window.c"
	}
#line 1336 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1337 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1337 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 659 "dconf-window.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1337 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1337 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1337 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 668 "dconf-window.c"
	} else {
#line 1337 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 672 "dconf-window.c"
	}
#line 1337 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1338 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1338 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1338 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1339 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1339 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1339 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1339 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1339 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1339 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 694 "dconf-window.c"
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1017 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1018 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 1018 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 1018 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
#line 1018 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1020 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 1020 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 719 "dconf-window.c"
		gchar* _tmp4_ = NULL;
#line 1021 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 1021 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 1021 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 727 "dconf-window.c"
	} else {
#line 1023 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		result = -1;
#line 1023 "/mnt/test/jhbuild/slash/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 733 "dconf-window.c"
	}
}


gchar* dconf_window_stripped_path (const gchar* path) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
#line 105 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 107 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = path;
#line 107 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = strlen (_tmp0_);
#line 107 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = _tmp1_;
#line 107 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp2_ <= 1) {
#line 757 "dconf-window.c"
		gchar* _tmp3_ = NULL;
#line 108 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp3_ = g_strdup ("/");
#line 108 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		result = _tmp3_;
#line 108 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		return result;
#line 765 "dconf-window.c"
	}
#line 109 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp4_ = path;
#line 109 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp5_ = path;
#line 109 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp6_ = string_last_index_of_char (_tmp5_, (gunichar) '/', 0);
#line 109 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp7_ = string_slice (_tmp4_, (glong) 0, (glong) (_tmp6_ + 1));
#line 109 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	result = _tmp7_;
#line 109 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return result;
#line 779 "dconf-window.c"
}


GtkWidget* _dconf_window_get_parent (GtkWidget* widget) {
	GtkWidget* result = NULL;
	GtkWidget* parent = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkContainer* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
#line 112 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (widget != NULL, NULL);
#line 114 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = widget;
#line 114 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = (GtkContainer*) gtk_widget_get_parent (_tmp0_);
#line 114 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = _g_object_ref0 ((GtkWidget*) _tmp1_);
#line 114 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	parent = _tmp2_;
#line 115 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (parent == NULL) {
#line 116 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_assert_not_reached ();
#line 804 "dconf-window.c"
	}
#line 117 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (parent, gtk_widget_get_type (), GtkWidget));
#line 117 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	result = _tmp3_;
#line 117 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (parent);
#line 117 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return result;
#line 814 "dconf-window.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 125 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 125 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return _data2_;
#line 823 "dconf-window.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 125 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 832 "dconf-window.c"
		DConfWindow* self;
#line 125 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		self = _data2_->self;
#line 125 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_object_unref0 (_data2_->checkbutton);
#line 125 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_object_unref0 (self);
#line 125 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_slice_free (Block2Data, _data2_);
#line 842 "dconf-window.c"
	}
}


static void __lambda87_ (Block2Data* _data2_) {
	DConfWindow* self;
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 142 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self = _data2_->self;
#line 142 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = _data2_->checkbutton;
#line 142 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
#line 142 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = _tmp1_;
#line 142 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (!_tmp2_) {
#line 862 "dconf-window.c"
		GSettings* _tmp3_ = NULL;
#line 142 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp3_ = self->priv->settings;
#line 142 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_settings_set_boolean (_tmp3_, "show-warning", FALSE);
#line 868 "dconf-window.c"
	}
}


static void ___lambda87__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 142 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	__lambda87_ (self);
#line 876 "dconf-window.c"
}


static void dconf_window_on_show (DConfWindow* self) {
	Block2Data* _data2_;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkMessageDialog* dialog = NULL;
	const gchar* _tmp2_ = NULL;
	GtkMessageDialog* _tmp3_ = NULL;
	GtkMessageDialog* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkMessageDialog* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkBox* box = NULL;
	GtkMessageDialog* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	GtkBox* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkCheckButton* _tmp12_ = NULL;
	GtkCheckButton* _tmp13_ = NULL;
	GtkCheckButton* _tmp14_ = NULL;
	GtkCheckButton* _tmp15_ = NULL;
	GtkBox* _tmp16_ = NULL;
	GtkCheckButton* _tmp17_ = NULL;
	gulong dialog_response_handler = 0UL;
	GtkMessageDialog* _tmp18_ = NULL;
	gulong _tmp19_ = 0UL;
	GtkMessageDialog* _tmp20_ = NULL;
	GtkMessageDialog* _tmp21_ = NULL;
	gulong _tmp22_ = 0UL;
	GtkMessageDialog* _tmp23_ = NULL;
#line 125 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 125 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 125 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data2_->_ref_count_ = 1;
#line 125 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data2_->self = g_object_ref (self);
#line 127 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->settings;
#line 127 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = g_settings_get_boolean (_tmp0_, "show-warning");
#line 127 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (!_tmp1_) {
#line 128 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		block2_data_unref (_data2_);
#line 128 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_data2_ = NULL;
#line 128 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		return;
#line 929 "dconf-window.c"
	}
#line 130 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = _ ("Thanks for using Dconf Editor for editing your settings!");
#line 130 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_NONE, _tmp2_);
#line 130 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_object_ref_sink (_tmp3_);
#line 130 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dialog = _tmp3_;
#line 131 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp4_ = dialog;
#line 131 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp5_ = _ ("Don’t forget that some options may break applications, so be careful.");
#line 131 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_message_dialog_format_secondary_text (_tmp4_, "%s", _tmp5_);
#line 132 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp6_ = dialog;
#line 132 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp7_ = _ ("I’ll be careful.");
#line 132 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_dialog_add_buttons ((GtkDialog*) _tmp6_, _tmp7_, GTK_RESPONSE_ACCEPT, NULL);
#line 135 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp8_ = dialog;
#line 135 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp9_ = gtk_message_dialog_get_message_area (_tmp8_);
#line 135 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_box_get_type (), GtkBox));
#line 135 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	box = _tmp10_;
#line 136 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp11_ = _ ("Show this dialog next time.");
#line 136 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp12_ = (GtkCheckButton*) gtk_check_button_new_with_label (_tmp11_);
#line 136 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_object_ref_sink (_tmp12_);
#line 136 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data2_->checkbutton = _tmp12_;
#line 137 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp13_ = _data2_->checkbutton;
#line 137 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp13_, TRUE);
#line 138 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp14_ = _data2_->checkbutton;
#line 138 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp14_, TRUE);
#line 139 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp15_ = _data2_->checkbutton;
#line 139 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_set_margin_top ((GtkWidget*) _tmp15_, 5);
#line 140 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp16_ = box;
#line 140 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp17_ = _data2_->checkbutton;
#line 140 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_container_add ((GtkContainer*) _tmp16_, (GtkWidget*) _tmp17_);
#line 142 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp18_ = dialog;
#line 142 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp19_ = g_signal_connect_data ((GtkDialog*) _tmp18_, "response", (GCallback) ___lambda87__gtk_dialog_response, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 142 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dialog_response_handler = _tmp19_;
#line 143 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp20_ = dialog;
#line 143 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_dialog_run ((GtkDialog*) _tmp20_);
#line 144 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp21_ = dialog;
#line 144 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp22_ = dialog_response_handler;
#line 144 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_signal_handler_disconnect ((GObject*) _tmp21_, _tmp22_);
#line 145 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp23_ = dialog;
#line 145 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp23_);
#line 125 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (box);
#line 125 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (dialog);
#line 125 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	block2_data_unref (_data2_);
#line 125 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_data2_ = NULL;
#line 1013 "dconf-window.c"
}


static void _dconf_window_on_show_gtk_widget_show (GtkWidget* _sender, gpointer self) {
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_on_show ((DConfWindow*) self);
#line 1020 "dconf-window.c"
}


static gboolean dconf_window_on_window_state_event (DConfWindow* self, GtkWidget* widget, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState* _tmp4_ = NULL;
	GdkWindowState _tmp5_ = 0;
#line 149 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 149 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 149 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 151 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = event;
#line 151 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 151 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 1042 "dconf-window.c"
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
#line 152 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp2_ = event;
#line 152 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 152 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		self->priv->window_is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1051 "dconf-window.c"
	}
#line 154 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp4_ = event;
#line 154 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp5_ = _tmp4_->changed_mask;
#line 154 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if ((_tmp5_ & GDK_WINDOW_STATE_TILED) != 0) {
#line 1059 "dconf-window.c"
		GdkEventWindowState* _tmp6_ = NULL;
		GdkWindowState _tmp7_ = 0;
#line 155 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp6_ = event;
#line 155 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp7_ = _tmp6_->new_window_state;
#line 155 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		self->priv->window_is_tiled = (_tmp7_ & GDK_WINDOW_STATE_TILED) != 0;
#line 1068 "dconf-window.c"
	}
#line 157 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	result = FALSE;
#line 157 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return result;
#line 1074 "dconf-window.c"
}


static gboolean _dconf_window_on_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = dconf_window_on_window_state_event ((DConfWindow*) self, _sender, event);
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return result;
#line 1083 "dconf-window.c"
}


static void dconf_window_on_size_allocate (DConfWindow* self, GtkAllocation* allocation) {
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkAllocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
#line 161 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 161 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (allocation != NULL);
#line 165 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 165 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 165 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	context = _tmp1_;
#line 166 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = *allocation;
#line 166 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = _tmp2_.width;
#line 166 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp3_ > 1200) {
#line 1113 "dconf-window.c"
		GtkStyleContext* _tmp4_ = NULL;
		GtkStyleContext* _tmp5_ = NULL;
		GtkStyleContext* _tmp6_ = NULL;
#line 168 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp4_ = context;
#line 168 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		gtk_style_context_add_class (_tmp4_, "xxl");
#line 169 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp5_ = context;
#line 169 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		gtk_style_context_add_class (_tmp5_, "xl");
#line 170 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp6_ = context;
#line 170 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		gtk_style_context_add_class (_tmp6_, "large-window");
#line 1129 "dconf-window.c"
	} else {
		GtkAllocation _tmp7_ = {0};
		gint _tmp8_ = 0;
#line 172 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp7_ = *allocation;
#line 172 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp8_ = _tmp7_.width;
#line 172 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (_tmp8_ > 1100) {
#line 1139 "dconf-window.c"
			GtkStyleContext* _tmp9_ = NULL;
			GtkStyleContext* _tmp10_ = NULL;
			GtkStyleContext* _tmp11_ = NULL;
#line 174 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp9_ = context;
#line 174 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_style_context_remove_class (_tmp9_, "xxl");
#line 175 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp10_ = context;
#line 175 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_style_context_add_class (_tmp10_, "xl");
#line 176 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp11_ = context;
#line 176 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_style_context_add_class (_tmp11_, "large-window");
#line 1155 "dconf-window.c"
		} else {
			GtkAllocation _tmp12_ = {0};
			gint _tmp13_ = 0;
#line 178 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp12_ = *allocation;
#line 178 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp13_ = _tmp12_.width;
#line 178 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			if (_tmp13_ > 1000) {
#line 1165 "dconf-window.c"
				GtkStyleContext* _tmp14_ = NULL;
				GtkStyleContext* _tmp15_ = NULL;
				GtkStyleContext* _tmp16_ = NULL;
#line 180 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp14_ = context;
#line 180 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				gtk_style_context_remove_class (_tmp14_, "xxl");
#line 181 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp15_ = context;
#line 181 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				gtk_style_context_remove_class (_tmp15_, "xl");
#line 182 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp16_ = context;
#line 182 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				gtk_style_context_add_class (_tmp16_, "large-window");
#line 1181 "dconf-window.c"
			} else {
				GtkStyleContext* _tmp17_ = NULL;
				GtkStyleContext* _tmp18_ = NULL;
				GtkStyleContext* _tmp19_ = NULL;
#line 186 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp17_ = context;
#line 186 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				gtk_style_context_remove_class (_tmp17_, "xxl");
#line 187 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp18_ = context;
#line 187 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				gtk_style_context_remove_class (_tmp18_, "xl");
#line 188 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp19_ = context;
#line 188 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				gtk_style_context_remove_class (_tmp19_, "large-window");
#line 1198 "dconf-window.c"
			}
		}
	}
#line 193 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp21_ = self->priv->window_is_maximized;
#line 193 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp21_) {
#line 193 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp20_ = TRUE;
#line 1208 "dconf-window.c"
	} else {
		gboolean _tmp22_ = FALSE;
#line 193 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp22_ = self->priv->window_is_tiled;
#line 193 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp20_ = _tmp22_;
#line 1215 "dconf-window.c"
	}
#line 193 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp20_) {
#line 194 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_object_unref0 (context);
#line 194 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		return;
#line 1223 "dconf-window.c"
	}
#line 195 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_window_get_size ((GtkWindow*) self, &_tmp23_, &_tmp24_);
#line 195 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->window_width = _tmp23_;
#line 195 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->window_height = _tmp24_;
#line 161 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (context);
#line 1233 "dconf-window.c"
}


static void _dconf_window_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_on_size_allocate ((DConfWindow*) self, allocation);
#line 1240 "dconf-window.c"
}


static void dconf_window_on_destroy (DConfWindow* self) {
	GtkApplication* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gulong _tmp2_ = 0UL;
	GSettings* _tmp3_ = NULL;
	gulong _tmp4_ = 0UL;
	GSettings* _tmp5_ = NULL;
	gulong _tmp6_ = 0UL;
	GSettings* _tmp7_ = NULL;
	GSettings* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GSettings* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GSettings* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	GSettings* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	GSettings* _tmp16_ = NULL;
#line 199 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 201 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
#line 201 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	configuration_editor_clean_copy_notification (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_CONFIGURATION_EDITOR, ConfigurationEditor));
#line 203 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = self->priv->settings;
#line 203 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = self->priv->behaviour_changed_handler;
#line 203 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_signal_handler_disconnect ((GObject*) _tmp1_, _tmp2_);
#line 205 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = self->priv->settings;
#line 205 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp4_ = self->priv->small_keys_list_rows_handler;
#line 205 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_signal_handler_disconnect ((GObject*) _tmp3_, _tmp4_);
#line 206 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp5_ = self->priv->settings;
#line 206 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp6_ = self->priv->small_bookmarks_rows_handler;
#line 206 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_signal_handler_disconnect ((GObject*) _tmp5_, _tmp6_);
#line 208 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp7_ = self->priv->settings;
#line 208 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_settings_delay (_tmp7_);
#line 209 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp8_ = self->priv->settings;
#line 209 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp9_ = self->priv->_current_path;
#line 209 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_settings_set_string (_tmp8_, "saved-view", _tmp9_);
#line 210 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp10_ = self->priv->settings;
#line 210 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp11_ = self->priv->window_width;
#line 210 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_settings_set_int (_tmp10_, "window-width", _tmp11_);
#line 211 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp12_ = self->priv->settings;
#line 211 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp13_ = self->priv->window_height;
#line 211 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_settings_set_int (_tmp12_, "window-height", _tmp13_);
#line 212 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp14_ = self->priv->settings;
#line 212 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp15_ = self->priv->window_is_maximized;
#line 212 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_settings_set_boolean (_tmp14_, "window-is-maximized", _tmp15_);
#line 213 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp16_ = self->priv->settings;
#line 213 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_settings_apply (_tmp16_);
#line 215 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	GTK_WIDGET_CLASS (dconf_window_parent_class)->destroy ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow));
#line 1320 "dconf-window.c"
}


static void _dconf_window_on_destroy_gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_on_destroy ((DConfWindow*) self);
#line 1327 "dconf-window.c"
}


static void dconf_window_request_path (DConfWindow* self, const gchar* full_name) {
	RegistryView* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	RegistryView* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	PathBar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 223 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 223 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (full_name != NULL);
#line 225 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->registry_view;
#line 225 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = FALSE;
#line 225 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_set_search_mode (_tmp0_, &_tmp1_);
#line 226 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = self->priv->registry_view;
#line 226 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = full_name;
#line 226 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp4_ = self->priv->pathbar;
#line 226 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp5_ = full_name;
#line 226 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp6_ = path_bar_get_selected_child (_tmp4_, _tmp5_);
#line 226 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp7_ = _tmp6_;
#line 226 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_path_requested (_tmp2_, _tmp3_, _tmp7_);
#line 226 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (_tmp7_);
#line 1366 "dconf-window.c"
}


static void _dconf_window_request_path_path_element_request_path (PathElement* _sender, const gchar* path, gpointer self) {
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_request_path ((DConfWindow*) self, path);
#line 1373 "dconf-window.c"
}


void dconf_window_update_path_elements (DConfWindow* self) {
	Bookmarks* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	PathBar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 229 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 231 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->bookmarks_button;
#line 231 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = self->priv->_current_path;
#line 231 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	bookmarks_set_path (_tmp0_, _tmp1_);
#line 232 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = self->priv->pathbar;
#line 232 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = self->priv->_current_path;
#line 232 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	path_bar_set_path (_tmp2_, _tmp3_);
#line 1396 "dconf-window.c"
}


void dconf_window_update_hamburger_menu (DConfWindow* self) {
	GMenu* section = NULL;
	GMenu* menu = NULL;
	GMenu* _tmp0_ = NULL;
	GMenu* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	RegistryView* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	GMenu* _tmp28_ = NULL;
	GtkMenuButton* _tmp29_ = NULL;
	GMenu* _tmp30_ = NULL;
#line 235 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 239 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = g_menu_new ();
#line 239 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	menu = _tmp0_;
#line 240 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = menu;
#line 240 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = _ ("Copy current path");
#line 240 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = self->priv->_current_path;
#line 240 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp4_ = g_strescape (_tmp3_, "");
#line 240 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp5_ = _tmp4_;
#line 240 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp6_ = g_strconcat ("app.copy(\"", _tmp5_, NULL);
#line 240 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp7_ = _tmp6_;
#line 240 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp8_ = g_strconcat (_tmp7_, "\")", NULL);
#line 240 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp9_ = _tmp8_;
#line 240 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_menu_append (_tmp1_, _tmp2_, _tmp9_);
#line 240 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (_tmp9_);
#line 240 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (_tmp7_);
#line 240 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (_tmp5_);
#line 242 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp10_ = self->priv->_current_path;
#line 242 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp11_ = g_str_has_suffix (_tmp10_, "/");
#line 242 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp11_) {
#line 1458 "dconf-window.c"
		GMenu* _tmp12_ = NULL;
		GMenu* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GMenu* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		GMenu* _tmp17_ = NULL;
		GMenu* _tmp18_ = NULL;
		GMenu* _tmp19_ = NULL;
#line 244 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp12_ = g_menu_new ();
#line 244 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_object_unref0 (section);
#line 244 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		section = _tmp12_;
#line 245 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp13_ = section;
#line 245 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp14_ = _ ("Reset visible keys");
#line 245 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_menu_append (_tmp13_, _tmp14_, "win.reset-visible");
#line 246 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp15_ = section;
#line 246 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp16_ = _ ("Reset recursively");
#line 246 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_menu_append (_tmp15_, _tmp16_, "win.reset-recursive");
#line 247 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp17_ = section;
#line 247 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_menu_freeze (_tmp17_);
#line 248 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp18_ = menu;
#line 248 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp19_ = section;
#line 248 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_menu_append_section (_tmp18_, NULL, (GMenuModel*) _tmp19_);
#line 1495 "dconf-window.c"
	}
#line 251 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp20_ = self->priv->registry_view;
#line 251 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp21_ = registry_view_get_current_delay_mode (_tmp20_);
#line 251 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (!_tmp21_) {
#line 1503 "dconf-window.c"
		GMenu* _tmp22_ = NULL;
		GMenu* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		GMenu* _tmp25_ = NULL;
		GMenu* _tmp26_ = NULL;
		GMenu* _tmp27_ = NULL;
#line 253 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp22_ = g_menu_new ();
#line 253 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_object_unref0 (section);
#line 253 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		section = _tmp22_;
#line 254 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp23_ = section;
#line 254 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp24_ = _ ("Enter delay mode");
#line 254 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_menu_append (_tmp23_, _tmp24_, "win.enter-delay-mode");
#line 255 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp25_ = section;
#line 255 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_menu_freeze (_tmp25_);
#line 256 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp26_ = menu;
#line 256 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp27_ = section;
#line 256 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_menu_append_section (_tmp26_, NULL, (GMenuModel*) _tmp27_);
#line 1532 "dconf-window.c"
	}
#line 259 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp28_ = menu;
#line 259 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_menu_freeze (_tmp28_);
#line 260 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp29_ = self->priv->info_button;
#line 260 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp30_ = menu;
#line 260 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_menu_button_set_menu_model (_tmp29_, G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, g_menu_model_get_type (), GMenuModel));
#line 235 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (menu);
#line 235 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (section);
#line 1548 "dconf-window.c"
}


static void dconf_window_reset (DConfWindow* self) {
	RegistryView* _tmp0_ = NULL;
#line 267 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 269 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->registry_view;
#line 269 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_reset (_tmp0_, FALSE);
#line 1560 "dconf-window.c"
}


static void dconf_window_reset_recursively (DConfWindow* self) {
	RegistryView* _tmp0_ = NULL;
#line 272 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 274 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->registry_view;
#line 274 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_reset (_tmp0_, TRUE);
#line 1572 "dconf-window.c"
}


static void dconf_window_enter_delay_mode (DConfWindow* self) {
	RegistryView* _tmp0_ = NULL;
#line 277 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 279 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->registry_view;
#line 279 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_enter_delay_mode (_tmp0_);
#line 1584 "dconf-window.c"
}


static gboolean dconf_window_on_key_press_event (DConfWindow* self, GtkWidget* widget, GdkEventKey* event) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	GdkEventKey* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	const gchar* _tmp3_ = NULL;
	gchar* name = NULL;
	gchar* _tmp4_ = NULL;
	GdkEventKey* _tmp5_ = NULL;
	GdkModifierType _tmp6_ = 0;
	GdkEventKey* _tmp56_ = NULL;
	GdkModifierType _tmp57_ = 0;
	const gchar* _tmp87_ = NULL;
	gboolean _tmp113_ = FALSE;
	Bookmarks* _tmp114_ = NULL;
	gboolean _tmp115_ = FALSE;
	gboolean _tmp116_ = FALSE;
	RegistryView* _tmp120_ = NULL;
	GdkEventKey* _tmp121_ = NULL;
	gboolean _tmp122_ = FALSE;
#line 287 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 287 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 287 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 289 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = event;
#line 289 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = _tmp1_->keyval;
#line 289 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp3_ = gdk_keyval_name (_tmp2_);
#line 289 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = _tmp3_;
#line 289 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp0_ == NULL) {
#line 289 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp0_ = "";
#line 1626 "dconf-window.c"
	}
#line 289 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp4_ = g_strdup ((const gchar*) _tmp0_);
#line 289 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	name = _tmp4_;
#line 291 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp5_ = event;
#line 291 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp6_ = _tmp5_->state;
#line 291 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if ((_tmp6_ & GDK_CONTROL_MASK) != 0) {
#line 1638 "dconf-window.c"
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GQuark _tmp10_ = 0U;
#line 293 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		static GQuark _tmp9_label0 = 0;
#line 293 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		static GQuark _tmp9_label1 = 0;
#line 293 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		static GQuark _tmp9_label2 = 0;
#line 293 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		static GQuark _tmp9_label3 = 0;
#line 293 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		static GQuark _tmp9_label4 = 0;
#line 293 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		static GQuark _tmp9_label5 = 0;
#line 293 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		static GQuark _tmp9_label6 = 0;
#line 293 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp7_ = name;
#line 293 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp8_ = _tmp7_;
#line 293 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp10_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
#line 293 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (_tmp10_ == ((0 != _tmp9_label0) ? _tmp9_label0 : (_tmp9_label0 = g_quark_from_static_string ("b")))) {
#line 293 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			switch (0) {
#line 1666 "dconf-window.c"
				default:
				{
					GtkMenuButton* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					gboolean _tmp13_ = FALSE;
					RegistryView* _tmp15_ = NULL;
					Bookmarks* _tmp16_ = NULL;
#line 296 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp11_ = self->priv->info_button;
#line 296 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp12_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp11_);
#line 296 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp13_ = _tmp12_;
#line 296 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					if (_tmp13_) {
#line 1682 "dconf-window.c"
						GtkMenuButton* _tmp14_ = NULL;
#line 297 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp14_ = self->priv->info_button;
#line 297 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp14_, FALSE);
#line 1688 "dconf-window.c"
					}
#line 298 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp15_ = self->priv->registry_view;
#line 298 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					registry_view_discard_row_popover (_tmp15_);
#line 299 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp16_ = self->priv->bookmarks_button;
#line 299 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					gtk_button_clicked ((GtkButton*) _tmp16_);
#line 300 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					result = TRUE;
#line 300 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (name);
#line 300 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					return result;
#line 1704 "dconf-window.c"
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label1) ? _tmp9_label1 : (_tmp9_label1 = g_quark_from_static_string ("d")))) {
#line 293 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			switch (0) {
#line 1710 "dconf-window.c"
				default:
				{
					GtkMenuButton* _tmp17_ = NULL;
					gboolean _tmp18_ = FALSE;
					gboolean _tmp19_ = FALSE;
					RegistryView* _tmp21_ = NULL;
					Bookmarks* _tmp22_ = NULL;
#line 302 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp17_ = self->priv->info_button;
#line 302 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp18_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp17_);
#line 302 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp19_ = _tmp18_;
#line 302 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					if (_tmp19_) {
#line 1726 "dconf-window.c"
						GtkMenuButton* _tmp20_ = NULL;
#line 303 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp20_ = self->priv->info_button;
#line 303 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp20_, FALSE);
#line 1732 "dconf-window.c"
					}
#line 304 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp21_ = self->priv->registry_view;
#line 304 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					registry_view_discard_row_popover (_tmp21_);
#line 305 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp22_ = self->priv->bookmarks_button;
#line 305 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					bookmarks_set_bookmarked (_tmp22_, TRUE);
#line 306 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					result = TRUE;
#line 306 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (name);
#line 306 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					return result;
#line 1748 "dconf-window.c"
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label2) ? _tmp9_label2 : (_tmp9_label2 = g_quark_from_static_string ("D")))) {
#line 293 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			switch (0) {
#line 1754 "dconf-window.c"
				default:
				{
					GtkMenuButton* _tmp23_ = NULL;
					gboolean _tmp24_ = FALSE;
					gboolean _tmp25_ = FALSE;
					RegistryView* _tmp27_ = NULL;
					Bookmarks* _tmp28_ = NULL;
#line 308 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp23_ = self->priv->info_button;
#line 308 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp24_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp23_);
#line 308 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp25_ = _tmp24_;
#line 308 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					if (_tmp25_) {
#line 1770 "dconf-window.c"
						GtkMenuButton* _tmp26_ = NULL;
#line 309 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp26_ = self->priv->info_button;
#line 309 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp26_, FALSE);
#line 1776 "dconf-window.c"
					}
#line 310 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp27_ = self->priv->registry_view;
#line 310 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					registry_view_discard_row_popover (_tmp27_);
#line 311 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp28_ = self->priv->bookmarks_button;
#line 311 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					bookmarks_set_bookmarked (_tmp28_, FALSE);
#line 312 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					result = TRUE;
#line 312 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (name);
#line 312 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					return result;
#line 1792 "dconf-window.c"
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label3) ? _tmp9_label3 : (_tmp9_label3 = g_quark_from_static_string ("f")))) {
#line 293 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			switch (0) {
#line 1798 "dconf-window.c"
				default:
				{
					Bookmarks* _tmp29_ = NULL;
					gboolean _tmp30_ = FALSE;
					gboolean _tmp31_ = FALSE;
					GtkMenuButton* _tmp33_ = NULL;
					gboolean _tmp34_ = FALSE;
					gboolean _tmp35_ = FALSE;
					RegistryView* _tmp37_ = NULL;
					RegistryView* _tmp38_ = NULL;
#line 314 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp29_ = self->priv->bookmarks_button;
#line 314 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp30_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp29_);
#line 314 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp31_ = _tmp30_;
#line 314 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					if (_tmp31_) {
#line 1817 "dconf-window.c"
						Bookmarks* _tmp32_ = NULL;
#line 315 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp32_ = self->priv->bookmarks_button;
#line 315 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp32_, FALSE);
#line 1823 "dconf-window.c"
					}
#line 316 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp33_ = self->priv->info_button;
#line 316 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp34_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp33_);
#line 316 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp35_ = _tmp34_;
#line 316 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					if (_tmp35_) {
#line 1833 "dconf-window.c"
						GtkMenuButton* _tmp36_ = NULL;
#line 317 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp36_ = self->priv->info_button;
#line 317 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp36_, FALSE);
#line 1839 "dconf-window.c"
					}
#line 318 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp37_ = self->priv->registry_view;
#line 318 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					registry_view_discard_row_popover (_tmp37_);
#line 319 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp38_ = self->priv->registry_view;
#line 319 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					registry_view_set_search_mode (_tmp38_, NULL);
#line 320 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					result = TRUE;
#line 320 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (name);
#line 320 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					return result;
#line 1855 "dconf-window.c"
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label4) ? _tmp9_label4 : (_tmp9_label4 = g_quark_from_static_string ("c")))) {
#line 293 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			switch (0) {
#line 1861 "dconf-window.c"
				default:
				{
					RegistryView* _tmp39_ = NULL;
					gchar* selected_row_text = NULL;
					RegistryView* _tmp40_ = NULL;
					gchar* _tmp41_ = NULL;
					ConfigurationEditor* application = NULL;
					GtkApplication* _tmp42_ = NULL;
					ConfigurationEditor* _tmp43_ = NULL;
					const gchar* _tmp44_ = NULL;
					const gchar* _tmp45_ = NULL;
					ConfigurationEditor* _tmp48_ = NULL;
#line 322 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp39_ = self->priv->registry_view;
#line 322 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					registry_view_discard_row_popover (_tmp39_);
#line 323 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp40_ = self->priv->registry_view;
#line 323 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp41_ = registry_view_get_copy_text (_tmp40_);
#line 323 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					selected_row_text = _tmp41_;
#line 324 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp42_ = gtk_window_get_application ((GtkWindow*) self);
#line 324 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp43_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, TYPE_CONFIGURATION_EDITOR, ConfigurationEditor));
#line 324 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					application = _tmp43_;
#line 325 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp45_ = selected_row_text;
#line 325 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					if (_tmp45_ == NULL) {
#line 1894 "dconf-window.c"
						const gchar* _tmp46_ = NULL;
#line 325 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp46_ = self->priv->_current_path;
#line 325 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp44_ = _tmp46_;
#line 1900 "dconf-window.c"
					} else {
						const gchar* _tmp47_ = NULL;
#line 325 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp47_ = selected_row_text;
#line 325 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp44_ = (const gchar*) _tmp47_;
#line 1907 "dconf-window.c"
					}
#line 325 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp48_ = application;
#line 325 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					configuration_editor_copy (_tmp48_, _tmp44_);
#line 326 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					result = TRUE;
#line 326 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_object_unref0 (application);
#line 326 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (selected_row_text);
#line 326 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (name);
#line 326 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					return result;
#line 1923 "dconf-window.c"
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label5) ? _tmp9_label5 : (_tmp9_label5 = g_quark_from_static_string ("C")))) {
#line 293 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			switch (0) {
#line 1929 "dconf-window.c"
				default:
				{
					RegistryView* _tmp49_ = NULL;
					GtkApplication* _tmp50_ = NULL;
					const gchar* _tmp51_ = NULL;
#line 328 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp49_ = self->priv->registry_view;
#line 328 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					registry_view_discard_row_popover (_tmp49_);
#line 329 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp50_ = gtk_window_get_application ((GtkWindow*) self);
#line 329 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp51_ = self->priv->_current_path;
#line 329 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					configuration_editor_copy (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, TYPE_CONFIGURATION_EDITOR, ConfigurationEditor), _tmp51_);
#line 330 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					result = TRUE;
#line 330 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (name);
#line 330 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					return result;
#line 1951 "dconf-window.c"
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label6) ? _tmp9_label6 : (_tmp9_label6 = g_quark_from_static_string ("F1")))) {
#line 293 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			switch (0) {
#line 1957 "dconf-window.c"
				default:
				{
					RegistryView* _tmp52_ = NULL;
					GdkEventKey* _tmp53_ = NULL;
					GdkModifierType _tmp54_ = 0;
					GtkApplication* _tmp55_ = NULL;
#line 332 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp52_ = self->priv->registry_view;
#line 332 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					registry_view_discard_row_popover (_tmp52_);
#line 333 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp53_ = event;
#line 333 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp54_ = _tmp53_->state;
#line 333 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					if ((_tmp54_ & GDK_SHIFT_MASK) == 0) {
#line 334 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						result = FALSE;
#line 334 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_g_free0 (name);
#line 334 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						return result;
#line 1980 "dconf-window.c"
					}
#line 335 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp55_ = gtk_window_get_application ((GtkWindow*) self);
#line 335 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					configuration_editor_about_cb (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, TYPE_CONFIGURATION_EDITOR, ConfigurationEditor));
#line 336 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					result = TRUE;
#line 336 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (name);
#line 336 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					return result;
#line 1992 "dconf-window.c"
				}
			}
		} else {
#line 293 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			switch (0) {
#line 1998 "dconf-window.c"
				default:
				{
#line 338 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					break;
#line 2003 "dconf-window.c"
				}
			}
		}
	}
#line 342 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp56_ = event;
#line 342 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp57_ = _tmp56_->state;
#line 342 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if ((_tmp57_ & GDK_MOD1_MASK) != 0) {
#line 2014 "dconf-window.c"
		const gchar* _tmp58_ = NULL;
#line 344 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp58_ = name;
#line 344 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (g_strcmp0 (_tmp58_, "Up") == 0) {
#line 2020 "dconf-window.c"
			const gchar* _tmp59_ = NULL;
			GdkEventKey* _tmp60_ = NULL;
			GdkModifierType _tmp61_ = 0;
#line 346 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp59_ = self->priv->_current_path;
#line 346 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			if (g_strcmp0 (_tmp59_, "/") == 0) {
#line 347 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				result = TRUE;
#line 347 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_g_free0 (name);
#line 347 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				return result;
#line 2034 "dconf-window.c"
			}
#line 348 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp60_ = event;
#line 348 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp61_ = _tmp60_->state;
#line 348 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			if ((_tmp61_ & GDK_SHIFT_MASK) != 0) {
#line 349 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				dconf_window_request_path (self, "/");
#line 2044 "dconf-window.c"
			} else {
				const gchar* _tmp62_ = NULL;
				gboolean _tmp63_ = FALSE;
#line 350 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp62_ = self->priv->_current_path;
#line 350 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp63_ = g_str_has_suffix (_tmp62_, "/");
#line 350 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				if (_tmp63_) {
#line 2054 "dconf-window.c"
					const gchar* _tmp64_ = NULL;
					const gchar* _tmp65_ = NULL;
					const gchar* _tmp66_ = NULL;
					gint _tmp67_ = 0;
					gint _tmp68_ = 0;
					gchar* _tmp69_ = NULL;
					gchar* _tmp70_ = NULL;
					gint _tmp71_ = 0;
					gchar* _tmp72_ = NULL;
					gchar* _tmp73_ = NULL;
#line 351 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp64_ = self->priv->_current_path;
#line 351 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp65_ = self->priv->_current_path;
#line 351 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp66_ = self->priv->_current_path;
#line 351 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp67_ = strlen (_tmp66_);
#line 351 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp68_ = _tmp67_;
#line 351 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp69_ = string_slice (_tmp65_, (glong) 0, (glong) (_tmp68_ - 1));
#line 351 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp70_ = _tmp69_;
#line 351 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp71_ = string_last_index_of_char (_tmp70_, (gunichar) '/', 0);
#line 351 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp72_ = string_slice (_tmp64_, (glong) 0, (glong) (_tmp71_ + 1));
#line 351 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp73_ = _tmp72_;
#line 351 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					dconf_window_request_path (self, _tmp73_);
#line 351 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (_tmp73_);
#line 351 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (_tmp70_);
#line 2091 "dconf-window.c"
				} else {
					const gchar* _tmp74_ = NULL;
					const gchar* _tmp75_ = NULL;
					gint _tmp76_ = 0;
					gchar* _tmp77_ = NULL;
					gchar* _tmp78_ = NULL;
#line 353 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp74_ = self->priv->_current_path;
#line 353 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp75_ = self->priv->_current_path;
#line 353 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp76_ = string_last_index_of_char (_tmp75_, (gunichar) '/', 0);
#line 353 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp77_ = string_slice (_tmp74_, (glong) 0, (glong) (_tmp76_ + 1));
#line 353 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp78_ = _tmp77_;
#line 353 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					dconf_window_request_path (self, _tmp78_);
#line 353 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (_tmp78_);
#line 2112 "dconf-window.c"
				}
			}
#line 354 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			result = TRUE;
#line 354 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_g_free0 (name);
#line 354 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			return result;
#line 2121 "dconf-window.c"
		} else {
			const gchar* _tmp79_ = NULL;
#line 356 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp79_ = name;
#line 356 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			if (g_strcmp0 (_tmp79_, "Down") == 0) {
#line 2128 "dconf-window.c"
				GdkEventKey* _tmp80_ = NULL;
				GdkModifierType _tmp81_ = 0;
#line 358 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp80_ = event;
#line 358 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp81_ = _tmp80_->state;
#line 358 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				if ((_tmp81_ & GDK_SHIFT_MASK) != 0) {
#line 2137 "dconf-window.c"
					PathBar* _tmp82_ = NULL;
					gboolean _tmp83_ = FALSE;
#line 359 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp82_ = self->priv->pathbar;
#line 359 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp83_ = path_bar_open_child (_tmp82_, NULL);
#line 359 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					result = _tmp83_;
#line 359 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (name);
#line 359 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					return result;
#line 2150 "dconf-window.c"
				} else {
					PathBar* _tmp84_ = NULL;
					const gchar* _tmp85_ = NULL;
					gboolean _tmp86_ = FALSE;
#line 361 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp84_ = self->priv->pathbar;
#line 361 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp85_ = self->priv->_current_path;
#line 361 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp86_ = path_bar_open_child (_tmp84_, _tmp85_);
#line 361 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					result = _tmp86_;
#line 361 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_g_free0 (name);
#line 361 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					return result;
#line 2167 "dconf-window.c"
				}
			}
		}
	}
#line 366 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp87_ = name;
#line 366 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (g_strcmp0 (_tmp87_, "F10") == 0) {
#line 2176 "dconf-window.c"
		RegistryView* _tmp88_ = NULL;
		Bookmarks* _tmp89_ = NULL;
		gboolean _tmp90_ = FALSE;
		gboolean _tmp91_ = FALSE;
#line 368 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp88_ = self->priv->registry_view;
#line 368 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		registry_view_discard_row_popover (_tmp88_);
#line 369 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp89_ = self->priv->bookmarks_button;
#line 369 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp90_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp89_);
#line 369 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp91_ = _tmp90_;
#line 369 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (_tmp91_) {
#line 2193 "dconf-window.c"
			Bookmarks* _tmp92_ = NULL;
#line 370 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp92_ = self->priv->bookmarks_button;
#line 370 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp92_, FALSE);
#line 2199 "dconf-window.c"
		}
#line 371 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		result = FALSE;
#line 371 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_free0 (name);
#line 371 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		return result;
#line 2207 "dconf-window.c"
	} else {
		const gchar* _tmp93_ = NULL;
#line 373 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp93_ = name;
#line 373 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		if (g_strcmp0 (_tmp93_, "Menu") == 0) {
#line 2214 "dconf-window.c"
			RegistryView* _tmp94_ = NULL;
			gboolean _tmp95_ = FALSE;
#line 375 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp94_ = self->priv->registry_view;
#line 375 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_tmp95_ = registry_view_show_row_popover (_tmp94_);
#line 375 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			if (_tmp95_) {
#line 2223 "dconf-window.c"
				Bookmarks* _tmp96_ = NULL;
				gboolean _tmp97_ = FALSE;
				gboolean _tmp98_ = FALSE;
				GtkMenuButton* _tmp100_ = NULL;
				gboolean _tmp101_ = FALSE;
				gboolean _tmp102_ = FALSE;
#line 377 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp96_ = self->priv->bookmarks_button;
#line 377 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp97_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp96_);
#line 377 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp98_ = _tmp97_;
#line 377 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				if (_tmp98_) {
#line 2238 "dconf-window.c"
					Bookmarks* _tmp99_ = NULL;
#line 378 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp99_ = self->priv->bookmarks_button;
#line 378 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp99_, FALSE);
#line 2244 "dconf-window.c"
				}
#line 379 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp100_ = self->priv->info_button;
#line 379 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp101_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp100_);
#line 379 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp102_ = _tmp101_;
#line 379 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				if (_tmp102_) {
#line 2254 "dconf-window.c"
					GtkMenuButton* _tmp103_ = NULL;
#line 380 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp103_ = self->priv->info_button;
#line 380 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp103_, FALSE);
#line 2260 "dconf-window.c"
				}
			} else {
				GtkMenuButton* _tmp104_ = NULL;
				gboolean _tmp105_ = FALSE;
				gboolean _tmp106_ = FALSE;
#line 382 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp104_ = self->priv->info_button;
#line 382 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp105_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp104_);
#line 382 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				_tmp106_ = _tmp105_;
#line 382 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
				if (_tmp106_ == FALSE) {
#line 2274 "dconf-window.c"
					Bookmarks* _tmp107_ = NULL;
					gboolean _tmp108_ = FALSE;
					gboolean _tmp109_ = FALSE;
					GtkMenuButton* _tmp111_ = NULL;
#line 384 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp107_ = self->priv->bookmarks_button;
#line 384 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp108_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp107_);
#line 384 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp109_ = _tmp108_;
#line 384 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					if (_tmp109_) {
#line 2287 "dconf-window.c"
						Bookmarks* _tmp110_ = NULL;
#line 385 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						_tmp110_ = self->priv->bookmarks_button;
#line 385 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp110_, FALSE);
#line 2293 "dconf-window.c"
					}
#line 386 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp111_ = self->priv->info_button;
#line 386 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp111_, TRUE);
#line 2299 "dconf-window.c"
				} else {
					GtkMenuButton* _tmp112_ = NULL;
#line 389 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					_tmp112_ = self->priv->info_button;
#line 389 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp112_, FALSE);
#line 2306 "dconf-window.c"
				}
			}
#line 390 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			result = TRUE;
#line 390 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			_g_free0 (name);
#line 390 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
			return result;
#line 2315 "dconf-window.c"
		}
	}
#line 393 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp114_ = self->priv->bookmarks_button;
#line 393 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp115_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp114_);
#line 393 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp116_ = _tmp115_;
#line 393 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp116_) {
#line 393 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp113_ = TRUE;
#line 2328 "dconf-window.c"
	} else {
		GtkMenuButton* _tmp117_ = NULL;
		gboolean _tmp118_ = FALSE;
		gboolean _tmp119_ = FALSE;
#line 393 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp117_ = self->priv->info_button;
#line 393 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp118_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp117_);
#line 393 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp119_ = _tmp118_;
#line 393 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_tmp113_ = _tmp119_;
#line 2341 "dconf-window.c"
	}
#line 393 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (_tmp113_) {
#line 394 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		result = FALSE;
#line 394 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		_g_free0 (name);
#line 394 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		return result;
#line 2351 "dconf-window.c"
	}
#line 396 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp120_ = self->priv->registry_view;
#line 396 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp121_ = event;
#line 396 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp122_ = registry_view_handle_search_event (_tmp120_, _tmp121_);
#line 396 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	result = _tmp122_;
#line 396 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (name);
#line 396 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return result;
#line 2365 "dconf-window.c"
}


static gboolean _dconf_window_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = dconf_window_on_key_press_event ((DConfWindow*) self, _sender, event);
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return result;
#line 2374 "dconf-window.c"
}


static void dconf_window_on_menu_button_clicked (DConfWindow* self) {
	RegistryView* _tmp0_ = NULL;
	RegistryView* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 400 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 402 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->registry_view;
#line 402 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_discard_row_popover (_tmp0_);
#line 403 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = self->priv->registry_view;
#line 403 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = FALSE;
#line 403 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	registry_view_set_search_mode (_tmp1_, &_tmp2_);
#line 2394 "dconf-window.c"
}


static void _dconf_window_on_menu_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_on_menu_button_clicked ((DConfWindow*) self);
#line 2401 "dconf-window.c"
}


void dconf_window_show_notification (DConfWindow* self, const gchar* notification) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkRevealer* _tmp2_ = NULL;
#line 410 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 410 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (notification != NULL);
#line 412 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->notification_label;
#line 412 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = notification;
#line 412 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_label_set_text (_tmp0_, _tmp1_);
#line 413 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp2_ = self->priv->notification_revealer;
#line 413 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_revealer_set_reveal_child (_tmp2_, TRUE);
#line 2423 "dconf-window.c"
}


static void dconf_window_hide_notification (DConfWindow* self) {
	GtkRevealer* _tmp0_ = NULL;
#line 417 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 419 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->notification_revealer;
#line 419 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
#line 2435 "dconf-window.c"
}


static void _dconf_window_hide_notification_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_hide_notification ((DConfWindow*) self);
#line 2442 "dconf-window.c"
}


static const gchar* dconf_window_get_current_path (DConfWindow* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 38 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 38 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = self->priv->_current_path;
#line 38 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	result = _tmp0_;
#line 38 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	return result;
#line 2457 "dconf-window.c"
}


void dconf_window_set_current_path (DConfWindow* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 38 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_return_if_fail (self != NULL);
#line 38 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = value;
#line 38 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 38 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (self->priv->_current_path);
#line 38 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->_current_path = _tmp1_;
#line 38 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_object_notify ((GObject *) self, "current-path");
#line 2476 "dconf-window.c"
}


static void dconf_window_class_init (DConfWindowClass * klass) {
	gint DConfWindow_private_offset;
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	dconf_window_parent_class = g_type_class_peek_parent (klass);
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_type_class_add_private (klass, sizeof (DConfWindowPrivate));
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_dconf_window_get_property;
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_dconf_window_set_property;
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	G_OBJECT_CLASS (klass)->finalize = dconf_window_finalize;
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DCONF_WINDOW_CURRENT_PATH, g_param_spec_string ("current-path", "current-path", "current-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	DConfWindow_private_offset = g_type_class_get_instance_private_offset (klass);
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/ca/desrt/dconf-editor/ui/dconf-editor.ui");
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bookmarks_button", FALSE, DConfWindow_private_offset + G_STRUCT_OFFSET (DConfWindowPrivate, bookmarks_button));
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "info_button", FALSE, DConfWindow_private_offset + G_STRUCT_OFFSET (DConfWindowPrivate, info_button));
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pathbar", FALSE, DConfWindow_private_offset + G_STRUCT_OFFSET (DConfWindowPrivate, pathbar));
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "registry_view", FALSE, DConfWindow_private_offset + G_STRUCT_OFFSET (DConfWindowPrivate, registry_view));
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "notification_revealer", FALSE, DConfWindow_private_offset + G_STRUCT_OFFSET (DConfWindowPrivate, notification_revealer));
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "notification_label", FALSE, DConfWindow_private_offset + G_STRUCT_OFFSET (DConfWindowPrivate, notification_label));
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_show", G_CALLBACK(_dconf_window_on_show_gtk_widget_show));
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_window_state_event", G_CALLBACK(_dconf_window_on_window_state_event_gtk_widget_window_state_event));
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_size_allocate", G_CALLBACK(_dconf_window_on_size_allocate_gtk_widget_size_allocate));
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_destroy", G_CALLBACK(_dconf_window_on_destroy_gtk_widget_destroy));
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "request_path", G_CALLBACK(_dconf_window_request_path_path_element_request_path));
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_key_press_event", G_CALLBACK(_dconf_window_on_key_press_event_gtk_widget_key_press_event));
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_menu_button_clicked", G_CALLBACK(_dconf_window_on_menu_button_clicked_gtk_button_clicked));
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "hide_notification", G_CALLBACK(_dconf_window_hide_notification_gtk_button_clicked));
#line 2526 "dconf-window.c"
}


static void dconf_window_instance_init (DConfWindow * self) {
	gchar* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv = DCONF_WINDOW_GET_PRIVATE (self);
#line 38 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp0_ = g_strdup ("/");
#line 38 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->_current_path = _tmp0_;
#line 40 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->window_width = 0;
#line 41 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->window_height = 0;
#line 42 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->window_is_maximized = FALSE;
#line 43 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->window_is_tiled = FALSE;
#line 45 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_tmp1_ = g_settings_new ("ca.desrt.dconf-editor.Settings");
#line 45 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->settings = _tmp1_;
#line 55 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->behaviour_changed_handler = (gulong) 0;
#line 57 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->small_keys_list_rows_handler = (gulong) 0;
#line 58 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self->priv->small_bookmarks_rows_handler = (gulong) 0;
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_type_ensure (TYPE_BOOKMARKS);
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_type_ensure (TYPE_REGISTRY_VIEW);
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	g_type_ensure (TYPE_PATH_BAR);
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 2565 "dconf-window.c"
}


static void dconf_window_finalize (GObject* obj) {
	DConfWindow * self;
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DCONF_WINDOW, DConfWindow);
#line 38 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_free0 (self->priv->_current_path);
#line 45 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (self->priv->settings);
#line 47 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (self->priv->bookmarks_button);
#line 48 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (self->priv->info_button);
#line 49 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (self->priv->pathbar);
#line 50 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (self->priv->registry_view);
#line 52 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (self->priv->notification_revealer);
#line 53 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	_g_object_unref0 (self->priv->notification_label);
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	G_OBJECT_CLASS (dconf_window_parent_class)->finalize (obj);
#line 2591 "dconf-window.c"
}


GType dconf_window_get_type (void) {
	static volatile gsize dconf_window_type_id__volatile = 0;
	if (g_once_init_enter (&dconf_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DConfWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dconf_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DConfWindow), 0, (GInstanceInitFunc) dconf_window_instance_init, NULL };
		GType dconf_window_type_id;
		dconf_window_type_id = g_type_register_static (gtk_application_window_get_type (), "DConfWindow", &g_define_type_info, 0);
		g_once_init_leave (&dconf_window_type_id__volatile, dconf_window_type_id);
	}
	return dconf_window_type_id__volatile;
}


static void _vala_dconf_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DConfWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DCONF_WINDOW, DConfWindow);
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	switch (property_id) {
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		case DCONF_WINDOW_CURRENT_PATH:
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_value_set_string (value, dconf_window_get_current_path (self));
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		break;
#line 2618 "dconf-window.c"
		default:
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		break;
#line 2624 "dconf-window.c"
	}
}


static void _vala_dconf_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DConfWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DCONF_WINDOW, DConfWindow);
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	switch (property_id) {
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		case DCONF_WINDOW_CURRENT_PATH:
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		dconf_window_set_current_path (self, g_value_get_string (value));
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		break;
#line 2640 "dconf-window.c"
		default:
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		break;
#line 2646 "dconf-window.c"
	}
}


static void path_element_base_init (PathElementIface * iface) {
#line 423 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	static gboolean initialized = FALSE;
#line 423 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
	if (!initialized) {
#line 423 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		initialized = TRUE;
#line 423 "/mnt/test/jhbuild/jhbuild/dconf-editor/editor/dconf-window.vala"
		g_signal_new ("request_path", TYPE_PATH_ELEMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 2660 "dconf-window.c"
	}
}


GType path_element_get_type (void) {
	static volatile gsize path_element_type_id__volatile = 0;
	if (g_once_init_enter (&path_element_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PathElementIface), (GBaseInitFunc) path_element_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType path_element_type_id;
		path_element_type_id = g_type_register_static (G_TYPE_INTERFACE, "PathElement", &g_define_type_info, 0);
		g_once_init_leave (&path_element_type_id__volatile, path_element_type_id);
	}
	return path_element_type_id__volatile;
}



