/*!

\if MANPAGES
\page dcmquant Convert DICOM color images to palette color
\else
\page dcmquant dcmquant: Convert DICOM color images to palette color
\endif

\section dcmquant_synopsis SYNOPSIS

\verbatim
dcmquant [options] dcmfile-in dcmfile-out
\endverbatim

\section dcmquant_description DESCRIPTION

The \b dcmquant utility reads a DICOM color image, computes a palette color
look-up table of the desired size for this image (based on the median cut
algorithm published by Paul Heckbert) and converts the color image into a
DICOM palette color image.

\section dcmquant_parameters PARAMETERS

\verbatim
dcmfile-in   DICOM input filename to be converted ("-" for stdin)

dcmfile-out  DICOM output filename to be written ("-" for stdout)
\endverbatim

\section dcmquant_options OPTIONS

\subsection dcmquant_general_options general options
\verbatim
  -h   --help
         print this help text and exit

       --version
         print version information and exit

       --arguments
         print expanded command line arguments

  -q   --quiet
         quiet mode, print no warnings and errors

  -v   --verbose
         verbose mode, print processing details

  -d   --debug
         debug mode, print debug information

  -ll  --log-level  [l]evel: string constant
         (fatal, error, warn, info, debug, trace)
         use level l for the logger

  -lc  --log-config  [f]ilename: string
         use config file f for the logger
\endverbatim

\subsection dcmquant_input_options input options
\verbatim
input file format:

  +f   --read-file
         read file format or data set (default)

  +fo  --read-file-only
         read file format only

  -f   --read-dataset
         read data set without file meta information

input transfer syntax:

  -t=  --read-xfer-auto
         use TS recognition (default)

  -td  --read-xfer-detect
         ignore TS specified in the file meta header

  -te  --read-xfer-little
         read with explicit VR little endian TS

  -tb  --read-xfer-big
         read with explicit VR big endian TS

  -ti  --read-xfer-implicit
         read with implicit VR little endian TS
\endverbatim

\subsection dcmquant_processing_options image processing and encoding options
\verbatim
frame selection:

  +F   --frame  [n]umber: integer
         select specified frame

  +Fa  --all-frames
         select all frames (default)

compatibility:

  +Mp  --accept-palettes
         accept incorrect palette attribute tags
         (0028,111x) and (0028,121x)

median cut dimension selection:

  +Dr  --mc-dimension-rgb
         max dimension from RGB range (default)

  +Dl  --mc-dimension-lum
         max dimension from luminance

median cut representative color selection:

  +Cb  --mc-color-avgbox
         average colors in box (default)

  +Cp  --mc-color-avgpixel
         average pixels in box

  +Cc  --mc-color-center
         select center of box

color palette value representation:

  +pw  --write-ow
         write Palette LUT as OW (default)

  +pu  --write-us
         write Palette LUT as US (retired)

color palette creation:

  +pe  --lut-entries-word
         write Palette LUT with 16-bit entries

  +pf  --floyd-steinberg
         use Floyd-Steinberg error diffusion

  +pc  --colors  number of colors: 2..65536 (default 256)
         number of colors to quantize to

SOP Class UID:

  +cd  --class-default
         keep SOP Class UID (default)

  +cs  --class-sc
         convert to Secondary Capture Image
         (implies --uid-always)

SOP Instance UID:

  +ua  --uid-always
         always assign new UID (default)

  +un  --uid-never
         never assign new UID
\endverbatim

\subsection dcmquant_output_options output options
\verbatim
output file format:

  +F   --write-file
         write file format (default)

  -F   --write-dataset
         write data set without file meta information

output transfer syntax:

  +t=  --write-xfer-same
         write with same TS as input (default)

  +te  --write-xfer-little
         write with explicit VR little endian TS

  +tb  --write-xfer-big
         write with explicit VR big endian TS

  +ti  --write-xfer-implicit
         write with implicit VR little endian TS

post-1993 value representations:

  +u   --enable-new-vr
         enable support for new VRs (UN/UT) (default)

  -u   --disable-new-vr
         disable support for new VRs, convert to OB

group length encoding:

  +g=  --group-length-recalc
         recalculate group lengths if present (default)

  +g   --group-length-create
         always write with group length elements

  -g   --group-length-remove
         always write without group length elements

length encoding in sequences and items:

  +e   --length-explicit
         write with explicit lengths (default)

  -e   --length-undefined
         write with undefined lengths

data set trailing padding (not with --write-dataset):

  -p=  --padding-retain
         do not change padding
         (default if not --write-dataset)

  -p   --padding-off
         no padding (implicit if --write-dataset)

  +p   --padding-create  [f]ile-pad [i]tem-pad: integer
         align file on multiple of f bytes and items on
         multiple of i bytes
\endverbatim

\section dcmquant_logging LOGGING

The level of logging output of the various command line tools and underlying
libraries can be specified by the user.  By default, only errors and warnings
are written to the standard error stream.  Using option \e --verbose also
informational messages like processing details are reported.  Option
\e --debug can be used to get more details on the internal activity, e.g. for
debugging purposes.  Other logging levels can be selected using option
\e --log-level.  In \e --quiet mode only fatal errors are reported.  In such
very severe error events, the application will usually terminate.  For more
details on the different logging levels, see documentation of module "oflog".

In case the logging output should be written to file (optionally with logfile
rotation), to syslog (Unix) or the event log (Windows) option \e --log-config
can be used.  This configuration file also allows for directing only certain
messages to a particular output stream and for filtering certain messages
based on the module or application where they are generated.  An example
configuration file is provided in <em>\<etcdir\>/logger.cfg</em>.

\section dcmquant_command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behavior conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator unless they appear between two
quotation marks) prior to any further evaluation.  Please note that a command
file cannot contain another command file.  This simple but effective approach
allows one to summarize common combinations of options/parameters and avoids
longish and confusing command lines (an example is provided in file
<em>\<datadir\>/dumppat.txt</em>).

\section dcmquant_environment ENVIRONMENT

The \b dcmquant utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<datadir\>/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behavior should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  On Windows systems,
a semicolon (";") is used as a separator.  The data dictionary code will
attempt to load each file specified in the \e DCMDICTPATH environment variable.
It is an error if no data dictionary can be loaded.

\section dcmquant_copyright COPYRIGHT

Copyright (C) 2001-2023 by OFFIS e.V., Escherweg 2, 26121 Oldenburg, Germany.

*/
