/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.util.artifact;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.onseven.dbvis.util.ab;
import com.onseven.dbvis.util.artifact.Artifact;
import com.onseven.dbvis.util.artifact.ArtifactFile;
import com.onseven.dbvis.util.artifact.DriverStatus;
import com.onseven.dbvis.util.artifact.FolderArtifact;
import com.onseven.dbvis.util.artifact.LocalArtifact;
import com.onseven.dbvis.util.artifact.MavenArtifact;
import com.onseven.dbvis.util.artifact.b;
import com.onseven.dbvis.util.artifact.remote.RemoteArtifact;
import com.onseven.dbvis.util.dc;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ArtifactBundle {
    @JacksonXmlElementWrapper(localName="Artifacts")
    @JacksonXmlProperty(localName="Artifact")
    private List<Artifact> artifacts = new ArrayList<Artifact>();
    @JsonIgnore
    private String id;
    @JsonIgnore
    private DriverStatus driverStatus = new DriverStatus();
    @JsonIgnore
    private File bundleRoot;

    public ArtifactBundle() {
    }

    public ArtifactBundle(ArtifactBundle artifactBundle) {
        this.bundleRoot = artifactBundle.bundleRoot;
        this.id = artifactBundle.id;
        if (artifactBundle.driverStatus != null) {
            this.driverStatus = new DriverStatus(artifactBundle.driverStatus);
        }
        for (Artifact artifact : artifactBundle.artifacts) {
            this.addArtifact(artifact.createCopy());
        }
    }

    public boolean hasSameMavenArtifactIds(ArtifactBundle artifactBundle) {
        List list = this.mavenArtifacts().collect(Collectors.toList());
        if (list.size() != this.artifacts.size()) {
            return false;
        }
        List list2 = artifactBundle.mavenArtifacts().collect(Collectors.toList());
        if (list.size() != list2.size()) {
            return false;
        }
        int n2 = 0;
        for (MavenArtifact mavenArtifact : list) {
            MavenArtifact mavenArtifact2 = (MavenArtifact)list2.get(n2);
            if (mavenArtifact.getGroupId().equals(mavenArtifact2.getGroupId()) && mavenArtifact.getArtifactId().equals(mavenArtifact2.getArtifactId())) continue;
            return false;
        }
        return true;
    }

    public Stream<MavenArtifact> mavenArtifacts() {
        return this.getArtifacts().stream().filter(artifact -> artifact instanceof MavenArtifact).map(artifact -> (MavenArtifact)artifact);
    }

    public Stream<LocalArtifact> localArtifacts() {
        return this.getArtifacts().stream().filter(artifact -> artifact instanceof LocalArtifact).map(artifact -> (LocalArtifact)artifact);
    }

    public Stream<b> localClassFolderArtifacts() {
        return this.getArtifacts().stream().filter(artifact -> artifact instanceof b).map(artifact -> (b)artifact);
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    @JsonIgnore
    public List<Artifact> getActiveArtifacts() {
        if (this.artifacts == null) {
            return null;
        }
        return this.artifacts.stream().filter(artifact -> artifact.isActive()).collect(Collectors.toList());
    }

    @JsonSetter(nulls=Nulls.AS_EMPTY)
    public void setArtifacts(List<Artifact> list) {
        this.artifacts = list;
    }

    public void addArtifact(Artifact artifact) {
        LocalArtifact localArtifact;
        if (artifact instanceof LocalArtifact && (localArtifact = (LocalArtifact)artifact).getLocalFile() != null && !ab.k(localArtifact.getLocalFile().getRootPath()) && this.getBundleRoot() != null) {
            localArtifact.getLocalFile().setRootPath(this.getBundleRoot().getAbsolutePath());
        }
        this.artifacts.add(artifact);
    }

    public File getBundleRoot() {
        return this.bundleRoot;
    }

    public void setBundleRoot(File file) {
        this.bundleRoot = file;
    }

    public void initBundleRoot(File file, File file2) {
        this.bundleRoot = file;
        for (Artifact artifact : this.artifacts) {
            if (!(artifact instanceof LocalArtifact)) continue;
            LocalArtifact localArtifact = (LocalArtifact)artifact;
            ArtifactFile artifactFile = localArtifact.getLocalFile();
            File file3 = new File(file2, artifactFile.getFilePath());
            if (dc.b(file3)) {
                artifactFile.setRootPath(file2.getAbsolutePath());
                continue;
            }
            File file4 = new File(file, artifactFile.getFilePath());
            if (!dc.b(file4)) continue;
            artifactFile.setRootPath(file.getAbsolutePath());
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public DriverStatus getDriverStatus() {
        return this.driverStatus;
    }

    public void setDriverStatus(DriverStatus driverStatus) {
        this.driverStatus = driverStatus;
    }

    public boolean areSame(ArtifactBundle artifactBundle) {
        if (this == artifactBundle) {
            return true;
        }
        if (this.artifacts == artifactBundle.artifacts) {
            return true;
        }
        if (this.artifacts != null) {
            return this.artifacts.equals(artifactBundle.artifacts);
        }
        return false;
    }

    public boolean hasMavenArtifacts() {
        if (this.artifacts != null) {
            return this.artifacts.stream().anyMatch(MavenArtifact.class::isInstance);
        }
        return false;
    }

    public boolean hasDownloadableArtifacts() {
        return this.hasMavenArtifacts() || this.hasRemoteArtifacts();
    }

    public boolean hasRemoteArtifacts() {
        if (this.artifacts != null) {
            return this.artifacts.stream().anyMatch(RemoteArtifact.class::isInstance);
        }
        return false;
    }

    public boolean dump(PrintStream printStream) {
        printStream.println("Artifacts");
        for (Artifact artifact : this.artifacts) {
            artifact.dump(printStream);
            printStream.println();
        }
        printStream.println("DriverStatus");
        this.getDriverStatus().dump(printStream);
        return true;
    }

    public List<FolderArtifact> getFolderArtifacts() {
        ArrayList<FolderArtifact> arrayList = new ArrayList<FolderArtifact>();
        for (Artifact artifact : this.artifacts) {
            if (!(artifact instanceof FolderArtifact)) continue;
            arrayList.add((FolderArtifact)artifact);
        }
        return arrayList;
    }

    public void cleanDataThatShouldBeFetchedFromTemplate() {
        this.mavenArtifacts().forEach(mavenArtifact -> mavenArtifact.setVersionRange(null));
    }
}

