/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.runtime.installer.helper.content.HttpAuthenticator;
import com.install4j.runtime.installer.helper.content.JavaHttpConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jetbrains.annotations.NotNull;

public class UrlConnectionWrapper
implements JavaHttpConnection {
    private final URLConnection connection;
    private Proxy proxy;
    private Runnable sslResetter;

    public UrlConnectionWrapper(URL url, @NotNull Proxy proxy, boolean acceptAllCertificates) throws IOException {
        Authenticator.setDefault(HttpAuthenticator.getInstance());
        if (acceptAllCertificates && Objects.equals(url.getProtocol(), "https")) {
            this.sslResetter = this.acceptAllCertificates();
        }
        this.proxy = proxy;
        this.connection = url.openConnection(proxy);
    }

    @Override
    @NotNull
    public Proxy getProxy() {
        return this.proxy;
    }

    @Override
    public void connect() throws IOException {
        this.connection.connect();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.connection.getInputStream();
    }

    @Override
    public InputStream getErrorStream() throws IOException {
        if (this.connection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.connection;
            httpURLConnection.getResponseCode();
            InputStream errorStream = httpURLConnection.getErrorStream();
            if (errorStream != null) {
                return errorStream;
            }
        }
        return this.connection.getInputStream();
    }

    @Override
    public int getResponseCode() throws IOException {
        try {
            if (this.connection instanceof HttpURLConnection) {
                int n = ((HttpURLConnection)this.connection).getResponseCode();
                return n;
            }
            int n = 200;
            return n;
        }
        finally {
            if (this.sslResetter != null) {
                this.sslResetter.run();
            }
        }
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.connection.getHeaderFields();
    }

    @Override
    public String getHeaderField(String key) {
        return this.connection.getHeaderField(key);
    }

    @Override
    public String getContentEncoding() {
        return this.connection.getContentEncoding();
    }

    @Override
    public URL getURL() {
        return this.connection.getURL();
    }

    @Override
    public String getContentType() {
        return this.connection.getContentType();
    }

    @Override
    public void setRequestMethod(String requestMethod) throws ProtocolException {
        if (this.connection instanceof HttpURLConnection) {
            ((HttpURLConnection)this.connection).setRequestMethod(requestMethod);
        }
    }

    @Override
    public void setRequestProperty(String key, String value) {
        this.connection.setRequestProperty(key, value);
    }

    @Override
    public void addRequestProperty(String key, String value) {
        this.connection.addRequestProperty(key, value);
    }

    @Override
    public void setDoOutput(long contentLength) {
        this.connection.setRequestProperty("Content-Length", String.valueOf(contentLength));
        this.connection.setDoOutput(true);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.connection.getOutputStream();
    }

    @Override
    public void setUseCaches(boolean useCaches) {
        this.connection.setUseCaches(useCaches);
    }

    @Override
    public void setConnectTimeout(int timeout) {
        this.connection.setConnectTimeout(timeout);
    }

    @Override
    public void setReadTimeout(int timeout) {
        this.connection.setReadTimeout(timeout);
    }

    @Override
    public long getContentLengthLong() {
        return this.connection.getContentLengthLong();
    }

    @Override
    public void close() {
    }

    private Runnable acceptAllCertificates() {
        SSLSocketFactory defaultSSLSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        HostnameVerifier defaultHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        HttpsURLConnection.setDefaultHostnameVerifier((s, sslSession) -> true);
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return () -> {
            HttpsURLConnection.setDefaultSSLSocketFactory(defaultSSLSocketFactory);
            HttpsURLConnection.setDefaultHostnameVerifier(defaultHostnameVerifier);
        };
    }
}

