/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.eclipse;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.windows.WindowsGraphicsUtilsPort;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.TopLevelMenuContainer;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class EclipseMenuItemUI
extends MenuItemUI {
    protected JMenuItem menuItem = null;
    protected Color selectionBackground;
    protected Color selectionForeground;
    protected Color disabledForeground;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    private String \u010e;
    protected int defaultTextIconGap;
    protected Font acceleratorFont;
    protected MouseInputListener mouseInputListener;
    protected MenuDragMouseListener menuDragMouseListener;
    protected MenuKeyListener menuKeyListener;
    private PropertyChangeListener \u010a;
    protected Icon arrowIcon = null;
    protected Icon checkIcon = null;
    protected boolean oldBorderPainted;
    InputMap \u0110;
    private static final boolean \u0103 = false;
    protected Color shadowColor;
    protected int defaultAccelEndGap;
    protected int defaultShadowWidth;
    private Color \u0101;
    private Color \u0104;
    static final String \u0109 = "maxTextWidth";
    static final String \u010c = "maxAccWidth";
    protected ThemePainter _painter;
    static Rectangle \u010b = new Rectangle(0, 0, 0, 0);
    static Rectangle \u0106 = new Rectangle();
    static Rectangle \u0102 = new Rectangle();
    static Rectangle \u010f = new Rectangle();
    static Rectangle \u0105 = new Rectangle();
    static Rectangle \u0108 = new Rectangle();
    static Rectangle \u010d = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    static Rectangle \u0107 = new Rectangle();

    public static ComponentUI createUI(JComponent jComponent) {
        return new EclipseMenuItemUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.menuItem = (JMenuItem)jComponent;
        this.installDefaults();
        this.installComponents(this.menuItem);
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        String string = this.getPropertyPrefix();
        this.acceleratorFont = UIDefaultsLookup.getFont("MenuItem.acceleratorFont");
        if (this.acceleratorFont == null) {
            this.acceleratorFont = UIManager.getFont("MenuItem.font");
        }
        this.menuItem.setOpaque(true);
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(UIDefaultsLookup.getInsets(string + ".margin"));
        }
        this.defaultTextIconGap = UIDefaultsLookup.getInt("MenuItem.textIconGap");
        this.defaultAccelEndGap = UIDefaultsLookup.getInt("MenuItem.accelEndGap");
        this.defaultShadowWidth = UIDefaultsLookup.getInt("MenuItem.shadowWidth");
        this.\u0101 = UIDefaultsLookup.getColor("MenuItem.selectionBorderColor");
        this.\u0104 = UIDefaultsLookup.getColor("MenuItem.background");
        this.shadowColor = UIDefaultsLookup.getColor("MenuItem.shadowColor");
        LookAndFeel.installBorder(this.menuItem, string + ".border");
        this.oldBorderPainted = this.menuItem.isBorderPainted();
        Object object = UIDefaultsLookup.get(string + ".borderPainted");
        this.menuItem.setBorderPainted(object instanceof Boolean ? (Boolean)object : false);
        LookAndFeel.installColorsAndFont(this.menuItem, string + ".background", string + ".foreground", string + ".font");
        if (this.selectionBackground == null || this.selectionBackground instanceof UIResource) {
            this.selectionBackground = UIDefaultsLookup.getColor(string + ".selectionBackground");
        }
        if (this.selectionForeground == null || this.selectionForeground instanceof UIResource) {
            this.selectionForeground = UIDefaultsLookup.getColor(string + ".selectionForeground");
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = UIDefaultsLookup.getColor(string + ".disabledForeground");
        }
        if (this.acceleratorForeground == null || this.acceleratorForeground instanceof UIResource) {
            this.acceleratorForeground = UIDefaultsLookup.getColor(string + ".acceleratorForeground");
        }
        if (this.acceleratorSelectionForeground == null || this.acceleratorSelectionForeground instanceof UIResource) {
            this.acceleratorSelectionForeground = UIDefaultsLookup.getColor(string + ".acceleratorSelectionForeground");
        }
        this.\u010e = UIDefaultsLookup.getString("MenuItem.acceleratorDelimiter");
        if (this.\u010e == null) {
            this.\u010e = "+";
        }
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIDefaultsLookup.getIcon(string + ".arrowIcon");
        }
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            this.checkIcon = UIDefaultsLookup.getIcon(string + ".checkIcon");
        }
    }

    protected void installComponents(JMenuItem jMenuItem) {
        BasicHTML.updateRenderer(jMenuItem, jMenuItem.getText());
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        if (this.mouseInputListener != null) {
            this.menuItem.addMouseListener(this.mouseInputListener);
            this.menuItem.addMouseMotionListener(this.mouseInputListener);
        }
        if ((this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem)) != null) {
            this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        }
        if ((this.menuKeyListener = this.createMenuKeyListener(this.menuItem)) != null) {
            this.menuItem.addMenuKeyListener(this.menuKeyListener);
        }
        if ((this.\u010a = this.\u0101(this.menuItem)) != null) {
            this.menuItem.addPropertyChangeListener(this.\u010a);
        }
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.menuItem, actionMap);
        this.\u0103();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.menuItem = (JMenuItem)jComponent;
        this.uninstallDefaults();
        this.uninstallComponents(this.menuItem);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        Container container = this.menuItem.getParent();
        if (!(container == null || !(container instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            JComponent jComponent2 = (JComponent)container;
            jComponent2.putClientProperty(\u010c, null);
            jComponent2.putClientProperty(\u0109, null);
        }
        this.menuItem = null;
    }

    protected void uninstallDefaults() {
        this._painter = null;
        LookAndFeel.uninstallBorder(this.menuItem);
        this.menuItem.setBorderPainted(this.oldBorderPainted);
        if (this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(null);
        }
        if (this.arrowIcon instanceof UIResource) {
            this.arrowIcon = null;
        }
        if (this.checkIcon instanceof UIResource) {
            this.checkIcon = null;
        }
    }

    protected void uninstallComponents(JMenuItem jMenuItem) {
        BasicHTML.updateRenderer(jMenuItem, "");
    }

    protected void uninstallListeners() {
        if (this.mouseInputListener != null) {
            this.menuItem.removeMouseListener(this.mouseInputListener);
            this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        }
        if (this.menuDragMouseListener != null) {
            this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        }
        if (this.menuKeyListener != null) {
            this.menuItem.removeMenuKeyListener(this.menuKeyListener);
        }
        if (this.\u010a != null) {
            this.menuItem.removePropertyChangeListener(this.\u010a);
        }
        this.mouseInputListener = null;
        this.menuDragMouseListener = null;
        this.menuKeyListener = null;
        this.\u010a = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.menuItem, null);
        if (this.\u0110 != null) {
            SwingUtilities.replaceUIInputMap(this.menuItem, 2, null);
            this.\u0110 = null;
        }
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler();
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return new D();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return new C();
    }

    private PropertyChangeListener \u0101(JComponent jComponent) {
        return new B();
    }

    protected ActionMap getActionMap() {
        String string = this.getPropertyPrefix();
        String string2 = string + ".actionMap";
        ActionMap actionMap = (ActionMap)UIDefaultsLookup.get(string2);
        if (actionMap == null) {
            actionMap = this.createActionMap();
            UIManager.getLookAndFeelDefaults().put(string2, actionMap);
        }
        return actionMap;
    }

    protected ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("doClick", new A());
        return actionMapUIResource;
    }

    protected InputMap createInputMap(int n2) {
        if (n2 == 2) {
            return new ComponentInputMapUIResource(this.menuItem);
        }
        return null;
    }

    void \u0103() {
        KeyStroke keyStroke = this.menuItem.getAccelerator();
        if (this.\u0110 != null) {
            this.\u0110.clear();
        }
        if (keyStroke != null) {
            if (this.\u0110 == null) {
                this.\u0110 = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.\u0110);
            }
            this.\u0110.put(keyStroke, "doClick");
        }
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = null;
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension = this.getPreferredSize(jComponent);
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getPreferredMenuItemSize(jComponent, this.checkIcon, this.arrowIcon, this.defaultTextIconGap);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = null;
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension = this.getPreferredSize(jComponent);
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    private void \u0101() {
        \u0106.setBounds(\u010b);
        \u0102.setBounds(\u010b);
        \u010f.setBounds(\u010b);
        \u0105.setBounds(\u010b);
        \u0108.setBounds(\u010b);
        \u010d.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        \u0107.setBounds(\u010b);
    }

    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n2) {
        Serializable serializable;
        Container container;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        Icon icon3 = jMenuItem.getIcon();
        String string = jMenuItem.getText();
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string2 = "";
        if (keyStroke != null) {
            int n3;
            int n4 = keyStroke.getModifiers();
            if (n4 > 0) {
                string2 = KeyEvent.getKeyModifiersText(n4);
                string2 = string2 + this.\u010e;
            }
            string2 = (n3 = keyStroke.getKeyCode()) != 0 ? string2 + KeyEvent.getKeyText(n3) : string2 + keyStroke.getKeyChar();
        }
        Font font = jMenuItem.getFont();
        FontMetrics fontMetrics = jMenuItem.getFontMetrics(font);
        FontMetrics fontMetrics2 = jMenuItem.getFontMetrics(this.acceleratorFont);
        this.\u0101();
        this.\u0101(fontMetrics, string, fontMetrics2, string2, icon3, icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), \u010d, \u0106, \u0102, \u010f, \u0105, \u0108, string == null ? 0 : n2, this.defaultAccelEndGap);
        \u0107.setBounds(\u0102);
        if (!\u0106.isEmpty()) {
            \u0107 = SwingUtilities.computeUnion(EclipseMenuItemUI.\u0106.x, EclipseMenuItemUI.\u0106.y, EclipseMenuItemUI.\u0106.width, EclipseMenuItemUI.\u0106.height, \u0107);
        }
        if (!((container = this.menuItem.getParent()) == null || !(container instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            int n5;
            serializable = (JComponent)container;
            Integer n6 = (Integer)((JComponent)serializable).getClientProperty(\u0109);
            Integer n7 = (Integer)((JComponent)serializable).getClientProperty(\u010c);
            int n8 = n6 != null ? n6 : 0;
            int n9 = n5 = n7 != null ? n7 : 0;
            if (EclipseMenuItemUI.\u0107.width < n8) {
                EclipseMenuItemUI.\u0107.width = n8;
            } else {
                ((JComponent)serializable).putClientProperty(\u0109, EclipseMenuItemUI.\u0107.width);
            }
            if (EclipseMenuItemUI.\u010f.width > n5) {
                n5 = EclipseMenuItemUI.\u010f.width;
                ((JComponent)serializable).putClientProperty(\u010c, EclipseMenuItemUI.\u010f.width);
            }
            EclipseMenuItemUI.\u0107.width += n5;
            EclipseMenuItemUI.\u0107.width += n2;
            EclipseMenuItemUI.\u0107.width += this.defaultAccelEndGap;
        }
        if (icon3 != null) {
            EclipseMenuItemUI.\u0107.width += n2;
        }
        serializable = jMenuItem.getInsets();
        if (this.\u0102()) {
            serializable = UIDefaultsLookup.getInsets("MenuItem.margin");
            EclipseMenuItemUI.\u0107.width += 5;
        }
        if (serializable != null) {
            EclipseMenuItemUI.\u0107.width += ((Insets)serializable).left + ((Insets)serializable).right;
            EclipseMenuItemUI.\u0107.height += ((Insets)serializable).top + ((Insets)serializable).bottom;
        }
        if (EclipseMenuItemUI.\u0107.width % 2 == 0) {
            ++EclipseMenuItemUI.\u0107.width;
        }
        if (EclipseMenuItemUI.\u0107.height % 2 == 0) {
            ++EclipseMenuItemUI.\u0107.height;
        }
        if (JideSwingUtilities.getOrientationOf(this.menuItem) == 0) {
            return \u0107.getSize();
        }
        return new Dimension(EclipseMenuItemUI.\u0107.height, EclipseMenuItemUI.\u0107.width);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintMenuItem(graphics, jComponent, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, this.defaultTextIconGap);
    }

    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n2) {
        Serializable serializable;
        Object object;
        int n3;
        int n4;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        ButtonModel buttonModel = jMenuItem.getModel();
        if (JideSwingUtilities.getOrientationOf(this.menuItem) == 0) {
            n4 = jMenuItem.getWidth();
            n3 = jMenuItem.getHeight();
        } else {
            n4 = jMenuItem.getHeight();
            n3 = jMenuItem.getWidth();
            object = (Graphics2D)graphics;
            serializable = ((Graphics2D)object).getTransform();
            ((Graphics2D)object).rotate(1.5707963267948966);
            ((Graphics2D)object).translate(0, -n3 + 1);
        }
        object = jComponent.getInsets();
        this.\u0101();
        \u010d.setBounds(0, 0, n4, n3);
        EclipseMenuItemUI.\u010d.x += ((Insets)object).left;
        EclipseMenuItemUI.\u010d.y += ((Insets)object).top;
        EclipseMenuItemUI.\u010d.width -= ((Insets)object).right + EclipseMenuItemUI.\u010d.x;
        EclipseMenuItemUI.\u010d.height -= ((Insets)object).bottom + EclipseMenuItemUI.\u010d.y;
        serializable = graphics.getFont();
        Font font = jComponent.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(this.acceleratorFont);
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string = "";
        if (keyStroke != null) {
            int n5;
            int n6 = keyStroke.getModifiers();
            if (n6 > 0) {
                string = KeyEvent.getKeyModifiersText(n6);
                string = string + this.\u010e;
            }
            string = (n5 = keyStroke.getKeyCode()) != 0 ? string + KeyEvent.getKeyText(n5) : string + keyStroke.getKeyChar();
        }
        String string2 = this.\u0101(fontMetrics, jMenuItem.getText(), fontMetrics2, string, jMenuItem.getIcon(), icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), \u010d, \u0106, \u0102, \u010f, \u0105, \u0108, jMenuItem.getText() == null ? 0 : n2, n2);
        this.paintBackground(graphics, jMenuItem, color);
        Color color3 = graphics.getColor();
        if ((jComponent.getUIClassID().indexOf("CheckBoxMenu") >= 0 || jComponent.getUIClassID().indexOf("RadioButtonMenu") >= 0) && icon != null) {
            this.\u0101(jMenuItem, graphics, icon);
            graphics.setColor(color3);
        }
        this.\u0101(jMenuItem, graphics);
        if (string2 != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, \u0102);
            } else {
                this.paintText(graphics, jMenuItem, \u0102, string2);
            }
        }
        if (string != null && !string.equals("")) {
            int n7 = 0;
            Container container = this.menuItem.getParent();
            if (container != null && container instanceof JComponent) {
                JComponent jComponent2 = (JComponent)container;
                Integer n8 = (Integer)jComponent2.getClientProperty(\u010c);
                int n9 = n8 != null ? n8 : EclipseMenuItemUI.\u010f.width;
                n7 = n9 - EclipseMenuItemUI.\u010f.width;
            }
            graphics.setFont(this.acceleratorFont);
            if (!buttonModel.isEnabled()) {
                if (this.disabledForeground != null) {
                    graphics.setColor(this.disabledForeground);
                    JideSwingUtilities.drawString(this.menuItem, graphics, string, EclipseMenuItemUI.\u010f.x - n7, EclipseMenuItemUI.\u010f.y + fontMetrics2.getAscent());
                } else {
                    graphics.setColor(jMenuItem.getBackground().brighter());
                    JideSwingUtilities.drawString(this.menuItem, graphics, string, EclipseMenuItemUI.\u010f.x - n7, EclipseMenuItemUI.\u010f.y + fontMetrics2.getAscent());
                    graphics.setColor(jMenuItem.getBackground().darker());
                    JideSwingUtilities.drawString(this.menuItem, graphics, string, EclipseMenuItemUI.\u010f.x - n7 - 1, EclipseMenuItemUI.\u010f.y + fontMetrics2.getAscent() - 1);
                }
            } else {
                if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                    graphics.setColor(this.acceleratorSelectionForeground);
                } else {
                    graphics.setColor(this.acceleratorForeground);
                }
                JideSwingUtilities.drawString(this.menuItem, graphics, string, EclipseMenuItemUI.\u010f.x - n7, EclipseMenuItemUI.\u010f.y + fontMetrics2.getAscent());
            }
        }
        if (icon2 != null) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            }
            if (this.\u0102()) {
                icon2.paintIcon(jComponent, graphics, EclipseMenuItemUI.\u0108.x, EclipseMenuItemUI.\u0108.y);
            }
        }
        graphics.setColor(color3);
        graphics.setFont((Font)serializable);
    }

    private void \u0101(JMenuItem jMenuItem, Graphics graphics, Icon icon) {
        boolean bl = false;
        ButtonModel buttonModel = jMenuItem.getModel();
        if (jMenuItem instanceof JCheckBoxMenuItem) {
            bl = jMenuItem.isSelected();
        } else if (jMenuItem instanceof JRadioButtonMenuItem) {
            bl = jMenuItem.isSelected();
        }
        if (bl && jMenuItem.getIcon() == null) {
            if (buttonModel.isArmed()) {
                if (icon instanceof ImageIcon) {
                    ImageIcon imageIcon = IconsFactory.createMaskImage(jMenuItem, icon, Color.BLACK, this.selectionForeground);
                    imageIcon.paintIcon(jMenuItem, graphics, EclipseMenuItemUI.\u0105.x, EclipseMenuItemUI.\u0105.y);
                } else {
                    ImageIcon imageIcon = IconsFactory.createNegativeImage(jMenuItem, icon);
                    imageIcon.paintIcon(jMenuItem, graphics, EclipseMenuItemUI.\u0105.x, EclipseMenuItemUI.\u0105.y);
                }
            } else if (icon instanceof ImageIcon) {
                ImageIcon imageIcon = IconsFactory.createMaskImage(jMenuItem, icon, Color.BLACK, jMenuItem.getForeground());
                imageIcon.paintIcon(jMenuItem, graphics, EclipseMenuItemUI.\u0105.x, EclipseMenuItemUI.\u0105.y);
            } else {
                icon.paintIcon(jMenuItem, graphics, EclipseMenuItemUI.\u0105.x, EclipseMenuItemUI.\u0105.y);
            }
        }
    }

    private void \u0101(JMenuItem jMenuItem, Graphics graphics) {
        ButtonModel buttonModel = jMenuItem.getModel();
        if (jMenuItem.getIcon() != null) {
            Icon icon;
            if (!buttonModel.isEnabled()) {
                icon = jMenuItem.getDisabledIcon();
                if (icon == null) {
                    icon = jMenuItem.getIcon();
                    icon = icon instanceof ImageIcon ? IconsFactory.createGrayImage(((ImageIcon)icon).getImage()) : IconsFactory.createGrayImage(jMenuItem, icon);
                }
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon = jMenuItem.getPressedIcon();
                if (icon == null) {
                    icon = jMenuItem.getIcon();
                }
            } else {
                icon = jMenuItem.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(jMenuItem, graphics, EclipseMenuItemUI.\u0106.x, EclipseMenuItemUI.\u0106.y);
            }
        }
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        int n2;
        int n3;
        ButtonModel buttonModel = jMenuItem.getModel();
        Color color2 = graphics.getColor();
        if (JideSwingUtilities.getOrientationOf(jMenuItem) == 0) {
            n3 = jMenuItem.getWidth();
            n2 = jMenuItem.getHeight();
        } else {
            n3 = jMenuItem.getHeight();
            n2 = jMenuItem.getWidth();
        }
        if (jMenuItem.isOpaque()) {
            if (jMenuItem.getBackground() instanceof UIResource) {
                graphics.setColor(this.\u0104);
            } else {
                graphics.setColor(jMenuItem.getBackground());
            }
            graphics.fillRect(0, 0, n3, n2);
            if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color);
                graphics.fillRect(1, 1, n3 - 2, n2 - 2);
            }
            graphics.setColor(color2);
        }
    }

    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        ButtonModel buttonModel = jMenuItem.getModel();
        if (!buttonModel.isEnabled()) {
            WindowsGraphicsUtilsPort.paintText(graphics, jMenuItem, rectangle, string, 0);
        } else {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n2 = jMenuItem.getDisplayedMnemonicIndex();
            if (LookAndFeelFactory.isMnemonicHidden()) {
                n2 = -1;
            }
            Color color = graphics.getColor();
            if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(this.selectionForeground);
            }
            JideSwingUtilities.drawStringUnderlineCharAt(jMenuItem, graphics, string, n2, rectangle.x, rectangle.y + fontMetrics.getAscent());
            graphics.setColor(color);
        }
    }

    private String \u0101(FontMetrics fontMetrics, String string, FontMetrics fontMetrics2, String string2, Icon icon, Icon icon2, Icon icon3, int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4, Rectangle rectangle5, Rectangle rectangle6, int n6, int n7) {
        SwingUtilities.layoutCompoundLabel(this.menuItem, fontMetrics, string, icon, n2, n3, n4, n5, rectangle, rectangle2, rectangle3, n6);
        rectangle.y = 0;
        rectangle.x = 0;
        if (JideSwingUtilities.getOrientationOf(this.menuItem) == 0) {
            rectangle.height = this.menuItem.getHeight();
            rectangle.width = this.menuItem.getWidth();
        } else {
            rectangle.height = this.menuItem.getWidth();
            rectangle.width = this.menuItem.getHeight();
        }
        if (string2 == null || string2.equals("")) {
            rectangle4.height = 0;
            rectangle4.width = 0;
            string2 = "";
        } else {
            rectangle4.width = SwingUtilities.computeStringWidth(fontMetrics2, string2);
            rectangle4.height = fontMetrics2.getHeight();
        }
        if (string == null || string.equals("")) {
            rectangle3.height = 0;
            rectangle3.width = 0;
            string = "";
        } else {
            boolean bl = string == null || string.equals("");
            boolean bl2 = false;
            View view = null;
            View view2 = view = this.menuItem != null ? (View)this.menuItem.getClientProperty("html") : null;
            if (view != null) {
                rectangle3.width = (int)view.getPreferredSpan(0);
                rectangle3.height = (int)view.getPreferredSpan(1);
            } else {
                rectangle3.width = SwingUtilities.computeStringWidth(fontMetrics, string);
                rectangle3.height = fontMetrics.getHeight();
            }
        }
        if (icon == null) {
            if (this.\u0102()) {
                rectangle2.height = 16;
                rectangle2.width = 16;
            } else {
                rectangle2.height = 0;
                rectangle2.width = 0;
            }
        } else {
            rectangle2.width = icon.getIconWidth();
            rectangle2.height = icon.getIconHeight();
        }
        if (icon3 == null) {
            rectangle6.height = 0;
            rectangle6.width = 0;
        } else {
            rectangle6.width = icon3.getIconWidth();
            rectangle6.height = icon3.getIconHeight();
        }
        if (icon2 == null) {
            rectangle5.height = 0;
            rectangle5.width = 0;
        } else {
            rectangle5.width = icon2.getIconWidth();
            rectangle5.height = icon2.getIconHeight();
        }
        if (this.menuItem.getComponentOrientation().isLeftToRight()) {
            if (this.\u0102()) {
                rectangle2.x = this.defaultShadowWidth - rectangle2.width >> 1;
                rectangle3.x = this.defaultShadowWidth + n6;
            } else if (icon != null) {
                rectangle2.x = this.menuItem.getInsets().left;
                rectangle3.x = rectangle2.x + rectangle2.width + n6;
            } else {
                rectangle3.x = this.menuItem.getInsets().left;
            }
            rectangle4.x = rectangle.x + rectangle.width - this.defaultAccelEndGap - rectangle4.width;
            if (this.\u0102()) {
                rectangle5.x = this.defaultShadowWidth - rectangle5.width >> 1;
                rectangle6.x = rectangle.x + rectangle.width - n7 - rectangle6.width;
            }
        }
        if (n4 == 0 && n2 == 0) {
            rectangle3.y = (rectangle.height - rectangle3.height >> 1) + 1;
            rectangle2.y = (rectangle.height - rectangle2.height >> 1) + 1;
        }
        Rectangle rectangle7 = rectangle2.union(rectangle3);
        rectangle4.y = rectangle7.y + (rectangle7.height >> 1) - (rectangle4.height >> 1);
        if (this.\u0102()) {
            rectangle6.y = (rectangle.height - rectangle6.height >> 1) + 1;
            rectangle5.y = (rectangle.height - rectangle5.height >> 1) + 1;
        }
        return string;
    }

    private boolean \u0102() {
        boolean bl = true;
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu()) {
            bl = false;
        }
        return bl;
    }

    public MenuElement[] getPath() {
        MenuElement[] menuElementArray;
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
        int n2 = menuElementArray2.length;
        if (n2 == 0) {
            return new MenuElement[0];
        }
        Container container = this.menuItem.getParent();
        if (menuElementArray2[n2 - 1].getComponent() == container) {
            menuElementArray = new MenuElement[n2 + 1];
            System.arraycopy(menuElementArray2, 0, menuElementArray, 0, n2);
            menuElementArray[n2] = this.menuItem;
        } else {
            int n3;
            for (n3 = menuElementArray2.length - 1; n3 >= 0 && menuElementArray2[n3].getComponent() != container; --n3) {
            }
            menuElementArray = new MenuElement[n3 + 2];
            System.arraycopy(menuElementArray2, 0, menuElementArray, 0, n3 + 1);
            menuElementArray[n3 + 1] = this.menuItem;
        }
        return menuElementArray;
    }

    protected void doClick(MenuSelectionManager menuSelectionManager) {
        if (menuSelectionManager == null) {
            menuSelectionManager = MenuSelectionManager.defaultManager();
        }
        menuSelectionManager.clearSelectedPath();
        this.menuItem.doClick(0);
    }

    public ThemePainter getPainter() {
        return this._painter;
    }

    protected boolean isDownArrowVisible(Container container) {
        if (container instanceof TopLevelMenuContainer && ((TopLevelMenuContainer)((Object)container)).isMenuBar()) {
            return false;
        }
        if (container instanceof TopLevelMenuContainer && !((TopLevelMenuContainer)((Object)container)).isMenuBar()) {
            return true;
        }
        return !(container instanceof JMenuBar);
    }

    private static class A
    extends AbstractAction {
        private static final long \u0101 = -3086149185380600185L;

        private A() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            MenuSelectionManager.defaultManager().clearSelectedPath();
            jMenuItem.doClick();
        }
    }

    private class B
    implements PropertyChangeListener {
        private B() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("labelFor") || string.equals("displayedMnemonic") || string.equals("accelerator")) {
                EclipseMenuItemUI.this.\u0103();
            } else if ("buttonStyle".equals(string) || "opaque".equals(string) || "contentAreaFilled".equals(string)) {
                if (propertyChangeEvent.getSource() instanceof JMenuItem) {
                    JMenuItem jMenuItem = (JMenuItem)propertyChangeEvent.getSource();
                    jMenuItem.repaint();
                }
            } else if (string.equals("text") || "font".equals(string) || "foreground".equals(string)) {
                JMenuItem jMenuItem = (JMenuItem)propertyChangeEvent.getSource();
                String string2 = jMenuItem.getText();
                BasicHTML.updateRenderer(jMenuItem, string2);
            }
        }
    }

    private class C
    implements MenuKeyListener {
        private C() {
        }

        @Override
        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
            if (EclipseMenuItemUI.this.menuItem != null && EclipseMenuItemUI.this.menuItem.isEnabled()) {
                int n2 = EclipseMenuItemUI.this.menuItem.getMnemonic();
                if (n2 == 0 || menuKeyEvent.getPath().length != 2) {
                    return;
                }
                if (this.\u0101((char)n2) == this.\u0101(menuKeyEvent.getKeyChar())) {
                    MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
                    EclipseMenuItemUI.this.doClick(menuSelectionManager);
                    menuKeyEvent.consume();
                }
            }
        }

        @Override
        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
        }

        @Override
        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }

        private char \u0101(char c2) {
            return Character.toLowerCase(c2);
        }
    }

    private class D
    implements MenuDragMouseListener {
        private D() {
        }

        @Override
        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        }

        @Override
        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            if (EclipseMenuItemUI.this.menuItem != null && EclipseMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
                MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
                menuSelectionManager.setSelectedPath(menuElementArray);
            }
        }

        @Override
        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        @Override
        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
            if (EclipseMenuItemUI.this.menuItem != null && EclipseMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
                Point point = menuDragMouseEvent.getPoint();
                if (point.x >= 0 && point.x < EclipseMenuItemUI.this.menuItem.getWidth() && point.y >= 0 && point.y < EclipseMenuItemUI.this.menuItem.getHeight()) {
                    EclipseMenuItemUI.this.doClick(menuSelectionManager);
                } else {
                    menuSelectionManager.clearSelectedPath();
                }
            }
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (EclipseMenuItemUI.this.menuItem != null && EclipseMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                Point point = mouseEvent.getPoint();
                if (point.x >= 0 && point.x < EclipseMenuItemUI.this.menuItem.getWidth() && point.y >= 0 && point.y < EclipseMenuItemUI.this.menuItem.getHeight()) {
                    EclipseMenuItemUI.this.doClick(menuSelectionManager);
                } else {
                    menuSelectionManager.processMouseEvent(mouseEvent);
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (EclipseMenuItemUI.this.menuItem != null && EclipseMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                int n2 = mouseEvent.getModifiers();
                if ((n2 & 0x1C) != 0) {
                    MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
                } else {
                    menuSelectionManager.setSelectedPath(EclipseMenuItemUI.this.getPath());
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (EclipseMenuItemUI.this.menuItem != null && EclipseMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                int n2 = mouseEvent.getModifiers();
                if ((n2 & 0x1C) != 0) {
                    MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
                } else {
                    MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                    if (menuElementArray.length > 1) {
                        MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 1];
                        int n3 = menuElementArray.length - 1;
                        for (int i2 = 0; i2 < n3; ++i2) {
                            menuElementArray2[i2] = menuElementArray[i2];
                        }
                        menuSelectionManager.setSelectedPath(menuElementArray2);
                    }
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

