/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.Animatable;
import com.jidesoft.chart.AnimatedChart;
import com.jidesoft.chart.AutoRanger;
import com.jidesoft.chart.BarResizePolicy;
import com.jidesoft.chart.ChartType;
import com.jidesoft.chart.ChartUIDefaultsCustomizer;
import com.jidesoft.chart.DefaultAutoRanger;
import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.E;
import com.jidesoft.chart.Frontable;
import com.jidesoft.chart.G;
import com.jidesoft.chart.J;
import com.jidesoft.chart.K;
import com.jidesoft.chart.MultiAutoRanger;
import com.jidesoft.chart.MultiImageLazyChartRenderer;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.ShadowVisibility;
import com.jidesoft.chart.Shadowable;
import com.jidesoft.chart.UserToPixelTransform;
import com.jidesoft.chart.ZOrder;
import com.jidesoft.chart.ZOrderModelComparator;
import com.jidesoft.chart.annotation.AbstractAnnotation;
import com.jidesoft.chart.annotation.AbstractLabel;
import com.jidesoft.chart.annotation.Annotation;
import com.jidesoft.chart.annotation.AutoPositionedLabel;
import com.jidesoft.chart.annotation.ChartAnnotation;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.axis.AxisPlacement;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.chart.event.ImageChangeEvent;
import com.jidesoft.chart.event.ImageChangeListener;
import com.jidesoft.chart.event.MouseDragPanner;
import com.jidesoft.chart.event.MouseWheelZoomer;
import com.jidesoft.chart.event.PointDescriptor;
import com.jidesoft.chart.event.PointSelection;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartModelChangeEvent;
import com.jidesoft.chart.model.ChartModelChangeListener;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.model.IdentityTransform;
import com.jidesoft.chart.model.LeanChartModel;
import com.jidesoft.chart.model.SummingChartModel;
import com.jidesoft.chart.render.AbstractPieSegmentRenderer;
import com.jidesoft.chart.render.AxisRenderer;
import com.jidesoft.chart.render.BarRenderer;
import com.jidesoft.chart.render.DefaultBarRenderer;
import com.jidesoft.chart.render.DefaultLineRenderer;
import com.jidesoft.chart.render.DefaultPieSegmentRenderer;
import com.jidesoft.chart.render.DefaultPointRenderer;
import com.jidesoft.chart.render.LineRenderer;
import com.jidesoft.chart.render.PieSegmentRenderer;
import com.jidesoft.chart.render.PointRenderer;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.util.ChartUtils;
import com.jidesoft.chart.util.Filter;
import com.jidesoft.chart.util.GraphicsUtilities;
import com.jidesoft.chart.util.Pair;
import com.jidesoft.chart.util.Point2DPool;
import com.jidesoft.chart.util.Rotation;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Positionable;
import com.jidesoft.range.Range;
import com.jidesoft.swing.Animator;
import com.jidesoft.swing.ShadowFactory;
import com.jidesoft.swing.ShadowRenderer;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GrayFilter;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class Chart
extends JComponent
implements ChartModelChangeListener,
PropertyChangeListener,
Animatable,
AnimatedChart {
    private static final long \u0164 = 1843397021865383301L;
    public static final String PROPERTY_ANIMATE_ON_SHOW = "Animate on Show";
    public static final String PROPERTY_ANIMATION_POSITION = "Animation Position";
    public static final String PROPERTY_ANTI_ALIASING = "AntiAliasing";
    public static final String PROPERTY_AUTO_RANGING = "AutoRanging";
    public static final String PROPERTY_AXIS_COLOR = "AxisColor";
    public static final String PROPERTY_BAR_RENDERER = "BarRenderer";
    public static final String PROPERTY_BAR_GAP = "BarGap";
    public static final String PROPERTY_BAR_GROUP_GAP = "BarGroupGap";
    public static final String PROPERTY_BARS_GROUPED = "BarsGrouped";
    public static final String PROPERTY_CHART_BACKGROUND = "ChartBackground";
    public static final String PROPERTY_CHART_BORDER = "ChartBorder";
    public static final String PROPERTY_CURRENT_CHART_POINT = "ChartFocusPoint";
    public static final String PROPERTY_CHART_TYPE = "ChartType";
    public static final String PROPERTY_GRID_COLOR = "GridColor";
    public static final String PROPERTY_HIGHLIGHT_STYLE = "HighlightStyle";
    public static final String PROPERTY_HIGH_QUALITY = "HighQuality";
    public static final String PROPERTY_HORIZONTAL_GRID_LINES_VISIBLE = "HorizontalGridLinesVisible";
    public static final String PROPERTY_HORIZONTAL_MINOR_GRID_LINES_VISIBLE = "HorizontalMinorGridLinesVisible";
    public static final String PROPERTY_HORIZONTAL_MINOR_GRID_STROKE = "HorizontalMinorGridStroke";
    public static final String PROPERTY_HORIZONTAL_GRID_STROKE = "HorizontalGridStroke";
    public static final String PROPERTY_LABEL_COLOR = "LabelColor";
    public static final String PROPERTY_LABELLING_TRACES = "LabellingTraces";
    public static final String PROPERTY_LAZY_RENDERING_THRESHOLD = "LazyRenderingThreshold";
    public static final String PROPERTY_LINE_RENDERER = "LineRenderer";
    public static final String PROPERTY_MAX_BAR_WIDTH = "MaxBarWidth";
    public static final String PROPERTY_MINOR_GRID_COLOR = "MinorGridColor";
    public static final String PROPERTY_MODEL = "Model";
    public static final String PROPERTY_PANEL_BACKGROUND = "PanelBackground";
    public static final String PROPERTY_PIE_DIAMETER = "PieDiameter";
    public static final String PROPERTY_PIE_SEGMENT_RENDERER = "PieSegmentRenderer";
    public static final String PROPERTY_POINT_RENDERER = "PointRenderer";
    public static final String PROPERTY_ROLLOVER_VISIBLE = "Rollover Visible";
    public static final String PROPERTY_SELECTABLE = "Selectable";
    public static final String PROPERTY_SELECTION_SHOWS_EXPLODED_SEGMENTS = "SelectionShowsExplodedSegments";
    public static final String PROPERTY_SELECTION_SHOWS_OUTLINE = "SelectionShowsOutlines";
    public static final String PROPERTY_SHADOW_RENDERER = "Shadow Renderer";
    public static final String PROPERTY_SHADOW_VISIBLE = "ShadowVisible";
    public static final String PROPERTY_SHADOW_VISIBILITY = "ShadowVisibility";
    public static final String PROPERTY_CHART_STYLE = "ChartStyle";
    public static final String PROPERTY_TICK_COLOR = "TickColor";
    public static final String PROPERTY_TICK_STROKE = "TickStroke";
    public static final String PROPERTY_TICK_FONT = "TickFont";
    public static final String PROPERTY_TICK_LENGTH = "TickLength";
    public static final String PROPERTY_MINOR_TICK_LENGTH = "Minor TickLength";
    public static final String PROPERTY_ALLOW_TICK_LABEL_OVERLAP = "Allow Tick Label Overlap";
    public static final String PROPERTY_TITLE = "Title";
    public static final String PROPERTY_TITLE_VISIBLE = "TitleVisible";
    public static final String PROPERTY_VERTICAL_GRID_LINES_VISIBLE = "VerticalGridLinesVisible";
    public static final String PROPERTY_VERTICAL_MINOR_GRID_LINES_VISIBLE = "VerticalMinorGridLinesVisible";
    public static final String PROPERTY_VERTICAL_MINOR_GRID_STROKE = "VerticalMinorGridStroke";
    public static final String PROPERTY_VERTICAL_GRID_STROKE = "VerticalGridStroke";
    public static final String PROPERTY_X_AXIS = "XAxis";
    public static final String PROPERTY_Y_AXIS = "YAxis";
    private static final boolean \u017c = false;
    private static int \u0189;
    private static double \u0186;
    private int \u0151 = Integer.MAX_VALUE;
    private ShadowRenderer \u0161;
    private Axis \u0174;
    private List<Axis> \u0147 = new CopyOnWriteArrayList<Axis>();
    private Map<ChartModel, Axis> \u0178 = new HashMap<ChartModel, Axis>();
    private Map<ChartModel, ListSelectionModel> \u0187 = new HashMap<ChartModel, ListSelectionModel>();
    private AbstractLabel \u014f = null;
    private List<Drawable> \u014c = new ArrayList<Drawable>();
    private transient E<ChartModel> \u0141;
    private ImageChangeListener \u0162;
    private Filter<ChartModel> \u0143 = new A();
    private Filter<ChartModel> \u0181 = new C();
    private Filter<ChartModel> \u0194 = new D();
    private Filter<ChartModel> \u0163 = new B();
    private Map<ChartModel, Integer> \u0160 = new HashMap<ChartModel, Integer>();
    private boolean \u013e = true;
    private boolean \u014e = false;
    private Animator \u017d = new Animator(this, 50, 40, 10);
    private boolean \u0176 = true;
    private boolean \u014a = false;
    private AutoRanger \u0175 = new DefaultAutoRanger();
    private boolean \u016e = false;
    private boolean \u0158 = true;
    private boolean \u013f = true;
    private boolean \u018c = false;
    private boolean \u0149 = true;
    private boolean \u016c = false;
    private boolean \u0190 = false;
    private boolean \u0159 = true;
    private boolean \u0183 = false;
    private List<UserToPixelTransform> \u014d = new CopyOnWriteArrayList<UserToPixelTransform>();
    private int \u0193;
    private int \u016b;
    private int \u0146;
    private int \u0170;
    private Paint \u0157;
    private Paint \u015b = null;
    private Border \u015a;
    private Color \u0192 = Color.DARK_GRAY;
    private Color \u0179 = Color.DARK_GRAY;
    private Color \u0172 = Color.LIGHT_GRAY;
    private Color \u0152 = new Color(192, 192, 192, 100);
    private Color \u015c = Color.black;
    private Stroke \u015d = new BasicStroke(1.0f);
    private Font \u016d;
    private ShadowVisibility \u0185 = ShadowVisibility.NONE;
    private final Map<String, ChartModel> \u0169 = Collections.synchronizedMap(new HashMap());
    private BufferedImage \u0140 = null;
    private BufferedImage \u018a = null;
    private BufferedImage \u018d = null;
    private boolean \u0184;
    private Map<String, ChartStyle> \u018f = new HashMap<String, ChartStyle>();
    private Map<String, PointRenderer> \u0154 = new HashMap<String, PointRenderer>();
    private Map<String, LineRenderer> \u017f = new HashMap<String, LineRenderer>();
    private Map<String, BarRenderer> \u0150 = new HashMap<String, BarRenderer>();
    private Map<Highlight, ChartStyle> \u0148 = new HashMap<Highlight, ChartStyle>();
    private MouseWheelZoomer \u016f;
    private MouseDragPanner \u0171;
    private com.jidesoft.chart.C \u017a;
    private Chartable \u0166;
    private List<ChartModel> \u015e = new CopyOnWriteArrayList<ChartModel>();
    private final J \u018b = new J();
    private final com.jidesoft.chart.B \u017e = new com.jidesoft.chart.B();
    private final K \u0153 = new K();
    private final G \u0145 = new G();
    private final com.jidesoft.chart.D \u0168 = new com.jidesoft.chart.D(this);
    private Stroke \u0191 = new BasicStroke(1.0f);
    private Stroke \u0177 = new BasicStroke(1.0f);
    private Stroke \u016a = new BasicStroke(1.0f);
    private Stroke \u0167 = new BasicStroke(1.0f);
    private ChartType \u0155 = ChartType.XY;
    private PointRenderer \u0165 = new DefaultPointRenderer();
    private BarRenderer \u0144 = new DefaultBarRenderer();
    private LineRenderer \u015f = new DefaultLineRenderer(this);
    private PieSegmentRenderer \u014b = new DefaultPieSegmentRenderer();
    private double \u0156 = 0.0;
    private boolean \u0188 = false;
    private boolean \u018e = true;
    private int \u0142 = 4;
    private final ReadWriteLock \u0173 = new ReentrantReadWriteLock();
    private final Lock \u0180 = this.\u0173.readLock();
    private final Lock \u017b = this.\u0173.writeLock();
    private Point2DPool \u0182 = Point2DPool.instance();

    public Chart() {
        this.init();
    }

    public Chart(ChartModel chartModel) {
        this();
        this.setModel(chartModel);
    }

    public Chart(String string) {
        this();
        this.setName(string);
    }

    public Chart(Dimension dimension) {
        this();
        this.setSize(dimension);
        this.setPreferredSize(dimension);
        this.update();
    }

    protected void init() {
        this.setName("Chart-" + \u0189);
        ++\u0189;
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        if (UIDefaultsLookup.get("Chart.font") == null) {
            new ChartUIDefaultsCustomizer().customize(UIManager.getLookAndFeelDefaults());
        }
        ShadowFactory shadowFactory = new ShadowFactory();
        shadowFactory.setRenderingHint("blur_quality", "high");
        this.setShadowRenderer(shadowFactory);
        this.setPanelBackground(UIManager.getColor("Chart.background"));
        this.\u0102(new Axis("x"), false);
        this.\u0101(new Axis("y"), false);
        this.setMinimumSize(new Dimension(100, 100));
        this.setFont(UIManager.getFont("Chart.font"));
        this.setTickFont(UIManager.getFont("Chart.tickFont"));
        this.\u0162 = new ImageChangeListener(){

            @Override
            public void imageChanged(ImageChangeEvent imageChangeEvent) {
                Chart.this.update(false);
                Chart.this.firePropertyChange("dirty", false, true);
            }
        };
        this.setLazyChartRenderer(new MultiImageLazyChartRenderer(this));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Chart.this.update();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                Chart.this.repaint(500L);
            }
        });
        this.\u017a = new com.jidesoft.chart.C(this);
        this.addMouseListener(this.\u017a);
        this.addMouseMotionListener(this.\u017a);
        this.\u017d.addAnimatorListener(this.\u0168);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (UIDefaultsLookup.get("Chart.font") == null) {
            new ChartUIDefaultsCustomizer().customize(UIManager.getLookAndFeelDefaults());
        }
    }

    public void setZOrder(ChartModel chartModel, Integer n2) {
        this.\u0160.put(chartModel, n2);
    }

    public Integer getZOrder(ChartModel chartModel) {
        return this.\u0160.get(chartModel);
    }

    public ChartType getChartType() {
        return this.\u0155;
    }

    public void setChartType(ChartType chartType) {
        ChartType chartType2 = this.\u0155;
        this.\u0155 = chartType;
        ChartUtils.clearBufferedImage(this.\u018a, this.getBackground());
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_CHART_TYPE, (Object)chartType2, (Object)chartType);
    }

    public ShadowRenderer getShadowRenderer() {
        return this.\u0161;
    }

    public void setShadowRenderer(ShadowRenderer shadowRenderer) {
        if (shadowRenderer == null) {
            throw new IllegalArgumentException("Shadow Renderer cannot be null");
        }
        ShadowRenderer shadowRenderer2 = this.\u0161;
        this.\u0161 = shadowRenderer;
        this.firePropertyChange(PROPERTY_SHADOW_RENDERER, shadowRenderer2, shadowRenderer);
    }

    public PointRenderer getPointRenderer() {
        return this.\u0165;
    }

    public void setPointRenderer(PointRenderer pointRenderer) {
        PointRenderer pointRenderer2 = this.\u0165;
        if (pointRenderer == null) {
            throw new IllegalArgumentException("PointRenderer cannot be null");
        }
        this.\u0165 = pointRenderer;
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_POINT_RENDERER, pointRenderer2, pointRenderer);
    }

    public PointRenderer getPointRenderer(ChartModel chartModel) {
        String string = chartModel.getName();
        if (string == null) {
            throw new IllegalArgumentException("The name of the supplied ChartModel cannot be null");
        }
        PointRenderer pointRenderer = this.\u0154.get(string);
        if (pointRenderer == null) {
            return this.getPointRenderer();
        }
        return pointRenderer;
    }

    public void setPointRenderer(ChartModel chartModel, PointRenderer pointRenderer) {
        String string = chartModel.getName();
        if (string == null) {
            throw new IllegalArgumentException("ChartModel name cannot be null");
        }
        PointRenderer pointRenderer2 = this.\u0154.get(string);
        if (pointRenderer == null) {
            throw new IllegalArgumentException("PointRenderer cannot be null");
        }
        this.\u0154.put(string, pointRenderer);
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_POINT_RENDERER, pointRenderer2, pointRenderer);
    }

    public LineRenderer getLineRenderer(ChartModel chartModel) {
        String string = chartModel.getName();
        if (string == null) {
            throw new IllegalArgumentException("ChartModel name cannot be null");
        }
        LineRenderer lineRenderer = this.\u017f.get(string);
        if (lineRenderer == null) {
            return this.getLineRenderer();
        }
        return lineRenderer;
    }

    public void setLineRenderer(ChartModel chartModel, LineRenderer lineRenderer) {
        if (chartModel == null) {
            throw new IllegalArgumentException("Cannot set LineRenderer for a null model");
        }
        String string = chartModel.getName();
        if (string == null) {
            throw new IllegalArgumentException("Cannot set LineRenderer for a ChartModel with null name");
        }
        LineRenderer lineRenderer2 = this.\u017f.get(string);
        if (lineRenderer == null) {
            throw new IllegalArgumentException("LineRenderer cannot be null");
        }
        this.\u017f.put(string, lineRenderer);
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_LINE_RENDERER, lineRenderer2, lineRenderer);
    }

    public BarRenderer getBarRenderer() {
        return this.\u0144;
    }

    public void setBarRenderer(BarRenderer barRenderer) {
        BarRenderer barRenderer2 = this.\u0144;
        this.\u0144 = barRenderer;
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_BAR_RENDERER, barRenderer2, barRenderer);
    }

    public BarRenderer getBarRenderer(ChartModel chartModel) {
        String string = chartModel.getName();
        if (string == null) {
            throw new NullPointerException("ChartModel name cannot be null");
        }
        BarRenderer barRenderer = this.\u0150.get(string);
        if (barRenderer == null) {
            return this.getBarRenderer();
        }
        return barRenderer;
    }

    public void setBarRenderer(ChartModel chartModel, BarRenderer barRenderer) {
        String string = chartModel.getName();
        if (string == null) {
            throw new NullPointerException("ChartModel name cannot be null");
        }
        BarRenderer barRenderer2 = this.\u0150.get(string);
        if (barRenderer == null) {
            throw new IllegalArgumentException("BarRenderer cannot be null");
        }
        this.\u0150.put(string, barRenderer);
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_BAR_RENDERER, barRenderer2, barRenderer);
    }

    public boolean isRecordingShapes() {
        return this.\u0159;
    }

    public void setRecordingShapes(boolean bl) {
        this.\u0159 = bl;
    }

    public void setPieDiameter(Integer n2) {
        Integer n3 = this.\u018b.\u0103();
        this.\u018b.\u0101(n2);
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_PIE_DIAMETER, n3, n2);
    }

    public Integer getPieDiameter() {
        return this.\u018b.\u0103();
    }

    public Stroke getHorizontalGridStroke() {
        return this.\u0191;
    }

    public Stroke getHorizontalMinorGridStroke() {
        return this.\u0177;
    }

    public void setHorizontalMinorGridStroke(Stroke stroke) {
        Stroke stroke2 = this.\u0177;
        this.\u0177 = stroke;
        this.firePropertyChange(PROPERTY_HORIZONTAL_MINOR_GRID_STROKE, stroke2, stroke);
    }

    public void setHorizontalGridStroke(Stroke stroke) {
        Stroke stroke2 = this.\u0191;
        this.\u0191 = stroke;
        this.firePropertyChange(PROPERTY_HORIZONTAL_GRID_STROKE, stroke2, stroke);
    }

    public Stroke getVerticalGridStroke() {
        return this.\u016a;
    }

    public void setVerticalGridStroke(Stroke stroke) {
        Stroke stroke2 = this.\u016a;
        this.\u016a = stroke;
        this.firePropertyChange(PROPERTY_VERTICAL_GRID_STROKE, stroke2, stroke);
    }

    public Stroke getVerticalMinorGridStroke() {
        return this.\u0167;
    }

    public void setVerticalMinorGridStroke(Stroke stroke) {
        Stroke stroke2 = this.\u0167;
        this.\u0167 = stroke;
        this.firePropertyChange(PROPERTY_VERTICAL_MINOR_GRID_STROKE, stroke2, stroke);
    }

    public Chartable getCurrentChartPoint() {
        return this.\u0166;
    }

    void \u0101(Chartable chartable) {
        Chartable chartable2 = this.\u0166;
        if (this.\u0166 != null && this.\u0166.equals(chartable) || this.\u0166 == null && chartable == null) {
            return;
        }
        this.\u0166 = chartable;
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_CURRENT_CHART_POINT, chartable2, this.\u0166);
    }

    public Shape renderedAs(Chartable chartable) {
        PointDescriptor pointDescriptor = this.\u017e.\u0102(chartable);
        if (pointDescriptor != null) {
            return pointDescriptor.getShape();
        }
        pointDescriptor = this.\u0145.\u0101(chartable);
        if (pointDescriptor != null) {
            return pointDescriptor.getShape();
        }
        if (this.\u014b instanceof AbstractPieSegmentRenderer) {
            AbstractPieSegmentRenderer abstractPieSegmentRenderer = (AbstractPieSegmentRenderer)this.\u014b;
            pointDescriptor = abstractPieSegmentRenderer.rendered(chartable);
            return pointDescriptor == null ? null : pointDescriptor.getShape();
        }
        return null;
    }

    public PointDescriptor rendered(Chartable chartable) {
        PointDescriptor pointDescriptor = this.\u017e.\u0102(chartable);
        if (pointDescriptor != null) {
            return pointDescriptor;
        }
        pointDescriptor = this.\u0145.\u0101(chartable);
        if (pointDescriptor != null) {
            return pointDescriptor;
        }
        if (this.\u014b instanceof AbstractPieSegmentRenderer) {
            AbstractPieSegmentRenderer abstractPieSegmentRenderer = (AbstractPieSegmentRenderer)this.\u014b;
            pointDescriptor = abstractPieSegmentRenderer.rendered(chartable);
            return pointDescriptor;
        }
        return null;
    }

    public PointDescriptor containingShape(Point point) {
        PointDescriptor pointDescriptor = this.\u014b.containingSegment(point);
        if (pointDescriptor != null) {
            return pointDescriptor;
        }
        PointDescriptor pointDescriptor2 = this.\u017e.\u0103(point);
        if (pointDescriptor2 != null) {
            return pointDescriptor2;
        }
        PointDescriptor pointDescriptor3 = this.\u0145.\u0101(point);
        if (pointDescriptor3 != null) {
            return pointDescriptor3;
        }
        return null;
    }

    public Collection<PointDescriptor> containingShapes(Point point) {
        List<PointDescriptor> list;
        List<PointDescriptor> list2;
        ArrayList<PointDescriptor> arrayList = new ArrayList<PointDescriptor>();
        PointDescriptor pointDescriptor = this.\u014b.containingSegment(point);
        if (pointDescriptor != null) {
            arrayList.add(pointDescriptor);
        }
        if ((list2 = this.\u017e.\u0104(point)) != null) {
            arrayList.addAll(list2);
        }
        if ((list = this.\u0145.\u0102(point)) != null) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public PointDescriptor containingBar(Point point) {
        return this.\u017e.\u0103(point);
    }

    public PointDescriptor containingSegment(Point point) {
        return this.\u014b.containingSegment(point);
    }

    public Collection<ChartModel> nearLine(Point point, float f2) {
        return this.\u0153.\u0101(point, f2);
    }

    public PointDescriptor containingPoint(Point point) {
        return this.\u0145.\u0101(point);
    }

    public Collection<PointDescriptor> containingPoints(Point point) {
        return this.\u0145.\u0102(point);
    }

    public PieSegmentRenderer getPieSegmentRenderer() {
        return this.\u014b;
    }

    public void setPieSegmentRenderer(PieSegmentRenderer pieSegmentRenderer) {
        PieSegmentRenderer pieSegmentRenderer2 = this.\u014b;
        this.\u014b = pieSegmentRenderer;
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_PIE_SEGMENT_RENDERER, pieSegmentRenderer2, pieSegmentRenderer);
    }

    public LineRenderer getLineRenderer() {
        return this.\u015f;
    }

    public void setLineRenderer(LineRenderer lineRenderer) {
        LineRenderer lineRenderer2 = this.\u015f;
        this.\u015f = lineRenderer;
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_LINE_RENDERER, lineRenderer2, lineRenderer);
    }

    public void setBarGap(int n2) {
        int n3 = this.\u017e.\u010b();
        this.\u017e.\u0103(n2);
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_BAR_GAP, n3, n2);
    }

    public int getBarGap() {
        return this.\u017e.\u010b();
    }

    public void setMaxBarWidth(int n2) {
        int n3 = this.\u017e.\u0108();
        this.\u017e.\u0102(n2);
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_MAX_BAR_WIDTH, n3, n2);
    }

    public int getMaxBarWidth() {
        return this.\u017e.\u0108();
    }

    public int getBarGroupGap() {
        return this.\u017e.\u0106();
    }

    public void setBarGroupGap(int n2) {
        int n3 = this.\u017e.\u0106();
        this.\u017e.\u0101(n2);
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_BAR_GROUP_GAP, n3, n2);
    }

    public void setBarGroupGapProportion(Double d2) {
        Double d3 = this.\u017e.\u0105();
        this.\u017e.\u0101(d2);
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_BAR_GROUP_GAP, d3, d2);
    }

    public void setBarsGrouped(boolean bl) {
        boolean bl2 = this.\u017e.\u0107();
        this.\u017e.\u0101(bl);
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_BARS_GROUPED, bl2, bl);
    }

    public boolean isBarsGrouped() {
        return this.\u017e.\u0107();
    }

    public void setBarResizePolicy(BarResizePolicy barResizePolicy) {
        this.\u017e.\u0101(barResizePolicy);
    }

    public BarResizePolicy getBarResizePolicy() {
        return this.\u017e.\u010a();
    }

    private boolean \u010d() {
        return this.\u0184;
    }

    private void \u0101(boolean bl) {
        boolean bl2 = this.\u0184;
        this.\u0184 = bl;
        if (!bl2 && bl && this.isLazyRendering()) {
            this.\u0141.updateCharts(false);
        }
    }

    public boolean isHighQuality() {
        return this.\u0190;
    }

    public void setHighQuality(boolean bl) {
        boolean bl2 = this.\u0190;
        this.\u0190 = bl;
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_HIGH_QUALITY, bl2, bl);
    }

    public boolean isVerticalGridLinesVisible() {
        return this.\u013f;
    }

    public boolean isVerticalMinorGridLinesVisible() {
        return this.\u018c;
    }

    public void setVerticalMinorGridLinesVisible(boolean bl) {
        boolean bl2 = this.\u018c;
        this.\u018c = bl;
        this.firePropertyChange(PROPERTY_VERTICAL_MINOR_GRID_LINES_VISIBLE, bl2, bl);
    }

    public void setVerticalGridLinesVisible(boolean bl) {
        boolean bl2 = this.\u013f;
        this.\u013f = bl;
        this.firePropertyChange(PROPERTY_VERTICAL_GRID_LINES_VISIBLE, bl2, bl);
    }

    public boolean isHorizontalGridLinesVisible() {
        return this.\u0149;
    }

    public boolean isHorizontalMinorGridLinesVisible() {
        return this.\u016c;
    }

    public void setHorizontalGridLinesVisible(boolean bl) {
        boolean bl2 = this.\u0149;
        this.\u0149 = bl;
        this.firePropertyChange(PROPERTY_HORIZONTAL_GRID_LINES_VISIBLE, bl2, bl);
    }

    public void setHorizontalMinorGridLinesVisible(boolean bl) {
        boolean bl2 = this.\u016c;
        this.\u016c = bl;
        this.firePropertyChange(PROPERTY_HORIZONTAL_MINOR_GRID_LINES_VISIBLE, bl2, bl);
    }

    public boolean isTitleVisible() {
        return this.\u0158;
    }

    public void setTitleVisible(boolean bl) {
        if (bl == this.\u0158) {
            return;
        }
        boolean bl2 = this.\u0158;
        this.\u0158 = bl;
        this.\u0101(true);
        this.update();
        this.firePropertyChange(PROPERTY_TITLE_VISIBLE, bl2, bl);
    }

    public Font getTickFont() {
        return this.\u016d;
    }

    protected Font getTickFont(Axis axis) {
        Font font = axis.getTickFont();
        return font == null ? this.\u016d : font;
    }

    public void setTickFont(Font font) {
        Font font2 = this.\u016d;
        this.\u016d = font;
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_TICK_FONT, font2, font);
    }

    public Stroke getTickStroke() {
        return this.\u015d;
    }

    public void setTickStroke(Stroke stroke) {
        Stroke stroke2 = this.\u015d;
        this.\u015d = stroke;
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_TICK_STROKE, stroke2, stroke);
    }

    public Color getAxisColor() {
        return this.\u0192;
    }

    public void setAxisColor(Color color) {
        Color color2 = this.\u0192;
        this.\u0192 = color;
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_AXIS_COLOR, color2, color);
    }

    public Color getGridColor() {
        return this.\u0172;
    }

    public void setGridColor(Color color) {
        Color color2 = this.\u0172;
        this.\u0172 = color;
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_GRID_COLOR, color2, color);
    }

    public Color getMinorGridColor() {
        return this.\u0152;
    }

    public void setMinorGridColor(Color color) {
        Color color2 = this.\u0152;
        this.\u0152 = color;
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_MINOR_GRID_COLOR, color2, color);
    }

    public Paint getPanelBackground() {
        return this.\u0157;
    }

    public void setPanelBackground(Paint paint) {
        Paint paint2 = this.\u0157;
        if (paint instanceof Color) {
            Color color = (Color)paint;
            super.setBackground(color);
        }
        this.\u0157 = paint;
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_PANEL_BACKGROUND, paint2, paint);
    }

    @Override
    public void setBackground(Color color) {
        this.setPanelBackground(color);
    }

    public Paint getChartBackground() {
        return this.\u015b;
    }

    public void setChartBackground(Paint paint) {
        Paint paint2 = this.\u015b;
        this.\u015b = paint;
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_CHART_BACKGROUND, paint2, paint);
    }

    public Border getChartBorder() {
        return this.\u015a;
    }

    public void setChartBorder(Border border) {
        Border border2 = this.\u015a;
        this.\u015a = border;
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_CHART_BORDER, border2, border);
    }

    public UserToPixelTransform getUserToPixelTransform() {
        this.\u0180.lock();
        try {
            assert (this.\u014d != null);
            UserToPixelTransform userToPixelTransform = this.\u014d.size() > 0 ? this.\u014d.get(0) : null;
            return userToPixelTransform;
        }
        finally {
            this.\u0180.unlock();
        }
    }

    public boolean isAntiAliasing() {
        return this.\u0176;
    }

    public void setAntiAliasing(boolean bl) {
        boolean bl2 = this.\u0176;
        this.\u0176 = bl;
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_ANTI_ALIASING, bl2, bl);
    }

    public boolean isAllowTickLabelOverlap() {
        return this.\u0183;
    }

    public void setAllowTickLabelOverlap(boolean bl) {
        boolean bl2 = this.\u0183;
        this.\u0183 = bl;
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_ALLOW_TICK_LABEL_OVERLAP, bl2, bl);
    }

    public boolean isAutoRanging() {
        return this.\u014a;
    }

    public void setAutoRanging(boolean bl) {
        boolean bl2 = this.\u014a;
        this.\u014a = bl;
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_AUTO_RANGING, bl2, bl);
    }

    public void setAutoRanger(AutoRanger autoRanger) {
        this.\u0175 = autoRanger;
    }

    public AutoRanger getAutoRanger() {
        return this.\u0175;
    }

    public boolean isLabellingTraces() {
        return this.\u016e;
    }

    public void setLabellingTraces(boolean bl) {
        boolean bl2 = this.\u016e;
        this.\u016e = bl;
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_LABELLING_TRACES, bl2, bl);
    }

    public Chart addMouseZoomer() {
        return this.addMouseZoomer(true, true);
    }

    public Chart addMouseZoomer(boolean bl, boolean bl2) {
        if (this.\u016f != null) {
            this.removeMouseZoomer();
        }
        this.\u016f = new MouseWheelZoomer(this, bl, bl2);
        this.addMouseWheelListener(this.\u016f);
        this.addMouseMotionListener(this.\u016f);
        return this;
    }

    public Chart removeMouseZoomer() {
        if (this.\u016f != null) {
            this.removeMouseWheelListener(this.\u016f);
            this.removeMouseMotionListener(this.\u016f);
        }
        return this;
    }

    public Chart addMousePanner() {
        return this.addMousePanner(true, true);
    }

    public Chart addMousePanner(boolean bl, boolean bl2) {
        if (this.\u0171 != null) {
            this.removeMousePanner();
        }
        this.\u0171 = new MouseDragPanner(this, bl, bl2);
        this.addMouseListener(this.\u0171);
        this.addMouseMotionListener(this.\u0171);
        return this;
    }

    public Chart removeMousePanner() {
        if (this.\u0171 != null) {
            this.removeMouseListener(this.\u0171);
            this.removeMouseMotionListener(this.\u0171);
        }
        return this;
    }

    public void setRolloverEnabled(boolean bl) {
        boolean bl2 = this.\u017a.\u0101();
        this.\u017a.\u0101(bl);
        this.firePropertyChange(PROPERTY_ROLLOVER_VISIBLE, bl2, bl);
    }

    public boolean isRolloverEnabled() {
        return this.\u017a.\u0101();
    }

    public void setSelectionEnabled(boolean bl) {
        boolean bl2 = this.\u017a.\u0104();
        this.\u017a.\u0102(bl);
        this.firePropertyChange(PROPERTY_SELECTABLE, bl2, bl);
    }

    public boolean isSelectionEnabled() {
        return this.\u017a.\u0104();
    }

    public boolean isSelectionShowsExplodedSegments() {
        return this.\u0188;
    }

    public void setSelectionShowsExplodedSegments(boolean bl) {
        boolean bl2 = this.\u0188;
        this.\u0188 = bl;
        this.firePropertyChange(PROPERTY_SELECTION_SHOWS_EXPLODED_SEGMENTS, bl2, bl);
    }

    public boolean isSelectionShowsOutline() {
        return this.\u018e;
    }

    public void setSelectionShowsOutline(boolean bl) {
        boolean bl2 = this.\u018e;
        this.\u018e = bl;
        this.firePropertyChange(PROPERTY_SELECTION_SHOWS_OUTLINE, bl2, bl);
    }

    public void addDoubleClickListener(ActionListener actionListener) {
        this.\u017a.\u0101(actionListener);
    }

    public void removeDoubleClickListener(ActionListener actionListener) {
        this.\u017a.\u0102(actionListener);
    }

    public void setSelectionButton(int n2) {
        this.\u017a.\u0101(n2);
    }

    @Override
    public void chartModelChanged() {
        this.autoRange();
        this.update();
    }

    @Override
    public void chartModelChanged(ChartModelChangeEvent chartModelChangeEvent) {
        this.autoRange();
        this.update();
    }

    public boolean isShadowVisible() {
        return this.\u0185 == ShadowVisibility.ALL || this.\u0185 == ShadowVisibility.SOME;
    }

    public void setShadowVisible(boolean bl) {
        boolean bl2 = this.isShadowVisible();
        this.\u0185 = bl ? ShadowVisibility.ALL : ShadowVisibility.NONE;
        this.\u0101(true);
        this.update();
        this.firePropertyChange(PROPERTY_SHADOW_VISIBLE, bl2, bl);
    }

    public ShadowVisibility getShadowVisibility() {
        return this.\u0185;
    }

    public void setShadowVisibility(ShadowVisibility shadowVisibility) {
        ShadowVisibility shadowVisibility2 = this.\u0185;
        this.\u0185 = shadowVisibility;
        this.\u0101(true);
        this.update();
        this.firePropertyChange(PROPERTY_SHADOW_VISIBILITY, (Object)shadowVisibility2, (Object)shadowVisibility);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShadowVisible(ChartModel chartModel, boolean bl) {
        Map<String, ChartModel> map = this.\u0169;
        synchronized (map) {
            String string = chartModel.getName();
            ChartModel chartModel2 = this.\u0169.get(string);
            if (bl) {
                if (chartModel2 == null) {
                    this.\u0169.put(string, chartModel);
                }
            } else {
                this.\u0169.remove(string);
            }
        }
        this.\u0101(true);
        this.update();
    }

    public boolean isShadowVisible(ChartModel chartModel) {
        String string = chartModel.getName();
        ChartModel chartModel2 = this.\u0169.get(string);
        return chartModel2 != null;
    }

    public void autoRange() {
        if (this.isAutoRanging() && this.\u0175 != null) {
            if (this.\u0175 instanceof MultiAutoRanger) {
                MultiAutoRanger multiAutoRanger = (MultiAutoRanger)this.\u0175;
                Map<Axis, Range<?>> map = multiAutoRanger.getAxisRanges(this);
                if (map != null) {
                    for (Map.Entry<Axis, Range<?>> entry : map.entrySet()) {
                        Axis axis = entry.getKey();
                        Range<?> range = entry.getValue();
                        if (range == null) continue;
                        axis.setRange(range, false);
                    }
                }
            } else {
                Axis axis;
                Pair<Range<?>, Range<?>> pair = this.\u0175.getRanges(this);
                Range<?> range = pair.getFirst();
                Range<?> range2 = pair.getSecond();
                if (range != null && this.\u0174 != null) {
                    this.\u0174.setRange(range);
                }
                if (range2 != null && (axis = this.getYAxis()) != null) {
                    axis.setRange(range2);
                }
            }
            this.update();
        }
    }

    public void update() {
        this.update(true);
    }

    protected void update(boolean bl) {
        Container container;
        Axis axis;
        AxisRenderer axisRenderer;
        this.\u0108();
        this.\u0109();
        AxisRenderer axisRenderer2 = this.\u0174 == null ? null : this.\u0174.getAxisRenderer();
        int n2 = this.\u017e.\u0103(this);
        if (axisRenderer2 != null) {
            axisRenderer2.setBreadth(n2);
        }
        AxisRenderer axisRenderer3 = axisRenderer = (axis = this.getYAxis()) == null ? null : axis.getAxisRenderer();
        if (axisRenderer != null) {
            axisRenderer.setBreadth(n2);
        }
        this.\u0108();
        this.\u0109();
        Dimension dimension = this.getSize();
        if (this.isShadowVisible() && dimension.width > 0 && dimension.height > 0) {
            int n3;
            int n4 = this.\u0140 == null ? 0 : this.\u0140.getWidth();
            int n5 = n3 = this.\u0140 == null ? 0 : this.\u0140.getHeight();
            if (n4 != dimension.width || n3 != dimension.height) {
                this.\u0140 = new BufferedImage(dimension.width, dimension.height, 2);
                if (this.\u0155 == ChartType.PIE) {
                    this.\u018a = new BufferedImage(dimension.width, dimension.height, 2);
                }
            }
        }
        if (bl) {
            this.\u0101(true);
        }
        if ((container = this.getParent()) != null) {
            container.repaint();
        }
        this.revalidate();
        this.repaint();
    }

    public void drawInBackground() {
        if (this.isLazyRendering() && this.\u010d()) {
            this.\u0141.updateCharts(false);
        }
        this.\u0101(false);
        super.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("range".equals(string) || "max".equals(string) || "min".equals(string)) {
            this.update();
        } else if ("updateOtherAxes".equals(string)) {
            Object object = propertyChangeEvent.getSource();
            Object object2 = propertyChangeEvent.getOldValue();
            Object object3 = propertyChangeEvent.getNewValue();
            Axis axis = this.getYAxis();
            Axis axis2 = (Axis)object;
            if (axis != null && axis.equals(object)) {
                Range range = (Range)object2;
                Range range2 = (Range)object3;
                double d2 = (range2.minimum() - range.minimum()) / range.size();
                double d3 = (range2.maximum() - range.minimum()) / range.size();
                for (Axis axis3 : this.\u0147) {
                    if (axis3.equals(axis2)) continue;
                    Range<?> range3 = axis3.getRange();
                    NumericRange numericRange = new NumericRange(d2 * range3.size() + range3.minimum(), d3 * range3.size() + range3.minimum());
                    axis3.setRange(numericRange, false);
                }
            }
            this.update();
        } else if ("label".equals(string)) {
            this.repaint();
        }
    }

    public Chart addDrawable(Drawable drawable) {
        if (drawable == null) {
            return this;
        }
        this.\u014c.add(drawable);
        if (!drawable.equals(this.\u0141)) {
            this.invalidate();
            this.repaint();
        }
        return this;
    }

    public Chart removeDrawable(Drawable drawable) {
        if (drawable != null && !drawable.equals(this.\u0141)) {
            this.\u014c.remove(drawable);
            this.repaint();
        }
        return this;
    }

    public Chart removeDrawables() {
        this.\u014c.clear();
        this.\u014c.add(this.\u0141);
        this.repaint();
        return this;
    }

    public boolean containsDrawable(Drawable drawable) {
        return this.\u014c.contains(drawable);
    }

    public Collection<Drawable> getDrawables() {
        return this.\u014c;
    }

    void \u010b() {
        this.\u0145.\u0101();
        this.\u017e.\u0109();
        this.\u0153.\u0104();
    }

    int \u0101(Axis axis) {
        return this.axisWidth(this.getGraphics(), axis);
    }

    public int getAxisLabelPadding() {
        return this.\u0142;
    }

    public void setAxisLabelPadding(int n2) {
        this.\u0142 = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int axisWidth(Graphics graphics, Axis axis) {
        int n2;
        if (!axis.isVisible()) {
            return 0;
        }
        int n3 = axis.isVisible() && axis.isTicksVisible() ? this.getTickLength() : 0;
        Font font = this.getTickFont(axis);
        int n4 = n2 = axis.getLabel() == null ? 0 : this.\u0142;
        if (graphics == null) {
            Graphics graphics2 = null;
            try {
                BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
                graphics2 = bufferedImage.getGraphics();
                if (axis == this.\u0174) {
                    int n5 = axis.labelWidth(graphics2, font, Orientation.horizontal);
                    int n6 = n3 + 2 * n2 + n5;
                    return n6;
                }
                int n7 = axis.labelWidth(graphics2, font, Orientation.vertical);
                int n8 = n3 + 2 * n2 + n7;
                return n8;
            }
            finally {
                if (graphics2 != null) {
                    graphics2.dispose();
                }
            }
        }
        if (axis == this.\u0174) {
            int n9 = axis.labelWidth(graphics, font, Orientation.horizontal);
            return n3 + 2 * n2 + n9;
        }
        int n10 = axis.labelWidth(graphics, font, Orientation.vertical);
        return n3 + 2 * n2 + n10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int titleHeight() {
        Object object;
        if (this.\u014f == null || "".equals(this.\u014f.getLabel()) || !this.\u0158) {
            return 0;
        }
        Graphics graphics = this.getGraphics();
        Graphics graphics2 = null;
        if (graphics == null) {
            object = new BufferedImage(1, 1, 2);
            graphics = graphics2 = ((BufferedImage)object).getGraphics();
        }
        try {
            object = this.\u014f;
            FontMetrics fontMetrics = graphics.getFontMetrics(((AbstractLabel)object).getFont());
            int n2 = 2 * fontMetrics.getHeight();
            return n2;
        }
        finally {
            if (graphics2 != null) {
                graphics2.dispose();
            }
        }
    }

    int \u0104() {
        Insets insets = this.getInsets();
        int n2 = insets == null ? 0 : insets.left;
        for (Axis axis : this.\u0147) {
            if (axis.getPlacement() != AxisPlacement.LEADING) continue;
            int n3 = this.\u0101(axis);
            n2 += n3;
        }
        return n2;
    }

    int \u0105() {
        Insets insets = this.getInsets();
        int n2 = insets == null ? 0 : insets.right;
        for (Axis axis : this.\u0147) {
            if (axis.getPlacement() != AxisPlacement.TRAILING) continue;
            n2 += this.\u0101(axis);
        }
        return n2;
    }

    int \u0106() {
        int n2;
        Insets insets = this.getInsets();
        int n3 = n2 = insets == null ? 0 : insets.top;
        if (this.\u0174.getPlacement() == AxisPlacement.TRAILING) {
            return n2 + this.\u0101(this.getXAxis());
        }
        return n2;
    }

    int \u0107() {
        int n2;
        Insets insets = this.getInsets();
        int n3 = n2 = insets == null ? 0 : insets.bottom;
        int n4 = this.\u0174.getPlacement() == AxisPlacement.FLOATING ? n2 : (this.\u0174.getPlacement() == AxisPlacement.TRAILING ? n2 : (this.\u0174.getPlacement() == AxisPlacement.CENTER ? n2 : n2 + this.\u0101(this.\u0174)));
        return n4;
    }

    public int getXStart() {
        return this.\u0193;
    }

    public int getXEnd() {
        return this.\u016b;
    }

    public int getChartWidth() {
        int n2 = this.\u016b - this.\u0193;
        return n2 < 0 ? 0 : n2;
    }

    public int getYStart() {
        return this.\u0146;
    }

    public int getYEnd() {
        return this.\u0170;
    }

    public int getChartHeight() {
        int n2 = this.\u0146 - this.\u0170;
        return n2 < 0 ? 0 : n2;
    }

    public double getYSum(ChartModel chartModel) {
        double d2 = 0.0;
        if (chartModel != null) {
            for (int i2 = 0; i2 < chartModel.getPointCount(); ++i2) {
                Chartable chartable = chartModel.getPoint(i2);
                d2 += chartable.getY().position();
            }
        }
        return d2;
    }

    private void \u0108() {
        Axis axis;
        int n2;
        int n3;
        Dimension dimension = this.getSize();
        int n4 = this.\u0104();
        Axis axis2 = this.getYAxis();
        int n5 = n3 = axis2 == null || axis2.getAxisRenderer() == null ? 0 : axis2.getAxisRenderer().getBreadth();
        if (axis2 != null) {
            int n6 = axis2.getPlacement() == AxisPlacement.LEADING ? n3 / 2 : 1;
            n2 = axis2.getPlacement() == AxisPlacement.TRAILING ? n3 / 2 : 1;
            this.\u0193 = dimension.width == 0 ? 0 : n4 + n6;
            this.\u016b = dimension.width == 0 ? 0 : dimension.width - this.\u0105() - n2;
        }
        int n7 = n2 = (axis = this.getXAxis()) == null || axis.getAxisRenderer() == null ? 0 : axis.getAxisRenderer().getBreadth();
        if (axis != null) {
            int n8 = axis.getPlacement() == AxisPlacement.LEADING ? n2 / 2 : 1;
            int n9 = axis.getPlacement() == AxisPlacement.TRAILING ? n2 / 2 : 1;
            this.\u0146 = dimension.height == 0 ? 0 : dimension.height - this.\u0107() - n8;
            this.\u0170 = dimension.height == 0 ? 0 : this.\u0106() + this.titleHeight() + n9;
        }
    }

    public int getTickLength() {
        return this.\u0174 == null ? 0 : this.\u0174.getTickLength();
    }

    public void setTickLength(int n2) {
        int n3 = this.getTickLength();
        if (this.\u0174 != null) {
            this.\u0174.setTickLength(n2);
        }
        for (Axis axis : this.\u0147) {
            if (axis == null) continue;
            axis.setTickLength(n2);
        }
        this.update();
        this.firePropertyChange(PROPERTY_TICK_LENGTH, n3, n2);
    }

    public int getMinorTickLength() {
        return this.\u0174 == null ? 0 : this.\u0174.getMinorTickLength();
    }

    public void setMinorTickLength(int n2) {
        int n3 = this.getMinorTickLength();
        if (this.\u0174 != null) {
            this.\u0174.setMinorTickLength(n2);
        }
        for (Axis axis : this.\u0147) {
            if (axis == null) continue;
            axis.setMinorTickLength(n2);
        }
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_MINOR_TICK_LENGTH, n3, n2);
    }

    public Color getTickColor() {
        return this.\u0179;
    }

    public void setTickColor(Color color) {
        Color color2 = this.\u0179;
        this.\u0179 = color;
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_TICK_COLOR, color2, color);
    }

    public Color getLabelColor() {
        return this.\u015c;
    }

    public void setLabelColor(Color color) {
        Color color2 = this.\u015c;
        this.\u015c = color;
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_LABEL_COLOR, color2, color);
    }

    private void \u0102(Axis axis, boolean bl) {
        Axis axis2 = this.\u0174;
        if (this.\u0174 != null) {
            this.\u0174.removePropertyChangeListener(this);
        }
        this.\u0174 = axis;
        if (bl) {
            this.update();
        }
        if (this.\u0174 != null) {
            this.\u0174.addPropertyChangeListener(this);
        }
        this.firePropertyChange(PROPERTY_X_AXIS, axis2, axis);
    }

    public void setXAxis(Axis axis) {
        this.\u0102(axis, true);
    }

    public Axis getXAxis() {
        return this.\u0174;
    }

    private void \u0101(Axis axis, boolean bl) {
        assert (this.\u0147 != null);
        for (Axis axis2 : this.\u0147) {
            axis2.removePropertyChangeListener(this);
        }
        this.\u0147.clear();
        if (axis != null) {
            if (axis.getPlacement() == null) {
                axis.setPlacement(AxisPlacement.LEADING);
            }
            this.\u0147.add(axis);
        }
        if (bl) {
            this.update();
        }
        if (axis != null) {
            axis.addPropertyChangeListener(this);
        }
        this.firePropertyChange(PROPERTY_Y_AXIS, null, axis);
    }

    public void setYAxis(Axis axis) {
        this.\u0101(axis, true);
    }

    public Chart addYAxis(Axis axis) {
        assert (this.\u0147 != null);
        assert (axis != null);
        this.\u0147.add(axis);
        this.update();
        axis.addPropertyChangeListener(this);
        return this;
    }

    public Axis getYAxis() {
        assert (this.\u0147 != null);
        if (this.\u0147.size() == 0) {
            return null;
        }
        return this.\u0147.get(0);
    }

    public Axis getYAxis(int n2) {
        return this.\u0147.get(n2);
    }

    public int getYAxisCount() {
        if (this.\u0147 == null) {
            return 0;
        }
        return this.\u0147.size();
    }

    public void setTitle(String string) {
        AutoPositionedLabel autoPositionedLabel = new AutoPositionedLabel(string);
        this.setTitle(autoPositionedLabel);
    }

    public AbstractAnnotation getTitle() {
        return this.\u014f;
    }

    public void setTitle(AbstractLabel abstractLabel) {
        AbstractLabel abstractLabel2 = this.\u014f;
        this.\u014f = abstractLabel;
        this.repaint();
        this.firePropertyChange(PROPERTY_TITLE, abstractLabel2, abstractLabel);
    }

    public int getLazyRenderingThreshold() {
        return this.\u0151;
    }

    public void setLazyRenderingThreshold(int n2) {
        int n3 = this.\u0151;
        if (n2 < 0) {
            throw new IllegalArgumentException("Threshold must be >= 0");
        }
        this.\u0151 = n2;
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_LAZY_RENDERING_THRESHOLD, n3, n2);
    }

    public E<ChartModel> getLazyChartRenderer() {
        return this.\u0141;
    }

    public void setLazyChartRenderer(E<ChartModel> e2) {
        this.setLazyChartRenderer(e2, true);
    }

    public void setLazyChartRenderer(E<ChartModel> e2, boolean bl) {
        if (this.\u0141 != null) {
            this.removeDrawable(this.\u0141);
            this.\u0141.removeImageChangeListener(this.\u0162);
        }
        this.\u0141 = e2;
        this.addDrawable(e2);
        e2.addImageChangeListener(this.\u0162);
        e2.updateCharts(true);
    }

    public boolean isLazyRendering() {
        return this.getLazyRenderingThreshold() <= 0 || this.pointCount() >= this.getLazyRenderingThreshold();
    }

    private void \u0101(ChartModel chartModel) {
        if (chartModel == null) {
            throw new NullPointerException("You cannot add a NULL ChartModel to a chart");
        }
        String string = chartModel.getName();
        if (string == null) {
            throw new NullPointerException("You cannot add a chart model without a name to a chart");
        }
        ArrayList<ChartModel> arrayList = new ArrayList<ChartModel>(this.\u015e);
        assert (!this.\u015e.contains(chartModel)) : String.format("Chart '%s' already contains a model with name '%s'", this.getName(), chartModel.getName());
        for (ChartModel chartModel2 : this.\u015e) {
            if (!chartModel2.getName().equals(chartModel.getName())) continue;
            throw new IllegalArgumentException("ChartModel " + chartModel2.getName() + " already exists!");
        }
        this.\u015e.add(chartModel);
        if (this.isLazyRendering()) {
            this.\u0101(true);
        }
        this.autoRange();
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        this.\u0187.put(chartModel, defaultListSelectionModel);
        chartModel.addChartModelListener(this);
        this.firePropertyChange(PROPERTY_MODEL, arrayList, this.\u015e);
    }

    public void setModel(ChartModel chartModel) {
        ChartModel chartModel2 = this.\u015e.size() > 0 ? this.\u015e.get(0) : null;
        this.removeModels();
        this.addModel(chartModel);
        this.firePropertyChange(PROPERTY_MODEL, chartModel2, chartModel);
    }

    public void setModel(ChartModel chartModel, ChartStyle chartStyle) {
        ChartModel chartModel2 = this.\u015e.size() > 0 ? this.\u015e.get(0) : null;
        this.removeModels();
        this.addModel(chartModel, chartStyle);
        this.firePropertyChange(PROPERTY_MODEL, chartModel2, chartModel);
    }

    public Chart addModel(ChartModel chartModel) {
        this.addModel(chartModel, true);
        return this;
    }

    public Chart addModel(ChartModel chartModel, boolean bl) {
        this.\u0101(chartModel);
        if (!this.isLazyRendering() && bl) {
            this.\u0101(true);
            this.repaint();
        }
        return this;
    }

    public Chart addModel(ChartModel chartModel, ChartStyle chartStyle) {
        return this.addModel(chartModel, null, chartStyle);
    }

    public Chart addModel(ChartModel chartModel, Axis axis) {
        return this.addModel(chartModel, axis, null);
    }

    public Chart addModel(ChartModel chartModel, Axis axis, ChartStyle chartStyle) {
        if (chartModel == null) {
            throw new NullPointerException("You cannot add a NULL ChartModel to a chart");
        }
        String string = chartModel.getName();
        if (string == null) {
            throw new NullPointerException("You cannot add an unnamed ChartModel to a chart");
        }
        if (chartStyle != null) {
            this.\u018f.put(chartModel.getName(), chartStyle);
        }
        this.\u0101(chartModel);
        if (axis != null) {
            this.setModelAxis(chartModel, axis);
        }
        if (!this.isLazyRendering()) {
            this.\u0101(true);
            this.repaint();
        }
        return this;
    }

    public ChartModel getModel() {
        if (this.\u015e == null || this.\u015e.size() == 0) {
            return null;
        }
        return this.\u015e.get(0);
    }

    public ChartModel getModel(int n2) {
        if (this.\u015e == null || this.\u015e.size() == 0) {
            return null;
        }
        return this.\u015e.get(n2);
    }

    public ChartModel getModel(String string) {
        for (ChartModel chartModel : this.\u015e) {
            if (!string.equals(chartModel.getName())) continue;
            return chartModel;
        }
        return null;
    }

    public List<ChartModel> getModels() {
        return this.\u015e;
    }

    public int modelCount() {
        return this.\u015e == null ? 0 : this.\u015e.size();
    }

    public int pointCount() {
        int n2 = 0;
        for (ChartModel chartModel : this.\u015e) {
            n2 += chartModel.getPointCount();
        }
        return n2;
    }

    public void setModelAxis(ChartModel chartModel, Axis axis) {
        this.\u0178.put(chartModel, axis);
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_Y_AXIS, null, axis);
    }

    public Axis getAxisForModel(ChartModel chartModel) {
        Axis axis = this.\u0178.get(chartModel);
        return axis == null ? this.getYAxis() : axis;
    }

    public ListSelectionModel getSelectionsForModel(ChartModel chartModel) {
        return this.\u0187.get(chartModel);
    }

    public void setSelectionsForModel(ChartModel chartModel, ListSelectionModel listSelectionModel) {
        this.\u0187.put(chartModel, listSelectionModel);
    }

    public UserToPixelTransform getTransformForModel(ChartModel chartModel) {
        Axis axis = this.getAxisForModel(chartModel);
        assert (axis != null);
        return this.getTransformForAxis(axis);
    }

    public void setStyle(ChartModel chartModel, ChartStyle chartStyle) {
        this.setStyle(chartModel, chartStyle, true);
    }

    public void setStyle(ChartModel chartModel, ChartStyle chartStyle, boolean bl) {
        ChartStyle chartStyle2 = this.\u018f.get(chartModel.getName());
        this.\u018f.put(chartModel.getName(), chartStyle);
        if (bl) {
            if (this.isLazyRendering()) {
                this.\u0141.updateImage(chartModel, true);
            } else {
                this.\u0101(true);
                this.repaint();
            }
            this.firePropertyChange(PROPERTY_CHART_STYLE, chartStyle2, chartStyle);
        }
    }

    public ChartStyle getStyle(ChartModel chartModel) {
        assert (chartModel != null);
        String string = chartModel.getName();
        if (string == null) {
            throw new NullPointerException("Unnamed Model " + chartModel);
        }
        return this.\u018f.get(string);
    }

    public void setHighlightStyle(Highlight highlight, ChartStyle chartStyle) {
        if (chartStyle == null) {
            this.\u0148.remove(highlight);
        } else {
            this.\u0148.put(highlight, chartStyle);
        }
        this.\u0101(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_HIGHLIGHT_STYLE, null, chartStyle);
    }

    public ChartStyle getHighlightStyle(Highlight highlight) {
        return this.\u0148.get(highlight);
    }

    public Chart clearHighlights() {
        this.\u0148.clear();
        this.repaint();
        return this;
    }

    public boolean containsModel(ChartModel chartModel) {
        return this.\u015e.contains(chartModel);
    }

    public Chart removeModel(ChartModel chartModel) {
        assert (chartModel != null) : "Supplied ChartModel cannot be null";
        ArrayList<ChartModel> arrayList = new ArrayList<ChartModel>(this.\u015e);
        chartModel.removeChartModelListener(this);
        int n2 = this.\u015e.size();
        this.\u015e.remove(chartModel);
        this.\u0160.remove(chartModel);
        assert (this.\u015e.size() == n2 - 1) : "Unable to remove model. Was it named?";
        this.\u0178.remove(chartModel);
        String string = chartModel.getName();
        this.\u017f.remove(string);
        this.\u0150.remove(string);
        this.\u0154.remove(string);
        this.\u018f.remove(string);
        this.\u0187.remove(chartModel);
        this.\u0169.remove(string);
        if (!this.isLazyRendering()) {
            this.\u0101(true);
            this.repaint();
        } else {
            this.\u0141.removeImage(chartModel);
            this.\u0141.updateCharts(false);
        }
        this.firePropertyChange(PROPERTY_MODEL, arrayList, this.\u015e);
        return this;
    }

    public Chart replaceModel(ChartModel chartModel, ChartModel chartModel2) {
        String string = chartModel.getName();
        if (!string.equals(chartModel2.getName())) {
            throw new IllegalArgumentException("The names of the old and new chart models must be the same");
        }
        chartModel.removeChartModelListener(this);
        int n2 = this.\u015e.indexOf(chartModel);
        if (n2 < 0) {
            throw new IllegalArgumentException("Cannot find model " + string + " in chart");
        }
        ArrayList<ChartModel> arrayList = new ArrayList<ChartModel>(this.\u015e);
        this.\u015e.set(n2, chartModel2);
        Axis axis = this.\u0178.get(chartModel);
        this.\u0178.remove(chartModel);
        this.\u0178.put(chartModel2, axis);
        this.\u0187.remove(chartModel);
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        this.\u0187.put(chartModel2, defaultListSelectionModel);
        chartModel2.addChartModelListener(this);
        this.\u0101(true);
        if (!this.isLazyRendering()) {
            this.repaint();
        }
        this.firePropertyChange(PROPERTY_MODEL, arrayList, this.\u015e);
        return this;
    }

    public Chart removeModels() {
        this.\u0141.cancelDrawing();
        ArrayList<ChartModel> arrayList = new ArrayList<ChartModel>(this.getModels());
        for (ChartModel chartModel : arrayList) {
            this.removeModel(chartModel);
        }
        this.\u0160.clear();
        assert (this.\u015e.size() == 0) : String.format("Chart " + this.getName() + " still has %d models", this.\u015e.size());
        return this;
    }

    private Color \u0101(Component component) {
        Container container = component.getParent();
        if (container == null) {
            return null;
        }
        Color color = container.getBackground();
        if (color == null) {
            return this.\u0101(container);
        }
        return color;
    }

    private boolean \u0101(Drawable drawable) {
        if (drawable instanceof ZOrder) {
            ZOrder zOrder = (ZOrder)((Object)drawable);
            return zOrder.getZOrder() < 0;
        }
        return false;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Object object;
        Object object3;
        Rectangle rectangle;
        this.\u0108();
        if (!this.\u014e) {
            this.autoRange();
            this.update();
            if (this.isAnimateOnShow()) {
                this.setAnimationPosition(0.0);
                this.startAnimation();
            } else {
                this.setAnimationPosition(1.0);
            }
            this.\u014e = true;
        }
        Rectangle rectangle2 = this.getVisibleRect();
        int n2 = rectangle2.width;
        int n3 = rectangle2.height;
        if (this.isLazyRendering() && this.\u010d() && n2 > 0 && n3 > 0) {
            this.\u0101(false);
            this.\u0141.updateCharts(false);
        }
        this.\u0184 = false;
        if (this.\u0193 == this.\u016b) {
            return;
        }
        ChartUtils.clearBufferedImage(this.\u0140, this.getBackground());
        if (this.\u0155 == ChartType.PIE) {
            ChartUtils.clearBufferedImage(this.\u018a, this.getBackground());
        }
        Graphics2D graphics2D = this.\u0140 == null ? null : this.\u0140.createGraphics();
        Graphics2D graphics2D2 = this.\u018a == null ? null : this.\u018a.createGraphics();
        Graphics2D graphics2D3 = (Graphics2D)graphics;
        Shape shape = graphics2D3.getClip();
        Rectangle rectangle3 = rectangle = shape == null ? new Rectangle(0, 0, 0, 0) : shape.getBounds();
        if (!this.isEnabled()) {
            if (this.\u018d == null || this.\u018d.getWidth() != this.getWidth() || this.\u018d.getHeight() != this.getHeight()) {
                this.\u018d = new BufferedImage(this.getWidth(), this.getHeight(), 2);
                graphics2D3 = this.\u018d.createGraphics();
            } else {
                graphics2D3 = this.\u018d.createGraphics();
                graphics2D3.setColor(new Color(0, 0, 0, 0));
                graphics2D3.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
        if (graphics2D != null) {
            graphics2D.setFont(this.getFont());
        }
        graphics2D3.setFont(this.getFont());
        if (this.\u0176) {
            graphics2D3.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (graphics2D != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            if (graphics2D2 != null) {
                graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
        } else {
            graphics2D3.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D3.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (graphics2D != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (graphics2D2 != null) {
                graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics2D2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
        }
        Paint paint = graphics2D3.getPaint();
        Color color = UIManager.getColor("Chart.disabledBackground");
        Paint paint2 = this.isEnabled() || color == null ? this.\u0157 : color;
        graphics2D3.setPaint(paint2);
        if (this.isOpaque()) {
            graphics2D3.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        Rectangle2D rectangle2D = graphics2D3.getClipBounds();
        int n4 = 0;
        int n5 = 0;
        if (this.\u0155 == ChartType.PIE) {
            if (this.\u015b != null) {
                object3 = this.getInsets();
                graphics2D3.setPaint(this.\u015b);
                graphics2D3.fillRect(((Insets)object3).left, ((Insets)object3).top, this.getWidth() - ((Insets)object3).left - ((Insets)object3).right, this.getHeight() - ((Insets)object3).top - ((Insets)object3).bottom);
            }
        } else {
            object3 = this.\u015b == null ? Color.white : this.\u015b;
            graphics2D3.setPaint((Paint)object3);
            graphics2D3.fillRect(this.\u0193, this.\u0170, this.getXEnd() - this.\u0193, this.\u0146 - this.\u0170);
            AxisRenderer object22 = this.\u0174 == null ? null : this.\u0174.getAxisRenderer();
            n4 = object22 == null ? 0 : object22.getBreadth();
            object = this.getYAxis();
            AxisRenderer axisRenderer = object == null ? null : ((Axis)object).getAxisRenderer();
            n5 = axisRenderer == null ? 0 : axisRenderer.getBreadth();
            int n6 = this.\u0193 - n5 / 2 + 1;
            Rectangle rectangle4 = new Rectangle(n6, this.\u0170, this.getXEnd() - n6, this.\u0146 - this.\u0170 + n4 / 2);
            rectangle2D = rectangle.createIntersection(rectangle4);
            graphics2D3.setClip(rectangle2D);
        }
        if (this.\u0155 == ChartType.PIE) {
            graphics2D3.setClip(shape);
            this.\u018b.\u0101(graphics2D2);
            object3 = this.getModel();
            Graphics2D graphics2D4 = this.\u0101(graphics2D3, graphics2D);
            if (graphics2D4 != null && object3 != null) {
                this.\u018b.\u0101(graphics2D4, this, (ChartModel)object3, 0, null, false);
            }
        } else {
            graphics2D3.setClip(rectangle2D);
            for (Drawable drawable : this.\u014c) {
                if (!this.\u0101(drawable) || (object = (Frontable)((Object)drawable)).isAtFront()) continue;
                drawable.draw(graphics2D3);
                this.\u0101(graphics2D, drawable);
            }
            graphics2D3.setClip(shape);
            this.paintAxes(graphics2D3);
        }
        this.\u0102(graphics2D3);
        graphics2D3.setClip(rectangle2D);
        for (Drawable drawable : this.\u014c) {
            if (drawable == this.\u0141 || !(drawable instanceof Frontable) || this.\u0101(drawable) || (object = (Frontable)((Object)drawable)).isAtFront()) continue;
            drawable.draw(graphics2D3);
            this.\u0101(graphics2D, drawable);
        }
        this.\u0141.draw(this.\u0101(graphics2D3, graphics2D));
        if (!this.isLazyRendering() && this.\u0155 == ChartType.XY) {
            this.paintModels(graphics2D3, graphics2D, rectangle, rectangle2D);
        }
        if (this.\u0155 != ChartType.PIE) {
            graphics2D3.setClip(rectangle);
            this.paintYAxisLabels(graphics2D3);
            graphics2D3.setClip(rectangle2D);
        }
        if (this.\u0140 != null) {
            object3 = new Rectangle(this.\u0193 + n5 / 2, this.\u0170, (int)((double)(this.getXEnd() - this.\u0193) - (double)n5 / 2.0), (int)((double)(this.\u0146 - this.\u0170) - (double)n4 / 2.0));
            graphics2D3.setClip((Shape)object3);
            if (this.isShadowVisible() && this.\u0156 >= 1.0) {
                BufferedImage bufferedImage = this.\u0161.createShadow(this.\u0140);
                if (this.\u0155 == ChartType.PIE) {
                    graphics.setClip(rectangle);
                }
                graphics2D3.drawImage((Image)bufferedImage, 0, 0, null);
            }
            graphics2D3.setClip(rectangle2D);
            graphics2D3.drawImage((Image)this.\u0140, 0, 0, null);
            if (this.\u018a != null) {
                graphics2D3.drawImage((Image)this.\u018a, 0, 0, null);
            }
        }
        this.paintAnnotations(graphics2D3);
        graphics2D3.setPaint(paint);
        if (this.\u0140 != null && graphics2D != null) {
            graphics2D.dispose();
        }
        for (Drawable drawable : this.\u014c) {
            if (drawable instanceof Frontable) {
                object = (Frontable)((Object)drawable);
                if (!object.isAtFront()) continue;
                drawable.draw(graphics2D3);
                continue;
            }
            drawable.draw(graphics2D3);
        }
        object3 = this.getBounds();
        graphics2D3.setClip(new Rectangle(0, 0, ((Rectangle)object3).width, ((Rectangle)object3).height));
        if (this.\u0155 == ChartType.XY && this.\u015a != null) {
            this.\u015a.paintBorder(this, graphics2D3, this.\u0193, this.\u0170, this.getChartWidth() + 1, this.getChartHeight() + 1);
        }
        if (!this.isEnabled()) {
            if (this.\u0155 == ChartType.PIE) {
                graphics.drawImage(this.\u018d, 0, 0, null);
                Image image = GrayFilter.createDisabledImage(this.\u018d);
                graphics.drawImage(image, 0, 0, null);
            } else {
                graphics.drawImage(this.\u018d, 0, 0, null);
                graphics.setClip(rectangle2D);
                Image image = GrayFilter.createDisabledImage(this.\u018d);
                graphics.drawImage(image, 0, 0, null);
            }
            graphics2D3.dispose();
        }
    }

    private void \u0101(Graphics2D graphics2D, Drawable drawable) {
        if (this.isShadowVisible() && this.\u0156 == 1.0) {
            Shadowable shadowable;
            if (this.\u0185 == ShadowVisibility.ALL) {
                drawable.draw(graphics2D);
            } else if (drawable instanceof Shadowable && graphics2D != null && (shadowable = (Shadowable)((Object)drawable)).isShadowVisible()) {
                drawable.draw(graphics2D);
            }
        }
    }

    private Graphics2D \u0101(Graphics2D graphics2D, Graphics2D graphics2D2) {
        return this.\u0185 == ShadowVisibility.ALL ? graphics2D2 : graphics2D;
    }

    @Override
    public JToolTip createToolTip() {
        final JToolTip jToolTip = super.createToolTip();
        jToolTip.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                Chart.this.repaint(jToolTip.getBounds());
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
        return jToolTip;
    }

    public void paintYAxisTicks(Graphics graphics, Axis axis, Point point, int n2) {
        UserToPixelTransform userToPixelTransform = this.getTransformForAxis(axis);
        this.paintYAxisTicks(graphics, axis, userToPixelTransform, point, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintHorizontalGrid(Graphics graphics, Axis axis, UserToPixelTransform userToPixelTransform) {
        Tick[] tickArray;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Font font = graphics2D.getFont();
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        Font font2 = this.getTickFont(axis);
        graphics2D.setFont(font2);
        for (Tick tick : tickArray = axis.getTicks()) {
            Point2D point2D;
            block4: {
                double d2;
                block5: {
                    point2D = null;
                    try {
                        point2D = this.\u0182.borrow(0.0, tick.getPosition());
                        Point2D point2D2 = this.calculatePixelPoint2D(point2D, userToPixelTransform);
                        if (point2D2 == null) break block4;
                        d2 = point2D2.getY();
                        if (!Double.isInfinite(d2) && !Double.isNaN(d2)) break block5;
                        this.\u0182.replace(point2D);
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.\u0182.replace(point2D);
                        throw throwable;
                    }
                }
                int n2 = (int)d2;
                if (n2 + 1 < this.\u0170 || n2 > this.\u0146 || axis != this.getYAxis() || !tick.isMajor() && !this.isHorizontalMinorGridLinesVisible()) break block4;
                Stroke stroke2 = tick.isMajor() ? this.\u0191 : this.\u0177;
                Color color2 = tick.isMajor() ? this.\u0172 : this.\u0152;
                graphics2D.setStroke(stroke2);
                graphics2D.setColor(color2);
                graphics2D.drawLine(this.\u0193, n2, this.\u016b, n2);
            }
            this.\u0182.replace(point2D);
        }
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintYAxisTicks(Graphics graphics, Axis axis, UserToPixelTransform userToPixelTransform, Point point, int n2) {
        int n3;
        Graphics2D graphics2D = (Graphics2D)graphics;
        AxisPlacement axisPlacement = axis.getPlacement();
        Font font = graphics2D.getFont();
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        Font font2 = this.getTickFont(axis);
        graphics2D.setFont(font2);
        Tick[] tickArray = axis.getTicks();
        Color color2 = this.getTickColor(axis);
        Color color3 = this.getMinorTickColor(axis);
        for (Tick object : tickArray) {
            Point2D n7;
            block11: {
                double d2;
                block12: {
                    int n4 = n3 = object.isMajor() ? axis.getTickLength() : axis.getMinorTickLength();
                    if (n3 <= 0) continue;
                    n7 = null;
                    try {
                        n7 = this.\u0182.borrow(0.0, object.getPosition());
                        Point2D n8 = this.calculatePixelPoint2D(n7, userToPixelTransform);
                        if (n8 == null) break block11;
                        d2 = n8.getY();
                        if (!Double.isInfinite(d2) && !Double.isNaN(d2)) break block12;
                        this.\u0182.replace(n7);
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.\u0182.replace(n7);
                        throw throwable;
                    }
                }
                int n5 = (int)d2;
                if (n5 + 1 < this.\u0170 || n5 > this.\u0146 || !axis.isVisible() || !axis.isTicksVisible()) break block11;
                graphics2D.setColor(object.isMajor() ? color2 : color3);
                if (this.\u015d != null) {
                    graphics2D.setStroke(this.\u015d);
                }
                int n6 = axisPlacement == AxisPlacement.LEADING ? -1 : 1;
                graphics2D.drawLine(n2, n5, n2 + n3 * n6, n5);
            }
            this.\u0182.replace(n7);
        }
        if (axis.isVisible() && axis.isLabelVisible()) {
            FontMetrics fontMetrics;
            AutoPositionedLabel autoPositionedLabel = axis.getLabel();
            Font font3 = autoPositionedLabel == null ? null : autoPositionedLabel.getFont();
            FontMetrics fontMetrics2 = fontMetrics = font3 == null ? graphics2D.getFontMetrics() : graphics2D.getFontMetrics(font3);
            if (autoPositionedLabel != null) {
                Double d3 = autoPositionedLabel.getRotation();
                n3 = this.\u0101(axis);
                if (axisPlacement == AxisPlacement.TRAILING) {
                    autoPositionedLabel.paint((Graphics)graphics2D, n2 + n3 - fontMetrics.getAscent() - this.\u0142, point.y, d3 == null ? Rotation.QUARTER_CLOCKWISE.doubleValue() : d3.doubleValue());
                } else if (axisPlacement == AxisPlacement.LEADING) {
                    autoPositionedLabel.paint((Graphics)graphics2D, n2 - n3 + fontMetrics.getAscent() + this.\u0142, point.y, d3 == null ? Rotation.QUARTER_ANTICLOCKWISE.doubleValue() : d3.doubleValue());
                } else {
                    int n7 = fontMetrics.stringWidth(autoPositionedLabel.getLabel());
                    int n8 = 10;
                    autoPositionedLabel.paint((Graphics)graphics2D, n2 - fontMetrics.getAscent() + this.\u0142, this.\u0170 + n8 + n7 / 2, d3 == null ? Rotation.QUARTER_ANTICLOCKWISE.doubleValue() : d3.doubleValue());
                }
            }
        }
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }

    protected boolean drawStringIfWithinBounds(Graphics graphics, String string, int n2, int n3) {
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = new Rectangle(0, 0, rectangle.width, rectangle.height);
        Rectangle2D rectangle2D = GraphicsUtilities.calculateStringBounds(graphics, string, n2, n3);
        if (GraphicsUtilities.rectangleWithinBounds(rectangle2D, rectangle2)) {
            this.\u0101((Graphics2D)graphics, string, (float)n2, n3, rectangle2D);
            return true;
        }
        return false;
    }

    protected boolean drawRotatedStringIfWithinBounds(Graphics graphics, String string, int n2, int n3, double d2) {
        Rectangle rectangle = this.getBounds();
        Container container = this.getParent();
        Rectangle rectangle2 = container == null ? null : SwingUtilities.convertRectangle(this.getParent(), rectangle, this);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (string == null || "".equals(string)) {
            return false;
        }
        int n4 = fontMetrics.stringWidth(string);
        int n5 = fontMetrics.getDescent();
        float f2 = (float)n2 + (float)n4 / 2.0f;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape = GraphicsUtilities.calculateRotatedStringBounds(graphics2D, string, n2, n3, d2);
        Rectangle rectangle3 = shape.getBounds();
        if (GraphicsUtilities.rectangleWithinBounds(rectangle3, rectangle2)) {
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            int n6 = n3;
            graphics2D.translate(f2, (double)n6);
            graphics2D.rotate(-d2);
            graphics2D.drawString(string, (float)(-n4) / 2.0f, (float)n5);
            graphics2D.rotate(d2);
            graphics2D.translate(-f2, (double)(-n6));
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            return true;
        }
        return false;
    }

    public void drawXAxisTickLabel(Graphics graphics, Axis axis, String string, int n2, int n3) {
        if (string == null) {
            return;
        }
        double d2 = axis.getTickLabelRotation();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = fontMetrics.getDescent();
        int n5 = fontMetrics.getAscent();
        AxisPlacement axisPlacement = axis.getPlacement();
        if (d2 == 0.0) {
            int n6 = fontMetrics.stringWidth(string);
            int n7 = n2 - n6 / 2;
            int n8 = axisPlacement == AxisPlacement.TRAILING ? n3 - n4 : n3 + n5;
            this.drawStringIfWithinBounds(graphics, string, n7, n8);
        } else {
            boolean bl;
            String string2 = string;
            boolean bl2 = false;
            do {
                String string3 = bl2 ? string2 + "\u2026" : string2;
                int n9 = string2.length() <= 1 ? 0 : fontMetrics.stringWidth(string3.substring(0, string3.length() - 1));
                int n10 = n9 / 2;
                int n11 = d2 < 1.5707963267948966 && d2 > 0.0 ? -((int)((double)n10 * Math.cos(d2))) : (int)((double)n10 * Math.cos(d2));
                int n12 = axisPlacement == AxisPlacement.TRAILING ? n2 - n9 / 2 - n11 : n2 - n9 / 2 + n11;
                int n13 = axisPlacement == AxisPlacement.TRAILING ? n3 - n5 - (int)Math.abs((double)n10 * Math.sin(d2)) : n3 + n4 + (int)Math.abs((double)n10 * Math.sin(d2));
                bl = this.drawRotatedStringIfWithinBounds(graphics, string3, n12, n13 + this.\u0174.getTickLength() + 1, d2);
                string2 = string2.substring(0, string2.length() - 1);
                bl2 = true;
            } while (!bl && string2.length() > 0);
        }
    }

    protected void paintYAxis(Graphics2D graphics2D, Axis axis, int n2) {
        if (!axis.isVisible()) {
            return;
        }
        axis.render(graphics2D, n2, this.\u0170, this.\u0146 - this.\u0170, Orientation.vertical);
    }

    protected void paintXAxis(Graphics2D graphics2D) {
        AxisRenderer axisRenderer = this.\u0174.getAxisRenderer();
        if (!this.\u0174.isVisible() || axisRenderer == null) {
            return;
        }
        int n2 = this.\u010a();
        AutoPositionedLabel autoPositionedLabel = this.\u0174.getLabel();
        if (autoPositionedLabel != null && this.\u0174.isLabelVisible()) {
            graphics2D.setColor(this.getLabelColor());
            Point point = this.\u0101(graphics2D);
            autoPositionedLabel.paint((Graphics)graphics2D, point.x, point.y, Rotation.NONE.doubleValue());
        }
        int n3 = this.\u016b - this.\u0193;
        this.\u0174.render(graphics2D, this.\u0193, n2, n3, Orientation.horizontal);
    }

    int \u010a() {
        int n2;
        AxisPlacement axisPlacement = this.\u0174.getPlacement();
        if (axisPlacement == null || axisPlacement == AxisPlacement.LEADING) {
            n2 = this.\u0146;
        } else if (axisPlacement == AxisPlacement.CENTER) {
            n2 = (this.\u0146 + this.\u0170) / 2;
        } else if (axisPlacement == AxisPlacement.FLOATING) {
            double d2 = this.\u0174.getFloatingPosition();
            Point2D.Double double_ = new Point2D.Double(this.\u0174.minimum(), d2);
            Point point = this.calculatePixelPoint(double_);
            n2 = point.y;
        } else {
            n2 = this.\u0170;
        }
        return n2;
    }

    Point \u0101(Graphics graphics) {
        AutoPositionedLabel autoPositionedLabel = this.\u0174.getLabel();
        assert (autoPositionedLabel != null);
        Font font = autoPositionedLabel.getFont();
        FontMetrics fontMetrics = font == null ? graphics.getFontMetrics() : graphics.getFontMetrics(font);
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        int n2 = this.\u010a();
        AxisPlacement axisPlacement = this.\u0174.getPlacement();
        Point point = this.calculatePixelPoint(new Point2D.Double(this.\u0174.minimum(), this.getYAxis().midPoint()));
        Point point2 = this.calculatePixelPoint(new Point2D.Double(this.\u0174.maximum(), this.getYAxis().midPoint()));
        int n3 = point == null ? 0 : point.x;
        int n4 = point2 == null ? this.\u016b : point2.x;
        int n5 = point2 == null ? 0 : point2.y;
        Point point3 = new Point((n3 + n4) / 2, n5);
        Dimension dimension2 = autoPositionedLabel.size(graphics, font);
        Point point4 = axisPlacement == AxisPlacement.LEADING ? new Point(point3.x, dimension.height - dimension2.height + fontMetrics.getAscent() - this.\u0142 - insets.bottom) : (axisPlacement == AxisPlacement.CENTER ? new Point(n4 - dimension2.width / 2 - this.\u0142, n2 - dimension2.height + fontMetrics.getAscent() - this.\u0142) : (axisPlacement == AxisPlacement.FLOATING ? new Point(n4 - dimension2.width / 2 - this.\u0142, n2 - dimension2.height + fontMetrics.getAscent() - this.\u0142) : new Point(point3.x, insets.top + this.titleHeight() + this.\u0142 + fontMetrics.getHeight() / 2)));
        return point4;
    }

    protected Color getTickColor(Axis axis) {
        Color color;
        Color color2 = color = axis == null ? this.\u0179 : axis.getTickColor();
        if (color == null) {
            color = this.\u0179;
        }
        return color;
    }

    protected Color getMinorTickColor(Axis axis) {
        Color color;
        Color color2 = color = axis == null ? this.\u0179 : axis.getMinorTickColor();
        if (color == null) {
            color = this.getTickColor(axis);
        }
        return color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintXAxisTicks(Graphics2D graphics2D, Tick[] tickArray) {
        Font font;
        if (tickArray == null) {
            return;
        }
        Font font2 = graphics2D.getFont();
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        Font font3 = font = this.\u0174 == null ? UIManager.getFont("Label.font") : this.getTickFont(this.\u0174);
        if (font != null) {
            graphics2D.setFont(font);
        }
        Tick[] tickArray2 = this.\u0183 ? tickArray : this.\u0101(graphics2D, tickArray, font);
        FontMetrics fontMetrics = font == null ? graphics2D.getFontMetrics() : graphics2D.getFontMetrics(font);
        AxisPlacement axisPlacement = this.\u0174 == null ? AxisPlacement.LEADING : this.\u0174.getPlacement();
        Color color2 = this.getTickColor(this.\u0174);
        Color color3 = this.getMinorTickColor(this.\u0174);
        for (Tick tick : tickArray2) {
            int n2;
            if (tick == null) continue;
            int n3 = n2 = tick.isMajor() ? this.\u0174.getTickLength() : this.\u0174.getMinorTickLength();
            if (this.\u015d != null) {
                graphics2D.setStroke(this.\u015d);
            }
            Point2D point2D = null;
            try {
                point2D = this.\u0182.borrow(tick.getPosition(), this.getYAxis().minimum());
                Point point = this.calculatePixelPoint(point2D);
                if (point != null) {
                    int n4 = point.x;
                    String string = tick.getLabel();
                    graphics2D.setColor(tick.isMajor() ? color2 : color3);
                    Color color4 = this.\u0174.getTickLabelColor();
                    if (color4 == null) {
                        color4 = this.\u015c;
                    }
                    if (this.\u0174.isVisible() && n4 + 1 >= this.\u0193 && n4 <= this.\u016b) {
                        AxisRenderer axisRenderer = this.\u0174.getAxisRenderer();
                        int n5 = axisRenderer == null ? 0 : axisRenderer.getBreadth() / 2;
                        int n6 = this.\u0174.getTickLabelOffset();
                        if (axisPlacement == null || axisPlacement == AxisPlacement.LEADING) {
                            if (n2 > 0) {
                                graphics2D.drawLine(n4, this.\u0146 + n5, n4, this.\u0146 + n2 + n5);
                            }
                            graphics2D.setColor(color4);
                            this.drawXAxisTickLabel(graphics2D, this.\u0174, string, n4, this.\u0146 + fontMetrics.getDescent() + n6 + n5);
                        } else if (axisPlacement == AxisPlacement.CENTER) {
                            int n7 = (this.\u0146 + this.\u0170) / 2;
                            if (n2 > 0) {
                                graphics2D.drawLine(n4, n7 + n5, n4, n7 + n2 + n5);
                            }
                            graphics2D.setColor(color4);
                            this.drawXAxisTickLabel(graphics2D, this.\u0174, string, n4, n7 + fontMetrics.getDescent() + n6 + n5);
                        } else if (axisPlacement == AxisPlacement.FLOATING) {
                            double d2 = this.\u0174.getFloatingPosition();
                            point2D.setLocation(this.\u0174.minimum(), d2);
                            Point point2 = this.calculatePixelPoint(point2D);
                            int n8 = point2.y;
                            if (n2 > 0) {
                                graphics2D.drawLine(n4, n8 + n5, n4, n8 + n2 + n5);
                            }
                            graphics2D.setColor(color4);
                            this.drawXAxisTickLabel(graphics2D, this.\u0174, string, n4, n8 + fontMetrics.getDescent() + n6 + n5);
                        } else {
                            if (n2 > 0) {
                                graphics2D.drawLine(n4, this.\u0170 - n5, n4, this.\u0170 - n2 - n5);
                            }
                            graphics2D.setColor(color4);
                            this.drawXAxisTickLabel(graphics2D, this.\u0174, string, n4, this.\u0170 - fontMetrics.getDescent() - n6 - n5);
                        }
                    }
                }
                this.\u0182.replace(point2D);
            }
            catch (Throwable throwable) {
                this.\u0182.replace(point2D);
                throw throwable;
            }
        }
        graphics2D.setFont(font2);
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }

    protected void paintXAxisGridLines(Graphics2D graphics2D, Tick[] tickArray) {
        assert (tickArray != null);
        Stroke stroke = graphics2D.getStroke();
        for (Tick tick : tickArray) {
            Point2D.Double double_;
            Point point;
            if (tick == null || (point = this.calculatePixelPoint(double_ = new Point2D.Double(tick.getPosition(), 0.0))) == null) continue;
            int n2 = point.x;
            if (!this.\u013f || n2 < this.\u0193 || n2 > this.\u016b || !tick.isMajor() && !this.\u018c) continue;
            Stroke stroke2 = tick.isMajor() ? this.\u016a : this.\u0167;
            Color color = tick.isMajor() ? this.\u0172 : this.\u0152;
            graphics2D.setStroke(stroke2);
            graphics2D.setColor(color);
            graphics2D.drawLine(n2, this.\u0146, n2, this.\u0170);
        }
        graphics2D.setStroke(stroke);
    }

    protected void paintAxes(Graphics2D graphics2D) {
        Tick[] tickArray = this.\u0174.getTicks();
        if (this.isVerticalGridLinesVisible()) {
            this.paintXAxisGridLines(graphics2D, tickArray);
        }
        if (this.\u0149) {
            this.paintHorizontalGrid(graphics2D, this.getYAxis(), this.getUserToPixelTransform());
        }
        this.paintXAxis(graphics2D);
        AxisRenderer axisRenderer = this.getYAxis().getAxisRenderer();
        int n2 = 0;
        graphics2D.setColor(this.\u0192);
        int n3 = (this.\u0193 + this.\u016b) / 2;
        int n4 = this.\u0193;
        int n5 = this.\u016b;
        Axis axis = this.getYAxis();
        UserToPixelTransform userToPixelTransform = this.getTransformForAxis(axis);
        Range<?> range = axis.getRange();
        double d2 = range.minimum();
        double d3 = range.maximum();
        Point point = this.calculatePixelPoint((Point2D)new Point2D.Double(this.\u0174.midPoint(), d2), userToPixelTransform);
        Point point2 = this.calculatePixelPoint((Point2D)new Point2D.Double(this.\u0174.midPoint(), d3), userToPixelTransform);
        for (Axis axis2 : this.\u0147) {
            int n6;
            int n7;
            int n8 = this.\u0101(axis2);
            AxisRenderer axisRenderer2 = axis2.getAxisRenderer();
            int n9 = axisRenderer2 == null ? 0 : axisRenderer2.getBreadth() / 2;
            AxisPlacement axisPlacement = axis2.getPlacement();
            if (axisPlacement == null || axisPlacement == AxisPlacement.LEADING) {
                n7 = n4;
                n6 = n7 - n9;
                n4 -= n8;
            } else if (axisPlacement == AxisPlacement.TRAILING) {
                n7 = n5;
                n6 = n7 + n9;
                n5 += n8;
            } else if (axisPlacement == AxisPlacement.FLOATING) {
                double d4 = axis2.getFloatingPosition();
                Point2D.Double double_ = new Point2D.Double(d4, axis2.midPoint());
                Point point3 = this.calculatePixelPoint(double_);
                n7 = point3.x;
                n6 = n7 - n9;
            } else {
                n7 = n3;
                n6 = n7 - n9;
            }
            this.paintYAxis(graphics2D, axis2, n7);
            if (n2 < this.\u014d.size()) {
                UserToPixelTransform userToPixelTransform2 = this.\u014d.get(n2);
                assert (userToPixelTransform2 != null);
                if (point != null && point2 != null) {
                    Point point4 = new Point(point.x, (point.y + point2.y) / 2);
                    this.paintYAxisTicks(graphics2D, axis2, userToPixelTransform2, point4, n6);
                }
            }
            ++n2;
        }
        if (this.\u0174.isTicksVisible()) {
            this.paintXAxisTicks(graphics2D, tickArray);
        }
    }

    private void \u0102(Graphics graphics) {
        if (this.\u014f != null && this.\u0158) {
            Insets insets = this.getInsets();
            int n2 = this.getChartType() == ChartType.PIE ? this.getWidth() / 2 : this.getXStart() + this.getChartWidth() / 2;
            Font font = this.\u014f.getFont();
            if (font == null) {
                font = graphics.getFont();
            }
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            int n3 = fontMetrics.getHeight() + fontMetrics.getDescent();
            this.\u014f.paint(graphics, n2, insets.top + n3, Rotation.NONE.doubleValue());
        }
    }

    protected void paintYAxisLabels(Graphics2D graphics2D) {
        int n2 = 0;
        graphics2D.setColor(this.\u0192);
        int n3 = (this.\u0193 + this.\u016b) / 2;
        int n4 = this.\u0193;
        int n5 = this.\u016b;
        for (Axis axis : this.\u0147) {
            Serializable serializable;
            Serializable serializable2;
            int n6;
            int n7 = this.\u0101(axis);
            AxisRenderer axisRenderer = axis.getAxisRenderer();
            int n8 = axisRenderer == null ? 0 : axisRenderer.getBreadth() / 2;
            int n9 = axis.getTickLabelOffset();
            AxisPlacement axisPlacement = axis.getPlacement();
            if (axisPlacement == null || axisPlacement == AxisPlacement.LEADING) {
                n6 = n4 - n9 - n8;
                n4 -= n7 + n8;
            } else if (axisPlacement == AxisPlacement.TRAILING) {
                n6 = n5 + n9 + n8;
                n5 += n7 + n8;
            } else if (axisPlacement == AxisPlacement.FLOATING) {
                double d2 = axis.getFloatingPosition();
                serializable2 = new Point2D.Double(d2, axis.midPoint());
                serializable = this.calculatePixelPoint((Point2D)((Object)serializable2));
                n6 = ((Point)serializable).x - n9 - n8;
            } else {
                n6 = n3 - n9 - n8;
            }
            if (n2 < this.\u014d.size()) {
                UserToPixelTransform userToPixelTransform = this.\u014d.get(n2);
                assert (userToPixelTransform != null);
                serializable2 = this.getTickFont(axis);
                Serializable serializable3 = serializable = serializable2 == null ? graphics2D.getFontMetrics() : graphics2D.getFontMetrics((Font)serializable2);
                if (axis.isVisible() && axis.isTicksVisible()) {
                    Tick[] tickArray;
                    Tick[] tickArray2 = axis.getTicks();
                    for (Tick tick : tickArray = this.\u0183 ? tickArray2 : this.\u0101((Graphics)graphics2D, axis, tickArray2, (Font)serializable2)) {
                        double d3;
                        Point2D.Double double_ = new Point2D.Double(0.0, tick.getPosition());
                        Point2D point2D = this.calculatePixelPoint2D((Point2D)double_, userToPixelTransform);
                        if (point2D == null || Double.isInfinite(d3 = point2D.getY()) || Double.isNaN(d3)) continue;
                        int n10 = (int)d3;
                        String string = tick.getLabel();
                        graphics2D.setFont((Font)serializable2);
                        Color color = axis.getTickLabelColor();
                        if (color == null) {
                            color = this.\u015c;
                        }
                        graphics2D.setColor(color);
                        if (axisPlacement == AxisPlacement.TRAILING) {
                            this.drawYAxisTickLabel(graphics2D, axis, string, n6 + axis.getTickLength() + 1, n10 + ((FontMetrics)serializable).getDescent());
                            continue;
                        }
                        if (axisPlacement == AxisPlacement.LEADING) {
                            this.drawYAxisTickLabel(graphics2D, axis, string, n6 - axis.getTickLength() - 1, n10 + ((FontMetrics)serializable).getDescent());
                            continue;
                        }
                        this.drawYAxisTickLabel(graphics2D, axis, string, n6 + axis.getTickLength() + 1, n10 + ((FontMetrics)serializable).getDescent());
                    }
                }
            }
            ++n2;
        }
    }

    private Tick[] \u0101(Graphics graphics, Axis axis, Tick[] tickArray, Font font) {
        boolean bl;
        int n2 = 1;
        ArrayList<Tick> arrayList = new ArrayList<Tick>();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setFont(font);
        do {
            int n3 = 0;
            bl = false;
            Rectangle2D rectangle2D = null;
            arrayList.clear();
            for (Tick tick : tickArray) {
                if (tick.isMajor()) {
                    if (n3 == 0) {
                        Point2D.Double double_ = new Point2D.Double(0.0, tick.getPosition());
                        UserToPixelTransform userToPixelTransform = this.getTransformForAxis(axis);
                        Point2D point2D = this.calculatePixelPoint2D((Point2D)double_, userToPixelTransform);
                        double d2 = axis.getTickLabelRotation();
                        Shape shape = null;
                        if (point2D != null) {
                            shape = this.\u0101(d2, 0.0, 1.0) ? GraphicsUtilities.calculateStringBounds(graphics2D, tick.getLabel(), point2D.getX(), point2D.getY()) : GraphicsUtilities.calculateRotatedStringBounds(graphics2D, tick.getLabel(), point2D.getX(), point2D.getY(), d2);
                        }
                        if (rectangle2D != null && shape != null) {
                            Area area = new Area(shape);
                            Area area2 = new Area(rectangle2D);
                            area.intersect(area2);
                            if (!area.isEmpty()) {
                                bl = true;
                                break;
                            }
                        }
                        arrayList.add(tick);
                        rectangle2D = shape;
                    }
                    if (++n3 != n2) continue;
                    n3 = 0;
                    continue;
                }
                arrayList.add(tick);
            }
            ++n2;
        } while (bl);
        graphics2D.dispose();
        Tick[] tickArray2 = new Tick[arrayList.size()];
        return arrayList.toArray(tickArray2);
    }

    private Tick[] \u0101(Graphics graphics, Tick[] tickArray, Font font) {
        boolean bl;
        int n2 = 1;
        ArrayList<Tick> arrayList = new ArrayList<Tick>();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setFont(font);
        do {
            int n3 = 0;
            bl = false;
            Rectangle2D rectangle2D = null;
            arrayList.clear();
            for (Tick tick : tickArray) {
                if (tick == null) continue;
                if (tick.isMajor()) {
                    if (n3 == 0) {
                        Point2D.Double double_ = new Point2D.Double(tick.getPosition(), 0.0);
                        Point2D point2D = this.calculatePixelPoint2D(double_);
                        double d2 = this.\u0174.getTickLabelRotation();
                        Shape shape = null;
                        if (point2D != null) {
                            shape = this.\u0101(d2, 0.0, 1.0) ? GraphicsUtilities.calculateStringBounds(graphics2D, tick.getLabel(), point2D.getX(), point2D.getY()) : GraphicsUtilities.calculateRotatedStringBounds(graphics2D, tick.getLabel(), point2D.getX(), point2D.getY(), d2);
                        }
                        if (rectangle2D != null && shape != null) {
                            Area area = new Area(shape);
                            Area area2 = new Area(rectangle2D);
                            area.intersect(area2);
                            if (!area.isEmpty()) {
                                bl = true;
                                break;
                            }
                        }
                        arrayList.add(tick);
                        rectangle2D = shape;
                    }
                    if (++n3 != n2) continue;
                    n3 = 0;
                    continue;
                }
                arrayList.add(tick);
            }
            ++n2;
        } while (bl);
        graphics2D.dispose();
        Tick[] tickArray2 = new Tick[arrayList.size()];
        return arrayList.toArray(tickArray2);
    }

    protected void drawYAxisTickLabel(Graphics graphics, Axis axis, String string, int n2, int n3) {
        if (string == null) {
            return;
        }
        AxisPlacement axisPlacement = axis.getPlacement();
        double d2 = axis.getTickLabelRotation();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = fontMetrics.stringWidth(string);
        int n5 = fontMetrics.getAscent();
        int n6 = fontMetrics.getDescent();
        if (d2 == 0.0) {
            int n7 = axisPlacement == AxisPlacement.LEADING ? n2 - n4 : n2 + n6;
            Rectangle rectangle = this.getBounds();
            Rectangle rectangle2 = new Rectangle(0, 0, rectangle.width, rectangle.height);
            Rectangle2D rectangle2D = GraphicsUtilities.calculateStringBounds(graphics, string, n2, n3);
            if (GraphicsUtilities.rectangleWithinBounds(rectangle2D, rectangle2)) {
                this.\u0101((Graphics2D)graphics, string, (float)n7, n3 + n6, rectangle2D);
            }
        } else if (this.\u0101(d2, 90.0, 1.0) || this.\u0101(d2, -90.0, 1.0) || this.\u0101(d2, 270.0, 1.0)) {
            int n8 = axisPlacement == AxisPlacement.LEADING ? n2 - n4 / 2 - n5 / 2 : n2 + n5 / 2 - n4 / 2;
            int n9 = n3 - fontMetrics.stringWidth("0") / 2;
            this.drawRotatedStringIfWithinBounds(graphics, string, n8, n9, d2);
        } else {
            boolean bl;
            boolean bl2 = false;
            String string2 = string;
            do {
                String string3 = bl2 ? string2 + "\u2026" : string2;
                int n10 = string2.length() <= 1 ? 0 : fontMetrics.stringWidth(string3.substring(0, string3.length() - 1));
                double d3 = (double)n10 / 2.0;
                int n11 = axisPlacement == AxisPlacement.LEADING ? n2 - n4 + (int)(d3 - d3 * Math.cos(d2)) : n2 + n6 - (int)(d3 - d3 * Math.cos(d2));
                int n12 = axisPlacement == AxisPlacement.LEADING ? n3 + (int)(d3 * Math.sin(d2)) : n3 - (int)(d3 * Math.sin(d2));
                bl = this.drawRotatedStringIfWithinBounds(graphics, string3, n11, n12, d2);
                string2 = string2.substring(0, string2.length() - 1);
                bl2 = true;
            } while (!bl && string2.length() > 0);
        }
    }

    private void \u0101(Graphics2D graphics2D, String string, float f2, float f3, Rectangle2D rectangle2D) {
        graphics2D.drawString(string, f2, f3);
    }

    private boolean \u0101(double d2, double d3, double d4) {
        double d5 = Math.toDegrees(d2);
        return Math.abs(d5 - d3) < d4;
    }

    public PointSelection nearestPoint(Point point, ChartModel chartModel) {
        if (point == null) {
            return null;
        }
        UserToPixelTransform userToPixelTransform = this.getTransformForModel(chartModel);
        double d2 = Double.MAX_VALUE;
        Chartable chartable = null;
        int n2 = -1;
        int n3 = 0;
        for (int i2 = 0; i2 < chartModel.getPointCount(); ++i2) {
            double d3;
            Object object;
            Object object2;
            Point2D.Double double_ = null;
            if (chartModel instanceof LeanChartModel) {
                object2 = (LeanChartModel)chartModel;
                object = object2.getPointPositions(i2);
                double_ = new Point2D.Double(object[0], object[1]);
            } else {
                Positionable positionable;
                object2 = chartModel.getPoint(i2);
                object = object2 == null ? null : object2.getX();
                Positionable positionable2 = positionable = object2 == null ? null : object2.getY();
                if (object != null && positionable != null) {
                    double_ = new Point2D.Double(object.position(), positionable.position());
                }
            }
            Object object3 = object2 = double_ == null ? null : this.calculatePixelPoint((Point2D)double_, userToPixelTransform);
            if (object2 != null && (d3 = ((Point2D)object2).distanceSq(point.x, point.y)) < d2) {
                d2 = d3;
                chartable = chartModel.getPoint(i2);
                n2 = n3;
            }
            ++n3;
        }
        if (chartable == null) {
            return null;
        }
        return new PointSelection(chartable, Math.sqrt(d2), n2);
    }

    public ChartModel nearestModel(Point point) {
        Double d2 = Double.MAX_VALUE;
        ChartModel chartModel = null;
        for (ChartModel chartModel2 : this.getModels()) {
            Double d3;
            PointSelection pointSelection = this.nearestPoint(point, chartModel2);
            if (pointSelection == null || (d3 = pointSelection.getDistance()) == null || !(d3 < d2)) continue;
            d2 = d3;
            chartModel = chartModel2;
        }
        return chartModel;
    }

    public boolean isUserPointViewable(Point2D point2D, ChartModel chartModel) {
        UserToPixelTransform userToPixelTransform = this.getTransformForModel(chartModel);
        Point2D point2D2 = userToPixelTransform.transform(point2D);
        return this.isPixelPointViewable((int)point2D2.getX(), (int)point2D2.getY());
    }

    public boolean isPixelPointViewable(int n2, int n3) {
        boolean bl = n2 <= this.getXEnd() && n2 >= this.getXStart();
        boolean bl2 = n3 <= this.getYStart() && n3 >= this.getYEnd();
        return bl && bl2;
    }

    public Pair<Chartable, Double> nearestPoint(Point2D point2D, ChartModel chartModel) {
        Chartable chartable = null;
        Double d2 = null;
        for (Chartable chartable2 : chartModel) {
            double d3 = Chart.distanceSq(point2D, chartable2);
            if (d2 != null && !(d3 < d2)) continue;
            d2 = d3;
            chartable = chartable2;
        }
        return new Pair<Object, Object>(chartable, d2);
    }

    public static double distanceSq(Point2D point2D, Chartable chartable) {
        double d2 = chartable.getX().position();
        double d3 = chartable.getY().position();
        return point2D.distanceSq(d2, d3);
    }

    public static double distance(Point2D point2D, Chartable chartable) {
        double d2 = chartable.getX().position();
        double d3 = chartable.getY().position();
        return point2D.distance(d2, d3);
    }

    void \u0101(Rectangle2D rectangle2D, Rectangle rectangle, Axis axis) {
        UserToPixelTransform userToPixelTransform = this.\u0102(rectangle2D, rectangle, axis);
        this.\u014d.add(userToPixelTransform);
    }

    void \u0101(Rectangle2D rectangle2D, Rectangle rectangle) {
        this.\u0103(rectangle2D, rectangle, this.getYAxis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void \u0103(Rectangle2D rectangle2D, Rectangle rectangle, Axis axis) {
        this.\u017b.lock();
        try {
            UserToPixelTransform userToPixelTransform = this.\u0102(rectangle2D, rectangle, axis);
            this.\u014d.clear();
            this.\u014d.add(userToPixelTransform);
        }
        finally {
            this.\u017b.unlock();
        }
    }

    private UserToPixelTransform \u0102(Rectangle2D rectangle2D, Rectangle rectangle, Axis axis) {
        if (rectangle.width == 0 || rectangle.height == 0) {
            rectangle = new Rectangle(100, 100);
        }
        boolean bl = this.\u0174 != null && this.\u0174.isFlipped();
        int n2 = bl ? -1 : 1;
        boolean bl2 = axis != null && axis.isFlipped();
        int n3 = bl2 ? -1 : 1;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(bl ? (double)(rectangle.x + rectangle.width) : (double)rectangle.x, rectangle.y + (bl2 ? 0 : rectangle.height));
        double d2 = (double)n2 * (double)rectangle.width / rectangle2D.getWidth();
        double d3 = -1.0 * (double)n3 * (double)rectangle.height / rectangle2D.getHeight();
        affineTransform.scale(d2, d3);
        UserToPixelTransform userToPixelTransform = new UserToPixelTransform(affineTransform);
        userToPixelTransform.setTranslation(-rectangle2D.getX(), -rectangle2D.getY());
        userToPixelTransform.setXTransform(this.\u0174 == null ? new IdentityTransform() : this.\u0174.getAxisTransform());
        userToPixelTransform.setYTransform(axis == null ? new IdentityTransform() : axis.getAxisTransform());
        return userToPixelTransform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point calculatePixelPoint(Point2D point2D) {
        this.\u0180.lock();
        try {
            UserToPixelTransform userToPixelTransform = this.getUserToPixelTransform();
            if (userToPixelTransform != null) {
                Point2D point2D2 = userToPixelTransform.transform(point2D);
                if (point2D2 == null) {
                    Point point = null;
                    return point;
                }
                Point point = new Point((int)point2D2.getX(), (int)point2D2.getY());
                return point;
            }
            Point point = null;
            return point;
        }
        finally {
            this.\u0180.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point2D calculatePixelPoint2D(Point2D point2D) {
        this.\u0180.lock();
        try {
            UserToPixelTransform userToPixelTransform = this.getUserToPixelTransform();
            Point2D point2D2 = userToPixelTransform == null ? null : userToPixelTransform.transform(point2D);
            return point2D2;
        }
        finally {
            this.\u0180.unlock();
        }
    }

    public Point calculatePixelPoint(Point2D point2D, Axis axis) {
        UserToPixelTransform userToPixelTransform = this.getTransformForAxis(axis);
        return this.calculatePixelPoint(point2D, userToPixelTransform);
    }

    public Point2D calculatePixelPoint2D(Point2D point2D, Axis axis) {
        UserToPixelTransform userToPixelTransform = this.getTransformForAxis(axis);
        return this.calculatePixelPoint2D(point2D, userToPixelTransform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point calculatePixelPoint(Point2D point2D, UserToPixelTransform userToPixelTransform) {
        Point point;
        if (userToPixelTransform == null) {
            return null;
        }
        Point2D point2D2 = null;
        try {
            point2D2 = this.\u0182.borrow(0.0, 0.0);
            point2D2 = userToPixelTransform.transform(point2D, point2D2);
            point = point2D2 == null || Double.isNaN(point2D2.getX()) || Double.isNaN(point2D2.getY()) ? null : new Point((int)point2D2.getX(), (int)point2D2.getY());
        }
        finally {
            this.\u0182.replace(point2D2);
        }
        return point;
    }

    public Point2D calculatePixelPoint2D(Point2D point2D, UserToPixelTransform userToPixelTransform) {
        if (userToPixelTransform == null) {
            return null;
        }
        return userToPixelTransform.transform(point2D);
    }

    public Point2D calculateUserPoint(Point point) {
        Point2D point2D;
        assert (point != null);
        try {
            UserToPixelTransform userToPixelTransform = this.getUserToPixelTransform();
            point2D = userToPixelTransform == null ? null : userToPixelTransform.inverseTransform(point);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
        return point2D;
    }

    public Point2D calculateUserPoint(Point point, Axis axis) {
        Point2D point2D;
        assert (point != null);
        try {
            UserToPixelTransform userToPixelTransform = this.getTransformForAxis(axis);
            point2D = userToPixelTransform == null ? null : userToPixelTransform.inverseTransform(point);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
        return point2D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double convertYToPrimary(double d2, Axis axis) {
        Point2D point2D = null;
        try {
            point2D = this.\u0182.borrow(this.getXAxis().midPoint(), d2);
            Point2D point2D2 = this.calculatePixelPoint2D(point2D, axis);
            Axis axis2 = this.getYAxis();
            Point point = new Point((int)point2D2.getX(), (int)point2D2.getY());
            Point2D point2D3 = this.calculateUserPoint(point, axis2);
            double d3 = point2D3.getY();
            this.\u0182.replace(point2D);
            return d3;
        }
        catch (Throwable throwable) {
            this.\u0182.replace(point2D);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double convertPrimaryToY(double d2, Axis axis) {
        Point2D point2D = null;
        try {
            point2D = this.\u0182.borrow(this.getXAxis().midPoint(), d2);
            Axis axis2 = this.getYAxis();
            Point2D point2D2 = this.calculatePixelPoint2D(point2D, axis2);
            Point point = new Point((int)point2D2.getX(), (int)point2D2.getY());
            Point2D point2D3 = this.calculateUserPoint(point, axis);
            double d3 = point2D3.getY();
            this.\u0182.replace(point2D);
            return d3;
        }
        catch (Throwable throwable) {
            this.\u0182.replace(point2D);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void \u0109() {
        Rectangle rectangle = new Rectangle(this.getXStart(), this.getYEnd(), Math.abs(this.getXEnd() - this.getXStart()), Math.abs(this.getYStart() - this.getYEnd()));
        if (this.getBarResizePolicy() == BarResizePolicy.RESIZE_OFF) {
            Object object;
            ChartStyle chartStyle;
            int n2 = 0;
            Object object2 = null;
            Iterator<ChartModel> object3 = this.getModels().iterator();
            while (object3.hasNext() && ((chartStyle = this.getStyle((ChartModel)(object = object3.next()))) == null || chartStyle.isBarsVisible() && chartStyle.getBarWidth() != null)) {
                int n3 = object.getPointCount();
                if (n3 < n2) continue;
                n2 = n3;
                object2 = object;
            }
            if (object2 != null) {
                void var4_8;
                ChartStyle chartStyle2 = this.getStyle((ChartModel)object2);
                if (chartStyle2 == null) {
                    ChartStyle chartStyle3 = new ChartStyle();
                }
                object = var4_8.getBarWidth();
                int n4 = this.getBarGap();
                if (object == null) {
                    this.\u0108();
                    rectangle = new Rectangle(this.\u0193, this.\u0170, this.\u016b - this.\u0193, Math.abs(this.\u0146 - this.\u0170));
                } else {
                    int n5;
                    int n6;
                    Dimension dimension = this.\u017e.\u0101(this, var4_8.getBarOrientation(), (Double)((Integer)object).doubleValue());
                    if (dimension == null) {
                        this.\u0108();
                        rectangle = new Rectangle(this.\u0193, this.\u0170, this.\u016b - this.\u0193, Math.abs(this.\u0146 - this.\u0170));
                    } else if (var4_8.getBarOrientation() == Orientation.vertical) {
                        n6 = this.getXStart();
                        n5 = n6 + dimension.width;
                        rectangle = new Rectangle(n6, this.getYEnd(), n5 - n6, Math.abs(this.getYStart() - this.getYEnd()));
                    } else {
                        n6 = this.getYStart();
                        n5 = n6 - ((Integer)object + n4) * (n2 + 1);
                        rectangle = new Rectangle(this.\u0193, n5, this.\u016b - this.\u0193, Math.abs(n6 - n5));
                    }
                }
            }
        }
        this.\u014d.clear();
        if (this.\u0174 != null) {
            Range<?> range = this.\u0174.getOutputRange();
            for (Axis axis : this.\u0147) {
                double d2 = range.minimum();
                double d3 = range.size();
                Range<?> range2 = axis.getOutputRange();
                double d4 = range2.minimum();
                double d5 = range2.size();
                Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d4, d3, d5);
                this.\u0101(double_, rectangle, axis);
            }
        }
    }

    Map<String, UserToPixelTransform> \u010c() {
        HashMap<String, UserToPixelTransform> hashMap = new HashMap<String, UserToPixelTransform>();
        for (ChartModel chartModel : this.\u015e) {
            UserToPixelTransform userToPixelTransform;
            Axis axis = this.getAxisForModel(chartModel);
            if (axis == null || (userToPixelTransform = this.getTransformForAxis(axis)) == null) continue;
            hashMap.put(chartModel.getName(), userToPixelTransform);
        }
        return hashMap;
    }

    void \u0102(Graphics2D graphics2D, ChartModel chartModel, int n2, UserToPixelTransform userToPixelTransform) {
        int n3 = this.getXStart();
        int n4 = this.getYEnd();
        graphics2D.translate(-n3, -n4);
        this.\u017e.\u0101(graphics2D, this, chartModel, n2, userToPixelTransform, true);
        graphics2D.translate(n3, n4);
    }

    protected void paintModels(Graphics2D graphics2D, Graphics2D graphics2D2, Shape shape, Shape shape2) {
        ArrayList<Object> arrayList;
        this.\u0145.\u0101();
        this.\u017e.\u0109();
        this.\u0153.\u0104();
        ChartModel chartModel = this.\u0102(this.\u015e);
        if (chartModel == null) {
            arrayList = new ArrayList<ChartModel>(this.\u015e);
        } else {
            arrayList = new ArrayList();
            for (ChartModel chartModel2 : this.\u015e) {
                if (!this.\u0181.isValueFiltered(chartModel2)) continue;
                arrayList.add(chartModel2);
            }
            arrayList.add(chartModel);
        }
        Collections.sort(arrayList, new ZOrderModelComparator(this));
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            ChartModel chartModel2;
            chartModel2 = (ChartModel)arrayList.get(i2);
            if (this.\u0185 == ShadowVisibility.ALL) {
                this.\u0101(graphics2D2, chartModel2, i2, shape, shape2);
                continue;
            }
            if (this.\u0185 == ShadowVisibility.NONE) {
                this.\u0101(graphics2D, chartModel2, i2, shape, shape2);
                continue;
            }
            if (this.\u0185 != ShadowVisibility.SOME) continue;
            if (this.isShadowVisible(chartModel2) && this.\u0156 == 1.0) {
                this.\u0101(graphics2D2, chartModel2, i2, shape, shape2);
                continue;
            }
            this.\u0101(graphics2D, chartModel2, i2, shape, shape2);
        }
        if (!this.isBarsGrouped() && chartModel instanceof SummingChartModel) {
            this.setStyle(chartModel, null, false);
        }
        if (chartModel instanceof SummingChartModel) {
            ((SummingChartModel)chartModel).clear();
        }
        chartModel = null;
        arrayList.clear();
        arrayList = null;
    }

    private ChartModel \u0102(List<ChartModel> list) {
        ChartModel chartModel;
        if (this.isBarsGrouped() || list == null || list.size() == 0) {
            return null;
        }
        ArrayList<ChartModel> arrayList = new ArrayList<ChartModel>();
        for (Object object : list) {
            if (this.\u0181.isValueFiltered((ChartModel)object)) continue;
            arrayList.add((ChartModel)object);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() == 1 && !(arrayList.get(0) instanceof SummingChartModel)) {
            chartModel = (ChartModel)arrayList.get(0);
        } else {
            Object object;
            chartModel = new SummingChartModel();
            ChartStyle chartStyle = this.getStyle((ChartModel)arrayList.get(0));
            object = chartStyle.getBarOrientation();
            ((SummingChartModel)chartModel).setOrientation((Orientation)((Object)object));
            ((SummingChartModel)chartModel).setDelegates(arrayList, false);
            ChartStyle chartStyle2 = new ChartStyle(chartStyle);
            chartStyle2.setBarOrientation((Orientation)((Object)object));
            this.setStyle(chartModel, chartStyle2, false);
        }
        arrayList.clear();
        return chartModel;
    }

    private void \u0101(Graphics2D graphics2D, ChartModel chartModel, int n2, Shape shape, Shape shape2) {
        Axis axis = this.getAxisForModel(chartModel);
        UserToPixelTransform userToPixelTransform = this.getTransformForAxis(axis);
        graphics2D.setClip(shape2);
        this.\u017e.\u0101(graphics2D, this, chartModel, n2, userToPixelTransform, false);
        Stroke stroke = graphics2D.getStroke();
        this.\u0153.\u0101(graphics2D, this, chartModel, n2, userToPixelTransform, false);
        graphics2D.setStroke(stroke);
        this.\u0145.\u0101(graphics2D, this, chartModel, n2, userToPixelTransform, false);
        graphics2D.setClip(shape2);
    }

    void \u0103(Graphics2D graphics2D, ChartModel chartModel, int n2, UserToPixelTransform userToPixelTransform) {
        int n3 = this.getXStart();
        int n4 = this.getYEnd();
        graphics2D.translate(-n3, -n4);
        this.\u0145.\u0101(graphics2D, this, chartModel, n2, userToPixelTransform, true);
        graphics2D.translate(n3, n4);
    }

    public UserToPixelTransform getTransformForAxis(Axis axis) {
        int n2;
        if (axis == null) {
            axis = this.getYAxis();
        }
        if ((n2 = this.\u0147.indexOf(axis)) < 0) {
            n2 = 0;
        }
        try {
            return this.\u014d.get(n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    protected void paintAnnotations(Graphics2D graphics2D) {
        Comparator<ChartAnnotation> comparator = new Comparator<ChartAnnotation>(){

            public int \u0101(ChartAnnotation chartAnnotation, ChartAnnotation chartAnnotation2) {
                int n2;
                int n3 = chartAnnotation.getZOrder();
                if (n3 == (n2 = chartAnnotation2.getZOrder())) {
                    return 0;
                }
                if (n3 < n2) {
                    return -1;
                }
                return 1;
            }
        };
        ArrayList<ChartAnnotation> arrayList = new ArrayList<ChartAnnotation>();
        for (ChartModel object : this.\u015e) {
            AnnotatedChartModel annotatedChartModel;
            if (!(object instanceof AnnotatedChartModel) || !(annotatedChartModel = (AnnotatedChartModel)object).isAnnotationsVisible()) continue;
            for (int i2 = 0; i2 < annotatedChartModel.getAnnotationCount(); ++i2) {
                Annotation annotation = annotatedChartModel.getAnnotation(i2);
                if (!(annotation instanceof ChartAnnotation)) continue;
                arrayList.add((ChartAnnotation)annotation);
            }
        }
        Collections.sort(arrayList, comparator);
        for (ChartAnnotation chartAnnotation : arrayList) {
            chartAnnotation.draw(graphics2D, this);
        }
    }

    void \u0101(Graphics2D graphics2D, ChartModel chartModel, int n2, UserToPixelTransform userToPixelTransform) {
        int n3 = this.getXStart();
        int n4 = this.getYEnd();
        graphics2D.translate(-n3, -n4);
        this.\u0153.\u0101(graphics2D, this, chartModel, n2, userToPixelTransform, true);
        graphics2D.translate(n3, n4);
    }

    @Override
    public double getAnimationPosition() {
        return this.\u0156;
    }

    @Override
    public void setAnimationPosition(double d2) {
        double d3 = this.\u0156;
        this.\u0156 = d2;
        this.firePropertyChange(PROPERTY_ANIMATION_POSITION, d3, d2);
        this.repaint(this.getXStart(), this.getYEnd(), this.getChartWidth(), this.getChartHeight());
    }

    @Override
    public boolean isAnimateOnShow() {
        return this.\u013e;
    }

    @Override
    public void setAnimateOnShow(boolean bl) {
        boolean bl2 = this.\u013e;
        this.\u013e = bl;
        this.firePropertyChange(PROPERTY_ANIMATE_ON_SHOW, bl2, bl);
    }

    @Override
    public void startAnimation() {
        this.\u017d.start();
    }

    @Override
    public void stopAnimation() {
        this.\u017d.stop();
    }

    public int interpolateXForAnimation(int n2, ChartModel chartModel) {
        return this.\u0168.\u0102(n2, chartModel);
    }

    public int interpolateYForAnimation(int n2, ChartModel chartModel) {
        return this.\u0168.\u0101(n2, chartModel);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4096)) {
            Lm.showInvalidProductMessage(Chart.class.getName(), 4096);
        }
        \u0189 = 1;
        \u0186 = 0.05;
    }

    class B
    implements Filter<ChartModel> {
        B() {
        }

        public boolean \u0102(ChartModel chartModel) {
            ChartStyle chartStyle = Chart.this.getStyle(chartModel);
            return chartStyle != null && !chartStyle.isPointsVisible();
        }
    }

    class A
    implements Filter<ChartModel> {
        A() {
        }

        public boolean \u0101(ChartModel chartModel) {
            ChartStyle chartStyle = Chart.this.getStyle(chartModel);
            return chartStyle == null || chartStyle.getLineFill() == null;
        }
    }

    class D
    implements Filter<ChartModel> {
        D() {
        }

        public boolean \u0104(ChartModel chartModel) {
            ChartStyle chartStyle = Chart.this.getStyle(chartModel);
            return chartStyle != null && (!chartStyle.isLinesVisible() || chartStyle.getLineFill() != null);
        }
    }

    class C
    implements Filter<ChartModel> {
        C() {
        }

        public boolean \u0103(ChartModel chartModel) {
            ChartStyle chartStyle = Chart.this.getStyle(chartModel);
            return chartStyle == null || !chartStyle.isBarsVisible();
        }
    }
}

