/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.logging;

import com.yworks.logging.Logger;
import com.yworks.util.Version;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;

public class XmlLogger
extends Logger {
    private PrintWriter pw;

    public XmlLogger(PrintWriter pw) {
        this.pw = pw;
        pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        pw.println("<yshrink version=\"" + Version.getVersion() + "\">");
        this.register();
    }

    @Override
    public void doLog(String s) {
        this.pw.println("<!-- " + s + " -->");
    }

    @Override
    public void doErr(String s) {
        this.pw.println("<!-- ERROR: ");
        this.pw.println(s);
        this.pw.println("-->");
    }

    @Override
    public void doErr(String s, Throwable ex) {
        this.pw.println("<!-- ERROR: ");
        this.pw.println(s);
        ex.printStackTrace(this.pw);
        this.pw.println("-->");
    }

    @Override
    public void doWarn(String s) {
        this.pw.println("<!-- WARNING:" + s + " -->");
    }

    @Override
    public void doWarnToLog(String s) {
        this.pw.println("<!-- WARNING:" + s + " -->");
    }

    @Override
    public void doShrinkLog(String s) {
        this.pw.println(s);
    }

    @Override
    public void close() {
        this.pw.println("</yshrink>");
        this.pw.println();
        this.pw.close();
        this.unregister();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String replaceSpecialChars(String s) {
        StringReader reader = new StringReader(s);
        StringBuilder r = new StringBuilder();
        try {
            int i;
            block6: while ((i = reader.read()) != -1) {
                char c = (char)i;
                switch (c) {
                    case '>': {
                        r.append("&gt;");
                        continue block6;
                    }
                    case '<': {
                        r.append("&lt;");
                        continue block6;
                    }
                }
                r.append(c);
            }
            return r.toString();
        }
        catch (IOException e) {
            Logger.err(e.getMessage());
        }
        return r.toString();
    }
}

