/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.exe4j.runtime.util.FileUtil;
import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.context.Context;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Install4jClassLoader
extends URLClassLoader {
    private static Install4jClassLoader instance = new Install4jClassLoader();
    private static boolean customJarsInitialized = false;
    private Map<String, Class> parentCache = new HashMap<String, Class>();
    private List<URL> addedURLs = new ArrayList<URL>();
    private Class customCodeInvoker;

    public static Install4jClassLoader getInstance() {
        if (!InstallerUtil.isInProcess()) {
            Thread.currentThread().setContextClassLoader(instance);
        }
        return instance;
    }

    public static void clear() {
        instance = new Install4jClassLoader();
    }

    private Install4jClassLoader() {
        super(new URL[0], Install4jClassLoader.class.getClassLoader());
    }

    public void addFile(File file) {
        try {
            this.addURL(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addURL(URL url) {
        this.addedURLs.add(url);
        super.addURL(url);
    }

    @Nullable
    public URL getResourceWithoutParent(@NotNull String name) {
        return this.findResource(name);
    }

    public List<URL> getAddedURLs() {
        return this.addedURLs;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        if (Objects.equals(name, CustomCodeInvoker.class.getName())) {
            this.loadCustomCodeInvoker(name);
            if (this.customCodeInvoker != null) {
                return this.customCodeInvoker;
            }
        }
        if ((c = this.findLoadedClass(name)) == null) {
            c = this.parentCache.get(name);
        }
        if (c == null) {
            if (name.startsWith("com.install4j.runtime.") || name.startsWith("com.install4j.api.") || name.startsWith("com.exe4j.") || name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("com.sun.") || name.startsWith("sun.") || name.startsWith("jdk.") || name.startsWith("org.w3c.") || name.startsWith("org.xml.")) {
                c = super.loadClass(name, resolve);
                this.parentCache.put(name, c);
            } else {
                try {
                    c = this.findClass(name);
                    if (resolve) {
                        this.resolveClass(c);
                    }
                }
                catch (ClassNotFoundException e) {
                    c = super.loadClass(name, resolve);
                    this.parentCache.put(name, c);
                }
            }
        }
        return c;
    }

    private void loadCustomCodeInvoker(String name) {
        if (this.customCodeInvoker == null) {
            InputStream inputStream = CustomCodeInvoker.class.getResourceAsStream(CustomCodeInvoker.class.getName().substring(CustomCodeInvoker.class.getPackage().getName().length() + 1).replace('.', '$') + ".class");
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                FileUtil.pumpStream(inputStream, bout);
                this.customCodeInvoker = this.defineClass(name, bout.toByteArray(), 0, bout.size());
            }
            catch (IOException e) {
                Logger.getInstance().log(e);
            }
        }
    }

    public static void addCustomJarsToClasspath(Context context) {
        if (customJarsInitialized) {
            return;
        }
        customJarsInitialized = true;
        Install4jClassLoader.addClassPathInt(new File(ResourceHelper.getRuntimeDir(), "user.jar"));
        File[] userFiles = new File(ResourceHelper.getRuntimeDir(), "user").listFiles();
        if (userFiles != null) {
            for (File userFile : userFiles) {
                if (!userFile.getName().endsWith(".jar") && !userFile.getName().endsWith(".zip")) continue;
                Install4jClassLoader.addClassPathInt(userFile);
            }
        }
        if (!InstallerConfig.isInstaller()) {
            List<String> customJars = InstallerConfig.getCurrentInstance().getCustomJars();
            for (String customJar : customJars) {
                File destinationFile = context.getDestinationFile(customJar);
                if (destinationFile == null) continue;
                Install4jClassLoader.addClassPathInt(destinationFile);
            }
        }
    }

    public static void addClassPath(final File file) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.ALL, new RunAction(){

            @Override
            protected void run(Context context) {
                Install4jClassLoader.addClassPathInt(file);
            }
        });
    }

    private static void addClassPathInt(File file) {
        try {
            Install4jClassLoader.getInstance().addURL(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static void initHelperState() {
        List<URL> urls = HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction<List<URL>>(){

            @Override
            protected List<URL> fetchValue(Context context) throws Exception {
                return Install4jClassLoader.getInstance().getAddedURLs();
            }
        });
        for (URL url : urls) {
            Install4jClassLoader.getInstance().addURL(url);
        }
    }

    public static Object invokeInCustomClassLoader(Method method, Object object, Object ... args) throws Throwable {
        Class<?> invokerClass = Install4jClassLoader.getInstance().loadClass(CustomCodeInvoker.class.getName(), true);
        try {
            return ((InvocationHandler)invokerClass.newInstance()).invoke(object, method, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public static class CustomCodeInvoker
    implements InvocationHandler {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke(proxy, args);
        }
    }
}

