/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.util.artifact.remote;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlCData;
import com.onseven.dbvis.util.artifact.Artifact;
import com.onseven.dbvis.util.artifact.ArtifactBase;
import com.onseven.dbvis.util.artifact.ArtifactVersion;
import com.onseven.dbvis.util.artifact.remote.d;
import java.io.PrintStream;
import java.util.Objects;

public class RemoteArtifact
extends ArtifactBase {
    @JsonProperty(value="RemoteReference")
    @JacksonXmlCData
    private String remoteReference;

    public RemoteArtifact() {
    }

    private RemoteArtifact(RemoteArtifact remoteArtifact) {
        this.initFrom(remoteArtifact);
        this.remoteReference = remoteArtifact.remoteReference;
    }

    public RemoteArtifact(String string) {
        this.remoteReference = string;
    }

    public String getRemoteReference() {
        return this.remoteReference;
    }

    public void setRemoteReference(String string) {
        this.remoteReference = string;
    }

    @Override
    public ArtifactVersion getArtifactVersion() {
        return null;
    }

    @Override
    public Artifact createCopy() {
        return new RemoteArtifact(this);
    }

    @Override
    public String shortId() {
        String string = "Undefined remote file";
        string = RemoteArtifact.getDownloadFileName(this.remoteReference);
        return string;
    }

    public static String getDownloadFileName(String string) {
        return d.b(string, -1);
    }

    @Override
    public String getIdString() {
        return this.shortId();
    }

    @Override
    public Artifact._b getType() {
        return Artifact._b.h;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RemoteArtifact)) {
            return false;
        }
        RemoteArtifact remoteArtifact = (RemoteArtifact)object;
        return Objects.equals(this.remoteReference, remoteArtifact.remoteReference) && this.areSame(this);
    }

    public int hashCode() {
        return Objects.hash(this.remoteReference);
    }

    @Override
    public void dump(PrintStream printStream) {
        printStream.print("     Artifact:" + this.getType());
        printStream.print("  " + this.remoteReference);
    }

    @Override
    protected String specificExtendedString() {
        return this.remoteReference;
    }

    public boolean areSameDownloadSettings(RemoteArtifact remoteArtifact) {
        if (remoteArtifact == null) {
            return false;
        }
        return Objects.equals(this.remoteReference, remoteArtifact.remoteReference) && Objects.equals(this.isActive(), remoteArtifact.isActive());
    }
}

