/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.util.artifact;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.onseven.dbvis.util.artifact.Artifact;
import com.onseven.dbvis.util.artifact.ArtifactFile;
import com.onseven.dbvis.w.k;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DriverFile
extends ArtifactFile {
    @JacksonXmlProperty(localName="orig", isAttribute=true)
    String originArtifactId;
    @JacksonXmlProperty(localName="artifactType", isAttribute=true)
    Artifact._b artifactType;
    @JacksonXmlElementWrapper(localName="Classes")
    @JacksonXmlProperty(localName="Class")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private List<k> classInfos = new ArrayList<k>();

    public DriverFile(String string, ArtifactFile._b _b2, String string2, Artifact._b _b3) {
        super(string, _b2);
        this.originArtifactId = string2;
        this.artifactType = _b3;
    }

    public DriverFile(String string, Artifact._b _b2) {
        this.originArtifactId = string;
        this.artifactType = _b2;
    }

    public DriverFile(DriverFile driverFile) {
        super(driverFile.getFilePath(), driverFile.getArtifactFileType());
        this.originArtifactId = driverFile.originArtifactId;
        this.artifactType = driverFile.artifactType;
        this.setRootPath(driverFile.getRootPath());
        this.setArtifactFileType(driverFile.getArtifactFileType());
        List<k> list = driverFile.classInfos;
        for (k k2 : list) {
            this.classInfos.add(new k(k2));
        }
    }

    public DriverFile() {
    }

    public boolean updateClassInfos(List<k> list) {
        boolean bl = false;
        if (this.classInfos == null && list == null) {
            return false;
        }
        if (this.classInfos == null && list != null) {
            this.classInfos = list;
            return true;
        }
        if (this.classInfos != null && list != null && this.classInfos.size() != list.size()) {
            this.classInfos = list;
            return true;
        }
        int n2 = 0;
        if (this.classInfos != null && list != null) {
            for (k k2 : list) {
                if (!k2.c().equals(this.classInfos.get(n2).c()) || !k2.b().equals(this.classInfos.get(n2).b())) {
                    bl = true;
                }
                ++n2;
            }
        }
        this.classInfos = list;
        return bl;
    }

    public String getOriginArtifactId() {
        return this.originArtifactId;
    }

    public void setOriginArtifactId(String string) {
        this.originArtifactId = string;
    }

    public Artifact._b getArtifactType() {
        return this.artifactType;
    }

    public void setArtifactType(Artifact._b _b2) {
        this.artifactType = _b2;
    }

    public boolean areSame(DriverFile driverFile) {
        if (driverFile == null) {
            return false;
        }
        if (!this.equals(driverFile)) {
            return false;
        }
        if (!Objects.equals(this.originArtifactId, driverFile.originArtifactId) || !Objects.equals((Object)this.artifactType, (Object)driverFile.artifactType)) {
            return false;
        }
        if (this.classInfos == null && driverFile.classInfos == null) {
            return true;
        }
        if (this.classInfos == null || driverFile.classInfos == null) {
            return false;
        }
        if (this.classInfos.size() != driverFile.classInfos.size()) {
            return false;
        }
        int n2 = 0;
        for (k k2 : this.classInfos) {
            k k3 = driverFile.classInfos.get(n2++);
            if (Objects.equals(k2.c(), k3.c()) && Objects.equals(k2.b(), k3.b())) continue;
            return false;
        }
        return true;
    }

    public void addClassInfo(k k2) {
        this.classInfos.add(k2);
    }

    public List<k> getClassInfos() {
        return this.classInfos;
    }

    public String toString() {
        return this.getFilePath();
    }

    public String debug() {
        return this.getFilePath() + ":" + this.getArtifactType() + ":" + this.getRootPath();
    }
}

