/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.ClusterNode;
import com.exasol.jdbc.ParserResult;
import com.exasol.jdbc.TextUtil;
import com.exasol.jdbc.Translator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EXAURLParser {
    public static final String regexCONNSTR = "CONNSTR";
    public static final String regexDBURL = "DBURL";
    public static final String regexURL = "URL";
    public static final String regexDefaultPort = "DefaultPort";
    public static final String regexPARAMS = "PARAMS";
    public static final String regexFINGERPRINT = "FINGERPRINT";
    public static final String regexEXAType = "EXATYPE";

    public int countChar(String string, String string2) {
        if (string == null || string2 == null) {
            return -1;
        }
        Matcher matcher = Pattern.compile(string2, 32).matcher(string);
        int n = 0;
        while (matcher.find()) {
            ++n;
        }
        return n;
    }

    public static int getIndexOfCharacters(String string, String string2) {
        if (string == null || string2 == null) {
            return -1;
        }
        Matcher matcher = Pattern.compile(string2, 32).matcher(string);
        if (matcher.find()) {
            return matcher.start();
        }
        return -1;
    }

    private String[] resolveURLRanges(String string) throws SQLException {
        String[] stringArray = null;
        if (string.contains(",")) {
            stringArray = TextUtil.split(",", string);
        }
        String string2 = "";
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = string2 + this.resolveRanges(stringArray[i]) + ",";
            }
        } else {
            string2 = this.resolveRanges(string);
        }
        if (string2 != null) {
            return TextUtil.split(",+", string2);
        }
        return string.split("$");
    }

    private String resolveRanges(String string) throws SQLException {
        if (this.countChar(string, "(\\.\\.)") > 1) {
            throw new SQLException(Translator.Cartesian_product_hosts_ports_found() + " URL: " + string);
        }
        Matcher matcher = Pattern.compile("((?<Start>[0-9]+)\\.\\.(?<End>[0-9]+))", 32).matcher(string);
        if (matcher.find()) {
            int n;
            String string2 = string.substring(0, matcher.start("Start"));
            String string3 = string.substring(matcher.end("End"));
            String string4 = matcher.group("Start").trim();
            String string5 = matcher.group("End").trim();
            int n2 = Integer.parseInt(string4);
            if (n2 > (n = Integer.parseInt(string5))) {
                throw new SQLException(Translator.A_range_must_begin_with_the_smaller_number() + " URL: " + string);
            }
            int n3 = n - n2 + 1;
            String string6 = "";
            for (int i = 0; i < n3; ++i) {
                String string7 = "";
                String string8 = Integer.toString(n2 + i);
                if (string8.length() < string4.length()) {
                    char[] cArray = new char[string4.length() - string8.length()];
                    Arrays.fill(cArray, '0');
                    string8 = new String(cArray) + string8;
                }
                string7 = string2 + string8 + string3;
                string6 = string6 + string7 + ",";
            }
            return string6;
        }
        return string;
    }

    private String getFingerprint(String string, String string2) throws SQLException {
        Matcher matcher = Pattern.compile("\\/(?<" + string2 + ">[^;|:|,]+)", 32).matcher(string);
        String string3 = null;
        while (matcher.find()) {
            if (string3 == null) {
                string3 = matcher.group(string2).trim();
                continue;
            }
            if (string3.equalsIgnoreCase(matcher.group(string2).trim())) continue;
            throw new SQLException(Translator.Error_more_than_one_fingerprint());
        }
        if (string3 != null && !string3.matches("[0-9a-zA-Z]+")) {
            int n = EXAURLParser.getIndexOfCharacters(string3, "[^0-9a-zA-Z]");
            if (n >= 0) {
                throw new SQLException("[ERROR] Fingerprint (" + string3 + ") contains " + "invalid character at " + n + " (" + string3.charAt(n) + ").");
            }
            throw new SQLException("[ERROR] Fingerprint (" + string3 + ") contains " + "invalid character.");
        }
        return string3;
    }

    private String readFile(String string) throws SQLException {
        Comparable<File> comparable;
        if (string == null) {
            throw new SQLException("[ERROR] Filename is null.");
        }
        FileInputStream fileInputStream = null;
        try {
            comparable = new File(string);
            ((File)comparable).canRead();
            fileInputStream = new FileInputStream((File)comparable);
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
        comparable = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, Charset.forName(StandardCharsets.UTF_8.name())));){
            int n = 0;
            while ((n = ((Reader)bufferedReader).read()) != -1) {
                ((StringBuilder)comparable).append((char)n);
            }
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
        return ((StringBuilder)comparable).toString();
    }

    private String readHostsFromFile(String string) throws SQLException {
        String string2 = null;
        try {
            string2 = this.readFile(string);
        }
        catch (SQLException sQLException) {
            throw new SQLException(Translator.Error_reading_cluster_string_form_the_file() + string + ". " + sQLException.toString());
        }
        CharSequence[] charSequenceArray = string2.split(",|\n|" + System.getProperty("line.separator"));
        return String.join((CharSequence)",", charSequenceArray);
    }

    public static HashMap<String, String> extractURL(String string) {
        String string2 = "exa|exa-debug|exa-worker|exa-worker-debug";
        String string3 = "^(?<DBURL>jdbc:(?<EXATYPE>" + string2 + "):(?<" + regexURL + ">(.|\\n|" + System.getProperty("line.separator") + "|$)[^;]*))(?<" + regexPARAMS + ">.*$)";
        HashMap<String, String> hashMap = null;
        Matcher matcher = Pattern.compile(string3, 32).matcher(string);
        if (matcher.matches()) {
            String string4 = matcher.group(regexURL);
            Matcher matcher2 = Pattern.compile(":(?<DefaultPort>[0-9]+)(/(?<FINGERPRINT>[0-9a-zA-z]+))*$", 32).matcher(string4);
            String string5 = "";
            String string6 = null;
            if (matcher2.find()) {
                string5 = matcher2.group(regexDefaultPort).trim();
                string4 = string4.substring(0, matcher2.start(regexDefaultPort) - 1);
                String string7 = matcher2.group(regexFINGERPRINT);
                if (string7 != null && string7.trim().length() > 0) {
                    string6 = string7.trim();
                }
            }
            hashMap = new HashMap<String, String>();
            hashMap.put(regexCONNSTR, string);
            hashMap.put(regexEXAType, matcher.group(regexEXAType));
            hashMap.put(regexDBURL, matcher.group(regexDBURL));
            hashMap.put(regexURL, string4);
            hashMap.put(regexDefaultPort, string5);
            hashMap.put(regexPARAMS, matcher.group(regexPARAMS));
            hashMap.put(regexFINGERPRINT, string6);
        }
        return hashMap;
    }

    private HashMap<String, String> parseURL(String string) throws SQLException {
        Object object;
        HashMap<String, String> hashMap = EXAURLParser.extractURL(string);
        if (hashMap == null) {
            return null;
        }
        String string2 = hashMap.get(regexDBURL);
        String string3 = hashMap.get(regexURL);
        String string4 = null;
        String string5 = null;
        if (string3.matches("//(.*):[0-9]+(/[0-9a-zA-Z]+)*")) {
            object = Pattern.compile("//(?<Filename>.*):(?<Port>[0-9]+)(/(?<Fingerprint>[0-9a-zA-Z]+))*", 32).matcher(string3);
            if (((Matcher)object).find()) {
                string5 = ((Matcher)object).group("Filename");
                string4 = this.readHostsFromFile(string5);
            }
        } else if (string3.matches("//(.*)") && ((Matcher)(object = Pattern.compile("//(?<Filename>.*)", 32).matcher(string3))).matches()) {
            string5 = ((Matcher)object).group("Filename");
            string4 = this.readHostsFromFile(string5);
        }
        if (string5 != null) {
            object = "//" + string5;
            string2 = string2.replace((CharSequence)object, string4);
            hashMap.replace(regexDBURL, string2);
            string3 = string3.replace((CharSequence)object, string4);
            hashMap.replace(regexURL, string3);
        }
        return hashMap;
    }

    public ParserResult URLParser(String string) throws SQLException {
        HashMap<String, String> hashMap = this.parseURL(string);
        if (hashMap == null) {
            return null;
        }
        String string2 = this.getFingerprint(hashMap.get(regexURL), regexFINGERPRINT);
        if (string2 != null && hashMap.get(regexFINGERPRINT) != null && !string2.equalsIgnoreCase(hashMap.get(regexFINGERPRINT))) {
            throw new SQLException(Translator.Error_more_than_one_fingerprint());
        }
        if (string2 == null && hashMap.get(regexFINGERPRINT) != null) {
            string2 = hashMap.get(regexFINGERPRINT);
        }
        if (string2 != null) {
            hashMap.replace(regexDBURL, hashMap.get(regexDBURL).replace("/" + string2, ""));
            hashMap.replace(regexURL, hashMap.get(regexURL).replace("/" + string2, ""));
        }
        hashMap.put(regexFINGERPRINT, string2);
        ParserResult parserResult = new ParserResult();
        parserResult.params.setProperty("url", hashMap.get(regexCONNSTR));
        if (System.getProperty("com.exasol.jdbc.debug") != null && System.getProperty("com.exasol.jdbc.debug").equalsIgnoreCase("true") || "exa-debug".equals(hashMap.get(regexEXAType)) || "exa-worker-debug".equals(hashMap.get(regexEXAType))) {
            parserResult.params.setProperty("debug", "1");
        }
        if ("exa-worker".equals(hashMap.get(regexEXAType)) || "exa-worker-debug".equals(hashMap.get(regexEXAType))) {
            parserResult.params.setProperty("worker", "1");
        }
        if (!hashMap.get(regexURL).matches("[0-9a-zA-Z:\\.,\\-/]+")) {
            int n = EXAURLParser.getIndexOfCharacters(hashMap.get(regexURL), "[^0-9a-zA-Z:.,\\-/]");
            if (n >= 0) {
                throw new SQLException(Translator.Invalid_character_in_cluster_string() + " URL: " + hashMap.get(regexURL) + ". Invalid character at: " + n + " (" + hashMap.get(regexURL).charAt(n) + ")");
            }
            throw new SQLException(Translator.Invalid_character_in_cluster_string() + " URL: " + hashMap.get(regexURL));
        }
        String[] stringArray = this.resolveURLRanges(hashMap.get(regexURL));
        Vector vector = parserResult.clusterNodes;
        String string3 = null;
        String string4 = hashMap.get(regexDefaultPort);
        if (string4 != null && string4.trim().length() > 0 && string4.trim().matches("[0-9]+")) {
            string3 = string4.trim();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(new ClusterNode(stringArray[i], string3, hashMap.get(regexFINGERPRINT)));
        }
        if (hashMap.get(regexPARAMS) != null) {
            String string5 = hashMap.get(regexPARAMS);
            Matcher matcher = Pattern.compile("(?<Key>.|[^=;]*)=(?<Value>.[^;=]*)", 32).matcher(hashMap.get(regexPARAMS));
            while (matcher.find()) {
                String string6 = matcher.group("Key");
                String string7 = matcher.group("Value");
                if (string6 == null || string6.length() == 0) {
                    throw new SQLException("[ERROR] Connection String parameters (" + hashMap.get(regexPARAMS) + ") contains invalid parameters.");
                }
                parserResult.params.put(string6, string7);
                string5 = string5.replace(";" + string6 + "=" + string7, "");
            }
            if (!string5.matches("(;|\\s)*")) {
                throw new SQLException("[ERROR] Connection String contains invalid parameters (" + string5 + ").");
            }
        }
        return parserResult;
    }
}

