/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.stats;

import com.nuodb.xml.Tag;
import com.nuodb.xml.TagFactory;

public class ProcessUsageSummary {
    public int idlePercent;
    public int cpuPercent;
    public int runnablePercent;
    public int syncPercent;
    public int lockPercent;
    public int fetchPercent;
    public int commitPercent;
    public int throttlePercent;
    public int networkSendPercent;
    public int archiveReadPercent;
    public int archiveWritePercent;
    public int journalWritePercent;
    public boolean isArchiveNode;
    private long activeTime;
    private long idleTime;
    private long stallPointWaitTime;
    private long syncPointWaitTime;
    private long userMilliseconds;
    private long kernelMilliseconds;
    private long transactionBlockedTime;
    private long platformObjectCheckOpenTime;
    private long platformObjectCheckPopulatedTime;
    private long platformObjectCheckCompleteTime;
    private long loadObjectTime;
    private long remoteCommitTime;
    private long nodeSocketBufferWriteTime;
    private long archiveReadTime;
    private long archiveWriteTime;
    private long archiveFsyncTime;
    private long archiveDirectoryTime;
    private long journalWriteTime;
    private long journalFsyncTime;
    private long journalDirectoryTime;
    private long archiveSyncThrottleTime;
    private long memoryThrottleTime;
    private long writeThrottleTime;
    private long outgoingMessageThrottleTime;
    private long archiveBandwidthThrottleTime;
    private long journalBandwidthThrottleTime;

    public ProcessUsageSummary(boolean isArchiveNode) {
        this.isArchiveNode = isArchiveNode;
    }

    public synchronized void update(Tag status) {
        this.receive(status);
        long deltaTime = this.get(status, "Milliseconds", 0L);
        this.idlePercent = this.percent(this.idleTime, deltaTime);
        this.cpuPercent = this.percent(this.userMilliseconds + this.kernelMilliseconds, this.activeTime);
        this.syncPercent = this.percent(this.syncPointWaitTime + this.stallPointWaitTime - this.platformObjectCheckOpenTime - this.platformObjectCheckPopulatedTime - this.platformObjectCheckCompleteTime, this.activeTime);
        this.lockPercent = this.percent(this.transactionBlockedTime, this.activeTime);
        this.fetchPercent = this.percent(this.platformObjectCheckOpenTime + this.platformObjectCheckPopulatedTime + this.platformObjectCheckCompleteTime + this.loadObjectTime, this.activeTime);
        this.commitPercent = this.percent(this.remoteCommitTime, this.activeTime);
        this.networkSendPercent = this.percent(this.nodeSocketBufferWriteTime, this.activeTime);
        this.archiveReadPercent = this.percent(this.archiveReadTime, this.activeTime);
        this.archiveWritePercent = this.percent(this.archiveWriteTime + this.archiveFsyncTime + this.archiveDirectoryTime, this.activeTime);
        this.journalWritePercent = this.percent(this.journalWriteTime + this.journalFsyncTime + this.journalDirectoryTime, this.activeTime);
        this.throttlePercent = this.percent(this.archiveSyncThrottleTime + this.memoryThrottleTime + this.writeThrottleTime + this.outgoingMessageThrottleTime + this.archiveBandwidthThrottleTime + this.journalBandwidthThrottleTime, this.activeTime);
        this.cpuPercent = Math.min(100, this.cpuPercent);
        this.runnablePercent = 100 - this.cpuPercent - this.syncPercent - this.lockPercent - this.fetchPercent - this.commitPercent - this.throttlePercent - this.networkSendPercent - this.archiveReadPercent - this.archiveWritePercent - this.journalWritePercent;
        this.runnablePercent = Math.max(0, Math.min(100, this.runnablePercent));
        if (this.activeTime == 0L) {
            this.runnablePercent = 0;
        }
    }

    public synchronized String toString() {
        if (this.isArchiveNode) {
            return String.format("Idle %d%% + CPU %d%% Runnable %d%% Sync %d%% Fetch %d%% Throttle %d%% Network Send %d%% Archive Read %d%% Write %d%% Journal %d%%", this.idlePercent, this.cpuPercent, this.runnablePercent, this.syncPercent, this.fetchPercent, this.throttlePercent, this.networkSendPercent, this.archiveReadPercent, this.archiveWritePercent, this.journalWritePercent);
        }
        return String.format("Idle %d%% + CPU %d%% Runnable %d%% Sync %d%% Lock %d%% Fetch %d%% Commit %d%% Throttle %d%% Network Send %d%%", this.idlePercent, this.cpuPercent, this.runnablePercent, this.syncPercent, this.lockPercent, this.fetchPercent, this.commitPercent, this.throttlePercent, this.networkSendPercent);
    }

    public synchronized Tag toXML() {
        Tag tag = TagFactory.createTag("UsageSummary");
        tag.addAttribute("Idle", this.idlePercent);
        tag.addAttribute("CPU", this.cpuPercent);
        tag.addAttribute("Runnable", this.runnablePercent);
        tag.addAttribute("Sync", this.syncPercent);
        tag.addAttribute("Fetch", this.fetchPercent);
        tag.addAttribute("Throttle", this.throttlePercent);
        tag.addAttribute("NetworkSend", this.networkSendPercent);
        if (this.isArchiveNode) {
            tag.addAttribute("ArchiveRead", this.archiveReadPercent);
            tag.addAttribute("ArchiveWrite", this.archiveWritePercent);
            tag.addAttribute("JournalWrite", this.journalWritePercent);
        } else {
            tag.addAttribute("Lock", this.lockPercent);
            tag.addAttribute("Commit", this.commitPercent);
        }
        return tag;
    }

    private void receive(Tag status) {
        this.activeTime = this.get(status, "ActiveTime", this.activeTime);
        this.idleTime = this.get(status, "IdleTime", this.idleTime);
        this.stallPointWaitTime = this.get(status, "StallPointWaitTime", this.stallPointWaitTime);
        this.syncPointWaitTime = this.get(status, "SyncPointWaitTime", this.syncPointWaitTime);
        this.userMilliseconds = this.get(status, "UserMilliseconds", this.userMilliseconds);
        this.kernelMilliseconds = this.get(status, "KernelMilliseconds", this.kernelMilliseconds);
        this.transactionBlockedTime = this.get(status, "TransactionBlockedTime", this.transactionBlockedTime);
        this.platformObjectCheckOpenTime = this.get(status, "PlatformObjectCheckOpenTime", this.platformObjectCheckOpenTime);
        this.platformObjectCheckPopulatedTime = this.get(status, "PlatformObjectCheckPopulatedTime", this.platformObjectCheckPopulatedTime);
        this.platformObjectCheckCompleteTime = this.get(status, "PlatformObjectCheckCompleteTime", this.platformObjectCheckCompleteTime);
        this.loadObjectTime = this.get(status, "LoadObjectTime", this.loadObjectTime);
        this.remoteCommitTime = this.get(status, "RemoteCommitTime", this.remoteCommitTime);
        this.nodeSocketBufferWriteTime = this.get(status, "NodeSocketBufferWriteTime", this.nodeSocketBufferWriteTime);
        this.archiveReadTime = this.get(status, "ArchiveReadTime", this.archiveReadTime);
        this.archiveWriteTime = this.get(status, "ArchiveWriteTime", this.archiveWriteTime);
        this.archiveFsyncTime = this.get(status, "ArchiveFsyncTime", this.archiveFsyncTime);
        this.archiveDirectoryTime = this.get(status, "ArchiveDirectoryTime", this.archiveDirectoryTime);
        this.journalWriteTime = this.get(status, "JournalWriteTime", this.journalWriteTime);
        this.journalFsyncTime = this.get(status, "JournalFsyncTime", this.journalFsyncTime);
        this.journalDirectoryTime = this.get(status, "JournalDirectoryTime", this.journalDirectoryTime);
        this.archiveSyncThrottleTime = this.get(status, "ArchiveSyncThrottleTime", this.archiveSyncThrottleTime);
        this.memoryThrottleTime = this.get(status, "MemoryThrottleTime", this.memoryThrottleTime);
        this.writeThrottleTime = this.get(status, "WriteThrottleTime", this.writeThrottleTime);
        this.outgoingMessageThrottleTime = this.get(status, "OutgoingMessageThrottleTime", this.outgoingMessageThrottleTime);
        this.archiveBandwidthThrottleTime = this.get(status, "ArchiveBandwidthThrottleTime", this.archiveBandwidthThrottleTime);
        this.journalBandwidthThrottleTime = this.get(status, "JournalBandwidthThrottleTime", this.journalBandwidthThrottleTime);
    }

    private long get(Tag status, String attribute, long defaultValue) {
        try {
            return status.getLongAttribute(attribute, defaultValue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private int percent(long numerator, long denominator) {
        if (denominator == 0L) {
            return 0;
        }
        return (int)((numerator * 100L + denominator / 2L) / denominator);
    }
}

