/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.util;

import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;

public class RedshiftProperties
extends Properties {
    public RedshiftProperties() {
        super((Properties)null);
    }

    public RedshiftProperties(Properties defaults) {
        super(defaults);
    }

    public RedshiftProperties(Properties info, Properties defaults) throws RedshiftException {
        super(defaults);
        if (info != null) {
            Enumeration<?> en = info.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String val = info.getProperty(key);
                if (val == null) {
                    throw new RedshiftException(GT.tr("Properties for the driver contains a non-string value for the key ", new Object[0]) + key, RedshiftState.UNEXPECTED_ERROR);
                }
                this.setProperty(key, val);
            }
        }
    }

    @Override
    public String getProperty(String key) {
        return super.getProperty(key.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        return super.setProperty(key.toLowerCase(Locale.ENGLISH), value);
    }
}

