/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yshrink.ant;

import com.yworks.logging.Logger;
import com.yworks.yshrink.core.ClassResolver;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class ResourceCpResolver
implements ClassResolver {
    private Path resource;
    URLClassLoader urlClassLoader;

    public ResourceCpResolver(Path resources, Task target) {
        this.resource = resources;
        String[] list = resources.list();
        ArrayList<URL> listUrls = new ArrayList<URL>();
        for (int i = 0; i < list.length; ++i) {
            try {
                URL url = new File(list[i]).toURL();
                listUrls.add(url);
                continue;
            }
            catch (MalformedURLException mfue) {
                Logger.err("Could not resolve resource: " + mfue);
                target.getProject().log(target, "Could not resolve resource: " + mfue, 1);
            }
        }
        URL[] urls = new URL[listUrls.size()];
        listUrls.toArray(urls);
        this.urlClassLoader = URLClassLoader.newInstance(urls, ClassLoader.getSystemClassLoader());
    }

    @Override
    public Class resolve(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className, false, this.urlClassLoader);
        }
        catch (NoClassDefFoundError ncdfe) {
            String message = ncdfe.getMessage();
            message = message == null || message.equals(className) ? className : message + "[" + className + "]";
            throw new ClassNotFoundException(message, ncdfe);
        }
        catch (LinkageError le) {
            throw new ClassNotFoundException(className, le);
        }
    }

    @Override
    public void close() throws Exception {
        this.urlClassLoader.close();
    }
}

