/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.action.Chevron;
import com.jidesoft.action.CommandBar;
import com.jidesoft.action.CommandBarTitleBar;
import com.jidesoft.action.CommandMenuBar;
import com.jidesoft.action.DockableBar;
import com.jidesoft.plaf.CommandBarUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.Gripper;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SystemInfo;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuBarUI;

public class BasicCommandBarUI
extends CommandBarUI
implements SwingConstants {
    protected JComponent _target;
    protected PropertyChangeListener propertyListener;
    protected ContainerListener containerListener;
    protected ChangeListener changeListener;
    private Gripper \u0103;
    private Chevron \u0101;
    private CommandBarTitleBar \u0104;
    private ThemePainter \u0102;
    protected JMenuBar _menuBar = null;
    MenuBar \u0105;
    B \u0106;

    boolean \u0101(Frame frame) {
        if (frame == null) {
            return false;
        }
        try {
            if (this.\u0105 == null) {
                this.\u0105 = this.\u0101(this._menuBar);
            }
        }
        catch (Throwable throwable) {
            return false;
        }
        if (SystemInfo.isJdk6Above()) {
            frame.setMenuBar(this.\u0105);
        } else {
            if (this.\u0106 == null) {
                this.\u0106 = new B();
            }
            frame.setMenuBar(this.\u0105);
            frame.addWindowListener(this.\u0106);
        }
        return true;
    }

    MenuBar \u0102() {
        if (this.\u0105 == null) {
            this.\u0105 = this.\u0101(this._menuBar);
        }
        return this.\u0105;
    }

    MenuBar \u0101(JMenuBar jMenuBar) {
        try {
            Class<?> clazz = Class.forName("com.apple.laf.ScreenMenuBar");
            return this.\u0101(clazz, jMenuBar);
        }
        catch (Throwable throwable) {
            try {
                Class<?> clazz = Class.forName("apple.laf.ScreenMenuBar");
                return this.\u0101(clazz, jMenuBar);
            }
            catch (Throwable throwable2) {
                return new MenuBar();
            }
        }
    }

    MenuBar \u0101(Class clazz, JMenuBar jMenuBar) throws Exception {
        return (MenuBar)clazz.getConstructor(JMenuBar.class).newInstance(jMenuBar);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (CommandBar.isScreenMenuBar((JMenuBar)jComponent)) {
            Container container = jComponent.getTopLevelAncestor();
            if (container instanceof Frame) {
                this.\u0101((Frame)container);
            }
            return new Dimension(0, 0);
        }
        return null;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicCommandBarUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this._target = jComponent;
        this._menuBar = (JMenuBar)jComponent;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        if (this.\u0105 != null) {
            Frame frame;
            Container container = jComponent.getTopLevelAncestor();
            if (container instanceof Frame && (frame = (Frame)container).getMenuBar() == this.\u0105) {
                frame.setMenuBar(null);
                frame.removeWindowListener(this.\u0106);
            }
            this.\u0105 = null;
        }
        this.uninstallDefaults();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
    }

    protected void installDefaults() {
        this.\u0102 = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        this.\u0101();
        LookAndFeel.installColorsAndFont(this._target, "CommandBar.background", "CommandBar.foreground", "CommandBar.font");
    }

    private void \u0101() {
        if (!(this._target instanceof CommandBar)) {
            return;
        }
        CommandBar commandBar = (CommandBar)this._target;
        if (commandBar.getContext() == null) {
            return;
        }
        if (commandBar.isFloating()) {
            LookAndFeel.installBorder(commandBar, "CommandBar.borderFloating");
        } else if (commandBar.isStretch()) {
            LookAndFeel.installBorder(commandBar, "MenuBar.border");
        } else if (commandBar.isHoriDocked()) {
            LookAndFeel.installBorder(commandBar, "CommandBar.border");
        } else if (commandBar.isVertDocked()) {
            LookAndFeel.installBorder(commandBar, "CommandBar.borderVert");
        } else {
            LookAndFeel.installBorder(commandBar, "CommandBar.border");
        }
    }

    protected void uninstallDefaults() {
        this.\u0102 = null;
    }

    @Override
    public Component getGripper() {
        return this.\u0103;
    }

    @Override
    public Component getTitleBar() {
        return this.\u0104;
    }

    protected void installComponents() {
        if (CommandBar.isScreenMenuBar((JMenuBar)this._target)) {
            return;
        }
        this.\u0103 = new Gripper();
        this.\u0103.setSize(9, this._target.getHeight());
        int n2 = this.\u0103(this._target);
        this.\u0103.setOrientation(n2);
        this._target.add((Component)this.\u0103, 0);
        this.\u0104 = new CommandBarTitleBar(this.\u0102(this._target));
        this.\u0104.setSize(this._target.getWidth(), 14);
        this._target.add((Component)this.\u0104, 1);
        this.\u0101 = new Chevron();
        this.\u0101.setOrientation(n2);
        this.\u0101.setOpaque(true);
        this._target.add((Component)this.\u0101, 2);
    }

    private int \u0103(Component component) {
        int n2 = 0;
        if (component instanceof CommandBar) {
            n2 = ((CommandBar)component).getOrientation();
        } else if (component instanceof JToolBar) {
            n2 = ((JToolBar)component).getOrientation();
        } else if (component instanceof JComponent) {
            n2 = JideSwingUtilities.getOrientationOf(component);
        }
        return n2;
    }

    private String \u0102(Component component) {
        String string = "";
        if (component instanceof CommandBar) {
            string = ((CommandBar)component).getTitle();
        } else if (component instanceof JComponent) {
            string = component.getName();
        }
        return string;
    }

    protected void uninstallComponents() {
        if (this.\u0101 != null) {
            this._target.remove(this.\u0101);
            this.\u0101 = null;
        }
        if (this.\u0104 != null) {
            this._target.remove(this.\u0104);
            this.\u0104 = null;
        }
        if (this.\u0103 != null) {
            this._target.remove(this.\u0103);
            this.\u0103 = null;
        }
    }

    protected void installListeners() {
        this.propertyListener = this.createPropertyListener();
        if (this.propertyListener != null) {
            this._target.addPropertyChangeListener(this.propertyListener);
        }
        this.containerListener = this.createContainerListener();
        if (this.containerListener != null) {
            this._target.addContainerListener(this.containerListener);
        }
        this.changeListener = this.createChangeListener();
        for (int i2 = 0; i2 < this._target.getComponentCount(); ++i2) {
            Component component = this._target.getComponent(i2);
            if (!(component instanceof JMenu)) continue;
            ((JMenu)component).getModel().addChangeListener(this.changeListener);
        }
    }

    protected void uninstallListeners() {
        if (this.propertyListener != null) {
            this._target.removePropertyChangeListener(this.propertyListener);
            this.propertyListener = null;
        }
        if (this.containerListener != null) {
            this._target.removeContainerListener(this.containerListener);
            this.containerListener = null;
        }
        for (int i2 = 0; i2 < this._target.getComponentCount(); ++i2) {
            Component component = this._target.getComponent(i2);
            if (!(component instanceof JMenu)) continue;
            ((JMenu)component).getModel().removeChangeListener(this.changeListener);
        }
        this.changeListener = null;
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.\u0101(1);
        SwingUtilities.replaceUIInputMap(this._target, 1, inputMap);
        ActionMap actionMap = this.\u0104();
        if (actionMap != null) {
            SwingUtilities.replaceUIActionMap(this._target, actionMap);
            if (this._target instanceof CommandMenuBar && SystemInfo.isWindows()) {
                InputMap inputMap2 = this.\u0101(2);
                SwingUtilities.replaceUIInputMap(this._target, 2, inputMap2);
                actionMap.put("takeFocus", new A());
            }
        }
    }

    static void \u0101(Component component) {
        Component component2 = null;
        while (component != null) {
            if (component instanceof JRootPane) {
                component2 = (JRootPane)component;
            }
            component = component.getParent();
        }
        if (component2 != null) {
            component2.repaint();
        } else {
            component.repaint();
        }
    }

    InputMap \u0101(int n2) {
        Object[] objectArray;
        if (n2 == 1) {
            return (InputMap)UIDefaultsLookup.get("CommandBar.ancestorInputMap");
        }
        if (n2 == 2 && (objectArray = (Object[])UIDefaultsLookup.get("MenuBar.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this._target, objectArray);
        }
        return null;
    }

    ActionMap \u0104() {
        ActionMap actionMap = (ActionMap)UIDefaultsLookup.get("CommandBar.actionMap");
        if (actionMap == null && (actionMap = this.\u0103()) != null) {
            UIManager.getLookAndFeelDefaults().put("CommandBar.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap \u0103() {
        return new ActionMapUIResource();
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this._target, null);
        SwingUtilities.replaceUIInputMap(this._target, 1, null);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    protected ChangeListener createChangeListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n2 = BasicCommandBarUI.this._target.getComponentCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Component component = BasicCommandBarUI.this._target.getComponent(i2);
                    if (component == null || !(component instanceof JMenu) || !((JMenu)component).isSelected()) continue;
                    ((CommandBar)BasicCommandBarUI.this._target).getSelectionModel().setSelectedIndex(i2);
                    break;
                }
            }
        };
    }

    protected PropertyChangeListener createPropertyListener() {
        return new PropertyListener();
    }

    protected ContainerListener createContainerListener() {
        return new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component instanceof JMenu) {
                    ((JMenu)component).getModel().addChangeListener(BasicCommandBarUI.this.changeListener);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component instanceof JMenu) {
                    ((JMenu)component).getModel().removeChangeListener(BasicCommandBarUI.this.changeListener);
                }
            }
        };
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        boolean bl;
        boolean bl2;
        if (jComponent instanceof CommandBar) {
            bl2 = ((CommandBar)jComponent).isFloating();
            bl = ((CommandBar)jComponent).isPaintBackground();
        } else {
            bl2 = false;
            bl = jComponent.isOpaque();
        }
        if (bl2) {
            try {
                this.\u0102.paintContentBackground(jComponent, graphics, new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight()), 0, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl) {
            Rectangle rectangle = new Rectangle();
            if (bl2 && this.\u0104 != null && this.\u0104.isVisible()) {
                graphics.setColor(this.getPainter().getColor("control"));
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                rectangle.x = 3;
                rectangle.width = jComponent.getWidth() - 2 * rectangle.x;
                rectangle.y = 20;
                rectangle.height = jComponent.getHeight() - 3 - rectangle.y;
            } else {
                rectangle.x = 0;
                rectangle.y = 0;
                rectangle.width = jComponent.getWidth();
                rectangle.height = jComponent.getHeight();
            }
            if (bl2) {
                this.getPainter().paintFloatingCommandBarBackground(jComponent, graphics, rectangle, JideSwingUtilities.getOrientationOf(jComponent), 0);
            } else {
                this.getPainter().paintCommandBarBackground(jComponent, graphics, rectangle, JideSwingUtilities.getOrientationOf(jComponent), 0);
            }
        }
    }

    public ThemePainter getPainter() {
        if (this.\u0102 == null) {
            this.\u0102 = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        }
        return this.\u0102;
    }

    protected class PropertyListener
    implements PropertyChangeListener {
        protected PropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("lookAndFeel")) {
                BasicCommandBarUI.this._target.updateUI();
            } else if (string.equals("title")) {
                if (BasicCommandBarUI.this.\u0104 != null) {
                    BasicCommandBarUI.this.\u0104.setTitle(BasicCommandBarUI.this.\u0102(BasicCommandBarUI.this._target));
                }
            } else if (string.equals("floatable")) {
                BasicCommandBarUI.this._target.invalidate();
                BasicCommandBarUI.this._target.doLayout();
            } else if (string.equals("rearrangable")) {
                BasicCommandBarUI.this._target.invalidate();
                BasicCommandBarUI.this._target.doLayout();
            } else if (string.equals("hidable")) {
                if (BasicCommandBarUI.this.getTitleBar() != null) {
                    BasicCommandBarUI.this.getTitleBar().invalidate();
                    BasicCommandBarUI.this.getTitleBar().doLayout();
                }
            } else if (string.equals("stretch")) {
                BasicCommandBarUI.this._target.invalidate();
                BasicCommandBarUI.this._target.doLayout();
            } else if (string.equals("orientation")) {
                int n2 = (Integer)propertyChangeEvent.getNewValue();
                ((DockableBar)BasicCommandBarUI.this._target).adjustChildrenOrientation(n2);
            } else if (string.equals("paintBackground")) {
                BasicCommandBarUI.this._target.repaint();
            } else if (string.equals("menuBar") || string.equals("chevronAlwaysVisible")) {
                BasicCommandBarUI.this._target.invalidate();
                BasicCommandBarUI.this._target.doLayout();
            } else if (string.equals("floating")) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                    BasicCommandBarUI.this.\u0101();
                }
            } else if (string.equals("horiDocked")) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                    BasicCommandBarUI.this.\u0101();
                }
            } else if (string.equals("vertDocked") && propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                BasicCommandBarUI.this.\u0101();
            }
        }
    }

    private static class A
    extends AbstractAction {
        private A() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JMenuBar jMenuBar = (JMenuBar)actionEvent.getSource();
            JMenu jMenu = jMenuBar.getMenu(0);
            if (jMenu != null) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                MenuElement[] menuElementArray = new MenuElement[]{jMenuBar, jMenu};
                menuSelectionManager.setSelectedPath(menuElementArray);
                try {
                    WindowsLookAndFeel.setMnemonicHidden((boolean)false);
                }
                catch (IllegalAccessError illegalAccessError) {
                    Logger.getLogger(BasicCommandBarUI.class.getName()).log(Level.FINE, "Exception calling WindowsLookAndFeel.setMnemonicHidden(false)", illegalAccessError);
                }
                BasicCommandBarUI.\u0101(jMenuBar);
            }
        }
    }

    class B
    extends WindowAdapter {
        @Override
        public void windowActivated(WindowEvent windowEvent) {
            if (windowEvent.getWindow() instanceof JFrame) {
                JFrame jFrame = (JFrame)windowEvent.getWindow();
                JMenuBar jMenuBar = jFrame.getJMenuBar();
                MenuBar menuBar = jFrame.getMenuBar();
                if (jMenuBar == null) {
                    if (menuBar == BasicCommandBarUI.this.\u0105) {
                        jFrame.setMenuBar(null);
                    }
                    jFrame.removeWindowListener(this);
                } else if (jMenuBar != BasicCommandBarUI.this._menuBar) {
                    jFrame.removeWindowListener(BasicCommandBarUI.this.\u0106);
                    MenuBarUI menuBarUI = jMenuBar.getUI();
                    if (menuBarUI instanceof BasicCommandBarUI) {
                        ((BasicCommandBarUI)menuBarUI).\u0101(jFrame);
                    }
                }
            }
        }

        B() {
        }
    }
}

