/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.alert.InputPopup;
import com.jidesoft.dialog.StandardDialog;
import com.jidesoft.editor.AbstractCodeEditorIntelliHints;
import com.jidesoft.editor.ClipboardsDialog;
import com.jidesoft.editor.CodeEditorFindAndReplaceTarget;
import com.jidesoft.editor.CodeEditorPainter;
import com.jidesoft.editor.CodeEditorResource;
import com.jidesoft.editor.CodeEditorRowMarginSupport;
import com.jidesoft.editor.CodeEditorSearchable;
import com.jidesoft.editor.CodeEditorSelectionFindAndReplaceTarget;
import com.jidesoft.editor.CodeEditorSettings;
import com.jidesoft.editor.CodeEditorTransferHandler;
import com.jidesoft.editor.CodeInspector;
import com.jidesoft.editor.ColumnGuide;
import com.jidesoft.editor.DefaultCodeEditorSettings;
import com.jidesoft.editor.DefaultSettings;
import com.jidesoft.editor.LazyLoadDocument;
import com.jidesoft.editor.LineBreak;
import com.jidesoft.editor.PageLoadEvent;
import com.jidesoft.editor.PageLoadListener;
import com.jidesoft.editor.SyntaxDocument;
import com.jidesoft.editor.SyntaxStyle;
import com.jidesoft.editor.SyntaxStyleSchema;
import com.jidesoft.editor.SyntaxUtils;
import com.jidesoft.editor.TextUtils;
import com.jidesoft.editor.action.InputHandler;
import com.jidesoft.editor.caret.CaretEvent;
import com.jidesoft.editor.caret.CaretListener;
import com.jidesoft.editor.caret.CaretModel;
import com.jidesoft.editor.caret.CaretPosition;
import com.jidesoft.editor.caret.DefaultCaretModel;
import com.jidesoft.editor.folding.DefaultFoldingModel;
import com.jidesoft.editor.folding.FoldingModel;
import com.jidesoft.editor.folding.FoldingSpan;
import com.jidesoft.editor.folding.FoldingSpanEvent;
import com.jidesoft.editor.folding.FoldingSpanListener;
import com.jidesoft.editor.highlight.DefaultHighlighter;
import com.jidesoft.editor.highlight.Highlighter;
import com.jidesoft.editor.margin.MarginArea;
import com.jidesoft.editor.marker.DefaultMarkerModel;
import com.jidesoft.editor.marker.MarkerArea;
import com.jidesoft.editor.selection.DefaultSelectionModel;
import com.jidesoft.editor.selection.SelectionEvent;
import com.jidesoft.editor.selection.SelectionListener;
import com.jidesoft.editor.selection.SelectionModel;
import com.jidesoft.editor.tokenmarker.Token;
import com.jidesoft.editor.tokenmarker.TokenMarker;
import com.jidesoft.margin.RowNumberMargin;
import com.jidesoft.marker.Marker;
import com.jidesoft.marker.MarkerEvent;
import com.jidesoft.marker.MarkerListener;
import com.jidesoft.marker.MarkerModel;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.popup.JidePopupFactory;
import com.jidesoft.search.FindAndReplace;
import com.jidesoft.search.FindAndReplaceDialog;
import com.jidesoft.search.FindAndReplaceEvent;
import com.jidesoft.search.FindAndReplaceListener;
import com.jidesoft.search.FindAndReplaceResource;
import com.jidesoft.search.FindAndReplaceTarget;
import com.jidesoft.search.FindResult;
import com.jidesoft.search.FindResultIntepreter;
import com.jidesoft.search.FindResults;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.DelayUndoManager;
import com.jidesoft.swing.InfiniteProgressPanel;
import com.jidesoft.swing.JideCursors;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Overlayable;
import com.jidesoft.swing.OverlayableUtils;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import com.jidesoft.swing.StyledLabelBuilder;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.StringUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class CodeEditor
extends JComponent
implements SelectionListener,
CaretListener,
PropertyChangeListener,
FindResultIntepreter,
LineBreak {
    private static final Logger \u0184;
    private boolean \u0167;
    private static TransferHandler \u015d;
    private InputMethodRequests \u0156 = null;
    public static String LEFT_OF_SCROLLBAR;
    public static final String PROPERTY_OVERWRITE_ENABLED = "overwriteEnabled";
    public static final String PROPERTY_FIRST_LINE = "firstLine";
    public static final String PROPERTY_VISIBLE_LINES = "visibleLines";
    public static final String PROPERTY_COLUMN_SELECTION_ENABLED = "columnSelectionEnabled";
    public MarginArea _marginArea;
    public RowNumberMargin _lineNumberMargin;
    protected static List<Transferable> _clipboards;
    private final String \u017e = "nonwordDelimiters";
    public Searchable _searchable;
    private JidePopup \u0165;
    public Timer _inspectionTimer;
    private FoldingModel \u0163;
    private FoldingSpanListener \u0181;
    private MarkerModel \u016f;
    private FindAndReplace \u0169 = null;
    private B \u016d;
    protected CodeEditorSettings _defaultSettings;
    protected DefaultCodeEditorSettings _localSettings;
    private transient Highlighter \u0185;
    private transient Highlighter \u017c;
    private List<ColumnGuide> \u0179;
    private transient boolean \u017d = false;
    private boolean \u0180 = true;
    private int \u0177 = 1;
    private int \u0183 = 1;
    private boolean \u0174 = false;
    private boolean \u0166 = false;
    private ClipboardOwner \u015c;
    private String \u0188;
    private boolean \u0159 = true;
    private boolean \u0164 = true;
    private Rectangle \u0186;
    private Rectangle \u0173;
    private Rectangle \u0158;
    private boolean \u0178;
    private List<FoldingSpan> \u0157;
    private boolean \u0182 = true;
    private boolean \u0187 = false;
    private int \u017b;
    private boolean \u016e = true;
    private boolean \u016c = false;
    private static final int \u0162 = 0;
    private static final int \u016a = 1;
    private static final int \u0175 = 2;
    private com.jidesoft.marker.MarkerArea \u0160;
    private MarkerListener \u017a;
    private List<CodeInspector> \u015b = new LinkedList<CodeInspector>();
    private boolean \u0176 = false;
    public static final String PROPERTY_EDITABLE = "editable";
    protected static String CENTER;
    protected static String RIGHT;
    protected static String LEFT;
    protected static String BOTTOM;
    @Deprecated
    protected static CodeEditor focusedComponent;
    @Deprecated
    protected static Timer caretTimer;
    private Timer \u015e;
    protected CodeEditorPainter _painter;
    protected boolean _caretVisible = true;
    private boolean \u016b;
    protected boolean _editable;
    protected CodeEditorSettings _settings;
    protected int _firstLine;
    protected int _visibleLines;
    protected int _horizontalOffset;
    protected JScrollBar _verticalScrollBar;
    protected JScrollBar _horizontalScrollBar;
    protected boolean _scrollBarsInitialized;
    protected SyntaxDocument _document;
    protected A _documentHandler;
    protected UndoableEditListener _undoableEditListener;
    public Segment lineSegment;
    protected boolean biasLeft;
    protected int bracketPosition;
    protected int bracketLine;
    protected int _magicCaret;
    protected boolean _overwrite;
    private boolean \u0172 = true;
    private Timer \u015f;
    protected CaretModel _caretModel;
    protected SelectionModel _selectionModel;
    public static final String PROPERTY_TAB_SIZE = "tabSize";
    private int \u017f = 4;
    public static final String PROPERTY_REPLACE_TAB_WITH_SPACE = "replaceTabWithSpace";
    private boolean \u0171 = true;
    public static final String PROPERTY_LINE_BREAK_STYLE = "lineBreakStyle";
    private int \u0168 = -2;
    public static final String PROPERTY_MAX_NUMBER_OF_CLIPBOARDS = "maxNumberOfClipboards";
    private int \u0170 = 10;
    private boolean \u0161;
    private static Insets \u015a;
    public static final String SMART_HOME_END_PROPERTY = "InputHandler.homeEnd";

    public CodeEditor() {
        this(DefaultSettings.getDefaults());
    }

    private void \u0111() {
        Highlighter highlighter;
        this.\u0168 = this.getDefaultLineBreakStyle();
        this.setBorder(UIDefaultsLookup.getBorder("TextField.border"));
        this.setAutoscrolls(true);
        this.addMouseWheelListener(new G());
        this._searchable = this.createSearchable(this);
        Highlighter highlighter2 = this.getHighlighter();
        if (highlighter2 == null || highlighter2 instanceof UIResource) {
            this.setHighlighter(this.createHighlighter());
        }
        if ((highlighter = this.getFixedHighlighter()) == null || highlighter instanceof UIResource) {
            this.setFixedHighlighter(this.createHighlighter());
        }
        this.loadActionMap();
    }

    protected Searchable createSearchable(CodeEditor codeEditor) {
        return new CodeEditorSearchable(codeEditor);
    }

    public CodeEditor(DefaultSettings defaultSettings) {
        this.enableEvents(8L);
        this._painter = this.createCodeEditorPainter(this);
        this._defaultSettings = defaultSettings;
        this._localSettings = new DefaultCodeEditorSettings();
        this._documentHandler = new A();
        this.lineSegment = new Segment();
        this.bracketPosition = -1;
        this.bracketLine = -1;
        this.setBlink(true);
        this._undoableEditListener = new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                CodeEditor.this.\u011c();
            }
        };
        this._marginArea = new MarginArea(this);
        this._lineNumberMargin = new RowNumberMargin(new CodeEditorRowMarginSupport(this));
        this._marginArea.add(this._lineNumberMargin);
        this.setLayout(new H());
        this.add(CENTER, this._painter);
        this.add(LEFT, this._marginArea);
        this._verticalScrollBar = this.createScrollBar(1);
        this.add(RIGHT, this._verticalScrollBar);
        this._horizontalScrollBar = this.createScrollBar(0);
        this.add(BOTTOM, this._horizontalScrollBar);
        this._verticalScrollBar.addAdjustmentListener(new E());
        this._horizontalScrollBar.addAdjustmentListener(new E());
        this._painter.addComponentListener(new I());
        K k2 = new K();
        this._painter.addMouseListener(k2);
        this._painter.addMouseMotionListener(k2);
        this.addFocusListener(new J());
        this.initializeDefaultSettings(defaultSettings);
        this.\u016d = new B();
        this.\u016d.\u0101();
        this.\u0111();
        this.setTransferHandler(this.createDefaultTransferHandler());
        DropTarget dropTarget = this.getDropTarget();
        try {
            if (dropTarget != null) {
                dropTarget.addDropTargetListener(new com.jidesoft.editor.G(this));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void swap() {
        this.add(RIGHT, this._marginArea);
        this.add(LEFT, this._verticalScrollBar);
    }

    protected CodeEditorPainter createCodeEditorPainter(CodeEditor codeEditor) {
        return new CodeEditorPainter(codeEditor);
    }

    protected TransferHandler createDefaultTransferHandler() {
        return new CodeEditorTransferHandler(this);
    }

    private void \u011c() {
        UndoManager undoManager = this.getDocument().getUndoManager();
        if (undoManager instanceof DelayUndoManager && !((DelayUndoManager)undoManager).isCacheEmpty()) {
            return;
        }
        Action action = this.\u0104("undo");
        if (action != null) {
            action.setEnabled(undoManager.canUndo());
        }
        if ((action = this.\u0104("redo")) != null) {
            action.setEnabled(undoManager.canRedo());
        }
    }

    protected JScrollBar createScrollBar(int n2) {
        return new JScrollBar(n2);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("blockCaret".equals(propertyChangeEvent.getPropertyName()) || "selectionColor".equals(propertyChangeEvent.getPropertyName()) || "lineHighlight".equals(propertyChangeEvent.getPropertyName()) || "lineHighlightColor".equals(propertyChangeEvent.getPropertyName())) {
            this._painter.invalidateSelectedLines();
        } else if ("bracketHighlightColor".equals(propertyChangeEvent.getPropertyName()) || "bracketHighlight".equals(propertyChangeEvent.getPropertyName())) {
            this._painter.invalidateLine(this.modelToViewPosition((CaretPosition)new CaretPosition((int)this.bracketLine, (int)this.bracketPosition)).line);
        } else if ("specialCharactersColor".equals(propertyChangeEvent.getPropertyName()) || "specialCharacters".equals(propertyChangeEvent.getPropertyName())) {
            this._painter.repaint();
        } else if ("styles".equals(propertyChangeEvent.getPropertyName())) {
            SyntaxStyleSchema syntaxStyleSchema = this.getStyles();
            if (syntaxStyleSchema != null && this.getMarkerArea() != null) {
                Color color;
                Color color2;
                SyntaxStyle syntaxStyle = syntaxStyleSchema.getStyle(11);
                Color color3 = color2 = syntaxStyle == null ? null : syntaxStyle.getStripeColor();
                if (color2 != null) {
                    this.getMarkerArea().registerMarkerColor(0, color2);
                } else {
                    this.getMarkerArea().registerMarkerColor(0, MarkerArea.DEFAULT_WARNING_COLOR);
                }
                SyntaxStyle syntaxStyle2 = syntaxStyleSchema.getStyle(12);
                Color color4 = color = syntaxStyle2 == null ? null : syntaxStyle2.getStripeColor();
                if (color != null) {
                    this.getMarkerArea().registerMarkerColor(1, color);
                } else {
                    this.getMarkerArea().registerMarkerColor(1, MarkerArea.DEFAULT_WARNING_COLOR);
                }
                this._painter.repaint();
            }
        } else if ("font".equals(propertyChangeEvent.getPropertyName())) {
            this.setFont((Font)propertyChangeEvent.getNewValue());
        } else if ("caretBlinks".equals(propertyChangeEvent.getPropertyName())) {
            if (Boolean.FALSE.equals(propertyChangeEvent.getNewValue())) {
                this.setBlink(false);
            }
            this._painter.invalidateSelectedLines();
        }
        this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    @Override
    public TransferHandler getTransferHandler() {
        TransferHandler transferHandler = super.getTransferHandler();
        if (transferHandler == null) {
            if (\u015d == null) {
                \u015d = new com.jidesoft.editor.H();
            }
            return \u015d;
        }
        return transferHandler;
    }

    public final SyntaxStyleSchema getStyles() {
        if (this._localSettings.getStyles() != null) {
            return this._localSettings.getStyles();
        }
        return this._defaultSettings.getStyles();
    }

    public final void setStyles(SyntaxStyleSchema syntaxStyleSchema) {
        this._localSettings.setStyles(syntaxStyleSchema);
        this.repaint();
    }

    public final Color getCaretColor() {
        if (this._localSettings.getCaretColor() != null) {
            return this._localSettings.getCaretColor();
        }
        return this._defaultSettings.getCaretColor();
    }

    public final void setCaretColor(Color color) {
        this._localSettings.setCaretColor(color);
    }

    public final Color getSelectionColor() {
        if (this._localSettings.getSelectionColor() != null) {
            return this._localSettings.getSelectionColor();
        }
        return this._defaultSettings.getSelectionColor();
    }

    public final void setSelectionColor(Color color) {
        this._localSettings.setSelectionColor(color);
    }

    public final Color getLineHighlightColor() {
        if (this._localSettings.getLineHighlightColor() != null) {
            return this._localSettings.getLineHighlightColor();
        }
        return this._defaultSettings.getLineHighlightColor();
    }

    public final void setLineHighlightColor(Color color) {
        this._localSettings.setLineHighlightColor(color);
    }

    public final boolean isLineHighlightVisible() {
        if (this._localSettings.isLineHighlightVisibleSet()) {
            return this._localSettings.isLineHighlightVisible();
        }
        return this._defaultSettings.isLineHighlightVisible();
    }

    public final void setLineHighlight(boolean bl) {
        this._localSettings.setLineHighlightVisible(bl);
    }

    public final Color getBracketHighlightColor() {
        if (this._localSettings.getBracketHighlightColor() != null) {
            return this._localSettings.getBracketHighlightColor();
        }
        return this._defaultSettings.getBracketHighlightColor();
    }

    public final void setBracketHighlightColor(Color color) {
        this._localSettings.setBracketHighlightColor(color);
    }

    public final boolean isBracketHighlightVisible() {
        if (this._localSettings.isBracketHighlightVisibleSet()) {
            return this._localSettings.isBracketHighlightVisible();
        }
        return this._defaultSettings.isBracketHighlightVisible();
    }

    public final void setBracketHighlightVisible(boolean bl) {
        this._localSettings.setBracketHighlightVisible(bl);
    }

    public final boolean isBlockCaret() {
        if (this._localSettings.isBlockCaretSet()) {
            return this._localSettings.isBlockCaret();
        }
        return this._defaultSettings.isBlockCaret();
    }

    public final void setBlockCaret(boolean bl) {
        this._localSettings.setBlockCaret(bl);
    }

    public final boolean isCaretBlinks() {
        if (this._localSettings.isCaretBlinksSet()) {
            return this._localSettings.isCaretBlinks();
        }
        return this._defaultSettings.isCaretBlinks();
    }

    public void setCaretBlinks(boolean bl) {
        this._localSettings.setCaretBlinks(bl);
    }

    public final Color getSpecialCharactersColor() {
        if (this._localSettings.getSpecialCharactersColor() != null) {
            return this._localSettings.getSpecialCharactersColor();
        }
        return this._defaultSettings.getSpecialCharactersColor();
    }

    public final void setSpecialCharactersColor(Color color) {
        this._localSettings.setSpecialCharactersColor(color);
    }

    public final boolean isSpecialCharactersVisible() {
        if (this._localSettings.isSpecialCharactersSet()) {
            return this._localSettings.isSpecialCharactersVisible();
        }
        return this._defaultSettings.isSpecialCharactersVisible();
    }

    public final void setSpecialCharactersVisible(boolean bl) {
        this._localSettings.setSpecialCharactersVisible(bl);
    }

    public boolean isPaintInvalid() {
        if (this._localSettings.isPaintInvalidSet()) {
            return this._localSettings.isPaintInvalid();
        }
        return this._defaultSettings.isPaintInvalid();
    }

    public void setPaintInvalid(boolean bl) {
        this._localSettings.setPaintInvalid(bl);
    }

    public boolean isVirtualSpaceAllowed() {
        if (this._localSettings.isVirtualSpaceAllowedSet()) {
            return this._localSettings.isVirtualSpaceAllowed();
        }
        return this._defaultSettings.isVirtualSpaceAllowed();
    }

    public void setVirtualSpaceAllowed(boolean bl) {
        this._localSettings.setVirtualSpaceAllowed(bl);
    }

    public com.jidesoft.marker.MarkerArea getMarkerArea() {
        return this.\u0160;
    }

    public void setMarkerArea(com.jidesoft.marker.MarkerArea markerArea) {
        this.\u0160 = markerArea;
    }

    public void initializeDefaultSettings(DefaultSettings defaultSettings) {
        this.setFont(defaultSettings.getFont());
        this.setDocument(new SyntaxDocument());
        this.getDocument().putProperty("nonwordDelimiters", "_");
        this._settings = defaultSettings;
        this._editable = true;
    }

    public void addCodeInspector(CodeInspector codeInspector) {
        this.\u015b.add(codeInspector);
    }

    public void removeCodeInspector(CodeInspector codeInspector) {
        this.\u015b.remove(codeInspector);
    }

    public CodeInspector[] getCodeInspectors() {
        return this.\u015b.toArray(new CodeInspector[this.\u015b.size()]);
    }

    public int getCodeInspectorCount() {
        return this.\u015b.size();
    }

    public CodeInspector getCodeInspector(int n2) {
        return this.\u015b.get(n2);
    }

    public boolean isAutoInspecting() {
        return this.\u0176;
    }

    public void setAutoInspecting(boolean bl) {
        if (this.\u0176 != bl) {
            this.\u0176 = bl;
            if (this.isAutoInspecting()) {
                this.inspectCode();
            } else {
                this.stopInspectCode();
            }
        }
    }

    public void stopInspectCode() {
        if (this._inspectionTimer != null && this._inspectionTimer.isRunning()) {
            this._inspectionTimer.stop();
        }
    }

    public void inspectCode() {
        this.inspectCode(null);
    }

    public void inspectCode(final DocumentEvent documentEvent) {
        if (this._inspectionTimer == null) {
            this._inspectionTimer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            if (CodeEditor.this.\u0160 != null) {
                                CodeEditor.this.\u0160.setInspecting(true);
                            }
                            for (CodeInspector codeInspector : CodeEditor.this.\u015b) {
                                codeInspector.inspect(CodeEditor.this, documentEvent, CodeEditor.this.getMarkerModel());
                            }
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    if (CodeEditor.this.\u0160 != null) {
                                        CodeEditor.this.\u0160.requireMinimumMode(0);
                                        CodeEditor.this.\u0160.setInspecting(false);
                                    }
                                }
                            };
                            SwingUtilities.invokeLater(runnable);
                        }
                    };
                    thread.start();
                }
            });
            this._inspectionTimer.setRepeats(false);
        }
        if (this._inspectionTimer.isRunning()) {
            this._inspectionTimer.restart();
        } else {
            this._inspectionTimer.start();
        }
    }

    public int getLineHeight() {
        return this._painter.getLineHeight();
    }

    @Override
    public final boolean isManagingFocus() {
        return true;
    }

    public final CodeEditorPainter getPainter() {
        return this._painter;
    }

    public final InputHandler getInputHandler() {
        if (this._localSettings.getInputHandler() != null) {
            return this._localSettings.getInputHandler();
        }
        return this._defaultSettings.getInputHandler();
    }

    public void setInputHandler(InputHandler inputHandler) {
        this._localSettings.setInputHandler(inputHandler);
    }

    public final boolean isCaretVisible() {
        return (!this.isCaretBlinks() || this.isBlink()) && this._caretVisible;
    }

    public void setCaretVisible(boolean bl) {
        this._caretVisible = bl;
        this.setBlink(true);
        this._painter.invalidateSelectedLines();
    }

    public final void blinkCaret() {
        if (this.\u015e == null) {
            this.\u015e = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (CodeEditor.this.hasFocus()) {
                        CodeEditor.this.blinkCaret();
                    }
                }
            });
            this.\u015e.setInitialDelay(500);
            this.\u015e.start();
        }
        if (!this.\u015e.isRunning()) {
            this.\u015e.restart();
        }
        if (this.isCaretBlinks()) {
            if (this.getPainter()._composedTextLayout == null) {
                this.setBlink(!this.\u016b);
            } else {
                this.setBlink(false);
            }
            this._painter.invalidateSelectedLines();
            this._painter.invalidateLine(this.getCaretModel().getViewPosition().line);
        } else {
            this.setBlink(true);
        }
    }

    public final int getElectricScroll() {
        if (this._localSettings.getElectricScroll() != -1) {
            return this._localSettings.getElectricScroll();
        }
        return this._defaultSettings.getElectricScroll();
    }

    public final void setElectricScroll(int n2) {
        this._localSettings.setElectricScroll(n2);
    }

    public void updateScrollBars() {
        int n2;
        if (this._verticalScrollBar != null && this._visibleLines != 0) {
            this._verticalScrollBar.setValues(this._firstLine, this._visibleLines, 0, this.getVisualLineCount() + 1);
            this._verticalScrollBar.setUnitIncrement(2);
            this._verticalScrollBar.setBlockIncrement(this._visibleLines);
            n2 = this.getVerticalScrollBarPolicy();
            if (n2 == 1) {
                this._verticalScrollBar.setVisible(true);
            } else if (n2 == 2) {
                this._verticalScrollBar.setVisible(false);
            } else if (n2 == 0) {
                this._verticalScrollBar.setVisible(this._visibleLines <= this.getVisualLineCount() + 1);
            }
            if (this.getMarkerArea() != null) {
                this.getMarkerArea().updateMarkerAreaHeight(0);
            }
        }
        n2 = this._painter.getWidth();
        if (this._horizontalScrollBar != null && n2 != 0) {
            this._horizontalScrollBar.setValues(-this._horizontalOffset, n2, 0, this.getContentSize().width);
            this._horizontalScrollBar.setUnitIncrement(this._painter.getFontMetrics().charWidth('w'));
            this._horizontalScrollBar.setBlockIncrement(n2 / 2);
            int n3 = this.getHorizontalScrollBarPolicy();
            if (n3 == 1) {
                this._horizontalScrollBar.setVisible(true);
            } else if (n3 == 2) {
                this._horizontalScrollBar.setVisible(false);
            } else if (n3 == 0) {
                this._horizontalScrollBar.setVisible(n2 <= this.getContentSize().width || this.getHorizontalOffset() < 0);
            }
            if (this.getMarkerArea() != null) {
                this.getMarkerArea().updateMarkerAreaHeight(0);
            }
        }
    }

    public final int getFirstLine() {
        if (this._firstLine < 0) {
            this.setFirstLine(0);
        } else if (this._firstLine >= this.getLineCount()) {
            this.setFirstLine(this.getLineCount() - this.getVisibleLines() + 1);
            if (this.getCaretModel().getModelPosition().line >= this.getLineCount()) {
                this.setCaretPosition(this.getDocumentLength());
            }
        }
        return this._firstLine;
    }

    public void setFirstLine(int n2) {
        if (n2 == this._firstLine) {
            return;
        }
        int n3 = this._firstLine;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 + this.getVisibleLines() > this.getVisualLineCount()) {
            n2 = this.getVisualLineCount() - this.getVisibleLines() + (this.\u0167 ? 1 : 0);
        }
        if (n2 < 0) {
            n2 = 0;
        }
        this._firstLine = n2;
        if (n2 != this._verticalScrollBar.getValue()) {
            this.updateScrollBars();
        }
        this._painter.repaint();
        this._marginArea.repaint();
        this.firePropertyChange(PROPERTY_FIRST_LINE, n3, this._firstLine);
    }

    public final int getVisibleLines() {
        return this._visibleLines;
    }

    public final void recalculateVisibleLines() {
        if (this._painter == null) {
            return;
        }
        int n2 = this._visibleLines;
        int n3 = this._painter.getHeight();
        int n4 = this.getLineHeight();
        if (n4 == 0) {
            this._visibleLines = 0;
        } else if (n3 <= 0) {
            this._visibleLines = 0;
            this.\u0167 = false;
        } else {
            this._visibleLines = n3 / n4;
            boolean bl = this.\u0167 = n3 % n4 != 0;
            if (this.\u0167) {
                ++this._visibleLines;
            }
        }
        this.updateScrollBars();
        if (n2 != this._visibleLines) {
            this.firePropertyChange(PROPERTY_VISIBLE_LINES, n2, this._visibleLines);
        }
    }

    public final int getHorizontalOffset() {
        return this._horizontalOffset;
    }

    public void setHorizontalOffset(int n2) {
        if (n2 == this._horizontalOffset) {
            return;
        }
        this._horizontalOffset = n2;
        if (n2 != this._horizontalScrollBar.getValue()) {
            this.updateScrollBars();
        }
        this._painter.repaint();
    }

    public boolean setOrigin(int n2, int n3) {
        boolean bl = false;
        if (n3 != this._horizontalOffset) {
            this.setHorizontalOffset(n3);
            bl = true;
        }
        if (n2 != this._firstLine) {
            this.setFirstLine(n2);
            bl = true;
        }
        if (bl) {
            this.updateScrollBars();
            this._painter.repaint();
            this._marginArea.repaint();
        }
        return bl;
    }

    public boolean scrollToCaret() {
        return this.\u0103(false);
    }

    boolean \u0103(boolean bl) {
        CaretPosition caretPosition;
        boolean bl2 = false;
        if (this.\u016d.\u0102) {
            bl2 = true;
        } else {
            caretPosition = this.getCaretModel().getViewPosition();
            int n2 = this.columnToX(caretPosition.line, caretPosition.column);
            int n3 = n2 - this.getHorizontalOffset();
            if (n3 > this.getContentSize().width) {
                bl2 = true;
            }
        }
        if (bl2) {
            this.\u016d.\u0103 = true;
            this.updateScrollBars();
        }
        caretPosition = null;
        if (bl) {
            caretPosition = this.getSelectionModel().hasSelection() ? this.offsetToViewPosition(this.getSelectionStart() == this.getCaretModel().getOffset() ? this.getSelectionEnd() : this.getSelectionStart()) : null;
        }
        return this.scrollToViewPosition(this.getCaretModel().getViewPosition(), caretPosition);
    }

    public boolean scrollTo(CaretPosition caretPosition) {
        return this.scrollToViewPosition(this.modelToViewPosition(caretPosition));
    }

    public boolean scrollToViewPosition(CaretPosition caretPosition) {
        return this.scrollToViewPosition(caretPosition, null);
    }

    protected boolean scrollToViewPosition(CaretPosition caretPosition, CaretPosition caretPosition2) {
        int n2;
        int n3;
        int n4;
        if (this._visibleLines == 0) {
            this.setFirstLine(Math.max(0, caretPosition.line - this.getElectricScroll()));
            return true;
        }
        int n5 = this._firstLine;
        int n6 = this._horizontalOffset;
        if (caretPosition.line < this._firstLine + this.getElectricScroll()) {
            n5 = Math.max(0, caretPosition.line - this.getElectricScroll());
            if (caretPosition2 != null) {
                n4 = caretPosition2.line;
                n3 = caretPosition.line;
                n2 = Math.abs(n4 - n3) + 1;
                n5 = n2 >= this._visibleLines ? Math.max(0, Math.min(n3, n4) - this.getElectricScroll()) : Math.max(0, Math.min(n3, n4) - this.getElectricScroll() - (this._visibleLines - n2) / 2);
            }
        } else if (caretPosition.line + this.getElectricScroll() >= this._firstLine + this._visibleLines) {
            n5 = caretPosition.line - this._visibleLines + this.getElectricScroll() + 1;
            if (caretPosition2 != null) {
                n4 = caretPosition2.line;
                n3 = caretPosition.line;
                n2 = Math.abs(n4 - n3) + 1;
                n5 = n2 >= this._visibleLines ? Math.max(n3, n4) - this._visibleLines + this.getElectricScroll() + 1 : Math.max(n3, n4) - this._visibleLines + this.getElectricScroll() + 1 + (this._visibleLines - n2) / 2;
            }
            if (n5 + this._visibleLines >= this.getLineCount()) {
                n5 = this.getLineCount() - this._visibleLines + 1;
            }
            if (n5 < 0) {
                n5 = 0;
            }
        }
        n4 = n3 = this.columnToX(caretPosition.line, caretPosition.column);
        if (caretPosition2 != null) {
            n4 = this.columnToX(caretPosition2.line, caretPosition2.column);
        }
        n2 = this._painter.getFontMetrics().charWidth('w');
        if (Math.max(n3, n4) + n2 >= this._painter.getWidth()) {
            n6 = this._horizontalOffset + (this._painter.getWidth() - Math.max(n3, n4)) - n2 - 5;
        } else if (Math.min(n3, n4) < 0) {
            n6 = Math.max(n3, n4) + n2 - this._horizontalOffset < this._painter.getWidth() ? 0 : (n3 < 0 ? Math.min(0, this._horizontalOffset - Math.min(n3, n4) + n2 + 5) : this._horizontalOffset + n2);
        } else {
            CaretPosition caretPosition3 = this.getCaretModel().getViewPosition();
            int n7 = this.columnToX(caretPosition3.line, caretPosition3.column);
            int n8 = n7 - this.getHorizontalOffset();
            if (n8 == this.getContentSize().width && (n6 = this._horizontalOffset + (this._painter.getWidth() - n3) - n2 - 5) >= 0) {
                n6 = 0;
            }
        }
        return this.setOrigin(n5, n6);
    }

    protected DocumentEvent createReplaceAllDocumentEvent() {
        return new DocumentEvent(){

            @Override
            public int getOffset() {
                return 0;
            }

            @Override
            public int getLength() {
                return CodeEditor.this.getDocumentLength();
            }

            @Override
            public Document getDocument() {
                return CodeEditor.this.getDocument();
            }

            @Override
            public DocumentEvent.EventType getType() {
                return DocumentEvent.EventType.CHANGE;
            }

            @Override
            public DocumentEvent.ElementChange getChange(Element element) {
                return null;
            }
        };
    }

    public int lineToY(int n2) {
        FontMetrics fontMetrics = this._painter.getFontMetrics();
        return (n2 - this._firstLine) * fontMetrics.getHeight() - (fontMetrics.getLeading() + fontMetrics.getMaxDescent());
    }

    public int yToLine(int n2) {
        return this.\u0107(n2);
    }

    private int \u0107(int n2) {
        FontMetrics fontMetrics = this._painter.getFontMetrics();
        int n3 = fontMetrics.getHeight();
        return Math.max(0, n2 / n3 + this._firstLine);
    }

    public final int offsetToX(int n2) {
        this._painter.currentLineTokens = null;
        return this._offsetToX(n2);
    }

    @Deprecated
    public final int offsetToX(int n2, int n3) {
        this._painter.currentLineTokens = null;
        return this._offsetToX(n3 + this.getLineStartOffset(n2));
    }

    @Deprecated
    public int _offsetToX(int n2, int n3) {
        return this._offsetToX(n3 + this.getLineStartOffset(n2));
    }

    public int _offsetToX(int n2) {
        if (this.isIntegerScaleFactor()) {
            return this.getIntegerOffsetToX(n2);
        }
        return this.getFractionalOffsetToX(n2);
    }

    protected int getIntegerOffsetToX(int n2) {
        Object object;
        int n3;
        TokenMarker tokenMarker = this.getTokenMarker();
        FontMetrics fontMetrics = this._painter.getFontMetrics();
        int n4 = this.getLineNumber(n2);
        if (n4 < 0 || n4 >= this.getLineCount()) {
            return this._horizontalOffset;
        }
        if (n2 == 0 && n4 == 0 || !this.getLineText(n4, this.lineSegment)) {
            return this._horizontalOffset;
        }
        int n5 = n2 - this.getLineStartOffset(n4);
        int n6 = this.lineSegment.offset;
        int n7 = this._horizontalOffset;
        Token token = null;
        if (tokenMarker != null) {
            if (this._painter.currentLineIndex == n4 && this._painter.currentLineTokens != null) {
                token = this._painter.currentLineTokens;
            } else {
                this._painter.currentLineIndex = n4;
                token = this._painter.currentLineTokens = tokenMarker.markTokens(this.lineSegment, n4);
            }
        }
        if (this.getFoldingModel().isEnabled() && tokenMarker != null) {
            int n8 = this.getLineStartOffset(n4);
            int n9 = this.getLineEndOffset(n4);
            n3 = this.getLineEndOffsetExcludeLineBreak(n4);
            int n10 = this.modelToViewLine(n4);
            object = new com.jidesoft.editor.E(this, n8);
            if (n9 >= ((com.jidesoft.editor.E)object).\u0104() && n8 > ((com.jidesoft.editor.E)object).\u0101()) {
                while (n9 >= ((com.jidesoft.editor.E)object).\u0104() && (((com.jidesoft.editor.E)object).\u0102() == null || n8 >= ((com.jidesoft.editor.E)object).\u0104()) && ((com.jidesoft.editor.E)object).\u0104() < this.getDocumentLength()) {
                    ((com.jidesoft.editor.E)object).\u0103();
                }
            } else if (n9 >= ((com.jidesoft.editor.E)object).\u0104() && n8 == ((com.jidesoft.editor.E)object).\u0101() && ((com.jidesoft.editor.E)object).\u0102() == null) {
                ((com.jidesoft.editor.E)object).\u0103();
            }
            if (((com.jidesoft.editor.E)object).\u0102() != null) {
                if (((com.jidesoft.editor.E)object).\u0101() >= n8 && ((com.jidesoft.editor.E)object).\u0104() >= n9) {
                    int n11 = ((com.jidesoft.editor.E)object).\u0102().getStartOffset();
                    int n12 = this.getLineNumber(n11);
                    if (n12 != n4 && n11 != this.getLineStartOffset(n12)) {
                        this.getLineText(n12, this.lineSegment);
                        token = tokenMarker.markTokens(this.lineSegment, n12);
                        n7 = SyntaxUtils.\u0101(this, this.lineSegment, 0, n11 - this.getLineStartOffset(n12), token, n7);
                        this.getLineText(n4, this.lineSegment);
                        token = tokenMarker.markTokens(this.lineSegment, n4);
                    }
                    if (n5 <= ((com.jidesoft.editor.E)object).\u0101() - n8) {
                        return SyntaxUtils.\u0101(this, this.lineSegment, 0, n5, token, n7);
                    }
                    n7 = SyntaxUtils.\u0101(this, this.lineSegment, 0, ((com.jidesoft.editor.E)object).\u0101() - n8, token, n7);
                    if (n5 < ((com.jidesoft.editor.E)object).\u0104() - n8 && n5 != n3) {
                        return n7;
                    }
                    n7 = SyntaxUtils.\u0101(this, ((com.jidesoft.editor.E)object).\u0102().getDescription(), n7);
                    int n13 = this.getLineNumber(((com.jidesoft.editor.E)object).\u0104() + 1);
                    int n14 = this.modelToViewLine(n13);
                    if (n14 == n10) {
                        if (n5 <= n3) {
                            return SyntaxUtils.\u0101(this, this.lineSegment, ((com.jidesoft.editor.E)object).\u0104() - n8, n5, token, n7);
                        }
                        n7 = SyntaxUtils.\u0101(this, this.lineSegment, ((com.jidesoft.editor.E)object).\u0104() - n8, -1, token, n7);
                        n7 += this.getPainter().getFontMetrics().charWidth(' ') * (n5 - n3);
                    }
                    return n7;
                }
                if (((com.jidesoft.editor.E)object).\u0101() >= n8 && ((com.jidesoft.editor.E)object).\u0104() < n9) {
                    int n15 = ((com.jidesoft.editor.E)object).\u0102().getStartOffset();
                    int n16 = this.getLineNumber(n15);
                    if (n16 != n4 && n15 != this.getLineStartOffset(n16)) {
                        this.getLineText(n16, this.lineSegment);
                        token = tokenMarker.markTokens(this.lineSegment, n16);
                        n7 = SyntaxUtils.\u0101(this, this.lineSegment, 0, n15 - this.getLineStartOffset(n16), token, n7);
                        this.getLineText(n4, this.lineSegment);
                        token = tokenMarker.markTokens(this.lineSegment, n4);
                    }
                    if (n5 <= ((com.jidesoft.editor.E)object).\u0101() - n8) {
                        return SyntaxUtils.\u0101(this, this.lineSegment, 0, n5, token, n7);
                    }
                    n7 = SyntaxUtils.\u0101(this, this.lineSegment, 0, ((com.jidesoft.editor.E)object).\u0101() - n8, token, n7);
                    if (n5 < ((com.jidesoft.editor.E)object).\u0104() - n8 && n5 != n3) {
                        return n7;
                    }
                    n7 = SyntaxUtils.\u0101(this, ((com.jidesoft.editor.E)object).\u0102().getDescription(), n7);
                    if (n5 <= n3) {
                        return SyntaxUtils.\u0101(this, this.lineSegment, ((com.jidesoft.editor.E)object).\u0104() - n8, n5, token, n7);
                    }
                    n7 = SyntaxUtils.\u0101(this, this.lineSegment, ((com.jidesoft.editor.E)object).\u0104() - n8, -1, token, n7);
                    return n7 + this.getPainter().getFontMetrics().charWidth(' ') * (n5 - n3);
                }
                if (((com.jidesoft.editor.E)object).\u0101() < n8 && ((com.jidesoft.editor.E)object).\u0104() >= n9) {
                    System.out.println("not reached 1");
                } else {
                    if (((com.jidesoft.editor.E)object).\u0101() < n8 && ((com.jidesoft.editor.E)object).\u0104() < n9) {
                        if (n5 <= n3) {
                            return SyntaxUtils.\u0101(this, this.lineSegment, ((com.jidesoft.editor.E)object).\u0104() - n8, n5, token, n7);
                        }
                        n7 = SyntaxUtils.\u0101(this, this.lineSegment, ((com.jidesoft.editor.E)object).\u0104() - n8, -1, token, n7);
                        return n7 + this.getPainter().getFontMetrics().charWidth(' ') * (n5 - n3);
                    }
                    System.out.println("not reached 2");
                }
                return n7;
            }
        }
        if (tokenMarker == null || n4 > this.getLineCount()) {
            this.lineSegment.count = n5;
            try {
                return n7 + Utilities.getTabbedTextWidth(this.lineSegment, fontMetrics, n7, (TabExpander)this._painter, 0);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return n7;
            }
        }
        Font font = this._painter.getFont();
        SyntaxStyleSchema syntaxStyleSchema = this.getStyles();
        while ((n3 = (int)token.id) != 127) {
            SyntaxStyle syntaxStyle = syntaxStyleSchema.getStyle(n3);
            object = this._painter.getGraphics();
            if (object == null) {
                fontMetrics = this._painter.getFontMetrics();
            } else {
                if (syntaxStyle == null || n3 == 0 && syntaxStyle.getForeground() == null) {
                    if (!font.equals(((Graphics)object).getFont())) {
                        ((Graphics)object).setFont(font);
                    }
                } else {
                    syntaxStyle.setGraphicsFlags((Graphics)object, font);
                }
                fontMetrics = ((Graphics)object).getFontMetrics();
            }
            int n17 = token.length;
            if (n5 + n6 < this.lineSegment.offset + n17) {
                this.lineSegment.count = n5 - (this.lineSegment.offset - n6);
                return n7 + Utilities.getTabbedTextWidth(this.lineSegment, fontMetrics, n7, (TabExpander)this._painter, 0);
            }
            this.lineSegment.count = n17;
            n7 += Utilities.getTabbedTextWidth(this.lineSegment, fontMetrics, n7, (TabExpander)this._painter, 0);
            this.lineSegment.offset += n17;
            token = token.next;
        }
        return n7;
    }

    public int xToColumn(int n2) {
        FontMetrics fontMetrics = this._painter.getFontMetrics();
        return (n2 - this.getHorizontalOffset()) / fontMetrics.charWidth('w');
    }

    public int xToColumn(int n2, int n3) {
        FontMetrics fontMetrics;
        int n4;
        int n5 = this.xToOffset(n2, n3);
        int n6 = this.offsetToViewPosition((int)n5).column;
        int n7 = this.offsetToX(n5);
        if (n7 < n3 && (n4 = (fontMetrics = this._painter.getFontMetrics()).charWidth(' ')) > 0) {
            n6 += (n3 - n7) / n4;
        }
        return n6;
    }

    @Deprecated
    public int columnToX(int n2) {
        FontMetrics fontMetrics = this._painter.getFontMetrics();
        return n2 * fontMetrics.charWidth('w') + this.getHorizontalOffset();
    }

    public int columnToX(int n2, int n3) {
        int n4;
        CaretPosition caretPosition = new CaretPosition(n2, n3);
        CaretPosition caretPosition2 = this.viewToModelPosition(caretPosition);
        int n5 = caretPosition2.line;
        int n6 = this.getLineEndOffsetExcludeLineBreak(n5);
        int n7 = this.offsetToX(this.modelPositionToOffset(caretPosition2));
        FontMetrics fontMetrics = this._painter.getFontMetrics();
        if (caretPosition2.column > n6) {
            n7 += (caretPosition2.column - n6) * fontMetrics.charWidth(' ');
        }
        if ((n4 = n3 - this.modelToViewPosition((CaretPosition)caretPosition2).column) > 0) {
            n7 += n4 * fontMetrics.charWidth(' ');
        }
        return n7;
    }

    protected int getLineEndOffsetExcludeLineBreak(int n2) {
        char c2;
        int n3;
        String string = this.getLineText(n2);
        for (n3 = string.length(); n3 > 0 && ((c2 = string.charAt(n3 - 1)) == '\r' || c2 == '\n'); --n3) {
        }
        return n3;
    }

    public int xToOffset(int n2, int n3) {
        int n4;
        int n5;
        Object object;
        int n6;
        if (!this.isIntegerScaleFactor()) {
            n6 = this.getLineStartOffset(n2);
            object = this.getLineText(n2);
            for (n5 = 0; n5 < ((String)object).length(); ++n5) {
                n4 = this._offsetToX(n6 + n5);
                if (n4 < n3) continue;
                return n6 + n5;
            }
        }
        n6 = this.getHorizontalOffset();
        n3 -= n6;
        object = this.getTokenMarker();
        n5 = this.viewToModelLine(n2);
        if (!this.getLineText(n5, this.lineSegment)) {
            return 0;
        }
        n4 = this.getLineStartOffset(n5);
        if (this.getFoldingModel().isEnabled() && object != null) {
            int n7 = this.getLineEndOffset(n5);
            int n8 = this.getLineEndOffsetExcludeLineBreak(n5);
            com.jidesoft.editor.E e2 = new com.jidesoft.editor.E(this, n4);
            if (n7 >= e2.\u0104() && n4 > e2.\u0101()) {
                while (n7 >= e2.\u0104() && (e2.\u0102() == null || n4 >= e2.\u0104()) && e2.\u0104() < this.getDocumentLength()) {
                    e2.\u0103();
                }
            } else if (n7 >= e2.\u0104() && n4 == e2.\u0101() && e2.\u0102() == null) {
                e2.\u0103();
            }
            if (e2.\u0102() != null) {
                Token token;
                if (this._painter.currentLineIndex == n5 && this._painter.currentLineTokens != null) {
                    token = this._painter.currentLineTokens;
                } else {
                    this._painter.currentLineIndex = n5;
                    token = this._painter.currentLineTokens = ((TokenMarker)object).markTokens(this.lineSegment, n5);
                }
                if (e2.\u0101() >= n4 && e2.\u0104() >= n7) {
                    int n9 = SyntaxUtils.\u0101(this, this.lineSegment, 0, e2.\u0101() - n4, token, 0);
                    if (n3 <= n9) {
                        return this.calculateOffset(n3, n5, n4);
                    }
                    if ((n3 -= n9) < (n9 = SyntaxUtils.\u0101(this, e2.\u0102().getDescription(), 0))) {
                        return e2.\u0101();
                    }
                    int n10 = this.getLineNumber(e2.\u0104());
                    if ((n3 -= n9) == 0 && n10 != n5) {
                        return n4;
                    }
                    int n11 = this.modelToViewLine(n10);
                    if (n11 == n2) {
                        n8 = this.getLineEndOffsetExcludeLineBreak(n10);
                        this.getLineText(n10, this.lineSegment);
                        token = this._painter.currentLineTokens = ((TokenMarker)object).markTokens(this.lineSegment, n10);
                        int n12 = this.getLineStartOffset(n10);
                        n9 = SyntaxUtils.\u0101(this, this.lineSegment, e2.\u0104() - n12, -1, token, 0);
                        if (n3 <= n9) {
                            return this.calculateOffset(n3, n10, e2.\u0104());
                        }
                        n4 = n12;
                    }
                    return n4 + n8;
                }
                if (e2.\u0101() >= n4 && e2.\u0104() < n7) {
                    int n13 = SyntaxUtils.\u0101(this, this.lineSegment, 0, e2.\u0101() - n4, token, 0);
                    if (n3 <= n13) {
                        return this.calculateOffset(n3, n5, n4);
                    }
                    if ((n3 -= n13) < (n13 = SyntaxUtils.\u0101(this, e2.\u0102().getDescription(), 0))) {
                        return e2.\u0101();
                    }
                    if ((n3 -= n13) == 0) {
                        return n4;
                    }
                    n13 = SyntaxUtils.\u0101(this, this.lineSegment, e2.\u0104() - n4, -1, token, 0);
                    if (n3 <= n13) {
                        return this.calculateOffset(n3, n5, e2.\u0104());
                    }
                    return n4 + n8;
                }
                if (e2.\u0101() < n4 && e2.\u0104() >= n7) {
                    System.out.println("not reached 1");
                } else {
                    if (e2.\u0101() < n4 && e2.\u0104() < n7) {
                        int n14 = SyntaxUtils.\u0101(this, this.lineSegment, e2.\u0104() - n4, -1, token, 0);
                        if (n3 <= n14) {
                            return this.calculateOffset(n3, n5, e2.\u0104());
                        }
                        return n4 + n8;
                    }
                    System.out.println("not reached 2");
                }
            }
        }
        return Math.min(this.calculateOffset(n3, n5, n4), this.getLineStartOffset(n5) + this.getLineEndOffsetExcludeLineBreak(n5));
    }

    protected int calculateOffset(int n2, int n3, int n4) {
        Token token;
        FontMetrics fontMetrics = this._painter.getFontMetrics();
        TokenMarker tokenMarker = this.getTokenMarker();
        this.getLineText(n3, this.lineSegment);
        int n5 = n4 - this.getLineStartOffset(n3);
        char[] cArray = this.lineSegment.array;
        this.lineSegment.count = Math.min(this.lineSegment.count, this.getLineEndOffsetExcludeLineBreak(n3) + 1);
        int n6 = this.lineSegment.offset + n5;
        int n7 = this.lineSegment.count - n5;
        int n8 = 0;
        boolean bl = this.isBlockCaret();
        if (tokenMarker == null) {
            for (int i2 = 0; i2 < n7; ++i2) {
                int n9;
                char c2 = cArray[i2 + n6];
                if (c2 == '\t') {
                    int n10 = n8 + this.getHorizontalOffset();
                    n9 = (int)this._painter.nextTabStop(n10, i2) - n10;
                } else {
                    n9 = fontMetrics.charWidth(c2);
                }
                if (bl ? n2 - n9 <= n8 : n2 - n9 / 2 <= n8) {
                    return n4 + i2;
                }
                n8 += n9;
            }
            return n4 + n7 - 1;
        }
        if (this._painter.currentLineIndex == n3 && this._painter.currentLineTokens != null) {
            token = this._painter.currentLineTokens;
        } else {
            this._painter.currentLineIndex = n3;
            token = this._painter.currentLineTokens = tokenMarker.markTokens(this.lineSegment, n3);
        }
        int n11 = 0;
        Font font = this._painter.getFont();
        SyntaxStyleSchema syntaxStyleSchema = this.getStyles();
        byte by;
        while ((by = token.id) != 127) {
            fontMetrics = by == 0 || this._painter.getGraphics() == null ? this._painter.getFontMetrics() : syntaxStyleSchema.getStyle(by).getFontMetrics(font, this._painter.getGraphics());
            int n12 = token.length;
            for (int i3 = 0; i3 < n12; ++i3) {
                int n13;
                int n14 = n6 + n11 + i3;
                if (n14 >= cArray.length) continue;
                char c3 = cArray[n14];
                if (c3 == '\t') {
                    int n15 = n8 + this.getHorizontalOffset();
                    n13 = (int)this._painter.nextTabStop(n15, n11 + i3) - n15;
                } else {
                    n13 = fontMetrics.charWidth(c3);
                }
                if (bl ? n2 - n13 <= n8 : n2 - n13 / 2 <= n8) {
                    return n4 + n11 + i3;
                }
                n8 += n13;
            }
            n11 += n12;
            token = token.next;
        }
        return n4 + Math.max(0, n11 - 1);
    }

    public int xyToOffset(int n2, int n3) {
        int n4 = this.yToLine(n3);
        int n5 = this.xToColumn(n4, n2);
        return this.modelPositionToOffset(this.viewToModelPosition(new CaretPosition(n4, n5)));
    }

    public final SyntaxDocument getDocument() {
        return this._document;
    }

    public void setDocument(SyntaxDocument syntaxDocument) {
        if (this._document == syntaxDocument) {
            return;
        }
        if (this._document != null) {
            this._document.removeDocumentListener(this._documentHandler);
            this._document.removeUndoableEditListener(this._undoableEditListener);
            if (this.getFoldingModel() instanceof DocumentListener) {
                this._document.removeDocumentListener((DocumentListener)((Object)this.getFoldingModel()));
            }
            if (this.getMarkerModel() instanceof DocumentListener) {
                this._document.removeDocumentListener((DocumentListener)((Object)this.getMarkerModel()));
            }
            if (this._document instanceof LazyLoadDocument) {
                ((LazyLoadDocument)this._document).removePageLoadingListener(this._documentHandler);
            }
        }
        SyntaxDocument syntaxDocument2 = this._document;
        this._document = syntaxDocument;
        if (this._document != null) {
            this._document.addDocumentListener(this._documentHandler);
            if (this.getFoldingModel() instanceof DocumentListener) {
                this._document.addDocumentListener((DocumentListener)((Object)this.getFoldingModel()));
            }
            if (this.getMarkerModel() instanceof DocumentListener) {
                this._document.addDocumentListener((DocumentListener)((Object)this.getMarkerModel()));
            }
            this._document.addUndoableEditListener(this._undoableEditListener);
            if (this._document instanceof LazyLoadDocument) {
                ((LazyLoadDocument)this._document).addPageLoadingListener(this._documentHandler);
            }
            this.select(0, 0);
            if (this.\u016d != null) {
                this.\u016d.\u0101();
            }
            this.updateScrollBars();
            this._painter.repaint();
        }
        this.firePropertyChange("document", syntaxDocument2, this._document);
    }

    public final TokenMarker getTokenMarker() {
        return this._document.getTokenMarker();
    }

    public final void setTokenMarker(TokenMarker tokenMarker) {
        this._document.setTokenMarker(tokenMarker);
    }

    public final int getDocumentLength() {
        if (this._document == null) {
            return 0;
        }
        return this._document.getLength();
    }

    public final int getLineCount() {
        if (this._document == null) {
            return 0;
        }
        return this._document.getLineCount();
    }

    public int getVisualLineCount() {
        int n2 = this.getLineCount();
        return n2 -= ((DefaultFoldingModel)this.getFoldingModel()).getFoldedLinesCountBefore(this.getDocument().getLength() + 1);
    }

    public final int getLineNumber(int n2) {
        return this._document.getLineNumber(n2);
    }

    public int getLineStartOffset(int n2) {
        if (this._document == null) {
            return 0;
        }
        return this._document.getLineStartOffset(n2);
    }

    public int getLineStartOffsetNoSpace(int n2) {
        if (this._document == null) {
            return 0;
        }
        int n3 = this.getLineStartOffset(n2);
        while (n3 < this._document.getLength()) {
            try {
                char c2 = this._document.getText(n3, 1).charAt(0);
                if (!Character.isSpaceChar(c2)) break;
                ++n3;
            }
            catch (BadLocationException badLocationException) {
                \u0184.warning(badLocationException.getLocalizedMessage());
            }
        }
        return n3;
    }

    public int getLineEndOffset(int n2) {
        if (this._document == null) {
            return 0;
        }
        return this._document.getLineEndOffset(n2);
    }

    public int getLineLength(int n2) {
        if (this._document == null) {
            return 0;
        }
        return this._document.getLineLength(n2);
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        this.exportText(this.getRawText(), stringBuffer);
        return stringBuffer.toString();
    }

    public void setText(String string) {
        if (string == null) {
            this.setRawText("");
            this.setLineBreakStyle(-2);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = this.importText(string.substring(0, Math.min(1000, string.length())), stringBuffer);
            if (n2 == 2) {
                stringBuffer = new StringBuffer();
                int n3 = CodeEditor.\u011f();
                n2 = SyntaxDocument.convertLineBreaks(string, stringBuffer, TextUtils.getLineBreak(n3 != 2 ? n3 : 1));
                this.setLineBreakStyle(n2);
                this.setRawText(stringBuffer.toString());
            } else if (string.length() < 1000) {
                this.setLineBreakStyle(n2);
                this.setRawText(stringBuffer.toString());
            } else if (n2 != this.getLineBreakStyle()) {
                stringBuffer = new StringBuffer();
                n2 = this.importText(string, stringBuffer);
                this.setLineBreakStyle(n2);
                this.setRawText(stringBuffer.toString());
            } else {
                this.setRawText(string);
            }
        }
    }

    public void append(String string) {
        SyntaxDocument syntaxDocument = this.getDocument();
        if (syntaxDocument != null) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = this.importText(string, stringBuffer);
                if (n2 != -2 && n2 != this.getLineBreakStyle()) {
                    this.setLineBreakStyle(-1);
                }
                syntaxDocument.insertString(syntaxDocument.getLength(), stringBuffer.toString(), null);
            }
            catch (BadLocationException badLocationException) {
                \u0184.warning(badLocationException.getLocalizedMessage());
            }
        }
    }

    public final String getText(int n2, int n3) {
        try {
            return this._document.getText(n2, n3);
        }
        catch (BadLocationException badLocationException) {
            \u0184.warning(badLocationException.getLocalizedMessage());
            return "";
        }
    }

    public final void getText(int n2, int n3, Segment segment) {
        try {
            if (n3 > 0) {
                this._document.getText(n2, n3, segment);
            }
        }
        catch (BadLocationException badLocationException) {
            \u0184.warning(badLocationException.getLocalizedMessage());
            segment.count = 0;
            segment.offset = 0;
        }
    }

    protected int exportText(String string, StringBuffer stringBuffer) {
        int n2 = this.getLineBreakStyle();
        String string2 = TextUtils.getLineBreak(n2);
        return SyntaxDocument.convertLineBreaks(string, stringBuffer, string2);
    }

    protected int importText(String string, StringBuffer stringBuffer) {
        return SyntaxDocument.convertLineBreaks(string, stringBuffer);
    }

    public String getRawText() {
        try {
            return this._document.getText(0, this._document.getLength());
        }
        catch (BadLocationException badLocationException) {
            \u0184.warning(badLocationException.getLocalizedMessage());
            return null;
        }
    }

    public void setRawText(String string) {
        try {
            this.getFoldingModel().removeAllFoldingSpans();
            TokenMarker tokenMarker = this.getDocument() == null ? null : this.getDocument().getTokenMarker();
            DocumentListener[] documentListenerArray = this.getDocument() == null ? null : this.getDocument().getDocumentListeners();
            DocumentFilter documentFilter = this.getDocument() == null ? null : this.getDocument().getDocumentFilter();
            Dictionary<Object, Object> dictionary = this.getDocument() == null ? null : this.getDocument().getDocumentProperties();
            UndoableEditListener[] undoableEditListenerArray = this.getDocument() == null ? null : this.getDocument().getUndoableEditListeners();
            this.setDocument(new SyntaxDocument());
            this.getDocument().putProperty("nonwordDelimiters", "_");
            if (tokenMarker != null) {
                this.getDocument().setTokenMarker(tokenMarker);
            }
            if (documentListenerArray != null) {
                for (DocumentListener eventListener : documentListenerArray) {
                    this.getDocument().removeDocumentListener(eventListener);
                    this.getDocument().addDocumentListener(eventListener);
                }
            }
            if (documentFilter != null) {
                this.getDocument().setDocumentFilter(documentFilter);
            }
            if (dictionary != null) {
                this.getDocument().setDocumentProperties(dictionary);
            }
            this.getDocument().insertString(0, string, null);
            if (undoableEditListenerArray != null) {
                for (EventListener eventListener : undoableEditListenerArray) {
                    if (eventListener instanceof SyntaxDocument.MyUndoableEditListener) continue;
                    this.getDocument().removeUndoableEditListener((UndoableEditListener)eventListener);
                    this.getDocument().addUndoableEditListener((UndoableEditListener)eventListener);
                }
            }
            this.select(0);
            this.discardAllEdits();
            this.getCaretModel().setOffset(0);
            this.getMarginArea().invalidate();
            this.resetContentSize();
            this.doLayout();
            this.getMarginArea().doLayout();
            this.updateScrollBars();
        }
        catch (BadLocationException badLocationException) {
            \u0184.warning(badLocationException.getLocalizedMessage());
        }
    }

    public final String getLineText(int n2) {
        int n3;
        int n4 = this.getLineStartOffset(n2);
        if (n4 != -1 && (n3 = this.getLineEndOffset(n2)) >= n4) {
            return this.getText(n4, n3 - n4 + 1);
        }
        return "";
    }

    public final boolean getLineText(int n2, Segment segment) {
        int n3;
        if (n2 >= 0 && n2 < this.getLineCount() && (n3 = this.getLineStartOffset(n2)) != -1) {
            this.getText(n3, this.getLineEndOffset(n2) - n3 + 1, segment);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLineText(int n2, String string) {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        this._document.beginCompoundEdit();
        int n3 = this.getLineStartOffset(n2);
        int n4 = this.getLineEndOffset(n2);
        try {
            this._document.remove(n3, n4 - n3);
            StringBuffer stringBuffer = new StringBuffer();
            int n5 = this.importText(string, stringBuffer);
            if (n5 != -2 && n5 != this.getLineBreakStyle()) {
                this.setLineBreakStyle(-1);
            }
            this._document.insertString(n3, stringBuffer.toString(), null);
        }
        catch (BadLocationException badLocationException) {
            \u0184.warning(badLocationException.getLocalizedMessage());
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    public final int getSelectionStart() {
        return this.getSelectionModel().getSelectionStart() < this.getSelectionModel().getSelectionEnd() ? this.getSelectionModel().getSelectionStart() : this.getSelectionModel().getSelectionEnd();
    }

    public int getSelectionStart(int n2) {
        if (this.getSelectionModel().isColumnSelectionMode()) {
            Element element = this._document.getDefaultRootElement();
            int n3 = this.getSelectionModel().getSelectionEndViewPosition() == null || this.getSelectionModel().getSelectionStartViewPosition() == null ? (this.getSelectionModel().getSelectionStart() > this.getSelectionModel().getSelectionEnd() ? this.getCaretModel().getViewPosition().column : this.offsetToViewPosition((int)this.getSelectionStart()).column) : Math.min(this.getSelectionModel().getSelectionStartViewPosition().column, this.getSelectionModel().getSelectionEndViewPosition().column);
            Element element2 = element.getElement(n2);
            int n4 = element2.getStartOffset();
            int n5 = element2.getEndOffset() - 1;
            return Math.min(n5, n4 + this.getCorrespondingColumn(n3, this.getSelectionStartLine(), n2));
        }
        if (n2 == this.getSelectionStartLine()) {
            return this.getSelectionStart();
        }
        return this.getLineStartOffset(n2);
    }

    public final int getSelectionStartLine() {
        return this.getSelectionModel().getSelectionStartLine() <= this.getSelectionModel().getSelectionEndLine() ? this.getSelectionModel().getSelectionStartLine() : this.getSelectionModel().getSelectionEndLine();
    }

    public final void setSelectionStart(int n2) {
        this.select(n2, this.getSelectionEnd());
    }

    public final void surroundSelection(String string, String string2) {
        String string3 = this.getSelectedText();
        if (string3 != null) {
            this.setSelectedText(string + string3 + string2);
        } else {
            this.setSelectedText(string + string2);
        }
    }

    public void selectWord() {
        int n2 = this.getCaretModel().getModelPosition().line;
        int n3 = this.getLineStartOffset(n2);
        int n4 = this.getCaretModel().getOffset() - n3;
        if (this.getLineLength(n2) == 0) {
            return;
        }
        String string = this.getLineText(n2);
        String string2 = (String)this.getDocument().getProperty("nonwordDelimiters");
        if (n4 == this.getLineLength(n2)) {
            --n4;
        }
        if (string.length() > 0) {
            int n5 = TextUtils.findWordEnd(string, n4, string2);
            int n6 = TextUtils.findWordStart(string, n4 - (n5 == n4 ? 1 : 0), string2);
            this.getSelectionModel().setSelection(n3 + n6, n3 + n5);
        }
    }

    public void selectWord(String string) {
        int[] nArray = this.getCurrentWordBounds(string);
        this.select(nArray[0], nArray[1]);
    }

    public int[] getCurrentWordBounds() {
        return this.getCurrentWordBounds((String)this.getDocument().getProperty("nonwordDelimiters"));
    }

    public String getLeftWordPart() {
        return this.getLeftWordPart((String)this.getDocument().getProperty("nonwordDelimiters"));
    }

    public String getLeftWordPart(String string) {
        int n2 = this.getCaretModel().getOffset();
        int n3 = this.getCaretModel().getModelPosition().line;
        int n4 = this.getLineStartOffset(n3);
        int n5 = 0;
        String string2 = this.getLineText(this.getCaretModel().getModelPosition().line);
        if ((n2 -= n4) > 0) {
            n5 = TextUtils.findWordStart(string2, n2, string);
        }
        return string2.substring(n5, n2);
    }

    public int[] getCurrentWordBounds(String string) {
        int n2 = this.getCaretModel().getOffset();
        int n3 = this.getCaretModel().getModelPosition().line;
        int n4 = this.getLineStartOffset(n3);
        int n5 = 0;
        String string2 = this.getLineText(this.getCaretModel().getModelPosition().line);
        if ((n2 -= n4) == 0) {
            n5 = n4;
        } else if (n2 > 0) {
            n5 = n4 + TextUtils.findWordStart(string2, n2, string);
        }
        if (n2 < string2.length()) {
            n2 = TextUtils.findWordEnd(string2, n2, string);
        }
        return new int[]{n5, n2 += n4};
    }

    public String getCurrentWord() {
        int[] nArray = this.getCurrentWordBounds();
        return this.getText(nArray[0], nArray[1] - nArray[0]);
    }

    public String getCurrentWord(String string) {
        int[] nArray = this.getCurrentWordBounds(string);
        return this.getText(nArray[0], nArray[1] - nArray[0]);
    }

    public void selectToMatchingBracket() {
        int n2 = this.getCaretModel().getOffset();
        int n3 = -1;
        try {
            n3 = TextUtils.findMatchingBracket(this._document, n2 - 1);
        }
        catch (BadLocationException badLocationException) {
            \u0184.warning(badLocationException.getLocalizedMessage());
        }
        if (n3 != -1 && n3 != n2) {
            if (n3 > n2) {
                this.select(n2, n3 + 1);
            } else {
                this.select(n3, n2);
            }
        } else {
            this.selectBlock();
        }
    }

    public void selectBlock() {
        int n2;
        int n3 = this.getSelectionStart();
        int n4 = this.getSelectionEnd();
        String[] stringArray = new String[]{"<", "(", "{", "[", ">", ")", "}", "]"};
        String string = "<({[";
        String string2 = ">)}]";
        if (!(n3 != 0 || this.getDocumentLength() > 0 && string.contains(this.getText(n3, 1)))) {
            PortingUtils.notifyUser();
            return;
        }
        int n5 = 1;
        String string3 = null;
        String string4 = null;
        ++n3;
        while (n3 > 0) {
            n3 = this.getDocument().findPrevious(stringArray, n3, 0, false, false);
            try {
                if (this._document.isInCommentOrLiteral(n3)) {
                    --n3;
                    continue;
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            if (n3 < 0) {
                return;
            }
            char c2 = this.getText(n3, 1).charAt(0);
            n2 = string.indexOf(c2);
            if (n2 != -1) {
                if (--n5 == 0) {
                    string3 = "" + c2;
                    string4 = "" + string2.charAt(n2);
                    break;
                }
            } else if (string2.indexOf(c2) != -1 && n3 < this.getSelectionStart()) {
                ++n5;
            }
            --n3;
        }
        if (string3 == null) {
            PortingUtils.notifyUser();
            return;
        }
        n5 = 1;
        String[] stringArray2 = new String[]{string3, string4};
        n2 = this.getDocumentLength();
        if (n4 <= n3) {
            n4 = n3 + 1;
        }
        while (n4 < n2) {
            n4 = this.getDocument().findNext(stringArray2, n4, n2, false);
            try {
                if (this._document.isInCommentOrLiteral(n4)) {
                    ++n4;
                    continue;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (n4 < 0) {
                return;
            }
            char c3 = this.getText(n4, 1).charAt(0);
            if (c3 == string4.charAt(0)) {
                if (--n5 == 0) {
                    ++n4;
                    break;
                }
            } else if (c3 == string3.charAt(0)) {
                ++n5;
            }
            ++n4;
        }
        this.select(n3, n4);
    }

    public void gotoEndOfLine() {
        int n2 = this.viewToModelLine(this.getCaretModel().getViewPosition().line + 1) - 1;
        CaretPosition caretPosition = new CaretPosition(n2, this.getLineEndOffsetExcludeLineBreak(n2));
        this.select(this.modelPositionToOffset(caretPosition));
    }

    public void commentLine(int n2) {
        String string = this.getLineText(n2);
        int n3 = this.getLineStartOffset(n2);
        if (string.startsWith("//")) {
            this.select(n3, n3 + 2);
            this.setSelectedText("");
        } else {
            this.select(n3);
            this.setSelectedText("//");
        }
    }

    public void commentLine() {
        int n2;
        int n3 = this.getLineNumber(this.getSelectionStart());
        if (n3 == (n2 = this.getLineNumber(this.getSelectionEnd()))) {
            this.commentLine(this.getCaretModel().getModelPosition().line);
        } else {
            for (int i2 = n3; i2 <= n2; ++i2) {
                this.commentLine(i2);
            }
        }
    }

    public void indentSelectedLines() {
        this.indentLinesBetween(this.getSelectionStartLine(), this.getSelectionEndLine());
    }

    public void indentLinesBetween(int n2, int n3) {
        for (int i2 = n2; i2 <= n3; ++i2) {
            this.indentLine(i2);
        }
    }

    public void indentLine(int n2) {
        String string = this.getLineText(n2).trim();
        if (n2 != 0) {
            String string2 = this.getLineText(n2 - 1);
            String string3 = TextUtils.getLeadingWhitespace(string2);
            if (!string.startsWith("}") && (string2.endsWith("{") || string2.endsWith(":"))) {
                string3 = string3 + '\t';
            } else if (string.indexOf(125) != -1 && string3.length() >= 1) {
                string3 = string3.substring(0, string3.length() - 1);
            } else if ((string2.endsWith("/**") || string2.endsWith("/*")) && string.startsWith("*")) {
                string3 = string3 + " ";
            } else if (string2.endsWith("*/")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            string = string3 + string;
        }
        this.selectLine(n2);
        this.setSelectedText(string);
    }

    public void selectLine(int n2) {
        int n3 = this.getLineStartOffset(n2);
        int n4 = this.getLineEndOffset(n2) + 1;
        if (n4 > this.getDocumentLength()) {
            n4 = this.getDocumentLength();
        }
        this.select(n3, n4);
        this.getCaretModel().setOffset(n3);
    }

    public void selectLines(int n2, int n3) {
        int n4 = this.getLineEndOffset(n3) + 1;
        this.select(this.getLineStartOffset(n2), n4);
        this.getCaretModel().setOffset(n4);
    }

    public final int getSelectionEnd() {
        return this.getSelectionModel().getSelectionEnd() > this.getSelectionModel().getSelectionStart() ? this.getSelectionModel().getSelectionEnd() : this.getSelectionModel().getSelectionStart();
    }

    public int getSelectionEnd(int n2) {
        if (this.getSelectionModel().isColumnSelectionMode()) {
            int n3 = this.getSelectionModel().getSelectionEndViewPosition() == null || this.getSelectionModel().getSelectionStartViewPosition() == null ? (this.getSelectionModel().getSelectionStart() < this.getSelectionEnd() ? this.getCaretModel().getViewPosition().column : this.offsetToViewPosition((int)this.getSelectionEnd()).column) : Math.max(this.getSelectionModel().getSelectionStartViewPosition().column, this.getSelectionModel().getSelectionEndViewPosition().column);
            int n4 = this.getLineStartOffset(n2);
            int n5 = this.getLineEndOffset(n2);
            return Math.min(n5, n4 + this.getCorrespondingColumn(n3, this.getSelectionEndLine(), n2));
        }
        if (n2 == this.getSelectionEndLine()) {
            return this.getSelectionEnd();
        }
        return this.getLineEndOffset(n2);
    }

    public final int getSelectionEndLine() {
        return this.getSelectionModel().getSelectionStartLine() <= this.getSelectionModel().getSelectionEndLine() ? this.getSelectionModel().getSelectionEndLine() : this.getSelectionModel().getSelectionStartLine();
    }

    public final void setSelectionEnd(int n2) {
        this.getSelectionModel().setSelection(this.getSelectionStart(), n2);
        this.select(this.getSelectionStart(), n2);
    }

    public int getLeadSelectionOffset() {
        int n2 = this.getCaretModel().getOffset();
        if (!this.getSelectionModel().hasSelection()) {
            return n2;
        }
        if (n2 == this.getSelectionModel().getSelectionEnd()) {
            return this.getSelectionModel().getSelectionStart();
        }
        return this.getSelectionModel().getSelectionEnd();
    }

    public int getAnchorSelectionOffset() {
        int n2 = this.getCaretModel().getOffset();
        if (!this.getSelectionModel().hasSelection()) {
            return n2;
        }
        if (n2 == this.getSelectionModel().getSelectionStart()) {
            return this.getSelectionModel().getSelectionEnd();
        }
        return this.getSelectionModel().getSelectionStart();
    }

    private CaretPosition \u0110() {
        CaretPosition caretPosition = this.getCaretModel().getViewPosition();
        SelectionModel selectionModel = this.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            return caretPosition;
        }
        if (JideSwingUtilities.equals(caretPosition, selectionModel.getSelectionStartViewPosition())) {
            return selectionModel.getSelectionEndViewPosition();
        }
        return selectionModel.getSelectionStartViewPosition();
    }

    public final int getMarkPosition() {
        return this.getAnchorSelectionOffset();
    }

    public final void select(int n2) {
        this.select(n2, n2);
    }

    public final void selectAll() {
        this.select(0, this.getDocumentLength(), false);
    }

    public final void selectNone() {
        this.select(this.getCaretModel().getOffset(), this.getCaretModel().getOffset());
    }

    public void select(int n2, int n3) {
        this.select(n2, n3, this.\u017d || this.getAutoscrolls());
    }

    public void select(int n2, int n3, boolean bl) {
        this.\u0102(n2, n3, bl, false);
    }

    void \u0102(int n2, int n3, boolean bl, boolean bl2) {
        this.getSelectionModel().setSelection(n2, n3);
        this.getCaretModel().setOffset(n3);
        if (bl) {
            this.\u0103(bl2);
        }
    }

    void \u0101(CaretPosition caretPosition, CaretPosition caretPosition2) {
        this.\u0101(caretPosition, caretPosition2, this.\u017d || this.getAutoscrolls());
    }

    void \u0101(CaretPosition caretPosition, CaretPosition caretPosition2, boolean bl) {
        if (caretPosition == null || caretPosition2 == null) {
            return;
        }
        this.getSelectionModel().setSelection(caretPosition, caretPosition2);
        this.getCaretModel().setViewPosition(caretPosition2);
        if (bl) {
            if (this.getSelectionStart() == this.getSelectionEnd()) {
                this.setMagicCaretPosition(-1);
            }
            boolean bl2 = false;
            if (this.\u016d.\u0102) {
                bl2 = true;
            } else {
                int n2 = this.columnToX(caretPosition2.line, caretPosition2.column);
                int n3 = n2 - this.getHorizontalOffset();
                if (n3 > this.getContentSize().width) {
                    bl2 = true;
                }
            }
            if (bl2) {
                this.\u016d.\u0103 = true;
                this.updateScrollBars();
            }
            this.scrollToViewPosition(caretPosition2, caretPosition);
        }
    }

    /*
     * WARNING - void declaration
     */
    String \u0113() {
        FoldingSpan[] foldingSpanArray;
        if (this.getSelectionModel().isColumnSelectionMode()) {
            return this.getSelectedText();
        }
        int n2 = this.getSelectionStart();
        int n3 = this.getSelectionEnd();
        FoldingModel foldingModel = this.getFoldingModel();
        if (foldingModel != null && (foldingSpanArray = foldingModel.getFoldingSpans()) != null) {
            Arrays.sort(foldingSpanArray, new Comparator<FoldingSpan>(){

                public int \u0101(FoldingSpan foldingSpan, FoldingSpan foldingSpan2) {
                    if (foldingSpan == null && foldingSpan2 == null) {
                        return 0;
                    }
                    if (foldingSpan == null) {
                        return -1;
                    }
                    if (foldingSpan2 == null) {
                        return 1;
                    }
                    if (foldingSpan.getStartOffset() < foldingSpan2.getStartOffset()) {
                        return -1;
                    }
                    if (foldingSpan.getStartOffset() > foldingSpan2.getStartOffset()) {
                        return 1;
                    }
                    if (foldingSpan.getEndOffset() < foldingSpan2.getEndOffset()) {
                        return -1;
                    }
                    if (foldingSpan.getEndOffset() > foldingSpan2.getEndOffset()) {
                        return 1;
                    }
                    return 0;
                }
            });
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            FoldingSpan[] object = foldingSpanArray;
            int n4 = object.length;
            for (int i2 = 0; i2 < n4; ++i2) {
                FoldingSpan foldingSpan = object[i2];
                if (foldingSpan.isValid() && !foldingSpan.isExpanded() && foldingSpan.getStartOffset() >= n2 && foldingSpan.getStartOffset() < n3) {
                    if (arrayList.size() > 0 && foldingSpan.getStartOffset() < (Integer)arrayList.get(arrayList.size() - 1)) continue;
                    arrayList.add(foldingSpan.getStartOffset());
                    arrayList.add(foldingSpan.getEndOffset());
                    continue;
                }
                if (foldingSpan.getStartOffset() >= n3) break;
            }
            if (arrayList.size() > 0) {
                void var6_8;
                arrayList.add(0, n2);
                arrayList.add(n3);
                String string = "";
                for (n4 = 0; n4 < arrayList.size(); n4 += 2) {
                    Integer n5 = (Integer)arrayList.get(n4);
                    Integer n6 = (Integer)arrayList.get(n4 + 1);
                    if (n5 >= n6) continue;
                    String string2 = (String)var6_8 + this.getText(n5, n6 - n5);
                }
                return var6_8;
            }
        }
        return this.getText(n2, n3 - n2);
    }

    public final String getSelectedText() {
        return this.getSelectionModel().getSelectedText();
    }

    public void setSelectedText(String string) {
        if (!this._editable) {
            throw new InternalError("Text component read only");
        }
        try {
            if (string != null) {
                int n2;
                if (this.getSelectionModel().hasSelection()) {
                    n2 = this.getSelectionStart();
                    int n3 = this.getSelectionEnd();
                    if (n3 >= this.getDocumentLength()) {
                        n3 = this.getDocumentLength();
                    }
                    this.getSelectionModel().clearSelection();
                    this._document.remove(n2, n3 - n2);
                    this._document.insertString(n2, string, null);
                } else {
                    CaretPosition caretPosition = this.getCaretModel().getModelPosition();
                    int n4 = this.getLineEndOffset(caretPosition.line);
                    CaretPosition caretPosition2 = this.offsetToModelPosition(n4);
                    if (caretPosition.column > caretPosition2.column) {
                        n2 = n4;
                        this._document.insertString(n2, TextUtils.createWhiteSpace(caretPosition.column - caretPosition2.column, this.getTabSize(), this.isReplaceTabWithSpace(), caretPosition2.column) + string, null);
                    } else {
                        n2 = this.getCaretModel().getOffset();
                        this._document.insertString(n2, string, null);
                    }
                }
                com.jidesoft.editor.E e2 = new com.jidesoft.editor.E(this, n2);
                do {
                    if (e2.\u0102() != null) {
                        this.getFoldingModel().expandFoldingSpan(e2.\u0102());
                    }
                    e2.\u0103();
                } while (e2.\u0101() < n2 + string.length() && e2.\u0104() < this.getDocumentLength());
            }
        }
        catch (BadLocationException badLocationException) {
            \u0184.warning(badLocationException.getLocalizedMessage());
            throw new InternalError("Cannot replace selection");
        }
    }

    public final boolean isEditable() {
        return this._editable;
    }

    public final void setEditable(boolean bl) {
        Action action;
        boolean bl2 = this._editable;
        if (bl2 != bl) {
            this._editable = bl;
            this.firePropertyChange(PROPERTY_EDITABLE, bl2, bl);
        }
        if ((action = this.\u0104("cut")) != null) {
            action.setEnabled(this.isEditable() && this.isEnabled());
        }
        if ((action = this.\u0104("paste")) != null) {
            action.setEnabled(this.isEditable() && this.isEnabled());
        }
        if ((action = this.\u0104("delete")) != null) {
            action.setEnabled(this.isEditable() && this.isEnabled());
        }
    }

    public final int getMagicCaretPosition() {
        return this._magicCaret;
    }

    public final void setMagicCaretPosition(int n2) {
        this._magicCaret = n2;
    }

    public void overwriteSetSelectedText(String string) {
        if (!this._overwrite || this.getSelectionStart() != this.getSelectionEnd()) {
            this.setSelectedText(string);
            return;
        }
        int n2 = this.getCaretModel().getOffset();
        int n3 = this.getLineEndOffset(this.getCaretModel().getModelPosition().line);
        if (n3 - n2 < string.length()) {
            this.setSelectedText(string);
            return;
        }
        try {
            this._document.remove(n2, string.length());
            this._document.insertString(n2, string, null);
        }
        catch (BadLocationException badLocationException) {
            \u0184.warning(badLocationException.getLocalizedMessage());
        }
    }

    public final boolean isOverwriteEnabled() {
        return this._overwrite;
    }

    public final void setOverwriteEnabled(boolean bl) {
        boolean bl2 = this._overwrite;
        if (bl2 != bl) {
            this._overwrite = bl;
            this._painter.invalidateSelectedLines();
            this.firePropertyChange(PROPERTY_OVERWRITE_ENABLED, bl2, bl);
        }
    }

    public final boolean isSelectionRectangular() {
        return this.getSelectionModel().isColumnSelectionMode();
    }

    public final void setSelectionRectangular(boolean bl) {
        this.getSelectionModel().setColumnSelectionMode(bl);
        this._painter.invalidateSelectedLines();
    }

    public final int getBracketPosition() {
        return this.bracketPosition;
    }

    public final int getBracketLine() {
        return this.bracketLine;
    }

    public void undo() {
        this._document.undo();
        this.\u011c();
    }

    public void redo() {
        this._document.redo();
        this.\u011c();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this._defaultSettings != null) {
            this._defaultSettings.addPropertyChangeListener(this);
        }
        if (this._localSettings != null) {
            this._localSettings.addPropertyChangeListener(this);
        }
        this.blinkCaret();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this._defaultSettings != null) {
            this._defaultSettings.removePropertyChangeListener(this);
        }
        if (this._localSettings != null) {
            this._localSettings.removePropertyChangeListener(this);
        }
        if (this.\u015e != null) {
            this.\u015e.stop();
            this.\u015e = null;
        }
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (this._searchable.isPopupVisible()) {
            super.processKeyEvent(keyEvent);
        } else {
            if (this.getInputHandler() != null) {
                switch (keyEvent.getID()) {
                    case 400: {
                        this.getInputHandler().keyTyped(keyEvent);
                        break;
                    }
                    case 401: {
                        this.getInputHandler().keyPressed(keyEvent);
                        break;
                    }
                    case 402: {
                        this.getInputHandler().keyReleased(keyEvent);
                    }
                }
            }
            if (!keyEvent.isConsumed()) {
                super.processKeyEvent(keyEvent);
            }
        }
    }

    protected void updateBracketHighlight(int n2) {
        try {
            int n3 = TextUtils.findMatchingBracket(this._document, n2 - 1);
            if (n3 != -1) {
                this.bracketLine = this.getLineNumber(n3);
                this.bracketPosition = n3 - this.getLineStartOffset(this.bracketLine);
                return;
            }
        }
        catch (BadLocationException badLocationException) {
            \u0184.warning(badLocationException.getLocalizedMessage());
        }
        this.bracketPosition = -1;
        this.bracketLine = -1;
    }

    protected void documentChanged(DocumentEvent documentEvent) {
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(this._document.getDefaultRootElement());
        this.\u016d.\u0101(documentEvent);
        int n2 = elementChange == null ? 0 : (elementChange instanceof LazyLoadDocument.C ? ((LazyLoadDocument.C)elementChange).\u0101() : elementChange.getChildrenAdded().length - elementChange.getChildrenRemoved().length);
        int n3 = this.offsetToViewPosition((int)documentEvent.getOffset()).line;
        if (n2 == 0) {
            this._painter.invalidateLine(n3);
        } else if (n3 < this._firstLine) {
            this.setFirstLine(this._firstLine + n2);
        } else {
            this._painter.invalidateLineRange(n3, this.getFirstLine() + this.getVisibleLines());
        }
        this.updateScrollBars();
        if (this.isAutoInspecting()) {
            this.inspectCode(documentEvent);
        }
        if (this.getMarginArea() != null) {
            this.getMarginArea().invalidate();
            this.getMarginArea().repaint();
        }
    }

    public boolean isBlink() {
        return this.\u016b;
    }

    public void setBlink(boolean bl) {
        this.\u016b = bl;
    }

    public void pauseBlink() {
        this.setBlink(true);
        if (this.\u015e != null) {
            this.\u015e.stop();
        }
    }

    public boolean isTabAlignment() {
        return this.\u0180;
    }

    public void setTabAlignment(boolean bl) {
        this.\u0180 = bl;
    }

    public int getHorizontalScrollBarPolicy() {
        return this.\u0177;
    }

    public void setHorizontalScrollBarPolicy(int n2) {
        this.\u0177 = n2;
    }

    public int getVerticalScrollBarPolicy() {
        return this.\u0183;
    }

    public void setVerticalScrollBarPolicy(int n2) {
        this.\u0183 = n2;
    }

    public boolean isShowToolTipOverMarkedText() {
        return this.\u0174;
    }

    public void setShowToolTipOverMarkedText(boolean bl) {
        this.\u0174 = bl;
    }

    public String getFileName() {
        return this.\u0188;
    }

    public void setFileName(String string) {
        this.setFileName(string, "UTF-8");
    }

    public void setFileName(String string, String string2) {
        this.\u0188 = string;
        this.getFoldingModel().removeAllFoldingSpans();
        if (this.\u0188 != null) {
            TokenMarker tokenMarker;
            int n2 = this.getLineCount();
            TokenMarker tokenMarker2 = tokenMarker = this._document == null ? null : this._document.getTokenMarker();
            if (!(this._document instanceof LazyLoadDocument)) {
                LazyLoadDocument lazyLoadDocument = this.createLazyLoadDocument();
                this.setDocument(lazyLoadDocument);
            }
            if (this._document instanceof LazyLoadDocument) {
                ((LazyLoadDocument)this._document).setFileName(this.\u0188, string2);
            }
            if (tokenMarker != null) {
                if (this._document.getTokenMarker() != tokenMarker) {
                    this._document.setTokenMarker(tokenMarker);
                } else {
                    tokenMarker.deleteLines(0, n2);
                    tokenMarker.insertLines(0, this.getLineCount());
                    this._document.tokenizeLines();
                }
            }
            this.setTokenMarker(tokenMarker == null ? this._document.getTokenMarker() : tokenMarker);
        } else {
            this.setRawText("");
        }
        this.select(0);
        this.discardAllEdits();
        this.getMarginArea().invalidate();
        this.getCaretModel().setOffset(0);
        this.resetContentSize();
        this.doLayout();
        this.getMarginArea().doLayout();
        this.updateScrollBars();
    }

    protected LazyLoadDocument createLazyLoadDocument() {
        return new LazyLoadDocument();
    }

    public boolean exportToOutputStream(OutputStream outputStream) throws IOException, BadLocationException {
        OutputStreamWriter outputStreamWriter = this.createOutputStreamWriter(outputStream);
        if (this.getDocument() instanceof LazyLoadDocument) {
            return ((LazyLoadDocument)this.getDocument()).\u0101(outputStreamWriter);
        }
        outputStreamWriter.write(this.getText());
        outputStreamWriter.flush();
        return true;
    }

    protected OutputStreamWriter createOutputStreamWriter(OutputStream outputStream) {
        return new OutputStreamWriter(outputStream);
    }

    public boolean isContentVisible() {
        return this.\u0159;
    }

    public void setContentVisible(boolean bl) {
        this.\u0159 = bl;
    }

    public boolean isDelayContentsOnLoading() {
        return this.\u0164;
    }

    public void setDelayContentsOnLoading(boolean bl) {
        this.\u0164 = bl;
    }

    public boolean isChangePromptDialogPosition() {
        return this.\u0178;
    }

    public void setChangePromptDialogPosition(boolean bl) {
        this.\u0178 = bl;
    }

    public boolean isIndentOnPasting() {
        return this.\u016e;
    }

    public void setIndentOnPasting(boolean bl) {
        this.\u016e = bl;
    }

    public boolean isCopyVisibleTextOnly() {
        return this.\u016c;
    }

    public void setCopyVisibleTextOnly(boolean bl) {
        this.\u016c = bl;
    }

    public boolean isSkipsEmptyLinesOnLineComments() {
        return this.\u0187;
    }

    public void setSkipsEmptyLinesOnLineComments(boolean bl) {
        this.\u0187 = bl;
    }

    private Timer \u0118() {
        return new Timer(200, new AbstractAction(){
            private static final long \u0102 = -5539461235451859382L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CodeEditor.this.setContentVisible(true);
                CodeEditor.this.repaint();
            }
        });
    }

    protected void pageLoadFailedHandling(PageLoadEvent pageLoadEvent) {
    }

    @Override
    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean getFocusCycleRoot() {
        return true;
    }

    private void \u0101(int n2, int n3, int n4) {
        int n5 = this.getMarkPosition();
        if (this.\u017b >= 0) {
            int n6 = this.getLineStartOffset(this.viewToModelLine(this.\u017b));
            int n7 = this.getLineStartOffset(this.viewToModelLine(this.\u017b + 1));
            if (n2 <= n6) {
                n5 = n7;
                n2 = this.getLineStartOffset(this.viewToModelLine(this.offsetToViewPosition((int)n2).line));
            } else if (n2 >= n7) {
                n5 = n6;
                int n8 = this.offsetToViewPosition((int)n2).line;
                n2 = n8 < this.getVisualLineCount() - 1 ? this.getLineStartOffset(this.viewToModelLine(n8 + 1)) : this.getDocumentLength();
            } else {
                n2 = n5 == n6 ? n7 : n6;
            }
        }
        if (this.getSelectionModel().isColumnSelectionMode()) {
            this.\u0101(this.\u0110(), new CaretPosition(n3, n4));
        } else {
            this.select(n5, n2);
        }
    }

    protected boolean isColumnSelectionMode(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 8) != 0;
    }

    public void scrollUpPage() {
        this.setFirstLine(this.getFirstLine() - this.getVisibleLines() + (this.\u0167 ? 1 : 0));
    }

    public void scrollDownPage() {
        this.setFirstLine(this.getFirstLine() + this.getVisibleLines() - (this.\u0167 ? 1 : 0));
    }

    public MarginArea getMarginArea() {
        return this._marginArea;
    }

    public void setMarginArea(MarginArea marginArea) {
        this._marginArea = marginArea;
    }

    public void setLineNumberVisible(boolean bl) {
        this._lineNumberMargin.setVisible(bl);
    }

    public boolean isLineNumberVisible() {
        return this._lineNumberMargin.isVisible();
    }

    public RowNumberMargin getLineNumberMargin() {
        return this._lineNumberMargin;
    }

    public CaretModel getCaretModel() {
        if (this._caretModel == null) {
            this._caretModel = this.\u011b();
            this._caretModel.addCaretListener(this);
        }
        return this._caretModel;
    }

    private DefaultCaretModel \u011b() {
        return new DefaultCaretModel(this);
    }

    public SelectionModel getSelectionModel() {
        if (this._selectionModel == null) {
            this._selectionModel = this.createSelectionModel();
            this._selectionModel.addSelectionListener(this);
        }
        return this._selectionModel;
    }

    @Override
    public void selectionChanged(SelectionEvent selectionEvent) {
        if (selectionEvent.getOldSelectionStart() != selectionEvent.getNewSelectionStart() || selectionEvent.getOldSelectionEnd() != selectionEvent.getNewSelectionEnd()) {
            if (selectionEvent.getNewSelectionEnd() == selectionEvent.getNewSelectionStart() && selectionEvent.getOldSelectionEnd() == selectionEvent.getOldSelectionStart()) {
                return;
            }
            this._painter.invalidateRange(selectionEvent.getOldSelectionStart(), selectionEvent.getOldSelectionEnd());
            this._painter.invalidateRange(selectionEvent.getNewSelectionStart(), selectionEvent.getNewSelectionEnd());
            try {
                Clipboard clipboard = this.getToolkit().getSystemSelection();
                if (clipboard != null) {
                    String string = this.getSelectedText();
                    if (string == null) {
                        string = "";
                    }
                    if (!"".equals(string)) {
                        this.\u0166 = true;
                        clipboard.setContents(new StringSelection(string), this.\u0116());
                    } else if (this.\u0166) {
                        clipboard.setContents(new StringSelection(string), this.\u0116());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private ClipboardOwner \u0116() {
        if (this.\u015c == null) {
            this.\u015c = this.createClipboardOwner();
        }
        return this.\u015c;
    }

    protected ClipboardOwner createClipboardOwner() {
        return new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard clipboard, Transferable transferable) {
                CodeEditor.this.\u0166 = false;
            }
        };
    }

    @Override
    public void caretUpdated(CaretEvent caretEvent) {
        if (caretEvent.getType() == 1) {
            int n2 = caretEvent.getOldPosition().line;
            this._painter.invalidateLineRange(n2, n2);
            int n3 = caretEvent.getNewPosition().line;
            this._painter.invalidateLineRange(n3, n3);
        } else {
            int n4 = this.modelToViewPosition((CaretPosition)caretEvent.getOldPosition()).line;
            this._painter.invalidateLineRange(n4, n4);
            int n5 = this.modelToViewPosition((CaretPosition)caretEvent.getNewPosition()).line;
            this._painter.invalidateLineRange(n5, n5);
        }
        if (this.isBracketHighlightVisible()) {
            if (this.bracketLine != -1) {
                this._painter.invalidateLine(this.modelToViewPosition((CaretPosition)new CaretPosition((int)this.bracketLine, (int)this.bracketPosition)).line);
            }
            this.updateBracketHighlight(this.modelPositionToOffset(caretEvent.getNewPosition()));
            if (this.bracketLine != -1) {
                this._painter.invalidateLine(this.modelToViewPosition((CaretPosition)new CaretPosition((int)this.bracketLine, (int)this.bracketPosition)).line);
            }
            this._marginArea.repaint();
        }
        ((DefaultFoldingModel)this.getFoldingModel()).resetCaretPosition();
        if (!this.isVirtualSpaceAllowed() && caretEvent.getOldPosition().line == caretEvent.getNewPosition().line && caretEvent.getType() == 1) {
            this.setMagicCaretPosition(this.columnToX(caretEvent.getNewPosition().line, caretEvent.getNewPosition().column));
        }
    }

    protected SelectionModel createSelectionModel() {
        return new DefaultSelectionModel(this);
    }

    public CaretPosition viewToModelPosition(CaretPosition caretPosition) {
        FoldingSpan foldingSpan;
        if (caretPosition.line == 0 && caretPosition.column == 0) {
            return new CaretPosition(0, 0);
        }
        DefaultFoldingModel defaultFoldingModel = (DefaultFoldingModel)this.getFoldingModel();
        int n2 = caretPosition.line;
        int n3 = caretPosition.column;
        if (defaultFoldingModel.isEnabled() && (foldingSpan = defaultFoldingModel.getOutermostSpanAtViewPosition(caretPosition)) != null) {
            CaretPosition caretPosition2 = this.offsetToModelPosition(foldingSpan.getStartOffset());
            CaretPosition caretPosition3 = this.modelToViewPosition(caretPosition2);
            if (caretPosition.line == caretPosition3.line && caretPosition.column >= caretPosition3.column && caretPosition.column < caretPosition3.column + com.jidesoft.editor.A.\u0101(foldingSpan)) {
                return caretPosition2;
            }
            CaretPosition caretPosition4 = this.offsetToModelPosition(foldingSpan.getEndOffset());
            n2 = caretPosition4.line + (caretPosition.line - caretPosition3.line);
            if (caretPosition3.line == caretPosition.line) {
                if (caretPosition.column >= caretPosition3.column + com.jidesoft.editor.A.\u0101(foldingSpan)) {
                    n3 = Math.min(caretPosition4.column, this.getLineEndOffsetExcludeLineBreak(caretPosition4.line)) + (caretPosition.column - caretPosition3.column - com.jidesoft.editor.A.\u0101(foldingSpan));
                } else {
                    return this.offsetToModelPosition(foldingSpan.getStartOffset());
                }
            }
        }
        if (n3 < 0) {
            n3 = 0;
        }
        return new CaretPosition(n2, n3);
    }

    public CaretPosition modelToViewPosition(CaretPosition caretPosition) {
        DefaultFoldingModel defaultFoldingModel = (DefaultFoldingModel)this.getFoldingModel();
        if (!defaultFoldingModel.isEnabled()) {
            return new CaretPosition(caretPosition.line, caretPosition.column);
        }
        if (caretPosition.line == 0 && caretPosition.column == 0) {
            return new CaretPosition(0, 0);
        }
        int n2 = this.modelPositionToOffset(caretPosition);
        FoldingSpan foldingSpan = defaultFoldingModel.getOutermostSpanAtOffset(n2);
        if (foldingSpan != null && n2 > foldingSpan.getStartOffset()) {
            if (n2 < this.getDocument().getLength() - 1) {
                int n3 = foldingSpan.getStartOffset();
                CaretPosition caretPosition2 = this.offsetToModelPosition(n3);
                CaretPosition caretPosition3 = this.modelToViewPosition(caretPosition2);
                if (n2 == foldingSpan.getEndOffset() - 1 && caretPosition.column >= this.getLineEndOffsetExcludeLineBreak(caretPosition.line)) {
                    return new CaretPosition(caretPosition3.line, caretPosition3.column + com.jidesoft.editor.A.\u0101(foldingSpan) + (caretPosition.column - this.getLineEndOffsetExcludeLineBreak(caretPosition.line)));
                }
                return caretPosition3;
            }
            n2 = foldingSpan.getEndOffset() + 3;
        }
        int n4 = caretPosition.line;
        int n5 = caretPosition.column;
        n4 -= defaultFoldingModel.getFoldedLinesCountBefore(n2);
        FoldingSpan[] foldingSpanArray = defaultFoldingModel.getTopLevelSpans();
        for (int i2 = defaultFoldingModel.getLastTopLevelIndexBefore(n2); i2 >= 0; --i2) {
            FoldingSpan foldingSpan2 = foldingSpanArray[i2];
            if (!foldingSpan2.isValid()) continue;
            if (this.getLineNumber(foldingSpan2.getEndOffset()) != caretPosition.line) break;
            int n6 = 0;
            if (foldingSpan2.getEndOffset() >= n2) {
                if (n2 != this.getLineEndOffsetExcludeLineBreak(caretPosition.line) + this.getLineStartOffset(caretPosition.line) && foldingSpan2.getEndOffset() != n2) break;
                n6 = foldingSpan2.getEndOffset() - n2;
            }
            CaretPosition caretPosition4 = this.offsetToModelPosition(foldingSpan2.getStartOffset());
            CaretPosition caretPosition5 = this.offsetToModelPosition(foldingSpan2.getEndOffset());
            n5 += caretPosition4.column + com.jidesoft.editor.A.\u0101(foldingSpan2) - caretPosition5.column + n6;
            n2 = foldingSpan2.getStartOffset();
            caretPosition = caretPosition4;
        }
        return new CaretPosition(n4, n5);
    }

    public CaretPosition offsetToModelPosition(int n2) {
        if (n2 <= 0) {
            return new CaretPosition(0, 0);
        }
        int n3 = this._document.getLength();
        if (n2 > n3) {
            return new CaretPosition(this._document.getLineCount(), 0);
        }
        int n4 = this.getLineNumber(n2);
        int n5 = this.getLineStartOffset(n4);
        return new CaretPosition(n4, Math.max(n2 - n5, 0));
    }

    public CaretPosition offsetToViewPosition(int n2) {
        return this.modelToViewPosition(this.offsetToModelPosition(n2));
    }

    public int modelPositionToOffset(CaretPosition caretPosition) {
        if (this.getLineCount() == 0) {
            return 0;
        }
        if (caretPosition.line < 0) {
            throw new IndexOutOfBoundsException("Wrong line: " + caretPosition.line);
        }
        if (caretPosition.column < 0) {
            throw new IndexOutOfBoundsException("Wrong column:" + caretPosition.column);
        }
        if (caretPosition.line == 0 && caretPosition.column == 0) {
            return 0;
        }
        if (caretPosition.line >= this.getLineCount()) {
            return this._document.getLength();
        }
        int n2 = this.getLineStartOffset(caretPosition.line);
        int n3 = this.getLineEndOffsetExcludeLineBreak(caretPosition.line);
        int n4 = n2;
        if (caretPosition.column > 0 && n3 > 0) {
            n4 += Math.min(caretPosition.column, n3);
        }
        return n4;
    }

    @Deprecated
    public int offsetToLine(int n2) {
        return this.offsetToViewPosition((int)n2).line;
    }

    public int getTabSize() {
        return this.\u017f;
    }

    public void setTabSize(int n2) {
        int n3 = this.\u017f;
        if (n3 != n2) {
            this.\u017f = n2;
            this.firePropertyChange(PROPERTY_TAB_SIZE, n3, n2);
        }
    }

    public boolean isReplaceTabWithSpace() {
        return this.\u0171;
    }

    public void setReplaceTabWithSpace(boolean bl) {
        boolean bl2 = this.\u0171;
        if (bl2 != bl) {
            this.\u0171 = bl;
            this.firePropertyChange(PROPERTY_REPLACE_TAB_WITH_SPACE, bl2, bl);
        }
    }

    static int \u011f() {
        if (SystemInfo.isWindows()) {
            return 0;
        }
        if (SystemInfo.isMacClassic()) {
            return 2;
        }
        if (SystemInfo.isUnix() || SystemInfo.isMacOSX()) {
            return 1;
        }
        return 0;
    }

    public int getDefaultLineBreakStyle() {
        return CodeEditor.\u011f();
    }

    public int getLineBreakStyle() {
        return this.\u0168 == -1 ? this.getDefaultLineBreakStyle() : this.\u0168;
    }

    public boolean isLineBreakStyleMixed() {
        return this.\u0168 == -1;
    }

    public void setLineBreakStyle(int n2) {
        int n3;
        if (n2 == -2) {
            n2 = this.getDefaultLineBreakStyle();
        }
        if ((n3 = this.\u0168) != n2) {
            this.\u0168 = n2;
            this.firePropertyChange(PROPERTY_LINE_BREAK_STYLE, n3, n2);
        }
    }

    private String \u0119() {
        return this.getLineBreakStyle() == 2 ? "\n" : TextUtils.getLineBreak(this.getLineBreakStyle());
    }

    public void discardAllEdits() {
        this.getDocument().getUndoManager().discardAllEdits();
    }

    public void promptGotoLine() {
        Point point;
        final InputPopup inputPopup = new InputPopup(this.getResourceString("CodeEditor.gotoLine"), MessageFormat.format(this.getResourceString("CodeEditor.gotoLine.message"), 1, this.getLineCount()), this.getCaretModel().getModelPosition().line + 1);
        inputPopup.setOwner(this);
        inputPopup.removeExcludedComponent(this);
        try {
            point = this.getLocationOnScreen();
        }
        catch (Exception exception) {
            point = this.getLocation();
        }
        Dimension dimension = inputPopup.getPreferredSize();
        point.x += (this.getWidth() - dimension.width) / 2;
        point.y += (this.getHeight() - dimension.height) / 2;
        inputPopup.getTextField().addActionListener(new AbstractAction(){
            private static final long \u0103 = 7299209753351159934L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTextField jTextField = (JTextField)actionEvent.getSource();
                String string = jTextField.getText();
                if (string != null && string.trim().length() > 0) {
                    try {
                        int n2 = Integer.parseInt("" + string);
                        CodeEditor.this.gotoLine(n2 - 1);
                        inputPopup.hidePopup();
                    }
                    catch (NumberFormatException numberFormatException) {
                        inputPopup.getStatusLabel().setForeground(Color.RED);
                        inputPopup.getStatusLabel().setText(CodeEditor.this.getResourceString("CodeEditor.gotoLine.invalid"));
                    }
                } else {
                    inputPopup.getStatusLabel().setForeground(Color.RED);
                    inputPopup.getStatusLabel().setText(CodeEditor.this.getResourceString("CodeEditor.gotoLine.empty"));
                }
            }
        });
        inputPopup.setTimeout(0);
        inputPopup.showPopup(point.x, point.y, this);
    }

    public void promptGotoLineAtView() {
        Object object = JOptionPane.showInputDialog(this, "Line number: ", "Go to Line at View", 3, null, null, this.getCaretModel().getViewPosition().line + 1);
        if (object != null) {
            try {
                int n2 = Integer.parseInt("" + object);
                this.gotoLineAtView(n2 - 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void promptGotoOffset() {
        Object object = JOptionPane.showInputDialog(this, "Offset: ", "Go to Offset", 3, null, null, this.getCaretModel().getOffset());
        if (object != null) {
            try {
                int n2 = Integer.parseInt("" + object);
                this.gotoOffset(n2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void gotoLine(int n2) {
        if (n2 < 0) {
            PortingUtils.notifyUser();
            n2 = 0;
        }
        if (n2 > this.getLineCount() - 1) {
            PortingUtils.notifyUser();
            n2 = this.getLineCount() - 1;
        }
        CaretPosition caretPosition = this.getCaretModel().getModelPosition();
        int n3 = caretPosition.column;
        if (!this.isVirtualSpaceAllowed()) {
            n3 = Math.min(n3, this.getLineEndOffset(n2) - this.getLineStartOffset(n2));
        }
        this.getCaretModel().setModelPosition(new CaretPosition(n2, n3));
        CaretPosition caretPosition2 = this.getCaretModel().getViewPosition();
        if (caretPosition2.line < this.getFirstLine() || caretPosition2.line >= this.getFirstLine() + this.getVisibleLines() - 1) {
            if (caretPosition2.line - 10 >= 0 && caretPosition2.line - 10 + this.getVisibleLines() < this.getVisualLineCount()) {
                this.setFirstLine(caretPosition2.line - 10);
            } else if (caretPosition2.line + 10 < this.getVisualLineCount() && caretPosition2.line + 10 - this.getVisibleLines() >= 0) {
                this.setFirstLine(caretPosition2.line + 10 - this.getVisibleLines());
            } else {
                this.scrollToViewPosition(caretPosition2);
            }
        }
    }

    public void gotoLineAtView(int n2) {
        if (n2 < 0) {
            PortingUtils.notifyUser();
            n2 = 0;
        }
        if (n2 > this.getVisualLineCount() - 1) {
            PortingUtils.notifyUser();
            n2 = this.getVisualLineCount() - 1;
        }
        CaretPosition caretPosition = this.getCaretModel().getViewPosition();
        int n3 = caretPosition.column;
        if (!this.isVirtualSpaceAllowed()) {
            n3 = Math.min(n3, this.getLineEndOffset(n2) - this.getLineStartOffset(n2));
        }
        CaretPosition caretPosition2 = new CaretPosition(n2, n3);
        this.getCaretModel().setViewPosition(caretPosition2);
        if (caretPosition2.line < this.getFirstLine() || caretPosition2.line >= this.getFirstLine() + this.getVisibleLines() - 1) {
            if (caretPosition2.line - 10 >= 0 && caretPosition2.line - 10 + this.getVisibleLines() < this.getVisualLineCount()) {
                this.setFirstLine(caretPosition2.line - 10);
            } else if (caretPosition2.line + 10 < this.getVisualLineCount() && caretPosition2.line + 10 - this.getVisibleLines() >= 0) {
                this.setFirstLine(caretPosition2.line + 10 - this.getVisibleLines());
            } else {
                this.scrollToViewPosition(caretPosition2);
            }
        }
    }

    public void gotoOffset(int n2) {
        if (n2 < 0) {
            PortingUtils.notifyUser();
            n2 = 0;
        }
        if (n2 > this.getDocumentLength() - 1) {
            PortingUtils.notifyUser();
            n2 = this.getDocumentLength() - 1;
        }
        this.getCaretModel().setOffset(n2);
        this.scrollToCaret();
    }

    public MarkerModel getMarkerModel() {
        if (this.\u016f == null) {
            this.setMarkerModel(new DefaultMarkerModel());
        }
        return this.\u016f;
    }

    public void setMarkerModel(MarkerModel markerModel) {
        if (this.\u016f != null && this.\u017a != null) {
            this.\u016f.removeMarkerListener(this.\u017a);
        }
        this.\u016f = markerModel;
        if (this.\u016f != null) {
            if (this.\u017a == null) {
                this.\u017a = new MarkerListener(){

                    @Override
                    public void markerChanged(MarkerEvent markerEvent) {
                        Marker marker = markerEvent.getMarker();
                        if (marker != null && markerEvent.getType() == 0 && CodeEditor.this.getMarkerArea() != null) {
                            if (marker.getType() == 0) {
                                CodeEditor.this.getMarkerArea().requireMinimumMode(200);
                            } else if (marker.getType() == 1) {
                                CodeEditor.this.getMarkerArea().requireMinimumMode(100);
                            }
                        }
                        if (!markerEvent.isAdjusting()) {
                            if (CodeEditor.this.getMarkerArea() != null) {
                                CodeEditor.this.getMarkerArea().repaint();
                            }
                            CodeEditor.this._painter.repaint();
                        }
                    }
                };
            }
            this.\u016f.addMarkerListener(this.\u017a);
        }
    }

    public int getMaxNumberOfClipboards() {
        return this.\u0170;
    }

    public void setMaxNumberOfClipboards(int n2) {
        int n3 = this.\u0170;
        if (n3 != n2) {
            this.\u0170 = n2;
            this.firePropertyChange(PROPERTY_MAX_NUMBER_OF_CLIPBOARDS, n3, n2);
        }
    }

    public void setDragEnabled(boolean bl) {
        if (bl && GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.\u0161 = bl;
    }

    public boolean getDragEnabled() {
        return this.\u0161;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this._painter.setFont(font);
        this.recalculateVisibleLines();
        this.resetContentSize();
        this.getMarginArea().setFont(font);
    }

    public Searchable getSearchable() {
        return this._searchable;
    }

    public FindAndReplace getFindAndReplace() {
        block4: {
            Object object;
            block5: {
                boolean bl = false;
                if (this.\u0169 == null) {
                    this.\u0169 = new FindAndReplace();
                    object = new CodeEditorFindAndReplaceTarget(this);
                    this.\u0169.addTarget((FindAndReplaceTarget)object);
                    this.\u0169.setTarget((FindAndReplaceTarget)object);
                    bl = true;
                    final CodeEditorSelectionFindAndReplaceTarget object2 = new CodeEditorSelectionFindAndReplaceTarget(this);
                    this.\u0169.addTarget(object2);
                    this.\u0169.addFindAndReplaceListener(new FindAndReplaceListener(){
                        private boolean \u0104;
                        private int \u0105;
                        private int \u0103;

                        @Override
                        public void statusChanged(FindAndReplaceEvent findAndReplaceEvent) {
                            FindResult findResult;
                            int n2 = 0;
                            if (findAndReplaceEvent.getSource() instanceof FindAndReplace && ((FindAndReplace)findAndReplaceEvent.getSource()).getTarget() instanceof CodeEditorSelectionFindAndReplaceTarget && CodeEditor.this.getSelectionModel().hasSelection()) {
                                n2 = CodeEditor.this.getSelectionStart();
                            }
                            if (findAndReplaceEvent.getStatus() == 0) {
                                if (findAndReplaceEvent.getSource() instanceof FindAndReplace && ((FindAndReplace)findAndReplaceEvent.getSource()).isTargetChanged() && ((FindAndReplace)findAndReplaceEvent.getSource()).getTarget() instanceof CodeEditorFindAndReplaceTarget && object2.hasHighlight()) {
                                    CodeEditor.this.select(CodeEditor.this.getSelectionStart() + object2.getCurrentPosition(false) + 1);
                                }
                                CodeEditor.this.\u0112();
                            }
                            if (findAndReplaceEvent.getStatus() == 1) {
                                this.\u0104 = true;
                                if (CodeEditor.this.getSelectionModel().hasSelection() && this.\u0105 != this.\u0103 && this.\u0105 >= 0 && this.\u0103 >= 0 && CodeEditor.this.getSelectionStart() == this.\u0105 && CodeEditor.this.getSelectionEnd() == this.\u0103) {
                                    CodeEditor.this.getSelectionModel().clearSelection();
                                }
                                this.\u0105 = -1;
                                this.\u0103 = -1;
                            } else if (findAndReplaceEvent.getStatus() == 2) {
                                FindResult findResult2;
                                this.\u0104 = false;
                                FindResults findResults = findAndReplaceEvent.getFindResults();
                                if (findResults != null && (findResult2 = findResults.getFirstFindResult(CodeEditor.this)) != null) {
                                    CodeEditor.this.select(findResult2.getStart(), findResult2.getEnd());
                                }
                            } else if (!this.\u0104 && findAndReplaceEvent.getStatus() == 4) {
                                FindResult findResult3 = findAndReplaceEvent.getFindResult();
                                if (findResult3 != null) {
                                    this.\u0105 = findResult3.getStart() + n2;
                                    this.\u0103 = findResult3.getEnd() + n2;
                                }
                            } else if (findAndReplaceEvent.getStatus() == 4 && this.\u0104 && (findResult = findAndReplaceEvent.getFindResult()) != null) {
                                try {
                                    Object object = CodeEditor.this.getClientProperty("Searchable");
                                    Color color = CodeEditorSelectionFindAndReplaceTarget.\u0136;
                                    if (object instanceof CodeEditorSearchable) {
                                        color = ((CodeEditorSearchable)object).getHighlightColor();
                                    }
                                    CodeEditor.this.getHighlighter().addHighlight(findResult.getStart() + n2, findResult.getEnd() + n2, new C(color));
                                }
                                catch (BadLocationException badLocationException) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                }
                object = this.\u0169.getTargets();
                if (!this.getSelectionModel().hasSelection()) break block5;
                if (this.getSelectionStartLine() == this.getSelectionEndLine() || !bl) break block4;
                for (FindAndReplaceTarget findAndReplaceTarget : object) {
                    if (!(findAndReplaceTarget instanceof CodeEditorSelectionFindAndReplaceTarget)) continue;
                    this.\u0169.setTarget(findAndReplaceTarget);
                    break block4;
                }
                break block4;
            }
            if (this.\u0169.getTarget() instanceof CodeEditorSelectionFindAndReplaceTarget) {
                for (FindAndReplaceTarget findAndReplaceTarget : object) {
                    if (findAndReplaceTarget == this.\u0169.getTarget() || findAndReplaceTarget instanceof CodeEditorSelectionFindAndReplaceTarget || !(findAndReplaceTarget instanceof CodeEditorFindAndReplaceTarget)) continue;
                    this.\u0169.setTarget(findAndReplaceTarget);
                    break;
                }
            }
        }
        return this.\u0169;
    }

    void \u0112() {
        Highlighter highlighter = this.getHighlighter();
        if (highlighter instanceof DefaultHighlighter) {
            Highlighter.Highlight[] highlightArray = highlighter.getHighlights();
            for (int i2 = highlightArray.length - 1; i2 >= 0; --i2) {
                Highlighter.Highlight highlight = highlightArray[i2];
                if (!(highlight.getPainter() instanceof C)) continue;
                highlighter.removeHighlight(((DefaultHighlighter)highlighter).getHighlightInfo(i2));
            }
        }
    }

    public Point getCaretLocation() {
        CaretPosition caretPosition = this.getCaretModel().getViewPosition();
        int n2 = (caretPosition.line - this.getFirstLine()) * this.getLineHeight();
        int n3 = this.columnToX(caretPosition.line, caretPosition.column);
        return new Point(n3, n2);
    }

    public Point getCaretLocationOnScreen() {
        Point point = this.getCaretLocation();
        SwingUtilities.convertPointToScreen(point, this.getPainter());
        return point;
    }

    public void showMessage(String string) {
        this.\u010f();
        this.\u0165 = JidePopupFactory.getSharedInstance().createPopup();
        this.getCaretModel().addCaretListener(new CaretListener(){

            @Override
            public void caretUpdated(CaretEvent caretEvent) {
                CodeEditor.this.\u010f();
            }
        });
        JLabel jLabel = new JLabel(string);
        jLabel.setOpaque(true);
        jLabel.setFont(UIDefaultsLookup.getFont("Label.font").deriveFont(1, 11.0f));
        jLabel.setBackground(UIDefaultsLookup.getColor("ToolTip.background"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 6));
        jLabel.setForeground(UIDefaultsLookup.getColor("ToolTip.foreground"));
        this.\u0165.getContentPane().setLayout(new BorderLayout());
        this.\u0165.getContentPane().add(jLabel);
        this.\u0165.setOwner(this);
        this.\u0165.setPopupBorder(new F());
        Point point = this.getCaretLocation();
        SwingUtilities.convertPointToScreen(point, this.getPainter());
        Point point2 = new Point(this.getWidth(), this.getHeight());
        SwingUtilities.convertPointToScreen(point2, this);
        if (point.x + this.\u0165.getPreferredSize().width > point2.x) {
            point.x = point2.x - this.\u0165.getPreferredSize().width;
        }
        if (point.y + this.\u0165.getPreferredSize().height > point2.y) {
            point.y = point2.y - this.\u0165.getPreferredSize().height;
        }
        this.\u0165.setDefaultMoveOperation(0);
        this.\u0165.setTransient(true);
        this.\u0165.showPopup(point.x, point.y + this.getLineHeight());
    }

    private void \u010f() {
        if (this.\u0165 != null) {
            this.\u0165.hidePopupImmediately();
            this.\u0165 = null;
        }
    }

    public void find() {
        Window window;
        this.\u010f();
        this.getFindAndReplace().setReplace(false);
        if (this.getSelectionModel().hasSelection() && this.getSelectionModel().getSelectionStartLine() == this.getSelectionModel().getSelectionEndLine()) {
            this.getFindAndReplace().setFindText(this.getSelectedText());
        }
        FindAndReplaceDialog findAndReplaceDialog = (window = JideSwingUtilities.getWindowForComponent(this)) instanceof Frame ? new FindAndReplaceDialog((Frame)window, this.getResourceString("FindAndReplace.findTitle"), this.getFindAndReplace()) : new FindAndReplaceDialog((Dialog)window, this.getResourceString("FindAndReplace.findTitle"), this.getFindAndReplace());
        this.customizeDialogData(findAndReplaceDialog);
        findAndReplaceDialog.pack();
        findAndReplaceDialog.setLocationRelativeTo(this);
        if (this.\u0186 != null) {
            findAndReplaceDialog.setBounds(this.\u0186);
        }
        findAndReplaceDialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (componentEvent.getSource() instanceof FindAndReplaceDialog) {
                    CodeEditor.this.\u0186 = ((FindAndReplaceDialog)componentEvent.getSource()).getBounds();
                }
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                if (componentEvent.getSource() instanceof FindAndReplaceDialog) {
                    CodeEditor.this.\u0186 = ((FindAndReplaceDialog)componentEvent.getSource()).getBounds();
                }
            }
        });
        this.customizeDialog(findAndReplaceDialog);
        findAndReplaceDialog.setVisible(true);
    }

    public void findNext() {
        this.getFindAndReplace().setForward(!this.getFindAndReplace().isReversed());
        this.getFindAndReplace().searchAgain();
    }

    public void findPrevious() {
        this.getFindAndReplace().setForward(this.getFindAndReplace().isReversed());
        this.getFindAndReplace().searchAgain();
    }

    public void replace() {
        Window window;
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        this.getFindAndReplace().setReplace(true);
        if (this.getSelectionModel().hasSelection() && this.getSelectionModel().getSelectionStartLine() == this.getSelectionModel().getSelectionEndLine()) {
            this.getFindAndReplace().setFindText(this.getSelectedText());
        }
        FindAndReplaceDialog findAndReplaceDialog = (window = JideSwingUtilities.getWindowForComponent(this)) instanceof Frame ? new FindAndReplaceDialog((Frame)window, this.getResourceString("FindAndReplace.replaceTitle"), this.getFindAndReplace()) : new FindAndReplaceDialog((Dialog)window, this.getResourceString("FindAndReplace.replaceTitle"), this.getFindAndReplace());
        this.customizeDialogData(findAndReplaceDialog);
        findAndReplaceDialog.pack();
        findAndReplaceDialog.setLocationRelativeTo(this);
        if (this.\u0173 != null) {
            findAndReplaceDialog.setBounds(this.\u0173);
        }
        findAndReplaceDialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (componentEvent.getSource() instanceof FindAndReplaceDialog) {
                    CodeEditor.this.\u0173 = ((FindAndReplaceDialog)componentEvent.getSource()).getBounds();
                }
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                if (componentEvent.getSource() instanceof FindAndReplaceDialog) {
                    CodeEditor.this.\u0173 = ((FindAndReplaceDialog)componentEvent.getSource()).getBounds();
                }
            }
        });
        this.customizeDialog(findAndReplaceDialog);
        findAndReplaceDialog.setVisible(true);
    }

    public void quickSearch(String string) {
        this.getSearchable().showPopup(string);
    }

    private static void \u0101(CodeEditor codeEditor, boolean bl, int n2) {
        if (bl) {
            if (codeEditor.getSelectionModel().isColumnSelectionMode()) {
                codeEditor.getSelectionModel().setSelection(n2, codeEditor.getCaretModel().getOffset());
            } else {
                codeEditor.getSelectionModel().setSelection(n2, codeEditor.getCaretModel().getOffset());
            }
        } else {
            codeEditor.getSelectionModel().clearSelection();
        }
    }

    public void moveToLineEnd(boolean bl) {
        int n2 = this.getLeadSelectionOffset();
        int n3 = this.getCaretModel().getModelPosition().line;
        if (n3 >= this.getLineCount()) {
            CaretPosition caretPosition = new CaretPosition(n3, 0);
            this.getCaretModel().setModelPosition(caretPosition);
            CodeEditor.\u0101(this, bl, n2);
            if (this.\u017d || this.getAutoscrolls()) {
                this.scrollToCaret();
            }
            return;
        }
        CaretPosition caretPosition = this.getCaretModel().getViewPosition();
        caretPosition = new CaretPosition(caretPosition.line, com.jidesoft.editor.A.\u0101(this, caretPosition.line));
        CaretPosition caretPosition2 = this.viewToModelPosition(caretPosition);
        int n4 = this.modelPositionToOffset(caretPosition2);
        n3 = caretPosition2.line;
        int n5 = n4;
        int n6 = this.getLineStartOffset(n3);
        try {
            String string = this.getDocument().getLineText(n6);
            for (int i2 = n5 - 1 - n6; i2 >= 0 && (string.charAt(i2) == ' ' || string.charAt(i2) == '\t'); --i2) {
                n5 = i2 + n6;
            }
        }
        catch (BadLocationException badLocationException) {
            \u0184.warning(badLocationException.getLocalizedMessage());
        }
        if (n5 == this.getCaretModel().getOffset()) {
            n5 = n4;
        }
        this.getCaretModel().setOffset(n5);
        if (this.\u017d || this.getAutoscrolls()) {
            this.scrollToCaret();
        }
        CodeEditor.\u0101(this, bl, n2);
        this.adjustColumnSelectionModelOnCaretMoving(bl);
        if (!this.isVirtualSpaceAllowed()) {
            this.setMagicCaretPosition(this.columnToX(this.getCaretModel().getViewPosition().line, this.getCaretModel().getViewPosition().column));
        }
    }

    private static int \u0102(CodeEditor codeEditor, int n2) {
        int n3 = CodeEditor.\u0103(codeEditor, n2);
        if (n3 >= 0) {
            int n4 = CodeEditor.\u0101(codeEditor, n3);
            return codeEditor.offsetToModelPosition((int)n4).column;
        }
        return 0;
    }

    private static int \u0103(CodeEditor codeEditor, int n2) {
        if (n2 < 0 || n2 > codeEditor.getDocumentLength()) {
            return -1;
        }
        int n3 = Math.max(n2 - codeEditor.getDocument().getLookupBufferSize(), 0);
        int n4 = Math.min(codeEditor.getDocument().getLookupBufferSize(), n2);
        while (n3 >= 0) {
            char c2;
            int n5;
            String string = codeEditor.getText(n3, n4);
            for (n5 = string.length() - 1; n5 >= 0 && ((c2 = string.charAt(n5)) == ' ' || c2 == '\t' || c2 == '\r' || c2 == '\n'); --n5) {
            }
            if (n5 >= 0) {
                return codeEditor.getLineNumber(n5 + n3);
            }
            if (n3 == 0) break;
            n4 = Math.min(codeEditor.getDocument().getLookupBufferSize(), n3);
            n3 = Math.max(n3 - codeEditor.getDocument().getLookupBufferSize(), 0);
        }
        return -1;
    }

    private static int \u0101(CodeEditor codeEditor, int n2) {
        int n3 = codeEditor.getLineStartOffset(n2);
        int n4 = codeEditor.getLineEndOffset(n2);
        try {
            String string = codeEditor.getDocument().getLineText(n3);
            for (int i2 = 0; i2 < n4 - n3; ++i2) {
                char c2 = string.charAt(i2);
                if (c2 == ' ' || c2 == '\t') continue;
                return n3 + i2;
            }
        }
        catch (BadLocationException badLocationException) {
            \u0184.warning(badLocationException.getLocalizedMessage());
        }
        return n4;
    }

    private void \u0101(boolean bl, int n2, int n3) {
        this.\u0117();
        if (this.getSelectionModel().isColumnSelectionMode()) {
            int n4 = this.getCaretModel().getViewPosition().line + n3;
            int n5 = this.getCaretModel().getViewPosition().column + n2;
            int n6 = this.modelPositionToOffset(this.viewToModelPosition(new CaretPosition(n4, n5)));
            this.setSelectionRectangular(true);
            this.\u0101(n6, n4, n5);
        } else {
            this.getCaretModel().moveCaret(n2, n3, bl, false, this.\u017d || this.getAutoscrolls());
        }
        if (!this.isVirtualSpaceAllowed() && n2 != 0) {
            this.setMagicCaretPosition(this.columnToX(this.getCaretModel().getViewPosition().line, this.getCaretModel().getViewPosition().column));
        }
        this.adjustColumnSelectionModelOnCaretMoving(bl);
    }

    private void \u0117() {
        Object object = this.getClientProperty("INTELLI_HINTS");
        if (object instanceof AbstractCodeEditorIntelliHints) {
            ((AbstractCodeEditorIntelliHints)object).hideHintsPopup();
        }
    }

    public void moveToLineStart(boolean bl) {
        boolean bl2;
        int n2;
        int n3 = this.getLeadSelectionOffset();
        int n4 = this.getCaretModel().getModelPosition().column;
        CaretPosition caretPosition = this.getCaretModel().getViewPosition();
        for (n2 = this.getCaretModel().getModelPosition().line; n2 >= 0 && this.modelToViewPosition((CaretPosition)new CaretPosition((int)n2, (int)0)).line == caretPosition.line; --n2) {
        }
        ++n2;
        boolean bl3 = bl2 = !Boolean.FALSE.equals(this.getClientProperty(SMART_HOME_END_PROPERTY));
        if (!bl2) {
            CaretPosition caretPosition2 = new CaretPosition(n2, 0);
            this.getCaretModel().setModelPosition(caretPosition2);
            CodeEditor.\u0101(this, bl, n3);
            if (this.\u017d || this.getAutoscrolls()) {
                this.scrollToCaret();
            }
            return;
        }
        int n5 = this.getCaretModel().getOffset();
        if (n2 >= this.getLineCount() || n5 > this.getDocumentLength()) {
            int n6 = 0;
            if (n4 == 0) {
                n6 = CodeEditor.\u0102(this, n5);
            }
            CaretPosition caretPosition3 = new CaretPosition(n2, n6);
            this.getCaretModel().setModelPosition(caretPosition3);
            CodeEditor.\u0101(this, bl, n3);
            if (this.\u017d || this.getAutoscrolls()) {
                this.scrollToCaret();
            }
            return;
        }
        int n7 = CodeEditor.\u0101(this, n2);
        int n8 = this.getLineEndOffset(n2);
        if (n2 > 0 && n8 == n7 && n4 == 0) {
            int n9 = CodeEditor.\u0102(this, n5);
            CaretPosition caretPosition4 = new CaretPosition(n2, n9);
            this.getCaretModel().setModelPosition(caretPosition4);
            CodeEditor.\u0101(this, bl, n3);
            if (this.\u017d || this.getAutoscrolls()) {
                this.scrollToCaret();
            }
            return;
        }
        int n10 = this.getLineStartOffset(n2);
        if (n7 < n5 || n4 == 0) {
            n10 = n7;
        }
        this.getCaretModel().setOffset(n10);
        if (this.\u017d || this.getAutoscrolls()) {
            this.scrollToCaret();
        }
        CodeEditor.\u0101(this, bl, n3);
        this.adjustColumnSelectionModelOnCaretMoving(bl);
        if (!this.isVirtualSpaceAllowed()) {
            this.setMagicCaretPosition(this.columnToX(this.getCaretModel().getViewPosition().line, this.getCaretModel().getViewPosition().column));
        }
    }

    public void moveToDocumentStart(boolean bl) {
        if (bl) {
            this.select(this.getMarkPosition(), 0);
        } else {
            this.select(0);
        }
        this.adjustColumnSelectionModelOnCaretMoving(bl);
        if (!this.isVirtualSpaceAllowed()) {
            this.setMagicCaretPosition(this.columnToX(this.getCaretModel().getViewPosition().line, this.getCaretModel().getViewPosition().column));
        }
    }

    public void moveToDocumentEnd(boolean bl) {
        if (bl) {
            this.select(this.getMarkPosition(), this.getDocumentLength());
        } else {
            this.select(this.getDocumentLength());
        }
        this.adjustColumnSelectionModelOnCaretMoving(bl);
        if (!this.isVirtualSpaceAllowed()) {
            this.setMagicCaretPosition(this.columnToX(this.getCaretModel().getViewPosition().line, this.getCaretModel().getViewPosition().column));
        }
    }

    public void moveToNextChar(boolean bl) {
        if (!bl && this.getSelectionModel().hasSelection()) {
            this.getCaretModel().setOffset(Math.min(this.getDocumentLength(), Math.max(this.getSelectionModel().getSelectionStart(), this.getSelectionModel().getSelectionEnd())));
            this.getSelectionModel().clearSelection();
            if (this.\u017d || this.getAutoscrolls()) {
                this.scrollToCaret();
            }
            this.setBlink(true);
            if (!this.isVirtualSpaceAllowed()) {
                this.setMagicCaretPosition(this.columnToX(this.getCaretModel().getViewPosition().line, this.getCaretModel().getViewPosition().column));
            }
            return;
        }
        if (this.getCaretModel().getOffset() >= this.getDocumentLength() && !this.isVirtualSpaceAllowed()) {
            PortingUtils.notifyUser();
            return;
        }
        this.\u0101(bl, 1, 0);
    }

    public void moveToNextLine(boolean bl) {
        if (this.getCaretModel().getViewPosition().line >= this.getVisualLineCount() - 1) {
            PortingUtils.notifyUser();
            return;
        }
        this.\u0101(bl, 0, 1);
    }

    public void moveToNextPage(boolean bl) {
        int n2 = this.getVisibleLines();
        int n3 = this.getCaretModel().getViewPosition().line;
        int n4 = this.getVisualLineCount();
        if (n3 >= n4 || this.getCaretModel().getOffset() >= this.getDocumentLength()) {
            PortingUtils.notifyUser();
            return;
        }
        if (n3 + n2 > n4 - 1) {
            n2 = n4 - n3 - 1;
        }
        this.\u0101(bl, 0, n2);
    }

    public void moveToNextWord(boolean bl) {
        this.moveToNextWord(bl, true);
    }

    public void moveToNextWord(boolean bl, boolean bl2) {
        int n2;
        int n3;
        int n4;
        int n5;
        this.\u0117();
        int n6 = n5 = this.getCaretModel().getOffset();
        do {
            boolean bl3 = n6 == n5;
            n3 = this.offsetToModelPosition((int)n6).line;
            n6 = this.\u0102(n6, bl2, bl3);
            n4 = this.offsetToModelPosition((int)n6).line;
            n2 = this.getLineStartOffset(n4) + this.getLineEndOffsetExcludeLineBreak(n4);
        } while (n6 <= this.getDocumentLength() && n6 >= 0 && n4 < this.getLineCount() - 1 && n4 != n3);
        n6 = Math.min(n6, n2);
        if (n6 > this.getDocumentLength() || n6 < 0) {
            PortingUtils.notifyUser();
        } else {
            if (bl) {
                this.select(this.getMarkPosition(), n6);
            } else {
                this.select(n6);
            }
            if (!this.isVirtualSpaceAllowed()) {
                this.setMagicCaretPosition(this.columnToX(this.getCaretModel().getViewPosition().line, this.getCaretModel().getViewPosition().column));
            }
        }
        this.adjustColumnSelectionModelOnCaretMoving(bl);
    }

    private int \u0102(int n2, boolean bl, boolean bl2) {
        int n3;
        int n4 = this.offsetToModelPosition((int)n2).line;
        int n5 = this.getLineStartOffset(n4);
        int n6 = n2 - n5;
        String string = this.getLineText(n4);
        String string2 = (String)this.getDocument().getProperty("nonwordDelimiters");
        if (n6 > this.getLineEndOffsetExcludeLineBreak(n4)) {
            n3 = n4 + 1;
            n6 = n3 >= this.getLineCount() ? -1 : this.getLineStartOffset(n3);
        } else {
            n6 = TextUtils.findWordEnd(string, n6 + 1, string2, true, bl);
            n6 += n5;
        }
        if (n6 >= 0 && !bl2 && bl && (n3 = this.offsetToModelPosition((int)n6).line) == n4) {
            n6 = TextUtils.findWordStart(string, n6 - n5 - 1, string2, true, !bl, true) + n5;
        }
        return n6;
    }

    public void moveToPreviousChar(boolean bl) {
        if (!bl && this.getSelectionModel().hasSelection()) {
            this.getCaretModel().setOffset(Math.min(this.getSelectionModel().getSelectionStart(), this.getSelectionModel().getSelectionEnd()));
            this.getSelectionModel().clearSelection();
            if (this.\u017d || this.getAutoscrolls()) {
                this.scrollToCaret();
            }
            this.setBlink(true);
            if (!this.isVirtualSpaceAllowed()) {
                this.setMagicCaretPosition(this.columnToX(this.getCaretModel().getViewPosition().line, this.getCaretModel().getViewPosition().column));
            }
            return;
        }
        if (this.getCaretModel().getOffset() <= 0) {
            PortingUtils.notifyUser();
            return;
        }
        this.\u0101(bl, -1, 0);
    }

    public void moveToPreviousLine(boolean bl) {
        if (this.getCaretModel().getViewPosition().line <= 0) {
            PortingUtils.notifyUser();
            return;
        }
        this.\u0101(bl, 0, -1);
    }

    public void moveToPreviousPage(boolean bl) {
        int n2 = this.getVisibleLines();
        int n3 = this.getCaretModel().getViewPosition().line;
        if (n3 <= 0) {
            PortingUtils.notifyUser();
            return;
        }
        if (n3 - n2 < 0) {
            n2 = n3;
        }
        this.\u0101(bl, 0, -n2);
    }

    public void moveToPreviousWord(boolean bl) {
        this.moveToPreviousWord(bl, false);
    }

    public void moveToPreviousWord(boolean bl, boolean bl2) {
        int n2;
        int n3;
        int n4;
        int n5;
        this.\u0117();
        for (n5 = n4 = this.getCaretModel().getOffset(); (n5 = this.\u0101(n5, bl2, n5 == n4)) == (n3 = this.getLineStartOffset(n2 = this.offsetToModelPosition((int)n5).line)) && n5 < this.getDocumentLength() && n5 > 0 && n2 != 0 && Character.isWhitespace(this.getText(n5, 1).charAt(0)); --n5) {
        }
        if (n5 < 0) {
            PortingUtils.notifyUser();
        } else {
            if (bl) {
                this.select(this.getMarkPosition(), n5);
            } else {
                this.select(n5);
            }
            if (!this.isVirtualSpaceAllowed()) {
                this.setMagicCaretPosition(this.columnToX(this.getCaretModel().getViewPosition().line, this.getCaretModel().getViewPosition().column));
            }
        }
        this.adjustColumnSelectionModelOnCaretMoving(bl);
    }

    protected void adjustColumnSelectionModelOnCaretMoving(boolean bl) {
        if (!bl && this.getSelectionModel().isColumnSelectionMode()) {
            this.getSelectionModel().setColumnSelectionMode(false);
        }
    }

    private int \u0101(int n2, boolean bl, boolean bl2) {
        int n3 = this.offsetToModelPosition((int)n2).line;
        int n4 = this.getLineStartOffset(n3);
        String string = this.getLineText(n3);
        int n5 = n2 - n4;
        if (n5 == 0) {
            int n6;
            n5 = n4 == 0 ? -1 : ((n6 = n3 - 1) == -1 ? -1 : this.getLineStartOffset(n6) + this.getLineEndOffsetExcludeLineBreak(n6));
        } else {
            String string2 = (String)this.getDocument().getProperty("nonwordDelimiters");
            n5 = TextUtils.findWordStart(string, n5 - 1, string2, true, bl, bl2);
            n5 += n4;
        }
        return n5;
    }

    public void toggleOverwrite() {
        this.setOverwriteEnabled(!this.isOverwriteEnabled());
    }

    public void splitLine() {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        if (this.getSelectionModel().isColumnSelectionMode()) {
            this.deleteChar();
            return;
        }
        int n2 = this.getSelectionModel().hasSelection() ? this.getSelectionStart() : this.getCaretModel().getOffset();
        this.insertBreak();
        this.getCaretModel().setOffset(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertBreak() {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        if (this.getSelectionModel().isColumnSelectionMode() && this.getSelectionModel().hasSelection()) {
            this.deleteChar();
            return;
        }
        this._document.beginCompoundEdit();
        try {
            this.setSelectedText(this.\u0119());
            int n2 = this.getCaretModel().getModelPosition().line;
            int n3 = n2 - 1;
            if (n3 >= 0) {
                try {
                    int n4 = this.getCaretModel().getOffset();
                    String string = this.isAutoIndent() ? TextUtils.getLeadingWhitespace(this.getLineText(n3)) : "";
                    this.getDocument().insertString(n4, string, null);
                    this.setMagicCaretPosition(this.columnToX(n3, string.length()));
                }
                catch (BadLocationException badLocationException) {
                    \u0184.warning(badLocationException.getLocalizedMessage());
                }
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    public void startNewLine() {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        if (this.getSelectionModel().isColumnSelectionMode()) {
            this.deleteChar();
            return;
        }
        this._document.beginCompoundEdit();
        try {
            int n2 = this.getCaretModel().getModelPosition().line;
            String string = this.isAutoIndent() ? TextUtils.getLeadingWhitespace(this.getLineText(n2)) : "";
            this.gotoEndOfLine();
            this.setSelectedText(this.\u0119() + string);
            this.setMagicCaretPosition(this.columnToX(n2, string.length()));
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indentSelection() {
        block9: {
            if (!this.isEditable() || !this.isEnabled()) {
                PortingUtils.notifyUser();
                return;
            }
            try {
                this._document.beginCompoundEdit();
                if (!this.getSelectionModel().hasSelection() || this.getSelectionModel().isColumnSelectionMode()) {
                    this.insertChar("\t");
                    break block9;
                }
                int n2 = this.getSelectionEndLine();
                int n3 = this.getSelectionStartLine();
                try {
                    String string = this._document.getText(this.getSelectionEnd() - 1, 1);
                    if (string.equals("\n") || string.equals("\r")) {
                        --n2;
                    }
                }
                catch (BadLocationException badLocationException) {
                    \u0184.warning(badLocationException.getLocalizedMessage());
                }
                for (int i2 = n3; i2 <= n2; ++i2) {
                    this.indentLine(i2, false);
                }
            }
            finally {
                this._document.endCompoundEdit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unindentSelection() {
        if (!this.isEditable() || !this.isEnabled() || this.getSelectionModel().isColumnSelectionMode()) {
            PortingUtils.notifyUser();
            return;
        }
        try {
            int n2;
            this._document.beginCompoundEdit();
            int n3 = this.getSelectionModel().hasSelection() ? this.getSelectionStartLine() : this.getCaretModel().getModelPosition().line;
            int n4 = n2 = this.getSelectionModel().hasSelection() ? this.getSelectionEndLine() : n3;
            if (n2 < n3) {
                n2 = n3;
            }
            for (int i2 = n3; i2 <= n2; ++i2) {
                this.indentLine(i2, true);
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean indentLine(int n2, boolean bl) {
        int[] nArray = new int[1];
        int n3 = this.getCurrentIndentForLine(n2, nArray);
        if (bl) {
            if ((n3 -= this.getTabSize()) < 0) {
                n3 = 0;
            }
        } else {
            n3 += this.getTabSize();
        }
        try {
            this._document.beginCompoundEdit();
            int n4 = this.getLineStartOffset(n2);
            try {
                this._document.remove(n4, nArray[0]);
                this._document.insertString(n4, TextUtils.createWhiteSpace(n3, this.getTabSize(), this.isReplaceTabWithSpace()), null);
            }
            catch (BadLocationException badLocationException) {
                \u0184.warning(badLocationException.getLocalizedMessage());
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
        return true;
    }

    public int getCurrentIndentForLine(int n2, int[] nArray) {
        if (!this.getLineText(n2, this.lineSegment)) {
            return 0;
        }
        int n3 = this.getTabSize();
        int n4 = 0;
        block4: for (int i2 = 0; i2 < this.lineSegment.count; ++i2) {
            char c2 = this.lineSegment.array[this.lineSegment.offset + i2];
            switch (c2) {
                case ' ': {
                    ++n4;
                    if (nArray == null) continue block4;
                    nArray[0] = nArray[0] + 1;
                    continue block4;
                }
                case '\t': {
                    n4 += n3 - n4 % n3;
                    if (nArray == null) continue block4;
                    nArray[0] = nArray[0] + 1;
                    continue block4;
                }
            }
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void \u0105(String string) {
        SelectionModel selectionModel = this.getSelectionModel();
        if (!selectionModel.hasSelection() || !selectionModel.isColumnSelectionMode()) {
            this.\u0103(string);
            return;
        }
        boolean bl = this.isVirtualSpaceAllowed();
        this.setVirtualSpaceAllowed(true);
        try {
            int n2;
            int n3 = this.getSelectionStartLine();
            int n4 = this.getSelectionEndLine();
            for (n2 = n3; n2 < n4 && this.getSelectionStart(n2) + 1 == this.getSelectionEnd(n2 + 1); ++n2) {
            }
            if (n2 >= n4) {
                this.\u0103(string);
                return;
            }
            CaretPosition caretPosition = this.getSelectionModel().getSelectionStartViewPosition();
            CaretPosition caretPosition2 = this.getSelectionModel().getSelectionEndViewPosition();
            this.\u0106(2);
            if (caretPosition != null && caretPosition2 != null) {
                int n5 = Math.min(caretPosition.column, caretPosition2.column);
                this.getSelectionModel().setSelection(new CaretPosition(caretPosition.line, n5), new CaretPosition(caretPosition2.line, n5));
                this.getCaretModel().setViewPosition(new CaretPosition(Math.min(caretPosition.line, caretPosition2.line), n5));
            }
            String[] stringArray = new String[n4 - n3 + 1];
            for (int i2 = 0; i2 < n4 - n3 + 1; ++i2) {
                stringArray[i2] = string;
            }
            CaretPosition[] caretPositionArray = this.\u0101(stringArray, n3);
            if (caretPositionArray.length == 2 && caretPositionArray[0] != null && caretPositionArray[1] != null) {
                this.\u0101(caretPositionArray[0], caretPositionArray[1], false);
                this.getCaretModel().setViewPosition(new CaretPosition(Math.min(caretPositionArray[0].line, caretPositionArray[1].line), Math.max(caretPositionArray[0].column, caretPositionArray[1].column)));
            }
            if (this.\u017d || this.getAutoscrolls()) {
                this.scrollToCaret();
            }
        }
        finally {
            this.setVirtualSpaceAllowed(bl);
        }
    }

    private void \u0114() {
        this.\u0106(2);
    }

    private void \u0106(int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = this.getSelectionStartLine();
        int n9 = this.getSelectionEndLine();
        int n10 = n9 - n8 + 1;
        int[] nArray = new int[n10 * 2];
        boolean bl = true;
        for (n7 = n8; n7 <= n9; ++n7) {
            if (this.getLineEndOffsetExcludeLineBreak(n7) == 0) continue;
            bl = false;
            break;
        }
        for (n7 = n8; n7 <= n9; ++n7) {
            n6 = this.getLineStartOffset(n7);
            if (bl) {
                nArray[(n7 - n8) * 2] = n6;
                nArray[(n7 - n8) * 2 + 1] = n6;
                continue;
            }
            n5 = this.getSelectionStart(n7);
            n4 = this.getSelectionEnd(n7);
            n3 = this.getLineEndOffsetExcludeLineBreak(n7) + this.getLineStartOffset(n7);
            if (n5 >= n3 && n2 == 0 || (n4 <= n6 || n4 > n3) && n2 == 1) {
                nArray[(n7 - n8) * 2] = -1;
                nArray[(n7 - n8) * 2 + 1] = -1;
                continue;
            }
            nArray[(n7 - n8) * 2] = Math.min(n5, n4);
            nArray[(n7 - n8) * 2 + 1] = Math.max(n5, n4);
        }
        n6 = this.getSelectionModel().getSelectionStart() > this.getSelectionModel().getSelectionEnd() ? this.getCaretModel().getViewPosition().column : this.offsetToViewPosition((int)this.getSelectionStart()).column;
        n5 = this.getSelectionModel().getSelectionStart() < this.getSelectionEnd() ? this.getCaretModel().getViewPosition().column : this.offsetToViewPosition((int)this.getSelectionEnd()).column;
        n4 = Math.min(n6, n5);
        n3 = 0;
        for (n7 = n9; n7 >= n8; --n7) {
            if (nArray[(n7 - n8) * 2] < 0 || nArray[(n7 - n8) * 2 + 1] < 0) continue;
            try {
                n3 = nArray[(n7 - n8) * 2 + 1] - nArray[(n7 - n8) * 2];
                if (n3 > 0) {
                    this.getDocument().remove(nArray[(n7 - n8) * 2], n3);
                    continue;
                }
                switch (n2) {
                    case 0: {
                        this.getDocument().remove(nArray[(n7 - n8) * 2], 1);
                        break;
                    }
                    case 1: {
                        if (n4 <= 0) break;
                        this.getDocument().remove(nArray[(n7 - n8) * 2] - 1, 1);
                        break;
                    }
                }
                continue;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (n2 == 1) {
            if (n3 == 0) {
                --n4;
            } else if (n4 == n5) {
                n4 -= n3;
            }
        }
        CaretModel caretModel = this.getCaretModel();
        CaretPosition caretPosition = new CaretPosition(caretModel.getViewPosition().line, n4);
        caretModel.setViewPosition(caretPosition);
    }

    private void \u0103(String string) {
        com.jidesoft.editor.A.\u0101(this);
        com.jidesoft.editor.A.\u0101(this, string, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertChar(String string) {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        this.expandFolding();
        try {
            int n2;
            this._document.beginCompoundEdit();
            int n3 = this.getInputHandler().getRepeatCount();
            if ("\t".equals(string) && this.isReplaceTabWithSpace() && (n2 = this.getTabSize()) >= 1) {
                if (this.isTabAlignment() && n3 == 1) {
                    n2 = !this.getSelectionModel().hasSelection() ? (n2 -= this.getCaretModel().getViewPosition().column % n2) : (n2 -= this.offsetToViewPosition((int)this.getSelectionStart()).column % n2);
                }
                StringBuffer stringBuffer = new StringBuffer(n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    stringBuffer.append(' ');
                }
                string = stringBuffer.toString();
            }
            if (this.isEditable() && this.isEnabled()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i3 = 0; i3 < n3; ++i3) {
                    stringBuffer.append(string);
                }
                this.\u0105(stringBuffer.toString());
            } else {
                PortingUtils.notifyUser();
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinLines() {
        block17: {
            if (!this.isEditable() || !this.isEnabled()) {
                PortingUtils.notifyUser();
                return;
            }
            try {
                this._document.beginCompoundEdit();
                if (!this.getSelectionModel().hasSelection()) {
                    int n2 = this.getCaretModel().getModelPosition().line;
                    int n3 = this.getLineEndOffset(n2);
                    try {
                        if (n2 >= 0 && n2 < this.getLineCount() - 1) {
                            this._document.remove(n3, 1 + TextUtils.getLeadingWhitespace(this.getLineText(n2 + 1)).length());
                            this._document.insertString(n3, " ", null);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        \u0184.warning(badLocationException.getLocalizedMessage());
                    }
                    this.select(n3);
                    break block17;
                }
                if (this.getSelectionEndLine() != this.getSelectionStartLine()) {
                    int n4 = this.getSelectionStartLine();
                    int n5 = this.getSelectionEndLine();
                    try {
                        String string = this._document.getText(this.getSelectionEnd() - 1, 1);
                        if (string.equals("\n") || string.equals("\r")) {
                            --n5;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        \u0184.warning(badLocationException.getLocalizedMessage());
                    }
                    if (n5 - n4 >= 1) {
                        for (int i2 = n5 - 1; i2 >= n4; --i2) {
                            int n6 = this.getLineEndOffset(i2);
                            try {
                                this._document.remove(n6, 1 + TextUtils.getLeadingWhitespace(this.getLineText(i2 + 1)).length());
                                this._document.insertString(n6, " ", null);
                                continue;
                            }
                            catch (BadLocationException badLocationException) {
                                \u0184.warning(badLocationException.getLocalizedMessage());
                            }
                        }
                    } else {
                        PortingUtils.notifyUser();
                    }
                    break block17;
                }
                PortingUtils.notifyUser();
            }
            finally {
                this._document.endCompoundEdit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleCase() {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        if (!this.getSelectionModel().hasSelection()) {
            PortingUtils.notifyUser();
            return;
        }
        try {
            this._document.beginCompoundEdit();
            String string = this.getSelectionModel().getSelectedText();
            int n2 = this.getSelectionStart();
            int n3 = this.getSelectionEnd();
            CaretPosition caretPosition = this.getSelectionModel().getSelectionStartViewPosition();
            CaretPosition caretPosition2 = this.getSelectionModel().getSelectionEndViewPosition();
            boolean bl = this.getSelectionModel().isColumnSelectionMode();
            string = this.\u0102(string) ? string.toLowerCase(this.getLocale()) : string.toUpperCase(this.getLocale());
            boolean bl2 = this.isIndentOnPasting();
            this.setIndentOnPasting(false);
            try {
                this.\u0106(string);
            }
            finally {
                this.setIndentOnPasting(bl2);
            }
            this.getSelectionModel().setColumnSelectionMode(bl);
            if (this.getSelectionModel().isColumnSelectionMode()) {
                this.getSelectionModel().setSelection(caretPosition, caretPosition2);
            } else {
                this.getSelectionModel().setSelection(n2, n3);
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    private boolean \u0102(String string) {
        if (string.length() <= 0) {
            return false;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (!Character.isLetter(c2)) continue;
            return Character.isUpperCase(c2);
        }
        return false;
    }

    public void duplicateSelection() {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        this._document.beginCompoundEdit();
        try {
            String string = this.getSelectedText();
            if (string == null || string.length() == 0) {
                int n2 = this.getCaretModel().getOffset();
                this.selectLine(this.getCaretModel().getModelPosition().line);
                string = this.getSelectedText();
                if (string == null) {
                    this.setSelectedText("\n");
                    this.getCaretModel().setOffset(n2 + 1);
                } else if (!string.endsWith("\n")) {
                    this.setSelectedText(string + "\n" + string);
                    this.getCaretModel().setOffset(n2 + string.length() + 1);
                } else {
                    this.setSelectedText(string + string);
                    this.getCaretModel().setOffset(n2 + string.length());
                }
            } else {
                this.setSelectedText(string + string);
                int n3 = this.getCaretModel().getOffset();
                this.select(n3 - string.length(), n3);
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backspaceChar() {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        this._document.beginCompoundEdit();
        try {
            if (this.getSelectionStart() != this.getSelectionEnd()) {
                if (this.getSelectionModel().isColumnSelectionMode()) {
                    this.\u0106(1);
                } else {
                    this.setSelectedText("");
                }
            } else {
                FoldingSpan[] foldingSpanArray;
                CaretPosition caretPosition = this.getCaretModel().getModelPosition();
                if (this.getLineEndOffset(caretPosition.line) - this.getLineStartOffset(caretPosition.line) < caretPosition.column) {
                    CaretPosition caretPosition2 = this.getCaretModel().getViewPosition();
                    this.getCaretModel().setViewPosition(new CaretPosition(caretPosition2.line, caretPosition2.column - 1));
                    return;
                }
                int n2 = this.getCaretModel().getOffset();
                if (n2 == 0) {
                    PortingUtils.notifyUser();
                    return;
                }
                if (this.getFoldingModel() instanceof DefaultFoldingModel && this.getFoldingModel().isEnabled() && (foldingSpanArray = ((DefaultFoldingModel)this.getFoldingModel()).getTopLevelSpans()) != null) {
                    for (FoldingSpan foldingSpan : foldingSpanArray) {
                        if (foldingSpan.getEndOffset() != n2) continue;
                        return;
                    }
                }
                try {
                    int n3 = n2 - 1;
                    int n4 = 1;
                    String string = this.\u0119();
                    int n5 = string.indexOf(this.getDocument().getText(n3, n4));
                    if (n5 >= 0 && n3 >= n5 && string.equals(this.getDocument().getText(n3 - n5, string.length()))) {
                        n3 -= n5;
                        n4 = string.length();
                    }
                    this.getDocument().remove(n3, n4);
                    this.getCaretModel().setOffset(n3);
                }
                catch (BadLocationException badLocationException) {
                    \u0184.warning(badLocationException.getLocalizedMessage());
                }
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backspaceWord() {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        this._document.beginCompoundEdit();
        try {
            int n2 = this.getCaretModel().getOffset();
            this.moveToPreviousWord(false);
            int n3 = this.getCaretModel().getOffset();
            if (n3 < n2) {
                try {
                    this.getDocument().remove(n3, n2 - n3);
                }
                catch (BadLocationException badLocationException) {
                    \u0184.warning(badLocationException.getLocalizedMessage());
                }
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteChar() {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        this._document.beginCompoundEdit();
        try {
            if (this.getSelectionStart() != this.getSelectionEnd()) {
                if (this.getSelectionModel().isColumnSelectionMode()) {
                    this.\u0114();
                } else {
                    this.setSelectedText("");
                }
            } else {
                String string;
                FoldingSpan[] foldingSpanArray;
                int n2 = this.getCaretModel().getOffset();
                if (n2 == this.getDocumentLength()) {
                    PortingUtils.notifyUser();
                    return;
                }
                if (this.getFoldingModel() instanceof DefaultFoldingModel && this.getFoldingModel().isEnabled() && (foldingSpanArray = ((DefaultFoldingModel)this.getFoldingModel()).getTopLevelSpans()) != null) {
                    for (FoldingSpan foldingSpan : foldingSpanArray) {
                        if (foldingSpan.getStartOffset() != n2) continue;
                        return;
                    }
                }
                foldingSpanArray = this.getCaretModel().getModelPosition();
                int n3 = foldingSpanArray.column - (this.getLineEndOffset(foldingSpanArray.line) - this.getLineStartOffset(foldingSpanArray.line));
                int n4 = 1;
                if (n3 > 0) {
                    this.\u0105("t");
                    n2 = this.getCaretModel().getOffset() - 1;
                    ++n4;
                }
                if ((string = this.getText(n2, Math.min(2, this.getDocumentLength() - n2))) != null && string.length() >= 1 && string.charAt(0) == '\r' && string.length() >= 2 && string.charAt(1) == '\n') {
                    ++n4;
                }
                try {
                    this.getDocument().remove(n2, n4);
                }
                catch (BadLocationException badLocationException) {
                    \u0184.warning(badLocationException.getLocalizedMessage());
                }
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWord() {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        this._document.beginCompoundEdit();
        try {
            int n2 = this.getCaretModel().getOffset();
            this.moveToNextWord(true);
            int n3 = this.getCaretModel().getOffset();
            if (n3 > n2) {
                try {
                    this.getDocument().remove(n2, n3 - n2);
                }
                catch (BadLocationException badLocationException) {
                    \u0184.warning(badLocationException.getLocalizedMessage());
                }
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLine() {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        int n2 = this.getCaretModel().getModelPosition().line;
        int n3 = this.getLineStartOffset(n2);
        int n4 = this.getLineEndOffset(n2) + 1;
        try {
            if (n4 > this.getDocumentLength()) {
                if (n3 != 0) {
                    --n3;
                }
                n4 = this.getDocumentLength();
            }
            this._document.beginCompoundEdit();
            try {
                this._document.remove(n3, n4 - n3);
            }
            catch (BadLocationException badLocationException) {
                \u0184.warning(badLocationException.getLocalizedMessage());
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    public void clipboardCut() {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        if (this._document.getUndoManager() instanceof DelayUndoManager) {
            ((DelayUndoManager)this._document.getUndoManager()).commitCache();
        }
        this._document.beginCompoundEdit();
        try {
            this.clipboardCopy();
            if (this.getSelectionModel().isColumnSelectionMode()) {
                this.\u0114();
            } else {
                this.setSelectedText("");
            }
        }
        finally {
            this._document.endCompoundEdit();
            if (this._document.getUndoManager() instanceof DelayUndoManager) {
                ((DelayUndoManager)this._document.getUndoManager()).commitCache();
            }
        }
    }

    public void clipboardMove(int n2) {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        if (this._document.getUndoManager() instanceof DelayUndoManager) {
            ((DelayUndoManager)this._document.getUndoManager()).commitCache();
        }
        this._document.beginCompoundEdit();
        try {
            if (n2 < this.getSelectionStart()) {
                this.clipboardCut();
                this.getCaretModel().setOffset(n2);
                this.clipboardPaste();
            } else if (n2 > this.getSelectionEnd()) {
                int n3 = Math.abs(this.getSelectionEnd() - this.getSelectionStart());
                this.clipboardCut();
                this.getCaretModel().setOffset(n2 - n3);
                this.clipboardPaste();
            }
        }
        finally {
            this._document.endCompoundEdit();
            if (this._document.getUndoManager() instanceof DelayUndoManager) {
                ((DelayUndoManager)this._document.getUndoManager()).commitCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void \u0101(int n2, MouseEvent mouseEvent) {
        if (!(this.isEditable() && this.isEnabled() && this.getSelectionModel().hasSelection())) {
            PortingUtils.notifyUser();
            return;
        }
        String string = this.getSelectedText();
        if (string == null) {
            PortingUtils.notifyUser();
            return;
        }
        this._document.beginCompoundEdit();
        try {
            if (!this.getSelectionModel().isColumnSelectionMode()) {
                if (n2 < this.getSelectionStart()) {
                    if (mouseEvent != null && mouseEvent.isControlDown()) {
                        this.getSelectionModel().clearSelection();
                    } else {
                        this.setSelectedText("");
                        this.getCaretModel().setOffset(n2);
                    }
                    this.\u0105(string);
                } else if (n2 > this.getSelectionEnd()) {
                    int n3 = Math.abs(this.getSelectionEnd() - this.getSelectionStart());
                    if (mouseEvent != null && mouseEvent.isControlDown()) {
                        this.getSelectionModel().clearSelection();
                    } else {
                        this.setSelectedText("");
                        this.getCaretModel().setOffset(n2 - n3);
                    }
                    this.\u0105(string);
                }
            } else {
                Comparable<CaretPosition> comparable;
                if (mouseEvent != null && mouseEvent.isControlDown()) {
                    this.getSelectionModel().clearSelection();
                } else {
                    comparable = this.getCaretModel().getViewPosition();
                    CaretPosition caretPosition = this.getSelectionModel().getSelectionStartViewPosition();
                    CaretPosition caretPosition2 = this.getSelectionModel().getSelectionEndViewPosition();
                    if (caretPosition != null && caretPosition2 != null) {
                        int n4 = Math.min(caretPosition.line, caretPosition2.line);
                        int n5 = Math.max(caretPosition.line, caretPosition2.line);
                        if (((CaretPosition)comparable).line >= n4 && ((CaretPosition)comparable).line <= n5) {
                            int n6 = Math.max(caretPosition.column, caretPosition2.column);
                            int n7 = Math.min(caretPosition.column, caretPosition2.column);
                            if (((CaretPosition)comparable).column >= n6) {
                                comparable = new CaretPosition(((CaretPosition)comparable).line, ((CaretPosition)comparable).column - (n6 - n7));
                            } else if (((CaretPosition)comparable).column >= n7) {
                                comparable = new CaretPosition(((CaretPosition)comparable).line, n7);
                            }
                        }
                    }
                    this.\u0114();
                    this.getSelectionModel().clearSelection();
                    this.getCaretModel().setViewPosition((CaretPosition)comparable);
                }
                comparable = new StringBuffer();
                this.exportText(string, (StringBuffer)comparable);
                this.\u0106(((StringBuffer)comparable).toString());
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    public void clipboardCopy() {
        String string;
        if (!this.getSelectionModel().hasSelection()) {
            this.selectLine(this.getCaretModel().getModelPosition().line);
        }
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        String string2 = string = this.isCopyVisibleTextOnly() ? this.\u0113() : this.getSelectedText();
        if (string == null) {
            PortingUtils.notifyUser();
            return;
        }
        int n2 = this.getInputHandler().getRepeatCount();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(string);
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        this.exportText(stringBuffer.toString(), stringBuffer2);
        StringSelection stringSelection = new StringSelection(stringBuffer2.toString());
        if (_clipboards == null) {
            _clipboards = new ArrayList<Transferable>();
        }
        _clipboards.add(0, stringSelection);
        if (_clipboards.size() > this.getMaxNumberOfClipboards()) {
            _clipboards.remove(_clipboards.size() - 1);
        }
        clipboard.setContents(stringSelection, this.\u0116());
    }

    public void clipboardPaste() {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        if (this._document.getUndoManager() instanceof DelayUndoManager) {
            ((DelayUndoManager)this._document.getUndoManager()).commitCache();
        }
        this._document.beginCompoundEdit();
        try {
            if (this._editable) {
                Clipboard clipboard = this.getToolkit().getSystemClipboard();
                this.\u0101(clipboard.getContents(this));
            }
        }
        finally {
            this._document.endCompoundEdit();
            if (this._document.getUndoManager() instanceof DelayUndoManager) {
                ((DelayUndoManager)this._document.getUndoManager()).commitCache();
            }
        }
    }

    private void \u0101(Transferable transferable) {
        try {
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            this.\u0106(string);
        }
        catch (Exception exception) {
            PortingUtils.notifyUser();
            \u0184.warning(exception.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void \u0106(String string) {
        block41: {
            try {
                int n2;
                int n3 = this.getInputHandler().getRepeatCount();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i2 = 0; i2 < n3; ++i2) {
                    stringBuffer.append(string);
                }
                StringBuffer stringBuffer2 = new StringBuffer();
                int n4 = this.importText(stringBuffer.toString(), stringBuffer2);
                if (this.getSelectionModel().isColumnSelectionMode()) {
                    boolean bl = this.isVirtualSpaceAllowed();
                    this.setVirtualSpaceAllowed(true);
                    try {
                        Object[] objectArray;
                        int n5 = this.getSelectionStartLine();
                        int n6 = this.getSelectionEndLine();
                        int n7 = n6 - n5 + 1;
                        CaretPosition caretPosition = this.getSelectionModel().getSelectionStartViewPosition();
                        CaretPosition caretPosition2 = this.getSelectionModel().getSelectionEndViewPosition();
                        if (!JideSwingUtilities.equals(caretPosition, caretPosition2)) {
                            this.\u0106(2);
                            if (caretPosition != null && caretPosition2 != null) {
                                this.getCaretModel().setViewPosition(new CaretPosition(Math.min(caretPosition.line, caretPosition2.line), Math.min(caretPosition.column, caretPosition2.column)));
                            }
                        }
                        this.getSelectionModel().clearSelection();
                        Object[] objectArray2 = stringBuffer2.toString().split(TextUtils.getLineBreak(n4));
                        if (n7 > objectArray2.length && objectArray2.length > 0) {
                            objectArray = new String[n7];
                            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                                objectArray[i3] = i3 < objectArray2.length && objectArray2[i3] != null ? objectArray2[i3] : objectArray2[objectArray2.length - 1];
                            }
                            objectArray2 = objectArray;
                        }
                        if ((objectArray = this.\u0101((String[])objectArray2, this.getCaretModel().getModelPosition().line)).length >= 2 && objectArray[0] != null && objectArray[1] != null) {
                            this.\u0101((CaretPosition)objectArray[0], (CaretPosition)objectArray[1], false);
                            this.getCaretModel().setViewPosition(new CaretPosition(Math.min(((CaretPosition)objectArray[0]).line, ((CaretPosition)objectArray[1]).line), Math.max(((CaretPosition)objectArray[0]).column, ((CaretPosition)objectArray[1]).column)));
                        }
                        break block41;
                    }
                    finally {
                        this.setVirtualSpaceAllowed(bl);
                    }
                }
                if (this.getSelectionModel().hasSelection()) {
                    n2 = this.getCaretModel().getOffset();
                    if (this.getSelectionStart() > n2 || this.getSelectionEnd() < n2) {
                        this.getSelectionModel().clearSelection();
                    }
                }
                if (this.isIndentOnPasting()) {
                    int n8;
                    StringBuffer stringBuffer3;
                    String string2;
                    int n9;
                    n2 = 1;
                    int n10 = this.getSelectionStart();
                    if (n10 > (n9 = this.getLineStartOffset(this.getLineNumber(n10)))) {
                        string2 = this.getText(n9, n10 - n9);
                        for (int i4 = 0; i4 < string2.length(); ++i4) {
                            char c2 = string2.charAt(i4);
                            if (c2 == ' ' || c2 == '\t') continue;
                            n2 = 0;
                            break;
                        }
                    }
                    string2 = stringBuffer2.toString();
                    String[] stringArray = string2.split(TextUtils.getLineBreak(n4 == 2 ? 1 : n4));
                    String string3 = "";
                    int n11 = -1;
                    if (!this.getSelectionModel().hasSelection() && n2 != 0) {
                        CaretPosition caretPosition = this.getCaretModel().getModelPosition();
                        n11 = this.getLineEndOffset(caretPosition.line);
                        CaretPosition caretPosition3 = this.offsetToModelPosition(n11);
                        if (caretPosition.column > caretPosition3.column) {
                            string3 = TextUtils.createWhiteSpace(caretPosition.column - caretPosition3.column, this.getTabSize(), this.isReplaceTabWithSpace(), caretPosition3.column);
                        } else {
                            n11 = this.getCaretModel().getOffset();
                        }
                    }
                    int n12 = this.getSelectionModel().hasSelection() ? this.getSelectionStartLine() : this.getCaretModel().getModelPosition().line;
                    int n13 = n12 - 1;
                    String string4 = "";
                    if (n13 >= 0 && n13 < this.getLineCount()) {
                        int n14;
                        for (n14 = n13; n14 >= 0 && this.\u0101(this.getLineText(n14)); --n14) {
                        }
                        if (n14 >= 0) {
                            string4 = TextUtils.getLeadingWhitespace(this.getLineText(n14));
                        }
                    }
                    String string5 = "";
                    if (stringArray.length >= 1) {
                        string5 = TextUtils.getLeadingWhitespace(stringArray[0]);
                    }
                    String string6 = "";
                    if (this.isReplaceTabWithSpace()) {
                        stringBuffer3 = new StringBuffer();
                        for (n8 = 0; n8 < this.getTabSize(); ++n8) {
                            stringBuffer3.append(" ");
                        }
                        string6 = stringBuffer3.toString();
                        string5 = string5.replaceAll("\t", string6);
                        string4 = string4.replaceAll("\t", string6);
                    }
                    if (stringArray.length > 1) {
                        String string7;
                        if (string4.length() != 0 || string5.length() != 0) {
                            for (int i5 = 1; i5 < stringArray.length; ++i5) {
                                String string8 = TextUtils.getLeadingWhitespace(stringArray[i5]);
                                if (this.isReplaceTabWithSpace()) {
                                    string8 = string8.replaceAll("\t", string6);
                                    stringArray[i5] = stringArray[i5].replaceAll("\t", string6);
                                }
                                if (string8.startsWith(string5)) {
                                    stringArray[i5] = string4 + stringArray[i5].substring(string5.length());
                                    continue;
                                }
                                if (!string5.startsWith(string8)) continue;
                                string7 = string5.substring(string8.length());
                                if (string4.startsWith(string7)) {
                                    stringArray[i5] = string4.substring(string7.length()) + stringArray[i5].substring(string8.length());
                                    continue;
                                }
                                if (!string7.startsWith(string4)) continue;
                                stringArray[i5] = stringArray[i5].substring(string8.length());
                            }
                        }
                        stringBuffer3 = new StringBuffer();
                        for (n8 = 0; n8 < stringArray.length; ++n8) {
                            string7 = stringArray[n8];
                            stringBuffer3.append(string7);
                            if (n8 == stringArray.length - 1) continue;
                            stringBuffer3.append(this.\u0119());
                        }
                        if (string2.endsWith("\r") || string2.endsWith("\n")) {
                            stringBuffer3.append(this.\u0119());
                        }
                        string2 = stringBuffer3.toString();
                    } else if (stringArray.length == 1 && !string.endsWith(TextUtils.getLineBreak(1))) {
                        string2 = stringArray[0];
                    }
                    if (n2 != 0) {
                        if (string3.length() == 0 || string2.startsWith(string3)) {
                            string2 = string2.substring(string3.length());
                            this.setSelectedText(string2);
                        } else {
                            this.setSelectedText(string2);
                            int n15 = this.getCaretModel().getOffset();
                            this._document.remove(n9, string3.length() + (n11 - n9));
                            this.getCaretModel().setOffset(n15 - string3.length() - (n11 - n9));
                        }
                    } else {
                        this.setSelectedText(string2);
                    }
                } else {
                    this.setSelectedText(stringBuffer2.toString());
                }
            }
            catch (BadLocationException badLocationException) {
                PortingUtils.notifyUser();
                \u0184.warning(badLocationException.getLocalizedMessage());
            }
        }
    }

    private boolean \u0101(String string) {
        char[] cArray;
        for (char c2 : cArray = string.toCharArray()) {
            if (c2 == ' ' || c2 == '\t' || c2 == 'r' || c2 == '\n' || c2 == '\r') continue;
            return false;
        }
        return true;
    }

    private CaretPosition[] \u0101(String[] stringArray, int n2) {
        int n3;
        if (stringArray == null || stringArray.length < 1) {
            return new CaretPosition[]{this.getSelectionModel().getSelectionStartViewPosition(), this.getSelectionModel().getSelectionEndViewPosition()};
        }
        CaretPosition caretPosition = this.getCaretModel().getViewPosition();
        CaretPosition[] caretPositionArray = new CaretPosition[2];
        boolean bl = true;
        int n4 = this.getCaretModel().getOffset();
        block0: while (bl) {
            bl = false;
            this.getCaretModel().moveCaret(stringArray[0].length(), Math.min(stringArray.length, this.getLineCount() - n2 + 1), false, false, false);
            n3 = this.getCaretModel().getOffset();
            com.jidesoft.editor.E e2 = new com.jidesoft.editor.E(this, n4);
            do {
                if (e2.\u0102() != null) {
                    this.getFoldingModel().expandFoldingSpan(e2.\u0102());
                    bl = true;
                    continue block0;
                }
                e2.\u0103();
            } while (e2.\u0101() < n3);
        }
        n3 = n2 + stringArray.length - this.getLineCount();
        if (n3 > 0) {
            this.getCaretModel().setModelPosition(new CaretPosition(this.getLineCount() - 1, 0));
            this.getSelectionModel().setColumnSelectionMode(false);
            for (int i2 = 0; i2 <= n3; ++i2) {
                this.startNewLine();
            }
            this.getSelectionModel().setColumnSelectionMode(true);
        }
        for (int i3 = n2 + stringArray.length - 1; i3 >= n2; --i3) {
            Comparable<StringBuffer> comparable;
            if (i3 >= this.getLineCount()) continue;
            String string = stringArray[i3 - n2];
            this.getCaretModel().setViewPosition(caretPosition);
            this.getCaretModel().moveCaret(0, i3 - n2, false, false, false);
            if (this.getLineEndOffsetExcludeLineBreak(i3) < this.getCaretModel().getModelPosition().column) {
                if (this.\u0101(string)) continue;
                comparable = new StringBuffer();
                for (int i4 = 0; i4 < this.getCaretModel().getModelPosition().column - this.getLineEndOffsetExcludeLineBreak(i3); ++i4) {
                    ((StringBuffer)comparable).append(' ');
                }
                string = ((StringBuffer)comparable).toString() + string;
                this.getCaretModel().setModelPosition(new CaretPosition(i3, this.getLineEndOffsetExcludeLineBreak(i3)));
            }
            com.jidesoft.editor.A.\u0101(this, string, false, false);
            comparable = this.getCaretModel().getViewPosition();
            if (caretPositionArray[1] == null) {
                caretPositionArray[1] = comparable;
            }
            caretPositionArray[0] = comparable;
        }
        if (caretPositionArray[0] != null && caretPositionArray[1] != null) {
            this.getCaretModel().setViewPosition(new CaretPosition(Math.min(caretPositionArray[0].line, caretPositionArray[1].line), Math.max(caretPositionArray[0].column, caretPositionArray[1].column)));
        }
        return caretPositionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pasteWithDialog() {
        Transferable transferable3;
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        Window window = JideSwingUtilities.getWindowForComponent(this);
        ArrayList<Transferable> arrayList = new ArrayList<Transferable>();
        Transferable transferable2 = this.getToolkit().getSystemClipboard().getContents(this);
        Object object = null;
        try {
            object = transferable2.getTransferData(DataFlavor.stringFlavor);
            if (_clipboards == null || _clipboards.size() < 1) {
                arrayList.add(transferable2);
            } else {
                arrayList.addAll(_clipboards);
                if (object != null) {
                    boolean bl = true;
                    for (Transferable transferable3 : _clipboards) {
                        if (transferable3 == null || !object.equals(transferable3.getTransferData(DataFlavor.stringFlavor))) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        arrayList.add(transferable2);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ClipboardsDialog clipboardsDialog = window instanceof Frame ? new ClipboardsDialog((Frame)window, this.getResourceString("Clipboard.pasteDialogTitle"), arrayList, this._painter.getFont()) : new ClipboardsDialog((Dialog)window, this.getResourceString("Clipboard.pasteDialogTitle"), arrayList, this._painter.getFont());
        this.customizeDialogData(clipboardsDialog);
        clipboardsDialog.pack();
        clipboardsDialog.setLocationRelativeTo(this);
        if (this.\u0158 != null) {
            clipboardsDialog.setBounds(this.\u0158);
        } else if (clipboardsDialog.getPreferredSize().width >= 500) {
            clipboardsDialog.setSize(500, clipboardsDialog.getPreferredSize().height);
        }
        clipboardsDialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (componentEvent.getSource() instanceof ClipboardsDialog) {
                    CodeEditor.this.\u0158 = ((ClipboardsDialog)componentEvent.getSource()).getBounds();
                }
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                if (componentEvent.getSource() instanceof ClipboardsDialog) {
                    CodeEditor.this.\u0158 = ((ClipboardsDialog)componentEvent.getSource()).getBounds();
                }
            }
        });
        this.customizeDialog(clipboardsDialog);
        clipboardsDialog.setVisible(true);
        int n2 = clipboardsDialog.getDialogResult();
        if (n2 == 0 && (transferable3 = clipboardsDialog.getSelectedClipboard()) != null) {
            if (transferable3 != transferable2) {
                _clipboards.remove(transferable3);
                _clipboards.add(0, transferable3);
            }
            this._document.beginCompoundEdit();
            try {
                this.\u017d = true;
                this.\u0101(transferable3);
            }
            finally {
                this.\u017d = false;
                this._document.endCompoundEdit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lineComments() {
        block20: {
            if (!this.isEditable() || !this.isEnabled()) {
                PortingUtils.notifyUser();
                return;
            }
            try {
                int n2;
                int n3;
                this._document.beginCompoundEdit();
                String string = (String)this._document.getProperty("lineComment");
                if (string == null) {
                    return;
                }
                if (!this.getSelectionModel().hasSelection()) {
                    int n4 = this.getCaretModel().getModelPosition().line;
                    int n5 = this.getLineStartOffset(n4);
                    if (!this.isSkipsEmptyLinesOnLineComments() || !this.\u0108(n4)) {
                        int n6 = this.\u0101(n4, string);
                        try {
                            if (n6 != -1) {
                                this._document.remove(n5 + n6, string.length());
                            } else {
                                this._document.insertString(n5, string, null);
                                this.getCaretModel().setOffset(n5);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            \u0184.warning(badLocationException.getLocalizedMessage());
                        }
                    }
                    this.getCaretModel().moveCaret(0, 1, false, true, this.\u017d || this.getAutoscrolls());
                    break block20;
                }
                int n7 = this.getSelectionStartLine();
                int n8 = this.getSelectionEndLine();
                try {
                    String string2 = this._document.getText(this.getSelectionEnd() - 1, 1);
                    if ((string2.equals("\n") || string2.equals("\r")) && n7 != n8) {
                        --n8;
                    }
                }
                catch (BadLocationException badLocationException) {
                    \u0184.warning(badLocationException.getLocalizedMessage());
                }
                boolean bl = true;
                for (n3 = n8; n3 >= n7; --n3) {
                    n2 = this.\u0101(n3, string);
                    if (n2 != -1 || this.isSkipsEmptyLinesOnLineComments() && this.\u0108(n3)) continue;
                    bl = false;
                    break;
                }
                for (n3 = n8; n3 >= n7; --n3) {
                    n2 = this.getLineStartOffset(n3);
                    if (this.isSkipsEmptyLinesOnLineComments() && this.\u0108(n3)) continue;
                    int n9 = bl ? this.\u0101(n3, string) : -1;
                    try {
                        if (n9 != -1) {
                            this._document.remove(n2 + n9, string.length());
                            continue;
                        }
                        this._document.insertString(n2, string, null);
                        continue;
                    }
                    catch (BadLocationException badLocationException) {
                        \u0184.warning(badLocationException.getLocalizedMessage());
                    }
                }
            }
            finally {
                this._document.endCompoundEdit();
            }
        }
    }

    private boolean \u0108(int n2) {
        String string = this.getLineText(n2);
        return string == null || string.trim().length() == 0;
    }

    private int \u0101(int n2, String string) {
        String string2 = this.getLineText(n2);
        return this.\u0101(string2, string);
    }

    private int \u0101(String string, String string2) {
        String string3 = TextUtils.getLeadingWhitespace(string);
        boolean bl = string.length() >= string3.length() + string2.length() && string2.equals(string.substring(string3.length(), string3.length() + string2.length()));
        return bl ? string3.length() : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockComments() {
        block19: {
            if (!this.isEditable() || !this.isEnabled()) {
                PortingUtils.notifyUser();
                return;
            }
            try {
                int n2;
                this._document.beginCompoundEdit();
                String string = (String)this._document.getProperty("blockCommentStart");
                String string2 = (String)this._document.getProperty("blockCommentEnd");
                if (string == null || string2 == null) {
                    return;
                }
                if (!this.getSelectionModel().hasSelection()) {
                    int n3 = this.getCaretModel().getOffset();
                    try {
                        this._document.insertString(n3, string + string2, null);
                    }
                    catch (BadLocationException badLocationException) {
                        \u0184.warning(badLocationException.getLocalizedMessage());
                    }
                    break block19;
                }
                int n4 = this.getSelectionStart();
                int n5 = this.getSelectionEnd();
                if (n5 > (n2 = this._document.getLength())) {
                    n5 = n2;
                }
                int n6 = Math.max(string.length(), string2.length());
                try {
                    String[] stringArray = new String[]{string, string2};
                    if (string.equals(this._document.getText(n4, string.length())) && string2.equals(this._document.getText(n5 - string2.length(), string2.length()))) {
                        int n7 = this._document.findPrevious(stringArray, n5, n4, true, false);
                        while (n7 >= 0) {
                            if (this._document.getText(n7, n6).startsWith(string)) {
                                this._document.remove(n7, string.length());
                            } else {
                                this._document.remove(n7, string2.length());
                            }
                            n7 = this._document.findPrevious(stringArray, n7, n4, true, false);
                        }
                        break block19;
                    }
                    this._document.insertString(n5, string2, null);
                    int n8 = this._document.findPrevious(stringArray, n5, n4, true, false);
                    while (n8 >= 0) {
                        if (this._document.getText(n8, n6).startsWith(string)) {
                            this._document.insertString(n8, string2, null);
                        } else {
                            this._document.insertString(n8 + string2.length(), string, null);
                        }
                        n8 = this._document.findPrevious(stringArray, n8, n4, true, false);
                    }
                    this._document.insertString(n4, string, null);
                }
                catch (BadLocationException badLocationException) {
                    \u0184.warning(badLocationException.getLocalizedMessage());
                }
            }
            finally {
                this._document.endCompoundEdit();
            }
        }
    }

    private FoldingSpanListener \u011e() {
        if (this.\u0181 == null) {
            this.\u0181 = new FoldingSpanListener(){

                @Override
                public void foldingSpanChanged(FoldingSpanEvent foldingSpanEvent) {
                    if (!foldingSpanEvent.isAdjusting()) {
                        CodeEditor.this.getCaretModel().updateViewPosition();
                        CodeEditor.this._painter.invalidateLineRange(CodeEditor.this.getFirstLine(), CodeEditor.this.getFirstLine() + CodeEditor.this.getVisibleLines());
                        CodeEditor.this.\u016d.\u0101();
                        CodeEditor.this.updateScrollBars();
                    }
                    if (foldingSpanEvent.getType() == 3 && CodeEditor.this.\u0157 != null && CodeEditor.this.\u0157.contains(foldingSpanEvent.getFoldingSpan())) {
                        CodeEditor.this.\u0157.remove(foldingSpanEvent.getFoldingSpan());
                        CodeEditor.this.getFoldingModel().removeFoldingSpan(foldingSpanEvent.getFoldingSpan());
                    }
                }
            };
        }
        return this.\u0181;
    }

    public FoldingModel getFoldingModel() {
        if (this.\u0163 == null) {
            this.\u0163 = new DefaultFoldingModel(this);
            this.\u0163.setEnabled(true);
            this.\u0163.addFoldingSpanListener(this.\u011e());
        }
        return this.\u0163;
    }

    public void setFoldingModel(FoldingModel foldingModel) {
        if (this.\u0163 != foldingModel) {
            if (this.\u0163 != null) {
                this.\u0163.removeFoldingSpanListener(this.\u011e());
            }
            this.\u0163 = foldingModel;
            if (this.\u0163 != null) {
                this.\u0163.addFoldingSpanListener(this.\u011e());
            }
        }
    }

    public void expandFolding() {
        FoldingModel foldingModel = this.getFoldingModel();
        if (foldingModel.isEnabled()) {
            CaretPosition caretPosition = this.getCaretModel().getViewPosition();
            FoldingSpan foldingSpan = ((DefaultFoldingModel)foldingModel).getOutermostSpanAtViewPosition(caretPosition);
            if (foldingSpan != null) {
                CaretPosition caretPosition2 = this.offsetToViewPosition(foldingSpan.getStartOffset());
                if (caretPosition2.line != caretPosition.line || caretPosition.column < caretPosition2.column || caretPosition.column >= caretPosition2.column + com.jidesoft.editor.A.\u0101(foldingSpan)) {
                    foldingSpan = null;
                }
            }
            if (foldingSpan != null && !foldingSpan.isExpanded()) {
                foldingSpan.setExpanded(true);
            } else {
                int n2 = this.getCaretModel().getOffset();
                FoldingSpan[] foldingSpanArray = DefaultFoldingModel.getFoldingSpanAtOffset(this, n2);
                for (int i2 = foldingSpanArray.length - 1; i2 >= 0; --i2) {
                    FoldingSpan foldingSpan2 = foldingSpanArray[i2];
                    if (foldingSpan2.isExpanded() || foldingSpan2.getStartOffset() >= n2) continue;
                    foldingSpan2.setExpanded(true);
                    break;
                }
            }
        }
    }

    public void collapseFolding() {
        FoldingModel foldingModel = this.getFoldingModel();
        if (foldingModel.isEnabled()) {
            int n2 = this.getCaretModel().getModelPosition().line;
            FoldingSpan foldingSpan = DefaultFoldingModel.findFoldingSpanStartingAtLine(this, n2);
            if (foldingSpan != null && foldingSpan.isExpanded()) {
                foldingSpan.setExpanded(false);
            } else {
                int n3 = this.getCaretModel().getOffset();
                FoldingSpan[] foldingSpanArray = DefaultFoldingModel.getFoldingSpanAtOffset(this, n3);
                for (int i2 = 0; i2 < foldingSpanArray.length; ++i2) {
                    FoldingSpan foldingSpan2 = foldingSpanArray[i2];
                    if (!foldingSpan2.isExpanded()) continue;
                    foldingSpan2.setExpanded(false);
                    break;
                }
            }
        }
    }

    public void expandAll() {
        FoldingModel foldingModel = this.getFoldingModel();
        foldingModel.expandAll();
        if (this.\u017d || this.getAutoscrolls()) {
            this.scrollToCaret();
        }
    }

    public void collapseAll() {
        FoldingModel foldingModel = this.getFoldingModel();
        foldingModel.collapseAll();
        if (this.\u017d || this.getAutoscrolls()) {
            this.scrollToCaret();
        }
    }

    public void toggleFoldingSelection() {
        int n2 = this.getSelectionStart();
        int n3 = this.getSelectionEnd();
        try {
            if (n2 < n3 && "\n".equals(this.getDocument().getText(n3 - 1, 1))) {
                --n3;
            }
        }
        catch (BadLocationException badLocationException) {
            \u0184.warning(badLocationException.getLocalizedMessage());
        }
        if (n2 != n3 && !((DefaultFoldingModel)this.getFoldingModel()).hasAnySpan(n2, n3)) {
            FoldingSpan foldingSpan = this.getFoldingModel().addFoldingSpan(n2, n3, "...");
            if (this.\u0157 == null) {
                this.\u0157 = new ArrayList<FoldingSpan>();
            }
            this.\u0157.add(foldingSpan);
            foldingSpan.setExpanded(false);
            int n4 = Math.min(n2 + "...".length(), this.getDocumentLength());
            this.getCaretModel().setOffset(n4);
        } else {
            FoldingSpan foldingSpan = ((DefaultFoldingModel)this.getFoldingModel()).getOutermostSpanAtOffset(n2);
            if (foldingSpan != null) {
                this.getFoldingModel().removeFoldingSpan(foldingSpan);
            }
            if (n2 != n3 && (foldingSpan = ((DefaultFoldingModel)this.getFoldingModel()).getOutermostSpanAtOffset(n3)) != null) {
                this.getFoldingModel().removeFoldingSpan(foldingSpan);
            }
        }
    }

    public int modelToViewLine(int n2) {
        return this.modelToViewPosition((CaretPosition)new CaretPosition((int)n2, (int)0)).line;
    }

    public int viewToModelLine(int n2) {
        return this.viewToModelPosition((CaretPosition)new CaretPosition((int)n2, (int)0)).line;
    }

    @Override
    public void repaint() {
        super.repaint();
        if (this.getMarkerArea() != null) {
            this.getMarkerArea().repaint();
        }
    }

    @Override
    public void repaint(long l2) {
        super.repaint(l2);
        if (this.getMarkerArea() != null) {
            this.getMarkerArea().repaint(l2);
        }
    }

    public Dimension getContentSize() {
        return this.recalculateContentSize();
    }

    protected Dimension recalculateContentSize() {
        Dimension dimension = this.\u016d.\u0102();
        return new Dimension(dimension.width, dimension.height + 10 * this.getLineHeight());
    }

    protected void resetContentSize() {
        if (this.\u016d != null) {
            this.\u016d.\u0101();
        }
    }

    @Override
    public void configureStyledLabel(StyledLabel styledLabel, Object object) {
        styledLabel.clearStyleRanges();
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof FindResult) {
            FindResult findResult = (FindResult)object;
            String string = findResult.getStyledText();
            if (string == null) {
                CaretPosition caretPosition = this.offsetToModelPosition(findResult.getStart());
                stringBuffer.append("{(").append(caretPosition.line + 1).append(", ").append(caretPosition.column + 1).append(") :italic, f:gray}");
                stringBuffer.append(" ");
                int n2 = this.getLineStartOffset(caretPosition.line);
                int n3 = findResult.getStart() - n2;
                int n4 = findResult.getEnd() - findResult.getStart();
                String string2 = this.getText(n2, this.getLineEndOffsetExcludeLineBreak(caretPosition.line));
                if (string2.length() >= n3 + n4) {
                    stringBuffer.append(StyledLabelBuilder.parseToVoidStyledTextConfusion(string2.substring(0, n3)));
                    String string3 = string2.substring(n3, n3 + n4);
                    string3 = string3.replaceAll("\\:", "\\\\:");
                    stringBuffer.append("{").append(string3);
                    if (stringBuffer.charAt(stringBuffer.length() - 1) == '\\') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(":bold}");
                    stringBuffer.append(StyledLabelBuilder.parseToVoidStyledTextConfusion(string2.substring(n3 + n4)));
                } else {
                    stringBuffer.append(string2);
                }
                string = stringBuffer.toString();
            }
            StyledLabelBuilder.setStyledText(styledLabel, string);
            findResult.setStyledText(string);
        } else if (object instanceof FindResults) {
            FindResults findResults = (FindResults)object;
            stringBuffer.append(findResults.getName());
            int n5 = stringBuffer.length();
            int n6 = findResults.getNumberOfFindResults();
            stringBuffer.append(" (");
            if (n6 > 1) {
                stringBuffer.append(n6).append(" ").append(this.getResourceString("FindAndReplace.usages"));
            } else if (n6 == 1) {
                stringBuffer.append(n6).append(" ").append(this.getResourceString("FindAndReplace.usage"));
            } else if (n6 == 0) {
                stringBuffer.append(this.getResourceString("FindAndReplace.noUsages"));
            }
            stringBuffer.append(")");
            styledLabel.setText(stringBuffer.toString());
            styledLabel.addStyleRange(new StyleRange(n5, stringBuffer.length() - n5, 2, Color.GRAY));
        } else {
            stringBuffer.append(object);
        }
    }

    private ResourceBundle \u011a() {
        return CodeEditorResource.getResourceBundle(this.getLocale());
    }

    public String getResourceString(String string) {
        if (string != null && string.startsWith("FindAndReplace")) {
            return FindAndReplaceResource.getResourceBundle(this.getLocale()).getString(string);
        }
        return this.\u011a().getString(string);
    }

    public Rectangle modelToView(int n2) throws BadLocationException {
        int n3 = this.offsetToViewPosition((int)n2).line;
        int n4 = this.offsetToX(n2);
        int n5 = this.lineToY(n3);
        return new Rectangle(n4, n5 += this.getPainter().getFontMetrics().getLeading() + this.getPainter().getFontMetrics().getMaxDescent(), this._painter.getFontMetrics().charWidth('w'), this.getLineHeight());
    }

    public Rectangle modelToView(int n2, int n3) throws BadLocationException, IllegalArgumentException {
        int n4 = this.offsetToViewPosition((int)n2).line;
        int n5 = this.offsetToViewPosition((int)n3).line;
        int n6 = this.offsetToX(n2);
        int n7 = this.offsetToX(n3);
        if (n4 != n5 && n6 != n7) {
            throw new IllegalArgumentException("The start and end offset must be one the same visible line");
        }
        int n8 = this.lineToY(n4);
        n8 += this.getPainter().getFontMetrics().getLeading() + this.getPainter().getFontMetrics().getMaxDescent();
        if (n7 == n6 || this.getLineStartOffset(this.getLineNumber(n2)) == n2 && n3 == this.getDocumentLength()) {
            return new Rectangle(0, n8, this.getPainter().getWidth(), this.getLineHeight());
        }
        return new Rectangle(n6, n8, n7 - n6, this.getLineHeight());
    }

    public Highlighter getHighlighter() {
        return this.\u0185;
    }

    public void setHighlighter(Highlighter highlighter) {
        if (this.\u0185 != null) {
            this.\u0185.deinstall(this);
        }
        Highlighter highlighter2 = this.\u0185;
        this.\u0185 = highlighter;
        if (this.\u0185 != null) {
            this.\u0185.install(this);
        }
        this.firePropertyChange("highlighter", highlighter2, highlighter);
    }

    public Highlighter getFixedHighlighter() {
        return this.\u017c;
    }

    public void setFixedHighlighter(Highlighter highlighter) {
        if (this.\u017c != null) {
            this.\u017c.deinstall(this);
        }
        Highlighter highlighter2 = this.\u017c;
        this.\u017c = highlighter;
        if (this.\u017c != null) {
            this.\u017c.install(this);
        }
        this.firePropertyChange("fixedHighlighter", highlighter2, highlighter);
    }

    protected Highlighter createHighlighter() {
        return new DefaultUIResourceHighlighter();
    }

    public ColumnGuide[] getColumnGuides() {
        List<ColumnGuide> list = this.internalGetColumnGuides();
        return list.toArray(new ColumnGuide[list.size()]);
    }

    protected List<ColumnGuide> internalGetColumnGuides() {
        if (this.\u0179 == null) {
            this.\u0179 = new ArrayList<ColumnGuide>();
        }
        return this.\u0179;
    }

    public void addColumnGuide(ColumnGuide columnGuide) {
        this.internalGetColumnGuides().add(columnGuide);
        this.getPainter().repaint();
    }

    public void removeColumnGuide(ColumnGuide columnGuide) {
        this.internalGetColumnGuides().remove(columnGuide);
        this.getPainter().repaint();
    }

    public void removeAllColumnGuides() {
        this.internalGetColumnGuides().clear();
        this.getPainter().repaint();
    }

    public void escape() {
        if (this.getSelectionModel().hasSelection()) {
            this.getSelectionModel().clearSelection();
        } else if (this.getHighlighter() != null) {
            this.getHighlighter().removeAllHighlights();
        }
    }

    public void loadActionMap() {
        ActionMap actionMap = this.getActionMap();
        class ActionDelegate
        extends AbstractAction {
            private Action \u0102;
            private static final long \u0103 = 7860792901523776985L;

            ActionDelegate(Action action) {
                this.\u0102 = action;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.\u0102.actionPerformed(actionEvent);
            }
        }
        actionMap.put("copy", new ActionDelegate(InputHandler.CLIP_COPY));
        actionMap.put("cut", new ActionDelegate(InputHandler.CLIP_CUT));
        actionMap.put("paste", new ActionDelegate(InputHandler.CLIP_PASTE));
        actionMap.put("delete", new ActionDelegate(InputHandler.DELETE));
        actionMap.put("redo", new ActionDelegate(InputHandler.REDO));
        actionMap.put("undo", new ActionDelegate(InputHandler.UNDO));
        actionMap.put("selectAll", new ActionDelegate(InputHandler.SELECT_ALL));
    }

    private Action \u0104(String string) {
        ActionMap actionMap = this.getActionMap();
        return actionMap.get(string);
    }

    public void setCaretPosition(int n2) {
        this.getCaretModel().setOffset(n2);
    }

    public int getCaretPosition() {
        return this.getCaretModel().getOffset();
    }

    public JScrollBar getVerticalScrollBar() {
        return this._verticalScrollBar;
    }

    public JScrollBar getHorizontalScrollBar() {
        return this._horizontalScrollBar;
    }

    public int getCorrespondingColumn(int n2, int n3, int n4) {
        int n5 = n2;
        int n6 = n4 - n3;
        if (n6 != 0) {
            int n7;
            int n8;
            int n9;
            String string = null;
            if (n3 < this.getLineCount()) {
                string = this.getLineText(n3);
            }
            if (string != null) {
                n9 = 0;
                for (n8 = 0; n8 < string.length() && n8 < n2; ++n8) {
                    int n10 = n7 = string.charAt(n8) == '\t' ? 1 : 0;
                    if (n7 != 0) {
                        n5 += this.getTabSize() - n9 % this.getTabSize() - 1;
                        n9 = 0;
                        continue;
                    }
                    ++n9;
                }
            }
            if (n4 < this.getLineCount()) {
                string = this.getLineText(n4);
            }
            if (string != null) {
                n8 = 0;
                n9 = 0;
                int n11 = 0;
                for (n7 = 0; n7 < string.length() && n9 < n5; ++n7) {
                    int n12;
                    int n13 = n12 = string.charAt(n7) == '\t' ? 1 : 0;
                    if (n12 != 0) {
                        n9 = n8 == 0 ? (n9 += this.getTabSize() - n11 % this.getTabSize()) : (n9 += this.getTabSize());
                        n11 = 0;
                    } else {
                        ++n9;
                        ++n11;
                    }
                    n8 = n12;
                }
                if (n9 < n5) {
                    n7 += n5 - n9;
                }
                return n7;
            }
        }
        return n5;
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        if (this.\u0156 == null) {
            this.\u0156 = new com.jidesoft.editor.I(this);
        }
        return new D(this.\u0156);
    }

    public void setOverlayVisible(boolean bl) {
        Overlayable overlayable = OverlayableUtils.getOverlayable(this);
        if (overlayable != null) {
            JComponent[] jComponentArray;
            for (JComponent jComponent : jComponentArray = overlayable.getOverlayComponents()) {
                if (!(jComponent instanceof InfiniteProgressPanel)) continue;
                if (bl) {
                    ((InfiniteProgressPanel)jComponent).start();
                    continue;
                }
                ((InfiniteProgressPanel)jComponent).stop();
            }
        }
    }

    public JComponent createOverlay() {
        DefaultOverlayable defaultOverlayable = new DefaultOverlayable(this);
        InfiniteProgressPanel infiniteProgressPanel = new InfiniteProgressPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(20, 20);
            }
        };
        defaultOverlayable.addOverlayComponent(infiniteProgressPanel);
        infiniteProgressPanel.stop();
        defaultOverlayable.setOverlayVisible(false);
        return defaultOverlayable;
    }

    @Override
    public void repaint(long l2, int n2, int n3, int n4, int n5) {
        super.repaint(l2, n2, n3, n4, n5);
        OverlayableUtils.repaintOverlayable(this);
    }

    void \u0101(String string, FoldingSpan foldingSpan) {
        if (\u0184.isLoggable(Level.FINE)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append("\r\n");
            if (foldingSpan != null) {
                String string2 = this.getText(foldingSpan.getEndOffset() - 1, 2);
                stringBuffer.append("span is ( ").append(foldingSpan.getStartOffset()).append(", ").append(foldingSpan.getEndOffset()).append(").").append(string2.length() == 2 && string2.charAt(0) == '\r' && string2.charAt(1) == '\n').append("\r\n");
            }
            stringBuffer.append("Folding Model is:\r\n");
            stringBuffer.append(this.getFoldingModel());
            \u0184.fine(stringBuffer.toString());
        }
    }

    protected void customizeDialog(StandardDialog standardDialog) {
    }

    protected void customizeDialogData(StandardDialog standardDialog) {
    }

    public static void clearClipboards() {
        _clipboards.clear();
    }

    public boolean isAdjustColumnSelectionOnMouseEvent() {
        return this.\u0182;
    }

    public void setAdjustColumnSelectionOnMouseEvent(boolean bl) {
        this.\u0182 = bl;
    }

    public void dispose() {
        if (this.getMarkerArea() != null) {
            this.getMarkerArea().dispose();
        }
        if (this.\u0156 instanceof com.jidesoft.editor.I) {
            this.removeInputMethodListener((com.jidesoft.editor.I)this.\u0156);
        }
        this.setDocument(null);
    }

    public boolean isAutoIndent() {
        return this.\u0172;
    }

    public void setAutoIndent(boolean bl) {
        this.\u0172 = bl;
    }

    protected boolean isIntegerScaleFactor() {
        Graphics2D graphics2D = (Graphics2D)this._painter.getGraphics();
        return graphics2D == null || JideSwingUtilities.isIntegerScaleFactor(graphics2D);
    }

    protected int getFractionalOffsetToX(int n2) {
        Token token;
        Serializable serializable;
        TokenMarker tokenMarker = this.getTokenMarker();
        int n3 = this.getLineNumber(n2);
        if (n3 < 0 || n3 >= this.getLineCount()) {
            return this._horizontalOffset;
        }
        if (n2 == 0 && n3 == 0 || !this.getLineText(n3, this.lineSegment)) {
            return this._horizontalOffset;
        }
        int n4 = n2 - this.getLineStartOffset(n3);
        int n5 = this.lineSegment.offset;
        int n6 = this._horizontalOffset;
        if (tokenMarker != null) {
            serializable = this._painter;
            if (((CodeEditorPainter)serializable).getCurrentLineIndex() == n3 && ((CodeEditorPainter)serializable).getCurrentLineTokens() != null) {
                token = ((CodeEditorPainter)serializable).getCurrentLineTokens();
            } else {
                ((CodeEditorPainter)serializable).setCurrentLineIndex(n3);
                token = tokenMarker.markTokens(this.lineSegment, n3);
                ((CodeEditorPainter)serializable).setCurrentLineTokens(token);
            }
        } else {
            token = new Token(this.lineSegment.count, 0);
        }
        serializable = this._painter.getFont();
        SyntaxStyleSchema syntaxStyleSchema = this.getStyles();
        byte by;
        while ((by = token.id) != 127) {
            FontMetrics fontMetrics;
            SyntaxStyle syntaxStyle = syntaxStyleSchema.getStyle(by);
            Graphics2D graphics2D = (Graphics2D)this._painter.getGraphics();
            if (graphics2D == null) {
                fontMetrics = this._painter.getFontMetrics();
            } else {
                if (syntaxStyle == null || by == 0 && syntaxStyle.getForeground() == null) {
                    if (!((Font)serializable).equals(graphics2D.getFont())) {
                        graphics2D.setFont((Font)serializable);
                    }
                } else {
                    syntaxStyle.setGraphicsFlags(graphics2D, (Font)serializable);
                }
                fontMetrics = graphics2D.getFontMetrics();
            }
            int n7 = token.length;
            if (n4 + n5 < this.lineSegment.offset + n7) {
                this.lineSegment.count = n4 - (this.lineSegment.offset - n5);
                return n6 + this.\u0101(this.lineSegment, fontMetrics, graphics2D);
            }
            this.lineSegment.count = n7;
            n6 += this.\u0101(this.lineSegment, fontMetrics, graphics2D);
            this.lineSegment.offset += n7;
            token = token.next;
        }
        return n6;
    }

    private int \u0101(Segment segment, FontMetrics fontMetrics, Graphics2D graphics2D) {
        if (segment.count <= 0) {
            return 0;
        }
        String string = segment.toString();
        double d2 = JideSwingUtilities.getScaleFactor(graphics2D);
        double d3 = (double)fontMetrics.stringWidth(" ") * d2;
        double d4 = Math.ceil(d3) - d3;
        double d5 = d4 / d2;
        int n2 = fontMetrics.stringWidth(string);
        int n3 = StringUtils.countChar(' ', string);
        return (int)Math.round((double)n2 - (double)n3 * d5);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(128)) {
            Lm.showInvalidProductMessage(CodeEditor.class.getName(), 128);
        }
        \u0184 = Logger.getLogger(CodeEditor.class.getName());
        LEFT_OF_SCROLLBAR = "los";
        CENTER = "center";
        RIGHT = "right";
        LEFT = "left";
        BOTTOM = "bottom";
        \u015a = new Insets(1, 1, 1, 1);
    }

    private static class D
    implements InputMethodRequests {
        private final InputMethodRequests \u0101;

        private D(InputMethodRequests inputMethodRequests) {
            this.\u0101 = inputMethodRequests;
        }

        @Override
        public Rectangle getTextLocation(final TextHitInfo textHitInfo) {
            if (EventQueue.isDispatchThread()) {
                return this.\u0101.getTextLocation(textHitInfo);
            }
            final Rectangle[] rectangleArray = new Rectangle[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        rectangleArray[0] = \u0101.getTextLocation(textHitInfo);
                    }
                });
            }
            catch (Exception exception) {
                \u0184.log(Level.SEVERE, exception.getLocalizedMessage());
            }
            return rectangleArray[0];
        }

        @Override
        public TextHitInfo getLocationOffset(final int n2, final int n3) {
            if (EventQueue.isDispatchThread()) {
                return this.\u0101.getLocationOffset(n2, n3);
            }
            final TextHitInfo[] textHitInfoArray = new TextHitInfo[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        textHitInfoArray[0] = \u0101.getLocationOffset(n2, n3);
                    }
                });
            }
            catch (Exception exception) {
                \u0184.log(Level.SEVERE, exception.getLocalizedMessage());
            }
            return textHitInfoArray[0];
        }

        @Override
        public int getInsertPositionOffset() {
            if (EventQueue.isDispatchThread()) {
                return this.\u0101.getInsertPositionOffset();
            }
            final int[] nArray = new int[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        nArray[0] = \u0101.getInsertPositionOffset();
                    }
                });
            }
            catch (Exception exception) {
                \u0184.log(Level.SEVERE, exception.getLocalizedMessage());
            }
            return nArray[0];
        }

        @Override
        public AttributedCharacterIterator getCommittedText(final int n2, final int n3, final AttributedCharacterIterator.Attribute[] attributeArray) {
            if (EventQueue.isDispatchThread()) {
                return n2 <= n3 ? this.\u0101.getCommittedText(n2, n3, attributeArray) : this.\u0101.getCommittedText(n3, n2, attributeArray);
            }
            final AttributedCharacterIterator[] attributedCharacterIteratorArray = new AttributedCharacterIterator[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        attributedCharacterIteratorArray[0] = n2 <= n3 ? \u0101.getCommittedText(n2, n3, attributeArray) : \u0101.getCommittedText(n3, n2, attributeArray);
                    }
                });
            }
            catch (Exception exception) {
                \u0184.log(Level.SEVERE, exception.getLocalizedMessage());
            }
            return attributedCharacterIteratorArray[0];
        }

        @Override
        public int getCommittedTextLength() {
            if (EventQueue.isDispatchThread()) {
                return this.\u0101.getCommittedTextLength();
            }
            final int[] nArray = new int[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        nArray[0] = \u0101.getCommittedTextLength();
                    }
                });
            }
            catch (Exception exception) {
                \u0184.log(Level.SEVERE, exception.getLocalizedMessage());
            }
            return nArray[0];
        }

        @Override
        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
            return null;
        }

        @Override
        public AttributedCharacterIterator getSelectedText(final AttributedCharacterIterator.Attribute[] attributeArray) {
            if (EventQueue.isDispatchThread()) {
                return this.\u0101.getSelectedText(attributeArray);
            }
            final AttributedCharacterIterator[] attributedCharacterIteratorArray = new AttributedCharacterIterator[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        attributedCharacterIteratorArray[0] = \u0101.getSelectedText(attributeArray);
                    }
                });
            }
            catch (Exception exception) {
                \u0184.log(Level.SEVERE, exception.getLocalizedMessage());
            }
            return attributedCharacterIteratorArray[0];
        }
    }

    private class C
    extends DefaultHighlighter.DefaultHighlightPainter {
        public C(Color color) {
            super(color);
        }
    }

    public static class DefaultUIResourceHighlighter
    extends DefaultHighlighter
    implements UIResource {
    }

    private class B {
        private boolean \u0103;
        private Dimension \u0104;
        private com.jidesoft.editor.D \u0105;
        private boolean \u0102;

        private B() {
        }

        public void \u0101() {
            if (CodeEditor.this.getDocument() instanceof LazyLoadDocument) {
                this.\u0103 = true;
                return;
            }
            int n2 = CodeEditor.this.getVisualLineCount();
            this.\u0105 = new com.jidesoft.editor.D(n2 + 300);
            int[] nArray = new int[n2];
            Arrays.fill(nArray, -1);
            this.\u0105.\u0101(nArray);
            this.\u0103 = true;
        }

        public void \u0101(DocumentEvent documentEvent) {
            if (CodeEditor.this.getDocument() instanceof LazyLoadDocument) {
                this.\u0103 = true;
                return;
            }
            int n2 = CodeEditor.this.offsetToViewPosition((int)documentEvent.getOffset()).line;
            this.\u0103 = true;
            DocumentEvent.ElementChange elementChange = documentEvent.getChange(CodeEditor.this.getDocument().getDefaultRootElement());
            int n3 = 0;
            if (elementChange != null && elementChange.getChildrenAdded() != null && elementChange.getChildrenRemoved() != null) {
                n3 = elementChange.getChildrenAdded().length - elementChange.getChildrenRemoved().length;
            }
            boolean bl = false;
            if (n2 < 0) {
                bl = true;
            } else if (n3 > 0) {
                if (n2 >= 0 && n2 < this.\u0105.\u010a()) {
                    this.\u0105.\u0106(n2, -1);
                } else if (n2 + 1 >= this.\u0105.\u010a()) {
                    n2 = this.\u0105.\u010a() - 1;
                }
                int[] nArray = new int[n3];
                Arrays.fill(nArray, -1);
                this.\u0105.\u0102(n2 + 1, nArray);
            } else if (n3 < 0 && n2 - n3 < this.\u0105.\u010a()) {
                if (n2 >= 0 && n2 < this.\u0105.\u010a() - 1) {
                    this.\u0105.\u0106(n2, -1);
                    this.\u0105.\u0108(n2 + 1, -n3);
                } else {
                    bl = true;
                }
            } else if (n3 != 0) {
                bl = true;
            } else if (n2 >= 0 && n2 < this.\u0105.\u010a()) {
                this.\u0105.\u0106(n2, -1);
            } else {
                bl = true;
            }
            if (this.\u0105.\u010a() != CodeEditor.this.getVisualLineCount()) {
                bl = true;
            }
            if (bl) {
                this.\u0101();
            }
            this.\u0103 = true;
        }

        private void \u0103() {
            int n2;
            int n3;
            if (!this.\u0103) {
                return;
            }
            SyntaxDocument syntaxDocument = CodeEditor.this.getDocument();
            if (syntaxDocument instanceof LazyLoadDocument) {
                int n4 = CodeEditor.this._painter.getFontMetrics().charWidth('w');
                this.\u0104 = new Dimension(((LazyLoadDocument)syntaxDocument).\u010a() * n4, CodeEditor.this.getLineHeight() * CodeEditor.this.getLineCount());
                if (this.\u0104.width != 0 && this.\u0104.height != 0) {
                    this.\u0103 = false;
                }
                return;
            }
            int n5 = this.\u0105.\u010a();
            int n6 = CodeEditor.this.getDocument().getLength();
            int n7 = CodeEditor.this._painter.getFontMetrics().charWidth('w');
            for (n3 = 0; n3 < n5; ++n3) {
                if (this.\u0105.\u0105(n3) != -1) continue;
                n2 = CodeEditor.this.modelPositionToOffset(CodeEditor.this.viewToModelPosition(new CaretPosition(n3 + 1, 0)));
                this.\u0105.\u0106(n3, CodeEditor.this.offsetToX(Math.min(n2, n6) - 1) - CodeEditor.this.getHorizontalOffset() + n7);
            }
            n3 = n7;
            for (n2 = 0; n2 < n5; ++n2) {
                n3 = Math.max(n3, this.\u0105.\u0105(n2));
            }
            CaretPosition caretPosition = CodeEditor.this.getCaretModel().getViewPosition();
            int n8 = CodeEditor.this.columnToX(caretPosition.line, caretPosition.column);
            int n9 = n8 - CodeEditor.this.getHorizontalOffset();
            if (n9 > n3) {
                n3 = n9;
                this.\u0102 = true;
            } else {
                this.\u0102 = false;
            }
            this.\u0104 = new Dimension(n3, CodeEditor.this.getLineHeight() * n5);
            this.\u0103 = false;
        }

        public Dimension \u0102() {
            this.\u0103();
            return this.\u0104;
        }
    }

    private class F
    implements Border {
        private F() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            graphics.setColor(UIDefaultsLookup.getColor("controlDkShadow"));
            graphics.drawLine(0, n5 - 1, n4, n5 - 1);
            graphics.drawLine(n4 - 1, 0, n4 - 1, n5);
            graphics.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
            graphics.drawLine(0, 0, n4, 0);
            graphics.drawLine(0, 0, 0, n5);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return \u015a;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    class G
    implements MouseWheelListener {
        G() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            JScrollBar jScrollBar = CodeEditor.this.getVerticalScrollBar();
            int n2 = mouseWheelEvent.getWheelRotation() < 0 ? -1 : 1;
            boolean bl = true;
            if (mouseWheelEvent.isShiftDown() && SystemInfo.isAnyMac()) {
                jScrollBar = CodeEditor.this.getHorizontalScrollBar();
                bl = false;
            } else if (jScrollBar == null || !jScrollBar.isVisible()) {
                jScrollBar = CodeEditor.this.getHorizontalScrollBar();
                if (jScrollBar == null || !jScrollBar.isVisible()) {
                    return;
                }
                bl = false;
            }
            mouseWheelEvent.consume();
            if (mouseWheelEvent.getScrollType() == 0) {
                int n3;
                int n4 = Math.abs(mouseWheelEvent.getUnitsToScroll());
                boolean bl2 = Math.abs(mouseWheelEvent.getWheelRotation()) == 1;
                boolean bl3 = CodeEditor.this.getComponentOrientation().isLeftToRight();
                int n5 = jScrollBar.getMinimum();
                int n6 = jScrollBar.getMaximum() - jScrollBar.getModel().getExtent();
                if (bl2) {
                    int n7 = n3 = bl ? CodeEditor.this.getVisibleLines() : 20;
                    if (n2 < 0) {
                        n5 = Math.max(n5, jScrollBar.getValue() - n3);
                    } else {
                        n6 = Math.min(n6, jScrollBar.getValue() + n3);
                    }
                }
                if (!bl3 && !bl) {
                    n2 = -n2;
                }
                n3 = bl ? CodeEditor.this.getFirstLine() : -CodeEditor.this.getHorizontalOffset();
                for (int i2 = 0; i2 < n4; ++i2) {
                    int n8;
                    int n9 = n8 = bl ? 1 : 4;
                    if (n2 < 0) {
                        if ((n3 -= n8) > n5) continue;
                        n3 = n5;
                        break;
                    }
                    if ((n3 += n8) < n6) continue;
                    n3 = n6;
                    break;
                }
                if (bl) {
                    CodeEditor.this.setFirstLine(n3);
                } else {
                    CodeEditor.this.setHorizontalOffset(-n3);
                }
            } else if (mouseWheelEvent.getScrollType() == 1) {
                int n10 = CodeEditor.this.getVisibleLines() * (n2 > 0 ? 1 : -1);
                CodeEditor.this.setFirstLine(CodeEditor.this.getFirstLine() + n10);
            }
        }
    }

    class L
    extends AbstractUndoableEdit {
        private int \u0104;
        private int \u0102;
        private static final long \u0103 = -2565588001384646576L;

        L(int n2, int n3) {
            this.\u0104 = n2;
            this.\u0102 = n3;
        }

        @Override
        public boolean isSignificant() {
            return false;
        }

        @Override
        public String getPresentationName() {
            return "caret move";
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            CodeEditor.this.select(this.\u0104, this.\u0102);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            CodeEditor.this.select(this.\u0104, this.\u0102);
        }

        @Override
        public boolean addEdit(UndoableEdit undoableEdit) {
            if (undoableEdit instanceof L) {
                L l2 = (L)undoableEdit;
                this.\u0104 = l2.\u0104;
                this.\u0102 = l2.\u0102;
                l2.die();
                return true;
            }
            return false;
        }
    }

    class K
    implements MouseInputListener {
        private boolean \u0104 = false;
        private boolean \u0103 = false;
        private transient Cursor \u0102 = null;

        K() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Object object;
            if (!CodeEditor.this.isEnabled()) {
                return;
            }
            boolean bl = CodeEditor.this.requestFocusInWindow();
            if (!bl) {
                object = new Runnable(){

                    @Override
                    public void run() {
                        CodeEditor.this.requestFocusInWindow();
                    }
                };
                SwingUtilities.invokeLater((Runnable)object);
            }
            CodeEditor.this.setCaretVisible(true);
            if (mouseEvent.isPopupTrigger() && (object = CodeEditor.this.getComponentPopupMenu()) != null) {
                ((JPopupMenu)object).show(CodeEditor.this._painter, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            if (!SwingUtilities.isRightMouseButton(mouseEvent)) {
                int n2;
                int n3;
                int n4 = CodeEditor.this.yToLine(mouseEvent.getY());
                if (n4 >= CodeEditor.this.getVisualLineCount()) {
                    CodeEditor.this.getSelectionModel().clearSelection();
                    int n5 = Math.max(CodeEditor.this.xToColumn(CodeEditor.this.getVisualLineCount() - 1, mouseEvent.getX()), CodeEditor.this.offsetToViewPosition((int)CodeEditor.this.getDocumentLength()).column);
                    if (CodeEditor.this.isVirtualSpaceAllowed()) {
                        CodeEditor.this.getCaretModel().setViewPosition(new CaretPosition(CodeEditor.this.getVisualLineCount() - 1, n5));
                    } else {
                        CodeEditor.this.getCaretModel().setOffset(CodeEditor.this.getDocumentLength());
                    }
                    return;
                }
                if (CodeEditor.this.isVirtualSpaceAllowed()) {
                    n3 = CodeEditor.this.xToColumn(n4, mouseEvent.getX());
                    CaretPosition caretPosition = CodeEditor.this.viewToModelPosition(new CaretPosition(n4, n3));
                    n2 = CodeEditor.this.modelPositionToOffset(caretPosition);
                } else {
                    n2 = CodeEditor.this.xToOffset(n4, mouseEvent.getX());
                    CaretPosition caretPosition = CodeEditor.this.offsetToModelPosition(n2);
                    n3 = CodeEditor.this.modelToViewPosition((CaretPosition)caretPosition).column;
                }
                switch (mouseEvent.getClickCount()) {
                    case 1: {
                        this.\u0102(mouseEvent, n4, n3, n2);
                        CodeEditor.this.\u017b = -1;
                        break;
                    }
                    case 2: {
                        if (!SwingUtilities.isLeftMouseButton(mouseEvent) && !SwingUtilities.isMiddleMouseButton(mouseEvent)) break;
                        try {
                            this.\u0103(mouseEvent, n4, n3, n2);
                        }
                        catch (BadLocationException badLocationException) {
                            \u0184.warning(badLocationException.getLocalizedMessage());
                        }
                        CodeEditor.this.\u017b = -1;
                        break;
                    }
                    case 3: {
                        if (!SwingUtilities.isLeftMouseButton(mouseEvent) && !SwingUtilities.isMiddleMouseButton(mouseEvent)) break;
                        this.\u0101(mouseEvent, n4, n3, n2);
                        CodeEditor.this.\u017b = n4;
                    }
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu;
            if (!CodeEditor.this.isEnabled()) {
                return;
            }
            if (mouseEvent.isPopupTrigger() && (jPopupMenu = CodeEditor.this.getComponentPopupMenu()) != null) {
                jPopupMenu.show(CodeEditor.this._painter, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (this.\u0104 && this.\u0103) {
                    int n2 = CodeEditor.this.xyToOffset(mouseEvent.getX(), mouseEvent.getY());
                    CodeEditor.this.\u0101(n2, mouseEvent);
                    if (this.\u0102 != null) {
                        CodeEditor.this._painter.setCursor(this.\u0102);
                    }
                } else if (this.\u0104 && !this.\u0103) {
                    CodeEditor.this.getSelectionModel().clearSelection();
                }
                this.\u0104 = false;
                this.\u0103 = false;
                CodeEditor.this.\u017b = -1;
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu;
            if (!CodeEditor.this.isEnabled()) {
                return;
            }
            if (mouseEvent.isPopupTrigger() && (jPopupMenu = CodeEditor.this.getComponentPopupMenu()) != null) {
                jPopupMenu.show(CodeEditor.this._painter, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu;
            if (!CodeEditor.this.isEnabled() || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (SystemInfo.isJdk15Above() && (jPopupMenu = CodeEditor.this.getComponentPopupMenu()) != null && jPopupMenu.isVisible()) {
                return;
            }
            int n2 = CodeEditor.this.xyToOffset(mouseEvent.getX(), mouseEvent.getY());
            if (SwingUtilities.isLeftMouseButton(mouseEvent) || SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                if (this.\u0104) {
                    if (!this.\u0103) {
                        this.\u0102 = CodeEditor.this._painter.getCursor();
                        CodeEditor.this._painter.setCursor(JideCursors.getPredefinedCursor(33));
                    }
                    this.\u0103 = true;
                    CodeEditor.this.getCaretModel().setOffset(n2);
                    CodeEditor.this.scrollToCaret();
                } else {
                    int n3 = CodeEditor.this.yToLine(mouseEvent.getY());
                    if (n3 >= CodeEditor.this.getLineCount()) {
                        return;
                    }
                    int n4 = CodeEditor.this.xToColumn(n3, mouseEvent.getX());
                    if (CodeEditor.this.isAdjustColumnSelectionOnMouseEvent()) {
                        CodeEditor.this.setSelectionRectangular(CodeEditor.this.isColumnSelectionMode(mouseEvent));
                    }
                    CodeEditor.this.\u0101(n2, n3, n4);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.\u0103 = false;
            this.\u0104 = false;
            this.\u0102 = null;
        }

        private void \u0102(MouseEvent mouseEvent, int n2, int n3, int n4) {
            if ((mouseEvent.getModifiers() & 1) != 0) {
                if (CodeEditor.this.isAdjustColumnSelectionOnMouseEvent()) {
                    CodeEditor.this.getSelectionModel().setColumnSelectionMode(CodeEditor.this.isColumnSelectionMode(mouseEvent));
                }
                if (CodeEditor.this.isSelectionRectangular()) {
                    CodeEditor.this.\u0101(CodeEditor.this.\u0110(), new CaretPosition(n2, n3));
                } else {
                    int n5 = CodeEditor.this.getAnchorSelectionOffset();
                    int n6 = CodeEditor.this.getLeadSelectionOffset();
                    if (n4 < n5) {
                        CodeEditor.this.select(Math.max(n5, n6), n4);
                    } else {
                        CodeEditor.this.select(Math.min(n5, n6), n4);
                    }
                }
            } else {
                TransferHandler transferHandler = null;
                Transferable transferable = null;
                CodeEditor codeEditor = null;
                if (SwingUtilities.isMiddleMouseButton(mouseEvent) && mouseEvent.getSource() instanceof CodeEditorPainter && (codeEditor = ((CodeEditorPainter)mouseEvent.getSource()).getCodeEditor()) != null) {
                    try {
                        Toolkit toolkit = codeEditor.getToolkit();
                        Clipboard clipboard = toolkit.getSystemSelection();
                        if (clipboard != null && (transferHandler = codeEditor.getTransferHandler()) != null) {
                            try {
                                transferable = clipboard.getContents(null);
                            }
                            catch (IllegalStateException illegalStateException) {
                                UIManager.getLookAndFeel().provideErrorFeedback(codeEditor);
                            }
                        }
                    }
                    catch (HeadlessException headlessException) {
                        // empty catch block
                    }
                }
                if (n4 <= CodeEditor.this.getSelectionStart() || n4 >= CodeEditor.this.getSelectionEnd()) {
                    CodeEditor.this.getSelectionModel().clearSelection();
                } else if (CodeEditor.this.isEnabled()) {
                    this.\u0104 = true;
                }
                CodeEditor.this.getCaretModel().setViewPosition(new CaretPosition(n2, n3));
                CodeEditor.this.setMagicCaretPosition(CodeEditor.this.columnToX(n2, n3));
                if (transferable != null && transferHandler != null && codeEditor != null) {
                    transferHandler.importData(codeEditor, transferable);
                }
            }
        }

        private void \u0103(MouseEvent mouseEvent, int n2, int n3, int n4) throws BadLocationException {
            int n5;
            int n6;
            if (CodeEditor.this.isAdjustColumnSelectionOnMouseEvent()) {
                CodeEditor.this.getSelectionModel().setColumnSelectionMode(CodeEditor.this.isColumnSelectionMode(mouseEvent));
            }
            if (CodeEditor.this.getLineLength(n6 = CodeEditor.this.viewToModelLine(n2)) == 0) {
                return;
            }
            try {
                n5 = TextUtils.findMatchingBracket(CodeEditor.this._document, Math.max(0, n4 - 1));
                if (n5 != -1) {
                    int n7 = CodeEditor.this.getMarkPosition();
                    if (n5 > n7) {
                        ++n5;
                        --n7;
                    }
                    CodeEditor.this.select(n7, n5);
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                \u0184.warning(badLocationException.getLocalizedMessage());
            }
            n5 = CodeEditor.this.getLineStartOffset(n6);
            com.jidesoft.editor.E e2 = new com.jidesoft.editor.E(CodeEditor.this, n5);
            int n8 = CodeEditor.this.getLineEndOffset(n6);
            if (n8 >= e2.\u0104() && n5 > e2.\u0101()) {
                e2.\u0103();
            } else if (n8 >= e2.\u0104() && n5 == e2.\u0101() && e2.\u0102() == null) {
                e2.\u0103();
            }
            if (e2.\u0102() != null && e2.\u0101() - n5 < n3) {
                n6 = CodeEditor.this.viewToModelLine(n2 + 1) - 1;
                n5 = CodeEditor.this.getLineStartOffset(n6);
            }
            String string = CodeEditor.this.getLineText(n6);
            int n9 = 0;
            int n10 = string.length();
            int n11 = CodeEditor.this.getLineEndOffsetExcludeLineBreak(n6);
            if (string.length() > 0) {
                if (n3 <= n11) {
                    int n12;
                    int n13 = n4 - n5;
                    if (n13 < 1) {
                        \u0184.fine("CodeEditor: column should not be less than 1");
                        n13 = 1;
                    } else if (n13 > string.length()) {
                        \u0184.fine("CodeEditor: column should not be larger than the line length");
                        n13 = string.length();
                    }
                    char c2 = string.charAt(n13 - 1);
                    String string2 = (String)CodeEditor.this._document.getProperty("nonwordDelimiters");
                    if (string2 == null) {
                        string2 = "";
                    }
                    boolean bl = !Character.isLetterOrDigit(c2) && string2.indexOf(c2) == -1;
                    for (n12 = n13 - 1; n12 >= 0; --n12) {
                        c2 = string.charAt(n12);
                        if (!(bl ^ (!Character.isLetterOrDigit(c2) && string2.indexOf(c2) == -1))) continue;
                        n9 = n12 + 1;
                        break;
                    }
                    for (n12 = n13; n12 < string.length(); ++n12) {
                        c2 = string.charAt(n12);
                        if (!(bl ^ (!Character.isLetterOrDigit(c2) && string2.indexOf(c2) == -1))) continue;
                        n10 = n12;
                        break;
                    }
                } else {
                    n9 = CodeEditor.this.getLineStartOffsetNoSpace(n6) - n5;
                }
                CodeEditor.this.select(n5 + n9, n5 + n10);
            }
        }

        private void \u0101(MouseEvent mouseEvent, int n2, int n3, int n4) {
            int n5 = CodeEditor.this.getLineStartOffset(CodeEditor.this.viewToModelLine(n2));
            int n6 = CodeEditor.this.getLineEndOffset(CodeEditor.this.viewToModelLine(n2 + 1) - 1);
            if (n5 >= 0 && n6 >= n5) {
                CodeEditor.this.select(n5, n6 + 1);
            }
            CodeEditor.this.getCaretModel().setViewPosition(new CaretPosition(n2, n3));
            CodeEditor.this.setMagicCaretPosition(CodeEditor.this.columnToX(n2, n3));
        }
    }

    class J
    implements FocusListener {
        J() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            CodeEditor.this.setCaretVisible(true);
            CodeEditor.this.blinkCaret();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            CodeEditor.this.setCaretVisible(false);
        }
    }

    class A
    implements DocumentListener,
    PageLoadListener {
        A() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            CodeEditor.this.documentChanged(documentEvent);
            int n2 = documentEvent.getOffset();
            int n3 = documentEvent.getLength();
            if (!CodeEditor.this.getSelectionModel().hasSelection()) {
                CodeEditor.this.select(n2 + n3, n2 + n3);
            } else {
                int n4 = CodeEditor.this.getSelectionStart() > n2 || CodeEditor.this.getSelectionStart() == CodeEditor.this.getSelectionEnd() && CodeEditor.this.getSelectionStart() == n2 ? CodeEditor.this.getSelectionStart() + n3 : CodeEditor.this.getSelectionStart();
                int n5 = CodeEditor.this.getSelectionEnd() >= n2 ? CodeEditor.this.getSelectionEnd() + n3 : CodeEditor.this.getSelectionEnd();
                CodeEditor.this.select(n4, n5);
            }
            CodeEditor.this.getPainter().invalidateLineRange(CodeEditor.this.getFirstLine(), CodeEditor.this.getFirstLine() + CodeEditor.this.getVisibleLines());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            CodeEditor.this.documentChanged(documentEvent);
            int n2 = documentEvent.getOffset();
            int n3 = documentEvent.getLength();
            if (!CodeEditor.this.getSelectionModel().hasSelection()) {
                CodeEditor.this.select(n2, n2);
            } else {
                int n4 = CodeEditor.this.getSelectionStart();
                int n5 = CodeEditor.this.getSelectionEnd();
                int n6 = n4 > n2 ? (n4 > n2 + n3 ? n4 - n3 : n2) : n4;
                int n7 = n5 > n2 ? (n5 > n2 + n3 ? n5 - n3 : n2) : n5;
                CodeEditor.this.select(n6, n7);
            }
            CodeEditor.this.getPainter().invalidateLineRange(CodeEditor.this.getFirstLine(), CodeEditor.this.getFirstLine() + CodeEditor.this.getVisibleLines());
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            CodeEditor.this.getPainter().invalidateLineRange(CodeEditor.this.getFirstLine(), CodeEditor.this.getFirstLine() + CodeEditor.this.getVisibleLines());
        }

        @Override
        public void pageLoadingStart(PageLoadEvent pageLoadEvent) {
            if (pageLoadEvent.\u0101()) {
                CodeEditor.this.setOverlayVisible(true);
                CodeEditor.this.setContentVisible(false);
                CodeEditor.this.repaint();
            }
        }

        @Override
        public void pageLoaded(PageLoadEvent pageLoadEvent) {
            if (pageLoadEvent.\u0101()) {
                CodeEditor.this.setOverlayVisible(false);
                CodeEditor.this.setContentVisible(true);
                CodeEditor.this.repaint();
            }
        }

        @Override
        public void pageLoadFailed(PageLoadEvent pageLoadEvent) {
            CodeEditor.this.pageLoadFailedHandling(pageLoadEvent);
        }
    }

    class I
    extends ComponentAdapter {
        I() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (CodeEditor.this.getDocument() == null) {
                return;
            }
            CodeEditor.this.recalculateVisibleLines();
            CodeEditor.this._scrollBarsInitialized = true;
        }
    }

    class E
    implements AdjustmentListener {
        E() {
        }

        @Override
        public void adjustmentValueChanged(final AdjustmentEvent adjustmentEvent) {
            if (!CodeEditor.this._scrollBarsInitialized) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (adjustmentEvent.getAdjustable() == CodeEditor.this._verticalScrollBar) {
                        CodeEditor.this.setFirstLine(CodeEditor.this._verticalScrollBar.getValue());
                    } else {
                        CodeEditor.this.setHorizontalOffset(-CodeEditor.this._horizontalScrollBar.getValue());
                    }
                }
            });
            if (!CodeEditor.this.isDelayContentsOnLoading() || !(CodeEditor.this.getDocument() instanceof LazyLoadDocument) || CodeEditor.this.getDocument().isLineLoaded(CodeEditor.this._verticalScrollBar.getValue())) {
                return;
            }
            if (CodeEditor.this.\u015f == null) {
                CodeEditor.this.\u015f = CodeEditor.this.\u0118();
            }
            CodeEditor.this.\u015f.restart();
            CodeEditor.this.setContentVisible(false);
        }
    }

    class H
    implements LayoutManager {
        private Component \u0106;
        private Component \u0102;
        private Component \u0105;
        private Component \u0104;
        private Vector<Component> \u0103 = new Vector();

        H() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addLayoutComponent(String string, Component component) {
            Object object = component.getTreeLock();
            synchronized (object) {
                if (string.equals(CENTER)) {
                    this.\u0102 = component;
                } else if (string.equals(RIGHT)) {
                    this.\u0105 = component;
                } else if (string.equals(BOTTOM)) {
                    this.\u0104 = component;
                } else if (string.equals(LEFT)) {
                    this.\u0106 = component;
                } else if (string.equals(LEFT_OF_SCROLLBAR)) {
                    this.\u0103.addElement(component);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeLayoutComponent(Component component) {
            Object object = component.getTreeLock();
            synchronized (object) {
                if (this.\u0102 == component) {
                    this.\u0102 = null;
                }
                if (this.\u0105 == component) {
                    this.\u0105 = null;
                }
                if (this.\u0104 == component) {
                    this.\u0104 = null;
                }
                if (this.\u0106 == component) {
                    this.\u0106 = null;
                } else {
                    this.\u0103.removeElement(component);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Dimension dimension;
                Dimension dimension2 = new Dimension();
                Insets insets = CodeEditor.this.getInsets();
                dimension2.width = insets.left + insets.right;
                dimension2.height = insets.top + insets.bottom;
                Dimension dimension3 = this.\u0102.getPreferredSize();
                dimension2.width += dimension3.width;
                dimension2.height += dimension3.height;
                if (this.\u0105.isVisible()) {
                    dimension = this.\u0105.getPreferredSize();
                    dimension2.width += dimension.width;
                }
                if (this.\u0104.isVisible()) {
                    dimension = this.\u0104.getPreferredSize();
                    dimension2.height += dimension.height;
                }
                if (this.\u0106 != null) {
                    dimension = this.\u0106.getPreferredSize();
                    dimension2.width += dimension.width;
                }
                return dimension2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Dimension dimension;
                Dimension dimension2 = new Dimension();
                Insets insets = CodeEditor.this.getInsets();
                dimension2.width = insets.left + insets.right;
                dimension2.height = insets.top + insets.bottom;
                Dimension dimension3 = this.\u0102.getMinimumSize();
                dimension2.width += dimension3.width;
                dimension2.height += dimension3.height;
                if (this.\u0105.isVisible()) {
                    dimension = this.\u0105.getMinimumSize();
                    dimension2.width += dimension.width;
                }
                if (this.\u0104.isVisible()) {
                    dimension = this.\u0104.getMinimumSize();
                    dimension2.height += dimension.height;
                }
                if (this.\u0106 != null) {
                    dimension = this.\u0106.getMinimumSize();
                    dimension2.width += dimension.width;
                }
                return dimension2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Dimension dimension = container.getSize();
                Insets insets = container.getInsets();
                int n2 = insets.top;
                int n3 = insets.left;
                int n4 = insets.bottom;
                int n5 = insets.right;
                int n6 = this.\u0106 != null ? this.\u0106.getPreferredSize().width : 0;
                int n7 = this.\u0105 != null && this.\u0105.isVisible() ? this.\u0105.getPreferredSize().width : 0;
                int n8 = this.\u0104 != null && this.\u0104.isVisible() ? this.\u0104.getPreferredSize().height : 0;
                int n9 = dimension.width - n7 - n3 - n5 - n6;
                int n10 = dimension.height - n8 - n2 - n4;
                if (this.\u0106 != null) {
                    this.\u0106.setBounds(n3, n2, n6, n10);
                }
                n3 += n6;
                if (this.\u0102 != null) {
                    this.\u0102.setBounds(n3, n2, n9, n10);
                }
                if (this.\u0105 != null && this.\u0105.isVisible()) {
                    this.\u0105.setBounds(n3 + n9, n2, n7, n10);
                }
                for (Component component : this.\u0103) {
                    Dimension dimension2 = component.getPreferredSize();
                    component.setBounds(n3, n2 + n10, dimension2.width, n8);
                    n3 += dimension2.width;
                }
                if (this.\u0104 != null && this.\u0104.isVisible()) {
                    this.\u0104.setBounds(n3, n2 + n10, dimension.width - n7 - n3 - n5, n8);
                }
            }
        }
    }
}

