/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.AutoScroll;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.SearchableUtils;
import com.jidesoft.tree.TreeUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListDataListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeChooserPanel
extends PopupPanel
implements ItemListener {
    private Color \u01cd = UIDefaultsLookup.getColor("controlLtHighlight");
    private Color \u01d3 = UIDefaultsLookup.getColor("textText");
    private Border \u01d1 = BorderFactory.createEmptyBorder(0, 0, 0, 0);
    private JTree \u01cf;
    protected TreeModel _model;
    private int \u01ce;
    private TreeCellRenderer \u01d0;
    private AutoScroll \u01d5;
    private boolean \u01cc;
    private boolean \u01d4;
    private A \u01d2;
    protected MouseMotionListener mouseMotionListener;
    protected MouseListener mouseListener;
    protected KeyListener keyListener;
    protected TreeSelectionListener treeSelectionListener;
    protected MouseListener treeMouseListener;
    protected MouseMotionListener treeMouseMotionListener;

    public TreeChooserPanel() {
        this(TreeChooserPanel.getDefaultTreeModel());
    }

    public TreeChooserPanel(Object object) {
        this(TreeChooserPanel.createTreeModel(object));
    }

    public TreeChooserPanel(Object[] objectArray) {
        this(TreeChooserPanel.createTreeModel(objectArray));
    }

    public TreeChooserPanel(Vector<?> vector) {
        this(TreeChooserPanel.createTreeModel(vector));
    }

    public TreeChooserPanel(Hashtable<?, ?> hashtable) {
        this(TreeChooserPanel.createTreeModel(hashtable));
    }

    public TreeChooserPanel(TreeModel treeModel) {
        this._model = treeModel;
        this.initComponents();
    }

    protected void initComponents() {
        this.setStretchToFit(true);
        this.setLayout(new BorderLayout());
        this.setBorder(this.\u01d1);
        this.setBackground(this.\u01cd);
        this.setForeground(this.\u01d3);
        this.\u01cf = this.createTree(this._model);
        this.setupTree(this.\u01cf);
        JideScrollPane jideScrollPane = new JideScrollPane(this.\u01cf);
        jideScrollPane.setVerticalScrollBarPolicy(22);
        jideScrollPane.setVerticalScrollBarCoversWholeHeight(true);
        this.customizeScroller(jideScrollPane);
        this.add((Component)jideScrollPane, "Center");
        this.addItemListener(this);
        this.\u01d5 = new AutoScroll(this.\u01cf){

            @Override
            public void autoScrollingStarted(int n2) {
            }

            @Override
            public void autoScrolling(int n2) {
                TreeChooserPanel.this.\u01cf.putClientProperty("PopupPanel.selectedByMouseRollover", Boolean.TRUE);
                if (n2 == 0 || n2 == 2) {
                    int n3 = TreeChooserPanel.this.\u01cf.getRowForPath(TreeChooserPanel.this.\u01cf.getSelectionPath());
                    if (n3 > 0) {
                        TreeChooserPanel.this.\u0106(n3 - 1);
                        TreeChooserPanel.this.\u01cf.scrollRowToVisible(n3 - 1);
                    }
                } else {
                    int n4;
                    int n5 = TreeChooserPanel.this.\u01cf.getRowForPath(TreeChooserPanel.this.\u01cf.getSelectionPath());
                    if (n5 < (n4 = TreeChooserPanel.this.\u01cf.getRowCount() - 1)) {
                        TreeChooserPanel.this.\u0106(n5 + 1);
                        TreeChooserPanel.this.\u01cf.scrollRowToVisible(n5 + 1);
                    }
                }
                TreeChooserPanel.this.\u01cf.putClientProperty("PopupPanel.selectedByMouseRollover", null);
            }

            @Override
            public void updateSelectionForEvent(MouseEvent mouseEvent, boolean bl) {
                Point point = mouseEvent.getPoint();
                if (TreeChooserPanel.this.\u01cf == null) {
                    return;
                }
                int n2 = TreeChooserPanel.this.\u01cf.getRowForLocation(point.x, point.y);
                if (n2 != -1) {
                    TreePath treePath = TreeChooserPanel.this.\u01cf.getPathForRow(n2);
                    if (TreeChooserPanel.this.\u01cf.getSelectionPath() != treePath) {
                        TreeChooserPanel.this.\u01cf.putClientProperty("PopupPanel.selectedByMouseRollover", Boolean.TRUE);
                        TreeChooserPanel.this.\u01cf.setSelectionRow(n2);
                        TreeChooserPanel.this.\u01cf.putClientProperty("PopupPanel.selectedByMouseRollover", null);
                        if (bl) {
                            TreeChooserPanel.this.\u01cf.makeVisible(treePath);
                        }
                    }
                }
            }
        };
    }

    protected void customizeScroller(JScrollPane jScrollPane) {
        jScrollPane.setFocusable(false);
        jScrollPane.getVerticalScrollBar().setFocusable(false);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
    }

    protected JTree createTree(TreeModel treeModel) {
        JTree jTree = new JTree(treeModel){

            @Override
            public TreePath getNextMatch(String string, int n2, Position.Bias bias) {
                return null;
            }

            @Override
            public void processMouseEvent(MouseEvent mouseEvent) {
                if (JideSwingUtilities.isMenuShortcutKeyDown(mouseEvent)) {
                    mouseEvent = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers() ^ Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                }
                super.processMouseEvent(mouseEvent);
            }
        };
        SearchableUtils.installSearchable(jTree);
        return jTree;
    }

    protected void setupTree(JTree jTree) {
        if (this.getCellRenderer() != null) {
            jTree.setCellRenderer(this.getCellRenderer());
        }
        this.installTreeListeners();
        this.\u0101(jTree);
    }

    void \u0101(JTree jTree) {
        AbstractAction abstractAction = new AbstractAction(){
            private static final long \u0102 = -7543677001664617720L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreePath treePath = TreeChooserPanel.this.\u01cf.getSelectionPath();
                if (treePath != null && TreeChooserPanel.this.isValidSelection(treePath)) {
                    TreeChooserPanel.this.setSelectedObject(treePath);
                }
            }
        };
        jTree.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(10, 0), 1);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.\u01cf.putClientProperty("PopupPanel.selectedByMouseRollover", Boolean.TRUE);
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getItem() instanceof TreePath) {
                this.\u01cf.setSelectionPath((TreePath)itemEvent.getItem());
                this.\u01cf.scrollPathToVisible((TreePath)itemEvent.getItem());
            } else if (itemEvent.getItem() != null && this.isSearchUserObjectToSelect()) {
                TreeUtils.expandAll(this.\u01cf);
                for (int i2 = 0; i2 < this.getTree().getRowCount(); ++i2) {
                    TreePath treePath = this.\u01cf.getPathForRow(i2);
                    if (treePath == null || treePath.getLastPathComponent() == null || !JideSwingUtilities.equals(((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject(), itemEvent.getItem())) continue;
                    this.\u01cf.setSelectionPath(treePath);
                    this.\u01cf.scrollPathToVisible(treePath);
                    break;
                }
            }
        } else if (itemEvent.getStateChange() == 2) {
            this.\u01cf.clearSelection();
        }
        this.\u01cf.putClientProperty("PopupPanel.selectedByMouseRollover", null);
    }

    public int getMaximumRowCount() {
        return this.\u01ce;
    }

    public void setMaximumRowCount(int n2) {
        int n3 = this.\u01ce;
        this.\u01ce = n2;
        this.\u01cf.setVisibleRowCount(this.\u01ce);
        this.firePropertyChange("maximumRowCount", n3, this.\u01ce);
    }

    public TreeCellRenderer getCellRenderer() {
        return this.\u01d0;
    }

    public void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        this.\u01d0 = treeCellRenderer;
        if (this.getCellRenderer() != null) {
            this.\u01cf.setCellRenderer(this.getCellRenderer());
        }
    }

    public JTree getTree() {
        return this.\u01cf;
    }

    protected static TreeModel getDefaultTreeModel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("JTree");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("colors");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("blue"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("violet"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("red"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("yellow"));
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("sports");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("basketball"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("soccer"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("football"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("hockey"));
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("food");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("hot dogs"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("pizza"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ravioli"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("bananas"));
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    public static TreeModel createTreeModel(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (object == null) {
            return TreeChooserPanel.getDefaultTreeModel();
        }
        if (object instanceof TreeModel) {
            return (TreeModel)object;
        }
        if (object instanceof Object[] || object instanceof Hashtable || object instanceof Vector) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("root");
            JTree.DynamicUtilTreeNode.createChildren(defaultMutableTreeNode, object);
        } else {
            if (object instanceof TreeNode) {
                return new DefaultTreeModel((TreeNode)object, false);
            }
            defaultMutableTreeNode = new JTree.DynamicUtilTreeNode((Object)"root", object);
        }
        return new DefaultTreeModel(defaultMutableTreeNode, false);
    }

    protected boolean isValidSelection(TreePath treePath) {
        return true;
    }

    public boolean isDoubleClickExpand() {
        return this.\u01cc;
    }

    public void setDoubleClickExpand(boolean bl) {
        this.\u01cc = bl;
    }

    public boolean isSearchUserObjectToSelect() {
        return this.\u01d4;
    }

    public void setSearchUserObjectToSelect(boolean bl) {
        this.\u01d4 = bl;
    }

    protected MouseEvent convertMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.\u01cf) {
            return mouseEvent;
        }
        Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this.\u01cf);
        return new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
    }

    protected void updateTreeSelectionForEvent(MouseEvent mouseEvent, boolean bl) {
        Point point = mouseEvent.getPoint();
        if (this.\u01cf == null) {
            return;
        }
        int n2 = this.\u01cf.getRowForLocation(point.x, point.y);
        if (n2 != -1) {
            TreePath treePath = this.\u01cf.getPathForRow(n2);
            if (this.\u01cf.getSelectionPath() != treePath) {
                this.\u01cf.setSelectionRow(n2);
                if (bl) {
                    this.\u01cf.makeVisible(treePath);
                }
            }
        }
    }

    private void \u0106(int n2) {
        if (n2 == -1) {
            this.\u01cf.clearSelection();
        } else {
            this.\u01cf.setSelectionRow(n2);
            this.\u01cf.makeVisible(this.\u01cf.getPathForRow(n2));
        }
    }

    protected MouseListener createMouseListener() {
        return this.\u0125();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return this.\u0125();
    }

    protected KeyListener createKeyListener() {
        return null;
    }

    protected TreeSelectionListener createTreeSelectionListener() {
        return null;
    }

    protected ListDataListener createListDataListener() {
        return null;
    }

    protected MouseListener createTreeMouseListener() {
        return this.\u0125();
    }

    protected MouseMotionListener createTreeMouseMotionListener() {
        return this.\u0125();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.\u0125();
    }

    protected ItemListener createItemListener() {
        return this.\u0125();
    }

    private A \u0125() {
        if (this.\u01d2 == null) {
            this.\u01d2 = this.\u0124();
        }
        return this.\u01d2;
    }

    A \u0124() {
        return new A();
    }

    protected void installTreeListeners() {
        this.treeMouseListener = this.createTreeMouseListener();
        if (this.treeMouseListener != null) {
            this.\u01cf.addMouseListener(this.treeMouseListener);
        }
        if ((this.treeMouseMotionListener = this.createTreeMouseMotionListener()) != null) {
            this.\u01cf.addMouseMotionListener(this.treeMouseMotionListener);
        }
        if ((this.treeSelectionListener = this.createTreeSelectionListener()) != null) {
            this.\u01cf.addTreeSelectionListener(this.treeSelectionListener);
        }
    }

    void \u0123() {
        if (this.treeMouseListener != null) {
            this.\u01cf.removeMouseListener(this.treeMouseListener);
            this.treeMouseListener = null;
        }
        if (this.treeMouseMotionListener != null) {
            this.\u01cf.removeMouseMotionListener(this.treeMouseMotionListener);
            this.treeMouseMotionListener = null;
        }
        if (this.treeSelectionListener != null) {
            this.\u01cf.removeTreeSelectionListener(this.treeSelectionListener);
            this.treeSelectionListener = null;
        }
        this.\u01d2 = null;
    }

    class A
    implements ItemListener,
    MouseListener,
    MouseMotionListener,
    PropertyChangeListener,
    Serializable {
        private static final long \u0102 = 10293066769220954L;

        A() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == TreeChooserPanel.this.\u01cf) {
                if (TreeChooserPanel.this.\u01cf.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()) == -1) {
                    return;
                }
                TreePath treePath = TreeChooserPanel.this.\u01cf.getSelectionPath();
                if (TreeChooserPanel.this.isDoubleClickExpand() && treePath.getLastPathComponent() instanceof TreeNode && !((TreeNode)treePath.getLastPathComponent()).isLeaf()) {
                    return;
                }
                if (treePath != null && TreeChooserPanel.this.isValidSelection(treePath)) {
                    TreeChooserPanel.this.setSelectedObject(treePath);
                }
                return;
            }
            Component component = (Component)mouseEvent.getSource();
            Dimension dimension = component.getSize();
            Rectangle rectangle = new Rectangle(0, 0, dimension.width - 1, dimension.height - 1);
            if (!rectangle.contains(mouseEvent.getPoint())) {
                TreePath treePath;
                MouseEvent mouseEvent2 = TreeChooserPanel.this.convertMouseEvent(mouseEvent);
                Point point = mouseEvent2.getPoint();
                Rectangle rectangle2 = new Rectangle();
                TreeChooserPanel.this.\u01cf.computeVisibleRect(rectangle2);
                if (rectangle2.contains(point) && (treePath = TreeChooserPanel.this.\u01cf.getSelectionPath()) != null && TreeChooserPanel.this.isValidSelection(treePath)) {
                    TreeChooserPanel.this.setSelectedObject(treePath);
                }
            }
            TreeChooserPanel.this.\u01d5.mouseReleased(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            TreeChooserPanel.this.\u01d5.mouseMoved(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            TreeChooserPanel.this.\u01d5.mouseDragged(mouseEvent);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ComponentOrientation componentOrientation;
            JComboBox jComboBox = (JComboBox)propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("componentOrientation") && (componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue()) != TreeChooserPanel.this.getComponentOrientation()) {
                TreeChooserPanel.this.setComponentOrientation(componentOrientation);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                if (itemEvent.getItem() instanceof TreePath) {
                    TreeChooserPanel.this.\u01cf.setSelectionPath((TreePath)itemEvent.getItem());
                }
            } else if (itemEvent.getStateChange() == 2) {
                TreeChooserPanel.this.\u01cf.clearSelection();
            }
        }
    }
}

