/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.grid.GridResource;
import com.jidesoft.grid.GridsResourceProvider;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.AlignmentSupport;
import com.jidesoft.swing.AutoScroll;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.PortingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;

public class ListChooserPanel
extends PopupPanel
implements ItemListener,
ListDataListener,
AlignmentSupport {
    protected JList _list;
    protected Class<?> _class = String.class;
    protected MouseMotionListener mouseMotionListener;
    protected MouseListener mouseListener;
    protected KeyListener keyListener;
    protected ListSelectionListener listSelectionListener;
    protected MouseListener listMouseListener;
    protected MouseMotionListener listMouseMotionListener;
    ComboBoxModel \u01e2;
    private Color \u01e0 = UIDefaultsLookup.getColor("controlLtHighlight");
    private Color \u01dd = UIDefaultsLookup.getColor("textText");
    private Border \u01da = BorderFactory.createEmptyBorder(0, 0, 0, 0);
    private ConverterContext \u01dc = null;
    private ObjectConverter \u01e1 = null;
    private int \u01db;
    private int \u01d8 = -1;
    private ListCellRenderer \u01e3;
    private JScrollPane \u01d7;
    private AutoScroll \u01df;
    private int \u01de = -1;
    private int \u01e4 = -1;
    private Handler \u01d9;

    public ListChooserPanel() {
        this(new Object[0], Object.class);
    }

    public ListChooserPanel(Object[] objectArray, Class<?> clazz) {
        this(new DefaultComboBoxModel<Object>(objectArray), clazz);
    }

    public ListChooserPanel(Vector<?> vector, Class<?> clazz) {
        this(new DefaultComboBoxModel(vector), clazz);
    }

    public ListChooserPanel(ComboBoxModel comboBoxModel, Class<?> clazz) {
        this(comboBoxModel, clazz, null);
    }

    public ListChooserPanel(ComboBoxModel comboBoxModel, Class<?> clazz, ConverterContext converterContext) {
        this(comboBoxModel, clazz, null, converterContext);
    }

    public ListChooserPanel(ComboBoxModel comboBoxModel, Class<?> clazz, ObjectConverter objectConverter, ConverterContext converterContext) {
        this.\u01e2 = comboBoxModel;
        this._class = clazz;
        this.\u01e1 = objectConverter;
        this.\u01dc = converterContext;
        this.initComponents();
    }

    @Override
    public void removeAllListeners() {
        this.\u01e2.removeListDataListener(this);
        this._list.getUI().uninstallUI(this._list);
    }

    protected void initComponents() {
        this.setStretchToFit(true);
        this.setLayout(new BorderLayout());
        this.setBorder(this.\u01da);
        this.setBackground(this.\u01e0);
        this.setForeground(this.\u01dd);
        this.\u01e2.addListDataListener(this);
        this._list = this.createList(this.\u01e2);
        this._list.setName("ComboBox.list");
        this.\u01d7 = new JideScrollPane(this._list);
        this.\u01d7.setVerticalScrollBarPolicy(20);
        ((JideScrollPane)this.\u01d7).setVerticalScrollBarCoversWholeHeight(true);
        this.\u01d7.setName("ComboBox.scrollPane");
        this.setupList(this._list);
        this.customizeScroller(this.\u01d7);
        this.add((Component)this.\u01d7, "Center");
        this.addItemListener(this);
        if (this.isAutoScroll()) {
            this.\u01df = new AutoScroll(this._list){

                @Override
                public void autoScrollingStarted(int n2) {
                    if (n2 == 0 || n2 == 2) {
                        Point point = SwingUtilities.convertPoint(ListChooserPanel.this.\u01d7, new Point(1, 1), ListChooserPanel.this._list);
                        int n3 = ListChooserPanel.this._list.locationToIndex(point);
                        ListChooserPanel.this._list.setSelectedIndex(n3);
                    } else {
                        Dimension dimension = ListChooserPanel.this.\u01d7.getSize();
                        Point point = SwingUtilities.convertPoint(ListChooserPanel.this.\u01d7, new Point(1, dimension.height - 1 - 2), ListChooserPanel.this._list);
                        int n4 = ListChooserPanel.this._list.locationToIndex(point);
                        ListChooserPanel.this._list.setSelectedIndex(n4);
                    }
                }

                @Override
                public void autoScrolling(int n2) {
                    if (n2 == 0 || n2 == 2) {
                        int n3 = ListChooserPanel.this._list.getSelectedIndex();
                        if (n3 > 0) {
                            ListChooserPanel.this._list.setSelectedIndex(n3 - 1);
                            ListChooserPanel.this._list.ensureIndexIsVisible(n3 - 1);
                        }
                    } else {
                        int n4;
                        int n5 = ListChooserPanel.this._list.getSelectedIndex();
                        if (n5 < (n4 = ListChooserPanel.this._list.getModel().getSize() - 1)) {
                            ListChooserPanel.this._list.setSelectedIndex(n5 + 1);
                            ListChooserPanel.this._list.ensureIndexIsVisible(n5 + 1);
                        }
                    }
                }

                @Override
                public void updateSelectionForEvent(MouseEvent mouseEvent, boolean bl) {
                    Point point = mouseEvent.getPoint();
                    if (ListChooserPanel.this._list == null) {
                        return;
                    }
                    int n2 = ListChooserPanel.this._list.locationToIndex(point);
                    if (n2 == -1) {
                        n2 = point.y < 0 ? 0 : ListChooserPanel.this.\u01e2.getSize() - 1;
                    }
                    if (ListChooserPanel.this._list.getSelectedIndex() != n2) {
                        ListChooserPanel.this._list.putClientProperty("PopupPanel.selectedByMouseRollover", Boolean.TRUE);
                        ListChooserPanel.this._list.setSelectedIndex(n2);
                        ListChooserPanel.this._list.putClientProperty("PopupPanel.selectedByMouseRollover", null);
                        if (bl) {
                            ListChooserPanel.this._list.ensureIndexIsVisible(n2);
                        }
                    }
                }
            };
        }
    }

    protected boolean isAutoScroll() {
        return true;
    }

    protected void customizeScroller(JScrollPane jScrollPane) {
        jScrollPane.setFocusable(false);
        jScrollPane.getVerticalScrollBar().setFocusable(false);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
    }

    protected JList createList(ComboBoxModel comboBoxModel) {
        return new ListEx(comboBoxModel);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.\u0128();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.\u0128();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        if (listDataEvent.getIndex0() == -1 && listDataEvent.getIndex1() == -1) {
            this.updateListSelectionWithoutFiringEvent();
        } else {
            this.\u0128();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateListSelectionWithoutFiringEvent() {
        ListSelectionListener[] listSelectionListenerArray;
        for (ListSelectionListener listSelectionListener : listSelectionListenerArray = this._list.getListSelectionListeners()) {
            this._list.removeListSelectionListener(listSelectionListener);
        }
        try {
            this.updateListSelection(this.\u01e2.getSelectedItem(), false);
        }
        finally {
            for (ListSelectionListener listSelectionListener : listSelectionListenerArray) {
                this._list.addListSelectionListener(listSelectionListener);
            }
        }
    }

    protected void setupList(JList jList) {
        if (this.getRenderer() == null) {
            final ListCellRenderer listCellRenderer = new JComboBox().getRenderer();
            jList.setCellRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
                    return listCellRenderer.getListCellRendererComponent(jList, ListChooserPanel.this.getConverter() != null ? ListChooserPanel.this.getConverter().toString(object, ListChooserPanel.this.getConverterContext()) : ObjectConverterManager.toString(object, ListChooserPanel.this._class, ListChooserPanel.this.getConverterContext()), n2, bl, bl2);
                }
            });
        } else {
            jList.setCellRenderer(this.getRenderer());
        }
        jList.setSelectionMode(0);
        jList.setVisibleRowCount(jList.getModel().getSize());
        this.installListListeners();
        this.\u0101(jList);
    }

    private void \u0101(JList jList) {
        AbstractAction abstractAction = this.\u0127();
        jList.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(10, 0), 1);
    }

    AbstractAction \u0127() {
        return new AbstractAction(){
            private static final long \u0102 = 9187441646805583284L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListChooserPanel.this.setSelectedObject(ListChooserPanel.this._list.getSelectedValue());
            }
        };
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            Object object = itemEvent.getItem();
            this.updateListSelection(object, true);
        } else if (itemEvent.getStateChange() == 2) {
            this._list.clearSelection();
        }
    }

    protected void updateListSelection(Object object, boolean bl) {
        if (this._list != null) {
            if (object == null) {
                this._list.clearSelection();
            } else {
                this._list.setSelectedValue(object, bl);
            }
        }
    }

    public int getMaximumRowCount() {
        return this.\u01db;
    }

    public void setMaximumRowCount(int n2) {
        int n3 = this.\u01db;
        this.\u01db = n2;
        if (this.\u01db < this._list.getModel().getSize() || this._list.getModel().getSize() == 0) {
            this._list.setVisibleRowCount(this.\u01db);
        }
        this.firePropertyChange("maximumRowCount", n3, this.\u01db);
    }

    public int getMaximumWidth() {
        return this.\u01d8;
    }

    public void setMaximumWidth(int n2) {
        if (this.\u01d8 != n2) {
            int n3 = this.\u01d8;
            this.\u01d8 = n2;
            this.firePropertyChange("maximumWidth", n3, this.\u01d8);
        }
    }

    public ListCellRenderer getRenderer() {
        if (this.\u01e3 instanceof JLabel) {
            if (this.getHorizontalAlignment() != -1) {
                ((JLabel)((Object)this.\u01e3)).setHorizontalAlignment(this.getHorizontalAlignment());
            }
            if (this.getVerticalAlignment() != -1) {
                ((JLabel)((Object)this.\u01e3)).setVerticalAlignment(this.getVerticalAlignment());
            }
        }
        return this.\u01e3;
    }

    public void setRenderer(ListCellRenderer listCellRenderer) {
        this.\u01e3 = listCellRenderer;
        if (this.getRenderer() != null && this._list != null) {
            this._list.setCellRenderer(this.getRenderer());
        }
    }

    public ConverterContext getConverterContext() {
        return this.\u01dc;
    }

    public void setConverterContext(ConverterContext converterContext) {
        this.\u01dc = converterContext;
    }

    public ObjectConverter getConverter() {
        return this.\u01e1;
    }

    public void setConverter(ObjectConverter objectConverter) {
        this.\u01e1 = objectConverter;
    }

    public JList getList() {
        return this._list;
    }

    @Override
    public void setSelectedObject(Object object) {
        super.setSelectedObject(object);
        if (this._list != null) {
            this._list.setSelectedValue(object, true);
        }
    }

    protected MouseEvent convertMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this._list) {
            return mouseEvent;
        }
        Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this._list);
        return new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
    }

    private void \u0107(int n2) {
        if (n2 == -1) {
            this._list.clearSelection();
        } else {
            this._list.setSelectedIndex(n2);
            this._list.ensureIndexIsVisible(n2);
        }
    }

    protected MouseListener createMouseListener() {
        return this.\u0126();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return this.\u0126();
    }

    protected KeyListener createKeyListener() {
        return null;
    }

    protected ListSelectionListener createListSelectionListener() {
        return null;
    }

    protected ListDataListener createListDataListener() {
        return null;
    }

    protected MouseListener createListMouseListener() {
        return this.\u0126();
    }

    protected MouseMotionListener createListMouseMotionListener() {
        return this.\u0126();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.\u0126();
    }

    protected ItemListener createItemListener() {
        return this.\u0126();
    }

    private Handler \u0126() {
        if (this.\u01d9 == null) {
            this.\u01d9 = this.createHandler();
        }
        return this.\u01d9;
    }

    protected Handler createHandler() {
        return new Handler();
    }

    protected void installListListeners() {
        this.listMouseListener = this.createListMouseListener();
        if (this.listMouseListener != null) {
            this._list.addMouseListener(this.listMouseListener);
        }
        if ((this.listMouseMotionListener = this.createListMouseMotionListener()) != null) {
            this._list.addMouseMotionListener(this.listMouseMotionListener);
        }
        if ((this.listSelectionListener = this.createListSelectionListener()) != null) {
            this._list.addListSelectionListener(this.listSelectionListener);
        }
    }

    void \u0129() {
        if (this.listMouseListener != null) {
            this._list.removeMouseListener(this.listMouseListener);
            this.listMouseListener = null;
        }
        if (this.listMouseMotionListener != null) {
            this._list.removeMouseMotionListener(this.listMouseMotionListener);
            this.listMouseMotionListener = null;
        }
        if (this.listSelectionListener != null) {
            this._list.removeListSelectionListener(this.listSelectionListener);
            this.listSelectionListener = null;
        }
        this.\u01d9 = null;
    }

    @Override
    public MouseMotionListener getMouseMotionListener() {
        return this.listMouseMotionListener;
    }

    @Override
    public MouseListener getMouseListener() {
        return this.listMouseListener;
    }

    @Override
    public int getHorizontalAlignment() {
        return this.\u01de;
    }

    @Override
    public void setHorizontalAlignment(int n2) {
        this.\u01de = n2;
    }

    @Override
    public int getVerticalAlignment() {
        return this.\u01e4;
    }

    @Override
    public void setVerticalAlignment(int n2) {
        this.\u01e4 = n2;
    }

    private void \u0128() {
        if (this._list.getModel().getSize() == 0) {
            this._list.setVisibleRowCount(1);
        } else if (this.getMaximumRowCount() < this._list.getModel().getSize()) {
            this._list.setVisibleRowCount(this.getMaximumRowCount());
        } else {
            this._list.setVisibleRowCount(this._list.getModel().getSize());
        }
        this.setPreferredSize(null);
    }

    protected class ListEx
    extends JList
    implements GridsResourceProvider {
        public ListEx(ListModel listModel) {
            super(listModel);
        }

        @Override
        public String getResourceString(String string) {
            return GridResource.getResourceBundle(ListChooserPanel.this.getLocale()).getString(string);
        }

        @Override
        public int getNextMatch(String string, int n2, Position.Bias bias) {
            return -1;
        }

        @Override
        public void processMouseEvent(MouseEvent mouseEvent) {
            if (JideSwingUtilities.isMenuShortcutKeyDown(mouseEvent)) {
                mouseEvent = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers() ^ Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            }
            this.superProcessMouseEvent(mouseEvent);
        }

        public void superProcessMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            Dimension dimension;
            if (this.getLayoutOrientation() != 0) {
                dimension = this.getPreferredSize();
            } else {
                Insets insets = this.getInsets();
                int n2 = insets.left + insets.right;
                int n3 = insets.top + insets.bottom;
                int n4 = this.getVisibleRowCount();
                int n5 = this.getFixedCellWidth();
                int n6 = this.getFixedCellHeight();
                if (n5 > 0 && n6 > 0) {
                    int n7 = n5 + n2;
                    int n8 = n4 * n6 + n3;
                    dimension = new Dimension(n7, n8);
                } else if (this.getModel().getSize() > 0) {
                    int n9;
                    int n10 = this.getPreferredSize().width;
                    Rectangle rectangle = this.getCellBounds(this.getModel().getSize() - 1, 0);
                    if (rectangle != null) {
                        int n11 = rectangle.height;
                        if (this.getModel().getSize() > 1 && (rectangle = this.getCellBounds(this.getModel().getSize() - 2, 0)) != null) {
                            n11 -= rectangle.height;
                        }
                        n9 = n4 * n11 + n3;
                    } else {
                        n9 = 1;
                    }
                    dimension = new Dimension(n10, n9);
                } else {
                    n5 = n5 > 0 ? n5 : 256;
                    n6 = n6 > 0 ? n6 : 16;
                    dimension = new Dimension(n5, n6 * n4);
                }
            }
            if (dimension != null) {
                dimension.width = ListChooserPanel.this.getMaximumWidth() > 0 ? Math.min(ListChooserPanel.this.getMaximumWidth(), dimension.width) : Math.min(PortingUtils.getLocalScreenBounds().width / 2, dimension.width);
            }
            return dimension != null && dimension.width > 0 && dimension.height > 0 ? JideSwingUtilities.adjustPreferredScrollableViewportSize(this, dimension) : dimension;
        }
    }

    protected class Handler
    implements ItemListener,
    MouseListener,
    MouseMotionListener,
    PropertyChangeListener,
    Serializable {
        private static final long \u0102 = 682523639161710467L;

        protected Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            if (mouseEvent.getSource() == ListChooserPanel.this._list) {
                ListChooserPanel.this._list.putClientProperty("PopupPanel.selectedByMouseRollover", Boolean.TRUE);
                ListChooserPanel.this.setSelectedObject(ListChooserPanel.this._list.getSelectedValue());
                ListChooserPanel.this._list.putClientProperty("PopupPanel.selectedByMouseRollover", null);
                return;
            }
            if (ListChooserPanel.this.isAutoScroll()) {
                Component component = (Component)mouseEvent.getSource();
                Dimension dimension = component.getSize();
                Rectangle rectangle = new Rectangle(0, 0, dimension.width - 1, dimension.height - 1);
                if (!rectangle.contains(mouseEvent.getPoint())) {
                    MouseEvent mouseEvent2 = ListChooserPanel.this.convertMouseEvent(mouseEvent);
                    Point point = mouseEvent2.getPoint();
                    Rectangle rectangle2 = new Rectangle();
                    ListChooserPanel.this._list.computeVisibleRect(rectangle2);
                    if (rectangle2.contains(point)) {
                        ListChooserPanel.this._list.putClientProperty("PopupPanel.selectedByMouseRollover", Boolean.TRUE);
                        ListChooserPanel.this.setSelectedObject(ListChooserPanel.this._list.getSelectedValue());
                        ListChooserPanel.this._list.putClientProperty("PopupPanel.selectedByMouseRollover", null);
                    }
                }
                ListChooserPanel.this.\u01df.mouseReleased(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed() || !ListChooserPanel.this.isAutoScroll()) {
                return;
            }
            ListChooserPanel.this.\u01df.mouseMoved(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed() || !ListChooserPanel.this.isAutoScroll()) {
                return;
            }
            ListChooserPanel.this.\u01df.mouseDragged(mouseEvent);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ComponentOrientation componentOrientation;
            JComboBox jComboBox = (JComboBox)propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if ("model".equals(string)) {
                ComboBoxModel comboBoxModel = (ComboBoxModel)propertyChangeEvent.getNewValue();
                ListChooserPanel.this._list.setModel(comboBoxModel);
                if (ListChooserPanel.this.isVisible()) {
                    ListChooserPanel.this.setVisible(false);
                }
            } else if ("renderer".equals(string)) {
                ListChooserPanel.this._list.setCellRenderer(jComboBox.getRenderer());
                if (ListChooserPanel.this.isVisible()) {
                    ListChooserPanel.this.setVisible(false);
                }
            } else if ("componentOrientation".equals(string) && (componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue()) != ListChooserPanel.this.getComponentOrientation()) {
                ListChooserPanel.this.applyComponentOrientation(componentOrientation);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                ListChooserPanel.this.\u0107(jComboBox.getSelectedIndex());
            }
        }
    }
}

