/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.model.ChartCategory;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.render.AbstractBarRenderer;
import com.jidesoft.chart.render.BarRenderer2D;
import com.jidesoft.chart.render.ZAlignment;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.range.Positionable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class Bar3DRenderer
extends AbstractBarRenderer
implements BarRenderer2D,
Serializable {
    private int \u0145;
    private double \u0144 = 0.3;
    private double \u0142 = 35.0;
    private ZAlignment \u0141 = ZAlignment.CENTER;

    @Override
    public int getMinimumBreadth() {
        return this.\u0145;
    }

    public double getAngle() {
        return this.\u0142;
    }

    public void setAngle(double d2) {
        this.\u0142 = d2;
    }

    public double getDepthRatio() {
        return this.\u0144;
    }

    public void setDepthRatio(double d2) {
        this.\u0144 = d2;
    }

    public ZAlignment getZAlignment() {
        return this.\u0141;
    }

    public void setZAlignment(ZAlignment zAlignment) {
        this.\u0141 = zAlignment;
    }

    @Override
    public Shape renderBar(Graphics2D graphics2D, Chart chart, ChartModel chartModel, Chartable chartable, boolean bl, boolean bl2, boolean bl3, double d2, double d3, double d4, double d5) {
        Highlight highlight;
        Object object;
        Positionable positionable;
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        ChartStyle chartStyle = chart.getStyle(chartModel);
        Orientation orientation = chartStyle == null ? Orientation.vertical : chartStyle.getBarOrientation();
        Positionable positionable2 = chartable == null ? null : chartable.getX();
        Positionable positionable3 = positionable = chartable == null ? null : chartable.getY();
        if (orientation == Orientation.vertical && positionable2 instanceof ChartCategory) {
            object = (ChartCategory)positionable2;
            highlight = ((ChartCategory)object).getHighlight();
            if (highlight != null) {
                chartStyle = chart.getHighlightStyle(highlight);
            }
        } else if (orientation == Orientation.horizontal && positionable instanceof ChartCategory && (highlight = ((ChartCategory)(object = (ChartCategory)positionable)).getHighlight()) != null) {
            chartStyle = chart.getHighlightStyle(highlight);
        }
        object = this.createBarPaint(chart, chartable, chartStyle, bl, bl2, bl3, (int)d2, (int)d3, (int)d4, (int)d5);
        if (object == null) {
            object = this.getBarColor(chart, chartable, chartStyle, bl, bl2, bl3);
        }
        boolean bl4 = false;
        if (orientation == Orientation.vertical) {
            if (d4 > (double)bl4) {
                d4 -= (double)bl4;
                d2 += (double)((float)bl4 / 2.0f);
            } else {
                d4 = 0.0;
            }
        }
        if (orientation == Orientation.horizontal) {
            if (d5 > (double)bl4) {
                d5 -= (double)bl4;
                d3 += (double)((float)bl4 / 2.0f);
            } else {
                d5 = 0.0;
            }
        }
        assert (d4 >= 0.0);
        if (d5 < 0.0) {
            d3 += d5;
            d5 = -d5;
        }
        boolean bl5 = true;
        if ((d5 == 0.0 && orientation == Orientation.vertical || d4 == 0.0 && orientation == Orientation.horizontal) && !this.isZeroHeightBarsVisible()) {
            bl5 = false;
        }
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = orientation == Orientation.vertical ? (int)(this.\u0144 * d4) : (int)(this.\u0144 * d5);
        GeneralPath generalPath = new GeneralPath();
        int n3 = (int)Math.round(Math.cos(Math.toRadians(this.\u0142)) * (double)n2);
        int n4 = (int)Math.round(Math.sin(Math.toRadians(this.\u0142)) * (double)n2);
        this.\u0145 = Math.max(n3, n4);
        int n5 = Math.round((float)n4 / 2.0f);
        int n6 = Math.round((float)n3 / 2.0f);
        if (this.\u0141 == ZAlignment.FRONT) {
            if (orientation == Orientation.vertical) {
                d3 -= (double)n5;
            } else {
                d2 += (double)n6;
            }
        } else if (this.\u0141 == ZAlignment.BACK) {
            if (orientation == Orientation.vertical) {
                d3 += (double)n5;
            } else {
                d2 -= (double)n6;
            }
        }
        if (orientation == Orientation.vertical) {
            d3 += (double)n5;
        } else {
            d2 -= (double)n6;
        }
        if (bl5) {
            this.\u0103(graphics2D2, (Paint)object, orientation, d2, d3, d4, d5, n2, n3, n4);
            this.\u0101(graphics2D2, (Paint)object, orientation, d2, d3, d4, d5, n2, n3, n4);
            this.\u0102(graphics2D2, (Paint)object, orientation, d2, d3, d4, d5, n2, n3, n4);
        }
        generalPath.moveTo(d2 + d4 + (double)n3, d3 + d5 - (double)n4);
        generalPath.lineTo(d2 + d4, d3 + d5);
        generalPath.lineTo(d2, d3 + d5);
        generalPath.lineTo(d2, d3);
        generalPath.lineTo(d2 + (double)n3, d3 - (double)n4);
        generalPath.lineTo(d2 + d4 + (double)n3, d3 - (double)n4);
        generalPath.closePath();
        if (this.alwaysShowOutlines || bl && chart.isSelectionShowsOutline()) {
            Color color = bl && chart.isSelectionShowsOutline() ? this.getSelectionColor() : (this.alwaysShowOutlines ? this.getOutlineColor() : chart.getBackground());
            if (bl5) {
                graphics2D2.setColor(color);
                graphics2D2.setStroke(new BasicStroke(this.getOutlineWidth()));
                graphics2D2.draw(generalPath);
            }
        }
        if (bl5 && this.isLabelsVisible()) {
            if (orientation == Orientation.vertical) {
                this.renderBarLabel(graphics2D2, chart, chartModel, chartable, bl, bl2, bl3, d2 + (double)n3 / 2.0, d3 - (double)n4, d4, d5);
            } else {
                this.renderBarLabel(graphics2D2, chart, chartModel, chartable, bl, bl2, bl3, d2 + (double)n3, d3 - (double)n4 / 2.0, d4, d5);
            }
        }
        graphics2D2.dispose();
        return generalPath;
    }

    private void \u0101(Graphics2D graphics2D, Paint paint, Orientation orientation, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        Paint paint2 = paint instanceof Color ? this.createSidePaint(orientation, (Color)paint, (int)d2, (int)d3, (int)d4, (int)d5, (int)d6) : paint;
        graphics2D.setPaint(paint2);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(d2 + d4, d3);
        generalPath.lineTo(d2 + d4, d3 + d5);
        generalPath.lineTo(d2 + d4 + d7, d3 + d5 - d8);
        generalPath.lineTo(d2 + d4 + d7, d3 - d8);
        generalPath.closePath();
        graphics2D.fill(generalPath);
    }

    private void \u0102(Graphics2D graphics2D, Paint paint, Orientation orientation, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        Paint paint2 = paint instanceof Color ? this.createFrontPaint(orientation, (Color)paint, (int)d2, (int)d3, (int)d4, (int)d5, (int)d6) : paint;
        graphics2D.setPaint(paint2);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d3, d4, d5);
        graphics2D.fill(double_);
    }

    private void \u0103(Graphics2D graphics2D, Paint paint, Orientation orientation, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        Paint paint2 = paint instanceof Color ? this.createTopPaint(orientation, (Color)paint, (int)d2, (int)d3, (int)d4, (int)d5, (int)d6) : paint;
        graphics2D.setPaint(paint2);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(d2, d3);
        generalPath.lineTo(d2 + d4, d3);
        generalPath.lineTo(d2 + d4 + d7, d3 - d8);
        generalPath.lineTo(d2 + d7, d3 - d8);
        graphics2D.fill(generalPath);
    }

    @Override
    public Shape renderBar(Graphics graphics, Chart chart, ChartModel chartModel, Chartable chartable, boolean bl, boolean bl2, boolean bl3, int n2, int n3, int n4, int n5) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        return this.renderBar(graphics2D, chart, chartModel, chartable, bl, bl2, bl3, (double)n2, (double)n3, (double)n4, (double)n5);
    }

    protected Paint createTopPaint(Orientation orientation, Color color, int n2, int n3, int n4, int n5, int n6) {
        int n7 = (int)Math.round(Math.sin(Math.toRadians(this.\u0142)) * (double)n6);
        int n8 = Math.round((float)n7 / 2.0f);
        if (orientation == Orientation.vertical) {
            return new GradientPaint(n2, n3 + n8, color, n2 + n4 + n6, n3 - n8, color.brighter());
        }
        return new GradientPaint(n2, n3 - n7, color.brighter(), n2 + n4, n3 - n8, color.brighter().brighter());
    }

    protected Paint createSidePaint(Orientation orientation, Color color, int n2, int n3, int n4, int n5, int n6) {
        return new GradientPaint(n2, n3, color.darker(), n2, n3 + n5, color.darker().darker());
    }

    protected Paint createFrontPaint(Orientation orientation, Color color, int n2, int n3, int n4, int n5, int n6) {
        if (orientation == Orientation.vertical) {
            return new GradientPaint(n2 - n4 / 2, n3, color, n2 + n4 + n4 / 2, n3, color.darker(), true);
        }
        return new GradientPaint(n2, n3, color, n2, n3 + n5, color.darker());
    }
}

