/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.annotation;

import com.jidesoft.chart.annotation.AbstractAnnotation;
import com.jidesoft.chart.style.LabelStyle;
import com.jidesoft.chart.util.Rotation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.UIManager;

public abstract class AbstractLabel
extends AbstractAnnotation {
    private static final Logger \u0114 = Logger.getLogger(AbstractLabel.class.getName());
    private Color \u010f;
    private Font \u010e;
    private Color \u0113 = null;
    private String \u0112;
    private LabelStyle \u0111 = new LabelStyle();
    private Dimension \u0115 = null;
    private final JLabel \u0110 = new JLabel("");

    public AbstractLabel() {
        this("");
    }

    public AbstractLabel(String string) {
        this(string, UIManager.getColor("Chart.foreground") == null ? UIManager.getColor("Panel.foreground") : UIManager.getColor("Chart.foreground"));
    }

    public AbstractLabel(String string, Color color) {
        this(string, color, UIManager.getFont("Chart.font") == null ? UIManager.getFont("Label.font") : UIManager.getFont("Chart.font"));
    }

    public AbstractLabel(String string, Color color, Font font) {
        this.setLabel(string);
        this.setColor(color);
        this.setFont(font);
    }

    public AbstractLabel(String string, LabelStyle labelStyle) {
        this.setLabel(string);
        this.setLabelStyle(labelStyle);
    }

    public String getLabel() {
        return this.\u0112;
    }

    public void setLabel(String string) {
        this.\u0112 = string;
    }

    protected JLabel getLabelComponent() {
        return this.\u0110;
    }

    public Color getColor() {
        return this.\u0111 == null ? this.\u010f : this.\u0111.getColor();
    }

    public void setColor(Color color) {
        if (this.\u010f == null) {
            this.\u010f = color;
        }
        if (this.\u0111 != null) {
            this.\u0111.setColor(color);
        }
    }

    public void setBackground(Color color) {
        this.\u0113 = color;
    }

    public Color getBackground() {
        return this.\u0113;
    }

    public Font getFont() {
        return this.\u0111 == null ? this.\u010e : this.\u0111.getFont();
    }

    public void setFont(Font font) {
        if (this.\u010e == null) {
            this.\u010e = font;
        }
        if (this.\u0111 != null) {
            this.\u0111.setFont(font);
        }
        this.\u0115 = null;
    }

    public Double getRotation() {
        \u0114.finest("LabelStyle = " + this.\u0111);
        if (this.\u0111 == null) {
            return 0.0;
        }
        return this.\u0111.getRotation();
    }

    public void setRotation(Double d2) {
        this.\u0111.setRotation(d2);
    }

    public LabelStyle getLabelStyle() {
        return this.\u0111;
    }

    public void setLabelStyle(LabelStyle labelStyle) {
        this.\u0111 = labelStyle;
        this.\u0115 = null;
    }

    public Dimension size(Graphics graphics, Font font) {
        if (this.\u0115 == null) {
            String string = this.getLabel();
            if (string != null && string.trim().toLowerCase().startsWith("<html")) {
                Font font2 = font == null ? this.\u0102() : font;
                this.\u0110.setFont(font2);
                this.\u0110.setText(string);
                this.\u0115 = this.\u0110.getPreferredSize();
            } else {
                Font font3 = font == null ? graphics.getFont() : font;
                FontMetrics fontMetrics = graphics.getFontMetrics(font3);
                int n2 = fontMetrics.getHeight();
                String string2 = this.getLabel();
                int n3 = string2 == null ? 0 : fontMetrics.stringWidth(string2);
                this.\u0115 = new Dimension(n3, n2);
            }
        }
        return this.\u0115;
    }

    private Font \u0102() {
        Font font;
        LabelStyle labelStyle = this.getLabelStyle();
        if (labelStyle == null) {
            font = UIManager.getFont("Label.font");
        } else {
            font = labelStyle.getFont();
            if (font == null) {
                font = UIManager.getFont("Label.font");
            }
        }
        return font;
    }

    private Color \u0101() {
        Color color;
        LabelStyle labelStyle = this.getLabelStyle();
        if (labelStyle == null) {
            color = UIManager.getColor("Label.foreground");
        } else {
            color = labelStyle.getColor();
            if (color == null) {
                color = UIManager.getColor("Label.foreground");
            }
        }
        return color;
    }

    public void paint(Graphics graphics, int n2, int n3, Rotation rotation) {
        if (rotation == Rotation.NONE) {
            this.paint(graphics, n2, n3, 0.0);
        } else if (rotation == Rotation.QUARTER_CLOCKWISE) {
            this.paint(graphics, n2, n3, 1.5707963267948966);
        } else if (rotation == Rotation.QUARTER_ANTICLOCKWISE) {
            this.paint(graphics, n2, n3, -1.5707963267948966);
        } else if (rotation == Rotation.HALF) {
            this.paint(graphics, n2, n3, -Math.PI);
        } else {
            throw new RuntimeException("Unexpected value : " + (Object)((Object)rotation));
        }
    }

    public void paint(Graphics graphics, int n2, int n3, double d2) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setColor(this.getColor());
        if (d2 == 0.0) {
            this.\u0101(graphics2D, n2, n3);
        } else {
            graphics2D.translate(n2, n3);
            graphics2D.rotate(d2);
            this.\u0101(graphics2D, 0, 0);
        }
        graphics2D.dispose();
    }

    private void \u0101(Graphics2D graphics2D, int n2, int n3) {
        String string = this.getLabel();
        if (string != null && string.trim().toLowerCase().startsWith("<html")) {
            Font font = this.\u0102();
            Color color = this.\u0101();
            this.\u0110.setForeground(color);
            this.\u0110.setFont(font);
            this.\u0110.setText(string);
            Dimension dimension = this.\u0110.getPreferredSize();
            this.\u0110.setSize(dimension);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            graphics2D.translate(n2 - dimension.width / 2, n3 - fontMetrics.getAscent());
            this.\u0110.paint(graphics2D);
            graphics2D.translate(-n2 + dimension.width / 2, -n3 + fontMetrics.getAscent());
        } else if (string != null) {
            Font font = this.getFont();
            if (font == null) {
                font = graphics2D.getFont();
            } else {
                graphics2D.setFont(font);
            }
            assert (font != null) : "Font cannot be null";
            Dimension dimension = this.size(graphics2D, font);
            graphics2D.drawString(string, n2 - dimension.width / 2, n3);
        }
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.\u0112 == null ? 0 : this.\u0112.hashCode());
        n2 = 31 * n2 + (this.\u0111 == null ? 0 : this.\u0111.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractLabel abstractLabel = (AbstractLabel)object;
        if (this.\u0112 == null ? abstractLabel.\u0112 != null : !this.\u0112.equals(abstractLabel.\u0112)) {
            return false;
        }
        return !(this.\u0111 == null ? abstractLabel.\u0111 != null : !this.\u0111.equals(abstractLabel.\u0111));
    }

    public String toString() {
        return String.format("#<Label label=%s>", this.\u0112);
    }
}

