/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.util;

import java.io.UnsupportedEncodingException;

public class ProtocolUtils {
    public static final String CURRENT_PROTOCOL_VERSION = "3.12";

    public static short protocolMajorVersion(int n) {
        return (short)(n >> 16);
    }

    public static short protocolMinorVersion(int n) {
        return (short)(n & 0xFFFF);
    }

    public static int protocolStrToInt(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 1) {
            return Integer.parseInt(stringArray[0]);
        }
        return Integer.parseInt(stringArray[0]) << 16 | Integer.parseInt(stringArray[1]);
    }

    public static String protocolIntToStr(int n) {
        return ProtocolUtils.protocolMajorVersion(n) + "." + ProtocolUtils.protocolMinorVersion(n);
    }

    public static byte[] encodeUTF8(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unexpected exception: UTF-8 charset not supported: " + unsupportedEncodingException);
        }
    }
}

