/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class SettingReader {
    private static boolean m_isSuccessfulLoad;
    private static String m_loadException;
    private static Properties s_addedSettings;
    private static Map<String, Object> s_objectSettings;
    private static Properties s_settings;

    public static void clearAllSettings() {
        s_addedSettings.clear();
        s_objectSettings.clear();
    }

    public static boolean isSuccessfulLoad() {
        return m_isSuccessfulLoad;
    }

    public static void loadSettings(String propertiesFile, String propertiesLocationVariable) {
        FileInputStream inProps = null;
        try {
            File directory;
            String propertiesPath = "";
            String propsLocation = null;
            if (null != propertiesLocationVariable) {
                propsLocation = System.getenv(propertiesLocationVariable);
            }
            if (null != propsLocation && (directory = new File(propsLocation)).exists() && !(propertiesPath = directory.getCanonicalPath()).endsWith(File.separator)) {
                propertiesPath = propertiesPath + File.separator;
            }
            propertiesPath = propertiesPath + propertiesFile;
            inProps = new FileInputStream(propertiesPath);
            s_settings.load(inProps);
            inProps.close();
        }
        catch (IOException e) {
            m_isSuccessfulLoad = false;
            m_loadException = e.getLocalizedMessage();
            try {
                if (null != inProps) {
                    inProps.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            return;
        }
        Enumeration<Object> keys = s_settings.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = s_settings.getProperty(key);
            s_settings.remove(key);
            s_settings.setProperty(key.toUpperCase(Locale.ENGLISH), value);
        }
        m_isSuccessfulLoad = true;
    }

    public static void loadSimbaSettings() {
        SettingReader.loadSettings("vertica.properties", "SIMBA_PROPERTIES_DIR");
    }

    public static Object readAdditionalSetting(String key) {
        return s_objectSettings.get(key.toUpperCase(Locale.ENGLISH));
    }

    public static String readSetting(String valueName) {
        String upperValueName = valueName.toUpperCase(Locale.ENGLISH);
        String setting = s_addedSettings.getProperty(upperValueName);
        if (null == setting) {
            setting = s_settings.getProperty(upperValueName);
        }
        return setting;
    }

    public static Map<String, Object> retrieveAllAdditionalSettings() {
        return s_objectSettings;
    }

    public static Properties retrieveAllSettings() {
        return s_settings;
    }

    public static String retrieveLoadErrorMessage() {
        return m_loadException;
    }

    public static void storeAdditionalSetting(String key, Object value) {
        s_objectSettings.put(key.toUpperCase(Locale.ENGLISH), value);
    }

    public static void storeSetting(String key, String value) {
        s_addedSettings.setProperty(key.toUpperCase(Locale.ENGLISH), value);
    }

    public static void storeSettings(Properties settings) {
        Enumeration<Object> keys = settings.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            s_addedSettings.setProperty(key.toUpperCase(Locale.ENGLISH), settings.get(key).toString());
        }
    }

    static {
        try {
            s_addedSettings = new Properties();
            SettingReader.storeSetting("DriverLocale", Locale.getDefault().toString());
        }
        catch (Exception e) {
            SettingReader.storeSetting("DriverLocale", "en");
        }
        m_isSuccessfulLoad = false;
        s_objectSettings = new HashMap<String, Object>();
        s_settings = new Properties();
    }
}

