#!/bin/sh

#
# Copyright (c) DbVis Software AB. All Rights Reserved.
#

# Script to launch the DbVisualizer tool

# Function: Initializes the java version variables
init_java_version() {
  version_output=$("$JAVA_EXEC" -version 2>&1)
  is_gcj=$(expr "$version_output" : '.*gcj')
  IS_OPENJDK=$(expr "$version_output" : '.*OpenJDK')
  if [ "$is_gcj" = "0" ]; then
    java_version=$(expr "$version_output" : '.*"\(.*\)".*')
    JAVA_MAJOR_VERSION=$(expr "$java_version" : '\([0-9][0-9]*\).*')
    JAVA_MINOR_VERSION=$(expr "$java_version" : '[0-9][0-9]*\.\([0-9][0-9]*\).*')
    JAVA_MICRO_VERSION=$(expr "$java_version" : '[0-9][0-9]*\.[0-9][0-9]*\.\([0-9][0-9]*\).*')
    VER_PATCH=$(expr "$java_version" : '[0-9][0-9]*\.[0-9][0-9]*\.[0-9][0-9]*[\._]\([0-9][0-9]*\).*')
  fi

  if [ -z "$java_version" ] ; then
    echo "Unable to extract java version - is a supported JRE installed?"
    exit 1
  fi

  if [  "$JAVA_MAJOR_VERSION" -lt "11" ]; then
    echo  "Java version $java_version is not supported. At least java 11 is required."
    exit 1
  fi
}

# If JAVA_EXEC is not set check if we're on macOS and if there is a bundled
# JRE that should be used. Otherwise use java in the PATH.
init_java_exec() {
  if [ -z "$JAVA_EXEC" ] ; then
    if [ "$DBVIS_OSTYPE" = "Darwin" ]; then
      # The bundled jre may be in two different locations.
      # This is for setup installers
      JAVA_PATH="$DBVIS_HOME/../../PlugIns/jre.bundle/Contents/Home/bin/java"
      if [ -f "$JAVA_PATH" ]; then
        JAVA_EXEC="$JAVA_PATH"
      else
        # This is for archive installers
        JAVA_PATH="$DBVIS_HOME/../jre.bundle/Contents/Home/bin/java"
        if [ -f "$JAVA_PATH" ]; then
          JAVA_EXEC="$JAVA_PATH"
        fi
      fi
    fi
    if [ "$DBVIS_OSTYPE" = "Linux" ]; then
      JAVA_PATH="$DBVIS_HOME/jre/bin/java"
      if [ -f "$JAVA_PATH" ]; then
        JAVA_EXEC="$JAVA_PATH"
      fi
    fi
  fi
  # Use java in PATH
  if [ -z "$JAVA_EXEC" ] ; then
    JAVA_EXEC=java
  fi
}

set_vars() {
  if [ -z "$DBVIS_HOME" ] ; then
    DBVIS_HOME=$(dirname "$0")
  fi
  CP="$DBVIS_HOME/resources"
  CP="$CP:$DBVIS_HOME/lib/*"
  DBVIS_OSTYPE=$(uname)
}

set_vars
init_java_exec
init_java_version "$JAVA_EXEC"

# All code up to this row is the same as in dbviscmd.sh

VM_ARGS="-Xmx2048M -XX:StringTableSize=1000003 -Dsun.locale.formatasdefault=true $VM_ARGS"
MAIN_CLASS="com.onseven.dbvis.DbVisualizerGUI"
SPLASH_FILE="${DBVIS_HOME}/resources/images/ix4/dbvis-splash_dark.png";

if [ "$JAVA_MAJOR_VERSION" -ge "11" ]; then
  if [ "$DBVIS_OSTYPE" = "Darwin" ]; then
    # Java 9+ with macOS
    "$JAVA_EXEC" ${VM_ARGS} \
      @"${DBVIS_HOME}"/java9-args @"${DBVIS_HOME}"/java9-args-macos \
      -Ddbvis.home="${DBVIS_HOME}" \
      -Dapple.awt.application.appearance=system \
      -splash:"${SPLASH_FILE}" \
      -Xdock:name="DbVisualizer" \
      -Xdock:icon="${DBVIS_HOME}/resources/images/ix4/dbvis-icon.icns" \
      -cp "${CP}" \
      $MAIN_CLASS "$@"
  else
    # Java 9+ with Linux/UNIX
    "$JAVA_EXEC" ${VM_ARGS} \
      @"${DBVIS_HOME}"/java9-args @"${DBVIS_HOME}"/java9-args-linux \
      -Ddbvis.home="${DBVIS_HOME}" \
      -splash:"${SPLASH_FILE}" \
      -Dsun.java2d.xrender=false \
      -cp "${CP}" \
      $MAIN_CLASS "$@"
  fi
else
  printf "Error: At least Java 11 is required. Below is the version currently being used:\n"
  "$JAVA_EXEC" -version
  exit 2
fi

