/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.chart.annotation.Annotation;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartModelChangeEvent;
import com.jidesoft.chart.model.ChartModelChangeListener;
import com.jidesoft.chart.model.ChartModelChangeType;
import com.jidesoft.chart.model.ChartModelListener;
import com.jidesoft.chart.model.ChartPoint;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.RangeProvider;
import com.jidesoft.chart.util.ChartUtils;
import com.jidesoft.range.Category;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Positionable;
import com.jidesoft.range.Range;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DefaultChartModel
implements AnnotatedChartModel,
RangeProvider,
Comparable<ChartModel> {
    private final ReadWriteLock \u01ac = new ReentrantReadWriteLock();
    private final Lock \u019f = this.\u01ac.readLock();
    private final Lock \u01a7 = this.\u01ac.writeLock();
    private static volatile int \u01a1;
    private Object \u01ad;
    private List<Chartable> \u01aa = new ArrayList<Chartable>();
    private Range<Double> \u01a6 = null;
    private Range<Double> \u01a9 = null;
    private List<Annotation> \u019d = new ArrayList<Annotation>();
    private CopyOnWriteArrayList<ChartModelListener> \u01a8 = new CopyOnWriteArrayList();
    private double \u01a2 = 0.0;
    private double \u019e = 0.0;
    private double \u01a4 = 0.0;
    private double \u01a5 = 0.0;
    private boolean \u01a3 = true;
    private boolean \u01ae;
    private boolean \u01a0 = false;

    public DefaultChartModel() {
        this(String.format("%d", ++\u01a1));
    }

    public DefaultChartModel(DefaultChartModel defaultChartModel) {
        this.\u01ad = defaultChartModel.\u01ad;
        this.\u01aa = new ArrayList<Chartable>(defaultChartModel.\u01aa);
        this.\u019d = new ArrayList<Annotation>(defaultChartModel.\u019d);
        this.\u01a2 = defaultChartModel.\u01a2;
        this.\u019e = defaultChartModel.\u019e;
        this.\u01a4 = defaultChartModel.\u01a4;
        this.\u01a5 = defaultChartModel.\u01a5;
        this.\u01ae = defaultChartModel.\u01ae;
    }

    public DefaultChartModel(Object object) {
        this.\u01ad = object;
    }

    @Override
    public String getName() {
        return this.\u01ad == null ? String.format("<DefaultChartModel @%X>", System.identityHashCode(this)) : this.\u01ad.toString();
    }

    public Object getKey() {
        return this.\u01ad;
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException("Cannot set the name of a ChartModel to null");
        }
        this.\u01ad = string;
    }

    public boolean isFiringEventsOnEDT() {
        return this.\u01a0;
    }

    public void setFiringEventsOnEDT(boolean bl) {
        this.\u01a0 = bl;
    }

    @Override
    public Chartable getPoint(int n2) {
        this.\u019f.lock();
        try {
            Chartable chartable = this.\u01aa.get(n2);
            return chartable;
        }
        finally {
            this.\u019f.unlock();
        }
    }

    public void clearPoints() {
        this.\u01a7.lock();
        try {
            this.\u01aa.clear();
            this.\u01a6 = null;
            this.\u01a9 = null;
        }
        finally {
            this.\u01a7.unlock();
        }
        this.fireModelChanged();
    }

    public void clearAnnotations() {
        this.\u01a7.lock();
        try {
            this.\u019d.clear();
        }
        finally {
            this.\u01a7.unlock();
        }
        this.fireModelChanged();
    }

    @Override
    public int getPointCount() {
        this.\u019f.lock();
        try {
            int n2 = this.\u01aa.size();
            return n2;
        }
        finally {
            this.\u019f.unlock();
        }
    }

    public DefaultChartModel addPoint(Chartable chartable) {
        return this.addPoint(chartable, true);
    }

    public DefaultChartModel addPoint(int n2, int n3) {
        return this.addPoint(new ChartPoint((double)n2, (double)n3), true);
    }

    public DefaultChartModel addPoint(int n2, double d2) {
        return this.addPoint(new ChartPoint((double)n2, d2), true);
    }

    public DefaultChartModel addPoint(double d2, int n2) {
        return this.addPoint(new ChartPoint(d2, (double)n2), true);
    }

    public DefaultChartModel addPoint(double d2, double d3) {
        return this.addPoint(new ChartPoint(d2, d3), true);
    }

    public DefaultChartModel addPoint(Positionable positionable, Positionable positionable2) {
        return this.addPoint(new ChartPoint(positionable, positionable2), true);
    }

    public DefaultChartModel addPoint(double d2, Positionable positionable) {
        return this.addPoint(new ChartPoint(d2, positionable), true);
    }

    public DefaultChartModel addPoint(Positionable positionable, double d2) {
        return this.addPoint(new ChartPoint(positionable, d2), true);
    }

    public DefaultChartModel addPoint(double d2, double d3, boolean bl) {
        this.addPoint(new ChartPoint(d2, d3), bl);
        return this;
    }

    public DefaultChartModel addPoint(Positionable positionable, Positionable positionable2, boolean bl) {
        this.addPoint(new ChartPoint(positionable, positionable2), bl);
        return this;
    }

    public DefaultChartModel addPoint(double d2, Positionable positionable, boolean bl) {
        this.addPoint(new ChartPoint(d2, positionable), bl);
        return this;
    }

    public DefaultChartModel addPoint(Positionable positionable, double d2, boolean bl) {
        this.addPoint(new ChartPoint(positionable, d2), bl);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultChartModel addPoint(Chartable chartable, boolean bl) {
        this.\u01a7.lock();
        try {
            int n2 = this.\u01aa.size();
            DefaultChartModel defaultChartModel = this.addPoint(n2, chartable, bl);
            return defaultChartModel;
        }
        finally {
            this.\u01a7.unlock();
        }
    }

    public DefaultChartModel addPoint(int n2, Chartable chartable) {
        return this.addPoint(n2, chartable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultChartModel addPoint(int n2, Chartable chartable, boolean bl) {
        ChartUtils.assertEDT();
        if (chartable == null) {
            throw new IllegalArgumentException("Cannot add a null point to the model");
        }
        Positionable positionable = chartable.getX();
        Positionable positionable2 = chartable.getY();
        this.\u01a7.lock();
        try {
            this.\u01aa.add(n2, chartable);
            if (positionable != null) {
                if (this.\u01a6 == null) {
                    if (positionable instanceof Category && ((Category)positionable).getRange() == null) {
                        this.\u01a6 = null;
                    } else if (!Double.isNaN(positionable.position())) {
                        this.\u01a6 = new NumericRange(positionable.position(), positionable.position());
                    }
                } else if (positionable.position() > this.\u01a6.maximum()) {
                    if (!Double.isNaN(positionable.position())) {
                        this.\u01a6 = new NumericRange(this.\u01a6.minimum(), positionable.position());
                    }
                } else if (positionable.position() < this.\u01a6.minimum() && !Double.isNaN(positionable.position())) {
                    this.\u01a6 = new NumericRange(positionable.position(), this.\u01a6.maximum());
                }
            }
            if (positionable2 != null) {
                if (this.\u01a9 == null) {
                    if (positionable2 instanceof Category && ((Category)positionable2).getRange() == null) {
                        this.\u01a9 = null;
                    } else if (!Double.isNaN(positionable2.position())) {
                        this.\u01a9 = new NumericRange(positionable2.position(), positionable2.position());
                    }
                } else if (positionable2.position() > this.\u01a9.maximum()) {
                    if (!Double.isNaN(positionable2.position())) {
                        this.\u01a9 = new NumericRange(this.\u01a9.minimum(), positionable2.position());
                    }
                } else if (positionable2.position() < this.\u01a9.minimum() && !Double.isNaN(positionable2.position())) {
                    this.\u01a9 = new NumericRange(positionable2.position(), this.\u01a9.maximum());
                }
            }
        }
        finally {
            this.\u01a7.unlock();
        }
        if (bl) {
            ChartModelChangeEvent chartModelChangeEvent = new ChartModelChangeEvent(this, ChartModelChangeType.INSERT, n2, 1);
            this.fireModelChanged(chartModelChangeEvent);
        }
        return this;
    }

    public DefaultChartModel replacePoint(int n2, Chartable chartable) {
        return this.replacePoint(n2, chartable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultChartModel replacePoint(int n2, Chartable chartable, boolean bl) {
        this.\u01a7.lock();
        try {
            this.\u01aa.set(n2, chartable);
            this.\u01a6 = null;
            this.\u01a9 = null;
        }
        finally {
            this.\u01a7.unlock();
        }
        if (bl) {
            ChartModelChangeEvent chartModelChangeEvent = new ChartModelChangeEvent(this, ChartModelChangeType.MODIFY, n2, 1);
            this.fireModelChanged(chartModelChangeEvent);
        }
        return this;
    }

    public DefaultChartModel removePoint(int n2) {
        return this.removePoint(n2, true);
    }

    public DefaultChartModel removePoint(int n2, boolean bl) {
        this.\u01a7.lock();
        try {
            this.\u01aa.remove(n2);
            this.\u01a6 = null;
            this.\u01a9 = null;
        }
        finally {
            this.\u01a7.unlock();
        }
        if (bl) {
            ChartModelChangeEvent chartModelChangeEvent = new ChartModelChangeEvent(this, ChartModelChangeType.REMOVE, n2, 1);
            this.fireModelChanged(chartModelChangeEvent);
        }
        return this;
    }

    public DefaultChartModel removePoint(Chartable chartable) {
        return this.removePoint(chartable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultChartModel removePoint(Chartable chartable, boolean bl) {
        this.\u01a7.lock();
        try {
            int n2 = this.\u01aa.indexOf(chartable);
            DefaultChartModel defaultChartModel = this.removePoint(n2, bl);
            return defaultChartModel;
        }
        finally {
            this.\u01a7.unlock();
        }
    }

    @Override
    public int getAnnotationCount() {
        this.\u019f.lock();
        try {
            int n2 = this.\u019d.size();
            return n2;
        }
        finally {
            this.\u019f.unlock();
        }
    }

    @Override
    public Annotation getAnnotation(int n2) {
        this.\u019f.lock();
        try {
            Annotation annotation = this.\u019d.get(n2);
            return annotation;
        }
        finally {
            this.\u019f.unlock();
        }
    }

    public void addAnnotation(Annotation annotation) {
        this.\u01a7.lock();
        try {
            this.\u019d.add(annotation);
        }
        finally {
            this.\u01a7.unlock();
        }
        this.fireModelChanged();
    }

    public void removeAnnotation(Annotation annotation) {
        this.\u01a7.lock();
        try {
            this.\u019d.remove(annotation);
        }
        finally {
            this.\u01a7.unlock();
        }
    }

    public double getXLeadingMarginProportion() {
        return this.\u01a2;
    }

    public void setXLeadingMarginProportion(double d2) {
        assert (0.0 <= d2);
        assert (1.0 >= d2);
        this.\u01a2 = d2;
    }

    public double getYLeadingMarginProportion() {
        return this.\u019e;
    }

    public void setYLeadingMarginProportion(double d2) {
        assert (0.0 <= d2);
        assert (1.0 >= d2);
        this.\u019e = d2;
    }

    public double getXTrailingMarginProportion() {
        return this.\u01a4;
    }

    public void setXTrailingMarginProportion(double d2) {
        assert (0.0 <= d2);
        assert (1.0 >= d2);
        this.\u01a4 = d2;
    }

    public double getYTrailingMarginProportion() {
        return this.\u01a5;
    }

    public void setYTrailingMarginProportion(double d2) {
        assert (0.0 <= d2);
        assert (1.0 >= d2);
        this.\u01a5 = d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Range<Double> getXRange() {
        if (this.\u01a6 != null) {
            return this.\u01a6;
        }
        this.\u019f.lock();
        try {
            if (this.getPointCount() > 0) {
                Double d2 = Double.POSITIVE_INFINITY;
                Double d3 = Double.NEGATIVE_INFINITY;
                for (Chartable chartable : this.\u01aa) {
                    Positionable positionable = chartable.getX();
                    if (positionable == null) continue;
                    double d4 = positionable.position();
                    if (d2 == null || d4 < d2) {
                        d2 = d4;
                    }
                    if (d3 != null && !(d4 > d3)) continue;
                    d3 = d4;
                }
                this.\u01a6 = new NumericRange(d2, d3);
                Range<Double> range = this.\u01a6;
                return range;
            }
            Range<Double> range = null;
            return range;
        }
        finally {
            this.\u019f.unlock();
        }
    }

    public Range<Double> getXRange(double d2, double d3) {
        Range<Double> range = this.getXRange();
        double d4 = range == null ? Double.POSITIVE_INFINITY : range.maximum();
        double d5 = range == null ? Double.NEGATIVE_INFINITY : range.minimum();
        double d6 = Math.abs(d4 - d5);
        double d7 = d2 * d6;
        double d8 = d3 * d6;
        return new NumericRange(d5 - d7, d4 + d8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Range<Double> getYRange() {
        if (this.\u01a9 != null) {
            return this.\u01a9;
        }
        this.\u019f.lock();
        try {
            if (this.getPointCount() > 0) {
                Double d2 = Double.POSITIVE_INFINITY;
                Double d3 = Double.NEGATIVE_INFINITY;
                for (Chartable chartable : this.\u01aa) {
                    Positionable positionable = chartable.getY();
                    if (positionable == null) continue;
                    double d4 = positionable.position();
                    if (d2 == null || d4 < d2) {
                        d2 = d4;
                    }
                    if (d3 != null && !(d4 > d3)) continue;
                    d3 = d4;
                }
                this.\u01a9 = new NumericRange(d2, d3);
                Range<Double> range = this.\u01a9;
                return range;
            }
            Range<Double> range = null;
            return range;
        }
        finally {
            this.\u019f.unlock();
        }
    }

    public Range<Double> getYRange(double d2, double d3) {
        Range<Double> range = this.getYRange();
        double d4 = range == null ? Double.POSITIVE_INFINITY : range.maximum();
        double d5 = range == null ? Double.NEGATIVE_INFINITY : range.minimum();
        double d6 = Math.abs(d4 - d5);
        double d7 = d2 * d6;
        double d8 = d3 * d6;
        return new NumericRange(d5 - d7, d4 + d8);
    }

    @Override
    public boolean isAnnotationsVisible() {
        this.\u019f.lock();
        try {
            boolean bl = this.\u01a3;
            return bl;
        }
        finally {
            this.\u019f.unlock();
        }
    }

    @Override
    public void setAnnotationsVisible(boolean bl) {
        this.\u01a7.lock();
        try {
            this.\u01a3 = bl;
        }
        finally {
            this.\u01a7.unlock();
        }
        this.fireModelChanged();
    }

    @Override
    public void addChartModelListener(ChartModelListener chartModelListener) {
        this.\u01a8.add(chartModelListener);
    }

    @Override
    public void removeChartModelListener(ChartModelListener chartModelListener) {
        this.\u01a8.remove(chartModelListener);
    }

    @Override
    public Iterator<Chartable> iterator() {
        return this.\u01aa.iterator();
    }

    @Override
    public boolean isCyclical() {
        this.\u019f.lock();
        try {
            boolean bl = this.\u01ae;
            return bl;
        }
        finally {
            this.\u019f.unlock();
        }
    }

    public void setCyclical(boolean bl) {
        this.\u01a7.lock();
        try {
            this.\u01ae = bl;
        }
        finally {
            this.\u01a7.unlock();
        }
    }

    public void update() {
        this.fireModelChanged();
    }

    protected void fireModelChanged(final ChartModelChangeEvent chartModelChangeEvent) {
        if (this.\u01a0) {
            ChartUtils.runOnEdt(new Runnable(){

                @Override
                public void run() {
                    for (ChartModelListener chartModelListener : DefaultChartModel.this.\u01a8) {
                        if (chartModelListener instanceof ChartModelChangeListener) {
                            ((ChartModelChangeListener)chartModelListener).chartModelChanged(chartModelChangeEvent);
                            continue;
                        }
                        if (chartModelListener == null) continue;
                        chartModelListener.chartModelChanged();
                    }
                }
            });
        } else {
            for (ChartModelListener chartModelListener : this.\u01a8) {
                if (chartModelListener instanceof ChartModelChangeListener) {
                    ((ChartModelChangeListener)chartModelListener).chartModelChanged(chartModelChangeEvent);
                    continue;
                }
                if (chartModelListener == null) continue;
                chartModelListener.chartModelChanged();
            }
        }
    }

    protected void fireModelChanged() {
        if (this.\u01a0) {
            ChartUtils.runOnEdt(new Runnable(){

                @Override
                public void run() {
                    for (ChartModelListener chartModelListener : DefaultChartModel.this.\u01a8) {
                        chartModelListener.chartModelChanged();
                    }
                }
            });
        } else {
            for (ChartModelListener chartModelListener : this.\u01a8) {
                chartModelListener.chartModelChanged();
            }
        }
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DefaultChartModel) {
            DefaultChartModel defaultChartModel = (DefaultChartModel)object;
            String string = this.getName();
            return string.equals(defaultChartModel.getName());
        }
        return false;
    }

    @Override
    public int compareTo(ChartModel chartModel) {
        String string = chartModel.getName();
        String string2 = this.getName();
        return string2.compareTo(string);
    }

    public String toString() {
        return String.format("#<DefaultChartModel name='%s'>", this.getName());
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4096)) {
            Lm.showInvalidProductMessage(DefaultChartModel.class.getName(), 4096);
        }
        \u01a1 = 0;
    }
}

