/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc42;

import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.interfaces.IResults;
import com.vertica.dsi.dataengine.utilities.ExecutionResult;
import com.vertica.dsi.dataengine.utilities.ExecutionResultType;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SForwardResultSet;
import com.vertica.jdbc.common.SPreparedStatement;
import com.vertica.jdbc.common.SResultSetMetaData;
import com.vertica.jdbc.common.SStatement;
import com.vertica.jdbc.jdbc41.S41PreparedStatement;
import com.vertica.jdbc.jdbc42.S42ForwardResultSet;
import com.vertica.jdbc.jdbc42.S42ParameterMetaData;
import com.vertica.jdbc.jdbc42.S42ResultSetMetaData;
import com.vertica.jdbc.jdbc42.S42UpdatableForwardResultSet;
import com.vertica.jdbc.jdbc42.utilities.CustomSqlTypes;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.utilities.JDBCVersion;
import java.sql.BatchUpdateException;
import java.sql.JDBCType;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.Iterator;

public class S42PreparedStatement
extends S41PreparedStatement {
    private long m_longTotal = Long.MAX_VALUE;

    public S42PreparedStatement(String sql, IStatement statement, SConnection conn, int concurrency) throws SQLException {
        super(sql, statement, conn, concurrency);
        this.m_jdbcVersion = JDBCVersion.JDBC42;
    }

    @Override
    protected ResultSet createResultSet(IResultSet internalResultSet, boolean updatable, int fetchSize) throws SQLException {
        SForwardResultSet resultSet = updatable ? new S42UpdatableForwardResultSet(this, internalResultSet, this.getLogger()) : new S42ForwardResultSet(this, internalResultSet, this.getLogger());
        resultSet.setFetchSize(fetchSize);
        return resultSet;
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getResultSetMetaData()) {
                IResults execResults = this.getQueryExecutor().getResults();
                Iterator<ExecutionResult> itr = execResults.getResultItr();
                if (!itr.hasNext()) {
                    return null;
                }
                ExecutionResult execResult = itr.next();
                if (ExecutionResultType.RESULT_SET == execResult.getType()) {
                    IResultSet result = (IResultSet)execResult.getResult();
                    this.setResultSetMetadata(this.createResultSetMetaData(result));
                }
            }
            return this.getResultSetMetaData();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    protected SResultSetMetaData createResultSetMetaData(IResultSet internalResultSet) throws SQLException {
        try {
            ArrayList<? extends IColumn> metadataColumns = internalResultSet.getSelectColumns();
            if (null == metadataColumns) {
                return null;
            }
            return new S42ResultSetMetaData(metadataColumns, this.getLogger(), this.getWarningListener());
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getOpenParamMetaData()) {
                S42ParameterMetaData parameterMetadata = null;
                parameterMetadata = new S42ParameterMetaData(this.getParameterMetadataList(), this.getLogger(), this.getWarningListener());
                this.setOpenParamMetaData(parameterMetadata);
            }
            return this.getOpenParamMetaData();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object value, SQLType targetSqlType) throws SQLException {
        if (!(targetSqlType instanceof JDBCType) && !(targetSqlType instanceof CustomSqlTypes)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        int targetSType = targetSqlType.getVendorTypeNumber();
        this.setObject(parameterIndex, value, targetSType);
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object value, SQLType targetSqlType, int scale) throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), parameterIndex, value, targetSqlType, scale);
        if (!(targetSqlType instanceof JDBCType) && !(targetSqlType instanceof CustomSqlTypes)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        int targetSType = targetSqlType.getVendorTypeNumber();
        this.setObject(parameterIndex, value, targetSType, scale);
    }

    @Override
    public synchronized long[] executeLargeBatch() throws SQLException, BatchUpdateException {
        try {
            SPreparedStatement.BatchExecResult result = this.executePreparedAnyBatch();
            switch (result) {
                case BATCH_EXEC_NO_BATCHES: {
                    return new long[0];
                }
                case BATCH_EXEC_SUCCEEDED: {
                    return this.processLargeBatchResults(this.m_queryExecutor.getResults(), this.getBatchParamConversionErrors(), SStatement.BatchType.MULTI_PARAM_SET);
                }
                case BATCH_EXEC_ALL_FAILED_INPUT_CONVERSION: {
                    return this.processLargeBatchResults(null, this.getBatchParamConversionErrors(), SStatement.BatchType.MULTI_PARAM_SET);
                }
            }
            throw new RuntimeException("Invalid enum value: " + result.name());
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate() throws SQLException {
        return this.executeAnyUpdate();
    }

    @Override
    public synchronized long executeLargeUpdate(String sql) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql, autoGeneratedKeys);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql, columnIndexes);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql, columnNames);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long getLargeUpdateCount() throws SQLException {
        return this.getAnyUpdateCount();
    }

    @Override
    public synchronized long getLargeMaxRows() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_statement.getProperty(2).getLong();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setLargeMaxRows(long max) throws SQLException {
        this.setAnyMaxRows(max);
    }
}

