/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc;

import com.vertica.core.VConnection;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.jdbc.VerticaJdbc41ConnectionHandle;
import com.vertica.jdbc.VerticaJdbc41ConnectionImpl;
import com.vertica.jdbc.VerticaJdbc41PreparedStatementImpl;
import com.vertica.jdbc.VerticaJdbc41StatementImpl;
import com.vertica.jdbc.VerticaJdbc42ConnectionHandle;
import com.vertica.jdbc.VerticaJdbc42ConnectionImpl;
import com.vertica.jdbc.VerticaJdbc42PreparedStatementImpl;
import com.vertica.jdbc.VerticaJdbc42StatementImpl;
import com.vertica.jdbc.VerticaJdbc4ConnectionHandle;
import com.vertica.jdbc.VerticaJdbc4ConnectionImpl;
import com.vertica.jdbc.VerticaJdbc4PreparedStatementImpl;
import com.vertica.jdbc.VerticaJdbc4StatementImpl;
import com.vertica.jdbc.common.SCallableStatement;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SConnectionHandle;
import com.vertica.jdbc.common.SPooledConnection;
import com.vertica.jdbc.common.SPreparedStatement;
import com.vertica.jdbc.common.SStatement;
import com.vertica.jdbc.hybrid.HybridJDBCObjectFactory;
import com.vertica.jdbc.jdbc4.S4Connection;
import com.vertica.jdbc.jdbc41.S41Connection;
import com.vertica.jdbc.jdbc42.S42Connection;
import com.vertica.jdbc.kv.VerticaJdbc41RoutableConnectionImpl;
import com.vertica.jdbc.kv.VerticaJdbc42RoutableConnectionImpl;
import com.vertica.jdbc.kv.VerticaJdbc4RoutableConnectionImpl;
import com.vertica.utilities.JDBCVersion;
import java.sql.SQLException;
import javax.sql.PooledConnection;

final class VJDBCObjectFactory
extends HybridJDBCObjectFactory {
    private final JDBCVersion m_JDBCVersion;

    protected VJDBCObjectFactory(JDBCVersion jDBCVersion) {
        super(jDBCVersion);
        this.m_JDBCVersion = jDBCVersion;
    }

    @Override
    protected SCallableStatement createCallableStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        return super.createCallableStatement(string, iStatement, sConnection, n);
    }

    @Override
    protected SConnection createConnection(IConnection iConnection, String string) throws SQLException {
        boolean bl = ((VConnection)iConnection).getEnableRoutableQueries();
        SConnection sConnection = null;
        switch (this.m_JDBCVersion) {
            case JDBC4: {
                sConnection = bl ? new VerticaJdbc4RoutableConnectionImpl(iConnection, string) : new VerticaJdbc4ConnectionImpl(iConnection, string);
                break;
            }
            case JDBC41: {
                sConnection = bl ? new VerticaJdbc41RoutableConnectionImpl(iConnection, string) : new VerticaJdbc41ConnectionImpl(iConnection, string);
                break;
            }
            case JDBC42: {
                sConnection = bl ? new VerticaJdbc42RoutableConnectionImpl(iConnection, string) : new VerticaJdbc42ConnectionImpl(iConnection, string);
                break;
            }
            default: {
                sConnection = bl ? new VerticaJdbc42RoutableConnectionImpl(iConnection, string) : new VerticaJdbc42ConnectionImpl(iConnection, string);
            }
        }
        return sConnection;
    }

    @Override
    protected SPreparedStatement createPreparedStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        SPreparedStatement sPreparedStatement = null;
        switch (this.m_JDBCVersion) {
            case JDBC4: {
                sPreparedStatement = new VerticaJdbc4PreparedStatementImpl(string, iStatement, (S4Connection)sConnection, n);
                break;
            }
            case JDBC41: {
                sPreparedStatement = new VerticaJdbc41PreparedStatementImpl(string, iStatement, (S41Connection)sConnection, n);
                break;
            }
            case JDBC42: {
                sPreparedStatement = new VerticaJdbc42PreparedStatementImpl(string, iStatement, (S42Connection)sConnection, n);
            }
        }
        return sPreparedStatement;
    }

    @Override
    protected SStatement createStatement(IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        SStatement sStatement = null;
        switch (this.m_JDBCVersion) {
            case JDBC4: {
                sStatement = new VerticaJdbc4StatementImpl(iStatement, (S4Connection)sConnection, n);
                break;
            }
            case JDBC41: {
                sStatement = new VerticaJdbc41StatementImpl(iStatement, (S41Connection)sConnection, n);
                break;
            }
            case JDBC42: {
                sStatement = new VerticaJdbc42StatementImpl(iStatement, (S42Connection)sConnection, n);
                break;
            }
            default: {
                sStatement = new VerticaJdbc42StatementImpl(iStatement, (S42Connection)sConnection, n);
            }
        }
        return sStatement;
    }

    @Override
    protected PooledConnection createPooledConnection(SConnection sConnection) throws SQLException {
        return super.createPooledConnection(sConnection);
    }

    @Override
    protected SConnectionHandle createConnectionHandle(SConnection sConnection, SPooledConnection sPooledConnection) throws SQLException {
        SConnectionHandle sConnectionHandle = null;
        switch (this.m_JDBCVersion) {
            case JDBC4: {
                sConnectionHandle = new VerticaJdbc4ConnectionHandle(sConnection, sPooledConnection);
                break;
            }
            case JDBC41: {
                sConnectionHandle = new VerticaJdbc41ConnectionHandle(sConnection, sPooledConnection);
                break;
            }
            case JDBC42: {
                sConnectionHandle = new VerticaJdbc42ConnectionHandle(sConnection, sPooledConnection);
                break;
            }
            default: {
                sConnectionHandle = new VerticaJdbc42ConnectionHandle(sConnection, sPooledConnection);
            }
        }
        return sConnectionHandle;
    }
}

